// Copyright (c) 2006 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef maxq7654_h
#define maxq7654_h

sfrb AP = 0x8;

sfrb APC = 0x18;
#define APC_MOD_MASK 0x7
#define APC_MOD_BIT 0
#define APC_IDS_MASK 0x40
#define APC_IDS 0x40
#define APC_IDS_BIT 6
#define APC_CLR_MASK 0x80
#define APC_CLR 0x80
#define APC_CLR_BIT 7

sfrb PSF = 0x48;
#define PSF_E_MASK 0x1
#define PSF_E 0x1
#define PSF_E_BIT 0
#define PSF_C_MASK 0x2
#define PSF_C 0x2
#define PSF_C_BIT 1
#define PSF_OV_MASK 0x4
#define PSF_OV 0x4
#define PSF_OV_BIT 2
#define PSF_GPF0_MASK 0x8
#define PSF_GPF0 0x8
#define PSF_GPF0_BIT 3
#define PSF_GPF1_MASK 0x10
#define PSF_GPF1 0x10
#define PSF_GPF1_BIT 4
#define PSF_S_MASK 0x40
#define PSF_S 0x40
#define PSF_S_BIT 6
#define PSF_Z_MASK 0x80
#define PSF_Z 0x80
#define PSF_Z_BIT 7

sfrb IC = 0x58;
#define IC_IGE_MASK 0x1
#define IC_IGE 0x1
#define IC_IGE_BIT 0
#define IC_INS_MASK 0x2
#define IC_INS 0x2
#define IC_INS_BIT 1
#define IC_CGDS_MASK 0x20
#define IC_CGDS 0x20
#define IC_CGDS_BIT 5

sfrb IMR = 0x68;
#define IMR_IM0_MASK 0x1
#define IMR_IM0 0x1
#define IMR_IM0_BIT 0
#define IMR_IM1_MASK 0x2
#define IMR_IM1 0x2
#define IMR_IM1_BIT 1
#define IMR_IM2_MASK 0x4
#define IMR_IM2 0x4
#define IMR_IM2_BIT 2
#define IMR_IM3_MASK 0x8
#define IMR_IM3 0x8
#define IMR_IM3_BIT 3
#define IMR_IM4_MASK 0x10
#define IMR_IM4 0x10
#define IMR_IM4_BIT 4
#define IMR_IM5_MASK 0x20
#define IMR_IM5 0x20
#define IMR_IM5_BIT 5
#define IMR_IMS_MASK 0x80
#define IMR_IMS 0x80
#define IMR_IMS_BIT 7

sfrb SC = 0x88;
#define SC_PWL_MASK 0x2
#define SC_PWL 0x2
#define SC_PWL_BIT 1
#define SC_ROD_MASK 0x4
#define SC_ROD 0x4
#define SC_ROD_BIT 2
#define SC_UPA_MASK 0x8
#define SC_UPA 0x8
#define SC_UPA_BIT 3
#define SC_CDA_MASK 0x30
#define SC_CDA_BIT 4
#define SC_TAP_MASK 0x180
#define SC_TAP_BIT 7

sfrb IIR = 0xb8;
#define IIR_II0_MASK 0x1
#define IIR_II0 0x1
#define IIR_II0_BIT 0
#define IIR_II1_MASK 0x2
#define IIR_II1 0x2
#define IIR_II1_BIT 1
#define IIR_II2_MASK 0x4
#define IIR_II2 0x4
#define IIR_II2_BIT 2
#define IIR_II3_MASK 0x8
#define IIR_II3 0x8
#define IIR_II3_BIT 3
#define IIR_II4_MASK 0x10
#define IIR_II4 0x10
#define IIR_II4_BIT 4
#define IIR_II5_MASK 0x20
#define IIR_II5 0x20
#define IIR_II5_BIT 5
#define IIR_IIS_MASK 0x80
#define IIR_IIS 0x80
#define IIR_IIS_BIT 7

sfrb CKCN = 0xe8;
#define CKCN_CD_MASK 0x3
#define CKCN_CD_BIT 0
#define CKCN_PMME_MASK 0x4
#define CKCN_PMME 0x4
#define CKCN_PMME_BIT 2
#define CKCN_SWB_MASK 0x8
#define CKCN_SWB 0x8
#define CKCN_SWB_BIT 3
#define CKCN_STOP_MASK 0x10
#define CKCN_STOP 0x10
#define CKCN_STOP_BIT 4
#define CKCN_RGMD_MASK 0x20
#define CKCN_RGMD 0x20
#define CKCN_RGMD_BIT 5
#define CKCN_RGSL_MASK 0x40
#define CKCN_RGSL 0x40
#define CKCN_RGSL_BIT 6
#define CKCN_XT_NOT_RC_MASK 0x80
#define CKCN_XT_NOT_RC 0x80
#define CKCN_XT_NOT_RC_BIT 7

sfrb WDCN = 0xf8;
#define WDCN_RWT_MASK 0x1
#define WDCN_RWT 0x1
#define WDCN_RWT_BIT 0
#define WDCN_EWT_MASK 0x2
#define WDCN_EWT 0x2
#define WDCN_EWT_BIT 1
#define WDCN_WTRF_MASK 0x4
#define WDCN_WTRF 0x4
#define WDCN_WTRF_BIT 2
#define WDCN_WDIF_MASK 0x8
#define WDCN_WDIF 0x8
#define WDCN_WDIF_BIT 3
#define WDCN_WD_MASK 0x30
#define WDCN_WD_BIT 4
#define WDCN_EWDI_MASK 0x40
#define WDCN_EWDI 0x40
#define WDCN_EWDI_BIT 6
#define WDCN_POR_MASK 0x80
#define WDCN_POR 0x80
#define WDCN_POR_BIT 7

sfrw A_0 = 0x9;

sfrw A_1 = 0x19;

sfrw A_2 = 0x29;

sfrw A_3 = 0x39;

sfrw A_4 = 0x49;

sfrw A_5 = 0x59;

sfrw A_6 = 0x69;

sfrw A_7 = 0x79;

sfrw A_8 = 0x89;

sfrw A_9 = 0x99;

sfrw A_10 = 0xa9;

sfrw A_11 = 0xb9;

sfrw A_12 = 0xc9;

sfrw A_13 = 0xd9;

sfrw A_14 = 0xe9;

sfrw A_15 = 0xf9;

sfrw PFX_0 = 0xb;

sfrw IP = 0xc;

sfrw SP = 0x1d;

sfrw IV = 0x2d;

sfrw LC_0 = 0x6d;

sfrw LC_1 = 0x7d;

sfrb OFFS = 0x3e;

sfrw DPC = 0x4e;
#define DPC_SDPS_MASK 0x3
#define DPC_SDPS_BIT 0
#define DPC_WBSO_MASK 0x4
#define DPC_WBSO 0x4
#define DPC_WBSO_BIT 2
#define DPC_WBS1_MASK 0x8
#define DPC_WBS1 0x8
#define DPC_WBS1_BIT 3
#define DPC_WBS2_MASK 0x10
#define DPC_WBS2 0x10
#define DPC_WBS2_BIT 4

sfrw GR = 0x5e;

sfrb GRL = 0x6e;

sfrw BP = 0x7e;

sfrw GRS = 0x8e;

sfrb GRH = 0x9e;

sfrw GRXL = 0xae;

sfrw FP = 0xbe;

sfrw DP_0 = 0x3f;

sfrw DP_1 = 0x7f;

sfrb PO0 = 0x0;

sfrb PO1 = 0x10;

sfrb PO2 = 0x20;

sfrb EIF0 = 0x30;
#define EIF0_IE0_MASK 0x1
#define EIF0_IE0 0x1
#define EIF0_IE0_BIT 0
#define EIF0_IE1_MASK 0x2
#define EIF0_IE1 0x2
#define EIF0_IE1_BIT 1
#define EIF0_IE2_MASK 0x4
#define EIF0_IE2 0x4
#define EIF0_IE2_BIT 2
#define EIF0_IE3_MASK 0x8
#define EIF0_IE3 0x8
#define EIF0_IE3_BIT 3
#define EIF0_IE4_MASK 0x10
#define EIF0_IE4 0x10
#define EIF0_IE4_BIT 4
#define EIF0_IE5_MASK 0x20
#define EIF0_IE5 0x20
#define EIF0_IE5_BIT 5

sfrb EIF1 = 0x40;
#define EIF1_IE0_MASK 0x1
#define EIF1_IE0 0x1
#define EIF1_IE0_BIT 0
#define EIF1_IE1_MASK 0x2
#define EIF1_IE1 0x2
#define EIF1_IE1_BIT 1
#define EIF1_IE2_MASK 0x4
#define EIF1_IE2 0x4
#define EIF1_IE2_BIT 2
#define EIF1_IE3_MASK 0x8
#define EIF1_IE3 0x8
#define EIF1_IE3_BIT 3
#define EIF1_IE4_MASK 0x10
#define EIF1_IE4 0x10
#define EIF1_IE4_BIT 4
#define EIF1_IE5_MASK 0x20
#define EIF1_IE5 0x20
#define EIF1_IE5_BIT 5
#define EIF1_IE6_MASK 0x40
#define EIF1_IE6 0x40
#define EIF1_IE6_BIT 6
#define EIF1_IE7_MASK 0x80
#define EIF1_IE7 0x80
#define EIF1_IE7_BIT 7

sfrb EIF2 = 0x50;
#define EIF2_IE0_MASK 0x1
#define EIF2_IE0 0x1
#define EIF2_IE0_BIT 0
#define EIF2_IE1_MASK 0x2
#define EIF2_IE1 0x2
#define EIF2_IE1_BIT 1
#define EIF2_IE2_MASK 0x4
#define EIF2_IE2 0x4
#define EIF2_IE2_BIT 2
#define EIF2_IE3_MASK 0x8
#define EIF2_IE3 0x8
#define EIF2_IE3_BIT 3
#define EIF2_IE4_MASK 0x10
#define EIF2_IE4 0x10
#define EIF2_IE4_BIT 4
#define EIF2_IE5_MASK 0x20
#define EIF2_IE5 0x20
#define EIF2_IE5_BIT 5
#define EIF2_IE6_MASK 0x40
#define EIF2_IE6 0x40
#define EIF2_IE6_BIT 6
#define EIF2_IE7_MASK 0x80
#define EIF2_IE7 0x80
#define EIF2_IE7_BIT 7

sfrb PI0 = 0x80;

sfrb PI1 = 0x90;

sfrb PI2 = 0xa0;

sfrb EIE0 = 0xb0;
#define EIE0_EX0_MASK 0x1
#define EIE0_EX0 0x1
#define EIE0_EX0_BIT 0
#define EIE0_EX1_MASK 0x2
#define EIE0_EX1 0x2
#define EIE0_EX1_BIT 1
#define EIE0_EX2_MASK 0x4
#define EIE0_EX2 0x4
#define EIE0_EX2_BIT 2
#define EIE0_EX3_MASK 0x8
#define EIE0_EX3 0x8
#define EIE0_EX3_BIT 3
#define EIE0_EX4_MASK 0x10
#define EIE0_EX4 0x10
#define EIE0_EX4_BIT 4
#define EIE0_EX5_MASK 0x20
#define EIE0_EX5 0x20
#define EIE0_EX5_BIT 5

sfrb EIE1 = 0xc0;
#define EIE1_EX0_MASK 0x1
#define EIE1_EX0 0x1
#define EIE1_EX0_BIT 0
#define EIE1_EX1_MASK 0x2
#define EIE1_EX1 0x2
#define EIE1_EX1_BIT 1
#define EIE1_EX2_MASK 0x4
#define EIE1_EX2 0x4
#define EIE1_EX2_BIT 2
#define EIE1_EX3_MASK 0x8
#define EIE1_EX3 0x8
#define EIE1_EX3_BIT 3
#define EIE1_EX4_MASK 0x10
#define EIE1_EX4 0x10
#define EIE1_EX4_BIT 4
#define EIE1_EX5_MASK 0x20
#define EIE1_EX5 0x20
#define EIE1_EX5_BIT 5
#define EIE1_EX6_MASK 0x40
#define EIE1_EX6 0x40
#define EIE1_EX6_BIT 6
#define EIE1_EX7_MASK 0x80
#define EIE1_EX7 0x80
#define EIE1_EX7_BIT 7

sfrb EIE2 = 0xc0;
#define EIE2_EX0_MASK 0x1
#define EIE2_EX0 0x1
#define EIE2_EX0_BIT 0
#define EIE2_EX1_MASK 0x2
#define EIE2_EX1 0x2
#define EIE2_EX1_BIT 1
#define EIE2_EX2_MASK 0x4
#define EIE2_EX2 0x4
#define EIE2_EX2_BIT 2
#define EIE2_EX3_MASK 0x8
#define EIE2_EX3 0x8
#define EIE2_EX3_BIT 3
#define EIE2_EX4_MASK 0x10
#define EIE2_EX4 0x10
#define EIE2_EX4_BIT 4
#define EIE2_EX5_MASK 0x20
#define EIE2_EX5 0x20
#define EIE2_EX5_BIT 5
#define EIE2_EX6_MASK 0x40
#define EIE2_EX6 0x40
#define EIE2_EX6_BIT 6
#define EIE2_EX7_MASK 0x80
#define EIE2_EX7 0x80
#define EIE2_EX7_BIT 7

sfrb MCNT = 0x1;
#define MCNT_SUS_MASK 0x1
#define MCNT_SUS 0x1
#define MCNT_SUS_BIT 0
#define MCNT_MMAC_MASK 0x2
#define MCNT_MMAC 0x2
#define MCNT_MMAC_BIT 1
#define MCNT_MSUB_MASK 0x4
#define MCNT_MSUB 0x4
#define MCNT_MSUB_BIT 2
#define MCNT_OPCS_MASK 0x8
#define MCNT_OPCS 0x8
#define MCNT_OPCS_BIT 3
#define MCNT_SQU_MASK 0x10
#define MCNT_SQU 0x10
#define MCNT_SQU_BIT 4
#define MCNT_CLD_MASK 0x20
#define MCNT_CLD 0x20
#define MCNT_CLD_BIT 5
#define MCNT_MCW_MASK 0x40
#define MCNT_MCW 0x40
#define MCNT_MCW_BIT 6
#define MCNT_OF_MASK 0x80
#define MCNT_OF 0x80
#define MCNT_OF_BIT 7

sfrw MA = 0x11;

sfrw MB = 0x21;

sfrw MC2 = 0x31;

sfrw MC1 = 0x41;

sfrw MC0 = 0x51;

sfrw MC1R = 0xc1;

sfrw MC0R = 0xd1;

sfrw SPIB = 0x61;

sfrb SPICN = 0x71;
#define SPICN_SPIEN_MASK 0x1
#define SPICN_SPIEN 0x1
#define SPICN_SPIEN_BIT 0
#define SPICN_MSTM_MASK 0x2
#define SPICN_MSTM 0x2
#define SPICN_MSTM_BIT 1
#define SPICN_MODFE_MASK 0x4
#define SPICN_MODFE 0x4
#define SPICN_MODFE_BIT 2
#define SPICN_MODF_MASK 0x8
#define SPICN_MODF 0x8
#define SPICN_MODF_BIT 3
#define SPICN_WCOL_MASK 0x10
#define SPICN_WCOL 0x10
#define SPICN_WCOL_BIT 4
#define SPICN_ROVR_MASK 0x20
#define SPICN_ROVR 0x20
#define SPICN_ROVR_BIT 5
#define SPICN_SPIC_MASK 0x40
#define SPICN_SPIC 0x40
#define SPICN_SPIC_BIT 6
#define SPICN_STBY_MASK 0x80
#define SPICN_STBY 0x80
#define SPICN_STBY_BIT 7

sfrb SPICF = 0x81;
#define SPICF_CKPOL_MASK 0x1
#define SPICF_CKPOL 0x1
#define SPICF_CKPOL_BIT 0
#define SPICF_CKPHA_MASK 0x2
#define SPICF_CKPHA 0x2
#define SPICF_CKPHA_BIT 1
#define SPICF_CHR_MASK 0x4
#define SPICF_CHR 0x4
#define SPICF_CHR_BIT 2
#define SPICF_ESPI1_MASK 0x80
#define SPICF_ESPI1 0x80
#define SPICF_ESPI1_BIT 7

sfrb SPICK = 0x93;

sfrw RCNT = 0xe1;
#define RCNT_RTCE_MASK 0x1
#define RCNT_RTCE 0x1
#define RCNT_RTCE_BIT 0
#define RCNT_ADE_MASK 0x2
#define RCNT_ADE 0x2
#define RCNT_ADE_BIT 1
#define RCNT_ASE_MASK 0x4
#define RCNT_ASE 0x4
#define RCNT_ASE_BIT 2
#define RCNT_BUSY_MASK 0x8
#define RCNT_BUSY 0x8
#define RCNT_BUSY_BIT 3
#define RCNT_RDY_MASK 0x10
#define RCNT_RDY 0x10
#define RCNT_RDY_BIT 4
#define RCNT_RDYE_MASK 0x20
#define RCNT_RDYE 0x20
#define RCNT_RDYE_BIT 5
#define RCNT_ALDF_MASK 0x40
#define RCNT_ALDF 0x40
#define RCNT_ALDF_BIT 6
#define RCNT_ALSF_MASK 0x80
#define RCNT_ALSF 0x80
#define RCNT_ALSF_BIT 7
#define RCNT_ACS_MASK 0x2000
#define RCNT_ACS 0x2000
#define RCNT_ACS_BIT 13
#define RCNT_X32D_MASK 0x4000
#define RCNT_X32D 0x4000
#define RCNT_X32D_BIT 14
#define RCNT_WE_MASK 0x8000
#define RCNT_WE 0x8000
#define RCNT_WE_BIT 15

sfrb RSSA = 0xf1;

sfrb T2CNA0 = 0x2;
#define T2CNA0_G2EN_MASK 0x1
#define T2CNA0_G2EN 0x1
#define T2CNA0_G2EN_BIT 0
#define T2CNA0_SS2_MASK 0x2
#define T2CNA0_SS2 0x2
#define T2CNA0_SS2_BIT 1
#define T2CNA0_CPRL2_MASK 0x4
#define T2CNA0_CPRL2 0x4
#define T2CNA0_CPRL2_BIT 2
#define T2CNA0_TR2_MASK 0x8
#define T2CNA0_TR2 0x8
#define T2CNA0_TR2_BIT 3
#define T2CNA0_TR2L_MASK 0x10
#define T2CNA0_TR2L 0x10
#define T2CNA0_TR2L_BIT 4
#define T2CNA0_T2POL0_MASK 0x20
#define T2CNA0_T2POL0 0x20
#define T2CNA0_T2POL0_BIT 5
#define T2CNA0_T2OE0_MASK 0x40
#define T2CNA0_T2OE0 0x40
#define T2CNA0_T2OE0_BIT 6
#define T2CNA0_ET2_MASK 0x80
#define T2CNA0_ET2 0x80
#define T2CNA0_ET2_BIT 7

sfrb T2H0 = 0x12;

sfrb T2RH0 = 0x22;

sfrb T2CH0 = 0x32;

sfrb T2CNB0 = 0x82;
#define T2CNB0_TC2L_MASK 0x1
#define T2CNB0_TC2L 0x1
#define T2CNB0_TC2L_BIT 0
#define T2CNB0_TCC2_MASK 0x2
#define T2CNB0_TCC2 0x2
#define T2CNB0_TCC2_BIT 1
#define T2CNB0_TF2L_MASK 0x4
#define T2CNB0_TF2L 0x4
#define T2CNB0_TF2L_BIT 2
#define T2CNB0_TF2_MASK 0x8
#define T2CNB0_TF2 0x8
#define T2CNB0_TF2_BIT 3
#define T2CNB0_T2RL_MASK 0x10
#define T2CNB0_T2RL 0x10
#define T2CNB0_T2RL_BIT 4
#define T2CNB0_T2POL1_MASK 0x20
#define T2CNB0_T2POL1 0x20
#define T2CNB0_T2POL1_BIT 5
#define T2CNB0_T2OE1_MASK 0x40
#define T2CNB0_T2OE1 0x40
#define T2CNB0_T2OE1_BIT 6
#define T2CNB0_ET2L_MASK 0x80
#define T2CNB0_ET2L 0x80
#define T2CNB0_ET2L_BIT 7

sfrw T2V0 = 0x92;

sfrw T2R0 = 0xa2;

sfrw T2C0 = 0xb2;

sfrb T2CFG0 = 0x102;
#define T2CFG0_CT2_MASK 0x1
#define T2CFG0_CT2 0x1
#define T2CFG0_CT2_BIT 0
#define T2CFG0_CCF0_MASK 0x2
#define T2CFG0_CCF0 0x2
#define T2CFG0_CCF0_BIT 1
#define T2CFG0_CCF1_MASK 0x4
#define T2CFG0_CCF1 0x4
#define T2CFG0_CCF1_BIT 2
#define T2CFG0_T2MD_MASK 0x8
#define T2CFG0_T2MD 0x8
#define T2CFG0_T2MD_BIT 3
#define T2CFG0_DIV0_MASK 0x10
#define T2CFG0_DIV0 0x10
#define T2CFG0_DIV0_BIT 4
#define T2CFG0_DIV1_MASK 0x20
#define T2CFG0_DIV1 0x20
#define T2CFG0_DIV1_BIT 5
#define T2CFG0_DIV2_MASK 0x40
#define T2CFG0_DIV2 0x40
#define T2CFG0_DIV2_BIT 6
#define T2CFG0_T2CI_MASK 0x80
#define T2CFG0_T2CI 0x80
#define T2CFG0_T2CI_BIT 7

sfrb T2CNA1 = 0x42;
#define T2CNA1_G2EN_MASK 0x1
#define T2CNA1_G2EN 0x1
#define T2CNA1_G2EN_BIT 0
#define T2CNA1_SS2_MASK 0x2
#define T2CNA1_SS2 0x2
#define T2CNA1_SS2_BIT 1
#define T2CNA1_CPRL2_MASK 0x4
#define T2CNA1_CPRL2 0x4
#define T2CNA1_CPRL2_BIT 2
#define T2CNA1_TR2_MASK 0x8
#define T2CNA1_TR2 0x8
#define T2CNA1_TR2_BIT 3
#define T2CNA1_TR2L_MASK 0x10
#define T2CNA1_TR2L 0x10
#define T2CNA1_TR2L_BIT 4
#define T2CNA1_T2POL0_MASK 0x20
#define T2CNA1_T2POL0 0x20
#define T2CNA1_T2POL0_BIT 5
#define T2CNA1_T2OE0_MASK 0x40
#define T2CNA1_T2OE0 0x40
#define T2CNA1_T2OE0_BIT 6
#define T2CNA1_ET2_MASK 0x80
#define T2CNA1_ET2 0x80
#define T2CNA1_ET2_BIT 7

sfrb T2H1 = 0x52;

sfrb T2RH1 = 0x62;

sfrb T2CH1 = 0x72;

sfrb T2CNB1 = 0xc2;
#define T2CNB1_TC2L_MASK 0x1
#define T2CNB1_TC2L 0x1
#define T2CNB1_TC2L_BIT 0
#define T2CNB1_TCC2_MASK 0x2
#define T2CNB1_TCC2 0x2
#define T2CNB1_TCC2_BIT 1
#define T2CNB1_TF2L_MASK 0x4
#define T2CNB1_TF2L 0x4
#define T2CNB1_TF2L_BIT 2
#define T2CNB1_TF2_MASK 0x8
#define T2CNB1_TF2 0x8
#define T2CNB1_TF2_BIT 3
#define T2CNB1_T2RL_MASK 0x10
#define T2CNB1_T2RL 0x10
#define T2CNB1_T2RL_BIT 4
#define T2CNB1_T2POL1_MASK 0x20
#define T2CNB1_T2POL1 0x20
#define T2CNB1_T2POL1_BIT 5
#define T2CNB1_T2OE1_MASK 0x40
#define T2CNB1_T2OE1 0x40
#define T2CNB1_T2OE1_BIT 6
#define T2CNB1_ET2L_MASK 0x80
#define T2CNB1_ET2L 0x80
#define T2CNB1_ET2L_BIT 7

sfrw T2V1 = 0xd2;

sfrw T2R1 = 0xe2;

sfrw T2C1 = 0xf2;

sfrb T2CFG1 = 0x112;
#define T2CFG1_CT2_MASK 0x1
#define T2CFG1_CT2 0x1
#define T2CFG1_CT2_BIT 0
#define T2CFG1_CCF0_MASK 0x2
#define T2CFG1_CCF0 0x2
#define T2CFG1_CCF0_BIT 1
#define T2CFG1_CCF1_MASK 0x4
#define T2CFG1_CCF1 0x4
#define T2CFG1_CCF1_BIT 2
#define T2CFG1_T2MD_MASK 0x8
#define T2CFG1_T2MD 0x8
#define T2CFG1_T2MD_BIT 3
#define T2CFG1_DIV0_MASK 0x10
#define T2CFG1_DIV0 0x10
#define T2CFG1_DIV0_BIT 4
#define T2CFG1_DIV1_MASK 0x20
#define T2CFG1_DIV1 0x20
#define T2CFG1_DIV1_BIT 5
#define T2CFG1_DIV2_MASK 0x40
#define T2CFG1_DIV2 0x40
#define T2CFG1_DIV2_BIT 6
#define T2CFG1_T2CI_MASK 0x80
#define T2CFG1_T2CI 0x80
#define T2CFG1_T2CI_BIT 7

sfrb T2CNA2 = 0x3;
#define T2CNA2_G2EN_MASK 0x1
#define T2CNA2_G2EN 0x1
#define T2CNA2_G2EN_BIT 0
#define T2CNA2_SS2_MASK 0x2
#define T2CNA2_SS2 0x2
#define T2CNA2_SS2_BIT 1
#define T2CNA2_CPRL2_MASK 0x4
#define T2CNA2_CPRL2 0x4
#define T2CNA2_CPRL2_BIT 2
#define T2CNA2_TR2_MASK 0x8
#define T2CNA2_TR2 0x8
#define T2CNA2_TR2_BIT 3
#define T2CNA2_TR2L_MASK 0x10
#define T2CNA2_TR2L 0x10
#define T2CNA2_TR2L_BIT 4
#define T2CNA2_T2POL0_MASK 0x20
#define T2CNA2_T2POL0 0x20
#define T2CNA2_T2POL0_BIT 5
#define T2CNA2_T2OE0_MASK 0x40
#define T2CNA2_T2OE0 0x40
#define T2CNA2_T2OE0_BIT 6
#define T2CNA2_ET2_MASK 0x80
#define T2CNA2_ET2 0x80
#define T2CNA2_ET2_BIT 7

sfrb T2H2 = 0x13;

sfrb T2RH2 = 0x23;

sfrb T2CH2 = 0x33;

sfrb T2CNB2 = 0x83;
#define T2CNB2_TC2L_MASK 0x1
#define T2CNB2_TC2L 0x1
#define T2CNB2_TC2L_BIT 0
#define T2CNB2_TCC2_MASK 0x2
#define T2CNB2_TCC2 0x2
#define T2CNB2_TCC2_BIT 1
#define T2CNB2_TF2L_MASK 0x4
#define T2CNB2_TF2L 0x4
#define T2CNB2_TF2L_BIT 2
#define T2CNB2_TF2_MASK 0x8
#define T2CNB2_TF2 0x8
#define T2CNB2_TF2_BIT 3
#define T2CNB2_T2RL_MASK 0x10
#define T2CNB2_T2RL 0x10
#define T2CNB2_T2RL_BIT 4
#define T2CNB2_T2POL1_MASK 0x20
#define T2CNB2_T2POL1 0x20
#define T2CNB2_T2POL1_BIT 5
#define T2CNB2_T2OE1_MASK 0x40
#define T2CNB2_T2OE1 0x40
#define T2CNB2_T2OE1_BIT 6
#define T2CNB2_ET2L_MASK 0x80
#define T2CNB2_ET2L 0x80
#define T2CNB2_ET2L_BIT 7

sfrw T2V2 = 0x93;

sfrw T2R2 = 0xa3;

sfrw T2C2 = 0xb3;

sfrb T2CFG2 = 0x103;
#define T2CFG2_CT2_MASK 0x1
#define T2CFG2_CT2 0x1
#define T2CFG2_CT2_BIT 0
#define T2CFG2_CCF0_MASK 0x2
#define T2CFG2_CCF0 0x2
#define T2CFG2_CCF0_BIT 1
#define T2CFG2_CCF1_MASK 0x4
#define T2CFG2_CCF1 0x4
#define T2CFG2_CCF1_BIT 2
#define T2CFG2_T2MD_MASK 0x8
#define T2CFG2_T2MD 0x8
#define T2CFG2_T2MD_BIT 3
#define T2CFG2_DIV0_MASK 0x10
#define T2CFG2_DIV0 0x10
#define T2CFG2_DIV0_BIT 4
#define T2CFG2_DIV1_MASK 0x20
#define T2CFG2_DIV1 0x20
#define T2CFG2_DIV1_BIT 5
#define T2CFG2_DIV2_MASK 0x40
#define T2CFG2_DIV2 0x40
#define T2CFG2_DIV2_BIT 6
#define T2CFG2_T2CI_MASK 0x80
#define T2CFG2_T2CI 0x80
#define T2CFG2_T2CI_BIT 7

sfrb T2CNA3 = 0x43;
#define T2CNA3_G2EN_MASK 0x1
#define T2CNA3_G2EN 0x1
#define T2CNA3_G2EN_BIT 0
#define T2CNA3_SS2_MASK 0x2
#define T2CNA3_SS2 0x2
#define T2CNA3_SS2_BIT 1
#define T2CNA3_CPRL2_MASK 0x4
#define T2CNA3_CPRL2 0x4
#define T2CNA3_CPRL2_BIT 2
#define T2CNA3_TR2_MASK 0x8
#define T2CNA3_TR2 0x8
#define T2CNA3_TR2_BIT 3
#define T2CNA3_TR2L_MASK 0x10
#define T2CNA3_TR2L 0x10
#define T2CNA3_TR2L_BIT 4
#define T2CNA3_T2POL0_MASK 0x20
#define T2CNA3_T2POL0 0x20
#define T2CNA3_T2POL0_BIT 5
#define T2CNA3_T2OE0_MASK 0x40
#define T2CNA3_T2OE0 0x40
#define T2CNA3_T2OE0_BIT 6
#define T2CNA3_ET2_MASK 0x80
#define T2CNA3_ET2 0x80
#define T2CNA3_ET2_BIT 7

sfrb T2H3 = 0x53;

sfrb T2RH3 = 0x63;

sfrb T2CH3 = 0x73;

sfrb T2CNB3 = 0xc3;
#define T2CNB3_TC2L_MASK 0x1
#define T2CNB3_TC2L 0x1
#define T2CNB3_TC2L_BIT 0
#define T2CNB3_TCC2_MASK 0x2
#define T2CNB3_TCC2 0x2
#define T2CNB3_TCC2_BIT 1
#define T2CNB3_TF2L_MASK 0x4
#define T2CNB3_TF2L 0x4
#define T2CNB3_TF2L_BIT 2
#define T2CNB3_TF2_MASK 0x8
#define T2CNB3_TF2 0x8
#define T2CNB3_TF2_BIT 3
#define T2CNB3_T2RL_MASK 0x10
#define T2CNB3_T2RL 0x10
#define T2CNB3_T2RL_BIT 4
#define T2CNB3_T2POL1_MASK 0x20
#define T2CNB3_T2POL1 0x20
#define T2CNB3_T2POL1_BIT 5
#define T2CNB3_T2OE1_MASK 0x40
#define T2CNB3_T2OE1 0x40
#define T2CNB3_T2OE1_BIT 6
#define T2CNB3_ET2L_MASK 0x80
#define T2CNB3_ET2L 0x80
#define T2CNB3_ET2L_BIT 7

sfrw T2V3 = 0xd3;

sfrw T2R3 = 0xe3;

sfrw T2C3 = 0xf3;

sfrb T2CFG3 = 0x113;
#define T2CFG3_CT2_MASK 0x1
#define T2CFG3_CT2 0x1
#define T2CFG3_CT2_BIT 0
#define T2CFG3_CCF0_MASK 0x2
#define T2CFG3_CCF0 0x2
#define T2CFG3_CCF0_BIT 1
#define T2CFG3_CCF1_MASK 0x4
#define T2CFG3_CCF1 0x4
#define T2CFG3_CCF1_BIT 2
#define T2CFG3_T2MD_MASK 0x8
#define T2CFG3_T2MD 0x8
#define T2CFG3_T2MD_BIT 3
#define T2CFG3_DIV0_MASK 0x10
#define T2CFG3_DIV0 0x10
#define T2CFG3_DIV0_BIT 4
#define T2CFG3_DIV1_MASK 0x20
#define T2CFG3_DIV1 0x20
#define T2CFG3_DIV1_BIT 5
#define T2CFG3_DIV2_MASK 0x40
#define T2CFG3_DIV2 0x40
#define T2CFG3_DIV2_BIT 6
#define T2CFG3_T2CI_MASK 0x80
#define T2CFG3_T2CI 0x80
#define T2CFG3_T2CI_BIT 7

sfrw C0C = 0x4;
#define C0C_SWINT_MASK 0x1
#define C0C_SWINT 0x1
#define C0C_SWINT_BIT 0
#define C0C_ERCS_MASK 0x2
#define C0C_ERCS 0x2
#define C0C_ERCS_BIT 1
#define C0C_AUTOB_MASK 0x4
#define C0C_AUTOB 0x4
#define C0C_AUTOB_BIT 2
#define C0C_CRST_MASK 0x8
#define C0C_CRST 0x8
#define C0C_CRST_BIT 3
#define C0C_SIESTA_MASK 0x10
#define C0C_SIESTA 0x10
#define C0C_SIESTA_BIT 4
#define C0C_PDE_MASK 0x20
#define C0C_PDE 0x20
#define C0C_PDE_BIT 5
#define C0C_STIE_MASK 0x40
#define C0C_STIE 0x40
#define C0C_STIE_BIT 6
#define C0C_ERIPR_MASK 0x80
#define C0C_ERIPR 0x80
#define C0C_ERIPR_BIT 7

sfrw C0S = 0x14;
#define C0S_ER0_MASK 0x1
#define C0S_ER0 0x1
#define C0S_ER0_BIT 0
#define C0S_ER1_MASK 0x2
#define C0S_ER1 0x2
#define C0S_ER1_BIT 1
#define C0S_ER2_MASK 0x4
#define C0S_ER2 0x4
#define C0S_ER2_BIT 2
#define C0S_TXS_MASK 0x8
#define C0S_TXS 0x8
#define C0S_TXS_BIT 3
#define C0S_RXS_MASK 0x10
#define C0S_RXS 0x10
#define C0S_RXS_BIT 4
#define C0S_WKS_MASK 0x20
#define C0S_WKS 0x20
#define C0S_WKS_BIT 5
#define C0S_EC96_128_MASK 0x40
#define C0S_EC96_128 0x40
#define C0S_EC96_128_BIT 6
#define C0S_BSS_MASK 0x80
#define C0S_BSS 0x80
#define C0S_BSS_BIT 7

sfrw C0IR = 0x24;
#define C0IR_INTIN0_MASK 0x1
#define C0IR_INTIN0 0x1
#define C0IR_INTIN0_BIT 0
#define C0IR_INTIN1_MASK 0x2
#define C0IR_INTIN1 0x2
#define C0IR_INTIN1_BIT 1
#define C0IR_INTIN2_MASK 0x4
#define C0IR_INTIN2 0x4
#define C0IR_INTIN2_BIT 2
#define C0IR_INTIN3_MASK 0x8
#define C0IR_INTIN3 0x8
#define C0IR_INTIN3_BIT 3
#define C0IR_INTIN4_MASK 0x10
#define C0IR_INTIN4 0x10
#define C0IR_INTIN4_BIT 4
#define C0IR_INTIN5_MASK 0x20
#define C0IR_INTIN5 0x20
#define C0IR_INTIN5_BIT 5
#define C0IR_INTIN6_MASK 0x40
#define C0IR_INTIN6 0x40
#define C0IR_INTIN6_BIT 6
#define C0IR_INTIN7_MASK 0x80
#define C0IR_INTIN7 0x80
#define C0IR_INTIN7_BIT 7

sfrw C0TE = 0x34;

sfrw C0RE = 0x44;

sfrw C0R = 0x54;
#define C0R_C0IE_MASK 0x1
#define C0R_C0IE 0x1
#define C0R_C0IE_BIT 0
#define C0R_C0BIE_MASK 0x2
#define C0R_C0BIE 0x2
#define C0R_C0BIE_BIT 1
#define C0R_C0BPR6_MASK 0x8
#define C0R_C0BPR6 0x8
#define C0R_C0BPR6_BIT 3
#define C0R_C0BPR7_MASK 0x10
#define C0R_C0BPR7 0x10
#define C0R_C0BPR7_BIT 4
#define C0R_AID_MASK 0x20
#define C0R_AID 0x20
#define C0R_AID_BIT 5
#define C0R_INCDEC_MASK 0x40
#define C0R_INCDEC 0x40
#define C0R_INCDEC_BIT 6
#define C0R_CAN0BA_MASK 0x80
#define C0R_CAN0BA 0x80
#define C0R_CAN0BA_BIT 7

sfrw C0DP = 0x64;

sfrw C0DB = 0x74;

sfrw C0RMS = 0x84;

sfrw C0TMA = 0x94;

sfrw C0M1C = 0x114;
#define C0M1C_DTUP_MASK 0x1
#define C0M1C_DTUP 0x1
#define C0M1C_DTUP_BIT 0
#define C0M1C_ROW_MASK 0x2
#define C0M1C_ROW 0x2
#define C0M1C_ROW_BIT 1
#define C0M1C_TIH_MASK 0x2
#define C0M1C_TIH 0x2
#define C0M1C_TIH_BIT 1
#define C0M1C_MTRQ_MASK 0x4
#define C0M1C_MTRQ 0x4
#define C0M1C_MTRQ_BIT 2
#define C0M1C_EXTRQ_MASK 0x8
#define C0M1C_EXTRQ 0x8
#define C0M1C_EXTRQ_BIT 3
#define C0M1C_INTRQ_MASK 0x10
#define C0M1C_INTRQ 0x10
#define C0M1C_INTRQ_BIT 4
#define C0M1C_ERI_MASK 0x20
#define C0M1C_ERI 0x20
#define C0M1C_ERI_BIT 5
#define C0M1C_ETI_MASK 0x40
#define C0M1C_ETI 0x40
#define C0M1C_ETI_BIT 6
#define C0M1C_MSRDY_MASK 0x80
#define C0M1C_MSRDY 0x80
#define C0M1C_MSRDY_BIT 7

sfrw C0M2C = 0x124;
#define C0M2C_DTUP_MASK 0x1
#define C0M2C_DTUP 0x1
#define C0M2C_DTUP_BIT 0
#define C0M2C_ROW_MASK 0x2
#define C0M2C_ROW 0x2
#define C0M2C_ROW_BIT 1
#define C0M2C_TIH_MASK 0x2
#define C0M2C_TIH 0x2
#define C0M2C_TIH_BIT 1
#define C0M2C_MTRQ_MASK 0x4
#define C0M2C_MTRQ 0x4
#define C0M2C_MTRQ_BIT 2
#define C0M2C_EXTRQ_MASK 0x8
#define C0M2C_EXTRQ 0x8
#define C0M2C_EXTRQ_BIT 3
#define C0M2C_INTRQ_MASK 0x10
#define C0M2C_INTRQ 0x10
#define C0M2C_INTRQ_BIT 4
#define C0M2C_ERI_MASK 0x20
#define C0M2C_ERI 0x20
#define C0M2C_ERI_BIT 5
#define C0M2C_ETI_MASK 0x40
#define C0M2C_ETI 0x40
#define C0M2C_ETI_BIT 6
#define C0M2C_MSRDY_MASK 0x80
#define C0M2C_MSRDY 0x80
#define C0M2C_MSRDY_BIT 7

sfrw C0M3C = 0x134;
#define C0M3C_DTUP_MASK 0x1
#define C0M3C_DTUP 0x1
#define C0M3C_DTUP_BIT 0
#define C0M3C_ROW_MASK 0x2
#define C0M3C_ROW 0x2
#define C0M3C_ROW_BIT 1
#define C0M3C_TIH_MASK 0x2
#define C0M3C_TIH 0x2
#define C0M3C_TIH_BIT 1
#define C0M3C_MTRQ_MASK 0x4
#define C0M3C_MTRQ 0x4
#define C0M3C_MTRQ_BIT 2
#define C0M3C_EXTRQ_MASK 0x8
#define C0M3C_EXTRQ 0x8
#define C0M3C_EXTRQ_BIT 3
#define C0M3C_INTRQ_MASK 0x10
#define C0M3C_INTRQ 0x10
#define C0M3C_INTRQ_BIT 4
#define C0M3C_ERI_MASK 0x20
#define C0M3C_ERI 0x20
#define C0M3C_ERI_BIT 5
#define C0M3C_ETI_MASK 0x40
#define C0M3C_ETI 0x40
#define C0M3C_ETI_BIT 6
#define C0M3C_MSRDY_MASK 0x80
#define C0M3C_MSRDY 0x80
#define C0M3C_MSRDY_BIT 7

sfrw C0M4C = 0x144;
#define C0M4C_DTUP_MASK 0x1
#define C0M4C_DTUP 0x1
#define C0M4C_DTUP_BIT 0
#define C0M4C_ROW_MASK 0x2
#define C0M4C_ROW 0x2
#define C0M4C_ROW_BIT 1
#define C0M4C_TIH_MASK 0x2
#define C0M4C_TIH 0x2
#define C0M4C_TIH_BIT 1
#define C0M4C_MTRQ_MASK 0x4
#define C0M4C_MTRQ 0x4
#define C0M4C_MTRQ_BIT 2
#define C0M4C_EXTRQ_MASK 0x8
#define C0M4C_EXTRQ 0x8
#define C0M4C_EXTRQ_BIT 3
#define C0M4C_INTRQ_MASK 0x10
#define C0M4C_INTRQ 0x10
#define C0M4C_INTRQ_BIT 4
#define C0M4C_ERI_MASK 0x20
#define C0M4C_ERI 0x20
#define C0M4C_ERI_BIT 5
#define C0M4C_ETI_MASK 0x40
#define C0M4C_ETI 0x40
#define C0M4C_ETI_BIT 6
#define C0M4C_MSRDY_MASK 0x80
#define C0M4C_MSRDY 0x80
#define C0M4C_MSRDY_BIT 7

sfrw C0M5C = 0x154;
#define C0M5C_DTUP_MASK 0x1
#define C0M5C_DTUP 0x1
#define C0M5C_DTUP_BIT 0
#define C0M5C_ROW_MASK 0x2
#define C0M5C_ROW 0x2
#define C0M5C_ROW_BIT 1
#define C0M5C_TIH_MASK 0x2
#define C0M5C_TIH 0x2
#define C0M5C_TIH_BIT 1
#define C0M5C_MTRQ_MASK 0x4
#define C0M5C_MTRQ 0x4
#define C0M5C_MTRQ_BIT 2
#define C0M5C_EXTRQ_MASK 0x8
#define C0M5C_EXTRQ 0x8
#define C0M5C_EXTRQ_BIT 3
#define C0M5C_INTRQ_MASK 0x10
#define C0M5C_INTRQ 0x10
#define C0M5C_INTRQ_BIT 4
#define C0M5C_ERI_MASK 0x20
#define C0M5C_ERI 0x20
#define C0M5C_ERI_BIT 5
#define C0M5C_ETI_MASK 0x40
#define C0M5C_ETI 0x40
#define C0M5C_ETI_BIT 6
#define C0M5C_MSRDY_MASK 0x80
#define C0M5C_MSRDY 0x80
#define C0M5C_MSRDY_BIT 7

sfrw C0M6C = 0x164;
#define C0M6C_DTUP_MASK 0x1
#define C0M6C_DTUP 0x1
#define C0M6C_DTUP_BIT 0
#define C0M6C_ROW_MASK 0x2
#define C0M6C_ROW 0x2
#define C0M6C_ROW_BIT 1
#define C0M6C_TIH_MASK 0x2
#define C0M6C_TIH 0x2
#define C0M6C_TIH_BIT 1
#define C0M6C_MTRQ_MASK 0x4
#define C0M6C_MTRQ 0x4
#define C0M6C_MTRQ_BIT 2
#define C0M6C_EXTRQ_MASK 0x8
#define C0M6C_EXTRQ 0x8
#define C0M6C_EXTRQ_BIT 3
#define C0M6C_INTRQ_MASK 0x10
#define C0M6C_INTRQ 0x10
#define C0M6C_INTRQ_BIT 4
#define C0M6C_ERI_MASK 0x20
#define C0M6C_ERI 0x20
#define C0M6C_ERI_BIT 5
#define C0M6C_ETI_MASK 0x40
#define C0M6C_ETI 0x40
#define C0M6C_ETI_BIT 6
#define C0M6C_MSRDY_MASK 0x80
#define C0M6C_MSRDY 0x80
#define C0M6C_MSRDY_BIT 7

sfrw C0M7C = 0x174;
#define C0M7C_DTUP_MASK 0x1
#define C0M7C_DTUP 0x1
#define C0M7C_DTUP_BIT 0
#define C0M7C_ROW_MASK 0x2
#define C0M7C_ROW 0x2
#define C0M7C_ROW_BIT 1
#define C0M7C_TIH_MASK 0x2
#define C0M7C_TIH 0x2
#define C0M7C_TIH_BIT 1
#define C0M7C_MTRQ_MASK 0x4
#define C0M7C_MTRQ 0x4
#define C0M7C_MTRQ_BIT 2
#define C0M7C_EXTRQ_MASK 0x8
#define C0M7C_EXTRQ 0x8
#define C0M7C_EXTRQ_BIT 3
#define C0M7C_INTRQ_MASK 0x10
#define C0M7C_INTRQ 0x10
#define C0M7C_INTRQ_BIT 4
#define C0M7C_ERI_MASK 0x20
#define C0M7C_ERI 0x20
#define C0M7C_ERI_BIT 5
#define C0M7C_ETI_MASK 0x40
#define C0M7C_ETI 0x40
#define C0M7C_ETI_BIT 6
#define C0M7C_MSRDY_MASK 0x80
#define C0M7C_MSRDY 0x80
#define C0M7C_MSRDY_BIT 7

sfrw C0M8C = 0x184;
#define C0M8C_DTUP_MASK 0x1
#define C0M8C_DTUP 0x1
#define C0M8C_DTUP_BIT 0
#define C0M8C_ROW_MASK 0x2
#define C0M8C_ROW 0x2
#define C0M8C_ROW_BIT 1
#define C0M8C_TIH_MASK 0x2
#define C0M8C_TIH 0x2
#define C0M8C_TIH_BIT 1
#define C0M8C_MTRQ_MASK 0x4
#define C0M8C_MTRQ 0x4
#define C0M8C_MTRQ_BIT 2
#define C0M8C_EXTRQ_MASK 0x8
#define C0M8C_EXTRQ 0x8
#define C0M8C_EXTRQ_BIT 3
#define C0M8C_INTRQ_MASK 0x10
#define C0M8C_INTRQ 0x10
#define C0M8C_INTRQ_BIT 4
#define C0M8C_ERI_MASK 0x20
#define C0M8C_ERI 0x20
#define C0M8C_ERI_BIT 5
#define C0M8C_ETI_MASK 0x40
#define C0M8C_ETI 0x40
#define C0M8C_ETI_BIT 6
#define C0M8C_MSRDY_MASK 0x80
#define C0M8C_MSRDY 0x80
#define C0M8C_MSRDY_BIT 7

sfrw C0M9C = 0x194;
#define C0M9C_DTUP_MASK 0x1
#define C0M9C_DTUP 0x1
#define C0M9C_DTUP_BIT 0
#define C0M9C_ROW_MASK 0x2
#define C0M9C_ROW 0x2
#define C0M9C_ROW_BIT 1
#define C0M9C_TIH_MASK 0x2
#define C0M9C_TIH 0x2
#define C0M9C_TIH_BIT 1
#define C0M9C_MTRQ_MASK 0x4
#define C0M9C_MTRQ 0x4
#define C0M9C_MTRQ_BIT 2
#define C0M9C_EXTRQ_MASK 0x8
#define C0M9C_EXTRQ 0x8
#define C0M9C_EXTRQ_BIT 3
#define C0M9C_INTRQ_MASK 0x10
#define C0M9C_INTRQ 0x10
#define C0M9C_INTRQ_BIT 4
#define C0M9C_ERI_MASK 0x20
#define C0M9C_ERI 0x20
#define C0M9C_ERI_BIT 5
#define C0M9C_ETI_MASK 0x40
#define C0M9C_ETI 0x40
#define C0M9C_ETI_BIT 6
#define C0M9C_MSRDY_MASK 0x80
#define C0M9C_MSRDY 0x80
#define C0M9C_MSRDY_BIT 7

sfrw C0M10C = 0x1a4;
#define C0M10C_DTUP_MASK 0x1
#define C0M10C_DTUP 0x1
#define C0M10C_DTUP_BIT 0
#define C0M10C_ROW_MASK 0x2
#define C0M10C_ROW 0x2
#define C0M10C_ROW_BIT 1
#define C0M10C_TIH_MASK 0x2
#define C0M10C_TIH 0x2
#define C0M10C_TIH_BIT 1
#define C0M10C_MTRQ_MASK 0x4
#define C0M10C_MTRQ 0x4
#define C0M10C_MTRQ_BIT 2
#define C0M10C_EXTRQ_MASK 0x8
#define C0M10C_EXTRQ 0x8
#define C0M10C_EXTRQ_BIT 3
#define C0M10C_INTRQ_MASK 0x10
#define C0M10C_INTRQ 0x10
#define C0M10C_INTRQ_BIT 4
#define C0M10C_ERI_MASK 0x20
#define C0M10C_ERI 0x20
#define C0M10C_ERI_BIT 5
#define C0M10C_ETI_MASK 0x40
#define C0M10C_ETI 0x40
#define C0M10C_ETI_BIT 6
#define C0M10C_MSRDY_MASK 0x80
#define C0M10C_MSRDY 0x80
#define C0M10C_MSRDY_BIT 7

sfrw C0M11C = 0x1b4;
#define C0M11C_DTUP_MASK 0x1
#define C0M11C_DTUP 0x1
#define C0M11C_DTUP_BIT 0
#define C0M11C_ROW_MASK 0x2
#define C0M11C_ROW 0x2
#define C0M11C_ROW_BIT 1
#define C0M11C_TIH_MASK 0x2
#define C0M11C_TIH 0x2
#define C0M11C_TIH_BIT 1
#define C0M11C_MTRQ_MASK 0x4
#define C0M11C_MTRQ 0x4
#define C0M11C_MTRQ_BIT 2
#define C0M11C_EXTRQ_MASK 0x8
#define C0M11C_EXTRQ 0x8
#define C0M11C_EXTRQ_BIT 3
#define C0M11C_INTRQ_MASK 0x10
#define C0M11C_INTRQ 0x10
#define C0M11C_INTRQ_BIT 4
#define C0M11C_ERI_MASK 0x20
#define C0M11C_ERI 0x20
#define C0M11C_ERI_BIT 5
#define C0M11C_ETI_MASK 0x40
#define C0M11C_ETI 0x40
#define C0M11C_ETI_BIT 6
#define C0M11C_MSRDY_MASK 0x80
#define C0M11C_MSRDY 0x80
#define C0M11C_MSRDY_BIT 7

sfrw C0M12C = 0x1c4;
#define C0M12C_DTUP_MASK 0x1
#define C0M12C_DTUP 0x1
#define C0M12C_DTUP_BIT 0
#define C0M12C_ROW_MASK 0x2
#define C0M12C_ROW 0x2
#define C0M12C_ROW_BIT 1
#define C0M12C_TIH_MASK 0x2
#define C0M12C_TIH 0x2
#define C0M12C_TIH_BIT 1
#define C0M12C_MTRQ_MASK 0x4
#define C0M12C_MTRQ 0x4
#define C0M12C_MTRQ_BIT 2
#define C0M12C_EXTRQ_MASK 0x8
#define C0M12C_EXTRQ 0x8
#define C0M12C_EXTRQ_BIT 3
#define C0M12C_INTRQ_MASK 0x10
#define C0M12C_INTRQ 0x10
#define C0M12C_INTRQ_BIT 4
#define C0M12C_ERI_MASK 0x20
#define C0M12C_ERI 0x20
#define C0M12C_ERI_BIT 5
#define C0M12C_ETI_MASK 0x40
#define C0M12C_ETI 0x40
#define C0M12C_ETI_BIT 6
#define C0M12C_MSRDY_MASK 0x80
#define C0M12C_MSRDY 0x80
#define C0M12C_MSRDY_BIT 7

sfrw C0M13C = 0x1d4;
#define C0M13C_DTUP_MASK 0x1
#define C0M13C_DTUP 0x1
#define C0M13C_DTUP_BIT 0
#define C0M13C_ROW_MASK 0x2
#define C0M13C_ROW 0x2
#define C0M13C_ROW_BIT 1
#define C0M13C_TIH_MASK 0x2
#define C0M13C_TIH 0x2
#define C0M13C_TIH_BIT 1
#define C0M13C_MTRQ_MASK 0x4
#define C0M13C_MTRQ 0x4
#define C0M13C_MTRQ_BIT 2
#define C0M13C_EXTRQ_MASK 0x8
#define C0M13C_EXTRQ 0x8
#define C0M13C_EXTRQ_BIT 3
#define C0M13C_INTRQ_MASK 0x10
#define C0M13C_INTRQ 0x10
#define C0M13C_INTRQ_BIT 4
#define C0M13C_ERI_MASK 0x20
#define C0M13C_ERI 0x20
#define C0M13C_ERI_BIT 5
#define C0M13C_ETI_MASK 0x40
#define C0M13C_ETI 0x40
#define C0M13C_ETI_BIT 6
#define C0M13C_MSRDY_MASK 0x80
#define C0M13C_MSRDY 0x80
#define C0M13C_MSRDY_BIT 7

sfrw C0M14C = 0x1e4;
#define C0M14C_DTUP_MASK 0x1
#define C0M14C_DTUP 0x1
#define C0M14C_DTUP_BIT 0
#define C0M14C_ROW_MASK 0x2
#define C0M14C_ROW 0x2
#define C0M14C_ROW_BIT 1
#define C0M14C_TIH_MASK 0x2
#define C0M14C_TIH 0x2
#define C0M14C_TIH_BIT 1
#define C0M14C_MTRQ_MASK 0x4
#define C0M14C_MTRQ 0x4
#define C0M14C_MTRQ_BIT 2
#define C0M14C_EXTRQ_MASK 0x8
#define C0M14C_EXTRQ 0x8
#define C0M14C_EXTRQ_BIT 3
#define C0M14C_INTRQ_MASK 0x10
#define C0M14C_INTRQ 0x10
#define C0M14C_INTRQ_BIT 4
#define C0M14C_ERI_MASK 0x20
#define C0M14C_ERI 0x20
#define C0M14C_ERI_BIT 5
#define C0M14C_ETI_MASK 0x40
#define C0M14C_ETI 0x40
#define C0M14C_ETI_BIT 6
#define C0M14C_MSRDY_MASK 0x80
#define C0M14C_MSRDY 0x80
#define C0M14C_MSRDY_BIT 7

sfrw C0M15C = 0x154;
#define C0M15C_DTUP_MASK 0x1
#define C0M15C_DTUP 0x1
#define C0M15C_DTUP_BIT 0
#define C0M15C_ROW_MASK 0x2
#define C0M15C_ROW 0x2
#define C0M15C_ROW_BIT 1
#define C0M15C_TIH_MASK 0x2
#define C0M15C_TIH 0x2
#define C0M15C_TIH_BIT 1
#define C0M15C_MTRQ_MASK 0x4
#define C0M15C_MTRQ 0x4
#define C0M15C_MTRQ_BIT 2
#define C0M15C_EXTRQ_MASK 0x8
#define C0M15C_EXTRQ 0x8
#define C0M15C_EXTRQ_BIT 3
#define C0M15C_INTRQ_MASK 0x10
#define C0M15C_INTRQ 0x10
#define C0M15C_INTRQ_BIT 4
#define C0M15C_ERI_MASK 0x20
#define C0M15C_ERI 0x20
#define C0M15C_ERI_BIT 5
#define C0M15C_ETI_MASK 0x40
#define C0M15C_ETI 0x40
#define C0M15C_ETI_BIT 6
#define C0M15C_MSRDY_MASK 0x80
#define C0M15C_MSRDY 0x80
#define C0M15C_MSRDY_BIT 7

sfrw VMC = 0x5;
#define VMC_VDBR0_MASK 0x1
#define VMC_VDBR0 0x1
#define VMC_VDBR0_BIT 0
#define VMC_VDBR1_MASK 0x2
#define VMC_VDBR1 0x2
#define VMC_VDBR1_BIT 1
#define VMC_VDBI0_MASK 0x4
#define VMC_VDBI0 0x4
#define VMC_VDBI0_BIT 2
#define VMC_VDBI1_MASK 0x8
#define VMC_VDBI1 0x8
#define VMC_VDBI1_BIT 3
#define VMC_VIOBI0_MASK 0x10
#define VMC_VIOBI0 0x10
#define VMC_VIOBI0_BIT 4
#define VMC_VIOBI1_MASK 0x20
#define VMC_VIOBI1 0x20
#define VMC_VIOBI1_BIT 5
#define VMC_VABI0_MASK 0x40
#define VMC_VABI0 0x40
#define VMC_VABI0_BIT 6
#define VMC_VABI1_MASK 0x80
#define VMC_VABI1 0x80
#define VMC_VABI1_BIT 7

sfrw APE = 0x15;
#define APE_ADCE_MASK 0x1
#define APE_ADCE 0x1
#define APE_ADCE_BIT 0
#define APE_DAC1E_MASK 0x2
#define APE_DAC1E 0x2
#define APE_DAC1E_BIT 1
#define APE_DAC2E_MASK 0x4
#define APE_DAC2E 0x4
#define APE_DAC2E_BIT 2
#define APE_OAE_MASK 0x8
#define APE_OAE 0x8
#define APE_OAE_BIT 3
#define APE_TSE_MASK 0x10
#define APE_TSE 0x10
#define APE_TSE_BIT 4
#define APE_BGRE_MASK 0x20
#define APE_BGRE 0x20
#define APE_BGRE_BIT 5
#define APE_DRBE_MASK 0x40
#define APE_DRBE 0x40
#define APE_DRBE_BIT 6
#define APE_ARBE_MASK 0x80
#define APE_ARBE 0x80
#define APE_ARBE_BIT 7
#define APE_LRPD_MASK 0x100
#define APE_LRPD 0x100
#define APE_LRPD_BIT 8
#define APE_VABE_MASK 0x200
#define APE_VABE 0x200
#define APE_VABE_BIT 9
#define APE_VDPE_MASK 0x400
#define APE_VDPE 0x400
#define APE_VDPE_BIT 10
#define APE_VDBE_MASK 0x800
#define APE_VDBE 0x800
#define APE_VDBE_BIT 11
#define APE_VIBE_MASK 0x1000
#define APE_VIBE 0x1000
#define APE_VIBE_BIT 12

sfrw ACNT = 0x25;
#define ACNT_ADCS0_MASK 0x1
#define ACNT_ADCS0 0x1
#define ACNT_ADCS0_BIT 0
#define ACNT_ADCS1_MASK 0x2
#define ACNT_ADCS1 0x2
#define ACNT_ADCS1_BIT 1
#define ACNT_ADCS2_MASK 0x4
#define ACNT_ADCS2 0x4
#define ACNT_ADCS2_BIT 2
#define ACNT_ADCBY_MASK 0x8
#define ACNT_ADCBY 0x8
#define ACNT_ADCBY_BIT 3
#define ACNT_ADCASD_MASK 0x10
#define ACNT_ADCASD 0x10
#define ACNT_ADCASD_BIT 4
#define ACNT_ADCREF_MASK 0x20
#define ACNT_ADCREF 0x20
#define ACNT_ADCREF_BIT 5
#define ACNT_ADCDUL_MASK 0x40
#define ACNT_ADCDUL 0x40
#define ACNT_ADCDUL_BIT 6
#define ACNT_ADCBIP_MASK 0x200
#define ACNT_ADCBIP 0x200
#define ACNT_ADCBIP_BIT 9
#define ACNT_ADCDIF_MASK 0x400
#define ACNT_ADCDIF 0x400
#define ACNT_ADCDIF_BIT 10
#define ACNT_ADCMX0_MASK 0x800
#define ACNT_ADCMX0 0x800
#define ACNT_ADCMX0_BIT 11
#define ACNT_ADCMX1_MASK 0x1000
#define ACNT_ADCMX1 0x1000
#define ACNT_ADCMX1_BIT 12
#define ACNT_ADCMX2_MASK 0x2000
#define ACNT_ADCMX2 0x2000
#define ACNT_ADCMX2_BIT 13
#define ACNT_ADCMX3_MASK 0x4000
#define ACNT_ADCMX3 0x4000
#define ACNT_ADCMX3_BIT 14
#define ACNT_ADCMX4_MASK 0x8000
#define ACNT_ADCMX4 0x8000
#define ACNT_ADCMX4_BIT 15

sfrw DCNT = 0x35;
#define DCNT_DACRS_MASK 0x1
#define DCNT_DACRS 0x1
#define DCNT_DACRS_BIT 0
#define DCNT_DAC1CP_MASK 0x4
#define DCNT_DAC1CP 0x4
#define DCNT_DAC1CP_BIT 2
#define DCNT_DAC2CP_MASK 0x8
#define DCNT_DAC2CP 0x8
#define DCNT_DAC2CP_BIT 3
#define DCNT_DACLD_MASK 0x70
#define DCNT_DACLD_BIT 4
#define DCNT_ADCCP_MASK 0x80
#define DCNT_ADCCP 0x80
#define DCNT_ADCCP_BIT 7

sfrw DACI1 = 0x45;

sfrw DACI2 = 0x55;

sfrw DACO1 = 0x65;

sfrw DACO2 = 0x75;

sfrw ADCD = 0x85;

sfrw TSO = 0x95;

sfrw AIE = 0xa5;
#define AIE_FLLIE_MASK 0x1
#define AIE_FLLIE 0x1
#define AIE_FLLIE_BIT 0
#define AIE_ADCIE_MASK 0x2
#define AIE_ADCIE 0x2
#define AIE_ADCIE_BIT 1
#define AIE_AORIE_MASK 0x4
#define AIE_AORIE 0x4
#define AIE_AORIE_BIT 2
#define AIE_AVBIE_MASK 0x8
#define AIE_AVBIE 0x8
#define AIE_AVBIE_BIT 3
#define AIE_DVBIR_MASK 0x10
#define AIE_DVBIR 0x10
#define AIE_DVBIR_BIT 4
#define AIE_VIOBIE_MASK 0x20
#define AIE_VIOBIE 0x20
#define AIE_VIOBIE_BIT 5
#define AIE_HFFIE_MASK 0x40
#define AIE_HFFIE 0x40
#define AIE_HFFIE_BIT 6

sfrw ASR = 0xb5;
#define ASR_FLLRY_MASK 0x1
#define ASR_FLLRY 0x1
#define ASR_FLLRY_BIT 0
#define ASR_ADCRY_MASK 0x2
#define ASR_ADCRY 0x2
#define ASR_ADCRY_BIT 1
#define ASR_ADCOV_MASK 0x4
#define ASR_ADCOV 0x4
#define ASR_ADCOV_BIT 2
#define ASR_AVBI_MASK 0x8
#define ASR_AVBI 0x8
#define ASR_AVBI_BIT 3
#define ASR_DVBI_MASK 0x10
#define ASR_DVBI 0x10
#define ASR_DVBI_BIT 4
#define ASR_VIOBI_MASK 0x20
#define ASR_VIOBI 0x20
#define ASR_VIOBI_BIT 5
#define ASR_HFFINT_MASK 0x40
#define ASR_HFFINT 0x40
#define ASR_HFFINT_BIT 6
#define ASR_XHFRY_MASK 0x800
#define ASR_XHFRY 0x800
#define ASR_XHFRY_BIT 11
#define ASR_X32RY_MASK 0x1000
#define ASR_X32RY 0x1000
#define ASR_X32RY_BIT 12
#define ASR_AVLVL_MASK 0x2000
#define ASR_AVLVL 0x2000
#define ASR_AVLVL_BIT 13
#define ASR_DVLVL_MASK 0x4000
#define ASR_DVLVL 0x4000
#define ASR_DVLVL_BIT 14
#define ASR_VIOLVL_MASK 0x8000
#define ASR_VIOLVL 0x8000
#define ASR_VIOLVL_BIT 15

sfrw OSCC = 0xc5;
#define OSCC_FLLE_MASK 0x1
#define OSCC_FLLE 0x1
#define OSCC_FLLE_BIT 0
#define OSCC_RCE_MASK 0x2
#define OSCC_RCE 0x2
#define OSCC_RCE_BIT 1
#define OSCC_EXTHF_MASK 0x4
#define OSCC_EXTHF 0x4
#define OSCC_EXTHF_BIT 2
#define OSCC_X32E_MASK 0x8
#define OSCC_X32E 0x8
#define OSCC_X32E_BIT 3
#define OSCC_EXT32K_MASK 0x10
#define OSCC_EXT32K 0x10
#define OSCC_EXT32K_BIT 4
#define OSCC_ADCCD0_MASK 0x20
#define OSCC_ADCCD0 0x20
#define OSCC_ADCCD0_BIT 5
#define OSCC_ADCCD1_MASK 0x40
#define OSCC_ADCCD1 0x40
#define OSCC_ADCCD1_BIT 6
#define OSCC_ADCCD2_MASK 0x80
#define OSCC_ADCCD2 0x80
#define OSCC_ADCCD2_BIT 7
#define OSCC_HFIC0_MASK 0x100
#define OSCC_HFIC0 0x100
#define OSCC_HFIC0_BIT 8
#define OSCC_HFIC1_MASK 0x200
#define OSCC_HFIC1 0x200
#define OSCC_HFIC1_BIT 9
#define OSCC_HFOC0_MASK 0x400
#define OSCC_HFOC0 0x400
#define OSCC_HFOC0_BIT 10
#define OSCC_HFOC1_MASK 0x800
#define OSCC_HFOC1 0x800
#define OSCC_HFOC1_BIT 11


#endif
