// Copyright (c) 2006 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef maxq3120_h
#define maxq3120_h

sfrb RTRM = 0x180;

sfrw RCNT = 0x190;
#define RCNT_RTCE_MASK 0x1
#define RCNT_RTCE 0x1
#define RCNT_RTCE_BIT 0
#define RCNT_ADE_MASK 0x2
#define RCNT_ADE 0x2
#define RCNT_ADE_BIT 1
#define RCNT_ASE_MASK 0x4
#define RCNT_ASE 0x4
#define RCNT_ASE_BIT 2
#define RCNT_BUSY_MASK 0x8
#define RCNT_BUSY 0x8
#define RCNT_BUSY_BIT 3
#define RCNT_RDY_MASK 0x10
#define RCNT_RDY 0x10
#define RCNT_RDY_BIT 4
#define RCNT_RDYE_MASK 0x20
#define RCNT_RDYE 0x20
#define RCNT_RDYE_BIT 5
#define RCNT_ALDF_MASK 0x40
#define RCNT_ALDF 0x40
#define RCNT_ALDF_BIT 6
#define RCNT_ALSF_MASK 0x80
#define RCNT_ALSF 0x80
#define RCNT_ALSF_BIT 7
#define RCNT_SQE_MASK 0x100
#define RCNT_SQE 0x100
#define RCNT_SQE_BIT 8
#define RCNT_FT_MASK 0x200
#define RCNT_FT 0x200
#define RCNT_FT_BIT 9
#define RCNT_WE_MASK 0x8000
#define RCNT_WE 0x8000
#define RCNT_WE_BIT 15

sfrb RTSS = 0x1a0;

sfrw RTSH = 0x1b0;

sfrw RTSL = 0x1c0;

sfrw RSSA = 0x1d0;

sfrb RASH = 0x1e0;

sfrw RASL = 0x1f0;

sfrb MCNT = 0x3;
#define MCNT_SUS_MASK 0x1
#define MCNT_SUS 0x1
#define MCNT_SUS_BIT 0
#define MCNT_MMAC_MASK 0x2
#define MCNT_MMAC 0x2
#define MCNT_MMAC_BIT 1
#define MCNT_MSUB_MASK 0x4
#define MCNT_MSUB 0x4
#define MCNT_MSUB_BIT 2
#define MCNT_OPCS_MASK 0x8
#define MCNT_OPCS 0x8
#define MCNT_OPCS_BIT 3
#define MCNT_SQU_MASK 0x10
#define MCNT_SQU 0x10
#define MCNT_SQU_BIT 4
#define MCNT_CLD_MASK 0x20
#define MCNT_CLD 0x20
#define MCNT_CLD_BIT 5
#define MCNT_MCW_MASK 0x40
#define MCNT_MCW 0x40
#define MCNT_MCW_BIT 6
#define MCNT_OF_MASK 0x80
#define MCNT_OF 0x80
#define MCNT_OF_BIT 7

sfrw MA = 0x13;

sfrw MB = 0x23;

sfrw MC2 = 0x33;

sfrw MC1 = 0x43;

sfrw MC0 = 0x53;

sfrw MC1R = 0xb3;

sfrw MC0R = 0xc3;

sfrb PO0 = 0x0;

sfrb PO1 = 0x10;

sfrb PO2 = 0x20;

sfrb PO3 = 0x30;

sfrb EIF0 = 0x60;
#define EIF0_IE0_MASK 0x1
#define EIF0_IE0 0x1
#define EIF0_IE0_BIT 0
#define EIF0_IE1_MASK 0x2
#define EIF0_IE1 0x2
#define EIF0_IE1_BIT 1
#define EIF0_IE2_MASK 0x4
#define EIF0_IE2 0x4
#define EIF0_IE2_BIT 2
#define EIF0_IE3_MASK 0x8
#define EIF0_IE3 0x8
#define EIF0_IE3_BIT 3
#define EIF0_IE4_MASK 0x10
#define EIF0_IE4 0x10
#define EIF0_IE4_BIT 4
#define EIF0_IE5_MASK 0x20
#define EIF0_IE5 0x20
#define EIF0_IE5_BIT 5
#define EIF0_IE6_MASK 0x40
#define EIF0_IE6 0x40
#define EIF0_IE6_BIT 6
#define EIF0_IE7_MASK 0x80
#define EIF0_IE7 0x80
#define EIF0_IE7_BIT 7

sfrb EIE0 = 0x70;
#define EIE0_EX0_MASK 0x1
#define EIE0_EX0 0x1
#define EIE0_EX0_BIT 0
#define EIE0_EX1_MASK 0x2
#define EIE0_EX1 0x2
#define EIE0_EX1_BIT 1
#define EIE0_EX2_MASK 0x4
#define EIE0_EX2 0x4
#define EIE0_EX2_BIT 2
#define EIE0_EX3_MASK 0x8
#define EIE0_EX3 0x8
#define EIE0_EX3_BIT 3
#define EIE0_EX4_MASK 0x10
#define EIE0_EX4 0x10
#define EIE0_EX4_BIT 4
#define EIE0_EX5_MASK 0x20
#define EIE0_EX5 0x20
#define EIE0_EX5_BIT 5
#define EIE0_EX6_MASK 0x40
#define EIE0_EX6 0x40
#define EIE0_EX6_BIT 6
#define EIE0_EX7_MASK 0x80
#define EIE0_EX7 0x80
#define EIE0_EX7_BIT 7

sfrb PI0 = 0x80;

sfrb PI1 = 0x90;

sfrb PI2 = 0xa0;

sfrb PI3 = 0xb0;

sfrb EIES0 = 0xc0;
#define EIES0_IT0_MASK 0x1
#define EIES0_IT0 0x1
#define EIES0_IT0_BIT 0
#define EIES0_IT1_MASK 0x2
#define EIES0_IT1 0x2
#define EIES0_IT1_BIT 1
#define EIES0_IT2_MASK 0x4
#define EIES0_IT2 0x4
#define EIES0_IT2_BIT 2
#define EIES0_IT3_MASK 0x8
#define EIES0_IT3 0x8
#define EIES0_IT3_BIT 3
#define EIES0_IT4_MASK 0x10
#define EIES0_IT4 0x10
#define EIES0_IT4_BIT 4
#define EIES0_IT5_MASK 0x20
#define EIES0_IT5 0x20
#define EIES0_IT5_BIT 5
#define EIES0_IT6_MASK 0x40
#define EIES0_IT6 0x40
#define EIES0_IT6_BIT 6
#define EIES0_IT7_MASK 0x80
#define EIES0_IT7 0x80
#define EIES0_IT7_BIT 7

sfrb PD0 = 0x100;

sfrb PD1 = 0x110;

sfrb PD2 = 0x120;

sfrb PD3 = 0x130;

sfrb T0CN = 0x1;
#define T0CN_M0_MASK 0x1
#define T0CN_M0 0x1
#define T0CN_M0_BIT 0
#define T0CN_M1_MASK 0x2
#define T0CN_M1 0x2
#define T0CN_M1_BIT 1
#define T0CN_CT_MASK 0x4
#define T0CN_CT 0x4
#define T0CN_CT_BIT 2
#define T0CN_GATE_MASK 0x8
#define T0CN_GATE 0x8
#define T0CN_GATE_BIT 3
#define T0CN_TR0_MASK 0x10
#define T0CN_TR0 0x10
#define T0CN_TR0_BIT 4
#define T0CN_TF0_MASK 0x20
#define T0CN_TF0 0x20
#define T0CN_TF0_BIT 5
#define T0CN_T0M_MASK 0x40
#define T0CN_T0M 0x40
#define T0CN_T0M_BIT 6
#define T0CN_ET0_MASK 0x80
#define T0CN_ET0 0x80
#define T0CN_ET0_BIT 7

sfrb T0L = 0x11;

sfrb T0H = 0x21;

sfrb T1CN = 0x2;
#define T1CN_CPRL1_MASK 0x1
#define T1CN_CPRL1 0x1
#define T1CN_CPRL1_BIT 0
#define T1CN_CT1_MASK 0x2
#define T1CN_CT1 0x2
#define T1CN_CT1_BIT 1
#define T1CN_TR1_MASK 0x4
#define T1CN_TR1 0x4
#define T1CN_TR1_BIT 2
#define T1CN_EXEN1_MASK 0x8
#define T1CN_EXEN1 0x8
#define T1CN_EXEN1_BIT 3
#define T1CN_DCEN_MASK 0x10
#define T1CN_DCEN 0x10
#define T1CN_DCEN_BIT 4
#define T1CN_T1OE_MASK 0x20
#define T1CN_T1OE 0x20
#define T1CN_T1OE_BIT 5
#define T1CN_EXF1_MASK 0x40
#define T1CN_EXF1 0x40
#define T1CN_EXF1_BIT 6
#define T1CN_TF1_MASK 0x80
#define T1CN_TF1 0x80
#define T1CN_TF1_BIT 7

sfrb T1L = 0x12;

sfrb T1H = 0x22;

sfrb T1CL = 0x82;

sfrb T1CH = 0x92;

sfrb T1MD = 0xa2;
#define T1MD_T1M_MASK 0x1
#define T1MD_T1M 0x1
#define T1MD_T1M_BIT 0
#define T1MD_ET1_MASK 0x2
#define T1MD_ET1 0x2
#define T1MD_ET1_BIT 1

sfrb T2CNA = 0x32;
#define T2CNA_G2EN_MASK 0x1
#define T2CNA_G2EN 0x1
#define T2CNA_G2EN_BIT 0
#define T2CNA_SS2_MASK 0x2
#define T2CNA_SS2 0x2
#define T2CNA_SS2_BIT 1
#define T2CNA_CPRL2_MASK 0x4
#define T2CNA_CPRL2 0x4
#define T2CNA_CPRL2_BIT 2
#define T2CNA_TR2_MASK 0x8
#define T2CNA_TR2 0x8
#define T2CNA_TR2_BIT 3
#define T2CNA_TR2L_MASK 0x10
#define T2CNA_TR2L 0x10
#define T2CNA_TR2L_BIT 4
#define T2CNA_T2POL0_MASK 0x20
#define T2CNA_T2POL0 0x20
#define T2CNA_T2POL0_BIT 5
#define T2CNA_T2OE0_MASK 0x40
#define T2CNA_T2OE0 0x40
#define T2CNA_T2OE0_BIT 6
#define T2CNA_ET2_MASK 0x80
#define T2CNA_ET2 0x80
#define T2CNA_ET2_BIT 7

sfrb T2H = 0x42;

sfrb T2RH = 0x52;

sfrb T2CH = 0x62;

sfrb IRCN = 0x72;
#define IRCN_IRBB_MASK 0x1
#define IRCN_IRBB 0x1
#define IRCN_IRBB_BIT 0
#define IRCN_IRTX_MASK 0x2
#define IRCN_IRTX 0x2
#define IRCN_IRTX_BIT 1
#define IRCN_IREN_MASK 0x4
#define IRCN_IREN 0x4
#define IRCN_IREN_BIT 2

sfrb T2CNB = 0xb2;
#define T2CNB_TC2L_MASK 0x1
#define T2CNB_TC2L 0x1
#define T2CNB_TC2L_BIT 0
#define T2CNB_TF2L_MASK 0x2
#define T2CNB_TF2L 0x2
#define T2CNB_TF2L_BIT 1
#define T2CNB_TCC2_MASK 0x4
#define T2CNB_TCC2 0x4
#define T2CNB_TCC2_BIT 2
#define T2CNB_TF2_MASK 0x8
#define T2CNB_TF2 0x8
#define T2CNB_TF2_BIT 3
#define T2CNB_T2POL1_MASK 0x20
#define T2CNB_T2POL1 0x20
#define T2CNB_T2POL1_BIT 5
#define T2CNB_T2OE1_MASK 0x40
#define T2CNB_T2OE1 0x40
#define T2CNB_T2OE1_BIT 6
#define T2CNB_ET2L_MASK 0x80
#define T2CNB_ET2L 0x80
#define T2CNB_ET2L_BIT 7

sfrw T2V = 0xc2;

sfrw T2R = 0xd2;

sfrw T2C = 0xe2;

sfrb T2CFG = 0xf2;
#define T2CFG_CT2_MASK 0x1
#define T2CFG_CT2 0x1
#define T2CFG_CT2_BIT 0
#define T2CFG_CCF0_MASK 0x2
#define T2CFG_CCF0 0x2
#define T2CFG_CCF0_BIT 1
#define T2CFG_CCF1_MASK 0x4
#define T2CFG_CCF1 0x4
#define T2CFG_CCF1_BIT 2
#define T2CFG_T2MD_MASK 0x8
#define T2CFG_T2MD 0x8
#define T2CFG_T2MD_BIT 3
#define T2CFG_DIV0_MASK 0x10
#define T2CFG_DIV0 0x10
#define T2CFG_DIV0_BIT 4
#define T2CFG_DIV1_MASK 0x20
#define T2CFG_DIV1 0x20
#define T2CFG_DIV1_BIT 5
#define T2CFG_DIV2_MASK 0x40
#define T2CFG_DIV2 0x40
#define T2CFG_DIV2_BIT 6
#define T2CFG_T2CI_MASK 0x80
#define T2CFG_T2CI 0x80
#define T2CFG_T2CI_BIT 7

sfrb SCON0 = 0x31;
#define SCON0_RI0_MASK 0x1
#define SCON0_RI0 0x1
#define SCON0_RI0_BIT 0
#define SCON0_TI0_MASK 0x2
#define SCON0_TI0 0x2
#define SCON0_TI0_BIT 1
#define SCON0_RB80_MASK 0x4
#define SCON0_RB80 0x4
#define SCON0_RB80_BIT 2
#define SCON0_TB80_MASK 0x8
#define SCON0_TB80 0x8
#define SCON0_TB80_BIT 3
#define SCON0_REN0_MASK 0x10
#define SCON0_REN0 0x10
#define SCON0_REN0_BIT 4
#define SCON0_SM20_MASK 0x20
#define SCON0_SM20 0x20
#define SCON0_SM20_BIT 5
#define SCON0_SM10_MASK 0x40
#define SCON0_SM10 0x40
#define SCON0_SM10_BIT 6
#define SCON0_SM00_MASK 0x80
#define SCON0_SM00 0x80
#define SCON0_SM00_BIT 7
#define SCON0_FE0_MASK 0x80
#define SCON0_FE0 0x80
#define SCON0_FE0_BIT 7

sfrb SBUF0 = 0x41;

sfrb SMD0 = 0x91;
#define SMD0_FEDE0_MASK 0x1
#define SMD0_FEDE0 0x1
#define SMD0_FEDE0_BIT 0
#define SMD0_SMOD0_MASK 0x2
#define SMD0_SMOD0 0x2
#define SMD0_SMOD0_BIT 1
#define SMD0_ESI0_MASK 0x4
#define SMD0_ESI0 0x4
#define SMD0_ESI0_BIT 2
#define SMD0_OFS_MASK 0x40
#define SMD0_OFS 0x40
#define SMD0_OFS_BIT 6
#define SMD0_EPWM_MASK 0x4
#define SMD0_EPWM 0x4
#define SMD0_EPWM_BIT 2

sfrw PR0 = 0xa1;

sfrb SCON1 = 0x51;
#define SCON1_RI1_MASK 0x1
#define SCON1_RI1 0x1
#define SCON1_RI1_BIT 0
#define SCON1_TI1_MASK 0x2
#define SCON1_TI1 0x2
#define SCON1_TI1_BIT 1
#define SCON1_RB81_MASK 0x4
#define SCON1_RB81 0x4
#define SCON1_RB81_BIT 2
#define SCON1_TB81_MASK 0x8
#define SCON1_TB81 0x8
#define SCON1_TB81_BIT 3
#define SCON1_REN1_MASK 0x10
#define SCON1_REN1 0x10
#define SCON1_REN1_BIT 4
#define SCON1_SM21_MASK 0x20
#define SCON1_SM21 0x20
#define SCON1_SM21_BIT 5
#define SCON1_SM11_MASK 0x40
#define SCON1_SM11 0x40
#define SCON1_SM11_BIT 6
#define SCON1_SM01_MASK 0x80
#define SCON1_SM01 0x80
#define SCON1_SM01_BIT 7
#define SCON1_FE1_MASK 0x80
#define SCON1_FE1 0x80
#define SCON1_FE1_BIT 7

sfrb SBUF1 = 0x61;

sfrb SMD1 = 0xb1;
#define SMD1_FEDE1_MASK 0x1
#define SMD1_FEDE1 0x1
#define SMD1_FEDE1_BIT 0
#define SMD1_SMOD1_MASK 0x2
#define SMD1_SMOD1 0x2
#define SMD1_SMOD1_BIT 1
#define SMD1_ESI1_MASK 0x4
#define SMD1_ESI1 0x4
#define SMD1_ESI1_BIT 2

sfrw PR1 = 0xc1;

sfrb ICDF = 0x1b1;
#define ICDF_TXC_MASK 0x1
#define ICDF_TXC 0x1
#define ICDF_TXC_BIT 0
#define ICDF_SPE_MASK 0x2
#define ICDF_SPE 0x2
#define ICDF_SPE_BIT 1
#define ICDF_PSS0_MASK 0x4
#define ICDF_PSS0 0x4
#define ICDF_PSS0_BIT 2
#define ICDF_PSS1_MASK 0x8
#define ICDF_PSS1 0x8
#define ICDF_PSS1_BIT 3

sfrb AP = 0x8;

sfrb APC = 0x18;
#define APC_MOD_MASK 0x7
#define APC_MOD_BIT 0
#define APC_IDS_MASK 0x40
#define APC_IDS 0x40
#define APC_IDS_BIT 6
#define APC_CLR_MASK 0x80
#define APC_CLR 0x80
#define APC_CLR_BIT 7

sfrb PSF = 0x48;
#define PSF_E_MASK 0x1
#define PSF_E 0x1
#define PSF_E_BIT 0
#define PSF_C_MASK 0x2
#define PSF_C 0x2
#define PSF_C_BIT 1
#define PSF_OV_MASK 0x4
#define PSF_OV 0x4
#define PSF_OV_BIT 2
#define PSF_GPF0_MASK 0x8
#define PSF_GPF0 0x8
#define PSF_GPF0_BIT 3
#define PSF_GPF1_MASK 0x10
#define PSF_GPF1 0x10
#define PSF_GPF1_BIT 4
#define PSF_S_MASK 0x40
#define PSF_S 0x40
#define PSF_S_BIT 6
#define PSF_Z_MASK 0x80
#define PSF_Z 0x80
#define PSF_Z_BIT 7

sfrb IC = 0x58;
#define IC_IGE_MASK 0x1
#define IC_IGE 0x1
#define IC_IGE_BIT 0
#define IC_INS_MASK 0x2
#define IC_INS 0x2
#define IC_INS_BIT 1
#define IC_CGDS_MASK 0x20
#define IC_CGDS 0x20
#define IC_CGDS_BIT 5

sfrb IMR = 0x68;
#define IMR_IM0_MASK 0x1
#define IMR_IM0 0x1
#define IMR_IM0_BIT 0
#define IMR_IM1_MASK 0x2
#define IMR_IM1 0x2
#define IMR_IM1_BIT 1
#define IMR_IM2_MASK 0x4
#define IMR_IM2 0x4
#define IMR_IM2_BIT 2
#define IMR_IM3_MASK 0x8
#define IMR_IM3 0x8
#define IMR_IM3_BIT 3
#define IMR_IM4_MASK 0x10
#define IMR_IM4 0x10
#define IMR_IM4_BIT 4
#define IMR_IM5_MASK 0x20
#define IMR_IM5 0x20
#define IMR_IM5_BIT 5
#define IMR_IMS_MASK 0x80
#define IMR_IMS 0x80
#define IMR_IMS_BIT 7

sfrb SC = 0x88;
#define SC_PWL_MASK 0x2
#define SC_PWL 0x2
#define SC_PWL_BIT 1
#define SC_ROD_MASK 0x4
#define SC_ROD 0x4
#define SC_ROD_BIT 2
#define SC_UPA_MASK 0x8
#define SC_UPA 0x8
#define SC_UPA_BIT 3
#define SC_CDA_MASK 0x30
#define SC_CDA_BIT 4
#define SC_TAP_MASK 0x180
#define SC_TAP_BIT 7

sfrb IIR = 0xb8;
#define IIR_II0_MASK 0x1
#define IIR_II0 0x1
#define IIR_II0_BIT 0
#define IIR_II1_MASK 0x2
#define IIR_II1 0x2
#define IIR_II1_BIT 1
#define IIR_II2_MASK 0x4
#define IIR_II2 0x4
#define IIR_II2_BIT 2
#define IIR_II3_MASK 0x8
#define IIR_II3 0x8
#define IIR_II3_BIT 3
#define IIR_II4_MASK 0x10
#define IIR_II4 0x10
#define IIR_II4_BIT 4
#define IIR_II5_MASK 0x20
#define IIR_II5 0x20
#define IIR_II5_BIT 5
#define IIR_IIS_MASK 0x80
#define IIR_IIS 0x80
#define IIR_IIS_BIT 7

sfrb CKCN = 0xe8;
#define CKCN_CD_MASK 0x3
#define CKCN_CD_BIT 0
#define CKCN_PMME_MASK 0x4
#define CKCN_PMME 0x4
#define CKCN_PMME_BIT 2
#define CKCN_SWB_MASK 0x8
#define CKCN_SWB 0x8
#define CKCN_SWB_BIT 3
#define CKCN_STOP_MASK 0x10
#define CKCN_STOP 0x10
#define CKCN_STOP_BIT 4
#define CKCN_RGMD_MASK 0x20
#define CKCN_RGMD 0x20
#define CKCN_RGMD_BIT 5
#define CKCN_RGSL_MASK 0x40
#define CKCN_RGSL 0x40
#define CKCN_RGSL_BIT 6
#define CKCN_XT_NOT_RC_MASK 0x80
#define CKCN_XT_NOT_RC 0x80
#define CKCN_XT_NOT_RC_BIT 7

sfrb WDCN = 0xf8;
#define WDCN_RWT_MASK 0x1
#define WDCN_RWT 0x1
#define WDCN_RWT_BIT 0
#define WDCN_EWT_MASK 0x2
#define WDCN_EWT 0x2
#define WDCN_EWT_BIT 1
#define WDCN_WTRF_MASK 0x4
#define WDCN_WTRF 0x4
#define WDCN_WTRF_BIT 2
#define WDCN_WDIF_MASK 0x8
#define WDCN_WDIF 0x8
#define WDCN_WDIF_BIT 3
#define WDCN_WD_MASK 0x30
#define WDCN_WD_BIT 4
#define WDCN_EWDI_MASK 0x40
#define WDCN_EWDI 0x40
#define WDCN_EWDI_BIT 6
#define WDCN_POR_MASK 0x80
#define WDCN_POR 0x80
#define WDCN_POR_BIT 7

sfrw A_0 = 0x9;

sfrw A_1 = 0x19;

sfrw A_2 = 0x29;

sfrw A_3 = 0x39;

sfrw A_4 = 0x49;

sfrw A_5 = 0x59;

sfrw A_6 = 0x69;

sfrw A_7 = 0x79;

sfrw A_8 = 0x89;

sfrw A_9 = 0x99;

sfrw A_10 = 0xa9;

sfrw A_11 = 0xb9;

sfrw A_12 = 0xc9;

sfrw A_13 = 0xd9;

sfrw A_14 = 0xe9;

sfrw A_15 = 0xf9;

sfrw PFX_0 = 0xb;

sfrw IP = 0xc;

sfrw SP = 0x1d;

sfrw IV = 0x2d;

sfrw LC_0 = 0x6d;

sfrw LC_1 = 0x7d;

sfrb OFFS = 0x3e;

sfrw DPC = 0x4e;
#define DPC_SDPS_MASK 0x3
#define DPC_SDPS_BIT 0
#define DPC_WBSO_MASK 0x4
#define DPC_WBSO 0x4
#define DPC_WBSO_BIT 2
#define DPC_WBS1_MASK 0x8
#define DPC_WBS1 0x8
#define DPC_WBS1_BIT 3
#define DPC_WBS2_MASK 0x10
#define DPC_WBS2 0x10
#define DPC_WBS2_BIT 4

sfrw GR = 0x5e;

sfrb GRL = 0x6e;

sfrw BP = 0x7e;

sfrw GRS = 0x8e;

sfrb GRH = 0x9e;

sfrw GRXL = 0xae;

sfrw FP = 0xbe;

sfrw DP_0 = 0x3f;

sfrw DP_1 = 0x7f;

sfrw LCRA = 0xd3;
#define LCRA_LRA0_MASK 0x1
#define LCRA_LRA0 0x1
#define LCRA_LRA0_BIT 0
#define LCRA_LRA1_MASK 0x2
#define LCRA_LRA1 0x2
#define LCRA_LRA1_BIT 1
#define LCRA_LRA2_MASK 0x4
#define LCRA_LRA2 0x4
#define LCRA_LRA2_BIT 2
#define LCRA_LRA3_MASK 0x8
#define LCRA_LRA3 0x8
#define LCRA_LRA3_BIT 3
#define LCRA_LRIG_MASK 0x20
#define LCRA_LRIG 0x20
#define LCRA_LRIG_BIT 5
#define LCRA_LCCS_MASK 0x40
#define LCRA_LCCS 0x40
#define LCRA_LCCS_BIT 6
#define LCRA_FRM0_MASK 0x80
#define LCRA_FRM0 0x80
#define LCRA_FRM0_BIT 7
#define LCRA_FRM1_MASK 0x100
#define LCRA_FRM1 0x100
#define LCRA_FRM1_BIT 8
#define LCRA_FRM2_MASK 0x200
#define LCRA_FRM2 0x200
#define LCRA_FRM2_BIT 9
#define LCRA_FRM3_MASK 0x400
#define LCRA_FRM3 0x400
#define LCRA_FRM3_BIT 10
#define LCRA_DUTY0_MASK 0x800
#define LCRA_DUTY0 0x800
#define LCRA_DUTY0_BIT 11
#define LCRA_DUTY1_MASK 0x1000
#define LCRA_DUTY1 0x1000
#define LCRA_DUTY1_BIT 12

sfrb LCFG = 0xe3;
#define LCFG_DPE_MASK 0x1
#define LCFG_DPE 0x1
#define LCFG_DPE_BIT 0
#define LCFG_OPM_MASK 0x2
#define LCFG_OPM 0x2
#define LCFG_OPM_BIT 1
#define LCFG_PCF0_MASK 0x10
#define LCFG_PCF0 0x10
#define LCFG_PCF0_BIT 4
#define LCFG_PCF1_MASK 0x20
#define LCFG_PCF1 0x20
#define LCFG_PCF1_BIT 5
#define LCFG_PCF2_MASK 0x40
#define LCFG_PCF2 0x40
#define LCFG_PCF2_BIT 6
#define LCFG_PCF3_MASK 0x80
#define LCFG_PCF3 0x80
#define LCFG_PCF3_BIT 7

sfrb LCD0 = 0x103;

sfrb LCD1 = 0x113;

sfrb LCD2 = 0x123;

sfrb LCD3 = 0x133;

sfrb LCD4 = 0x143;

sfrb LCD5 = 0x153;

sfrb LCD6 = 0x163;

sfrb LCD7 = 0x173;

sfrb LCD8 = 0x183;

sfrb LCD9 = 0x193;

sfrb LCD10 = 0x1a3;

sfrb LCD11 = 0x1b3;

sfrb LCD12 = 0x1c3;

sfrb LCD13 = 0x1d3;

sfrb FCNTL = 0x1e0;
#define FCNTL_CF1_MASK 0x2
#define FCNTL_CF1 0x2
#define FCNTL_CF1_BIT 1
#define FCNTL_CF2_MASK 0x4
#define FCNTL_CF2 0x4
#define FCNTL_CF2_BIT 2
#define FCNTL_DQ5_MASK 0x8
#define FCNTL_DQ5 0x8
#define FCNTL_DQ5_BIT 3
#define FCNTL_FBYP_MASK 0x10
#define FCNTL_FBYP 0x10
#define FCNTL_FBYP_BIT 4
#define FCNTL_FINE_MASK 0x20
#define FCNTL_FINE 0x20
#define FCNTL_FINE_BIT 5
#define FCNTL_FERR_MASK 0x40
#define FCNTL_FERR 0x40
#define FCNTL_FERR_BIT 6
#define FCNTL_FBUSY_MASK 0x80
#define FCNTL_FBUSY 0x80
#define FCNTL_FBUSY_BIT 7

sfrw FDATA = 0x1f0;

sfrw ADCN = 0x83;
#define ADCN_ASR0_MASK 0x1
#define ADCN_ASR0 0x1
#define ADCN_ASR0_BIT 0
#define ADCN_ASR1_MASK 0x2
#define ADCN_ASR1 0x2
#define ADCN_ASR1_BIT 1
#define ADCN_ASL0_MASK 0x4
#define ADCN_ASL0 0x4
#define ADCN_ASL0_BIT 2
#define ADCN_ASL1_MASK 0x8
#define ADCN_ASL1 0x8
#define ADCN_ASL1_BIT 3
#define ADCN_EDCI_MASK 0x40
#define ADCN_EDCI 0x40
#define ADCN_EDCI_BIT 6
#define ADCN_APSE_MASK 0x80
#define ADCN_APSE 0x80
#define ADCN_APSE_BIT 7
#define ADCN_APD0_MASK 0x100
#define ADCN_APD0 0x100
#define ADCN_APD0_BIT 8
#define ADCN_APD1_MASK 0x200
#define ADCN_APD1 0x200
#define ADCN_APD1_BIT 9
#define ADCN_APD2_MASK 0x400
#define ADCN_APD2 0x400
#define ADCN_APD2_BIT 10
#define ADCN_G0_MASK 0x1000
#define ADCN_G0 0x1000
#define ADCN_G0_BIT 12
#define ADCN_G1_MASK 0x2000
#define ADCN_G1 0x2000
#define ADCN_G1_BIT 13
#define ADCN_G2_MASK 0x4000
#define ADCN_G2 0x4000
#define ADCN_G2_BIT 14
#define ADCN_G3_MASK 0x8000
#define ADCN_G3 0x8000
#define ADCN_G3_BIT 15

sfrw PHC = 0x93;

sfrw ADC0 = 0xa3;

sfrw ADC1 = 0xb3;

sfrb ATRM = 0xc3;


#endif
