// Copyright (c) 2006 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef maxq2000_h
#define maxq2000_h

sfrw RCNT = 0x190;
#define RCNT_RTCE_MASK 0x1
#define RCNT_RTCE 0x1
#define RCNT_RTCE_BIT 0
#define RCNT_ADE_MASK 0x2
#define RCNT_ADE 0x2
#define RCNT_ADE_BIT 1
#define RCNT_ASE_MASK 0x4
#define RCNT_ASE 0x4
#define RCNT_ASE_BIT 2
#define RCNT_BUSY_MASK 0x8
#define RCNT_BUSY 0x8
#define RCNT_BUSY_BIT 3
#define RCNT_RDY_MASK 0x10
#define RCNT_RDY 0x10
#define RCNT_RDY_BIT 4
#define RCNT_RDYE_MASK 0x20
#define RCNT_RDYE 0x20
#define RCNT_RDYE_BIT 5
#define RCNT_ALDF_MASK 0x40
#define RCNT_ALDF 0x40
#define RCNT_ALDF_BIT 6
#define RCNT_ALSF_MASK 0x80
#define RCNT_ALSF 0x80
#define RCNT_ALSF_BIT 7
#define RCNT_ACS_MASK 0x2000
#define RCNT_ACS 0x2000
#define RCNT_ACS_BIT 13
#define RCNT_X32D_MASK 0x4000
#define RCNT_X32D 0x4000
#define RCNT_X32D_BIT 14
#define RCNT_WE_MASK 0x8000
#define RCNT_WE 0x8000
#define RCNT_WE_BIT 15

sfrb RTSS = 0x1a0;

sfrw RTSH = 0x1b0;

sfrw RTSL = 0x1c0;

sfrw RSSA = 0x1d0;

sfrb RASH = 0x1e0;

sfrw RASL = 0x1f0;

sfrb MCNT = 0x2;
#define MCNT_SUS_MASK 0x1
#define MCNT_SUS 0x1
#define MCNT_SUS_BIT 0
#define MCNT_MMAC_MASK 0x2
#define MCNT_MMAC 0x2
#define MCNT_MMAC_BIT 1
#define MCNT_MSUB_MASK 0x4
#define MCNT_MSUB 0x4
#define MCNT_MSUB_BIT 2
#define MCNT_OPCS_MASK 0x8
#define MCNT_OPCS 0x8
#define MCNT_OPCS_BIT 3
#define MCNT_SQU_MASK 0x10
#define MCNT_SQU 0x10
#define MCNT_SQU_BIT 4
#define MCNT_CLD_MASK 0x20
#define MCNT_CLD 0x20
#define MCNT_CLD_BIT 5
#define MCNT_MCW_MASK 0x40
#define MCNT_MCW 0x40
#define MCNT_MCW_BIT 6
#define MCNT_OF_MASK 0x80
#define MCNT_OF 0x80
#define MCNT_OF_BIT 7

sfrw MA = 0x12;

sfrw MB = 0x22;

sfrw MC2 = 0x32;

sfrw MC1 = 0x42;

sfrw MC0 = 0x52;

sfrw MC1R = 0xb2;

sfrw MC0R = 0xc2;

sfrb PO0 = 0x0;

sfrb PO1 = 0x10;

sfrb PO2 = 0x20;

sfrb PO3 = 0x30;

sfrb EIF0 = 0x60;
#define EIF0_IE0_MASK 0x1
#define EIF0_IE0 0x1
#define EIF0_IE0_BIT 0
#define EIF0_IE1_MASK 0x2
#define EIF0_IE1 0x2
#define EIF0_IE1_BIT 1
#define EIF0_IE2_MASK 0x4
#define EIF0_IE2 0x4
#define EIF0_IE2_BIT 2
#define EIF0_IE3_MASK 0x8
#define EIF0_IE3 0x8
#define EIF0_IE3_BIT 3
#define EIF0_IE4_MASK 0x10
#define EIF0_IE4 0x10
#define EIF0_IE4_BIT 4
#define EIF0_IE5_MASK 0x20
#define EIF0_IE5 0x20
#define EIF0_IE5_BIT 5
#define EIF0_IE6_MASK 0x40
#define EIF0_IE6 0x40
#define EIF0_IE6_BIT 6
#define EIF0_IE7_MASK 0x80
#define EIF0_IE7 0x80
#define EIF0_IE7_BIT 7

sfrb EIE0 = 0x70;
#define EIE0_EX0_MASK 0x1
#define EIE0_EX0 0x1
#define EIE0_EX0_BIT 0
#define EIE0_EX1_MASK 0x2
#define EIE0_EX1 0x2
#define EIE0_EX1_BIT 1
#define EIE0_EX2_MASK 0x4
#define EIE0_EX2 0x4
#define EIE0_EX2_BIT 2
#define EIE0_EX3_MASK 0x8
#define EIE0_EX3 0x8
#define EIE0_EX3_BIT 3
#define EIE0_EX4_MASK 0x10
#define EIE0_EX4 0x10
#define EIE0_EX4_BIT 4
#define EIE0_EX5_MASK 0x20
#define EIE0_EX5 0x20
#define EIE0_EX5_BIT 5
#define EIE0_EX6_MASK 0x40
#define EIE0_EX6 0x40
#define EIE0_EX6_BIT 6
#define EIE0_EX7_MASK 0x80
#define EIE0_EX7 0x80
#define EIE0_EX7_BIT 7

sfrb PI0 = 0x80;

sfrb PI1 = 0x90;

sfrb PI2 = 0xa0;

sfrb PI3 = 0xb0;

sfrb EIES0 = 0xc0;
#define EIES0_IT0_MASK 0x1
#define EIES0_IT0 0x1
#define EIES0_IT0_BIT 0
#define EIES0_IT1_MASK 0x2
#define EIES0_IT1 0x2
#define EIES0_IT1_BIT 1
#define EIES0_IT2_MASK 0x4
#define EIES0_IT2 0x4
#define EIES0_IT2_BIT 2
#define EIES0_IT3_MASK 0x8
#define EIES0_IT3 0x8
#define EIES0_IT3_BIT 3
#define EIES0_IT4_MASK 0x10
#define EIES0_IT4 0x10
#define EIES0_IT4_BIT 4
#define EIES0_IT5_MASK 0x20
#define EIES0_IT5 0x20
#define EIES0_IT5_BIT 5
#define EIES0_IT6_MASK 0x40
#define EIES0_IT6 0x40
#define EIES0_IT6_BIT 6
#define EIES0_IT7_MASK 0x80
#define EIES0_IT7 0x80
#define EIES0_IT7_BIT 7

sfrb PD0 = 0x100;

sfrb PD1 = 0x110;

sfrb PD2 = 0x120;

sfrb PD3 = 0x130;

sfrb PO4 = 0x1;

sfrb PO5 = 0x11;

sfrb PO6 = 0x21;

sfrb PO7 = 0x31;

sfrb EIF1 = 0x61;
#define EIF1_IE8_MASK 0x1
#define EIF1_IE8 0x1
#define EIF1_IE8_BIT 0
#define EIF1_IE9_MASK 0x2
#define EIF1_IE9 0x2
#define EIF1_IE9_BIT 1
#define EIF1_IE10_MASK 0x4
#define EIF1_IE10 0x4
#define EIF1_IE10_BIT 2
#define EIF1_IE11_MASK 0x8
#define EIF1_IE11 0x8
#define EIF1_IE11_BIT 3
#define EIF1_IE12_MASK 0x10
#define EIF1_IE12 0x10
#define EIF1_IE12_BIT 4
#define EIF1_IE13_MASK 0x20
#define EIF1_IE13 0x20
#define EIF1_IE13_BIT 5
#define EIF1_IE14_MASK 0x40
#define EIF1_IE14 0x40
#define EIF1_IE14_BIT 6
#define EIF1_IE15_MASK 0x80
#define EIF1_IE15 0x80
#define EIF1_IE15_BIT 7

sfrb EIE1 = 0x71;
#define EIE1_EX8_MASK 0x1
#define EIE1_EX8 0x1
#define EIE1_EX8_BIT 0
#define EIE1_EX9_MASK 0x2
#define EIE1_EX9 0x2
#define EIE1_EX9_BIT 1
#define EIE1_EX10_MASK 0x4
#define EIE1_EX10 0x4
#define EIE1_EX10_BIT 2
#define EIE1_EX11_MASK 0x8
#define EIE1_EX11 0x8
#define EIE1_EX11_BIT 3
#define EIE1_EX12_MASK 0x10
#define EIE1_EX12 0x10
#define EIE1_EX12_BIT 4
#define EIE1_EX13_MASK 0x20
#define EIE1_EX13 0x20
#define EIE1_EX13_BIT 5
#define EIE1_EX14_MASK 0x40
#define EIE1_EX14 0x40
#define EIE1_EX14_BIT 6
#define EIE1_EX15_MASK 0x80
#define EIE1_EX15 0x80
#define EIE1_EX15_BIT 7

sfrb PI4 = 0x81;

sfrb PI5 = 0x91;

sfrb PI6 = 0xa1;

sfrb PI7 = 0xb1;

sfrb EIES1 = 0xc1;
#define EIES1_IT8_MASK 0x1
#define EIES1_IT8 0x1
#define EIES1_IT8_BIT 0
#define EIES1_IT9_MASK 0x2
#define EIES1_IT9 0x2
#define EIES1_IT9_BIT 1
#define EIES1_IT10_MASK 0x4
#define EIES1_IT10 0x4
#define EIES1_IT10_BIT 2
#define EIES1_IT11_MASK 0x8
#define EIES1_IT11 0x8
#define EIES1_IT11_BIT 3
#define EIES1_IT12_MASK 0x10
#define EIES1_IT12 0x10
#define EIES1_IT12_BIT 4
#define EIES1_IT13_MASK 0x20
#define EIES1_IT13 0x20
#define EIES1_IT13_BIT 5
#define EIES1_IT14_MASK 0x40
#define EIES1_IT14 0x40
#define EIES1_IT14_BIT 6
#define EIES1_IT15_MASK 0x80
#define EIES1_IT15 0x80
#define EIES1_IT15_BIT 7

sfrb PD4 = 0x101;

sfrb PD5 = 0x111;

sfrb PD6 = 0x121;

sfrb PD7 = 0x131;

sfrb SVS = 0x1e1;
#define SVS_SV70_MASK 0x1
#define SVS_SV70 0x1
#define SVS_SV70_BIT 0
#define SVS_SV71_MASK 0x2
#define SVS_SV71 0x2
#define SVS_SV71_BIT 1
#define SVS_SV64_MASK 0x10
#define SVS_SV64 0x10
#define SVS_SV64_BIT 4
#define SVS_SV65_MASK 0x20
#define SVS_SV65 0x20
#define SVS_SV65_BIT 5
#define SVS_SV66_MASK 0x40
#define SVS_SV66 0x40
#define SVS_SV66_BIT 6
#define SVS_SV67_MASK 0x80
#define SVS_SV67 0x80
#define SVS_SV67_BIT 7

sfrb WKO = 0x1f1;
#define WKO_WKE0_MASK 0x1
#define WKO_WKE0 0x1
#define WKO_WKE0_BIT 0
#define WKO_WKE1_MASK 0x2
#define WKO_WKE1 0x2
#define WKO_WKE1_BIT 1
#define WKO_WKL_MASK 0x4
#define WKO_WKL 0x4
#define WKO_WKL_BIT 2

sfrb T2CNA0 = 0x3;
#define T2CNA0_G2EN_MASK 0x1
#define T2CNA0_G2EN 0x1
#define T2CNA0_G2EN_BIT 0
#define T2CNA0_SS2_MASK 0x2
#define T2CNA0_SS2 0x2
#define T2CNA0_SS2_BIT 1
#define T2CNA0_CPRL2_MASK 0x4
#define T2CNA0_CPRL2 0x4
#define T2CNA0_CPRL2_BIT 2
#define T2CNA0_TR2_MASK 0x8
#define T2CNA0_TR2 0x8
#define T2CNA0_TR2_BIT 3
#define T2CNA0_TR2L_MASK 0x10
#define T2CNA0_TR2L 0x10
#define T2CNA0_TR2L_BIT 4
#define T2CNA0_T2POL0_MASK 0x20
#define T2CNA0_T2POL0 0x20
#define T2CNA0_T2POL0_BIT 5
#define T2CNA0_T2OE0_MASK 0x40
#define T2CNA0_T2OE0 0x40
#define T2CNA0_T2OE0_BIT 6
#define T2CNA0_ET2_MASK 0x80
#define T2CNA0_ET2 0x80
#define T2CNA0_ET2_BIT 7

sfrb T2H0 = 0x13;

sfrb T2RH0 = 0x23;

sfrb T2CH0 = 0x33;

sfrb T2CNB0 = 0xc3;
#define T2CNB0_TC2L_MASK 0x1
#define T2CNB0_TC2L 0x1
#define T2CNB0_TC2L_BIT 0
#define T2CNB0_TCC2_MASK 0x2
#define T2CNB0_TCC2 0x2
#define T2CNB0_TCC2_BIT 1
#define T2CNB0_TF2L_MASK 0x4
#define T2CNB0_TF2L 0x4
#define T2CNB0_TF2L_BIT 2
#define T2CNB0_TF2_MASK 0x8
#define T2CNB0_TF2 0x8
#define T2CNB0_TF2_BIT 3
#define T2CNB0_T2RL_MASK 0x10
#define T2CNB0_T2RL 0x10
#define T2CNB0_T2RL_BIT 4
#define T2CNB0_T2POL1_MASK 0x20
#define T2CNB0_T2POL1 0x20
#define T2CNB0_T2POL1_BIT 5
#define T2CNB0_T2OE1_MASK 0x40
#define T2CNB0_T2OE1 0x40
#define T2CNB0_T2OE1_BIT 6
#define T2CNB0_ET2L_MASK 0x80
#define T2CNB0_ET2L 0x80
#define T2CNB0_ET2L_BIT 7

sfrw T2V0 = 0xd3;

sfrw T2R0 = 0xe3;

sfrw T2C0 = 0xf3;

sfrb T2CFG0 = 0x103;
#define T2CFG0_CT2_MASK 0x1
#define T2CFG0_CT2 0x1
#define T2CFG0_CT2_BIT 0
#define T2CFG0_CCF0_MASK 0x2
#define T2CFG0_CCF0 0x2
#define T2CFG0_CCF0_BIT 1
#define T2CFG0_CCF1_MASK 0x4
#define T2CFG0_CCF1 0x4
#define T2CFG0_CCF1_BIT 2
#define T2CFG0_T2MD_MASK 0x8
#define T2CFG0_T2MD 0x8
#define T2CFG0_T2MD_BIT 3
#define T2CFG0_DIV0_MASK 0x10
#define T2CFG0_DIV0 0x10
#define T2CFG0_DIV0_BIT 4
#define T2CFG0_DIV1_MASK 0x20
#define T2CFG0_DIV1 0x20
#define T2CFG0_DIV1_BIT 5
#define T2CFG0_DIV2_MASK 0x40
#define T2CFG0_DIV2 0x40
#define T2CFG0_DIV2_BIT 6
#define T2CFG0_T2CI_MASK 0x80
#define T2CFG0_T2CI 0x80
#define T2CFG0_T2CI_BIT 7

sfrb T2CNA1 = 0x4;
#define T2CNA1_G2EN_MASK 0x1
#define T2CNA1_G2EN 0x1
#define T2CNA1_G2EN_BIT 0
#define T2CNA1_SS2_MASK 0x2
#define T2CNA1_SS2 0x2
#define T2CNA1_SS2_BIT 1
#define T2CNA1_CPRL2_MASK 0x4
#define T2CNA1_CPRL2 0x4
#define T2CNA1_CPRL2_BIT 2
#define T2CNA1_TR2_MASK 0x8
#define T2CNA1_TR2 0x8
#define T2CNA1_TR2_BIT 3
#define T2CNA1_TR2L_MASK 0x10
#define T2CNA1_TR2L 0x10
#define T2CNA1_TR2L_BIT 4
#define T2CNA1_T2POL0_MASK 0x20
#define T2CNA1_T2POL0 0x20
#define T2CNA1_T2POL0_BIT 5
#define T2CNA1_T2OE0_MASK 0x40
#define T2CNA1_T2OE0 0x40
#define T2CNA1_T2OE0_BIT 6
#define T2CNA1_ET2_MASK 0x80
#define T2CNA1_ET2 0x80
#define T2CNA1_ET2_BIT 7

sfrb T2H1 = 0x14;

sfrb T2RH1 = 0x24;

sfrb T2CH1 = 0x34;

sfrb T2CNB1 = 0x84;
#define T2CNB1_TC2L_MASK 0x1
#define T2CNB1_TC2L 0x1
#define T2CNB1_TC2L_BIT 0
#define T2CNB1_TCC2_MASK 0x2
#define T2CNB1_TCC2 0x2
#define T2CNB1_TCC2_BIT 1
#define T2CNB1_TF2L_MASK 0x4
#define T2CNB1_TF2L 0x4
#define T2CNB1_TF2L_BIT 2
#define T2CNB1_TF2_MASK 0x8
#define T2CNB1_TF2 0x8
#define T2CNB1_TF2_BIT 3
#define T2CNB1_T2RL_MASK 0x10
#define T2CNB1_T2RL 0x10
#define T2CNB1_T2RL_BIT 4
#define T2CNB1_T2POL1_MASK 0x20
#define T2CNB1_T2POL1 0x20
#define T2CNB1_T2POL1_BIT 5
#define T2CNB1_T2OE1_MASK 0x40
#define T2CNB1_T2OE1 0x40
#define T2CNB1_T2OE1_BIT 6
#define T2CNB1_ET2L_MASK 0x80
#define T2CNB1_ET2L 0x80
#define T2CNB1_ET2L_BIT 7

sfrw T2V1 = 0x94;

sfrw T2R1 = 0xa4;

sfrw T2C1 = 0xb4;

sfrb T2CFG1 = 0x104;
#define T2CFG1_CT2_MASK 0x1
#define T2CFG1_CT2 0x1
#define T2CFG1_CT2_BIT 0
#define T2CFG1_CCF0_MASK 0x2
#define T2CFG1_CCF0 0x2
#define T2CFG1_CCF0_BIT 1
#define T2CFG1_CCF1_MASK 0x4
#define T2CFG1_CCF1 0x4
#define T2CFG1_CCF1_BIT 2
#define T2CFG1_T2MD_MASK 0x8
#define T2CFG1_T2MD 0x8
#define T2CFG1_T2MD_BIT 3
#define T2CFG1_DIV0_MASK 0x10
#define T2CFG1_DIV0 0x10
#define T2CFG1_DIV0_BIT 4
#define T2CFG1_DIV1_MASK 0x20
#define T2CFG1_DIV1 0x20
#define T2CFG1_DIV1_BIT 5
#define T2CFG1_DIV2_MASK 0x40
#define T2CFG1_DIV2 0x40
#define T2CFG1_DIV2_BIT 6
#define T2CFG1_T2CI_MASK 0x80
#define T2CFG1_T2CI 0x80
#define T2CFG1_T2CI_BIT 7

sfrb T2CNA2 = 0x44;
#define T2CNA2_G2EN_MASK 0x1
#define T2CNA2_G2EN 0x1
#define T2CNA2_G2EN_BIT 0
#define T2CNA2_SS2_MASK 0x2
#define T2CNA2_SS2 0x2
#define T2CNA2_SS2_BIT 1
#define T2CNA2_CPRL2_MASK 0x4
#define T2CNA2_CPRL2 0x4
#define T2CNA2_CPRL2_BIT 2
#define T2CNA2_TR2_MASK 0x8
#define T2CNA2_TR2 0x8
#define T2CNA2_TR2_BIT 3
#define T2CNA2_TR2L_MASK 0x10
#define T2CNA2_TR2L 0x10
#define T2CNA2_TR2L_BIT 4
#define T2CNA2_T2POL0_MASK 0x20
#define T2CNA2_T2POL0 0x20
#define T2CNA2_T2POL0_BIT 5
#define T2CNA2_T2OE0_MASK 0x40
#define T2CNA2_T2OE0 0x40
#define T2CNA2_T2OE0_BIT 6
#define T2CNA2_ET2_MASK 0x80
#define T2CNA2_ET2 0x80
#define T2CNA2_ET2_BIT 7

sfrb T2H2 = 0x54;

sfrb T2RH2 = 0x64;

sfrb T2CH2 = 0x74;

sfrb T2CNB2 = 0xc4;
#define T2CNB2_TC2L_MASK 0x1
#define T2CNB2_TC2L 0x1
#define T2CNB2_TC2L_BIT 0
#define T2CNB2_TCC2_MASK 0x2
#define T2CNB2_TCC2 0x2
#define T2CNB2_TCC2_BIT 1
#define T2CNB2_TF2L_MASK 0x4
#define T2CNB2_TF2L 0x4
#define T2CNB2_TF2L_BIT 2
#define T2CNB2_TF2_MASK 0x8
#define T2CNB2_TF2 0x8
#define T2CNB2_TF2_BIT 3
#define T2CNB2_T2RL_MASK 0x10
#define T2CNB2_T2RL 0x10
#define T2CNB2_T2RL_BIT 4
#define T2CNB2_T2POL1_MASK 0x20
#define T2CNB2_T2POL1 0x20
#define T2CNB2_T2POL1_BIT 5
#define T2CNB2_T2OE1_MASK 0x40
#define T2CNB2_T2OE1 0x40
#define T2CNB2_T2OE1_BIT 6
#define T2CNB2_ET2L_MASK 0x80
#define T2CNB2_ET2L 0x80
#define T2CNB2_ET2L_BIT 7

sfrw T2V2 = 0xd4;

sfrw T2R2 = 0xe4;

sfrw T2C2 = 0xf4;

sfrb T2CFG2 = 0x114;
#define T2CFG2_CT2_MASK 0x1
#define T2CFG2_CT2 0x1
#define T2CFG2_CT2_BIT 0
#define T2CFG2_CCF0_MASK 0x2
#define T2CFG2_CCF0 0x2
#define T2CFG2_CCF0_BIT 1
#define T2CFG2_CCF1_MASK 0x4
#define T2CFG2_CCF1 0x4
#define T2CFG2_CCF1_BIT 2
#define T2CFG2_T2MD_MASK 0x8
#define T2CFG2_T2MD 0x8
#define T2CFG2_T2MD_BIT 3
#define T2CFG2_DIV0_MASK 0x10
#define T2CFG2_DIV0 0x10
#define T2CFG2_DIV0_BIT 4
#define T2CFG2_DIV1_MASK 0x20
#define T2CFG2_DIV1 0x20
#define T2CFG2_DIV1_BIT 5
#define T2CFG2_DIV2_MASK 0x40
#define T2CFG2_DIV2 0x40
#define T2CFG2_DIV2_BIT 6
#define T2CFG2_T2CI_MASK 0x80
#define T2CFG2_T2CI 0x80
#define T2CFG2_T2CI_BIT 7

sfrb SCON0 = 0x62;
#define SCON0_RI_MASK 0x1
#define SCON0_RI 0x1
#define SCON0_RI_BIT 0
#define SCON0_TI_MASK 0x2
#define SCON0_TI 0x2
#define SCON0_TI_BIT 1
#define SCON0_RB8_MASK 0x4
#define SCON0_RB8 0x4
#define SCON0_RB8_BIT 2
#define SCON0_TB8_MASK 0x8
#define SCON0_TB8 0x8
#define SCON0_TB8_BIT 3
#define SCON0_REN_MASK 0x10
#define SCON0_REN 0x10
#define SCON0_REN_BIT 4
#define SCON0_SM2_MASK 0x20
#define SCON0_SM2 0x20
#define SCON0_SM2_BIT 5
#define SCON0_SM1_MASK 0x40
#define SCON0_SM1 0x40
#define SCON0_SM1_BIT 6
#define SCON0_SM0_MASK 0x80
#define SCON0_SM0 0x80
#define SCON0_SM0_BIT 7
#define SCON0_FE_MASK 0x80
#define SCON0_FE 0x80
#define SCON0_FE_BIT 7

sfrb SBUF0 = 0x72;

sfrb SMD0 = 0x82;
#define SMD0_FEDE0_MASK 0x1
#define SMD0_FEDE0 0x1
#define SMD0_FEDE0_BIT 0
#define SMD0_SMOD0_MASK 0x2
#define SMD0_SMOD0 0x2
#define SMD0_SMOD0_BIT 1
#define SMD0_ESI0_MASK 0x4
#define SMD0_ESI0 0x4
#define SMD0_ESI0_BIT 2

sfrw PR0 = 0x92;

sfrb ICDF = 0x101;
#define ICDF_SPE_MASK 0x2
#define ICDF_SPE 0x2
#define ICDF_SPE_BIT 1
#define ICDF_PSS0_MASK 0x4
#define ICDF_PSS0 0x4
#define ICDF_PSS0_BIT 2
#define ICDF_PSS1_MASK 0x8
#define ICDF_PSS1 0x8
#define ICDF_PSS1_BIT 3

sfrw SPIB = 0x53;

sfrb SPICN = 0x153;
#define SPICN_SPIEN_MASK 0x1
#define SPICN_SPIEN 0x1
#define SPICN_SPIEN_BIT 0
#define SPICN_MSTM_MASK 0x2
#define SPICN_MSTM 0x2
#define SPICN_MSTM_BIT 1
#define SPICN_MODFE_MASK 0x4
#define SPICN_MODFE 0x4
#define SPICN_MODFE_BIT 2
#define SPICN_MODF_MASK 0x8
#define SPICN_MODF 0x8
#define SPICN_MODF_BIT 3
#define SPICN_WCOL_MASK 0x10
#define SPICN_WCOL 0x10
#define SPICN_WCOL_BIT 4
#define SPICN_ROVR_MASK 0x20
#define SPICN_ROVR 0x20
#define SPICN_ROVR_BIT 5
#define SPICN_SPIC_MASK 0x40
#define SPICN_SPIC 0x40
#define SPICN_SPIC_BIT 6
#define SPICN_STBY_MASK 0x80
#define SPICN_STBY 0x80
#define SPICN_STBY_BIT 7

sfrb SPICF = 0x163;
#define SPICF_CKPOL_MASK 0x1
#define SPICF_CKPOL 0x1
#define SPICF_CKPOL_BIT 0
#define SPICF_CKPHA_MASK 0x2
#define SPICF_CKPHA 0x2
#define SPICF_CKPHA_BIT 1
#define SPICF_CHR_MASK 0x4
#define SPICF_CHR 0x4
#define SPICF_CHR_BIT 2
#define SPICF_ESPI1_MASK 0x80
#define SPICF_ESPI1 0x80
#define SPICF_ESPI1_BIT 7

sfrb SPICK = 0x173;

sfrb SCON1 = 0x63;
#define SCON1_RI_MASK 0x1
#define SCON1_RI 0x1
#define SCON1_RI_BIT 0
#define SCON1_TI_MASK 0x2
#define SCON1_TI 0x2
#define SCON1_TI_BIT 1
#define SCON1_RB8_MASK 0x4
#define SCON1_RB8 0x4
#define SCON1_RB8_BIT 2
#define SCON1_TB8_MASK 0x8
#define SCON1_TB8 0x8
#define SCON1_TB8_BIT 3
#define SCON1_REN_MASK 0x10
#define SCON1_REN 0x10
#define SCON1_REN_BIT 4
#define SCON1_SM2_MASK 0x20
#define SCON1_SM2 0x20
#define SCON1_SM2_BIT 5
#define SCON1_SM1_MASK 0x40
#define SCON1_SM1 0x40
#define SCON1_SM1_BIT 6
#define SCON1_SM0_MASK 0x80
#define SCON1_SM0 0x80
#define SCON1_SM0_BIT 7
#define SCON1_FE_MASK 0x80
#define SCON1_FE 0x80
#define SCON1_FE_BIT 7

sfrb SBUF1 = 0x73;

sfrb SMD1 = 0x83;
#define SMD1_FEDE1_MASK 0x1
#define SMD1_FEDE1 0x1
#define SMD1_FEDE1_BIT 0
#define SMD1_SMOD1_MASK 0x2
#define SMD1_SMOD1 0x2
#define SMD1_SMOD1_BIT 1
#define SMD1_ESI1_MASK 0x4
#define SMD1_ESI1 0x4
#define SMD1_ESI1_BIT 2

sfrw PR1 = 0x93;

sfrb AP = 0x8;

sfrb APC = 0x18;
#define APC_MOD_MASK 0x7
#define APC_MOD_BIT 0
#define APC_IDS_MASK 0x40
#define APC_IDS 0x40
#define APC_IDS_BIT 6
#define APC_CLR_MASK 0x80
#define APC_CLR 0x80
#define APC_CLR_BIT 7

sfrb PSF = 0x48;
#define PSF_E_MASK 0x1
#define PSF_E 0x1
#define PSF_E_BIT 0
#define PSF_C_MASK 0x2
#define PSF_C 0x2
#define PSF_C_BIT 1
#define PSF_OV_MASK 0x4
#define PSF_OV 0x4
#define PSF_OV_BIT 2
#define PSF_GPF0_MASK 0x8
#define PSF_GPF0 0x8
#define PSF_GPF0_BIT 3
#define PSF_GPF1_MASK 0x10
#define PSF_GPF1 0x10
#define PSF_GPF1_BIT 4
#define PSF_S_MASK 0x40
#define PSF_S 0x40
#define PSF_S_BIT 6
#define PSF_Z_MASK 0x80
#define PSF_Z 0x80
#define PSF_Z_BIT 7

sfrb IC = 0x58;
#define IC_IGE_MASK 0x1
#define IC_IGE 0x1
#define IC_IGE_BIT 0
#define IC_INS_MASK 0x2
#define IC_INS 0x2
#define IC_INS_BIT 1
#define IC_CGDS_MASK 0x20
#define IC_CGDS 0x20
#define IC_CGDS_BIT 5

sfrb IMR = 0x68;
#define IMR_IM0_MASK 0x1
#define IMR_IM0 0x1
#define IMR_IM0_BIT 0
#define IMR_IM1_MASK 0x2
#define IMR_IM1 0x2
#define IMR_IM1_BIT 1
#define IMR_IM2_MASK 0x4
#define IMR_IM2 0x4
#define IMR_IM2_BIT 2
#define IMR_IM3_MASK 0x8
#define IMR_IM3 0x8
#define IMR_IM3_BIT 3
#define IMR_IM4_MASK 0x10
#define IMR_IM4 0x10
#define IMR_IM4_BIT 4
#define IMR_IM5_MASK 0x20
#define IMR_IM5 0x20
#define IMR_IM5_BIT 5
#define IMR_IMS_MASK 0x80
#define IMR_IMS 0x80
#define IMR_IMS_BIT 7

sfrb SC = 0x88;
#define SC_PWL_MASK 0x2
#define SC_PWL 0x2
#define SC_PWL_BIT 1
#define SC_ROD_MASK 0x4
#define SC_ROD 0x4
#define SC_ROD_BIT 2
#define SC_UPA_MASK 0x8
#define SC_UPA 0x8
#define SC_UPA_BIT 3
#define SC_CDA_MASK 0x30
#define SC_CDA_BIT 4
#define SC_TAP_MASK 0x180
#define SC_TAP_BIT 7

sfrb IIR = 0xb8;
#define IIR_II0_MASK 0x1
#define IIR_II0 0x1
#define IIR_II0_BIT 0
#define IIR_II1_MASK 0x2
#define IIR_II1 0x2
#define IIR_II1_BIT 1
#define IIR_II2_MASK 0x4
#define IIR_II2 0x4
#define IIR_II2_BIT 2
#define IIR_II3_MASK 0x8
#define IIR_II3 0x8
#define IIR_II3_BIT 3
#define IIR_II4_MASK 0x10
#define IIR_II4 0x10
#define IIR_II4_BIT 4
#define IIR_II5_MASK 0x20
#define IIR_II5 0x20
#define IIR_II5_BIT 5
#define IIR_IIS_MASK 0x80
#define IIR_IIS 0x80
#define IIR_IIS_BIT 7

sfrb CKCN = 0xe8;
#define CKCN_CD_MASK 0x3
#define CKCN_CD_BIT 0
#define CKCN_PMME_MASK 0x4
#define CKCN_PMME 0x4
#define CKCN_PMME_BIT 2
#define CKCN_SWB_MASK 0x8
#define CKCN_SWB 0x8
#define CKCN_SWB_BIT 3
#define CKCN_STOP_MASK 0x10
#define CKCN_STOP 0x10
#define CKCN_STOP_BIT 4
#define CKCN_RGMD_MASK 0x20
#define CKCN_RGMD 0x20
#define CKCN_RGMD_BIT 5
#define CKCN_RGSL_MASK 0x40
#define CKCN_RGSL 0x40
#define CKCN_RGSL_BIT 6
#define CKCN_XT_NOT_RC_MASK 0x80
#define CKCN_XT_NOT_RC 0x80
#define CKCN_XT_NOT_RC_BIT 7

sfrb WDCN = 0xf8;
#define WDCN_RWT_MASK 0x1
#define WDCN_RWT 0x1
#define WDCN_RWT_BIT 0
#define WDCN_EWT_MASK 0x2
#define WDCN_EWT 0x2
#define WDCN_EWT_BIT 1
#define WDCN_WTRF_MASK 0x4
#define WDCN_WTRF 0x4
#define WDCN_WTRF_BIT 2
#define WDCN_WDIF_MASK 0x8
#define WDCN_WDIF 0x8
#define WDCN_WDIF_BIT 3
#define WDCN_WD_MASK 0x30
#define WDCN_WD_BIT 4
#define WDCN_EWDI_MASK 0x40
#define WDCN_EWDI 0x40
#define WDCN_EWDI_BIT 6
#define WDCN_POR_MASK 0x80
#define WDCN_POR 0x80
#define WDCN_POR_BIT 7

sfrw A_0 = 0x9;

sfrw A_1 = 0x19;

sfrw A_2 = 0x29;

sfrw A_3 = 0x39;

sfrw A_4 = 0x49;

sfrw A_5 = 0x59;

sfrw A_6 = 0x69;

sfrw A_7 = 0x79;

sfrw A_8 = 0x89;

sfrw A_9 = 0x99;

sfrw A_10 = 0xa9;

sfrw A_11 = 0xb9;

sfrw A_12 = 0xc9;

sfrw A_13 = 0xd9;

sfrw A_14 = 0xe9;

sfrw A_15 = 0xf9;

sfrw PFX_0 = 0xb;

sfrw IP = 0xc;

sfrw SP = 0x1d;

sfrw IV = 0x2d;

sfrw LC_0 = 0x6d;

sfrw LC_1 = 0x7d;

sfrb OFFS = 0x3e;

sfrw DPC = 0x4e;
#define DPC_SDPS_MASK 0x3
#define DPC_SDPS_BIT 0
#define DPC_WBSO_MASK 0x4
#define DPC_WBSO 0x4
#define DPC_WBSO_BIT 2
#define DPC_WBS1_MASK 0x8
#define DPC_WBS1 0x8
#define DPC_WBS1_BIT 3
#define DPC_WBS2_MASK 0x10
#define DPC_WBS2 0x10
#define DPC_WBS2_BIT 4

sfrw GR = 0x5e;

sfrb GRL = 0x6e;

sfrw BP = 0x7e;

sfrw GRS = 0x8e;

sfrb GRH = 0x9e;

sfrw GRXL = 0xae;

sfrw FP = 0xbe;

sfrw DP_0 = 0x3f;

sfrw DP_1 = 0x7f;

sfrw LCRA = 0xd2;
#define LCRA_LRA0_MASK 0x1
#define LCRA_LRA0 0x1
#define LCRA_LRA0_BIT 0
#define LCRA_LRA1_MASK 0x2
#define LCRA_LRA1 0x2
#define LCRA_LRA1_BIT 1
#define LCRA_LRA2_MASK 0x4
#define LCRA_LRA2 0x4
#define LCRA_LRA2_BIT 2
#define LCRA_LRA3_MASK 0x8
#define LCRA_LRA3 0x8
#define LCRA_LRA3_BIT 3
#define LCRA_LRA4_MASK 0x10
#define LCRA_LRA4 0x10
#define LCRA_LRA4_BIT 4
#define LCRA_LRIG_MASK 0x20
#define LCRA_LRIG 0x20
#define LCRA_LRIG_BIT 5
#define LCRA_LCCS_MASK 0x40
#define LCRA_LCCS 0x40
#define LCRA_LCCS_BIT 6
#define LCRA_FRM0_MASK 0x80
#define LCRA_FRM0 0x80
#define LCRA_FRM0_BIT 7
#define LCRA_FRM1_MASK 0x100
#define LCRA_FRM1 0x100
#define LCRA_FRM1_BIT 8
#define LCRA_FRM2_MASK 0x200
#define LCRA_FRM2 0x200
#define LCRA_FRM2_BIT 9
#define LCRA_FRM3_MASK 0x400
#define LCRA_FRM3 0x400
#define LCRA_FRM3_BIT 10
#define LCRA_DUTY0_MASK 0x800
#define LCRA_DUTY0 0x800
#define LCRA_DUTY0_BIT 11
#define LCRA_DUTY1_MASK 0x1000
#define LCRA_DUTY1 0x1000
#define LCRA_DUTY1_BIT 12

sfrb LCFG = 0xe2;
#define LCFG_DPE_MASK 0x1
#define LCFG_DPE 0x1
#define LCFG_DPE_BIT 0
#define LCFG_OPM_MASK 0x2
#define LCFG_OPM 0x2
#define LCFG_OPM_BIT 1
#define LCFG_PCF0_MASK 0x10
#define LCFG_PCF0 0x10
#define LCFG_PCF0_BIT 4
#define LCFG_PCF1_MASK 0x20
#define LCFG_PCF1 0x20
#define LCFG_PCF1_BIT 5
#define LCFG_PCF2_MASK 0x40
#define LCFG_PCF2 0x40
#define LCFG_PCF2_BIT 6
#define LCFG_PCF3_MASK 0x80
#define LCFG_PCF3 0x80
#define LCFG_PCF3_BIT 7

sfrb LCD0 = 0x102;

sfrb LCD1 = 0x112;

sfrb LCD2 = 0x122;

sfrb LCD3 = 0x132;

sfrb LCD4 = 0x142;

sfrb LCD5 = 0x152;

sfrb LCD6 = 0x162;

sfrb LCD7 = 0x172;

sfrb LCD8 = 0x182;

sfrb LCD9 = 0x192;

sfrb LCD10 = 0x1a2;

sfrb LCD11 = 0x1b2;

sfrb LCD12 = 0x1c2;

sfrb LCD13 = 0x1d2;

sfrb LCD14 = 0x1e2;

sfrb LCD15 = 0x1f2;

sfrb LCD16 = 0xf2;

sfrb OWA = 0x133;

sfrb OWD = 0x143;


#endif
