// Rowley MAXQ C Compiler, runtime support.
//
// Copyright (c) 2004, 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __inmaxq_H
#define __inmaxq_H

// Status register
sfrb __ic = 0x58;  // module 8 index 5

// Swap nibble order within a byte
#pragma intrinsic(__swap_nibbles)
unsigned char __swap_nibbles(unsigned char);

// Swap byte order within a word
#pragma intrinsic(__swap_bytes)
unsigned __swap_bytes(unsigned x);

// Insert op into the code sequence
#pragma intrinsic(__insert_opcode)
void __insert_opcode(unsigned short op);

// Disable interrupts and return original status register
#pragma intrinsic(__disable_interrupt)
unsigned __disable_interrupt(void);

// Enable interrupts and return original status register
#pragma intrinsic(__enable_interrupt)
unsigned __enable_interrupt(void);

#define __save_interrupt() (__ic)
#define __restore_interrupt(x)  do { if (x & 0x01) __enable_interrupt(); else __disable_interrupt(); } while (0)

// Insert a NOP to code sequence.
#define __no_operation() __insert_opcode(0xda3a)

// Delay for a given number of cycles.
#pragma intrinsic(__delay_cycles)
void __delay_cycles(unsigned);

#endif
