// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 MAXQ2000 Evaluation Kit LED Example
//
// Description
// -----------
// This example demonstrates a timer interrupt.
// The switch SW6.8 must be turned on to enable the LED panel
//
////////////////////////////////////////////////////////////////////////////////

#include <MAXQ2000.h>

void 
interruptHandler(void) __interrupt
{
  if (T2CNB0 & 0x08)
    PO0 ^= 0x01; // toggle LED 1
  T2CNB0 = 0;
}

void setIV(void(*isr)(void));

int
main(void)
{
  PD0 = 0xff; // enable outputs
  PO0 = 0x00; // clear LEDs
  setIV(interruptHandler);
  IMR = 0x08; // enable module 3
  
  T2V0 = 0x03202;
  T2R0 = 0x03202;
  T2C0 = 0x00002; // no compare, don't want that interrupt firing
  T2CFG0 = 0x070; // use clock divided by 128
  T2CNB0 = 0x000;                
  T2CNA0 = 0x088; // start the timer, and enable interrupts

  IC = 1; // enable global interrupts

  while (1);
}
