// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 MAXQ2000 Evaluation Kit Button/LED Example
//
// Description
// -----------
// This example demonstrates generating external interrupts and writing to the GPIO port.
// The switches SW6.2 must be turned on to enable the SW4 push button 
// The switch SW6.8 must be turned on to enable the LED panel
//
////////////////////////////////////////////////////////////////////////////////

#include <MAXQ2000.h>

void 
interruptHandler(void) __interrupt
{
  if (EIF1 & 0x04)
    PO0 ^= 0x01; // toggle LED 1
  EIF1 = 0;
}

void setIV(void(*isr)(void));

int
main(void)
{
  PD0 = 0xff; // enable outputs
  PO0 = 0x00; // clear LEDs
  setIV(interruptHandler);
  EIE1 = 0x04; // enable interrupts for EI 10
  EIES1 = 0x04; // select falling edge for EI 10
  IMR |= 2; // include interrupts for module 1
  IC = 1; // enable global interrupts
  while (1);
}


