;* --------------------------------------------------------------------------------------
;*  Copyright (C) 2004 Dallas Semiconductor Corporation, All Rights Reserved.
;* 
;*  Permission is hereby granted, free of charge, to any person obtaining a
;*  copy of this software and associated documentation files (the "Software"),
;*  to deal in the Software without restriction, including without limitation
;*  the rights to use, copy, modify, merge, publish, distribute, sublicense,
;*  and/or sell copies of the Software, and to permit persons to whom the
;*  Software is furnished to do so, subject to the following conditions:
;* 
;*  The above copyright notice and this permission notice shall be included
;*  in all copies or substantial portions of the Software.
;* 
;*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
;*  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;*  MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;*  IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
;*  OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
;*  ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;*  OTHER DEALINGS IN THE SOFTWARE.
;* 
;*  Except as contained in this notice, the name of Dallas Semiconductor
;*  shall not be used except as stated in the Dallas Semiconductor
;*  Branding Policy.
;*
;* --------------------------------------------------------------------------------------
;* 
;*  This demonstration is meant to show the features of the serial port on the 
;*  MAXQ2000.  It shows how to read a character convert lower case to uppter case a-z
;*  to A-Z and display it on the PC screen using HyperTerminal.
;*
;*  Turn ON the following switches for this demonstration:
;*
;*       SW1.7, SW1.4: Enable the TXD0 and RXD0 on J5 (DB9 connector)
;*
;* --------------------------------------------------------------------------------------

#include "..\api\maxQ2000.inc"
#include "..\api\serial_IO.inc"

;
; Define the soft stack for interrupt storage at 200h
;
SOFTSTACK_W EQU 200h

  .code
  .keep
    ;
    ; Some basic initialization.  Set Accumulator Controls to normal.
    ; Set interrupt vector.  Set data pointer controls.  
    ;
    move  APC, #0                      ; no accumulator-modulo behavior
    move  AP, #0                       ; select accumulator 0
    move  DPC, #0                      ; select DP[0], byte mode
    move  A[15], #0                    ; A[15] is our flag to enter stop mode
    move  ACC, IMR                     ; need to mask in module 0 interrupts
    or    #1                           ; low bit --> module 0
    move  IMR, ACC                     ; store new interrupt mask
    move  IC, #1                       ; initialize global interrupts

;*****************************************************************************
;
; Main application loop.  Toggle the top two bits twice per loop.  Toggle the
; bottom bit once per loop.  Interrupt handler will take care of everything 
; else.
;
;*****************************************************************************
mainloop_top:

	move A[0], #PORT_0			
	move A[1], #MODE_1			
	call serial_modeinput		; Sets serial port 0 in Asynchronous mode
	move A[0], #PORT_0			
	move A[1], #ENABLE			
	call serial_receiver		; Set the receive enable
	
	move PR0, #PR_115200

	move A[0], #PORT_0
	move A[1], #DIV16
	call serial_dividebaud		; Divide baudrate by 16
	move A[0], #PORT_0				
	move A[1], #SINGLE			
	call serial_processormode	; In modes 2 and 3 changes to single processor
	move A[0], #PORT_0
	move A[1], #DIV12
	call serial_divideclock		; In mode 0 divides system clock by 4
 	move A[0], #PORT_0
	move A[1], #TRANSMIT
	call serial_clearinterrupt	; Clears the Transmit interrupt
	move A[0], #PORT_0
	move A[1], #RECEIVE
	call serial_clearinterrupt  ; Clears the Receive interrupt
send_char_loop:
	move A[0], #PORT_0
	call serial_receivedata		; Receives a char from the keyboard
	move ACC, A[2]		
	sub  #'a'					; Test for char less than 'a'
	jump S, no_char_change
	move ACC, #'z'
	sub  A[2]					; Test for character greater than 'a'
	jump S, no_char_change
	move ACC, A[2]
	and  #0DFh					; Convert character from a-z to A-Z
	move A[2], ACC
no_char_change:	
	move A[0], #PORT_0
	call serial_senddata		; sends a character
	jump send_char_loop
end
