;* --------------------------------------------------------------------------------------
;*  Copyright (C) 2004 Dallas Semiconductor Corporation, All Rights Reserved.
;*
;*  Permission is hereby granted, free of charge, to any person obtaining a
;*  copy of this software and associated documentation files (the "Software"),
;*  to deal in the Software without restriction, including without limitation
;*  the rights to use, copy, modify, merge, publish, distribute, sublicense,
;*  and/or sell copies of the Software, and to permit persons to whom the
;*  Software is furnished to do so, subject to the following conditions:
;*
;*  The above copyright notice and this permission notice shall be included
;*  in all copies or substantial portions of the Software.
;*
;*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
;*  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;*  MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;*  IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
;*  OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
;*  ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;*  OTHER DEALINGS IN THE SOFTWARE.
;*
;*  Except as contained in this notice, the name of Dallas Semiconductor
;*  shall not be used except as stated in the Dallas Semiconductor
;*  Branding Policy.
;*
;*  Module:        1407wave
;*  Description:   An example program that uses the MAX1407 on the MAXQ2000
;*                 Evaluation Kit to generate a sine wave.
;*  Filename:      1407wave.asm
;*  Date:          November 2, 2004
;*  Version:       1.00
;*
;*  To use this program, you must turn switches SW3 1-8 to the on position.
;*  Also, pins J7-7 and J7-8 should be shorted together.  The sine wave will be
;*  generated at these pins.
;* --------------------------------------------------------------------------------------

#include "..\api\maxq2000_spi.inc"
#include "..\api\maxq2000ev_1407.inc"

  .code
  .keep

    call    max1407_init

sine_wave_loop:

    move    LC[0], #45
loop_1:
    move    ACC, #46
    sub     LC[0]
    call    get_sine_value
    add     #511
    call    set_dac_output
    djnz    LC[0], loop_1

    move    LC[0], #45
loop_2:
    move    ACC, LC[0]
    sub     #1
    call    get_sine_value
    add     #511
    call    set_dac_output
    djnz    LC[0], loop_2

    move    LC[0], #45
loop_3:
    move    ACC, #46
    sub     LC[0]
    call    get_sine_value
    sub     #511
    neg
    call    set_dac_output
    djnz    LC[0], loop_3
    move    LC[0], #45

    move    LC[0], #45
loop_4:
    move    ACC, LC[0]
    sub     #1
    call    get_sine_value
    sub     #511
    neg
    call    set_dac_output
    djnz    LC[0], loop_4

    jump    sine_wave_loop

set_dac_output:
    sla4
    sla2
	move	A[2], ACC
    move    ACC, #MAX1407REG_DAC2
    move    A[1], #SPI_LENGTH_16
    call    max1407_writeregister
    ret

get_sine_value:
	move	A[1], ACC
    sla
	add		A[1]
    add     #sine_values
    call    ACC
    ret

sine_values:
	nop
    move    ACC, #0
    ret
	nop
    move    ACC, #18
    ret
	nop
    move    ACC, #36
    ret
	nop
    move    ACC, #53
    ret
	nop
    move    ACC, #71
    ret
	nop
    move    ACC, #89
    ret
	nop
    move    ACC, #106
    ret
	nop
    move    ACC, #124
    ret
	nop
    move    ACC, #141
    ret
	nop
    move    ACC, #158
    ret
	nop
    move    ACC, #175
    ret
	nop
    move    ACC, #191
    ret
	nop
    move    ACC, #208
    ret
	nop
    move    ACC, #224
    ret
	nop
    move    ACC, #240
    ret
    move    ACC, #256
    ret
    move    ACC, #271
    ret
    move    ACC, #286
    ret
    move    ACC, #300
    ret
    move    ACC, #315
    ret
    move    ACC, #328
    ret
    move    ACC, #342
    ret
    move    ACC, #355
    ret
    move    ACC, #368
    ret
    move    ACC, #380
    ret
    move    ACC, #391
    ret
    move    ACC, #403
    ret
    move    ACC, #413
    ret
    move    ACC, #424
    ret
    move    ACC, #433
    ret
    move    ACC, #443
    ret
    move    ACC, #451
    ret
    move    ACC, #459
    ret
    move    ACC, #467
    ret
    move    ACC, #474
    ret
    move    ACC, #480
    ret
    move    ACC, #486
    ret
    move    ACC, #491
    ret
    move    ACC, #496
    ret
    move    ACC, #500
    ret
    move    ACC, #503
    ret
    move    ACC, #506
    ret
    move    ACC, #508
    ret
    move    ACC, #510
    ret
    move    ACC, #511
    ret
    move    ACC, #511
    ret

end
