;* ----------------------------------------------------------------------------
;*  Copyright (C) 2004 Dallas Semiconductor Corporation, All Rights Reserved.
;*
;*  Permission is hereby granted, free of charge, to any person obtaining a
;*  copy of this software and associated documentation files (the "Software"),
;*  to deal in the Software without restriction, including without limitation
;*  the rights to use, copy, modify, merge, publish, distribute, sublicense,
;*  and/or sell copies of the Software, and to permit persons to whom the
;*  Software is furnished to do so, subject to the following conditions:
;*
;*  The above copyright notice and this permission notice shall be included
;*  in all copies or substantial portions of the Software.
;*
;*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
;*  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;*  MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;*  IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
;*  OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
;*  ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;*  OTHER DEALINGS IN THE SOFTWARE.
;*
;*  Except as contained in this notice, the name of Dallas Semiconductor
;*  shall not be used except as stated in the Dallas Semiconductor
;*  Branding Policy.
;*
;*  Module:        owdump
;*  Description:   An example program that uses the 1-Wire module of the
;*                 MAXQ2000 to discover all of the devices on the 1-Wire bus.
;*  Filename:      owdump.c
;*  Date:          November 2, 2004
;*  Version:       1.00
;*
;*  To use this program, jumpers JU8 and JU9 should both be closed.  Also, if
;*  you want to use the DS2433 that is on the EV Kit board, you should close
;*  JU7.
;* ----------------------------------------------------------------------------
#include "..\api\maxQ2000.inc"

  .code
  .keep

#define ROM_ID_ADDR  0
#define SCRATCH_ADDR 8

    move    ACC, #12            ; The EVKit has a 12 MHz crystal.
    call    ow_configureclock

	move	DPC, #0				; The ow_findfirst and ow_findnext methods
								; want the data pointers to be in byte mode.
    move    DP[0], #ROM_ID_ADDR
    move    DP[1], #SCRATCH_ADDR
    call    ow_findfirst
owdump_search_loop:
    jump    NZ, owdump_found_last

	nop
    ; Add code here to process the current 1-Wire device.
    ; The ROM ID is stored in data memory at ROM_ID_ADDR.
    ; Use ow_touchbyte and ow_touchbit (defined in
    ; maxq2000_ow.asm) to communicate with the device.
    ; Use the family code stored at ROM_ID_ADDR to get
    ; the type of 1-Wire device found.

    move    DP[0], #ROM_ID_ADDR
    move    DP[1], #SCRATCH_ADDR
    call    ow_findnext
    jump    owdump_search_loop
    
owdump_found_last:

    jump    $   ; All devices have been found and processed.

end
