// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 MAXQ2000 Evaluation Kit LED Example
//
// Description
// -----------
// This example uses printf over the serial port.
// Turn ON the following switches for this demonstration:
//
//       SW1.7, SW1.4: Enable the TXD0 and RXD0 on J5 (DB9 connector)
//
////////////////////////////////////////////////////////////////////////////////

#include <MAXQ2000.h>
#include <stdio.h>

int 
__putchar(int x)
{
  SBUF0 = x;
  while (!(SCON0 & 2));
  SCON0 &= ~2;
}

int
main(void)
{
  int i = 0;
  SCON0 = (1<<6)|(1<<4);
  SMD0 = 2;
  PR0 = 0x45E8;

  while (1)
  {
    printf("hello %d from MAXQ2000\n", i);
    i++;
  }
}
