// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                 MAXQ2000 Evaluation Kit LED Example
//
// Description
// -----------
// This example demonstrates writing to the GPIO port.
// The switch SW6.8 must be turned on to enable the LED panel
//
////////////////////////////////////////////////////////////////////////////////

#include <MAXQ2000.h>

#define NUM_LEDS 8

static void
ledInit()
{
  PD0 = 0xff;
}

static void
ledOn(int led)
{
  PO0 |= 1 << led;
}

static void
ledOff(int led)
{
  PO0 &= ~(1 << led);
}

void
delay(void)
{     
  long d = 60000;
  for(; d; --d);
}
 
int
main(void)
{
  int i, j;
  ledInit();
  while (1)
    {
      for (i = 0; i < NUM_LEDS; ++i)
        {
          ledOn(i);
          delay();
        }
      for (i = 0; i < NUM_LEDS; ++i)
        {
          ledOff(i);
          delay();
        }
      for (i = NUM_LEDS - 1; i >= 0; --i)
        {
          ledOn(i);
          delay();
        }
      for (i = NUM_LEDS - 1; i >= 0; --i)
        {
          ledOff(i);
          delay();
        }

    }
  return 0;
}


