;* --------------------------------------------------------------------------------------
;*  Copyright (C) 2004 Dallas Semiconductor Corporation, All Rights Reserved.
;* 
;*  Permission is hereby granted, free of charge, to any person obtaining a
;*  copy of this software and associated documentation files (the "Software"),
;*  to deal in the Software without restriction, including without limitation
;*  the rights to use, copy, modify, merge, publish, distribute, sublicense,
;*  and/or sell copies of the Software, and to permit persons to whom the
;*  Software is furnished to do so, subject to the following conditions:
;* 
;*  The above copyright notice and this permission notice shall be included
;*  in all copies or substantial portions of the Software.
;* 
;*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
;*  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;*  MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;*  IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
;*  OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
;*  ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;*  OTHER DEALINGS IN THE SOFTWARE.
;*
;*  Except as contained in this notice, the name of Dallas Semiconductor
;*  shall not be used except as stated in the Dallas Semiconductor
;*  Branding Policy.
;*
;*  Module:        maxq2000_spi
;*  Description:   Constants used by the MAXQ2000 SPI module.
;*  Filename:      maxq2000_spi.inc
;*  Date:          November 2, 2004
;*  Version:       1.00
;*
;* --------------------------------------------------------------------------------------

#define SPIFLAGS_MODEFAULT       	08h
#define SPIFLAGS_WRITECOLLISION  	10h
#define SPIFLAGS_RECEIVEOVERRUN  	20h
#define SPIFLAGS_TRANFERCOMPLETE 	40h

#define SPIFLAGS_ALLERRORS       	38h
#define SPIFLAGS_ALL             	78h

#define SPI_LENGTH_8				0
#define SPI_LENGTH_16				1

#define SPI_IDLE_LOW				0 
#define SPI_IDLE_HIGH				1

#define SPI_ACTIVE_EDGE				0
#define SPI_INACTIVE_EDGE			1

#define SPI_SLAVE_MODE				0
#define SPI_MASTER_MODE				1


