;******************************************************************************
;*
;*  Copyright (C) 2004 Dallas Semiconductor Corporation. 
;*  All rights Reserved. Printed in U.S.A.
;*
;*  This software is protected by copyright laws of the United States and of 
;*  foreign countries.  This material may also be protected by patent laws of
;*  the United States and of foreign countries.  This software is furnished 
;*  under a license agreement and/or a nondisclosure agreement and may only 
;*  be used or copied in accordance with the terms of those agreements.  The 
;*  mere transfer of this software does not imply any licenses of trade 
;*  secrets, proprietary technology, copyrights, patents, trademarks, 
;*  maskwork rights, or any other form of intellectual property whatsoever. 
;*  Dallas Semiconductor retains all ownership rights.
;*
;*     Description: Register defines and utility ROM equates for the MAXQ2000.
;*
;*        Filename: maxq2000.inc
;*
;*          Author: KLA
;*
;*        Compiler: MAX-IDE
;*
;*         Version: 1.01 - 07/28/03
;*                  1.02 - 06/03/04
;*                  1.03 - 10/07/04
;*
;*         Created: 07/28/03
;*
;*   Modifications: Changed to use defines instead of equates
;*                  ADM - removed non-public registers for example code usage
;*                  ADM - merged in the utility ROM function addresses
;*
;******************************************************************************

; ********************************************************************
;
; Module 0
;
; ********************************************************************

#define PO0           M0[0]
#define PO1           M0[1]
#define PO2           M0[2]
#define PO3           M0[3]
; Reserved           *M0[4]
; Reserved           *M0[5]
#define EIF0          M0[6]
#define EIE0          M0[7]
#define PI0           M0[8]
#define PI1           M0[9]
#define PI2           M0[10]
#define PI3           M0[11]
#define EIES0         M0[12]
; Reserved           *M0[13]
; Reserved           *M0[14]
; Reserved           *M0[15]

#define PD0           M0[16]
#define PD1           M0[17]
#define PD2           M0[18]
#define PD3           M0[19]
; Reserved           *M0[20]
; Reserved           *M0[21]
; Reserved           *M0[22]
; Reserved           *M0[23]
; Reserved           *M0[24]
#define RCNT          M0[25]
#define RTSS          M0[26]
#define RTSH          M0[27]
#define RTSL          M0[28]
#define RSSA          M0[29]
#define RASH          M0[30]
#define RASL          M0[31]

; ********************************************************************
;
; Module 1
;
; ********************************************************************

#define PO4           M1[0]
#define PO5           M1[1]
#define PO6           M1[2]
#define PO7           M1[3]
; Reserved           *M1[4]
; Reserved           *M1[5]
#define EIF1          M1[6]
#define EIE1          M1[7]
#define PI4           M1[8]
#define PI5           M1[9]
#define PI6           M1[10]
#define PI7           M1[11]
#define EIES1         M1[12]
; Reserved           *M1[13]
; Reserved           *M1[14]
; Reserved           *M1[15]

#define PD4           M1[16]
#define PD5           M1[17]
#define PD6           M1[18]
#define PD7           M1[19]
; Reserved           *M1[20]
; Reserved           *M1[21]
; Reserved           *M1[22]
; Reserved           *M1[23]
; Reserved           *M1[24]
; Reserved           *M1[25]
; Reserved           *M1[26]
; Reserved           *M1[27]
; Reserved           *M1[28]
; Reserved           *M1[29]
#define SVS           M1[30]
#define WKO           M1[31]


; ********************************************************************
;
; Module 2
;
; ********************************************************************

#define MCNT          M2[0]
#define MA            M2[1]
#define MB            M2[2]
#define MC2           M2[3]
#define MC1           M2[4]
#define MC0           M2[5]
#define SCON0         M2[6]
#define SBUF0         M2[7]
#define SMD0          M2[8]
#define PR0           M2[9]
; Reserved           *M2[10]
#define MC1R          M2[11]
#define MC0R          M2[12]
#define LCRA          M2[13]
#define LCFG          M2[14]
#define LCD16         M2[15]

#define LCD0          M2[16]
#define LCD1          M2[17]
#define LCD2          M2[18]
#define LCD3          M2[19]
#define LCD4          M2[20]
#define LCD5          M2[21]
#define LCD6          M2[22]
#define LCD7          M2[23]
#define LCD8          M2[24]
#define LCD9          M2[25]
#define LCD10         M2[26]
#define LCD11         M2[27]
#define LCD12         M2[28]
#define LCD13         M2[29]
#define LCD14         M2[30]
#define LCD15         M2[31]

; ********************************************************************
;
; Module 3
;
; ********************************************************************

#define T2CNA0        M3[0]
#define T2H0          M3[1]
#define T2RH0         M3[2]
#define T2CH0         M3[3]
; Reserved           *M3[4]
#define SPIB          M3[5]
#define SCON1         M3[6]
#define SBUF1         M3[7]
#define SMD1          M3[8]
#define PR1           M3[9]
; Reserved           *M3[10]
; Reserved           *M3[11]
#define T2CNB0        M3[12]
#define T2V0          M3[13]
#define T2R0          M3[14]
#define T2C0          M3[15]

#define T2CFG0        M3[16]
; Reserved           *M3[17]
; Reserved           *M3[18]
#define OWA           M3[19]
#define OWD           M3[20]
#define SPICN         M3[21]
#define SPICF         M3[22]
#define SPICK         M3[23]
; Reserved           *M3[24]
; Reserved           *M3[25]
; Reserved           *M3[26]
#define ICDF          M3[27]
; Reserved           *M3[28]
; Reserved           *M3[29]
; Reserved           *M3[30]
; Reserved           *M3[31]

; ********************************************************************
;
; Module 4
;
; ********************************************************************

#define T2CNA1        M4[0]
#define T2H1          M4[1]
#define T2RH1         M4[2]
#define T2CH1         M4[3]
#define T2CNA2        M4[4]
#define T2H2          M4[5]
#define T2RH2         M4[6]
#define T2CH2         M4[7]
#define T2CNB1        M4[8]
#define T2V1          M4[9]
#define T2R1          M4[10]
#define T2C1          M4[11]
#define T2CNB2        M4[12]
#define T2V2          M4[13]
#define T2R2          M4[14]
#define T2C2          M4[15]

#define T2CFG1        M4[16]
#define T2CFG2        M4[17]
; Reserved           *M4[18]    
; Reserved           *M4[19]    
; Reserved           *M4[20]    
; Reserved           *M4[21]    
; Reserved           *M4[22]    
; Reserved           *M4[23]    
; Reserved           *M4[24]    
; Reserved           *M4[25]    
; Reserved           *M4[26]    
; Reserved           *M4[27]    
; Reserved           *M4[28]    
; Reserved           *M4[29]    
; Reserved           *M4[30]    
; Reserved           *M4[31]    

; ********************************************************************
;
; Utility ROM function addresses (ROM version 1.01)
;
; ********************************************************************

#define UROM_flashWrite     (0x08461 * 2)
#define UROM_flashErasePage (0x08467 * 2)
#define UROM_flashEraseAll  (0x08478 * 2)
#define UROM_moveDP0        (0x08487 * 2)
#define UROM_moveDP0inc     (0x0848a * 2)
#define UROM_moveDP0dec     (0x0848d * 2)
#define UROM_moveDP1        (0x08490 * 2)
#define UROM_moveDP1inc     (0x08493 * 2)
#define UROM_moveDP1dec     (0x08496 * 2)
#define UROM_moveBP         (0x08499 * 2)
#define UROM_moveBPinc      (0x0849c * 2)
#define UROM_moveBPdec      (0x0849f * 2)
#define UROM_copyBuffer     (0x084a2 * 2)
