// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __limits_H
#define __limits_H

#define CHAR_BIT   8
#define CHAR_MAX   255
#define CHAR_MIN   0
#define SCHAR_MAX  127
#define SCHAR_MIN  (-128)
#define UCHAR_MAX  255
#define SHRT_MAX   32767
#define SHRT_MIN   (-32767 - 1)
#define USHRT_MAX  65535

#if defined(__CROSSWORKS_MSP430) || defined(__CROSSWORKS_AVR) || defined(__CROSSWORKS_MAXQ)
#define INT_MAX   32767
#define INT_MIN   (-32767 - 1)
#define UINT_MAX  65535
#else
#define INT_MAX    2147483647
#define INT_MIN	   (-2147483647 - 1)
#define UINT_MAX   4294967295
#endif

#define LONG_MAX   2147483647L
#define LONG_MIN   (-2147483647L - 1)
#define ULONG_MAX  4294967295UL
#define LLONG_MIN  (-9223372036854775807LL - 1)
#define LLONG_MAX  9223372036854775807LL
#define ULLONG_MAX 18446744073709551615ULL

#endif
