// Copyright (c) 2005, 2007 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <avr.h>
#include <ctl_api.h>

static void (*timer_isr)(void);
static void (*button_pressed_isr)(void);

void ctl_board_init(void)
{
  DDRA = 0xff; // set port to output
  PORTA = 0xff; // turn the leds off
}

void ctl_start_timer(CTL_ISR_FN_t isr)
{
  timer_isr = isr;
  TIMSK = (1<<OCIE0_BIT); // Interrupt on timer0 output compare
  TCCR0 = (1<<WGM01_BIT)|(1<<WGM00_BIT)|(1<<CS00_BIT); // CTC mode, running at clk/8
  OCR0 = 10000000/8/1000; // 1Mhz clock / 1Khz counter
}

unsigned long ctl_get_ticks_per_second(void)
{
  return 1000;
}

void TIMER0_COMP_IRQ(void) __ctl_interrupt[TIMER0_COMP_vect]
{
  timer_isr();
}

void ctl_board_on_button_pressed(CTL_ISR_FN_t isr)
{
  button_pressed_isr = isr; 
   // Interrupt on external interrupt 0
  EICRA = 3;
  EIMSK = 1;
}

void INT0_IRQ(void) __ctl_interrupt[INT0_vect]
{   
  button_pressed_isr();
}

void ctl_board_set_leds(unsigned v)
{
  if (v)
    PORTA = 0xfe;
  else
    PORTA = 0xff;
}

