// Rowley C Compiler, runtime support.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <avr.h>

  ifdef EEDR
        public  ___uint8_eeprom_load
        public  ___uint8_eeprom_store
        public  ___uint16_eeprom_load
        public  ___uint16_eeprom_store
        public  ___uint32_eeprom_load
        public  ___uint32_eeprom_store
        public  ___uint64_eeprom_store
        public  ___uint64_eeprom_load
        public  ___struct_asgn_data_ee
        public  ___struct_asgn_ee_data
        public  ___struct_asgn_ee_c
  endif

; Create sections
        data
        bss
        priority 0

; Call stack
        break
        dsect   "CALLSTACK"
        keep
        ds      call_stack_size

; Data stack
        break
        dsect   "DATASTACK"
        keep
        DS      data_stack_size

; Go to code section.
        code
        even

; Executed upon reset

        public __reset

__reset proc

; C compiler requires R0=0
        clr      r0

; Set up call stack
; SP points to the next empty location
  ifdef SPH
        ldi     r16, high(SFE(CALLSTACK)-1)
        out     __IOADDRESS(SPH), r16
  endif
        ldi     r16, low(SFE(CALLSTACK)-1)
        out     __IOADDRESS(SPL), r16

; Set up data stack
        ldi     r29, high(SFE(DATASTACK))
        ldi     r28, low(SFE(DATASTACK))

; Copy from initialised data section to data section.
        linkif  SIZEOF(IDATA0)
        ldi     r27, HIGH(SFB(IDATA0))
        ldi     r26, LOW(SFB(IDATA0))
        ldi     r31, HIGH(data_init_begin)
        ldi     r30, LOW(data_init_begin)
        ldi     r25, HIGH(data_init_end-data_init_begin)
        ldi     r24, LOW(data_init_end-data_init_begin)
#if defined(__BOOTLOADER) && (__TARGET_PROCESSOR==AT90CAN128 || __TARGET_PROCESSOR==ATmega128 || __TARGET_PROCESSOR==ATmega1280 || TARGET_PROCESSOR==ATmega1281)
        ldi     r16, 1
        out     __IOADDRESS(RAMPZ), r16
L$1:
        elpm     r1, z+
#elif defined(__BOOTLOADER) && (__TARGET_PROCESSOR==ATmega2560 || __TARGET_PROCESSOR==ATmega2561)
        ldi     r16, 3
        out     __IOADDRESS(RAMPZ), r16
L$1:
        elpm     r1, z+
#else
L$1:
        lpm     r1, z+
#endif
        st      x+, r1
        sbiw    r25:r24, 1
        brne    L$1
L$2:
        endlinkif

; Zero the bss.
        linkif  SIZEOF(UDATA0)
        ldi     r27, HIGH(SFB(UDATA0))
        ldi     r26, LOW(SFB(UDATA0))
        ldi     r25, HIGH(SIZEOF(UDATA0))
        ldi     r24, LOW(SIZEOF(UDATA0))
L$3:
        st      x+, r0
        sbiw    r25:r24, 1
        brne    L$3
L$4:
        endlinkif

; Call user entry point void main(void).
        rjmp    _main
        endproc


OUTX    macro   addr, reg
        if      addr < 0x40
        out     __IOADDRESS(addr), reg
        else
        sts     addr, reg
        endif
        endm

INX     macro   reg, addr
        if      addr < 0x40
        in      reg, __IOADDRESS(addr)
        else
        lds     reg, addr
        endif
        endm

  ifdef EEDR

        opt

; Write byte to EEPROM
; void __uint8_eeprom_store(unsigned char byte, unsigned addr);
___uint8_eeprom_store proc
        mov     r31, r26
        mov     r30, r25
        rcall   ___eeprom_wait
        OUTX    EEDR, r27
        rjmp    ___eeprom_write
        endproc

; Write 16 bits to EEPROM
; void __uint16_eeprom_store(unsigned val, unsigned addr);
___uint16_eeprom_store proc
        mov     r31, r25
        mov     r30, r24
        rcall   ___eeprom_wait
        OUTX    EEDR, r26
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r27
        rjmp    ___eeprom_write
        endproc

; Write 32 bits to EEPROM
; void __uint32_eeprom_store(unsigned long val, unsigned addr);
___uint32_eeprom_store proc
        in      r1, __IOADDRESS(SREG)
        cli
        mov     r31, r23
        mov     r30, r22
        rcall   ___eeprom_wait
        OUTX    EEDR, r24
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r25
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r26
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r27
        out     __IOADDRESS(SREG), r1
        rjmp    ___eeprom_write
        endproc

; Write 64 bits to EEPROM
; void __uint32_eeprom_store(unsigned long val, unsigned addr);
___uint64_eeprom_store proc
        ldd     r31, y+1
        ld      r30, y
        rcall   ___eeprom_wait
        OUTX    EEDR, r20
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r21
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r22
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r23
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r24
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r25
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r26
        rcall   ___eeprom_write
        rcall   ___eeprom_wait
        OUTX    EEDR, r27
        rjmp    ___eeprom_write
        endproc

___eeprom_write proc
  ifdef EEARH
        in      r1, __IOADDRESS(SREG)
        cli
        out     __IOADDRESS(EEARH), r31
        out     __IOADDRESS(EEARL), r30
  else
        out     __IOADDRESS(EEAR), r30
  endif
        sbi     __IOADDRESS(EECR), 2
        sbi     __IOADDRESS(EECR), 1
        out     __IOADDRESS(SREG), r1
        adiw    r30, 1
        ret
        endproc

___eeprom_wait proc
        noopt
        sbic    __IOADDRESS(EECR), 1
        jmp     ___eeprom_wait
        opt
        ret
        endproc

___eeprom_read proc
  ifdef EEARH
        in      r0, __IOADDRESS(SREG)
        cli
        out     __IOADDRESS(EEARH), r31
        out     __IOADDRESS(EEARL), r30
  else
        out     __IOADDRESS(EEAR), r30
  endif        
        sbi     __IOADDRESS(EECR), 0
        INX     r1, EEDR
        out     __IOADDRESS(SREG), r0
        clr     r0
        adiw    r30, 1
        ret
        endproc

; Read 8 bits from EEPROM
; unsigned char __uint8_eeprom_load(unsigned addr);
___uint8_eeprom_load proc
        mov     r31, r27
        mov     r30, r26
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r27, r1
        ret
        endproc

; Read 16 bits from EEPROM
; unsigned __uint16_eeprom_load(unsigned addr);
___uint16_eeprom_load proc
        mov     r31, r27
        mov     r30, r26
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r26, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r27, r1
        ret
        endproc

; Read 32 bits from EEPROM
; unsigned long __uint32_eeprom_load(unsigned addr);
___uint32_eeprom_load proc
        mov     r31, r27
        mov     r30, r26
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r24, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r25, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r26, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r27, r1
        ret
        endproc

; Read 64 bits from EEPROM
; unsigned long long __uint64_eeprom_load(unsigned addr);
___uint64_eeprom_load proc
        mov     r31, r27
        mov     r30, r26
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r20, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r21, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r22, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r23, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r24, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r25, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r26, r1
        rcall   ___eeprom_wait
        rcall   ___eeprom_read
        mov     r27, r1
        ret
        endproc

; Destination (data), source (eeprom), count
___struct_asgn_data_ee proc

; Save working registers
        rcall   ___save_registers

; Set Z = eeprom address
        ldd     r31, y+6+3
        ldd     r30, y+6+2

; Set X = data address
        ldd     r27, y+6+5
        ldd     r26, y+6+4

; Get count
        ldd     r25, y+6+1
        ldd     r24, y+6+0

; Transfer byte from eeprom to data
L$11    rcall   ___eeprom_wait
        rcall   ___eeprom_read
        st      x+, r1

; Loop until done
        sbiw    r24, 1
        brne    L$11

; Restore working registers and return
        rjmp    ___restore_registers
        endproc

; Destination (eeprom), source (data), count
___struct_asgn_ee_data proc

; Save working registers
        rcall   ___save_registers

; Set Z = eeprom address
        ldd     r31, y+6+5
        ldd     r30, y+6+4

; Set X = data address
        ldd     r27, y+6+3
        ldd     r26, y+6+2

; Get count
        ldd     r25, y+6+1
        ldd     r24, y+6+0

; Transfer byte from data to eeprom
L$21    rcall   ___eeprom_wait
        ld      r1, x+
        OUTX    EEDR, r1
        rcall   ___eeprom_write

; Loop until done
        sbiw    r24, 1
        brne    L$21

; Restore working registers and return
        rjmp    ___restore_registers
        endproc

___save_registers proc
        st      -y, r31
        st      -y, r30
        st      -y, r27
        st      -y, r26
        st      -y, r25
        st      -y, r24
        ret
        endproc

___restore_registers proc
        ld      r24, y+
        ld      r25, y+
        ld      r26, y+
        ld      r27, y+
        ld      r30, y+
        ld      r31, y+
        ret
        endproc

; Destination (eeprom), source (code), count
___struct_asgn_ee_c proc

; Save working registers
        rcall   ___save_registers

; Set X = eeprom address
        ldd     r27, y+6+5
        ldd     r26, y+6+4

; Set Z = code address
        ldd     r31, y+6+3
        ldd     r30, y+6+2

; Get count
        ldd     r25, y+6+1
        ldd     r24, y+6+0

; Transfer byte from code to eeprom
L$31    rcall   ___eeprom_wait
        lpm     r1, z+
        OUTX    EEDR, r1
  ifdef EEARH
        out     __IOADDRESS(EEARH), r27
        out     __IOADDRESS(EEARL), r26
  else
        out     __IOADDRESS(EEAR), r26
  endif
        sbi     __IOADDRESS(EECR), 2
        sbi     __IOADDRESS(EECR), 1
        adiw    r26, 1

; Loop until done
        sbiw    r24, 1
        brne    L$31

; Restore working registers and return
        rjmp    ___restore_registers
        endproc

  endif // ifdef EEDR


; Heap data structures; removed by the linker if the heap isn't used.
        data
___heap_start__::
        dw      0
        ds      heap_size
        ds      heap_size-4    

#ifndef __NOVECTORS
        ; Reset vector
        vectors
        keep
        org     0
        rjmp    __reset
#endif

; Initialise the IDATA0 section by duplicating the contents into the
; CONST section and copying them on startup.
        const
data_init_begin:
        init    "IDATA0"
data_init_end:
        even
