// Rowley C Compiler, runtime support.
//
// Copyright (c) 2004, 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __stdio_c_H
#define __stdio_c_H

// Again, can't just #include <stddef.h> to get a tranche of common
// definitions, nor #include <stdarg.h> to get va_list, so #include
// "__crossworks.h" to get the private versions of all.
#include "__crossworks.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef EOF
#define EOF (-1)
#endif

#ifndef __SIZE_T_DEFINED
#define __SIZE_T_DEFINED
typedef __SIZE_T size_t;
#endif

int puts_c(const __code char *);
int sprintf_c(char *, const __code char *, ...);
int snprintf_c(char *, size_t, const __code char *, ...);
int vsnprintf_c(char *, size_t, const __code char *, __va_list);

int printf_c(const __code char *, ...);
int vprintf_c(const __code char *, __va_list);
int vsprintf_c(char *, const __code char *, __va_list);

int scanf_c(const __code char *, ...);
int sscanf_c(const char *, const __code char *, ...);
int vscanf_c(const __code char *, __va_list);
int vsscanf_c(const char *, const __code char *, __va_list);

#ifdef __cplusplus
}
#endif

#endif
