#ifndef __ATtiny261_h
#define __ATtiny261_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0002
#define PCINT_vect 0x0004
#define TIMER1_COMPA_vect 0x0006
#define TIMER1_COMPB_vect 0x0008
#define TIMER1_OVF_vect 0x000a
#define TIMER0_OVF_vect 0x000c
#define USI_START_vect 0x000e
#define USI_OVF_vect 0x0010
#define EE_RDY_vect 0x0012
#define ANA_COMP_vect 0x0014
#define ADC_vect 0x0016
#define WDT_vect 0x0018
#define INT1_vect 0x001a
#define TIMER0_COMPA_vect 0x001c
#define TIMER0_COMPB_vect 0x001e
#define TIMER0_CAPT_vect 0x0020
#define TIMER1_COMPD_vect 0x0022
#define FAULT_PROTECTION_vect 0x0024

// I/O addresses


sfrb SREG = 0x5f;

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrb GIMSK = 0x5b;
#define PCIE0 4
#define PCIE0_BIT 4
#define PCIE0_MASK 16
#define PCIE1 5
#define PCIE1_BIT 5
#define PCIE1_MASK 32
#define INT0 6
#define INT0_BIT 6
#define INT0_MASK 64
#define INT1 7
#define INT1_BIT 7
#define INT1_MASK 128

sfrb GIFR = 0x5a;
#define PCIF 5
#define PCIF_BIT 5
#define PCIF_MASK 32
#define INTF0 6
#define INTF0_BIT 6
#define INTF0_MASK 64
#define INTF1 7
#define INTF1_BIT 7
#define INTF1_MASK 128

sfrb TIMSK = 0x59;
#define TICIE0 0
#define TICIE0_BIT 0
#define TICIE0_MASK 1
#define TOIE0 1
#define TOIE0_BIT 1
#define TOIE0_MASK 2
#define TOIE1 2
#define TOIE1_BIT 2
#define TOIE1_MASK 4
#define OCIE0B 3
#define OCIE0B_BIT 3
#define OCIE0B_MASK 8
#define OCIE0A 4
#define OCIE0A_BIT 4
#define OCIE0A_MASK 16
#define OCIE1B 5
#define OCIE1B_BIT 5
#define OCIE1B_MASK 32
#define OCIE1A 6
#define OCIE1A_BIT 6
#define OCIE1A_MASK 64
#define OCIE1D 7
#define OCIE1D_BIT 7
#define OCIE1D_MASK 128

sfrb TIFR = 0x58;
#define ICF0 0
#define ICF0_BIT 0
#define ICF0_MASK 1
#define TOV0 1
#define TOV0_BIT 1
#define TOV0_MASK 2
#define TOV1 2
#define TOV1_BIT 2
#define TOV1_MASK 4
#define OCF0B 3
#define OCF0B_BIT 3
#define OCF0B_MASK 8
#define OCF0A 4
#define OCF0A_BIT 4
#define OCF0A_MASK 16
#define OCF1B 5
#define OCF1B_BIT 5
#define OCF1B_MASK 32
#define OCF1A 6
#define OCF1A_BIT 6
#define OCF1A_MASK 64
#define OCF1D 7
#define OCF1D_BIT 7
#define OCF1D_MASK 128

sfrb SPMCSR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define RFLB 3
#define RFLB_BIT 3
#define RFLB_MASK 8
#define CTPB 4
#define CTPB_BIT 4
#define CTPB_MASK 16

sfrb PRR = 0x56;
#define PRADC 0
#define PRADC_BIT 0
#define PRADC_MASK 1
#define PRUSI 1
#define PRUSI_BIT 1
#define PRUSI_MASK 2
#define PRTIM0 2
#define PRTIM0_BIT 2
#define PRTIM0_MASK 4
#define PRTIM1 3
#define PRTIM1_BIT 3
#define PRTIM1_MASK 8

sfrb MCUCR = 0x55;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define SM0 3
#define SM0_BIT 3
#define SM0_MASK 8
#define SM1 4
#define SM1_BIT 4
#define SM1_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32
#define PUD 6
#define PUD_BIT 6
#define PUD_MASK 64

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8

sfrb TCCR0B = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define PSR0 3
#define PSR0_BIT 3
#define PSR0_MASK 8
#define TSM 4
#define TSM_BIT 4
#define TSM_MASK 16

sfrb TCNT0L = 0x52;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb OSCCAL = 0x51;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64
#define CAL7 7
#define CAL7_BIT 7
#define CAL7_MASK 128

sfrb TCCR1A = 0x50;
#define PWM1B 0
#define PWM1B_BIT 0
#define PWM1B_MASK 1
#define PWM1A 1
#define PWM1A_BIT 1
#define PWM1A_MASK 2
#define FOC1B 2
#define FOC1B_BIT 2
#define FOC1B_MASK 4
#define FOC1A 3
#define FOC1A_BIT 3
#define FOC1A_MASK 8
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb TCCR1B = 0x4f;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define CS13 3
#define CS13_BIT 3
#define CS13_MASK 8
#define DTPS10 4
#define DTPS10_BIT 4
#define DTPS10_MASK 16
#define DTPS11 5
#define DTPS11_BIT 5
#define DTPS11_MASK 32
#define PSR1 6
#define PSR1_BIT 6
#define PSR1_MASK 64

sfrb TCNT1 = 0x4e;
#define TC1H_0 0
#define TC1H_0_BIT 0
#define TC1H_0_MASK 1
#define TC1H_1 1
#define TC1H_1_BIT 1
#define TC1H_1_MASK 2
#define TC1H_2 2
#define TC1H_2_BIT 2
#define TC1H_2_MASK 4
#define TC1H_3 3
#define TC1H_3_BIT 3
#define TC1H_3_MASK 8
#define TC1H_4 4
#define TC1H_4_BIT 4
#define TC1H_4_MASK 16
#define TC1H_5 5
#define TC1H_5_BIT 5
#define TC1H_5_MASK 32
#define TC1H_6 6
#define TC1H_6_BIT 6
#define TC1H_6_MASK 64
#define TC1H_7 7
#define TC1H_7_BIT 7
#define TC1H_7_MASK 128

sfrb OCR1A = 0x4d;
#define OCR1A0 0
#define OCR1A0_BIT 0
#define OCR1A0_MASK 1
#define OCR1A1 1
#define OCR1A1_BIT 1
#define OCR1A1_MASK 2
#define OCR1A2 2
#define OCR1A2_BIT 2
#define OCR1A2_MASK 4
#define OCR1A3 3
#define OCR1A3_BIT 3
#define OCR1A3_MASK 8
#define OCR1A4 4
#define OCR1A4_BIT 4
#define OCR1A4_MASK 16
#define OCR1A5 5
#define OCR1A5_BIT 5
#define OCR1A5_MASK 32
#define OCR1A6 6
#define OCR1A6_BIT 6
#define OCR1A6_MASK 64
#define OCR1A7 7
#define OCR1A7_BIT 7
#define OCR1A7_MASK 128

sfrb OCR1B = 0x4c;
#define OCR1B0 0
#define OCR1B0_BIT 0
#define OCR1B0_MASK 1
#define OCR1B1 1
#define OCR1B1_BIT 1
#define OCR1B1_MASK 2
#define OCR1B2 2
#define OCR1B2_BIT 2
#define OCR1B2_MASK 4
#define OCR1B3 3
#define OCR1B3_BIT 3
#define OCR1B3_MASK 8
#define OCR1B4 4
#define OCR1B4_BIT 4
#define OCR1B4_MASK 16
#define OCR1B5 5
#define OCR1B5_BIT 5
#define OCR1B5_MASK 32
#define OCR1B6 6
#define OCR1B6_BIT 6
#define OCR1B6_MASK 64
#define OCR1B7 7
#define OCR1B7_BIT 7
#define OCR1B7_MASK 128

sfrb OCR1C = 0x4b;
#define OCR1C0 0
#define OCR1C0_BIT 0
#define OCR1C0_MASK 1
#define OCR1C1 1
#define OCR1C1_BIT 1
#define OCR1C1_MASK 2
#define OCR1C2 2
#define OCR1C2_BIT 2
#define OCR1C2_MASK 4
#define OCR1C3 3
#define OCR1C3_BIT 3
#define OCR1C3_MASK 8
#define OCR1C4 4
#define OCR1C4_BIT 4
#define OCR1C4_MASK 16
#define OCR1C5 5
#define OCR1C5_BIT 5
#define OCR1C5_MASK 32
#define OCR1C6 6
#define OCR1C6_BIT 6
#define OCR1C6_MASK 64
#define OCR1C7 7
#define OCR1C7_BIT 7
#define OCR1C7_MASK 128

sfrb OCR1D = 0x4a;
#define OCR1D0 0
#define OCR1D0_BIT 0
#define OCR1D0_MASK 1
#define OCR1D1 1
#define OCR1D1_BIT 1
#define OCR1D1_MASK 2
#define OCR1D2 2
#define OCR1D2_BIT 2
#define OCR1D2_MASK 4
#define OCR1D3 3
#define OCR1D3_BIT 3
#define OCR1D3_MASK 8
#define OCR1D4 4
#define OCR1D4_BIT 4
#define OCR1D4_MASK 16
#define OCR1D5 5
#define OCR1D5_BIT 5
#define OCR1D5_MASK 32
#define OCR1D6 6
#define OCR1D6_BIT 6
#define OCR1D6_MASK 64
#define OCR1C7 7
#define OCR1C7_BIT 7
#define OCR1C7_MASK 128

sfrb PLLCSR = 0x49;
#define PLOCK 0
#define PLOCK_BIT 0
#define PLOCK_MASK 1
#define PLLE 1
#define PLLE_BIT 1
#define PLLE_MASK 2
#define PCKE 2
#define PCKE_BIT 2
#define PCKE_MASK 4
#define LSM 7
#define LSM_BIT 7
#define LSM_MASK 128

sfrb CLKPR = 0x48;
#define CLKPS0 0
#define CLKPS0_BIT 0
#define CLKPS0_MASK 1
#define CLKPS1 1
#define CLKPS1_BIT 1
#define CLKPS1_MASK 2
#define CLKPS2 2
#define CLKPS2_BIT 2
#define CLKPS2_MASK 4
#define CLKPS3 3
#define CLKPS3_BIT 3
#define CLKPS3_MASK 8
#define CLKPCE 7
#define CLKPCE_BIT 7
#define CLKPCE_MASK 128

sfrb TCCR1C = 0x47;
#define PWM1D 0
#define PWM1D_BIT 0
#define PWM1D_MASK 1
#define FOC1D 1
#define FOC1D_BIT 1
#define FOC1D_MASK 2
#define COM1D0 2
#define COM1D0_BIT 2
#define COM1D0_MASK 4
#define COM1D1 3
#define COM1D1_BIT 3
#define COM1D1_MASK 8
#define COM1B0S 4
#define COM1B0S_BIT 4
#define COM1B0S_MASK 16
#define COM1B1S 5
#define COM1B1S_BIT 5
#define COM1B1S_MASK 32
#define COM1A0S 6
#define COM1A0S_BIT 6
#define COM1A0S_MASK 64
#define COM1A1S 7
#define COM1A1S_BIT 7
#define COM1A1S_MASK 128

sfrb TCCR1D = 0x46;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define FPF1 2
#define FPF1_BIT 2
#define FPF1_MASK 4
#define FPAC1 3
#define FPAC1_BIT 3
#define FPAC1_MASK 8
#define FPES1 4
#define FPES1_BIT 4
#define FPES1_MASK 16
#define FPNC1 5
#define FPNC1_BIT 5
#define FPNC1_MASK 32
#define FPEN1 6
#define FPEN1_BIT 6
#define FPEN1_MASK 64
#define FPIE1 7
#define FPIE1_BIT 7
#define FPIE1_MASK 128

sfrb TC1H = 0x45;
#define TC18 0
#define TC18_BIT 0
#define TC18_MASK 1
#define TC19 1
#define TC19_BIT 1
#define TC19_MASK 2

sfrb DT1 = 0x44;
#define DT1L0 0
#define DT1L0_BIT 0
#define DT1L0_MASK 1
#define DT1L1 1
#define DT1L1_BIT 1
#define DT1L1_MASK 2
#define DT1L2 2
#define DT1L2_BIT 2
#define DT1L2_MASK 4
#define DT1L3 3
#define DT1L3_BIT 3
#define DT1L3_MASK 8
#define DT1H0 4
#define DT1H0_BIT 4
#define DT1H0_MASK 16
#define DT1H1 5
#define DT1H1_BIT 5
#define DT1H1_MASK 32
#define DT1H2 6
#define DT1H2_BIT 6
#define DT1H2_MASK 64
#define DT1H3 7
#define DT1H3_BIT 7
#define DT1H3_MASK 128

sfrb PCMSK0 = 0x43;
#define PCINT0 0
#define PCINT0_BIT 0
#define PCINT0_MASK 1
#define PCINT1 1
#define PCINT1_BIT 1
#define PCINT1_MASK 2
#define PCINT2 2
#define PCINT2_BIT 2
#define PCINT2_MASK 4
#define PCINT3 3
#define PCINT3_BIT 3
#define PCINT3_MASK 8
#define PCINT4 4
#define PCINT4_BIT 4
#define PCINT4_MASK 16
#define PCINT5 5
#define PCINT5_BIT 5
#define PCINT5_MASK 32
#define PCINT6 6
#define PCINT6_BIT 6
#define PCINT6_MASK 64
#define PCINT7 7
#define PCINT7_BIT 7
#define PCINT7_MASK 128

sfrb PCMSK1 = 0x42;
#define PCINT8 0
#define PCINT8_BIT 0
#define PCINT8_MASK 1
#define PCINT9 1
#define PCINT9_BIT 1
#define PCINT9_MASK 2
#define PCINT10 2
#define PCINT10_BIT 2
#define PCINT10_MASK 4
#define PCINT11 3
#define PCINT11_BIT 3
#define PCINT11_MASK 8
#define PCINT12 4
#define PCINT12_BIT 4
#define PCINT12_MASK 16
#define PCINT13 5
#define PCINT13_BIT 5
#define PCINT13_MASK 32
#define PCINT14 6
#define PCINT14_BIT 6
#define PCINT14_MASK 64
#define PCINT15 7
#define PCINT15_BIT 7
#define PCINT15_MASK 128

sfrb WDTCR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16
#define WDP3 5
#define WDP3_BIT 5
#define WDP3_MASK 32
#define WDIE 6
#define WDIE_BIT 6
#define WDIE_MASK 64
#define WDIF 7
#define WDIF_BIT 7
#define WDIF_MASK 128

sfrb DWDR = 0x40;
#define DWDR0 0
#define DWDR0_BIT 0
#define DWDR0_MASK 1
#define DWDR1 1
#define DWDR1_BIT 1
#define DWDR1_MASK 2
#define DWDR2 2
#define DWDR2_BIT 2
#define DWDR2_MASK 4
#define DWDR3 3
#define DWDR3_BIT 3
#define DWDR3_MASK 8
#define DWDR4 4
#define DWDR4_BIT 4
#define DWDR4_MASK 16
#define DWDR5 5
#define DWDR5_BIT 5
#define DWDR5_MASK 32
#define DWDR6 6
#define DWDR6_BIT 6
#define DWDR6_MASK 64
#define DWDR7 7
#define DWDR7_BIT 7
#define DWDR7_MASK 128

sfrb EEARH = 0x3f;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1

sfrb EEARL = 0x3e;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64
#define EEAR7 7
#define EEAR7_BIT 7
#define EEAR7_MASK 128

sfrw EEARW = 0x3e;

sfrb EEDR = 0x3d;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3c;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEPE 1
#define EEPE_BIT 1
#define EEPE_MASK 2
#define EEMPE 2
#define EEMPE_BIT 2
#define EEMPE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8
#define EEPM0 4
#define EEPM0_BIT 4
#define EEPM0_MASK 16
#define EEPM1 5
#define EEPM1_BIT 5
#define EEPM1_MASK 32

sfrb PORTA = 0x3b;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8
#define PORTA4 4
#define PORTA4_BIT 4
#define PORTA4_MASK 16
#define PORTA5 5
#define PORTA5_BIT 5
#define PORTA5_MASK 32
#define PORTA6 6
#define PORTA6_BIT 6
#define PORTA6_MASK 64
#define PORTA7 7
#define PORTA7_BIT 7
#define PORTA7_MASK 128

sfrb DDRA = 0x3a;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define DDA2 2
#define DDA2_BIT 2
#define DDA2_MASK 4
#define DDA3 3
#define DDA3_BIT 3
#define DDA3_MASK 8
#define DDA4 4
#define DDA4_BIT 4
#define DDA4_MASK 16
#define DDA5 5
#define DDA5_BIT 5
#define DDA5_MASK 32
#define DDA6 6
#define DDA6_BIT 6
#define DDA6_MASK 64
#define DDA7 7
#define DDA7_BIT 7
#define DDA7_MASK 128

sfrb PINA = 0x39;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8
#define PINA4 4
#define PINA4_BIT 4
#define PINA4_MASK 16
#define PINA5 5
#define PINA5_BIT 5
#define PINA5_MASK 32
#define PINA6 6
#define PINA6_BIT 6
#define PINA6_MASK 64
#define PINA7 7
#define PINA7_BIT 7
#define PINA7_MASK 128

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x37;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb TCCR0A = 0x35;
#define WGM00 0
#define WGM00_BIT 0
#define WGM00_MASK 1
#define ACIC0 3
#define ACIC0_BIT 3
#define ACIC0_MASK 8
#define ICES0 4
#define ICES0_BIT 4
#define ICES0_MASK 16
#define ICNC0 5
#define ICNC0_BIT 5
#define ICNC0_MASK 32
#define ICEN0 6
#define ICEN0_BIT 6
#define ICEN0_MASK 64
#define TCW0 7
#define TCW0_BIT 7
#define TCW0_MASK 128

sfrb TCNT0H = 0x34;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb OCR0A = 0x33;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb OCR0B = 0x32;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb USIPP = 0x31;
#define USIPOS 0
#define USIPOS_BIT 0
#define USIPOS_MASK 1

sfrb USIBR = 0x30;
#define USIBR0 0
#define USIBR0_BIT 0
#define USIBR0_MASK 1
#define USIBR1 1
#define USIBR1_BIT 1
#define USIBR1_MASK 2
#define USIBR2 2
#define USIBR2_BIT 2
#define USIBR2_MASK 4
#define USIBR3 3
#define USIBR3_BIT 3
#define USIBR3_MASK 8
#define USIBR4 4
#define USIBR4_BIT 4
#define USIBR4_MASK 16
#define USIBR5 5
#define USIBR5_BIT 5
#define USIBR5_MASK 32
#define USIBR6 6
#define USIBR6_BIT 6
#define USIBR6_MASK 64
#define USIBR7 7
#define USIBR7_BIT 7
#define USIBR7_MASK 128

sfrb USIDR = 0x2f;
#define USIDR0 0
#define USIDR0_BIT 0
#define USIDR0_MASK 1
#define USIDR1 1
#define USIDR1_BIT 1
#define USIDR1_MASK 2
#define USIDR2 2
#define USIDR2_BIT 2
#define USIDR2_MASK 4
#define USIDR3 3
#define USIDR3_BIT 3
#define USIDR3_MASK 8
#define USIDR4 4
#define USIDR4_BIT 4
#define USIDR4_MASK 16
#define USIDR5 5
#define USIDR5_BIT 5
#define USIDR5_MASK 32
#define USIDR6 6
#define USIDR6_BIT 6
#define USIDR6_MASK 64
#define USIDR7 7
#define USIDR7_BIT 7
#define USIDR7_MASK 128

sfrb USISR = 0x2e;
#define USICNT0 0
#define USICNT0_BIT 0
#define USICNT0_MASK 1
#define USICNT1 1
#define USICNT1_BIT 1
#define USICNT1_MASK 2
#define USICNT2 2
#define USICNT2_BIT 2
#define USICNT2_MASK 4
#define USICNT3 3
#define USICNT3_BIT 3
#define USICNT3_MASK 8
#define USIDC 4
#define USIDC_BIT 4
#define USIDC_MASK 16
#define USIPF 5
#define USIPF_BIT 5
#define USIPF_MASK 32
#define USIOIF 6
#define USIOIF_BIT 6
#define USIOIF_MASK 64
#define USISIF 7
#define USISIF_BIT 7
#define USISIF_MASK 128

sfrb USICR = 0x2d;
#define USITC 0
#define USITC_BIT 0
#define USITC_MASK 1
#define USICLK 1
#define USICLK_BIT 1
#define USICLK_MASK 2
#define USICS0 2
#define USICS0_BIT 2
#define USICS0_MASK 4
#define USICS1 3
#define USICS1_BIT 3
#define USICS1_MASK 8
#define USIWM0 4
#define USIWM0_BIT 4
#define USIWM0_MASK 16
#define USIWM1 5
#define USIWM1_BIT 5
#define USIWM1_MASK 32
#define USIOIE 6
#define USIOIE_BIT 6
#define USIOIE_MASK 64
#define USISIE 7
#define USISIE_BIT 7
#define USISIE_MASK 128

sfrb GPIOR2 = 0x2c;
#define GPIOR20 0
#define GPIOR20_BIT 0
#define GPIOR20_MASK 1
#define GPIOR21 1
#define GPIOR21_BIT 1
#define GPIOR21_MASK 2
#define GPIOR22 2
#define GPIOR22_BIT 2
#define GPIOR22_MASK 4
#define GPIOR23 3
#define GPIOR23_BIT 3
#define GPIOR23_MASK 8
#define GPIOR24 4
#define GPIOR24_BIT 4
#define GPIOR24_MASK 16
#define GPIOR25 5
#define GPIOR25_BIT 5
#define GPIOR25_MASK 32
#define GPIOR26 6
#define GPIOR26_BIT 6
#define GPIOR26_MASK 64
#define GPIOR27 7
#define GPIOR27_BIT 7
#define GPIOR27_MASK 128

sfrb GPIOR1 = 0x2b;
#define GPIOR10 0
#define GPIOR10_BIT 0
#define GPIOR10_MASK 1
#define GPIOR11 1
#define GPIOR11_BIT 1
#define GPIOR11_MASK 2
#define GPIOR12 2
#define GPIOR12_BIT 2
#define GPIOR12_MASK 4
#define GPIOR13 3
#define GPIOR13_BIT 3
#define GPIOR13_MASK 8
#define GPIOR14 4
#define GPIOR14_BIT 4
#define GPIOR14_MASK 16
#define GPIOR15 5
#define GPIOR15_BIT 5
#define GPIOR15_MASK 32
#define GPIOR16 6
#define GPIOR16_BIT 6
#define GPIOR16_MASK 64
#define GPIOR17 7
#define GPIOR17_BIT 7
#define GPIOR17_MASK 128

sfrb GPIOR0 = 0x2a;
#define GPIOR00 0
#define GPIOR00_BIT 0
#define GPIOR00_MASK 1
#define GPIOR01 1
#define GPIOR01_BIT 1
#define GPIOR01_MASK 2
#define GPIOR02 2
#define GPIOR02_BIT 2
#define GPIOR02_MASK 4
#define GPIOR03 3
#define GPIOR03_BIT 3
#define GPIOR03_MASK 8
#define GPIOR04 4
#define GPIOR04_BIT 4
#define GPIOR04_MASK 16
#define GPIOR05 5
#define GPIOR05_BIT 5
#define GPIOR05_MASK 32
#define GPIOR06 6
#define GPIOR06_BIT 6
#define GPIOR06_MASK 64
#define GPIOR07 7
#define GPIOR07_BIT 7
#define GPIOR07_MASK 128

sfrb ACSRB = 0x29;
#define ACM0 0
#define ACM0_BIT 0
#define ACM0_MASK 1
#define ACM1 1
#define ACM1_BIT 1
#define ACM1_MASK 2
#define ACM2 2
#define ACM2_BIT 2
#define ACM2_MASK 4
#define HLEV 6
#define HLEV_BIT 6
#define HLEV_MASK 64
#define HSEL 7
#define HSEL_BIT 7
#define HSEL_MASK 128

sfrb ACSRA = 0x28;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACME 2
#define ACME_BIT 2
#define ACME_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb ADMUX = 0x27;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define MUX2 2
#define MUX2_BIT 2
#define MUX2_MASK 4
#define MUX3 3
#define MUX3_BIT 3
#define MUX3_MASK 8
#define MUX4 4
#define MUX4_BIT 4
#define MUX4_MASK 16
#define ADLAR 5
#define ADLAR_BIT 5
#define ADLAR_MASK 32
#define REFS0 6
#define REFS0_BIT 6
#define REFS0_MASK 64
#define REFS1 7
#define REFS1_BIT 7
#define REFS1_MASK 128

sfrb ADCSRA = 0x26;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADATE 5
#define ADATE_BIT 5
#define ADATE_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x25;
#define ADCH0 0
#define ADCH0_BIT 0
#define ADCH0_MASK 1
#define ADCH1 1
#define ADCH1_BIT 1
#define ADCH1_MASK 2
#define ADCH2 2
#define ADCH2_BIT 2
#define ADCH2_MASK 4
#define ADCH3 3
#define ADCH3_BIT 3
#define ADCH3_MASK 8
#define ADCH4 4
#define ADCH4_BIT 4
#define ADCH4_MASK 16
#define ADCH5 5
#define ADCH5_BIT 5
#define ADCH5_MASK 32
#define ADCH6 6
#define ADCH6_BIT 6
#define ADCH6_MASK 64
#define ADCH7 7
#define ADCH7_BIT 7
#define ADCH7_MASK 128

sfrb ADCL = 0x24;
#define ADCL0 0
#define ADCL0_BIT 0
#define ADCL0_MASK 1
#define ADCL1 1
#define ADCL1_BIT 1
#define ADCL1_MASK 2
#define ADCL2 2
#define ADCL2_BIT 2
#define ADCL2_MASK 4
#define ADCL3 3
#define ADCL3_BIT 3
#define ADCL3_MASK 8
#define ADCL4 4
#define ADCL4_BIT 4
#define ADCL4_MASK 16
#define ADCL5 5
#define ADCL5_BIT 5
#define ADCL5_MASK 32
#define ADCL6 6
#define ADCL6_BIT 6
#define ADCL6_MASK 64
#define ADCL7 7
#define ADCL7_BIT 7
#define ADCL7_MASK 128

sfrw ADCW = 0x24;

sfrb ADCSRB = 0x23;
#define ADTS0 0
#define ADTS0_BIT 0
#define ADTS0_MASK 1
#define ADTS1 1
#define ADTS1_BIT 1
#define ADTS1_MASK 2
#define ADTS2 2
#define ADTS2_BIT 2
#define ADTS2_MASK 4
#define MUX5 3
#define MUX5_BIT 3
#define MUX5_MASK 8
#define REFS2 4
#define REFS2_BIT 4
#define REFS2_MASK 16
#define IPR 5
#define IPR_BIT 5
#define IPR_MASK 32
#define GSEL 6
#define GSEL_BIT 6
#define GSEL_MASK 64
#define BIN 7
#define BIN_BIT 7
#define BIN_MASK 128

sfrb DIDR1 = 0x22;
#define ADC7D 4
#define ADC7D_BIT 4
#define ADC7D_MASK 16
#define ADC8D 5
#define ADC8D_BIT 5
#define ADC8D_MASK 32
#define ADC9D 6
#define ADC9D_BIT 6
#define ADC9D_MASK 64
#define ADC10D 7
#define ADC10D_BIT 7
#define ADC10D_MASK 128

sfrb DIDR0 = 0x21;
#define ADC0D 0
#define ADC0D_BIT 0
#define ADC0D_MASK 1
#define ADC1D 1
#define ADC1D_BIT 1
#define ADC1D_MASK 2
#define ADC2D 2
#define ADC2D_BIT 2
#define ADC2D_MASK 4
#define AREFD 3
#define AREFD_BIT 3
#define AREFD_MASK 8
#define ADC3D 4
#define ADC3D_BIT 4
#define ADC3D_MASK 16
#define ADC4D 5
#define ADC4D_BIT 5
#define ADC4D_MASK 32
#define ADC5D 6
#define ADC5D_BIT 6
#define ADC5D_MASK 64
#define ADC6D 7
#define ADC6D_BIT 7
#define ADC6D_MASK 128

sfrb TCCR1E = 0x20;
#define OC1OE0 0
#define OC1OE0_BIT 0
#define OC1OE0_MASK 1
#define OC1OE1 1
#define OC1OE1_BIT 1
#define OC1OE1_MASK 2
#define OC1OE2 2
#define OC1OE2_BIT 2
#define OC1OE2_MASK 4
#define OC1OE3 3
#define OC1OE3_BIT 3
#define OC1OE3_MASK 8
#define OC1OE4 4
#define OC1OE4_BIT 4
#define OC1OE4_MASK 16
#define OC1OE5 5
#define OC1OE5_BIT 5
#define OC1OE5_MASK 32

#endif
