#ifndef __ATtiny26_h
#define __ATtiny26_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0002
#define I/O_PINS_vect 0x0004
#define TIMER1CMPA_vect 0x0006
#define TIMER1CMPB_vect 0x0008
#define TIMER1OVF1_vect 0x000a
#define TIMER0OVF0_vect 0x000c
#define USI_STRT_vect 0x000e
#define USI_OVF_vect 0x0010
#define EE_RDY_vect 0x0012
#define ANA_COMP_vect 0x0014
#define ADC_vect 0x0016

// I/O addresses


sfrb SREG = 0x5f;

sfrb SP = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrb GIMSK = 0x5b;
#define PCIE0 4
#define PCIE0_BIT 4
#define PCIE0_MASK 16
#define PCIE1 5
#define PCIE1_BIT 5
#define PCIE1_MASK 32
#define INT0 6
#define INT0_BIT 6
#define INT0_MASK 64

sfrb GIFR = 0x5a;
#define PCIF 5
#define PCIF_BIT 5
#define PCIF_MASK 32
#define INTF0 6
#define INTF0_BIT 6
#define INTF0_MASK 64

sfrb TIMSK = 0x59;
#define TOIE0 1
#define TOIE0_BIT 1
#define TOIE0_MASK 2
#define TOIE1 2
#define TOIE1_BIT 2
#define TOIE1_MASK 4
#define OCIE1B 5
#define OCIE1B_BIT 5
#define OCIE1B_MASK 32
#define OCIE1A 6
#define OCIE1A_BIT 6
#define OCIE1A_MASK 64

sfrb TIFR = 0x58;
#define TOV0 1
#define TOV0_BIT 1
#define TOV0_MASK 2
#define TOV1 2
#define TOV1_BIT 2
#define TOV1_MASK 4
#define OCF1B 5
#define OCF1B_BIT 5
#define OCF1B_MASK 32
#define OCF1A 6
#define OCF1A_BIT 6
#define OCF1A_MASK 64

sfrb MCUCR = 0x55;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define SM0 3
#define SM0_BIT 3
#define SM0_MASK 8
#define SM1 4
#define SM1_BIT 4
#define SM1_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32
#define PUD 6
#define PUD_BIT 6
#define PUD_MASK 64

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8

sfrb TCCR0 = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define PSR0 3
#define PSR0_BIT 3
#define PSR0_MASK 8

sfrb TCNT0 = 0x52;
#define TCNT00 0
#define TCNT00_BIT 0
#define TCNT00_MASK 1
#define TCNT01 1
#define TCNT01_BIT 1
#define TCNT01_MASK 2
#define TCNT02 2
#define TCNT02_BIT 2
#define TCNT02_MASK 4
#define TCNT03 3
#define TCNT03_BIT 3
#define TCNT03_MASK 8
#define TCNT04 4
#define TCNT04_BIT 4
#define TCNT04_MASK 16
#define TCNT05 5
#define TCNT05_BIT 5
#define TCNT05_MASK 32
#define TCNT06 6
#define TCNT06_BIT 6
#define TCNT06_MASK 64
#define TCNT07 7
#define TCNT07_BIT 7
#define TCNT07_MASK 128

sfrb OSCCAL = 0x51;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64
#define CAL7 7
#define CAL7_BIT 7
#define CAL7_MASK 128

sfrb TCCR1A = 0x50;
#define PWM1B 0
#define PWM1B_BIT 0
#define PWM1B_MASK 1
#define PWM1A 1
#define PWM1A_BIT 1
#define PWM1A_MASK 2
#define FOC1B 2
#define FOC1B_BIT 2
#define FOC1B_MASK 4
#define FOC1A 3
#define FOC1A_BIT 3
#define FOC1A_MASK 8
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb TCCR1B = 0x4f;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define CS13 3
#define CS13_BIT 3
#define CS13_MASK 8
#define PSR1 6
#define PSR1_BIT 6
#define PSR1_MASK 64
#define CTC1 7
#define CTC1_BIT 7
#define CTC1_MASK 128

sfrb TCNT1 = 0x4e;
#define TCNT1_0 0
#define TCNT1_0_BIT 0
#define TCNT1_0_MASK 1
#define TCNT1_1 1
#define TCNT1_1_BIT 1
#define TCNT1_1_MASK 2
#define TCNT1_2 2
#define TCNT1_2_BIT 2
#define TCNT1_2_MASK 4
#define TCNT1_3 3
#define TCNT1_3_BIT 3
#define TCNT1_3_MASK 8
#define TCNT1_4 4
#define TCNT1_4_BIT 4
#define TCNT1_4_MASK 16
#define TCNT1_5 5
#define TCNT1_5_BIT 5
#define TCNT1_5_MASK 32
#define TCNT1_6 6
#define TCNT1_6_BIT 6
#define TCNT1_6_MASK 64
#define TCNT1_7 7
#define TCNT1_7_BIT 7
#define TCNT1_7_MASK 128

sfrb OCR1A = 0x4d;
#define OCR1A0 0
#define OCR1A0_BIT 0
#define OCR1A0_MASK 1
#define OCR1A1 1
#define OCR1A1_BIT 1
#define OCR1A1_MASK 2
#define OCR1A2 2
#define OCR1A2_BIT 2
#define OCR1A2_MASK 4
#define OCR1A3 3
#define OCR1A3_BIT 3
#define OCR1A3_MASK 8
#define OCR1A4 4
#define OCR1A4_BIT 4
#define OCR1A4_MASK 16
#define OCR1A5 5
#define OCR1A5_BIT 5
#define OCR1A5_MASK 32
#define OCR1A6 6
#define OCR1A6_BIT 6
#define OCR1A6_MASK 64
#define OCR1A7 7
#define OCR1A7_BIT 7
#define OCR1A7_MASK 128

sfrb OCR1B = 0x4c;
#define OCR1B0 0
#define OCR1B0_BIT 0
#define OCR1B0_MASK 1
#define OCR1B1 1
#define OCR1B1_BIT 1
#define OCR1B1_MASK 2
#define OCR1B2 2
#define OCR1B2_BIT 2
#define OCR1B2_MASK 4
#define OCR1B3 3
#define OCR1B3_BIT 3
#define OCR1B3_MASK 8
#define OCR1B4 4
#define OCR1B4_BIT 4
#define OCR1B4_MASK 16
#define OCR1B5 5
#define OCR1B5_BIT 5
#define OCR1B5_MASK 32
#define OCR1B6 6
#define OCR1B6_BIT 6
#define OCR1B6_MASK 64
#define OCR1B7 7
#define OCR1B7_BIT 7
#define OCR1B7_MASK 128

sfrb OCR1C = 0x4b;
#define OCR1C0 0
#define OCR1C0_BIT 0
#define OCR1C0_MASK 1
#define OCR1C1 1
#define OCR1C1_BIT 1
#define OCR1C1_MASK 2
#define OCR1C2 2
#define OCR1C2_BIT 2
#define OCR1C2_MASK 4
#define OCR1C3 3
#define OCR1C3_BIT 3
#define OCR1C3_MASK 8
#define OCR1C4 4
#define OCR1C4_BIT 4
#define OCR1C4_MASK 16
#define OCR1C5 5
#define OCR1C5_BIT 5
#define OCR1C5_MASK 32
#define OCR1C6 6
#define OCR1C6_BIT 6
#define OCR1C6_MASK 64
#define OCR1C7 7
#define OCR1C7_BIT 7
#define OCR1C7_MASK 128

sfrb PLLCSR = 0x49;
#define PLOCK 0
#define PLOCK_BIT 0
#define PLOCK_MASK 1
#define PLLE 1
#define PLLE_BIT 1
#define PLLE_MASK 2
#define PCKE 2
#define PCKE_BIT 2
#define PCKE_MASK 4

sfrb WDTCR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16

sfrb EEAR = 0x3e;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64

sfrb EEDR = 0x3d;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3c;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEWE 1
#define EEWE_BIT 1
#define EEWE_MASK 2
#define EEMWE 2
#define EEMWE_BIT 2
#define EEMWE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8

sfrb PORTA = 0x3b;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8
#define PORTA4 4
#define PORTA4_BIT 4
#define PORTA4_MASK 16
#define PORTA5 5
#define PORTA5_BIT 5
#define PORTA5_MASK 32
#define PORTA6 6
#define PORTA6_BIT 6
#define PORTA6_MASK 64
#define PORTA7 7
#define PORTA7_BIT 7
#define PORTA7_MASK 128

sfrb DDRA = 0x3a;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define DDA2 2
#define DDA2_BIT 2
#define DDA2_MASK 4
#define DDA3 3
#define DDA3_BIT 3
#define DDA3_MASK 8
#define DDA4 4
#define DDA4_BIT 4
#define DDA4_MASK 16
#define DDA5 5
#define DDA5_BIT 5
#define DDA5_MASK 32
#define DDA6 6
#define DDA6_BIT 6
#define DDA6_MASK 64
#define DDA7 7
#define DDA7_BIT 7
#define DDA7_MASK 128

sfrb PINA = 0x39;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8
#define PINA4 4
#define PINA4_BIT 4
#define PINA4_MASK 16
#define PINA5 5
#define PINA5_BIT 5
#define PINA5_MASK 32
#define PINA6 6
#define PINA6_BIT 6
#define PINA6_MASK 64
#define PINA7 7
#define PINA7_BIT 7
#define PINA7_MASK 128

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x37;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb USIDR = 0x2f;
#define USIDR0 0
#define USIDR0_BIT 0
#define USIDR0_MASK 1
#define USIDR1 1
#define USIDR1_BIT 1
#define USIDR1_MASK 2
#define USIDR2 2
#define USIDR2_BIT 2
#define USIDR2_MASK 4
#define USIDR3 3
#define USIDR3_BIT 3
#define USIDR3_MASK 8
#define USIDR4 4
#define USIDR4_BIT 4
#define USIDR4_MASK 16
#define USIDR5 5
#define USIDR5_BIT 5
#define USIDR5_MASK 32
#define USIDR6 6
#define USIDR6_BIT 6
#define USIDR6_MASK 64
#define USIDR7 7
#define USIDR7_BIT 7
#define USIDR7_MASK 128

sfrb USISR = 0x2e;
#define USICNT0 0
#define USICNT0_BIT 0
#define USICNT0_MASK 1
#define USICNT1 1
#define USICNT1_BIT 1
#define USICNT1_MASK 2
#define USICNT2 2
#define USICNT2_BIT 2
#define USICNT2_MASK 4
#define USICNT3 3
#define USICNT3_BIT 3
#define USICNT3_MASK 8
#define USIDC 4
#define USIDC_BIT 4
#define USIDC_MASK 16
#define USIPF 5
#define USIPF_BIT 5
#define USIPF_MASK 32
#define USIOIF 6
#define USIOIF_BIT 6
#define USIOIF_MASK 64
#define USISIF 7
#define USISIF_BIT 7
#define USISIF_MASK 128

sfrb USICR = 0x2d;
#define USITC 0
#define USITC_BIT 0
#define USITC_MASK 1
#define USICLK 1
#define USICLK_BIT 1
#define USICLK_MASK 2
#define USICS0 2
#define USICS0_BIT 2
#define USICS0_MASK 4
#define USICS1 3
#define USICS1_BIT 3
#define USICS1_MASK 8
#define USIWM0 4
#define USIWM0_BIT 4
#define USIWM0_MASK 16
#define USIWM1 5
#define USIWM1_BIT 5
#define USIWM1_MASK 32
#define USIOIE 6
#define USIOIE_BIT 6
#define USIOIE_MASK 64
#define USISIE 7
#define USISIE_BIT 7
#define USISIE_MASK 128

sfrb ACSR = 0x28;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACME 2
#define ACME_BIT 2
#define ACME_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb ADMUX = 0x27;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define MUX2 2
#define MUX2_BIT 2
#define MUX2_MASK 4
#define MUX3 3
#define MUX3_BIT 3
#define MUX3_MASK 8
#define MUX4 4
#define MUX4_BIT 4
#define MUX4_MASK 16
#define ADLAR 5
#define ADLAR_BIT 5
#define ADLAR_MASK 32
#define REFS0 6
#define REFS0_BIT 6
#define REFS0_MASK 64
#define REFS1 7
#define REFS1_BIT 7
#define REFS1_MASK 128

sfrb ADCSR = 0x26;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADFR 5
#define ADFR_BIT 5
#define ADFR_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x25;
#define ADCH0 0
#define ADCH0_BIT 0
#define ADCH0_MASK 1
#define ADCH1 1
#define ADCH1_BIT 1
#define ADCH1_MASK 2
#define ADCH2 2
#define ADCH2_BIT 2
#define ADCH2_MASK 4
#define ADCH3 3
#define ADCH3_BIT 3
#define ADCH3_MASK 8
#define ADCH4 4
#define ADCH4_BIT 4
#define ADCH4_MASK 16
#define ADCH5 5
#define ADCH5_BIT 5
#define ADCH5_MASK 32
#define ADCH6 6
#define ADCH6_BIT 6
#define ADCH6_MASK 64
#define ADCH7 7
#define ADCH7_BIT 7
#define ADCH7_MASK 128

sfrb ADCL = 0x24;
#define ADCL0 0
#define ADCL0_BIT 0
#define ADCL0_MASK 1
#define ADCL1 1
#define ADCL1_BIT 1
#define ADCL1_MASK 2
#define ADCL2 2
#define ADCL2_BIT 2
#define ADCL2_MASK 4
#define ADCL3 3
#define ADCL3_BIT 3
#define ADCL3_MASK 8
#define ADCL4 4
#define ADCL4_BIT 4
#define ADCL4_MASK 16
#define ADCL5 5
#define ADCL5_BIT 5
#define ADCL5_MASK 32
#define ADCL6 6
#define ADCL6_BIT 6
#define ADCL6_MASK 64
#define ADCL7 7
#define ADCL7_BIT 7
#define ADCL7_MASK 128

sfrw ADCW = 0x24;

#endif
