#ifndef __ATtiny24_h
#define __ATtiny24_h

// Interrupt vectors

#define RESET_vect 0x0000
#define EXT_INT0_vect 0x0002
#define PCINT0_vect 0x0004
#define PCINT1_vect 0x0006
#define WATCHDOG_vect 0x0008
#define TIM1_CAPT_vect 0x000a
#define TIM1_COMPA_vect 0x000c
#define TIM1_COMPB_vect 0x000e
#define TIM1_OVF_vect 0x0010
#define TIM0_COMPA_vect 0x0012
#define TIM0_COMPB_vect 0x0014
#define TIM0_OVF_vect 0x0016
#define ANA_COMP_vect 0x0018
#define ADC_vect 0x001a
#define EE_RDY_vect 0x001c
#define USI_STR_vect 0x001e
#define USI_OVF_vect 0x0020

// I/O addresses


sfrb SREG = 0x5f;

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrb OCR0B = 0x5c;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb GIMSK = 0x5b;
#define PCIE0 4
#define PCIE0_BIT 4
#define PCIE0_MASK 16
#define PCIE1 5
#define PCIE1_BIT 5
#define PCIE1_MASK 32
#define INT0 6
#define INT0_BIT 6
#define INT0_MASK 64

sfrb GIFR = 0x5a;
#define PCIF0 4
#define PCIF0_BIT 4
#define PCIF0_MASK 16
#define PCIF1 5
#define PCIF1_BIT 5
#define PCIF1_MASK 32
#define INTF0 6
#define INTF0_BIT 6
#define INTF0_MASK 64

sfrb TIMSK0 = 0x59;
#define TOIE0 0
#define TOIE0_BIT 0
#define TOIE0_MASK 1
#define OCIE0A 1
#define OCIE0A_BIT 1
#define OCIE0A_MASK 2
#define OCIE0B 2
#define OCIE0B_BIT 2
#define OCIE0B_MASK 4

sfrb TIFR0 = 0x58;
#define TOV0 0
#define TOV0_BIT 0
#define TOV0_MASK 1
#define OCF0A 1
#define OCF0A_BIT 1
#define OCF0A_MASK 2
#define OCF0B 2
#define OCF0B_BIT 2
#define OCF0B_MASK 4

sfrb SPMCSR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define RFLB 3
#define RFLB_BIT 3
#define RFLB_MASK 8
#define CTPB 4
#define CTPB_BIT 4
#define CTPB_MASK 16

sfrb OCR0A = 0x56;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb MCUCR = 0x55;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define SM0 3
#define SM0_BIT 3
#define SM0_MASK 8
#define SM1 4
#define SM1_BIT 4
#define SM1_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32
#define PUD 6
#define PUD_BIT 6
#define PUD_MASK 64

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8

sfrb TCCR0B = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM02 3
#define WGM02_BIT 3
#define WGM02_MASK 8
#define FOC0B 6
#define FOC0B_BIT 6
#define FOC0B_MASK 64
#define FOC0A 7
#define FOC0A_BIT 7
#define FOC0A_MASK 128

sfrb TCNT0 = 0x52;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb OSCCAL = 0x51;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64
#define CAL7 7
#define CAL7_BIT 7
#define CAL7_MASK 128

sfrb TCCR0A = 0x50;
#define WGM00 0
#define WGM00_BIT 0
#define WGM00_MASK 1
#define WGM01 1
#define WGM01_BIT 1
#define WGM01_MASK 2
#define COM0B0 4
#define COM0B0_BIT 4
#define COM0B0_MASK 16
#define COM0B1 5
#define COM0B1_BIT 5
#define COM0B1_MASK 32
#define COM0A0 6
#define COM0A0_BIT 6
#define COM0A0_MASK 64
#define COM0A1 7
#define COM0A1_BIT 7
#define COM0A1_MASK 128

sfrb TCCR1A = 0x4f;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb TCCR1B = 0x4e;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define WGM12 3
#define WGM12_BIT 3
#define WGM12_MASK 8
#define WGM13 4
#define WGM13_BIT 4
#define WGM13_MASK 16
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCNT1H = 0x4d;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x4c;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x4c;

sfrb OCR1AH = 0x4b;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x4a;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x4a;

sfrb OCR1BH = 0x49;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1BL = 0x48;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1BW = 0x48;

sfrb DWDR = 0x47;

sfrb CLKPR = 0x46;
#define CLKPS0 0
#define CLKPS0_BIT 0
#define CLKPS0_MASK 1
#define CLKPS1 1
#define CLKPS1_BIT 1
#define CLKPS1_MASK 2
#define CLKPS2 2
#define CLKPS2_BIT 2
#define CLKPS2_MASK 4
#define CLKPS3 3
#define CLKPS3_BIT 3
#define CLKPS3_MASK 8
#define CLKPCE 7
#define CLKPCE_BIT 7
#define CLKPCE_MASK 128

sfrb ICR1H = 0x45;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x44;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x44;

sfrb GTCCR = 0x43;
#define PSR10 0
#define PSR10_BIT 0
#define PSR10_MASK 1
#define TSM 7
#define TSM_BIT 7
#define TSM_MASK 128

sfrb TCCR1C = 0x42;
#define FOC1B 6
#define FOC1B_BIT 6
#define FOC1B_MASK 64
#define FOC1A 7
#define FOC1A_BIT 7
#define FOC1A_MASK 128

sfrb WDTCSR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16
#define WDP3 5
#define WDP3_BIT 5
#define WDP3_MASK 32
#define WDIE 6
#define WDIE_BIT 6
#define WDIE_MASK 64
#define WDIF 7
#define WDIF_BIT 7
#define WDIF_MASK 128

sfrb PCMSK1 = 0x40;
#define PCINT8 0
#define PCINT8_BIT 0
#define PCINT8_MASK 1
#define PCINT9 1
#define PCINT9_BIT 1
#define PCINT9_MASK 2
#define PCINT10 2
#define PCINT10_BIT 2
#define PCINT10_MASK 4
#define PCINT11 3
#define PCINT11_BIT 3
#define PCINT11_MASK 8

sfrb EEARH = 0x3f;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1

sfrb EEARL = 0x3e;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64
#define EEAR7 7
#define EEAR7_BIT 7
#define EEAR7_MASK 128

sfrw EEARW = 0x3e;

sfrb EEDR = 0x3d;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3c;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEPE 1
#define EEPE_BIT 1
#define EEPE_MASK 2
#define EEMPE 2
#define EEMPE_BIT 2
#define EEMPE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8
#define EEPM0 4
#define EEPM0_BIT 4
#define EEPM0_MASK 16
#define EEPM1 5
#define EEPM1_BIT 5
#define EEPM1_MASK 32

sfrb PORTA = 0x3b;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8
#define PORTA4 4
#define PORTA4_BIT 4
#define PORTA4_MASK 16
#define PORTA5 5
#define PORTA5_BIT 5
#define PORTA5_MASK 32
#define PORTA6 6
#define PORTA6_BIT 6
#define PORTA6_MASK 64
#define PORTA7 7
#define PORTA7_BIT 7
#define PORTA7_MASK 128

sfrb DDRA = 0x3a;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define DDA2 2
#define DDA2_BIT 2
#define DDA2_MASK 4
#define DDA3 3
#define DDA3_BIT 3
#define DDA3_MASK 8
#define DDA4 4
#define DDA4_BIT 4
#define DDA4_MASK 16
#define DDA5 5
#define DDA5_BIT 5
#define DDA5_MASK 32
#define DDA6 6
#define DDA6_BIT 6
#define DDA6_MASK 64
#define DDA7 7
#define DDA7_BIT 7
#define DDA7_MASK 128

sfrb PINA = 0x39;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8
#define PINA4 4
#define PINA4_BIT 4
#define PINA4_MASK 16
#define PINA5 5
#define PINA5_BIT 5
#define PINA5_MASK 32
#define PINA6 6
#define PINA6_BIT 6
#define PINA6_MASK 64
#define PINA7 7
#define PINA7_BIT 7
#define PINA7_MASK 128

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8

sfrb DDRB = 0x37;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8

sfrb GPIOR2 = 0x35;
#define GPIOR20 0
#define GPIOR20_BIT 0
#define GPIOR20_MASK 1
#define GPIOR21 1
#define GPIOR21_BIT 1
#define GPIOR21_MASK 2
#define GPIOR22 2
#define GPIOR22_BIT 2
#define GPIOR22_MASK 4
#define GPIOR23 3
#define GPIOR23_BIT 3
#define GPIOR23_MASK 8
#define GPIOR24 4
#define GPIOR24_BIT 4
#define GPIOR24_MASK 16
#define GPIOR25 5
#define GPIOR25_BIT 5
#define GPIOR25_MASK 32
#define GPIOR26 6
#define GPIOR26_BIT 6
#define GPIOR26_MASK 64
#define GPIOR27 7
#define GPIOR27_BIT 7
#define GPIOR27_MASK 128

sfrb GPIOR1 = 0x34;
#define GPIOR10 0
#define GPIOR10_BIT 0
#define GPIOR10_MASK 1
#define GPIOR11 1
#define GPIOR11_BIT 1
#define GPIOR11_MASK 2
#define GPIOR12 2
#define GPIOR12_BIT 2
#define GPIOR12_MASK 4
#define GPIOR13 3
#define GPIOR13_BIT 3
#define GPIOR13_MASK 8
#define GPIOR14 4
#define GPIOR14_BIT 4
#define GPIOR14_MASK 16
#define GPIOR15 5
#define GPIOR15_BIT 5
#define GPIOR15_MASK 32
#define GPIOR16 6
#define GPIOR16_BIT 6
#define GPIOR16_MASK 64
#define GPIOR17 7
#define GPIOR17_BIT 7
#define GPIOR17_MASK 128

sfrb GPIOR0 = 0x33;
#define GPIOR00 0
#define GPIOR00_BIT 0
#define GPIOR00_MASK 1
#define GPIOR01 1
#define GPIOR01_BIT 1
#define GPIOR01_MASK 2
#define GPIOR02 2
#define GPIOR02_BIT 2
#define GPIOR02_MASK 4
#define GPIOR03 3
#define GPIOR03_BIT 3
#define GPIOR03_MASK 8
#define GPIOR04 4
#define GPIOR04_BIT 4
#define GPIOR04_MASK 16
#define GPIOR05 5
#define GPIOR05_BIT 5
#define GPIOR05_MASK 32
#define GPIOR06 6
#define GPIOR06_BIT 6
#define GPIOR06_MASK 64
#define GPIOR07 7
#define GPIOR07_BIT 7
#define GPIOR07_MASK 128

sfrb PCMSK0 = 0x32;
#define PCINT0 0
#define PCINT0_BIT 0
#define PCINT0_MASK 1
#define PCINT1 1
#define PCINT1_BIT 1
#define PCINT1_MASK 2
#define PCINT2 2
#define PCINT2_BIT 2
#define PCINT2_MASK 4
#define PCINT3 3
#define PCINT3_BIT 3
#define PCINT3_MASK 8
#define PCINT4 4
#define PCINT4_BIT 4
#define PCINT4_MASK 16
#define PCINT5 5
#define PCINT5_BIT 5
#define PCINT5_MASK 32
#define PCINT6 6
#define PCINT6_BIT 6
#define PCINT6_MASK 64
#define PCINT7 7
#define PCINT7_BIT 7
#define PCINT7_MASK 128

sfrb USIBR = 0x30;
#define USIBR0 0
#define USIBR0_BIT 0
#define USIBR0_MASK 1
#define USIBR1 1
#define USIBR1_BIT 1
#define USIBR1_MASK 2
#define USIBR2 2
#define USIBR2_BIT 2
#define USIBR2_MASK 4
#define USIBR3 3
#define USIBR3_BIT 3
#define USIBR3_MASK 8
#define USIBR4 4
#define USIBR4_BIT 4
#define USIBR4_MASK 16
#define USIBR5 5
#define USIBR5_BIT 5
#define USIBR5_MASK 32
#define USIBR6 6
#define USIBR6_BIT 6
#define USIBR6_MASK 64
#define USIBR7 7
#define USIBR7_BIT 7
#define USIBR7_MASK 128

sfrb USIDR = 0x2f;
#define USIDR0 0
#define USIDR0_BIT 0
#define USIDR0_MASK 1
#define USIDR1 1
#define USIDR1_BIT 1
#define USIDR1_MASK 2
#define USIDR2 2
#define USIDR2_BIT 2
#define USIDR2_MASK 4
#define USIDR3 3
#define USIDR3_BIT 3
#define USIDR3_MASK 8
#define USIDR4 4
#define USIDR4_BIT 4
#define USIDR4_MASK 16
#define USIDR5 5
#define USIDR5_BIT 5
#define USIDR5_MASK 32
#define USIDR6 6
#define USIDR6_BIT 6
#define USIDR6_MASK 64
#define USIDR7 7
#define USIDR7_BIT 7
#define USIDR7_MASK 128

sfrb USISR = 0x2e;
#define USICNT0 0
#define USICNT0_BIT 0
#define USICNT0_MASK 1
#define USICNT1 1
#define USICNT1_BIT 1
#define USICNT1_MASK 2
#define USICNT2 2
#define USICNT2_BIT 2
#define USICNT2_MASK 4
#define USICNT3 3
#define USICNT3_BIT 3
#define USICNT3_MASK 8
#define USIDC 4
#define USIDC_BIT 4
#define USIDC_MASK 16
#define USIPF 5
#define USIPF_BIT 5
#define USIPF_MASK 32
#define USIOIF 6
#define USIOIF_BIT 6
#define USIOIF_MASK 64
#define USISIF 7
#define USISIF_BIT 7
#define USISIF_MASK 128

sfrb USICR = 0x2d;
#define USITC 0
#define USITC_BIT 0
#define USITC_MASK 1
#define USICLK 1
#define USICLK_BIT 1
#define USICLK_MASK 2
#define USICS0 2
#define USICS0_BIT 2
#define USICS0_MASK 4
#define USICS1 3
#define USICS1_BIT 3
#define USICS1_MASK 8
#define USIWM0 4
#define USIWM0_BIT 4
#define USIWM0_MASK 16
#define USIWM1 5
#define USIWM1_BIT 5
#define USIWM1_MASK 32
#define USIOIE 6
#define USIOIE_BIT 6
#define USIOIE_MASK 64
#define USISIE 7
#define USISIE_BIT 7
#define USISIE_MASK 128

sfrb TIMSK1 = 0x2c;
#define TOIE1 0
#define TOIE1_BIT 0
#define TOIE1_MASK 1
#define OCIE1A 1
#define OCIE1A_BIT 1
#define OCIE1A_MASK 2
#define OCIE1B 2
#define OCIE1B_BIT 2
#define OCIE1B_MASK 4
#define ICIE1 5
#define ICIE1_BIT 5
#define ICIE1_MASK 32

sfrb TIFR1 = 0x2b;
#define TOV1 0
#define TOV1_BIT 0
#define TOV1_MASK 1
#define OCF1A 1
#define OCF1A_BIT 1
#define OCF1A_MASK 2
#define OCF1B 2
#define OCF1B_BIT 2
#define OCF1B_MASK 4
#define ICF1 5
#define ICF1_BIT 5
#define ICF1_MASK 32

sfrb ACSR = 0x28;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIC 2
#define ACIC_BIT 2
#define ACIC_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb ADMUX = 0x27;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define MUX2 2
#define MUX2_BIT 2
#define MUX2_MASK 4
#define MUX3 3
#define MUX3_BIT 3
#define MUX3_MASK 8
#define MUX4 4
#define MUX4_BIT 4
#define MUX4_MASK 16
#define MUX5 5
#define MUX5_BIT 5
#define MUX5_MASK 32
#define REFS0 6
#define REFS0_BIT 6
#define REFS0_MASK 64
#define REFS1 7
#define REFS1_BIT 7
#define REFS1_MASK 128

sfrb ADCSRA = 0x26;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADATE 5
#define ADATE_BIT 5
#define ADATE_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x25;
#define ADCH0 0
#define ADCH0_BIT 0
#define ADCH0_MASK 1
#define ADCH1 1
#define ADCH1_BIT 1
#define ADCH1_MASK 2
#define ADCH2 2
#define ADCH2_BIT 2
#define ADCH2_MASK 4
#define ADCH3 3
#define ADCH3_BIT 3
#define ADCH3_MASK 8
#define ADCH4 4
#define ADCH4_BIT 4
#define ADCH4_MASK 16
#define ADCH5 5
#define ADCH5_BIT 5
#define ADCH5_MASK 32
#define ADCH6 6
#define ADCH6_BIT 6
#define ADCH6_MASK 64
#define ADCH7 7
#define ADCH7_BIT 7
#define ADCH7_MASK 128

sfrb ADCL = 0x24;
#define ADCL0 0
#define ADCL0_BIT 0
#define ADCL0_MASK 1
#define ADCL1 1
#define ADCL1_BIT 1
#define ADCL1_MASK 2
#define ADCL2 2
#define ADCL2_BIT 2
#define ADCL2_MASK 4
#define ADCL3 3
#define ADCL3_BIT 3
#define ADCL3_MASK 8
#define ADCL4 4
#define ADCL4_BIT 4
#define ADCL4_MASK 16
#define ADCL5 5
#define ADCL5_BIT 5
#define ADCL5_MASK 32
#define ADCL6 6
#define ADCL6_BIT 6
#define ADCL6_MASK 64
#define ADCL7 7
#define ADCL7_BIT 7
#define ADCL7_MASK 128

sfrw ADCW = 0x24;

sfrb ADCSRB = 0x23;
#define ADTS0 0
#define ADTS0_BIT 0
#define ADTS0_MASK 1
#define ADTS1 1
#define ADTS1_BIT 1
#define ADTS1_MASK 2
#define ADTS2 2
#define ADTS2_BIT 2
#define ADTS2_MASK 4
#define ADLAR 4
#define ADLAR_BIT 4
#define ADLAR_MASK 16
#define ACME 6
#define ACME_BIT 6
#define ACME_MASK 64
#define BIN 7
#define BIN_BIT 7
#define BIN_MASK 128

sfrb DIDR0 = 0x21;
#define ADC0D 0
#define ADC0D_BIT 0
#define ADC0D_MASK 1
#define ADC1D 1
#define ADC1D_BIT 1
#define ADC1D_MASK 2
#define ADC2D 2
#define ADC2D_BIT 2
#define ADC2D_MASK 4
#define ADC3D 3
#define ADC3D_BIT 3
#define ADC3D_MASK 8
#define ADC4D 4
#define ADC4D_BIT 4
#define ADC4D_MASK 16
#define ADC5D 5
#define ADC5D_BIT 5
#define ADC5D_MASK 32
#define ADC6D 6
#define ADC6D_BIT 6
#define ADC6D_MASK 64
#define ADC7D 7
#define ADC7D_BIT 7
#define ADC7D_MASK 128

sfrb PRR = 0x20;
#define PRADC 0
#define PRADC_BIT 0
#define PRADC_MASK 1
#define PRUSI 1
#define PRUSI_BIT 1
#define PRUSI_MASK 2
#define PRTIM0 2
#define PRTIM0_BIT 2
#define PRTIM0_MASK 4
#define PRTIM1 3
#define PRTIM1_BIT 3
#define PRTIM1_MASK 8

#endif
