#ifndef __ATtiny2313_h
#define __ATtiny2313_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0002
#define INT1_vect 0x0004
#define TIMER1_CAPT_vect 0x0006
#define TIMER1_COMPA_vect 0x0008
#define TIMER1_OVF_vect 0x000a
#define TIMER0_OVF_vect 0x000c
#define USART_RX_vect 0x000e
#define USART_UDRE_vect 0x0010
#define USART_TX_vect 0x0012
#define ANA_COMP_vect 0x0014
#define PCINT_vect 0x0016
#define TIMER1_COMPB_vect 0x0018
#define TIMER0_COMPA_vect 0x001a
#define TIMER0_COMPB_vect 0x001c
#define USI_START_vect 0x001e
#define USI_OVERFLOW_vect 0x0020
#define EEPROM_Ready_vect 0x0022
#define WDT_OVERFLOW_vect 0x0024

// I/O addresses


sfrb SREG = 0x5f;

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrb OCR0B = 0x5c;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb GIMSK = 0x5b;
#define PCIE 5
#define PCIE_BIT 5
#define PCIE_MASK 32
#define INT0 6
#define INT0_BIT 6
#define INT0_MASK 64
#define INT1 7
#define INT1_BIT 7
#define INT1_MASK 128

sfrb EIFR = 0x5a;
#define PCIF 5
#define PCIF_BIT 5
#define PCIF_MASK 32
#define INTF0 6
#define INTF0_BIT 6
#define INTF0_MASK 64
#define INTF1 7
#define INTF1_BIT 7
#define INTF1_MASK 128

sfrb TIMSK = 0x59;
#define OCIE0A 0
#define OCIE0A_BIT 0
#define OCIE0A_MASK 1
#define TOIE0 1
#define TOIE0_BIT 1
#define TOIE0_MASK 2
#define OCIE0B 2
#define OCIE0B_BIT 2
#define OCIE0B_MASK 4
#define ICIE1 3
#define ICIE1_BIT 3
#define ICIE1_MASK 8
#define OCIE1B 5
#define OCIE1B_BIT 5
#define OCIE1B_MASK 32
#define OCIE1A 6
#define OCIE1A_BIT 6
#define OCIE1A_MASK 64
#define TOIE1 7
#define TOIE1_BIT 7
#define TOIE1_MASK 128

sfrb TIFR = 0x58;
#define OCF0A 0
#define OCF0A_BIT 0
#define OCF0A_MASK 1
#define TOV0 1
#define TOV0_BIT 1
#define TOV0_MASK 2
#define OCF0B 2
#define OCF0B_BIT 2
#define OCF0B_MASK 4
#define ICF1 3
#define ICF1_BIT 3
#define ICF1_MASK 8
#define OCF1B 5
#define OCF1B_BIT 5
#define OCF1B_MASK 32
#define OCF1A 6
#define OCF1A_BIT 6
#define OCF1A_MASK 64
#define TOV1 7
#define TOV1_BIT 7
#define TOV1_MASK 128

sfrb SPMCSR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define RFLB 3
#define RFLB_BIT 3
#define RFLB_MASK 8
#define CTPB 4
#define CTPB_BIT 4
#define CTPB_MASK 16

sfrb OCR0A = 0x56;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb MCUCR = 0x55;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ISC10 2
#define ISC10_BIT 2
#define ISC10_MASK 4
#define ISC11 3
#define ISC11_BIT 3
#define ISC11_MASK 8
#define SM0 4
#define SM0_BIT 4
#define SM0_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32
#define SM1 6
#define SM1_BIT 6
#define SM1_MASK 64
#define PUD 7
#define PUD_BIT 7
#define PUD_MASK 128

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8

sfrb TCCR0B = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM02 3
#define WGM02_BIT 3
#define WGM02_MASK 8
#define FOC0B 6
#define FOC0B_BIT 6
#define FOC0B_MASK 64
#define FOC0A 7
#define FOC0A_BIT 7
#define FOC0A_MASK 128

sfrb TCNT0 = 0x52;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb OSCCAL = 0x51;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64

sfrb TCCR0A = 0x50;
#define WGM00 0
#define WGM00_BIT 0
#define WGM00_MASK 1
#define WGM01 1
#define WGM01_BIT 1
#define WGM01_MASK 2
#define COM0B0 4
#define COM0B0_BIT 4
#define COM0B0_MASK 16
#define COM0B1 5
#define COM0B1_BIT 5
#define COM0B1_MASK 32
#define COM0A0 6
#define COM0A0_BIT 6
#define COM0A0_MASK 64
#define COM0A1 7
#define COM0A1_BIT 7
#define COM0A1_MASK 128

sfrb TCCR1A = 0x4f;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb TCCR1B = 0x4e;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define WGM12 3
#define WGM12_BIT 3
#define WGM12_MASK 8
#define WGM13 4
#define WGM13_BIT 4
#define WGM13_MASK 16
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCNT1H = 0x4d;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x4c;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x4c;

sfrb OCR1AH = 0x4b;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x4a;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x4a;

sfrb OCR1BH = 0x49;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1BL = 0x48;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1BW = 0x48;

sfrb CLKPR = 0x46;
#define CLKPS0 0
#define CLKPS0_BIT 0
#define CLKPS0_MASK 1
#define CLKPS1 1
#define CLKPS1_BIT 1
#define CLKPS1_MASK 2
#define CLKPS2 2
#define CLKPS2_BIT 2
#define CLKPS2_MASK 4
#define CLKPS3 3
#define CLKPS3_BIT 3
#define CLKPS3_MASK 8
#define CLKPCE 7
#define CLKPCE_BIT 7
#define CLKPCE_MASK 128

sfrb ICR1H = 0x45;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x44;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x44;

sfrb GTCCR = 0x43;
#define PSR10 0
#define PSR10_BIT 0
#define PSR10_MASK 1

sfrb TCCR1C = 0x42;
#define FOC1B 6
#define FOC1B_BIT 6
#define FOC1B_MASK 64
#define FOC1A 7
#define FOC1A_BIT 7
#define FOC1A_MASK 128

sfrb WDTCR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16
#define WDP3 5
#define WDP3_BIT 5
#define WDP3_MASK 32
#define WDIE 6
#define WDIE_BIT 6
#define WDIE_MASK 64
#define WDIF 7
#define WDIF_BIT 7
#define WDIF_MASK 128

sfrb PCMSK = 0x40;
#define PCINT0 0
#define PCINT0_BIT 0
#define PCINT0_MASK 1
#define PCINT1 1
#define PCINT1_BIT 1
#define PCINT1_MASK 2
#define PCINT2 2
#define PCINT2_BIT 2
#define PCINT2_MASK 4
#define PCINT3 3
#define PCINT3_BIT 3
#define PCINT3_MASK 8
#define PCINT4 4
#define PCINT4_BIT 4
#define PCINT4_MASK 16
#define PCINT5 5
#define PCINT5_BIT 5
#define PCINT5_MASK 32
#define PCINT6 6
#define PCINT6_BIT 6
#define PCINT6_MASK 64
#define PCINT7 7
#define PCINT7_BIT 7
#define PCINT7_MASK 128

sfrb EEAR = 0x3e;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64

sfrb EEDR = 0x3d;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3c;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEPE 1
#define EEPE_BIT 1
#define EEPE_MASK 2
#define EEMPE 2
#define EEMPE_BIT 2
#define EEMPE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8
#define EEPM0 4
#define EEPM0_BIT 4
#define EEPM0_MASK 16
#define EEPM1 5
#define EEPM1_BIT 5
#define EEPM1_MASK 32

sfrb PORTA = 0x3b;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4

sfrb DDRA = 0x3a;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define DDA2 2
#define DDA2_BIT 2
#define DDA2_MASK 4

sfrb PINA = 0x39;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x37;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb GPIOR2 = 0x35;
#define GPIOR20 0
#define GPIOR20_BIT 0
#define GPIOR20_MASK 1
#define GPIOR21 1
#define GPIOR21_BIT 1
#define GPIOR21_MASK 2
#define GPIOR22 2
#define GPIOR22_BIT 2
#define GPIOR22_MASK 4
#define GPIOR23 3
#define GPIOR23_BIT 3
#define GPIOR23_MASK 8
#define GPIOR24 4
#define GPIOR24_BIT 4
#define GPIOR24_MASK 16
#define GPIOR25 5
#define GPIOR25_BIT 5
#define GPIOR25_MASK 32
#define GPIOR26 6
#define GPIOR26_BIT 6
#define GPIOR26_MASK 64
#define GPIOR27 7
#define GPIOR27_BIT 7
#define GPIOR27_MASK 128

sfrb GPIOR1 = 0x34;
#define GPIOR10 0
#define GPIOR10_BIT 0
#define GPIOR10_MASK 1
#define GPIOR11 1
#define GPIOR11_BIT 1
#define GPIOR11_MASK 2
#define GPIOR12 2
#define GPIOR12_BIT 2
#define GPIOR12_MASK 4
#define GPIOR13 3
#define GPIOR13_BIT 3
#define GPIOR13_MASK 8
#define GPIOR14 4
#define GPIOR14_BIT 4
#define GPIOR14_MASK 16
#define GPIOR15 5
#define GPIOR15_BIT 5
#define GPIOR15_MASK 32
#define GPIOR16 6
#define GPIOR16_BIT 6
#define GPIOR16_MASK 64
#define GPIOR17 7
#define GPIOR17_BIT 7
#define GPIOR17_MASK 128

sfrb GPIOR0 = 0x33;
#define GPIOR00 0
#define GPIOR00_BIT 0
#define GPIOR00_MASK 1
#define GPIOR01 1
#define GPIOR01_BIT 1
#define GPIOR01_MASK 2
#define GPIOR02 2
#define GPIOR02_BIT 2
#define GPIOR02_MASK 4
#define GPIOR03 3
#define GPIOR03_BIT 3
#define GPIOR03_MASK 8
#define GPIOR04 4
#define GPIOR04_BIT 4
#define GPIOR04_MASK 16
#define GPIOR05 5
#define GPIOR05_BIT 5
#define GPIOR05_MASK 32
#define GPIOR06 6
#define GPIOR06_BIT 6
#define GPIOR06_MASK 64
#define GPIOR07 7
#define GPIOR07_BIT 7
#define GPIOR07_MASK 128

sfrb PORTD = 0x32;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64

sfrb DDRD = 0x31;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64

sfrb PIND = 0x30;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64

sfrb USIDR = 0x2f;
#define USIDR0 0
#define USIDR0_BIT 0
#define USIDR0_MASK 1
#define USIDR1 1
#define USIDR1_BIT 1
#define USIDR1_MASK 2
#define USIDR2 2
#define USIDR2_BIT 2
#define USIDR2_MASK 4
#define USIDR3 3
#define USIDR3_BIT 3
#define USIDR3_MASK 8
#define USIDR4 4
#define USIDR4_BIT 4
#define USIDR4_MASK 16
#define USIDR5 5
#define USIDR5_BIT 5
#define USIDR5_MASK 32
#define USIDR6 6
#define USIDR6_BIT 6
#define USIDR6_MASK 64
#define USIDR7 7
#define USIDR7_BIT 7
#define USIDR7_MASK 128

sfrb USISR = 0x2e;
#define USICNT0 0
#define USICNT0_BIT 0
#define USICNT0_MASK 1
#define USICNT1 1
#define USICNT1_BIT 1
#define USICNT1_MASK 2
#define USICNT2 2
#define USICNT2_BIT 2
#define USICNT2_MASK 4
#define USICNT3 3
#define USICNT3_BIT 3
#define USICNT3_MASK 8
#define USIDC 4
#define USIDC_BIT 4
#define USIDC_MASK 16
#define USIPF 5
#define USIPF_BIT 5
#define USIPF_MASK 32
#define USIOIF 6
#define USIOIF_BIT 6
#define USIOIF_MASK 64
#define USISIF 7
#define USISIF_BIT 7
#define USISIF_MASK 128

sfrb USICR = 0x2d;
#define USITC 0
#define USITC_BIT 0
#define USITC_MASK 1
#define USICLK 1
#define USICLK_BIT 1
#define USICLK_MASK 2
#define USICS0 2
#define USICS0_BIT 2
#define USICS0_MASK 4
#define USICS1 3
#define USICS1_BIT 3
#define USICS1_MASK 8
#define USIWM0 4
#define USIWM0_BIT 4
#define USIWM0_MASK 16
#define USIWM1 5
#define USIWM1_BIT 5
#define USIWM1_MASK 32
#define USIOIE 6
#define USIOIE_BIT 6
#define USIOIE_MASK 64
#define USISIE 7
#define USISIE_BIT 7
#define USISIE_MASK 128

sfrb UDR = 0x2c;
#define UDR0 0
#define UDR0_BIT 0
#define UDR0_MASK 1
#define UDR1 1
#define UDR1_BIT 1
#define UDR1_MASK 2
#define UDR2 2
#define UDR2_BIT 2
#define UDR2_MASK 4
#define UDR3 3
#define UDR3_BIT 3
#define UDR3_MASK 8
#define UDR4 4
#define UDR4_BIT 4
#define UDR4_MASK 16
#define UDR5 5
#define UDR5_BIT 5
#define UDR5_MASK 32
#define UDR6 6
#define UDR6_BIT 6
#define UDR6_MASK 64
#define UDR7 7
#define UDR7_BIT 7
#define UDR7_MASK 128

sfrb UCSRA = 0x2b;
#define MPCM 0
#define MPCM_BIT 0
#define MPCM_MASK 1
#define U2X 1
#define U2X_BIT 1
#define U2X_MASK 2
#define UPE 2
#define UPE_BIT 2
#define UPE_MASK 4
#define DOR 3
#define DOR_BIT 3
#define DOR_MASK 8
#define FE 4
#define FE_BIT 4
#define FE_MASK 16
#define UDRE 5
#define UDRE_BIT 5
#define UDRE_MASK 32
#define TXC 6
#define TXC_BIT 6
#define TXC_MASK 64
#define RXC 7
#define RXC_BIT 7
#define RXC_MASK 128

sfrb UCSRB = 0x2a;
#define TXB8 0
#define TXB8_BIT 0
#define TXB8_MASK 1
#define RXB8 1
#define RXB8_BIT 1
#define RXB8_MASK 2
#define UCSZ2 2
#define UCSZ2_BIT 2
#define UCSZ2_MASK 4
#define TXEN 3
#define TXEN_BIT 3
#define TXEN_MASK 8
#define RXEN 4
#define RXEN_BIT 4
#define RXEN_MASK 16
#define UDRIE 5
#define UDRIE_BIT 5
#define UDRIE_MASK 32
#define TXCIE 6
#define TXCIE_BIT 6
#define TXCIE_MASK 64
#define RXCIE 7
#define RXCIE_BIT 7
#define RXCIE_MASK 128

sfrb UBRRL = 0x29;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrb ACSR = 0x28;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIC 2
#define ACIC_BIT 2
#define ACIC_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb UCSRC = 0x23;
#define UCPOL 0
#define UCPOL_BIT 0
#define UCPOL_MASK 1
#define UCSZ0 1
#define UCSZ0_BIT 1
#define UCSZ0_MASK 2
#define UCSZ1 2
#define UCSZ1_BIT 2
#define UCSZ1_MASK 4
#define USBS 3
#define USBS_BIT 3
#define USBS_MASK 8
#define UPM0 4
#define UPM0_BIT 4
#define UPM0_MASK 16
#define UPM1 5
#define UPM1_BIT 5
#define UPM1_MASK 32
#define UMSEL 6
#define UMSEL_BIT 6
#define UMSEL_MASK 64

sfrb UBRRH = 0x22;
#define UBRR8 0
#define UBRR8_BIT 0
#define UBRR8_MASK 1
#define UBRR9 1
#define UBRR9_BIT 1
#define UBRR9_MASK 2
#define UBRR10 2
#define UBRR10_BIT 2
#define UBRR10_MASK 4
#define UBRR11 3
#define UBRR11_BIT 3
#define UBRR11_MASK 8

sfrb DIDR = 0x21;
#define AIN0D 0
#define AIN0D_BIT 0
#define AIN0D_MASK 1
#define AIN1D 1
#define AIN1D_BIT 1
#define AIN1D_MASK 2

#endif
