#ifndef __ATtiny13_h
#define __ATtiny13_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0002
#define PCINT0_vect 0x0004
#define TIM0_OVF_vect 0x0006
#define EE_RDY_vect 0x0008
#define ANA_COMP_vect 0x000a
#define TIM0_COMPA_vect 0x000c
#define TIM0_COMPB_vect 0x000e
#define WDT_vect 0x0010
#define ADC_vect 0x0012

// I/O addresses


sfrb SREG = 0x5f;

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrb GIMSK = 0x5b;
#define PCIE 5
#define PCIE_BIT 5
#define PCIE_MASK 32
#define INT0 6
#define INT0_BIT 6
#define INT0_MASK 64

sfrb GIFR = 0x5a;
#define PCIF 5
#define PCIF_BIT 5
#define PCIF_MASK 32
#define INTF0 6
#define INTF0_BIT 6
#define INTF0_MASK 64

sfrb TIMSK0 = 0x59;
#define TOIE0 1
#define TOIE0_BIT 1
#define TOIE0_MASK 2
#define OCIE0A 2
#define OCIE0A_BIT 2
#define OCIE0A_MASK 4
#define OCIE0B 3
#define OCIE0B_BIT 3
#define OCIE0B_MASK 8

sfrb TIFR0 = 0x58;
#define TOV0 1
#define TOV0_BIT 1
#define TOV0_MASK 2
#define OCF0A 2
#define OCF0A_BIT 2
#define OCF0A_MASK 4
#define OCF0B 3
#define OCF0B_BIT 3
#define OCF0B_MASK 8

sfrb SPMCSR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define RFLB 3
#define RFLB_BIT 3
#define RFLB_MASK 8
#define CTPB 4
#define CTPB_BIT 4
#define CTPB_MASK 16

sfrb OCR0A = 0x56;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb MCUCR = 0x55;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define SM0 3
#define SM0_BIT 3
#define SM0_MASK 8
#define SM1 4
#define SM1_BIT 4
#define SM1_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32
#define PUD 6
#define PUD_BIT 6
#define PUD_MASK 64

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8

sfrb TCCR0B = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM02 3
#define WGM02_BIT 3
#define WGM02_MASK 8
#define FOC0B 6
#define FOC0B_BIT 6
#define FOC0B_MASK 64
#define FOC0A 7
#define FOC0A_BIT 7
#define FOC0A_MASK 128

sfrb TCNT0 = 0x52;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb OSCCAL = 0x51;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64

sfrb TCCR0A = 0x4f;
#define WGM00 0
#define WGM00_BIT 0
#define WGM00_MASK 1
#define WGM01 1
#define WGM01_BIT 1
#define WGM01_MASK 2
#define COM0B0 4
#define COM0B0_BIT 4
#define COM0B0_MASK 16
#define COM0B1 5
#define COM0B1_BIT 5
#define COM0B1_MASK 32
#define COM0A0 6
#define COM0A0_BIT 6
#define COM0A0_MASK 64
#define COM0A1 7
#define COM0A1_BIT 7
#define COM0A1_MASK 128

sfrb DWDR = 0x4e;
#define DWDR0 0
#define DWDR0_BIT 0
#define DWDR0_MASK 1
#define DWDR1 1
#define DWDR1_BIT 1
#define DWDR1_MASK 2
#define DWDR2 2
#define DWDR2_BIT 2
#define DWDR2_MASK 4
#define DWDR3 3
#define DWDR3_BIT 3
#define DWDR3_MASK 8
#define DWDR4 4
#define DWDR4_BIT 4
#define DWDR4_MASK 16
#define DWDR5 5
#define DWDR5_BIT 5
#define DWDR5_MASK 32
#define DWDR6 6
#define DWDR6_BIT 6
#define DWDR6_MASK 64
#define DWDR7 7
#define DWDR7_BIT 7
#define DWDR7_MASK 128

sfrb OCR0B = 0x49;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb GTCCR = 0x48;
#define PSR10 0
#define PSR10_BIT 0
#define PSR10_MASK 1
#define TSM 7
#define TSM_BIT 7
#define TSM_MASK 128

sfrb CLKPR = 0x46;
#define CLKPS0 0
#define CLKPS0_BIT 0
#define CLKPS0_MASK 1
#define CLKPS1 1
#define CLKPS1_BIT 1
#define CLKPS1_MASK 2
#define CLKPS2 2
#define CLKPS2_BIT 2
#define CLKPS2_MASK 4
#define CLKPS3 3
#define CLKPS3_BIT 3
#define CLKPS3_MASK 8
#define CLKPCE 7
#define CLKPCE_BIT 7
#define CLKPCE_MASK 128

sfrb WDTCR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16
#define WDP3 5
#define WDP3_BIT 5
#define WDP3_MASK 32
#define WDTIE 6
#define WDTIE_BIT 6
#define WDTIE_MASK 64
#define WDTIF 7
#define WDTIF_BIT 7
#define WDTIF_MASK 128

sfrb EEAR = 0x3e;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32

sfrb EEDR = 0x3d;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3c;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEWE 1
#define EEWE_BIT 1
#define EEWE_MASK 2
#define EEMWE 2
#define EEMWE_BIT 2
#define EEMWE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8
#define EEPM0 4
#define EEPM0_BIT 4
#define EEPM0_MASK 16
#define EEPM1 5
#define EEPM1_BIT 5
#define EEPM1_MASK 32

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32

sfrb DDRB = 0x37;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32

sfrb PCMSK = 0x35;
#define PCINT0 0
#define PCINT0_BIT 0
#define PCINT0_MASK 1
#define PCINT1 1
#define PCINT1_BIT 1
#define PCINT1_MASK 2
#define PCINT2 2
#define PCINT2_BIT 2
#define PCINT2_MASK 4
#define PCINT3 3
#define PCINT3_BIT 3
#define PCINT3_MASK 8
#define PCINT4 4
#define PCINT4_BIT 4
#define PCINT4_MASK 16
#define PCINT5 5
#define PCINT5_BIT 5
#define PCINT5_MASK 32

sfrb DIDR0 = 0x34;
#define AIN0D 0
#define AIN0D_BIT 0
#define AIN0D_MASK 1
#define AIN1D 1
#define AIN1D_BIT 1
#define AIN1D_MASK 2
#define ADC1D 2
#define ADC1D_BIT 2
#define ADC1D_MASK 4
#define ADC3D 3
#define ADC3D_BIT 3
#define ADC3D_MASK 8
#define ADC2D 4
#define ADC2D_BIT 4
#define ADC2D_MASK 16
#define ADC0D 5
#define ADC0D_BIT 5
#define ADC0D_MASK 32

sfrb ACSR = 0x28;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb ADMUX = 0x27;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define ADLAR 5
#define ADLAR_BIT 5
#define ADLAR_MASK 32
#define REFS0 6
#define REFS0_BIT 6
#define REFS0_MASK 64

sfrb ADCSRA = 0x26;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADATE 5
#define ADATE_BIT 5
#define ADATE_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x25;
#define ADCH0 0
#define ADCH0_BIT 0
#define ADCH0_MASK 1
#define ADCH1 1
#define ADCH1_BIT 1
#define ADCH1_MASK 2
#define ADCH2 2
#define ADCH2_BIT 2
#define ADCH2_MASK 4
#define ADCH3 3
#define ADCH3_BIT 3
#define ADCH3_MASK 8
#define ADCH4 4
#define ADCH4_BIT 4
#define ADCH4_MASK 16
#define ADCH5 5
#define ADCH5_BIT 5
#define ADCH5_MASK 32
#define ADCH6 6
#define ADCH6_BIT 6
#define ADCH6_MASK 64
#define ADCH7 7
#define ADCH7_BIT 7
#define ADCH7_MASK 128

sfrb ADCL = 0x24;
#define ADCL0 0
#define ADCL0_BIT 0
#define ADCL0_MASK 1
#define ADCL1 1
#define ADCL1_BIT 1
#define ADCL1_MASK 2
#define ADCL2 2
#define ADCL2_BIT 2
#define ADCL2_MASK 4
#define ADCL3 3
#define ADCL3_BIT 3
#define ADCL3_MASK 8
#define ADCL4 4
#define ADCL4_BIT 4
#define ADCL4_MASK 16
#define ADCL5 5
#define ADCL5_BIT 5
#define ADCL5_MASK 32
#define ADCL6 6
#define ADCL6_BIT 6
#define ADCL6_MASK 64
#define ADCL7 7
#define ADCL7_BIT 7
#define ADCL7_MASK 128

sfrw ADCW = 0x24;

sfrb ADCSRB = 0x23;
#define ADTS0 0
#define ADTS0_BIT 0
#define ADTS0_MASK 1
#define ADTS1 1
#define ADTS1_BIT 1
#define ADTS1_MASK 2
#define ADTS2 2
#define ADTS2_BIT 2
#define ADTS2_MASK 4
#define ACME 6
#define ACME_BIT 6
#define ACME_MASK 64

#endif
