#ifndef __ATmega88_h
#define __ATmega88_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0002
#define INT1_vect 0x0004
#define PCINT0_vect 0x0006
#define PCINT1_vect 0x0008
#define PCINT2_vect 0x000a
#define WDT_vect 0x000c
#define TIMER2_COMPA_vect 0x000e
#define TIMER2_COMPB_vect 0x0010
#define TIMER2_OVF_vect 0x0012
#define TIMER1_CAPT_vect 0x0014
#define TIMER1_COMPA_vect 0x0016
#define TIMER1_COMPB_vect 0x0018
#define TIMER1_OVF_vect 0x001a
#define TIMER0_COMPA_vect 0x001c
#define TIMER0_COMPB_vect 0x001e
#define TIMER0_OVF_vect 0x0020
#define SPI_STC_vect 0x0022
#define USART_RX_vect 0x0024
#define USART_UDRE_vect 0x0026
#define USART_TX_vect 0x0028
#define ADC_vect 0x002a
#define EE_READY_vect 0x002c
#define ANALOG_COMP_vect 0x002e
#define TWI_vect 0x0030
#define SPM_Ready_vect 0x0032

// I/O addresses


sfrb UDR0 = 0xc6;
#define UDR0_0 0
#define UDR0_0_BIT 0
#define UDR0_0_MASK 1
#define UDR0_1 1
#define UDR0_1_BIT 1
#define UDR0_1_MASK 2
#define UDR0_2 2
#define UDR0_2_BIT 2
#define UDR0_2_MASK 4
#define UDR0_3 3
#define UDR0_3_BIT 3
#define UDR0_3_MASK 8
#define UDR0_4 4
#define UDR0_4_BIT 4
#define UDR0_4_MASK 16
#define UDR0_5 5
#define UDR0_5_BIT 5
#define UDR0_5_MASK 32
#define UDR0_6 6
#define UDR0_6_BIT 6
#define UDR0_6_MASK 64
#define UDR0_7 7
#define UDR0_7_BIT 7
#define UDR0_7_MASK 128

sfrb UBRR0H = 0xc5;
#define UBRR8 0
#define UBRR8_BIT 0
#define UBRR8_MASK 1
#define UBRR9 1
#define UBRR9_BIT 1
#define UBRR9_MASK 2
#define UBRR10 2
#define UBRR10_BIT 2
#define UBRR10_MASK 4
#define UBRR11 3
#define UBRR11_BIT 3
#define UBRR11_MASK 8

sfrb UBRR0L = 0xc4;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrw UBRR0W = 0xc4;

sfrb UCSR0C = 0xc2;
#define UCPOL0 0
#define UCPOL0_BIT 0
#define UCPOL0_MASK 1
#define UCSZ00 1
#define UCSZ00_BIT 1
#define UCSZ00_MASK 2
#define UCSZ01 2
#define UCSZ01_BIT 2
#define UCSZ01_MASK 4
#define USBS0 3
#define USBS0_BIT 3
#define USBS0_MASK 8
#define UPM00 4
#define UPM00_BIT 4
#define UPM00_MASK 16
#define UPM01 5
#define UPM01_BIT 5
#define UPM01_MASK 32
#define UMSEL00 6
#define UMSEL00_BIT 6
#define UMSEL00_MASK 64
#define UMSEL01 7
#define UMSEL01_BIT 7
#define UMSEL01_MASK 128

sfrb UCSR0B = 0xc1;
#define TXB80 0
#define TXB80_BIT 0
#define TXB80_MASK 1
#define RXB80 1
#define RXB80_BIT 1
#define RXB80_MASK 2
#define UCSZ02 2
#define UCSZ02_BIT 2
#define UCSZ02_MASK 4
#define TXEN0 3
#define TXEN0_BIT 3
#define TXEN0_MASK 8
#define RXEN0 4
#define RXEN0_BIT 4
#define RXEN0_MASK 16
#define UDRIE0 5
#define UDRIE0_BIT 5
#define UDRIE0_MASK 32
#define TXCIE0 6
#define TXCIE0_BIT 6
#define TXCIE0_MASK 64
#define RXCIE0 7
#define RXCIE0_BIT 7
#define RXCIE0_MASK 128

sfrb UCSR0A = 0xc0;
#define MPCM0 0
#define MPCM0_BIT 0
#define MPCM0_MASK 1
#define U2X0 1
#define U2X0_BIT 1
#define U2X0_MASK 2
#define UPE0 2
#define UPE0_BIT 2
#define UPE0_MASK 4
#define DOR0 3
#define DOR0_BIT 3
#define DOR0_MASK 8
#define FE0 4
#define FE0_BIT 4
#define FE0_MASK 16
#define UDRE0 5
#define UDRE0_BIT 5
#define UDRE0_MASK 32
#define TXC0 6
#define TXC0_BIT 6
#define TXC0_MASK 64
#define RXC0 7
#define RXC0_BIT 7
#define RXC0_MASK 128

sfrb TWAMR = 0xbd;
#define TWAM0 1
#define TWAM0_BIT 1
#define TWAM0_MASK 2
#define TWAM1 2
#define TWAM1_BIT 2
#define TWAM1_MASK 4
#define TWAM2 3
#define TWAM2_BIT 3
#define TWAM2_MASK 8
#define TWAM3 4
#define TWAM3_BIT 4
#define TWAM3_MASK 16
#define TWAM4 5
#define TWAM4_BIT 5
#define TWAM4_MASK 32
#define TWAM5 6
#define TWAM5_BIT 6
#define TWAM5_MASK 64
#define TWAM6 7
#define TWAM6_BIT 7
#define TWAM6_MASK 128

sfrb TWCR = 0xbc;
#define TWIE 0
#define TWIE_BIT 0
#define TWIE_MASK 1
#define TWEN 2
#define TWEN_BIT 2
#define TWEN_MASK 4
#define TWWC 3
#define TWWC_BIT 3
#define TWWC_MASK 8
#define TWSTO 4
#define TWSTO_BIT 4
#define TWSTO_MASK 16
#define TWSTA 5
#define TWSTA_BIT 5
#define TWSTA_MASK 32
#define TWEA 6
#define TWEA_BIT 6
#define TWEA_MASK 64
#define TWINT 7
#define TWINT_BIT 7
#define TWINT_MASK 128

sfrb TWDR = 0xbb;
#define TWD0 0
#define TWD0_BIT 0
#define TWD0_MASK 1
#define TWD1 1
#define TWD1_BIT 1
#define TWD1_MASK 2
#define TWD2 2
#define TWD2_BIT 2
#define TWD2_MASK 4
#define TWD3 3
#define TWD3_BIT 3
#define TWD3_MASK 8
#define TWD4 4
#define TWD4_BIT 4
#define TWD4_MASK 16
#define TWD5 5
#define TWD5_BIT 5
#define TWD5_MASK 32
#define TWD6 6
#define TWD6_BIT 6
#define TWD6_MASK 64
#define TWD7 7
#define TWD7_BIT 7
#define TWD7_MASK 128

sfrb TWAR = 0xba;
#define TWGCE 0
#define TWGCE_BIT 0
#define TWGCE_MASK 1
#define TWA0 1
#define TWA0_BIT 1
#define TWA0_MASK 2
#define TWA1 2
#define TWA1_BIT 2
#define TWA1_MASK 4
#define TWA2 3
#define TWA2_BIT 3
#define TWA2_MASK 8
#define TWA3 4
#define TWA3_BIT 4
#define TWA3_MASK 16
#define TWA4 5
#define TWA4_BIT 5
#define TWA4_MASK 32
#define TWA5 6
#define TWA5_BIT 6
#define TWA5_MASK 64
#define TWA6 7
#define TWA6_BIT 7
#define TWA6_MASK 128

sfrb TWSR = 0xb9;
#define TWPS0 0
#define TWPS0_BIT 0
#define TWPS0_MASK 1
#define TWPS1 1
#define TWPS1_BIT 1
#define TWPS1_MASK 2
#define TWS3 3
#define TWS3_BIT 3
#define TWS3_MASK 8
#define TWS4 4
#define TWS4_BIT 4
#define TWS4_MASK 16
#define TWS5 5
#define TWS5_BIT 5
#define TWS5_MASK 32
#define TWS6 6
#define TWS6_BIT 6
#define TWS6_MASK 64
#define TWS7 7
#define TWS7_BIT 7
#define TWS7_MASK 128

sfrb TWBR = 0xb8;
#define TWBR0 0
#define TWBR0_BIT 0
#define TWBR0_MASK 1
#define TWBR1 1
#define TWBR1_BIT 1
#define TWBR1_MASK 2
#define TWBR2 2
#define TWBR2_BIT 2
#define TWBR2_MASK 4
#define TWBR3 3
#define TWBR3_BIT 3
#define TWBR3_MASK 8
#define TWBR4 4
#define TWBR4_BIT 4
#define TWBR4_MASK 16
#define TWBR5 5
#define TWBR5_BIT 5
#define TWBR5_MASK 32
#define TWBR6 6
#define TWBR6_BIT 6
#define TWBR6_MASK 64
#define TWBR7 7
#define TWBR7_BIT 7
#define TWBR7_MASK 128

sfrb ASSR = 0xb6;
#define TCR2BUB 0
#define TCR2BUB_BIT 0
#define TCR2BUB_MASK 1
#define TCR2AUB 1
#define TCR2AUB_BIT 1
#define TCR2AUB_MASK 2
#define OCR2BUB 2
#define OCR2BUB_BIT 2
#define OCR2BUB_MASK 4
#define OCR2AUB 3
#define OCR2AUB_BIT 3
#define OCR2AUB_MASK 8
#define TCN2UB 4
#define TCN2UB_BIT 4
#define TCN2UB_MASK 16
#define AS2 5
#define AS2_BIT 5
#define AS2_MASK 32
#define EXCLK 6
#define EXCLK_BIT 6
#define EXCLK_MASK 64

sfrb OCR2B = 0xb4;
#define OCR2_0 0
#define OCR2_0_BIT 0
#define OCR2_0_MASK 1
#define OCR2_1 1
#define OCR2_1_BIT 1
#define OCR2_1_MASK 2
#define OCR2_2 2
#define OCR2_2_BIT 2
#define OCR2_2_MASK 4
#define OCR2_3 3
#define OCR2_3_BIT 3
#define OCR2_3_MASK 8
#define OCR2_4 4
#define OCR2_4_BIT 4
#define OCR2_4_MASK 16
#define OCR2_5 5
#define OCR2_5_BIT 5
#define OCR2_5_MASK 32
#define OCR2_6 6
#define OCR2_6_BIT 6
#define OCR2_6_MASK 64
#define OCR2_7 7
#define OCR2_7_BIT 7
#define OCR2_7_MASK 128

sfrb OCR2A = 0xb3;
#define OCR2_0 0
#define OCR2_0_BIT 0
#define OCR2_0_MASK 1
#define OCR2_1 1
#define OCR2_1_BIT 1
#define OCR2_1_MASK 2
#define OCR2_2 2
#define OCR2_2_BIT 2
#define OCR2_2_MASK 4
#define OCR2_3 3
#define OCR2_3_BIT 3
#define OCR2_3_MASK 8
#define OCR2_4 4
#define OCR2_4_BIT 4
#define OCR2_4_MASK 16
#define OCR2_5 5
#define OCR2_5_BIT 5
#define OCR2_5_MASK 32
#define OCR2_6 6
#define OCR2_6_BIT 6
#define OCR2_6_MASK 64
#define OCR2_7 7
#define OCR2_7_BIT 7
#define OCR2_7_MASK 128

sfrb TCNT2 = 0xb2;
#define TCNT2_0 0
#define TCNT2_0_BIT 0
#define TCNT2_0_MASK 1
#define TCNT2_1 1
#define TCNT2_1_BIT 1
#define TCNT2_1_MASK 2
#define TCNT2_2 2
#define TCNT2_2_BIT 2
#define TCNT2_2_MASK 4
#define TCNT2_3 3
#define TCNT2_3_BIT 3
#define TCNT2_3_MASK 8
#define TCNT2_4 4
#define TCNT2_4_BIT 4
#define TCNT2_4_MASK 16
#define TCNT2_5 5
#define TCNT2_5_BIT 5
#define TCNT2_5_MASK 32
#define TCNT2_6 6
#define TCNT2_6_BIT 6
#define TCNT2_6_MASK 64
#define TCNT2_7 7
#define TCNT2_7_BIT 7
#define TCNT2_7_MASK 128

sfrb TCCR2B = 0xb1;
#define CS20 0
#define CS20_BIT 0
#define CS20_MASK 1
#define CS21 1
#define CS21_BIT 1
#define CS21_MASK 2
#define CS22 2
#define CS22_BIT 2
#define CS22_MASK 4
#define WGM22 3
#define WGM22_BIT 3
#define WGM22_MASK 8
#define FOC2B 6
#define FOC2B_BIT 6
#define FOC2B_MASK 64
#define FOC2A 7
#define FOC2A_BIT 7
#define FOC2A_MASK 128

sfrb TCCR2A = 0xb0;
#define WGM20 0
#define WGM20_BIT 0
#define WGM20_MASK 1
#define WGM21 1
#define WGM21_BIT 1
#define WGM21_MASK 2
#define COM2B0 4
#define COM2B0_BIT 4
#define COM2B0_MASK 16
#define COM2B1 5
#define COM2B1_BIT 5
#define COM2B1_MASK 32
#define COM2A0 6
#define COM2A0_BIT 6
#define COM2A0_MASK 64
#define COM2A1 7
#define COM2A1_BIT 7
#define COM2A1_MASK 128

sfrb OCR1BH = 0x8b;
#define OCR1BH0 0
#define OCR1BH0_BIT 0
#define OCR1BH0_MASK 1
#define OCR1BH1 1
#define OCR1BH1_BIT 1
#define OCR1BH1_MASK 2
#define OCR1BH2 2
#define OCR1BH2_BIT 2
#define OCR1BH2_MASK 4
#define OCR1BH3 3
#define OCR1BH3_BIT 3
#define OCR1BH3_MASK 8
#define OCR1BH4 4
#define OCR1BH4_BIT 4
#define OCR1BH4_MASK 16
#define OCR1BH5 5
#define OCR1BH5_BIT 5
#define OCR1BH5_MASK 32
#define OCR1BH6 6
#define OCR1BH6_BIT 6
#define OCR1BH6_MASK 64
#define OCR1BH7 7
#define OCR1BH7_BIT 7
#define OCR1BH7_MASK 128

sfrb OCR1BL = 0x8a;
#define OCR1BL0 0
#define OCR1BL0_BIT 0
#define OCR1BL0_MASK 1
#define OCR1BL1 1
#define OCR1BL1_BIT 1
#define OCR1BL1_MASK 2
#define OCR1BL2 2
#define OCR1BL2_BIT 2
#define OCR1BL2_MASK 4
#define OCR1BL3 3
#define OCR1BL3_BIT 3
#define OCR1BL3_MASK 8
#define OCR1BL4 4
#define OCR1BL4_BIT 4
#define OCR1BL4_MASK 16
#define OCR1BL5 5
#define OCR1BL5_BIT 5
#define OCR1BL5_MASK 32
#define OCR1BL6 6
#define OCR1BL6_BIT 6
#define OCR1BL6_MASK 64
#define OCR1BL7 7
#define OCR1BL7_BIT 7
#define OCR1BL7_MASK 128

sfrw OCR1BW = 0x8a;

sfrb OCR1AH = 0x89;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x88;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x88;

sfrb ICR1H = 0x87;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x86;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x86;

sfrb TCNT1H = 0x85;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x84;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x84;

sfrb TCCR1C = 0x82;
#define FOC1B 6
#define FOC1B_BIT 6
#define FOC1B_MASK 64
#define FOC1A 7
#define FOC1A_BIT 7
#define FOC1A_MASK 128

sfrb TCCR1B = 0x81;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define WGM12 3
#define WGM12_BIT 3
#define WGM12_MASK 8
#define WGM13 4
#define WGM13_BIT 4
#define WGM13_MASK 16
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCCR1A = 0x80;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb DIDR1 = 0x7f;
#define AIN0D 0
#define AIN0D_BIT 0
#define AIN0D_MASK 1
#define AIN1D 1
#define AIN1D_BIT 1
#define AIN1D_MASK 2

sfrb DIDR0 = 0x7e;
#define ADC0D 0
#define ADC0D_BIT 0
#define ADC0D_MASK 1
#define ADC1D 1
#define ADC1D_BIT 1
#define ADC1D_MASK 2
#define ADC2D 2
#define ADC2D_BIT 2
#define ADC2D_MASK 4
#define ADC3D 3
#define ADC3D_BIT 3
#define ADC3D_MASK 8
#define ADC4D 4
#define ADC4D_BIT 4
#define ADC4D_MASK 16
#define ADC5D 5
#define ADC5D_BIT 5
#define ADC5D_MASK 32

sfrb ADMUX = 0x7c;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define MUX2 2
#define MUX2_BIT 2
#define MUX2_MASK 4
#define MUX3 3
#define MUX3_BIT 3
#define MUX3_MASK 8
#define ADLAR 5
#define ADLAR_BIT 5
#define ADLAR_MASK 32
#define REFS0 6
#define REFS0_BIT 6
#define REFS0_MASK 64
#define REFS1 7
#define REFS1_BIT 7
#define REFS1_MASK 128

sfrb ADCSRB = 0x7b;
#define ADTS0 0
#define ADTS0_BIT 0
#define ADTS0_MASK 1
#define ADTS1 1
#define ADTS1_BIT 1
#define ADTS1_MASK 2
#define ADTS2 2
#define ADTS2_BIT 2
#define ADTS2_MASK 4
#define ACME 6
#define ACME_BIT 6
#define ACME_MASK 64

sfrb ADCSRA = 0x7a;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADATE 5
#define ADATE_BIT 5
#define ADATE_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x79;
#define ADCH0 0
#define ADCH0_BIT 0
#define ADCH0_MASK 1
#define ADCH1 1
#define ADCH1_BIT 1
#define ADCH1_MASK 2
#define ADCH2 2
#define ADCH2_BIT 2
#define ADCH2_MASK 4
#define ADCH3 3
#define ADCH3_BIT 3
#define ADCH3_MASK 8
#define ADCH4 4
#define ADCH4_BIT 4
#define ADCH4_MASK 16
#define ADCH5 5
#define ADCH5_BIT 5
#define ADCH5_MASK 32
#define ADCH6 6
#define ADCH6_BIT 6
#define ADCH6_MASK 64
#define ADCH7 7
#define ADCH7_BIT 7
#define ADCH7_MASK 128

sfrb ADCL = 0x78;
#define ADCL0 0
#define ADCL0_BIT 0
#define ADCL0_MASK 1
#define ADCL1 1
#define ADCL1_BIT 1
#define ADCL1_MASK 2
#define ADCL2 2
#define ADCL2_BIT 2
#define ADCL2_MASK 4
#define ADCL3 3
#define ADCL3_BIT 3
#define ADCL3_MASK 8
#define ADCL4 4
#define ADCL4_BIT 4
#define ADCL4_MASK 16
#define ADCL5 5
#define ADCL5_BIT 5
#define ADCL5_MASK 32
#define ADCL6 6
#define ADCL6_BIT 6
#define ADCL6_MASK 64
#define ADCL7 7
#define ADCL7_BIT 7
#define ADCL7_MASK 128

sfrw ADCW = 0x78;

sfrb TIMSK2 = 0x70;
#define TOIE2 0
#define TOIE2_BIT 0
#define TOIE2_MASK 1
#define OCIE2A 1
#define OCIE2A_BIT 1
#define OCIE2A_MASK 2
#define OCIE2B 2
#define OCIE2B_BIT 2
#define OCIE2B_MASK 4

sfrb TIMSK1 = 0x6f;
#define TOIE1 0
#define TOIE1_BIT 0
#define TOIE1_MASK 1
#define OCIE1A 1
#define OCIE1A_BIT 1
#define OCIE1A_MASK 2
#define OCIE1B 2
#define OCIE1B_BIT 2
#define OCIE1B_MASK 4
#define ICIE1 5
#define ICIE1_BIT 5
#define ICIE1_MASK 32

sfrb TIMSK0 = 0x6e;
#define TOIE0 0
#define TOIE0_BIT 0
#define TOIE0_MASK 1
#define OCIE0A 1
#define OCIE0A_BIT 1
#define OCIE0A_MASK 2
#define OCIE0B 2
#define OCIE0B_BIT 2
#define OCIE0B_MASK 4

sfrb PCMSK2 = 0x6d;
#define PCINT16 0
#define PCINT16_BIT 0
#define PCINT16_MASK 1
#define PCINT17 1
#define PCINT17_BIT 1
#define PCINT17_MASK 2
#define PCINT18 2
#define PCINT18_BIT 2
#define PCINT18_MASK 4
#define PCINT19 3
#define PCINT19_BIT 3
#define PCINT19_MASK 8
#define PCINT20 4
#define PCINT20_BIT 4
#define PCINT20_MASK 16
#define PCINT21 5
#define PCINT21_BIT 5
#define PCINT21_MASK 32
#define PCINT22 6
#define PCINT22_BIT 6
#define PCINT22_MASK 64
#define PCINT23 7
#define PCINT23_BIT 7
#define PCINT23_MASK 128

sfrb PCMSK1 = 0x6c;
#define PCINT8 0
#define PCINT8_BIT 0
#define PCINT8_MASK 1
#define PCINT9 1
#define PCINT9_BIT 1
#define PCINT9_MASK 2
#define PCINT10 2
#define PCINT10_BIT 2
#define PCINT10_MASK 4
#define PCINT11 3
#define PCINT11_BIT 3
#define PCINT11_MASK 8
#define PCINT12 4
#define PCINT12_BIT 4
#define PCINT12_MASK 16
#define PCINT13 5
#define PCINT13_BIT 5
#define PCINT13_MASK 32
#define PCINT14 6
#define PCINT14_BIT 6
#define PCINT14_MASK 64

sfrb PCMSK0 = 0x6b;
#define PCINT0 0
#define PCINT0_BIT 0
#define PCINT0_MASK 1
#define PCINT1 1
#define PCINT1_BIT 1
#define PCINT1_MASK 2
#define PCINT2 2
#define PCINT2_BIT 2
#define PCINT2_MASK 4
#define PCINT3 3
#define PCINT3_BIT 3
#define PCINT3_MASK 8
#define PCINT4 4
#define PCINT4_BIT 4
#define PCINT4_MASK 16
#define PCINT5 5
#define PCINT5_BIT 5
#define PCINT5_MASK 32
#define PCINT6 6
#define PCINT6_BIT 6
#define PCINT6_MASK 64
#define PCINT7 7
#define PCINT7_BIT 7
#define PCINT7_MASK 128

sfrb EICRA = 0x69;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ISC10 2
#define ISC10_BIT 2
#define ISC10_MASK 4
#define ISC11 3
#define ISC11_BIT 3
#define ISC11_MASK 8

sfrb PCICR = 0x68;
#define PCIE0 0
#define PCIE0_BIT 0
#define PCIE0_MASK 1
#define PCIE1 1
#define PCIE1_BIT 1
#define PCIE1_MASK 2
#define PCIE2 2
#define PCIE2_BIT 2
#define PCIE2_MASK 4

sfrb OSCCAL = 0x66;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64
#define CAL7 7
#define CAL7_BIT 7
#define CAL7_MASK 128

sfrb PRR = 0x64;
#define PRADC 0
#define PRADC_BIT 0
#define PRADC_MASK 1
#define PRUSART0 1
#define PRUSART0_BIT 1
#define PRUSART0_MASK 2
#define PRSPI 2
#define PRSPI_BIT 2
#define PRSPI_MASK 4
#define PRTIM1 3
#define PRTIM1_BIT 3
#define PRTIM1_MASK 8
#define PRTIM0 5
#define PRTIM0_BIT 5
#define PRTIM0_MASK 32
#define PRTIM2 6
#define PRTIM2_BIT 6
#define PRTIM2_MASK 64
#define PRTWI 7
#define PRTWI_BIT 7
#define PRTWI_MASK 128

sfrb CLKPR = 0x61;
#define CLKPS0 0
#define CLKPS0_BIT 0
#define CLKPS0_MASK 1
#define CLKPS1 1
#define CLKPS1_BIT 1
#define CLKPS1_MASK 2
#define CLKPS2 2
#define CLKPS2_BIT 2
#define CLKPS2_MASK 4
#define CLKPS3 3
#define CLKPS3_BIT 3
#define CLKPS3_MASK 8
#define CLKPCE 7
#define CLKPCE_BIT 7
#define CLKPCE_MASK 128

sfrb WDTCSR = 0x60;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16
#define WDP3 5
#define WDP3_BIT 5
#define WDP3_MASK 32
#define WDIE 6
#define WDIE_BIT 6
#define WDIE_MASK 64
#define WDIF 7
#define WDIF_BIT 7
#define WDIF_MASK 128

sfrb SREG = 0x5f;

sfrb SPH = 0x5e;
#define SP8 0
#define SP8_BIT 0
#define SP8_MASK 1
#define SP9 1
#define SP9_BIT 1
#define SP9_MASK 2

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrw SPW = 0x5d;

sfrb SPMCSR = 0x57;
#define SELFPRGEN 0
#define SELFPRGEN_BIT 0
#define SELFPRGEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define BLBSET 3
#define BLBSET_BIT 3
#define BLBSET_MASK 8
#define RWWSRE 4
#define RWWSRE_BIT 4
#define RWWSRE_MASK 16
#define RWWSB 6
#define RWWSB_BIT 6
#define RWWSB_MASK 64
#define SPMIE 7
#define SPMIE_BIT 7
#define SPMIE_MASK 128

sfrb MCUCR = 0x55;
#define IVCE 0
#define IVCE_BIT 0
#define IVCE_MASK 1
#define IVSEL 1
#define IVSEL_BIT 1
#define IVSEL_MASK 2
#define PUD 4
#define PUD_BIT 4
#define PUD_MASK 16

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8

sfrb SMCR = 0x53;
#define SE 0
#define SE_BIT 0
#define SE_MASK 1
#define SM0 1
#define SM0_BIT 1
#define SM0_MASK 2
#define SM1 2
#define SM1_BIT 2
#define SM1_MASK 4
#define SM2 3
#define SM2_BIT 3
#define SM2_MASK 8

sfrb ACSR = 0x50;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIC 2
#define ACIC_BIT 2
#define ACIC_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb SPDR = 0x4e;
#define SPDR0 0
#define SPDR0_BIT 0
#define SPDR0_MASK 1
#define SPDR1 1
#define SPDR1_BIT 1
#define SPDR1_MASK 2
#define SPDR2 2
#define SPDR2_BIT 2
#define SPDR2_MASK 4
#define SPDR3 3
#define SPDR3_BIT 3
#define SPDR3_MASK 8
#define SPDR4 4
#define SPDR4_BIT 4
#define SPDR4_MASK 16
#define SPDR5 5
#define SPDR5_BIT 5
#define SPDR5_MASK 32
#define SPDR6 6
#define SPDR6_BIT 6
#define SPDR6_MASK 64
#define SPDR7 7
#define SPDR7_BIT 7
#define SPDR7_MASK 128

sfrb SPSR = 0x4d;
#define SPI2X 0
#define SPI2X_BIT 0
#define SPI2X_MASK 1
#define WCOL 6
#define WCOL_BIT 6
#define WCOL_MASK 64
#define SPIF 7
#define SPIF_BIT 7
#define SPIF_MASK 128

sfrb SPCR = 0x4c;
#define SPR0 0
#define SPR0_BIT 0
#define SPR0_MASK 1
#define SPR1 1
#define SPR1_BIT 1
#define SPR1_MASK 2
#define CPHA 2
#define CPHA_BIT 2
#define CPHA_MASK 4
#define CPOL 3
#define CPOL_BIT 3
#define CPOL_MASK 8
#define MSTR 4
#define MSTR_BIT 4
#define MSTR_MASK 16
#define DORD 5
#define DORD_BIT 5
#define DORD_MASK 32
#define SPE 6
#define SPE_BIT 6
#define SPE_MASK 64
#define SPIE 7
#define SPIE_BIT 7
#define SPIE_MASK 128

sfrb GPIOR2 = 0x4b;
#define GPIOR20 0
#define GPIOR20_BIT 0
#define GPIOR20_MASK 1
#define GPIOR21 1
#define GPIOR21_BIT 1
#define GPIOR21_MASK 2
#define GPIOR22 2
#define GPIOR22_BIT 2
#define GPIOR22_MASK 4
#define GPIOR23 3
#define GPIOR23_BIT 3
#define GPIOR23_MASK 8
#define GPIOR24 4
#define GPIOR24_BIT 4
#define GPIOR24_MASK 16
#define GPIOR25 5
#define GPIOR25_BIT 5
#define GPIOR25_MASK 32
#define GPIOR26 6
#define GPIOR26_BIT 6
#define GPIOR26_MASK 64
#define GPIOR27 7
#define GPIOR27_BIT 7
#define GPIOR27_MASK 128

sfrb GPIOR1 = 0x4a;
#define GPIOR10 0
#define GPIOR10_BIT 0
#define GPIOR10_MASK 1
#define GPIOR11 1
#define GPIOR11_BIT 1
#define GPIOR11_MASK 2
#define GPIOR12 2
#define GPIOR12_BIT 2
#define GPIOR12_MASK 4
#define GPIOR13 3
#define GPIOR13_BIT 3
#define GPIOR13_MASK 8
#define GPIOR14 4
#define GPIOR14_BIT 4
#define GPIOR14_MASK 16
#define GPIOR15 5
#define GPIOR15_BIT 5
#define GPIOR15_MASK 32
#define GPIOR16 6
#define GPIOR16_BIT 6
#define GPIOR16_MASK 64
#define GPIOR17 7
#define GPIOR17_BIT 7
#define GPIOR17_MASK 128

sfrb OCR0B = 0x48;
#define OCR0B_0 0
#define OCR0B_0_BIT 0
#define OCR0B_0_MASK 1
#define OCR0B_1 1
#define OCR0B_1_BIT 1
#define OCR0B_1_MASK 2
#define OCR0B_2 2
#define OCR0B_2_BIT 2
#define OCR0B_2_MASK 4
#define OCR0B_3 3
#define OCR0B_3_BIT 3
#define OCR0B_3_MASK 8
#define OCR0B_4 4
#define OCR0B_4_BIT 4
#define OCR0B_4_MASK 16
#define OCR0B_5 5
#define OCR0B_5_BIT 5
#define OCR0B_5_MASK 32
#define OCR0B_6 6
#define OCR0B_6_BIT 6
#define OCR0B_6_MASK 64
#define OCR0B_7 7
#define OCR0B_7_BIT 7
#define OCR0B_7_MASK 128

sfrb OCR0A = 0x47;
#define OCROA_0 0
#define OCROA_0_BIT 0
#define OCROA_0_MASK 1
#define OCROA_1 1
#define OCROA_1_BIT 1
#define OCROA_1_MASK 2
#define OCROA_2 2
#define OCROA_2_BIT 2
#define OCROA_2_MASK 4
#define OCROA_3 3
#define OCROA_3_BIT 3
#define OCROA_3_MASK 8
#define OCROA_4 4
#define OCROA_4_BIT 4
#define OCROA_4_MASK 16
#define OCROA_5 5
#define OCROA_5_BIT 5
#define OCROA_5_MASK 32
#define OCROA_6 6
#define OCROA_6_BIT 6
#define OCROA_6_MASK 64
#define OCROA_7 7
#define OCROA_7_BIT 7
#define OCROA_7_MASK 128

sfrb TCNT0 = 0x46;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb TCCR0B = 0x45;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM02 3
#define WGM02_BIT 3
#define WGM02_MASK 8
#define FOC0B 6
#define FOC0B_BIT 6
#define FOC0B_MASK 64
#define FOC0A 7
#define FOC0A_BIT 7
#define FOC0A_MASK 128

sfrb TCCR0A = 0x44;
#define WGM00 0
#define WGM00_BIT 0
#define WGM00_MASK 1
#define WGM01 1
#define WGM01_BIT 1
#define WGM01_MASK 2
#define COM0B0 4
#define COM0B0_BIT 4
#define COM0B0_MASK 16
#define COM0B1 5
#define COM0B1_BIT 5
#define COM0B1_MASK 32
#define COM0A0 6
#define COM0A0_BIT 6
#define COM0A0_MASK 64
#define COM0A1 7
#define COM0A1_BIT 7
#define COM0A1_MASK 128

sfrb GTCCR = 0x43;
#define PSRSYNC 0
#define PSRSYNC_BIT 0
#define PSRSYNC_MASK 1
#define PSRASY 1
#define PSRASY_BIT 1
#define PSRASY_MASK 2
#define TSM 7
#define TSM_BIT 7
#define TSM_MASK 128

sfrb EEARH = 0x42;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1

sfrb EEARL = 0x41;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64
#define EEAR7 7
#define EEAR7_BIT 7
#define EEAR7_MASK 128

sfrw EEARW = 0x41;

sfrb EEDR = 0x40;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3f;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEPE 1
#define EEPE_BIT 1
#define EEPE_MASK 2
#define EEMPE 2
#define EEMPE_BIT 2
#define EEMPE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8
#define EEPM0 4
#define EEPM0_BIT 4
#define EEPM0_MASK 16
#define EEPM1 5
#define EEPM1_BIT 5
#define EEPM1_MASK 32

sfrb GPIOR0 = 0x3e;
#define GPIOR00 0
#define GPIOR00_BIT 0
#define GPIOR00_MASK 1
#define GPIOR01 1
#define GPIOR01_BIT 1
#define GPIOR01_MASK 2
#define GPIOR02 2
#define GPIOR02_BIT 2
#define GPIOR02_MASK 4
#define GPIOR03 3
#define GPIOR03_BIT 3
#define GPIOR03_MASK 8
#define GPIOR04 4
#define GPIOR04_BIT 4
#define GPIOR04_MASK 16
#define GPIOR05 5
#define GPIOR05_BIT 5
#define GPIOR05_MASK 32
#define GPIOR06 6
#define GPIOR06_BIT 6
#define GPIOR06_MASK 64
#define GPIOR07 7
#define GPIOR07_BIT 7
#define GPIOR07_MASK 128

sfrb EIMSK = 0x3d;
#define INT0 0
#define INT0_BIT 0
#define INT0_MASK 1
#define INT1 1
#define INT1_BIT 1
#define INT1_MASK 2

sfrb EIFR = 0x3c;
#define INTF0 0
#define INTF0_BIT 0
#define INTF0_MASK 1
#define INTF1 1
#define INTF1_BIT 1
#define INTF1_MASK 2

sfrb PCIFR = 0x3b;
#define PCIF0 0
#define PCIF0_BIT 0
#define PCIF0_MASK 1
#define PCIF1 1
#define PCIF1_BIT 1
#define PCIF1_MASK 2
#define PCIF2 2
#define PCIF2_BIT 2
#define PCIF2_MASK 4

sfrb TIFR2 = 0x37;
#define TOV2 0
#define TOV2_BIT 0
#define TOV2_MASK 1
#define OCF2A 1
#define OCF2A_BIT 1
#define OCF2A_MASK 2
#define OCF2B 2
#define OCF2B_BIT 2
#define OCF2B_MASK 4

sfrb TIFR1 = 0x36;
#define TOV1 0
#define TOV1_BIT 0
#define TOV1_MASK 1
#define OCF1A 1
#define OCF1A_BIT 1
#define OCF1A_MASK 2
#define OCF1B 2
#define OCF1B_BIT 2
#define OCF1B_MASK 4
#define ICF1 5
#define ICF1_BIT 5
#define ICF1_MASK 32

sfrb TIFR0 = 0x35;
#define TOV0 0
#define TOV0_BIT 0
#define TOV0_MASK 1
#define OCF0A 1
#define OCF0A_BIT 1
#define OCF0A_MASK 2
#define OCF0B 2
#define OCF0B_BIT 2
#define OCF0B_MASK 4

sfrb PORTD = 0x2b;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x2a;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64
#define DDD7 7
#define DDD7_BIT 7
#define DDD7_MASK 128

sfrb PIND = 0x29;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb PORTC = 0x28;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1
#define PORTC1 1
#define PORTC1_BIT 1
#define PORTC1_MASK 2
#define PORTC2 2
#define PORTC2_BIT 2
#define PORTC2_MASK 4
#define PORTC3 3
#define PORTC3_BIT 3
#define PORTC3_MASK 8
#define PORTC4 4
#define PORTC4_BIT 4
#define PORTC4_MASK 16
#define PORTC5 5
#define PORTC5_BIT 5
#define PORTC5_MASK 32
#define PORTC6 6
#define PORTC6_BIT 6
#define PORTC6_MASK 64

sfrb DDRC = 0x27;
#define DDC0 0
#define DDC0_BIT 0
#define DDC0_MASK 1
#define DDC1 1
#define DDC1_BIT 1
#define DDC1_MASK 2
#define DDC2 2
#define DDC2_BIT 2
#define DDC2_MASK 4
#define DDC3 3
#define DDC3_BIT 3
#define DDC3_MASK 8
#define DDC4 4
#define DDC4_BIT 4
#define DDC4_MASK 16
#define DDC5 5
#define DDC5_BIT 5
#define DDC5_MASK 32
#define DDC6 6
#define DDC6_BIT 6
#define DDC6_MASK 64

sfrb PINC = 0x26;
#define PINC0 0
#define PINC0_BIT 0
#define PINC0_MASK 1
#define PINC1 1
#define PINC1_BIT 1
#define PINC1_MASK 2
#define PINC2 2
#define PINC2_BIT 2
#define PINC2_MASK 4
#define PINC3 3
#define PINC3_BIT 3
#define PINC3_MASK 8
#define PINC4 4
#define PINC4_BIT 4
#define PINC4_MASK 16
#define PINC5 5
#define PINC5_BIT 5
#define PINC5_MASK 32
#define PINC6 6
#define PINC6_BIT 6
#define PINC6_MASK 64

sfrb PORTB = 0x25;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x24;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x23;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

#endif
