#ifndef __ATmega6450_h
#define __ATmega6450_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0004
#define PCINT0_vect 0x0008
#define PCINT1_vect 0x000c
#define TIMER2_COMP_vect 0x0010
#define TIMER2_OVF_vect 0x0014
#define TIMER1_CAPT_vect 0x0018
#define TIMER1_COMPA_vect 0x001c
#define TIMER1_COMPB_vect 0x0020
#define TIMER1_OVF_vect 0x0024
#define TIMER0_COMP_vect 0x0028
#define TIMER0_OVF_vect 0x002c
#define SPI_STC_vect 0x0030
#define USART_RX_vect 0x0034
#define USART_UDRE_vect 0x0038
#define USART0_TX_vect 0x003c
#define USI_START_vect 0x0040
#define USI_OVERFLOW_vect 0x0044
#define ANALOG_COMP_vect 0x0048
#define ADC_vect 0x004c
#define EE_READY_vect 0x0050
#define SPM_READY_vect 0x0054
#define NOT_USED_vect 0x0058
#define PCINT2_vect 0x005c
#define PCINT3_vect 0x0060

// I/O addresses


sfrb PORTJ = 0xdd;
#define PORTJ0 0
#define PORTJ0_BIT 0
#define PORTJ0_MASK 1
#define PORTJ1 1
#define PORTJ1_BIT 1
#define PORTJ1_MASK 2
#define PORTJ2 2
#define PORTJ2_BIT 2
#define PORTJ2_MASK 4
#define PORTJ3 3
#define PORTJ3_BIT 3
#define PORTJ3_MASK 8
#define PORTJ4 4
#define PORTJ4_BIT 4
#define PORTJ4_MASK 16
#define PORTJ5 5
#define PORTJ5_BIT 5
#define PORTJ5_MASK 32
#define PORTJ6 6
#define PORTJ6_BIT 6
#define PORTJ6_MASK 64

sfrb DDRJ = 0xdc;
#define DDJ0 0
#define DDJ0_BIT 0
#define DDJ0_MASK 1
#define DDJ1 1
#define DDJ1_BIT 1
#define DDJ1_MASK 2
#define DDJ2 2
#define DDJ2_BIT 2
#define DDJ2_MASK 4
#define DDJ3 3
#define DDJ3_BIT 3
#define DDJ3_MASK 8
#define DDJ4 4
#define DDJ4_BIT 4
#define DDJ4_MASK 16
#define DDJ5 5
#define DDJ5_BIT 5
#define DDJ5_MASK 32
#define DDJ6 6
#define DDJ6_BIT 6
#define DDJ6_MASK 64

sfrb PINJ = 0xdb;
#define PINJ0 0
#define PINJ0_BIT 0
#define PINJ0_MASK 1
#define PINJ1 1
#define PINJ1_BIT 1
#define PINJ1_MASK 2
#define PINJ2 2
#define PINJ2_BIT 2
#define PINJ2_MASK 4
#define PINJ3 3
#define PINJ3_BIT 3
#define PINJ3_MASK 8
#define PINJ4 4
#define PINJ4_BIT 4
#define PINJ4_MASK 16
#define PINJ5 5
#define PINJ5_BIT 5
#define PINJ5_MASK 32
#define PINJ6 6
#define PINJ6_BIT 6
#define PINJ6_MASK 64

sfrb PORTH = 0xda;
#define PORTH0 0
#define PORTH0_BIT 0
#define PORTH0_MASK 1
#define PORTH1 1
#define PORTH1_BIT 1
#define PORTH1_MASK 2
#define PORTH2 2
#define PORTH2_BIT 2
#define PORTH2_MASK 4
#define PORTH3 3
#define PORTH3_BIT 3
#define PORTH3_MASK 8
#define PORTH4 4
#define PORTH4_BIT 4
#define PORTH4_MASK 16
#define PORTH5 5
#define PORTH5_BIT 5
#define PORTH5_MASK 32
#define PORTH6 6
#define PORTH6_BIT 6
#define PORTH6_MASK 64
#define PORTH7 7
#define PORTH7_BIT 7
#define PORTH7_MASK 128

sfrb DDRH = 0xd9;
#define DDH0 0
#define DDH0_BIT 0
#define DDH0_MASK 1
#define DDH1 1
#define DDH1_BIT 1
#define DDH1_MASK 2
#define DDH2 2
#define DDH2_BIT 2
#define DDH2_MASK 4
#define DDH3 3
#define DDH3_BIT 3
#define DDH3_MASK 8
#define DDH4 4
#define DDH4_BIT 4
#define DDH4_MASK 16
#define DDH5 5
#define DDH5_BIT 5
#define DDH5_MASK 32
#define DDH6 6
#define DDH6_BIT 6
#define DDH6_MASK 64
#define DDH7 7
#define DDH7_BIT 7
#define DDH7_MASK 128

sfrb PINH = 0xd8;
#define PINH0 0
#define PINH0_BIT 0
#define PINH0_MASK 1
#define PINH1 1
#define PINH1_BIT 1
#define PINH1_MASK 2
#define PINH2 2
#define PINH2_BIT 2
#define PINH2_MASK 4
#define PINH3 3
#define PINH3_BIT 3
#define PINH3_MASK 8
#define PINH4 4
#define PINH4_BIT 4
#define PINH4_MASK 16
#define PINH5 5
#define PINH5_BIT 5
#define PINH5_MASK 32
#define PINH6 6
#define PINH6_BIT 6
#define PINH6_MASK 64
#define PINH7 7
#define PINH7_BIT 7
#define PINH7_MASK 128

sfrb UDR0 = 0xc6;
#define UDR00 0
#define UDR00_BIT 0
#define UDR00_MASK 1
#define UDR01 1
#define UDR01_BIT 1
#define UDR01_MASK 2
#define UDR02 2
#define UDR02_BIT 2
#define UDR02_MASK 4
#define UDR03 3
#define UDR03_BIT 3
#define UDR03_MASK 8
#define UDR04 4
#define UDR04_BIT 4
#define UDR04_MASK 16
#define UDR05 5
#define UDR05_BIT 5
#define UDR05_MASK 32
#define UDR06 6
#define UDR06_BIT 6
#define UDR06_MASK 64
#define UDR07 7
#define UDR07_BIT 7
#define UDR07_MASK 128

sfrb UBRR0H = 0xc5;
#define UBRR8 0
#define UBRR8_BIT 0
#define UBRR8_MASK 1
#define UBRR9 1
#define UBRR9_BIT 1
#define UBRR9_MASK 2
#define UBRR10 2
#define UBRR10_BIT 2
#define UBRR10_MASK 4
#define UBRR11 3
#define UBRR11_BIT 3
#define UBRR11_MASK 8

sfrb UBRR0L = 0xc4;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrw UBRR0W = 0xc4;

sfrb UCSR0C = 0xc2;
#define UCPOL0 0
#define UCPOL0_BIT 0
#define UCPOL0_MASK 1
#define UCSZ00 1
#define UCSZ00_BIT 1
#define UCSZ00_MASK 2
#define UCSZ01 2
#define UCSZ01_BIT 2
#define UCSZ01_MASK 4
#define USBS0 3
#define USBS0_BIT 3
#define USBS0_MASK 8
#define UPM00 4
#define UPM00_BIT 4
#define UPM00_MASK 16
#define UPM01 5
#define UPM01_BIT 5
#define UPM01_MASK 32
#define UMSEL0 6
#define UMSEL0_BIT 6
#define UMSEL0_MASK 64

sfrb UCSR0B = 0xc1;
#define TXB80 0
#define TXB80_BIT 0
#define TXB80_MASK 1
#define RXB80 1
#define RXB80_BIT 1
#define RXB80_MASK 2
#define UCSZ02 2
#define UCSZ02_BIT 2
#define UCSZ02_MASK 4
#define TXEN0 3
#define TXEN0_BIT 3
#define TXEN0_MASK 8
#define RXEN0 4
#define RXEN0_BIT 4
#define RXEN0_MASK 16
#define UDRIE0 5
#define UDRIE0_BIT 5
#define UDRIE0_MASK 32
#define TXCIE0 6
#define TXCIE0_BIT 6
#define TXCIE0_MASK 64
#define RXCIE0 7
#define RXCIE0_BIT 7
#define RXCIE0_MASK 128

sfrb UCSR0A = 0xc0;
#define MPCM0 0
#define MPCM0_BIT 0
#define MPCM0_MASK 1
#define U2X0 1
#define U2X0_BIT 1
#define U2X0_MASK 2
#define UPE0 2
#define UPE0_BIT 2
#define UPE0_MASK 4
#define DOR0 3
#define DOR0_BIT 3
#define DOR0_MASK 8
#define FE0 4
#define FE0_BIT 4
#define FE0_MASK 16
#define UDRE0 5
#define UDRE0_BIT 5
#define UDRE0_MASK 32
#define TXC0 6
#define TXC0_BIT 6
#define TXC0_MASK 64
#define RXC0 7
#define RXC0_BIT 7
#define RXC0_MASK 128

sfrb USIDR = 0xba;
#define USIDR0 0
#define USIDR0_BIT 0
#define USIDR0_MASK 1
#define USIDR1 1
#define USIDR1_BIT 1
#define USIDR1_MASK 2
#define USIDR2 2
#define USIDR2_BIT 2
#define USIDR2_MASK 4
#define USIDR3 3
#define USIDR3_BIT 3
#define USIDR3_MASK 8
#define USIDR4 4
#define USIDR4_BIT 4
#define USIDR4_MASK 16
#define USIDR5 5
#define USIDR5_BIT 5
#define USIDR5_MASK 32
#define USIDR6 6
#define USIDR6_BIT 6
#define USIDR6_MASK 64
#define USIDR7 7
#define USIDR7_BIT 7
#define USIDR7_MASK 128

sfrb USISR = 0xb9;
#define USICNT0 0
#define USICNT0_BIT 0
#define USICNT0_MASK 1
#define USICNT1 1
#define USICNT1_BIT 1
#define USICNT1_MASK 2
#define USICNT2 2
#define USICNT2_BIT 2
#define USICNT2_MASK 4
#define USICNT3 3
#define USICNT3_BIT 3
#define USICNT3_MASK 8
#define USIDC 4
#define USIDC_BIT 4
#define USIDC_MASK 16
#define USIPF 5
#define USIPF_BIT 5
#define USIPF_MASK 32
#define USIOIF 6
#define USIOIF_BIT 6
#define USIOIF_MASK 64
#define USISIF 7
#define USISIF_BIT 7
#define USISIF_MASK 128

sfrb USICR = 0xb8;
#define USITC 0
#define USITC_BIT 0
#define USITC_MASK 1
#define USICLK 1
#define USICLK_BIT 1
#define USICLK_MASK 2
#define USICS0 2
#define USICS0_BIT 2
#define USICS0_MASK 4
#define USICS1 3
#define USICS1_BIT 3
#define USICS1_MASK 8
#define USIWM0 4
#define USIWM0_BIT 4
#define USIWM0_MASK 16
#define USIWM1 5
#define USIWM1_BIT 5
#define USIWM1_MASK 32
#define USIOIE 6
#define USIOIE_BIT 6
#define USIOIE_MASK 64
#define USISIE 7
#define USISIE_BIT 7
#define USISIE_MASK 128

sfrb ASSR = 0xb6;
#define TCR2UB 0
#define TCR2UB_BIT 0
#define TCR2UB_MASK 1
#define OCR2UB 1
#define OCR2UB_BIT 1
#define OCR2UB_MASK 2
#define TCN2UB 2
#define TCN2UB_BIT 2
#define TCN2UB_MASK 4
#define AS2 3
#define AS2_BIT 3
#define AS2_MASK 8
#define EXCLK 4
#define EXCLK_BIT 4
#define EXCLK_MASK 16

sfrb OCR2A = 0xb3;
#define OCR2A0 0
#define OCR2A0_BIT 0
#define OCR2A0_MASK 1
#define OCR2A1 1
#define OCR2A1_BIT 1
#define OCR2A1_MASK 2
#define OCR2A2 2
#define OCR2A2_BIT 2
#define OCR2A2_MASK 4
#define OCR2A3 3
#define OCR2A3_BIT 3
#define OCR2A3_MASK 8
#define OCR2A4 4
#define OCR2A4_BIT 4
#define OCR2A4_MASK 16
#define OCR2A5 5
#define OCR2A5_BIT 5
#define OCR2A5_MASK 32
#define OCR2A6 6
#define OCR2A6_BIT 6
#define OCR2A6_MASK 64
#define OCR2A7 7
#define OCR2A7_BIT 7
#define OCR2A7_MASK 128

sfrb TCNT2 = 0xb2;
#define TCNT2_0 0
#define TCNT2_0_BIT 0
#define TCNT2_0_MASK 1
#define TCNT2_1 1
#define TCNT2_1_BIT 1
#define TCNT2_1_MASK 2
#define TCNT2_2 2
#define TCNT2_2_BIT 2
#define TCNT2_2_MASK 4
#define TCNT2_3 3
#define TCNT2_3_BIT 3
#define TCNT2_3_MASK 8
#define TCNT2_4 4
#define TCNT2_4_BIT 4
#define TCNT2_4_MASK 16
#define TCNT2_5 5
#define TCNT2_5_BIT 5
#define TCNT2_5_MASK 32
#define TCNT2_6 6
#define TCNT2_6_BIT 6
#define TCNT2_6_MASK 64
#define TCNT2_7 7
#define TCNT2_7_BIT 7
#define TCNT2_7_MASK 128

sfrb TCCR2A = 0xb0;
#define CS20 0
#define CS20_BIT 0
#define CS20_MASK 1
#define CS21 1
#define CS21_BIT 1
#define CS21_MASK 2
#define CS22 2
#define CS22_BIT 2
#define CS22_MASK 4
#define WGM21 3
#define WGM21_BIT 3
#define WGM21_MASK 8
#define COM2A0 4
#define COM2A0_BIT 4
#define COM2A0_MASK 16
#define COM2A1 5
#define COM2A1_BIT 5
#define COM2A1_MASK 32
#define WGM20 6
#define WGM20_BIT 6
#define WGM20_MASK 64
#define FOC2A 7
#define FOC2A_BIT 7
#define FOC2A_MASK 128

sfrb OCR1BH = 0x8b;
#define OCR1BH0 0
#define OCR1BH0_BIT 0
#define OCR1BH0_MASK 1
#define OCR1BH1 1
#define OCR1BH1_BIT 1
#define OCR1BH1_MASK 2
#define OCR1BH2 2
#define OCR1BH2_BIT 2
#define OCR1BH2_MASK 4
#define OCR1BH3 3
#define OCR1BH3_BIT 3
#define OCR1BH3_MASK 8
#define OCR1BH4 4
#define OCR1BH4_BIT 4
#define OCR1BH4_MASK 16
#define OCR1BH5 5
#define OCR1BH5_BIT 5
#define OCR1BH5_MASK 32
#define OCR1BH6 6
#define OCR1BH6_BIT 6
#define OCR1BH6_MASK 64
#define OCR1BH7 7
#define OCR1BH7_BIT 7
#define OCR1BH7_MASK 128

sfrb OCR1BL = 0x8a;
#define OCR1BL0 0
#define OCR1BL0_BIT 0
#define OCR1BL0_MASK 1
#define OCR1BL1 1
#define OCR1BL1_BIT 1
#define OCR1BL1_MASK 2
#define OCR1BL2 2
#define OCR1BL2_BIT 2
#define OCR1BL2_MASK 4
#define OCR1BL3 3
#define OCR1BL3_BIT 3
#define OCR1BL3_MASK 8
#define OCR1BL4 4
#define OCR1BL4_BIT 4
#define OCR1BL4_MASK 16
#define OCR1BL5 5
#define OCR1BL5_BIT 5
#define OCR1BL5_MASK 32
#define OCR1BL6 6
#define OCR1BL6_BIT 6
#define OCR1BL6_MASK 64
#define OCR1BL7 7
#define OCR1BL7_BIT 7
#define OCR1BL7_MASK 128

sfrw OCR1BW = 0x8a;

sfrb OCR1AH = 0x89;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x88;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x88;

sfrb ICR1H = 0x87;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x86;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x86;

sfrb TCNT1H = 0x85;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x84;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x84;

sfrb TCCR1C = 0x82;
#define FOC1B 6
#define FOC1B_BIT 6
#define FOC1B_MASK 64
#define FOC1A 7
#define FOC1A_BIT 7
#define FOC1A_MASK 128

sfrb TCCR1B = 0x81;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define WGM12 3
#define WGM12_BIT 3
#define WGM12_MASK 8
#define WGM13 4
#define WGM13_BIT 4
#define WGM13_MASK 16
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCCR1A = 0x80;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb DIDR1 = 0x7f;
#define AIN0D 0
#define AIN0D_BIT 0
#define AIN0D_MASK 1
#define AIN1D 1
#define AIN1D_BIT 1
#define AIN1D_MASK 2

sfrb DIDR0 = 0x7e;
#define ADC0D 0
#define ADC0D_BIT 0
#define ADC0D_MASK 1
#define ADC1D 1
#define ADC1D_BIT 1
#define ADC1D_MASK 2
#define ADC2D 2
#define ADC2D_BIT 2
#define ADC2D_MASK 4
#define ADC3D 3
#define ADC3D_BIT 3
#define ADC3D_MASK 8
#define ADC4D 4
#define ADC4D_BIT 4
#define ADC4D_MASK 16
#define ADC5D 5
#define ADC5D_BIT 5
#define ADC5D_MASK 32
#define ADC6D 6
#define ADC6D_BIT 6
#define ADC6D_MASK 64
#define ADC7D 7
#define ADC7D_BIT 7
#define ADC7D_MASK 128

sfrb ADMUX = 0x7c;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define MUX2 2
#define MUX2_BIT 2
#define MUX2_MASK 4
#define MUX3 3
#define MUX3_BIT 3
#define MUX3_MASK 8
#define MUX4 4
#define MUX4_BIT 4
#define MUX4_MASK 16
#define ADLAR 5
#define ADLAR_BIT 5
#define ADLAR_MASK 32
#define REFS0 6
#define REFS0_BIT 6
#define REFS0_MASK 64
#define REFS1 7
#define REFS1_BIT 7
#define REFS1_MASK 128

sfrb ADCSRB = 0x7b;
#define ADTS0 0
#define ADTS0_BIT 0
#define ADTS0_MASK 1
#define ADTS1 1
#define ADTS1_BIT 1
#define ADTS1_MASK 2
#define ADTS2 2
#define ADTS2_BIT 2
#define ADTS2_MASK 4
#define ACME 6
#define ACME_BIT 6
#define ACME_MASK 64

sfrb ADCSRA = 0x7a;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADATE 5
#define ADATE_BIT 5
#define ADATE_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x79;
#define ADCH0 0
#define ADCH0_BIT 0
#define ADCH0_MASK 1
#define ADCH1 1
#define ADCH1_BIT 1
#define ADCH1_MASK 2
#define ADCH2 2
#define ADCH2_BIT 2
#define ADCH2_MASK 4
#define ADCH3 3
#define ADCH3_BIT 3
#define ADCH3_MASK 8
#define ADCH4 4
#define ADCH4_BIT 4
#define ADCH4_MASK 16
#define ADCH5 5
#define ADCH5_BIT 5
#define ADCH5_MASK 32
#define ADCH6 6
#define ADCH6_BIT 6
#define ADCH6_MASK 64
#define ADCH7 7
#define ADCH7_BIT 7
#define ADCH7_MASK 128

sfrb ADCL = 0x78;
#define ADCL0 0
#define ADCL0_BIT 0
#define ADCL0_MASK 1
#define ADCL1 1
#define ADCL1_BIT 1
#define ADCL1_MASK 2
#define ADCL2 2
#define ADCL2_BIT 2
#define ADCL2_MASK 4
#define ADCL3 3
#define ADCL3_BIT 3
#define ADCL3_MASK 8
#define ADCL4 4
#define ADCL4_BIT 4
#define ADCL4_MASK 16
#define ADCL5 5
#define ADCL5_BIT 5
#define ADCL5_MASK 32
#define ADCL6 6
#define ADCL6_BIT 6
#define ADCL6_MASK 64
#define ADCL7 7
#define ADCL7_BIT 7
#define ADCL7_MASK 128

sfrw ADCW = 0x78;

sfrb PCMSK3 = 0x73;
#define PCINT24 0
#define PCINT24_BIT 0
#define PCINT24_MASK 1
#define PCINT25 1
#define PCINT25_BIT 1
#define PCINT25_MASK 2
#define PCINT26 2
#define PCINT26_BIT 2
#define PCINT26_MASK 4
#define PCINT27 3
#define PCINT27_BIT 3
#define PCINT27_MASK 8
#define PCINT28 4
#define PCINT28_BIT 4
#define PCINT28_MASK 16
#define PCINT29 5
#define PCINT29_BIT 5
#define PCINT29_MASK 32
#define PCINT30 6
#define PCINT30_BIT 6
#define PCINT30_MASK 64

sfrb TIMSK2 = 0x70;
#define TOIE2 0
#define TOIE2_BIT 0
#define TOIE2_MASK 1
#define OCIE2A 1
#define OCIE2A_BIT 1
#define OCIE2A_MASK 2

sfrb TIMSK1 = 0x6f;
#define TOIE1 0
#define TOIE1_BIT 0
#define TOIE1_MASK 1
#define OCIE1A 1
#define OCIE1A_BIT 1
#define OCIE1A_MASK 2
#define OCIE1B 2
#define OCIE1B_BIT 2
#define OCIE1B_MASK 4
#define ICIE1 5
#define ICIE1_BIT 5
#define ICIE1_MASK 32

sfrb TIMSK0 = 0x6e;
#define TOIE0 0
#define TOIE0_BIT 0
#define TOIE0_MASK 1
#define OCIE0A 1
#define OCIE0A_BIT 1
#define OCIE0A_MASK 2

sfrb PCMSK2 = 0x6d;
#define PCINT16 0
#define PCINT16_BIT 0
#define PCINT16_MASK 1
#define PCINT17 1
#define PCINT17_BIT 1
#define PCINT17_MASK 2
#define PCINT18 2
#define PCINT18_BIT 2
#define PCINT18_MASK 4
#define PCINT19 3
#define PCINT19_BIT 3
#define PCINT19_MASK 8
#define PCINT20 4
#define PCINT20_BIT 4
#define PCINT20_MASK 16
#define PCINT21 5
#define PCINT21_BIT 5
#define PCINT21_MASK 32
#define PCINT22 6
#define PCINT22_BIT 6
#define PCINT22_MASK 64
#define PCINT23 7
#define PCINT23_BIT 7
#define PCINT23_MASK 128

sfrb PCMSK1 = 0x6c;
#define PCINT8 0
#define PCINT8_BIT 0
#define PCINT8_MASK 1
#define PCINT9 1
#define PCINT9_BIT 1
#define PCINT9_MASK 2
#define PCINT10 2
#define PCINT10_BIT 2
#define PCINT10_MASK 4
#define PCINT11 3
#define PCINT11_BIT 3
#define PCINT11_MASK 8
#define PCINT12 4
#define PCINT12_BIT 4
#define PCINT12_MASK 16
#define PCINT13 5
#define PCINT13_BIT 5
#define PCINT13_MASK 32
#define PCINT14 6
#define PCINT14_BIT 6
#define PCINT14_MASK 64
#define PCINT15 7
#define PCINT15_BIT 7
#define PCINT15_MASK 128

sfrb PCMSK0 = 0x6b;
#define PCINT0 0
#define PCINT0_BIT 0
#define PCINT0_MASK 1
#define PCINT1 1
#define PCINT1_BIT 1
#define PCINT1_MASK 2
#define PCINT2 2
#define PCINT2_BIT 2
#define PCINT2_MASK 4
#define PCINT3 3
#define PCINT3_BIT 3
#define PCINT3_MASK 8
#define PCINT4 4
#define PCINT4_BIT 4
#define PCINT4_MASK 16
#define PCINT5 5
#define PCINT5_BIT 5
#define PCINT5_MASK 32
#define PCINT6 6
#define PCINT6_BIT 6
#define PCINT6_MASK 64
#define PCINT7 7
#define PCINT7_BIT 7
#define PCINT7_MASK 128

sfrb EICRA = 0x69;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2

sfrb OSCCAL = 0x66;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64
#define CAL7 7
#define CAL7_BIT 7
#define CAL7_MASK 128

sfrb PRR = 0x64;
#define PRADC 0
#define PRADC_BIT 0
#define PRADC_MASK 1
#define PRUSART0 1
#define PRUSART0_BIT 1
#define PRUSART0_MASK 2
#define PRSPI 2
#define PRSPI_BIT 2
#define PRSPI_MASK 4
#define PRTIM1 3
#define PRTIM1_BIT 3
#define PRTIM1_MASK 8
#define PRLCD 4
#define PRLCD_BIT 4
#define PRLCD_MASK 16

sfrb CLKPR = 0x61;
#define CLKPS0 0
#define CLKPS0_BIT 0
#define CLKPS0_MASK 1
#define CLKPS1 1
#define CLKPS1_BIT 1
#define CLKPS1_MASK 2
#define CLKPS2 2
#define CLKPS2_BIT 2
#define CLKPS2_MASK 4
#define CLKPS3 3
#define CLKPS3_BIT 3
#define CLKPS3_MASK 8
#define CLKPCE 7
#define CLKPCE_BIT 7
#define CLKPCE_MASK 128

sfrb WDTCR = 0x60;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16

sfrb SREG = 0x5f;

sfrb SPH = 0x5e;
#define SP8 0
#define SP8_BIT 0
#define SP8_MASK 1
#define SP9 1
#define SP9_BIT 1
#define SP9_MASK 2
#define SP10 2
#define SP10_BIT 2
#define SP10_MASK 4
#define SP11 3
#define SP11_BIT 3
#define SP11_MASK 8
#define SP12 4
#define SP12_BIT 4
#define SP12_MASK 16
#define SP13 5
#define SP13_BIT 5
#define SP13_MASK 32
#define SP14 6
#define SP14_BIT 6
#define SP14_MASK 64
#define SP15 7
#define SP15_BIT 7
#define SP15_MASK 128

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrw SPW = 0x5d;

sfrb SPMCSR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define BLBSET 3
#define BLBSET_BIT 3
#define BLBSET_MASK 8
#define RWWSRE 4
#define RWWSRE_BIT 4
#define RWWSRE_MASK 16
#define RWWSB 6
#define RWWSB_BIT 6
#define RWWSB_MASK 64
#define SPMIE 7
#define SPMIE_BIT 7
#define SPMIE_MASK 128

sfrb MCUCR = 0x55;
#define IVCE 0
#define IVCE_BIT 0
#define IVCE_MASK 1
#define IVSEL 1
#define IVSEL_BIT 1
#define IVSEL_MASK 2
#define PUD 4
#define PUD_BIT 4
#define PUD_MASK 16
#define JTD 7
#define JTD_BIT 7
#define JTD_MASK 128

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8
#define JTRF 4
#define JTRF_BIT 4
#define JTRF_MASK 16

sfrb SMCR = 0x53;
#define SE 0
#define SE_BIT 0
#define SE_MASK 1
#define SM0 1
#define SM0_BIT 1
#define SM0_MASK 2
#define SM1 2
#define SM1_BIT 2
#define SM1_MASK 4
#define SM2 3
#define SM2_BIT 3
#define SM2_MASK 8

sfrb OCDR = 0x51;
#define OCDR0 0
#define OCDR0_BIT 0
#define OCDR0_MASK 1
#define OCDR1 1
#define OCDR1_BIT 1
#define OCDR1_MASK 2
#define OCDR2 2
#define OCDR2_BIT 2
#define OCDR2_MASK 4
#define OCDR3 3
#define OCDR3_BIT 3
#define OCDR3_MASK 8
#define OCDR4 4
#define OCDR4_BIT 4
#define OCDR4_MASK 16
#define OCDR5 5
#define OCDR5_BIT 5
#define OCDR5_MASK 32
#define OCDR6 6
#define OCDR6_BIT 6
#define OCDR6_MASK 64
#define OCDR7 7
#define OCDR7_BIT 7
#define OCDR7_MASK 128

sfrb ACSR = 0x50;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIC 2
#define ACIC_BIT 2
#define ACIC_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb SPDR = 0x4e;
#define SPDR0 0
#define SPDR0_BIT 0
#define SPDR0_MASK 1
#define SPDR1 1
#define SPDR1_BIT 1
#define SPDR1_MASK 2
#define SPDR2 2
#define SPDR2_BIT 2
#define SPDR2_MASK 4
#define SPDR3 3
#define SPDR3_BIT 3
#define SPDR3_MASK 8
#define SPDR4 4
#define SPDR4_BIT 4
#define SPDR4_MASK 16
#define SPDR5 5
#define SPDR5_BIT 5
#define SPDR5_MASK 32
#define SPDR6 6
#define SPDR6_BIT 6
#define SPDR6_MASK 64
#define SPDR7 7
#define SPDR7_BIT 7
#define SPDR7_MASK 128

sfrb SPSR = 0x4d;
#define SPI2X 0
#define SPI2X_BIT 0
#define SPI2X_MASK 1
#define WCOL 6
#define WCOL_BIT 6
#define WCOL_MASK 64
#define SPIF 7
#define SPIF_BIT 7
#define SPIF_MASK 128

sfrb SPCR = 0x4c;
#define SPR0 0
#define SPR0_BIT 0
#define SPR0_MASK 1
#define SPR1 1
#define SPR1_BIT 1
#define SPR1_MASK 2
#define CPHA 2
#define CPHA_BIT 2
#define CPHA_MASK 4
#define CPOL 3
#define CPOL_BIT 3
#define CPOL_MASK 8
#define MSTR 4
#define MSTR_BIT 4
#define MSTR_MASK 16
#define DORD 5
#define DORD_BIT 5
#define DORD_MASK 32
#define SPE 6
#define SPE_BIT 6
#define SPE_MASK 64
#define SPIE 7
#define SPIE_BIT 7
#define SPIE_MASK 128

sfrb GPIOR2 = 0x4b;
#define GPIOR20 0
#define GPIOR20_BIT 0
#define GPIOR20_MASK 1
#define GPIOR21 1
#define GPIOR21_BIT 1
#define GPIOR21_MASK 2
#define GPIOR22 2
#define GPIOR22_BIT 2
#define GPIOR22_MASK 4
#define GPIOR23 3
#define GPIOR23_BIT 3
#define GPIOR23_MASK 8
#define GPIOR24 4
#define GPIOR24_BIT 4
#define GPIOR24_MASK 16
#define GPIOR25 5
#define GPIOR25_BIT 5
#define GPIOR25_MASK 32
#define GPIOR26 6
#define GPIOR26_BIT 6
#define GPIOR26_MASK 64
#define GPIOR27 7
#define GPIOR27_BIT 7
#define GPIOR27_MASK 128

sfrb GPIOR1 = 0x4a;
#define GPIOR10 0
#define GPIOR10_BIT 0
#define GPIOR10_MASK 1
#define GPIOR11 1
#define GPIOR11_BIT 1
#define GPIOR11_MASK 2
#define GPIOR12 2
#define GPIOR12_BIT 2
#define GPIOR12_MASK 4
#define GPIOR13 3
#define GPIOR13_BIT 3
#define GPIOR13_MASK 8
#define GPIOR14 4
#define GPIOR14_BIT 4
#define GPIOR14_MASK 16
#define GPIOR15 5
#define GPIOR15_BIT 5
#define GPIOR15_MASK 32
#define GPIOR16 6
#define GPIOR16_BIT 6
#define GPIOR16_MASK 64
#define GPIOR17 7
#define GPIOR17_BIT 7
#define GPIOR17_MASK 128

sfrb OCR0A = 0x47;
#define OCR0A0 0
#define OCR0A0_BIT 0
#define OCR0A0_MASK 1
#define OCR0A1 1
#define OCR0A1_BIT 1
#define OCR0A1_MASK 2
#define OCR0A2 2
#define OCR0A2_BIT 2
#define OCR0A2_MASK 4
#define OCR0A3 3
#define OCR0A3_BIT 3
#define OCR0A3_MASK 8
#define OCR0A4 4
#define OCR0A4_BIT 4
#define OCR0A4_MASK 16
#define OCR0A5 5
#define OCR0A5_BIT 5
#define OCR0A5_MASK 32
#define OCR0A6 6
#define OCR0A6_BIT 6
#define OCR0A6_MASK 64
#define OCR0A7 7
#define OCR0A7_BIT 7
#define OCR0A7_MASK 128

sfrb TCNT0 = 0x46;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb TCCR0A = 0x44;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM01 3
#define WGM01_BIT 3
#define WGM01_MASK 8
#define COM0A0 4
#define COM0A0_BIT 4
#define COM0A0_MASK 16
#define COM0A1 5
#define COM0A1_BIT 5
#define COM0A1_MASK 32
#define WGM00 6
#define WGM00_BIT 6
#define WGM00_MASK 64
#define FOC0A 7
#define FOC0A_BIT 7
#define FOC0A_MASK 128

sfrb GTCCR = 0x43;
#define PSR310 0
#define PSR310_BIT 0
#define PSR310_MASK 1
#define PSR2 1
#define PSR2_BIT 1
#define PSR2_MASK 2
#define TSM 7
#define TSM_BIT 7
#define TSM_MASK 128

sfrb EEARH = 0x42;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1
#define EEAR9 1
#define EEAR9_BIT 1
#define EEAR9_MASK 2
#define EEAR10 2
#define EEAR10_BIT 2
#define EEAR10_MASK 4

sfrb EEARL = 0x41;
#define EEARL0 0
#define EEARL0_BIT 0
#define EEARL0_MASK 1
#define EEARL1 1
#define EEARL1_BIT 1
#define EEARL1_MASK 2
#define EEARL2 2
#define EEARL2_BIT 2
#define EEARL2_MASK 4
#define EEARL3 3
#define EEARL3_BIT 3
#define EEARL3_MASK 8
#define EEARL4 4
#define EEARL4_BIT 4
#define EEARL4_MASK 16
#define EEARL5 5
#define EEARL5_BIT 5
#define EEARL5_MASK 32
#define EEARL6 6
#define EEARL6_BIT 6
#define EEARL6_MASK 64
#define EEARL7 7
#define EEARL7_BIT 7
#define EEARL7_MASK 128

sfrw EEARW = 0x41;

sfrb EEDR = 0x40;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3f;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEWE 1
#define EEWE_BIT 1
#define EEWE_MASK 2
#define EEMWE 2
#define EEMWE_BIT 2
#define EEMWE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8

sfrb GPIOR0 = 0x3e;
#define GPIOR00 0
#define GPIOR00_BIT 0
#define GPIOR00_MASK 1
#define GPIOR01 1
#define GPIOR01_BIT 1
#define GPIOR01_MASK 2
#define GPIOR02 2
#define GPIOR02_BIT 2
#define GPIOR02_MASK 4
#define GPIOR03 3
#define GPIOR03_BIT 3
#define GPIOR03_MASK 8
#define GPIOR04 4
#define GPIOR04_BIT 4
#define GPIOR04_MASK 16
#define GPIOR05 5
#define GPIOR05_BIT 5
#define GPIOR05_MASK 32
#define GPIOR06 6
#define GPIOR06_BIT 6
#define GPIOR06_MASK 64
#define GPIOR07 7
#define GPIOR07_BIT 7
#define GPIOR07_MASK 128

sfrb EIMSK = 0x3d;
#define INT0 0
#define INT0_BIT 0
#define INT0_MASK 1
#define PCIE0 4
#define PCIE0_BIT 4
#define PCIE0_MASK 16
#define PCIE1 5
#define PCIE1_BIT 5
#define PCIE1_MASK 32
#define PCIE2 6
#define PCIE2_BIT 6
#define PCIE2_MASK 64
#define PCIE3 7
#define PCIE3_BIT 7
#define PCIE3_MASK 128

sfrb EIFR = 0x3c;
#define INTF0 0
#define INTF0_BIT 0
#define INTF0_MASK 1
#define PCIF0 4
#define PCIF0_BIT 4
#define PCIF0_MASK 16
#define PCIF1 5
#define PCIF1_BIT 5
#define PCIF1_MASK 32
#define PCIF2 6
#define PCIF2_BIT 6
#define PCIF2_MASK 64
#define PCIF3 7
#define PCIF3_BIT 7
#define PCIF3_MASK 128

sfrb TIFR2 = 0x37;
#define TOV2 0
#define TOV2_BIT 0
#define TOV2_MASK 1
#define OCF2A 1
#define OCF2A_BIT 1
#define OCF2A_MASK 2

sfrb TIFR1 = 0x36;
#define TOV1 0
#define TOV1_BIT 0
#define TOV1_MASK 1
#define OCF1A 1
#define OCF1A_BIT 1
#define OCF1A_MASK 2
#define OCF1B 2
#define OCF1B_BIT 2
#define OCF1B_MASK 4
#define ICF1 5
#define ICF1_BIT 5
#define ICF1_MASK 32

sfrb TIFR0 = 0x35;
#define TOV0 0
#define TOV0_BIT 0
#define TOV0_MASK 1
#define OCF0A 1
#define OCF0A_BIT 1
#define OCF0A_MASK 2

sfrb PORTG = 0x34;
#define PORTG0 0
#define PORTG0_BIT 0
#define PORTG0_MASK 1
#define PORTG1 1
#define PORTG1_BIT 1
#define PORTG1_MASK 2
#define PORTG2 2
#define PORTG2_BIT 2
#define PORTG2_MASK 4
#define PORTG3 3
#define PORTG3_BIT 3
#define PORTG3_MASK 8
#define PORTG4 4
#define PORTG4_BIT 4
#define PORTG4_MASK 16

sfrb DDRG = 0x33;
#define DDG0 0
#define DDG0_BIT 0
#define DDG0_MASK 1
#define DDG1 1
#define DDG1_BIT 1
#define DDG1_MASK 2
#define DDG2 2
#define DDG2_BIT 2
#define DDG2_MASK 4
#define DDG3 3
#define DDG3_BIT 3
#define DDG3_MASK 8
#define DDG4 4
#define DDG4_BIT 4
#define DDG4_MASK 16

sfrb PING = 0x32;
#define PING0 0
#define PING0_BIT 0
#define PING0_MASK 1
#define PING1 1
#define PING1_BIT 1
#define PING1_MASK 2
#define PING2 2
#define PING2_BIT 2
#define PING2_MASK 4
#define PING3 3
#define PING3_BIT 3
#define PING3_MASK 8
#define PING4 4
#define PING4_BIT 4
#define PING4_MASK 16
#define PING5 5
#define PING5_BIT 5
#define PING5_MASK 32

sfrb PORTF = 0x31;
#define PORTF0 0
#define PORTF0_BIT 0
#define PORTF0_MASK 1
#define PORTF1 1
#define PORTF1_BIT 1
#define PORTF1_MASK 2
#define PORTF2 2
#define PORTF2_BIT 2
#define PORTF2_MASK 4
#define PORTF3 3
#define PORTF3_BIT 3
#define PORTF3_MASK 8
#define PORTF4 4
#define PORTF4_BIT 4
#define PORTF4_MASK 16
#define PORTF5 5
#define PORTF5_BIT 5
#define PORTF5_MASK 32
#define PORTF6 6
#define PORTF6_BIT 6
#define PORTF6_MASK 64
#define PORTF7 7
#define PORTF7_BIT 7
#define PORTF7_MASK 128

sfrb DDRF = 0x30;
#define DDF0 0
#define DDF0_BIT 0
#define DDF0_MASK 1
#define DDF1 1
#define DDF1_BIT 1
#define DDF1_MASK 2
#define DDF2 2
#define DDF2_BIT 2
#define DDF2_MASK 4
#define DDF3 3
#define DDF3_BIT 3
#define DDF3_MASK 8
#define DDF4 4
#define DDF4_BIT 4
#define DDF4_MASK 16
#define DDF5 5
#define DDF5_BIT 5
#define DDF5_MASK 32
#define DDF6 6
#define DDF6_BIT 6
#define DDF6_MASK 64
#define DDF7 7
#define DDF7_BIT 7
#define DDF7_MASK 128

sfrb PINF = 0x2f;
#define PINF0 0
#define PINF0_BIT 0
#define PINF0_MASK 1
#define PINF1 1
#define PINF1_BIT 1
#define PINF1_MASK 2
#define PINF2 2
#define PINF2_BIT 2
#define PINF2_MASK 4
#define PINF3 3
#define PINF3_BIT 3
#define PINF3_MASK 8
#define PINF4 4
#define PINF4_BIT 4
#define PINF4_MASK 16
#define PINF5 5
#define PINF5_BIT 5
#define PINF5_MASK 32
#define PINF6 6
#define PINF6_BIT 6
#define PINF6_MASK 64
#define PINF7 7
#define PINF7_BIT 7
#define PINF7_MASK 128

sfrb PORTE = 0x2e;
#define PORTE0 0
#define PORTE0_BIT 0
#define PORTE0_MASK 1
#define PORTE1 1
#define PORTE1_BIT 1
#define PORTE1_MASK 2
#define PORTE2 2
#define PORTE2_BIT 2
#define PORTE2_MASK 4
#define PORTE3 3
#define PORTE3_BIT 3
#define PORTE3_MASK 8
#define PORTE4 4
#define PORTE4_BIT 4
#define PORTE4_MASK 16
#define PORTE5 5
#define PORTE5_BIT 5
#define PORTE5_MASK 32
#define PORTE6 6
#define PORTE6_BIT 6
#define PORTE6_MASK 64
#define PORTE7 7
#define PORTE7_BIT 7
#define PORTE7_MASK 128

sfrb DDRE = 0x2d;
#define DDE0 0
#define DDE0_BIT 0
#define DDE0_MASK 1
#define DDE1 1
#define DDE1_BIT 1
#define DDE1_MASK 2
#define DDE2 2
#define DDE2_BIT 2
#define DDE2_MASK 4
#define DDE3 3
#define DDE3_BIT 3
#define DDE3_MASK 8
#define DDE4 4
#define DDE4_BIT 4
#define DDE4_MASK 16
#define DDE5 5
#define DDE5_BIT 5
#define DDE5_MASK 32
#define DDE6 6
#define DDE6_BIT 6
#define DDE6_MASK 64
#define DDE7 7
#define DDE7_BIT 7
#define DDE7_MASK 128

sfrb PINE = 0x2c;
#define PINE0 0
#define PINE0_BIT 0
#define PINE0_MASK 1
#define PINE1 1
#define PINE1_BIT 1
#define PINE1_MASK 2
#define PINE2 2
#define PINE2_BIT 2
#define PINE2_MASK 4
#define PINE3 3
#define PINE3_BIT 3
#define PINE3_MASK 8
#define PINE4 4
#define PINE4_BIT 4
#define PINE4_MASK 16
#define PINE5 5
#define PINE5_BIT 5
#define PINE5_MASK 32
#define PINE6 6
#define PINE6_BIT 6
#define PINE6_MASK 64
#define PINE7 7
#define PINE7_BIT 7
#define PINE7_MASK 128

sfrb PORTD = 0x2b;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x2a;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64
#define DDD7 7
#define DDD7_BIT 7
#define DDD7_MASK 128

sfrb PIND = 0x29;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb PORTC = 0x28;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1
#define PORTC1 1
#define PORTC1_BIT 1
#define PORTC1_MASK 2
#define PORTC2 2
#define PORTC2_BIT 2
#define PORTC2_MASK 4
#define PORTC3 3
#define PORTC3_BIT 3
#define PORTC3_MASK 8
#define PORTC4 4
#define PORTC4_BIT 4
#define PORTC4_MASK 16
#define PORTC5 5
#define PORTC5_BIT 5
#define PORTC5_MASK 32
#define PORTC6 6
#define PORTC6_BIT 6
#define PORTC6_MASK 64
#define PORTC7 7
#define PORTC7_BIT 7
#define PORTC7_MASK 128

sfrb DDRC = 0x27;
#define DDC0 0
#define DDC0_BIT 0
#define DDC0_MASK 1
#define DDC1 1
#define DDC1_BIT 1
#define DDC1_MASK 2
#define DDC2 2
#define DDC2_BIT 2
#define DDC2_MASK 4
#define DDC3 3
#define DDC3_BIT 3
#define DDC3_MASK 8
#define DDC4 4
#define DDC4_BIT 4
#define DDC4_MASK 16
#define DDC5 5
#define DDC5_BIT 5
#define DDC5_MASK 32
#define DDC6 6
#define DDC6_BIT 6
#define DDC6_MASK 64
#define DDC7 7
#define DDC7_BIT 7
#define DDC7_MASK 128

sfrb PINC = 0x26;
#define PINC0 0
#define PINC0_BIT 0
#define PINC0_MASK 1
#define PINC1 1
#define PINC1_BIT 1
#define PINC1_MASK 2
#define PINC2 2
#define PINC2_BIT 2
#define PINC2_MASK 4
#define PINC3 3
#define PINC3_BIT 3
#define PINC3_MASK 8
#define PINC4 4
#define PINC4_BIT 4
#define PINC4_MASK 16
#define PINC5 5
#define PINC5_BIT 5
#define PINC5_MASK 32
#define PINC6 6
#define PINC6_BIT 6
#define PINC6_MASK 64
#define PINC7 7
#define PINC7_BIT 7
#define PINC7_MASK 128

sfrb PORTB = 0x25;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x24;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x23;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb PORTA = 0x22;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8
#define PORTA4 4
#define PORTA4_BIT 4
#define PORTA4_MASK 16
#define PORTA5 5
#define PORTA5_BIT 5
#define PORTA5_MASK 32
#define PORTA6 6
#define PORTA6_BIT 6
#define PORTA6_MASK 64
#define PORTA7 7
#define PORTA7_BIT 7
#define PORTA7_MASK 128

sfrb DDRA = 0x21;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define DDA2 2
#define DDA2_BIT 2
#define DDA2_MASK 4
#define DDA3 3
#define DDA3_BIT 3
#define DDA3_MASK 8
#define DDA4 4
#define DDA4_BIT 4
#define DDA4_MASK 16
#define DDA5 5
#define DDA5_BIT 5
#define DDA5_MASK 32
#define DDA6 6
#define DDA6_BIT 6
#define DDA6_MASK 64
#define DDA7 7
#define DDA7_BIT 7
#define DDA7_MASK 128

sfrb PINA = 0x20;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8
#define PINA4 4
#define PINA4_BIT 4
#define PINA4_MASK 16
#define PINA5 5
#define PINA5_BIT 5
#define PINA5_MASK 32
#define PINA6 6
#define PINA6_BIT 6
#define PINA6_MASK 64
#define PINA7 7
#define PINA7_BIT 7
#define PINA7_MASK 128

#endif
