#ifndef __ATmega161_h
#define __ATmega161_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0004
#define INT1_vect 0x0008
#define INT2_vect 0x000c
#define TIMER2_COMP_vect 0x0010
#define TIMER2_OVF_vect 0x0014
#define TIMER1_CAPT_vect 0x0018
#define TIMER1_COMPA_vect 0x001c
#define TIMER1_COMPB_vect 0x0020
#define TIMER1_OVF_vect 0x0024
#define TIMER0_COMP_vect 0x0028
#define TIMER0_OVF_vect 0x002c
#define SPISTC_vect 0x0030
#define UART0RX_vect 0x0034
#define UART1RX_vect 0x0038
#define UART0UDRE_vect 0x003c
#define UART1UDRE_vect 0x0040
#define UART0TX_vect 0x0044
#define UART1TX_vect 0x0048
#define EE_RDY_vect 0x004c
#define ANA_COMP_vect 0x0050

// I/O addresses


sfrb SREG = 0x5f;

sfrb SPH = 0x5e;
#define SP8 0
#define SP8_BIT 0
#define SP8_MASK 1
#define SP9 1
#define SP9_BIT 1
#define SP9_MASK 2
#define SP10 2
#define SP10_BIT 2
#define SP10_MASK 4
#define SP11 3
#define SP11_BIT 3
#define SP11_MASK 8
#define SP12 4
#define SP12_BIT 4
#define SP12_MASK 16
#define SP13 5
#define SP13_BIT 5
#define SP13_MASK 32
#define SP14 6
#define SP14_BIT 6
#define SP14_MASK 64
#define SP15 7
#define SP15_BIT 7
#define SP15_MASK 128

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrw SPW = 0x5d;

sfrb GIMSK = 0x5b;
#define INT2 5
#define INT2_BIT 5
#define INT2_MASK 32
#define INT0 6
#define INT0_BIT 6
#define INT0_MASK 64
#define INT1 7
#define INT1_BIT 7
#define INT1_MASK 128

sfrb GIFR = 0x5a;
#define INTF2 5
#define INTF2_BIT 5
#define INTF2_MASK 32
#define INTF0 6
#define INTF0_BIT 6
#define INTF0_MASK 64
#define INTF1 7
#define INTF1_BIT 7
#define INTF1_MASK 128

sfrb TIMSK = 0x59;
#define OCIE0 0
#define OCIE0_BIT 0
#define OCIE0_MASK 1
#define TOIE0 1
#define TOIE0_BIT 1
#define TOIE0_MASK 2
#define OCIE2 2
#define OCIE2_BIT 2
#define OCIE2_MASK 4
#define TICIE1 3
#define TICIE1_BIT 3
#define TICIE1_MASK 8
#define TOIE2 4
#define TOIE2_BIT 4
#define TOIE2_MASK 16
#define OCIE1B 5
#define OCIE1B_BIT 5
#define OCIE1B_MASK 32
#define OCIE1A 6
#define OCIE1A_BIT 6
#define OCIE1A_MASK 64
#define TOIE1 7
#define TOIE1_BIT 7
#define TOIE1_MASK 128

sfrb TIFR = 0x58;
#define OCF0 0
#define OCF0_BIT 0
#define OCF0_MASK 1
#define TOV0 1
#define TOV0_BIT 1
#define TOV0_MASK 2
#define OCF2 2
#define OCF2_BIT 2
#define OCF2_MASK 4
#define ICF1 3
#define ICF1_BIT 3
#define ICF1_MASK 8
#define TOV2 4
#define TOV2_BIT 4
#define TOV2_MASK 16
#define OCF1B 5
#define OCF1B_BIT 5
#define OCF1B_MASK 32
#define OCF1A 6
#define OCF1A_BIT 6
#define OCF1A_MASK 64
#define TOV1 7
#define TOV1_BIT 7
#define TOV1_MASK 128

sfrb SPMCR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define BLBSET 3
#define BLBSET_BIT 3
#define BLBSET_MASK 8

sfrb EMCUCR = 0x56;
#define ISC2 0
#define ISC2_BIT 0
#define ISC2_MASK 1
#define SRW11 1
#define SRW11_BIT 1
#define SRW11_MASK 2
#define SRW00 2
#define SRW00_BIT 2
#define SRW00_MASK 4
#define SRW01 3
#define SRW01_BIT 3
#define SRW01_MASK 8
#define SRL0 4
#define SRL0_BIT 4
#define SRL0_MASK 16
#define SRL1 5
#define SRL1_BIT 5
#define SRL1_MASK 32
#define SRL2 6
#define SRL2_BIT 6
#define SRL2_MASK 64
#define SM0 7
#define SM0_BIT 7
#define SM0_MASK 128

sfrb MCUCR = 0x55;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ISC10 2
#define ISC10_BIT 2
#define ISC10_MASK 4
#define ISC11 3
#define ISC11_BIT 3
#define ISC11_MASK 8
#define SM1 4
#define SM1_BIT 4
#define SM1_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32
#define SRW10 6
#define SRW10_BIT 6
#define SRW10_MASK 64
#define SRE 7
#define SRE_BIT 7
#define SRE_MASK 128

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8

sfrb TCCR0 = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM01 3
#define WGM01_BIT 3
#define WGM01_MASK 8
#define COM00 4
#define COM00_BIT 4
#define COM00_MASK 16
#define COM01 5
#define COM01_BIT 5
#define COM01_MASK 32
#define WGM00 6
#define WGM00_BIT 6
#define WGM00_MASK 64
#define FOC0 7
#define FOC0_BIT 7
#define FOC0_MASK 128

sfrb TCNT0 = 0x52;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb OCR0 = 0x51;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb SFIOR = 0x50;
#define PSR10 0
#define PSR10_BIT 0
#define PSR10_MASK 1
#define PSR2 1
#define PSR2_BIT 1
#define PSR2_MASK 2

sfrb TCCR1A = 0x4f;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define FOC1B 2
#define FOC1B_BIT 2
#define FOC1B_MASK 4
#define FOC1A 3
#define FOC1A_BIT 3
#define FOC1A_MASK 8
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb TCCR1B = 0x4e;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define CTC1 3
#define CTC1_BIT 3
#define CTC1_MASK 8
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCNT1H = 0x4d;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x4c;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x4c;

sfrb OCR1AH = 0x4b;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x4a;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x4a;

sfrb OCR1BH = 0x49;
#define OCR1BH0 0
#define OCR1BH0_BIT 0
#define OCR1BH0_MASK 1
#define OCR1BH1 1
#define OCR1BH1_BIT 1
#define OCR1BH1_MASK 2
#define OCR1BH2 2
#define OCR1BH2_BIT 2
#define OCR1BH2_MASK 4
#define OCR1BH3 3
#define OCR1BH3_BIT 3
#define OCR1BH3_MASK 8
#define OCR1BH4 4
#define OCR1BH4_BIT 4
#define OCR1BH4_MASK 16
#define OCR1BH5 5
#define OCR1BH5_BIT 5
#define OCR1BH5_MASK 32
#define OCR1BH6 6
#define OCR1BH6_BIT 6
#define OCR1BH6_MASK 64
#define OCR1BH7 7
#define OCR1BH7_BIT 7
#define OCR1BH7_MASK 128

sfrb OCR1BL = 0x48;
#define OCR1BL0 0
#define OCR1BL0_BIT 0
#define OCR1BL0_MASK 1
#define OCR1BL1 1
#define OCR1BL1_BIT 1
#define OCR1BL1_MASK 2
#define OCR1BL2 2
#define OCR1BL2_BIT 2
#define OCR1BL2_MASK 4
#define OCR1BL3 3
#define OCR1BL3_BIT 3
#define OCR1BL3_MASK 8
#define OCR1BL4 4
#define OCR1BL4_BIT 4
#define OCR1BL4_MASK 16
#define OCR1BL5 5
#define OCR1BL5_BIT 5
#define OCR1BL5_MASK 32
#define OCR1BL6 6
#define OCR1BL6_BIT 6
#define OCR1BL6_MASK 64
#define OCR1BL7 7
#define OCR1BL7_BIT 7
#define OCR1BL7_MASK 128

sfrw OCR1BW = 0x48;

sfrb TCCR2 = 0x47;
#define CS20 0
#define CS20_BIT 0
#define CS20_MASK 1
#define CS21 1
#define CS21_BIT 1
#define CS21_MASK 2
#define CS22 2
#define CS22_BIT 2
#define CS22_MASK 4
#define CTC2 3
#define CTC2_BIT 3
#define CTC2_MASK 8
#define COM20 4
#define COM20_BIT 4
#define COM20_MASK 16
#define COM21 5
#define COM21_BIT 5
#define COM21_MASK 32
#define PWM2 6
#define PWM2_BIT 6
#define PWM2_MASK 64
#define FOC2 7
#define FOC2_BIT 7
#define FOC2_MASK 128

sfrb ASSR = 0x46;
#define TCR2UB 0
#define TCR2UB_BIT 0
#define TCR2UB_MASK 1
#define OCR2UB 1
#define OCR2UB_BIT 1
#define OCR2UB_MASK 2
#define TCN2UB 2
#define TCN2UB_BIT 2
#define TCN2UB_MASK 4
#define AS2 3
#define AS2_BIT 3
#define AS2_MASK 8

sfrb ICR1H = 0x45;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x44;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x44;

sfrb TCNT2 = 0x43;
#define TCNT2_0 0
#define TCNT2_0_BIT 0
#define TCNT2_0_MASK 1
#define TCNT2_1 1
#define TCNT2_1_BIT 1
#define TCNT2_1_MASK 2
#define TCNT2_2 2
#define TCNT2_2_BIT 2
#define TCNT2_2_MASK 4
#define TCNT2_3 3
#define TCNT2_3_BIT 3
#define TCNT2_3_MASK 8
#define TCNT2_4 4
#define TCNT2_4_BIT 4
#define TCNT2_4_MASK 16
#define TCNT2_5 5
#define TCNT2_5_BIT 5
#define TCNT2_5_MASK 32
#define TCNT2_6 6
#define TCNT2_6_BIT 6
#define TCNT2_6_MASK 64
#define TCNT2_7 7
#define TCNT2_7_BIT 7
#define TCNT2_7_MASK 128

sfrb OCR2 = 0x42;
#define OCR2_0 0
#define OCR2_0_BIT 0
#define OCR2_0_MASK 1
#define OCR2_1 1
#define OCR2_1_BIT 1
#define OCR2_1_MASK 2
#define OCR2_2 2
#define OCR2_2_BIT 2
#define OCR2_2_MASK 4
#define OCR2_3 3
#define OCR2_3_BIT 3
#define OCR2_3_MASK 8
#define OCR2_4 4
#define OCR2_4_BIT 4
#define OCR2_4_MASK 16
#define OCR2_5 5
#define OCR2_5_BIT 5
#define OCR2_5_MASK 32
#define OCR2_6 6
#define OCR2_6_BIT 6
#define OCR2_6_MASK 64
#define OCR2_7 7
#define OCR2_7_BIT 7
#define OCR2_7_MASK 128

sfrb WDTCR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDTOE 4
#define WDTOE_BIT 4
#define WDTOE_MASK 16

sfrb UBRRHI = 0x40;
#define UBRRHI00 0
#define UBRRHI00_BIT 0
#define UBRRHI00_MASK 1
#define UBRRHI01 1
#define UBRRHI01_BIT 1
#define UBRRHI01_MASK 2
#define UBRRHI02 2
#define UBRRHI02_BIT 2
#define UBRRHI02_MASK 4
#define UBRRHI03 3
#define UBRRHI03_BIT 3
#define UBRRHI03_MASK 8
#define UBRRHI10 4
#define UBRRHI10_BIT 4
#define UBRRHI10_MASK 16
#define UBRRHI11 5
#define UBRRHI11_BIT 5
#define UBRRHI11_MASK 32
#define UBRRHI12 6
#define UBRRHI12_BIT 6
#define UBRRHI12_MASK 64
#define UBRRHI13 7
#define UBRRHI13_BIT 7
#define UBRRHI13_MASK 128

sfrb EEARH = 0x3f;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1

sfrb EEARL = 0x3e;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64
#define EEAR7 7
#define EEAR7_BIT 7
#define EEAR7_MASK 128

sfrw EEARW = 0x3e;

sfrb EEDR = 0x3d;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3c;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEWE 1
#define EEWE_BIT 1
#define EEWE_MASK 2
#define EEMWE 2
#define EEMWE_BIT 2
#define EEMWE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8

sfrb PORTA = 0x3b;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8
#define PORTA4 4
#define PORTA4_BIT 4
#define PORTA4_MASK 16
#define PORTA5 5
#define PORTA5_BIT 5
#define PORTA5_MASK 32
#define PORTA6 6
#define PORTA6_BIT 6
#define PORTA6_MASK 64
#define PORTA7 7
#define PORTA7_BIT 7
#define PORTA7_MASK 128

sfrb DDRA = 0x3a;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define DDA2 2
#define DDA2_BIT 2
#define DDA2_MASK 4
#define DDA3 3
#define DDA3_BIT 3
#define DDA3_MASK 8
#define DDA4 4
#define DDA4_BIT 4
#define DDA4_MASK 16
#define DDA5 5
#define DDA5_BIT 5
#define DDA5_MASK 32
#define DDA6 6
#define DDA6_BIT 6
#define DDA6_MASK 64
#define DDA7 7
#define DDA7_BIT 7
#define DDA7_MASK 128

sfrb PINA = 0x39;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8
#define PINA4 4
#define PINA4_BIT 4
#define PINA4_MASK 16
#define PINA5 5
#define PINA5_BIT 5
#define PINA5_MASK 32
#define PINA6 6
#define PINA6_BIT 6
#define PINA6_MASK 64
#define PINA7 7
#define PINA7_BIT 7
#define PINA7_MASK 128

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x37;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb PORTC = 0x35;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1
#define PORTC1 1
#define PORTC1_BIT 1
#define PORTC1_MASK 2
#define PORTC2 2
#define PORTC2_BIT 2
#define PORTC2_MASK 4
#define PORTC3 3
#define PORTC3_BIT 3
#define PORTC3_MASK 8
#define PORTC4 4
#define PORTC4_BIT 4
#define PORTC4_MASK 16
#define PORTC5 5
#define PORTC5_BIT 5
#define PORTC5_MASK 32
#define PORTC6 6
#define PORTC6_BIT 6
#define PORTC6_MASK 64
#define PORTC7 7
#define PORTC7_BIT 7
#define PORTC7_MASK 128

sfrb DDRC = 0x34;
#define DDC0 0
#define DDC0_BIT 0
#define DDC0_MASK 1
#define DDC1 1
#define DDC1_BIT 1
#define DDC1_MASK 2
#define DDC2 2
#define DDC2_BIT 2
#define DDC2_MASK 4
#define DDC3 3
#define DDC3_BIT 3
#define DDC3_MASK 8
#define DDC4 4
#define DDC4_BIT 4
#define DDC4_MASK 16
#define DDC5 5
#define DDC5_BIT 5
#define DDC5_MASK 32
#define DDC6 6
#define DDC6_BIT 6
#define DDC6_MASK 64
#define DDC7 7
#define DDC7_BIT 7
#define DDC7_MASK 128

sfrb PINC = 0x33;
#define PINC0 0
#define PINC0_BIT 0
#define PINC0_MASK 1
#define PINC1 1
#define PINC1_BIT 1
#define PINC1_MASK 2
#define PINC2 2
#define PINC2_BIT 2
#define PINC2_MASK 4
#define PINC3 3
#define PINC3_BIT 3
#define PINC3_MASK 8
#define PINC4 4
#define PINC4_BIT 4
#define PINC4_MASK 16
#define PINC5 5
#define PINC5_BIT 5
#define PINC5_MASK 32
#define PINC6 6
#define PINC6_BIT 6
#define PINC6_MASK 64
#define PINC7 7
#define PINC7_BIT 7
#define PINC7_MASK 128

sfrb PORTD = 0x32;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x31;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64
#define DDD7 7
#define DDD7_BIT 7
#define DDD7_MASK 128

sfrb PIND = 0x30;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb SPDR = 0x2f;
#define SPDR0 0
#define SPDR0_BIT 0
#define SPDR0_MASK 1
#define SPDR1 1
#define SPDR1_BIT 1
#define SPDR1_MASK 2
#define SPDR2 2
#define SPDR2_BIT 2
#define SPDR2_MASK 4
#define SPDR3 3
#define SPDR3_BIT 3
#define SPDR3_MASK 8
#define SPDR4 4
#define SPDR4_BIT 4
#define SPDR4_MASK 16
#define SPDR5 5
#define SPDR5_BIT 5
#define SPDR5_MASK 32
#define SPDR6 6
#define SPDR6_BIT 6
#define SPDR6_MASK 64
#define SPDR7 7
#define SPDR7_BIT 7
#define SPDR7_MASK 128

sfrb SPSR = 0x2e;
#define SPI2X 0
#define SPI2X_BIT 0
#define SPI2X_MASK 1
#define WCOL 6
#define WCOL_BIT 6
#define WCOL_MASK 64
#define SPIF 7
#define SPIF_BIT 7
#define SPIF_MASK 128

sfrb SPCR = 0x2d;
#define SPR0 0
#define SPR0_BIT 0
#define SPR0_MASK 1
#define SPR1 1
#define SPR1_BIT 1
#define SPR1_MASK 2
#define CPHA 2
#define CPHA_BIT 2
#define CPHA_MASK 4
#define CPOL 3
#define CPOL_BIT 3
#define CPOL_MASK 8
#define MSTR 4
#define MSTR_BIT 4
#define MSTR_MASK 16
#define DORD 5
#define DORD_BIT 5
#define DORD_MASK 32
#define SPE 6
#define SPE_BIT 6
#define SPE_MASK 64
#define SPIE 7
#define SPIE_BIT 7
#define SPIE_MASK 128

sfrb UDR0 = 0x2c;
#define UDR00 0
#define UDR00_BIT 0
#define UDR00_MASK 1
#define UDR01 1
#define UDR01_BIT 1
#define UDR01_MASK 2
#define UDR02 2
#define UDR02_BIT 2
#define UDR02_MASK 4
#define UDR03 3
#define UDR03_BIT 3
#define UDR03_MASK 8
#define UDR04 4
#define UDR04_BIT 4
#define UDR04_MASK 16
#define UDR05 5
#define UDR05_BIT 5
#define UDR05_MASK 32
#define UDR06 6
#define UDR06_BIT 6
#define UDR06_MASK 64
#define UDR07 7
#define UDR07_BIT 7
#define UDR07_MASK 128

sfrb UCSR0A = 0x2b;
#define MPCM0 0
#define MPCM0_BIT 0
#define MPCM0_MASK 1
#define U2X0 1
#define U2X0_BIT 1
#define U2X0_MASK 2
#define OR0 3
#define OR0_BIT 3
#define OR0_MASK 8
#define FE0 4
#define FE0_BIT 4
#define FE0_MASK 16
#define UDRE0 5
#define UDRE0_BIT 5
#define UDRE0_MASK 32
#define TXC0 6
#define TXC0_BIT 6
#define TXC0_MASK 64
#define RXC0 7
#define RXC0_BIT 7
#define RXC0_MASK 128

sfrb UCSR0B = 0x2a;
#define TXB80 0
#define TXB80_BIT 0
#define TXB80_MASK 1
#define RXB80 1
#define RXB80_BIT 1
#define RXB80_MASK 2
#define CHR90 2
#define CHR90_BIT 2
#define CHR90_MASK 4
#define TXEN0 3
#define TXEN0_BIT 3
#define TXEN0_MASK 8
#define RXEN0 4
#define RXEN0_BIT 4
#define RXEN0_MASK 16
#define UDR0IE0 5
#define UDR0IE0_BIT 5
#define UDR0IE0_MASK 32
#define TXCIE0 6
#define TXCIE0_BIT 6
#define TXCIE0_MASK 64
#define RXCIE0 7
#define RXCIE0_BIT 7
#define RXCIE0_MASK 128

sfrb UBRR0 = 0x29;
#define UBRR00 0
#define UBRR00_BIT 0
#define UBRR00_MASK 1
#define UBRR01 1
#define UBRR01_BIT 1
#define UBRR01_MASK 2
#define UBRR02 2
#define UBRR02_BIT 2
#define UBRR02_MASK 4
#define UBRR03 3
#define UBRR03_BIT 3
#define UBRR03_MASK 8
#define UBRR04 4
#define UBRR04_BIT 4
#define UBRR04_MASK 16
#define UBRR05 5
#define UBRR05_BIT 5
#define UBRR05_MASK 32
#define UBRR06 6
#define UBRR06_BIT 6
#define UBRR06_MASK 64
#define UBRR07 7
#define UBRR07_BIT 7
#define UBRR07_MASK 128

sfrb ACSR = 0x28;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIC 2
#define ACIC_BIT 2
#define ACIC_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define AINBG 6
#define AINBG_BIT 6
#define AINBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb PORTE = 0x27;
#define PORTE0 0
#define PORTE0_BIT 0
#define PORTE0_MASK 1
#define PORTE1 1
#define PORTE1_BIT 1
#define PORTE1_MASK 2
#define PORTE2 2
#define PORTE2_BIT 2
#define PORTE2_MASK 4

sfrb DDRE = 0x26;
#define DDE0 0
#define DDE0_BIT 0
#define DDE0_MASK 1
#define DDE1 1
#define DDE1_BIT 1
#define DDE1_MASK 2
#define DDE2 2
#define DDE2_BIT 2
#define DDE2_MASK 4

sfrb PINE = 0x25;
#define PINE0 0
#define PINE0_BIT 0
#define PINE0_MASK 1
#define PINE1 1
#define PINE1_BIT 1
#define PINE1_MASK 2
#define PINE2 2
#define PINE2_BIT 2
#define PINE2_MASK 4

sfrb UDR1 = 0x23;
#define UDR10 0
#define UDR10_BIT 0
#define UDR10_MASK 1
#define UDR11 1
#define UDR11_BIT 1
#define UDR11_MASK 2
#define UDR12 2
#define UDR12_BIT 2
#define UDR12_MASK 4
#define UDR13 3
#define UDR13_BIT 3
#define UDR13_MASK 8
#define UDR14 4
#define UDR14_BIT 4
#define UDR14_MASK 16
#define UDR15 5
#define UDR15_BIT 5
#define UDR15_MASK 32
#define UDR16 6
#define UDR16_BIT 6
#define UDR16_MASK 64
#define UDR17 7
#define UDR17_BIT 7
#define UDR17_MASK 128

sfrb UCSR1A = 0x22;
#define MPCM1 0
#define MPCM1_BIT 0
#define MPCM1_MASK 1
#define U2X1 1
#define U2X1_BIT 1
#define U2X1_MASK 2
#define OR1 3
#define OR1_BIT 3
#define OR1_MASK 8
#define FE1 4
#define FE1_BIT 4
#define FE1_MASK 16
#define UDRE1 5
#define UDRE1_BIT 5
#define UDRE1_MASK 32
#define TXC1 6
#define TXC1_BIT 6
#define TXC1_MASK 64
#define RXC1 7
#define RXC1_BIT 7
#define RXC1_MASK 128

sfrb UCSR1B = 0x21;
#define TXB81 0
#define TXB81_BIT 0
#define TXB81_MASK 1
#define RXB81 1
#define RXB81_BIT 1
#define RXB81_MASK 2
#define CHR91 2
#define CHR91_BIT 2
#define CHR91_MASK 4
#define TXEN1 3
#define TXEN1_BIT 3
#define TXEN1_MASK 8
#define RXEN1 4
#define RXEN1_BIT 4
#define RXEN1_MASK 16
#define UDR1IE1 5
#define UDR1IE1_BIT 5
#define UDR1IE1_MASK 32
#define TXCIE1 6
#define TXCIE1_BIT 6
#define TXCIE1_MASK 64
#define RXCIE1 7
#define RXCIE1_BIT 7
#define RXCIE1_MASK 128

sfrb UBRR1 = 0x20;
#define UBRR10 0
#define UBRR10_BIT 0
#define UBRR10_MASK 1
#define UBRR11 1
#define UBRR11_BIT 1
#define UBRR11_MASK 2
#define UBRR12 2
#define UBRR12_BIT 2
#define UBRR12_MASK 4
#define UBRR13 3
#define UBRR13_BIT 3
#define UBRR13_MASK 8
#define UBRR14 4
#define UBRR14_BIT 4
#define UBRR14_MASK 16
#define UBRR15 5
#define UBRR15_BIT 5
#define UBRR15_MASK 32
#define UBRR16 6
#define UBRR16_BIT 6
#define UBRR16_MASK 64
#define UBRR17 7
#define UBRR17_BIT 7
#define UBRR17_MASK 128

#endif
