#ifndef __ATmega1281_h
#define __ATmega1281_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0004
#define INT1_vect 0x0008
#define INT2_vect 0x000c
#define INT3_vect 0x0010
#define INT4_vect 0x0014
#define INT5_vect 0x0018
#define INT6_vect 0x001c
#define INT7_vect 0x0020
#define PCINT0_vect 0x0024
#define PCINT1_vect 0x0028
#define PCINT2_vect 0x002c
#define WDT_vect 0x0030
#define TIMER2_COMPA_vect 0x0034
#define TIMER2_COMPB_vect 0x0038
#define TIMER2_OVF_vect 0x003c
#define TIMER1_CAPT_vect 0x0040
#define TIMER1_COMPA_vect 0x0044
#define TIMER1_COMPB_vect 0x0048
#define TIMER1_COMPC_vect 0x004c
#define TIMER1_OVF_vect 0x0050
#define TIMER0_COMPA_vect 0x0054
#define TIMER0_COMPB_vect 0x0058
#define TIMER0_OVF_vect 0x005c
#define SPI_STC_vect 0x0060
#define USART0_RX_vect 0x0064
#define USART0_UDRE_vect 0x0068
#define USART0_TX_vect 0x006c
#define ANALOG_COMP_vect 0x0070
#define ADC_vect 0x0074
#define EE_READY_vect 0x0078
#define TIMER3_CAPT_vect 0x007c
#define TIMER3_COMPA_vect 0x0080
#define TIMER3_COMPB_vect 0x0084
#define TIMER3_COMPC_vect 0x0088
#define TIMER3_OVF_vect 0x008c
#define USART1_RX_vect 0x0090
#define USART1_UDRE_vect 0x0094
#define USART1_TX_vect 0x0098
#define TWI_vect 0x009c
#define SPM_READY_vect 0x00a0
#define TIMER4_CAPT_vect 0x00a4
#define TIMER4_COMPA_vect 0x00a8
#define TIMER4_COMPB_vect 0x00ac
#define TIMER4_COMPC_vect 0x00b0
#define TIMER4_OVF_vect 0x00b4
#define TIMER5_CAPT_vect 0x00b8
#define TIMER5_COMPA_vect 0x00bc
#define TIMER5_COMPB_vect 0x00c0
#define TIMER5_COMPC_vect 0x00c4
#define TIMER5_OVF_vect 0x00c8
#define USART2_RX_vect 0x00cc
#define USART2_UDRE_vect 0x00d0
#define USART2_TX_vect 0x00d4
#define USART3_RX_vect 0x00d8
#define USART3_UDRE_vect 0x00dc
#define USART3_TX_vect 0x00e0

// I/O addresses


sfrb UDR3 = 0x136;

sfrb UBRR3H = 0x135;

sfrb UBRR3L = 0x134;

sfrw UBRR3W = 0x134;

sfrb UCSR3C = 0x132;

sfrb UCSR3B = 0x131;

sfrb UCSR3A = 0x130;

sfrb OCR5CH = 0x12d;
#define OCR5CH0 0
#define OCR5CH0_BIT 0
#define OCR5CH0_MASK 1
#define OCR5CH1 1
#define OCR5CH1_BIT 1
#define OCR5CH1_MASK 2
#define OCR5CH2 2
#define OCR5CH2_BIT 2
#define OCR5CH2_MASK 4
#define OCR5CH3 3
#define OCR5CH3_BIT 3
#define OCR5CH3_MASK 8
#define OCR5CH4 4
#define OCR5CH4_BIT 4
#define OCR5CH4_MASK 16
#define OCR5CH5 5
#define OCR5CH5_BIT 5
#define OCR5CH5_MASK 32
#define OCR5CH6 6
#define OCR5CH6_BIT 6
#define OCR5CH6_MASK 64
#define OCR5CH7 7
#define OCR5CH7_BIT 7
#define OCR5CH7_MASK 128

sfrb OCR5CL = 0x12c;
#define OCR5CL0 0
#define OCR5CL0_BIT 0
#define OCR5CL0_MASK 1
#define OCR5CL1 1
#define OCR5CL1_BIT 1
#define OCR5CL1_MASK 2
#define OCR5CL2 2
#define OCR5CL2_BIT 2
#define OCR5CL2_MASK 4
#define OCR5CL3 3
#define OCR5CL3_BIT 3
#define OCR5CL3_MASK 8
#define OCR5CL4 4
#define OCR5CL4_BIT 4
#define OCR5CL4_MASK 16
#define OCR5CL5 5
#define OCR5CL5_BIT 5
#define OCR5CL5_MASK 32
#define OCR5CL6 6
#define OCR5CL6_BIT 6
#define OCR5CL6_MASK 64
#define OCR5CL7 7
#define OCR5CL7_BIT 7
#define OCR5CL7_MASK 128

sfrw OCR5CW = 0x12c;

sfrb OCR5BH = 0x12b;
#define OCR5BH0 0
#define OCR5BH0_BIT 0
#define OCR5BH0_MASK 1
#define OCR5BH1 1
#define OCR5BH1_BIT 1
#define OCR5BH1_MASK 2
#define OCR5BH2 2
#define OCR5BH2_BIT 2
#define OCR5BH2_MASK 4
#define OCR5BH3 3
#define OCR5BH3_BIT 3
#define OCR5BH3_MASK 8
#define OCR5BH4 4
#define OCR5BH4_BIT 4
#define OCR5BH4_MASK 16
#define OCR5BH5 5
#define OCR5BH5_BIT 5
#define OCR5BH5_MASK 32
#define OCR5BH6 6
#define OCR5BH6_BIT 6
#define OCR5BH6_MASK 64
#define OCR5BH7 7
#define OCR5BH7_BIT 7
#define OCR5BH7_MASK 128

sfrb OCR5BL = 0x12a;
#define OCR5BL0 0
#define OCR5BL0_BIT 0
#define OCR5BL0_MASK 1
#define OCR5BL1 1
#define OCR5BL1_BIT 1
#define OCR5BL1_MASK 2
#define OCR5BL2 2
#define OCR5BL2_BIT 2
#define OCR5BL2_MASK 4
#define OCR5BL3 3
#define OCR5BL3_BIT 3
#define OCR5BL3_MASK 8
#define OCR5BL4 4
#define OCR5BL4_BIT 4
#define OCR5BL4_MASK 16
#define OCR5BL5 5
#define OCR5BL5_BIT 5
#define OCR5BL5_MASK 32
#define OCR5BL6 6
#define OCR5BL6_BIT 6
#define OCR5BL6_MASK 64
#define OCR5BL7 7
#define OCR5BL7_BIT 7
#define OCR5BL7_MASK 128

sfrw OCR5BW = 0x12a;

sfrb OCR5AH = 0x129;
#define OCR5AH0 0
#define OCR5AH0_BIT 0
#define OCR5AH0_MASK 1
#define OCR5AH1 1
#define OCR5AH1_BIT 1
#define OCR5AH1_MASK 2
#define OCR5AH2 2
#define OCR5AH2_BIT 2
#define OCR5AH2_MASK 4
#define OCR5AH3 3
#define OCR5AH3_BIT 3
#define OCR5AH3_MASK 8
#define OCR5AH4 4
#define OCR5AH4_BIT 4
#define OCR5AH4_MASK 16
#define OCR5AH5 5
#define OCR5AH5_BIT 5
#define OCR5AH5_MASK 32
#define OCR5AH6 6
#define OCR5AH6_BIT 6
#define OCR5AH6_MASK 64
#define OCR5AH7 7
#define OCR5AH7_BIT 7
#define OCR5AH7_MASK 128

sfrb OCR5AL = 0x128;
#define OCR5AL0 0
#define OCR5AL0_BIT 0
#define OCR5AL0_MASK 1
#define OCR5AL1 1
#define OCR5AL1_BIT 1
#define OCR5AL1_MASK 2
#define OCR5AL2 2
#define OCR5AL2_BIT 2
#define OCR5AL2_MASK 4
#define OCR5AL3 3
#define OCR5AL3_BIT 3
#define OCR5AL3_MASK 8
#define OCR5AL4 4
#define OCR5AL4_BIT 4
#define OCR5AL4_MASK 16
#define OCR5AL5 5
#define OCR5AL5_BIT 5
#define OCR5AL5_MASK 32
#define OCR5AL6 6
#define OCR5AL6_BIT 6
#define OCR5AL6_MASK 64
#define OCR5AL7 7
#define OCR5AL7_BIT 7
#define OCR5AL7_MASK 128

sfrw OCR5AW = 0x128;

sfrb ICR5H = 0x127;
#define ICR5H0 0
#define ICR5H0_BIT 0
#define ICR5H0_MASK 1
#define ICR5H1 1
#define ICR5H1_BIT 1
#define ICR5H1_MASK 2
#define ICR5H2 2
#define ICR5H2_BIT 2
#define ICR5H2_MASK 4
#define ICR5H3 3
#define ICR5H3_BIT 3
#define ICR5H3_MASK 8
#define ICR5H4 4
#define ICR5H4_BIT 4
#define ICR5H4_MASK 16
#define ICR5H5 5
#define ICR5H5_BIT 5
#define ICR5H5_MASK 32
#define ICR5H6 6
#define ICR5H6_BIT 6
#define ICR5H6_MASK 64
#define ICR5H7 7
#define ICR5H7_BIT 7
#define ICR5H7_MASK 128

sfrb ICR5L = 0x126;
#define ICR5L0 0
#define ICR5L0_BIT 0
#define ICR5L0_MASK 1
#define ICR5L1 1
#define ICR5L1_BIT 1
#define ICR5L1_MASK 2
#define ICR5L2 2
#define ICR5L2_BIT 2
#define ICR5L2_MASK 4
#define ICR5L3 3
#define ICR5L3_BIT 3
#define ICR5L3_MASK 8
#define ICR5L4 4
#define ICR5L4_BIT 4
#define ICR5L4_MASK 16
#define ICR5L5 5
#define ICR5L5_BIT 5
#define ICR5L5_MASK 32
#define ICR5L6 6
#define ICR5L6_BIT 6
#define ICR5L6_MASK 64
#define ICR5L7 7
#define ICR5L7_BIT 7
#define ICR5L7_MASK 128

sfrw ICR5W = 0x126;

sfrb TCNT5H = 0x125;
#define TCNT5H0 0
#define TCNT5H0_BIT 0
#define TCNT5H0_MASK 1
#define TCNT5H1 1
#define TCNT5H1_BIT 1
#define TCNT5H1_MASK 2
#define TCNT5H2 2
#define TCNT5H2_BIT 2
#define TCNT5H2_MASK 4
#define TCNT5H3 3
#define TCNT5H3_BIT 3
#define TCNT5H3_MASK 8
#define TCNT5H4 4
#define TCNT5H4_BIT 4
#define TCNT5H4_MASK 16
#define TCNT5H5 5
#define TCNT5H5_BIT 5
#define TCNT5H5_MASK 32
#define TCNT5H6 6
#define TCNT5H6_BIT 6
#define TCNT5H6_MASK 64
#define TCNT5H7 7
#define TCNT5H7_BIT 7
#define TCNT5H7_MASK 128

sfrb TCNT5L = 0x124;
#define TCNT5L0 0
#define TCNT5L0_BIT 0
#define TCNT5L0_MASK 1
#define TCNT5L1 1
#define TCNT5L1_BIT 1
#define TCNT5L1_MASK 2
#define TCNT5L2 2
#define TCNT5L2_BIT 2
#define TCNT5L2_MASK 4
#define TCNT5L3 3
#define TCNT5L3_BIT 3
#define TCNT5L3_MASK 8
#define TCNT5L4 4
#define TCNT5L4_BIT 4
#define TCNT5L4_MASK 16
#define TCNT5L5 5
#define TCNT5L5_BIT 5
#define TCNT5L5_MASK 32
#define TCNT5L6 6
#define TCNT5L6_BIT 6
#define TCNT5L6_MASK 64
#define TCNT5L7 7
#define TCNT5L7_BIT 7
#define TCNT5L7_MASK 128

sfrw TCNT5W = 0x124;

sfrb TCCR5C = 0x122;
#define FOC5C 5
#define FOC5C_BIT 5
#define FOC5C_MASK 32
#define FOC5B 6
#define FOC5B_BIT 6
#define FOC5B_MASK 64
#define FOC5A 7
#define FOC5A_BIT 7
#define FOC5A_MASK 128

sfrb TCCR5B = 0x121;
#define CS50 0
#define CS50_BIT 0
#define CS50_MASK 1
#define CS51 1
#define CS51_BIT 1
#define CS51_MASK 2
#define CS52 2
#define CS52_BIT 2
#define CS52_MASK 4
#define WGM52 3
#define WGM52_BIT 3
#define WGM52_MASK 8
#define WGM53 4
#define WGM53_BIT 4
#define WGM53_MASK 16
#define ICES5 6
#define ICES5_BIT 6
#define ICES5_MASK 64
#define ICNC5 7
#define ICNC5_BIT 7
#define ICNC5_MASK 128

sfrb TCCR5A = 0x120;
#define WGM50 0
#define WGM50_BIT 0
#define WGM50_MASK 1
#define WGM51 1
#define WGM51_BIT 1
#define WGM51_MASK 2
#define COM5C0 2
#define COM5C0_BIT 2
#define COM5C0_MASK 4
#define COM5C1 3
#define COM5C1_BIT 3
#define COM5C1_MASK 8
#define COM5B0 4
#define COM5B0_BIT 4
#define COM5B0_MASK 16
#define COM5B1 5
#define COM5B1_BIT 5
#define COM5B1_MASK 32
#define COM5A0 6
#define COM5A0_BIT 6
#define COM5A0_MASK 64
#define COM5A1 7
#define COM5A1_BIT 7
#define COM5A1_MASK 128

sfrb PORTL = 0x10b;

sfrb DDRL = 0x10a;

sfrb PINL = 0x109;

sfrb PORTK = 0x108;

sfrb DDRK = 0x107;

sfrb PINK = 0x106;

sfrb PORTJ = 0x105;

sfrb DDRJ = 0x104;

sfrb PINJ = 0x103;

sfrb PORTH = 0x102;

sfrb DDRH = 0x101;

sfrb PINH = 0x100;

sfrb UDR2 = 0xd6;

sfrb UBRR2H = 0xd5;

sfrb UBRR2L = 0xd4;

sfrw UBRR2W = 0xd4;

sfrb UCSR2C = 0xd2;

sfrb UCSR2B = 0xd1;

sfrb UCSR2A = 0xd0;

sfrb UDR1 = 0xce;
#define UDR1_0 0
#define UDR1_0_BIT 0
#define UDR1_0_MASK 1
#define UDR1_1 1
#define UDR1_1_BIT 1
#define UDR1_1_MASK 2
#define UDR1_2 2
#define UDR1_2_BIT 2
#define UDR1_2_MASK 4
#define UDR1_3 3
#define UDR1_3_BIT 3
#define UDR1_3_MASK 8
#define UDR1_4 4
#define UDR1_4_BIT 4
#define UDR1_4_MASK 16
#define UDR1_5 5
#define UDR1_5_BIT 5
#define UDR1_5_MASK 32
#define UDR1_6 6
#define UDR1_6_BIT 6
#define UDR1_6_MASK 64
#define UDR1_7 7
#define UDR1_7_BIT 7
#define UDR1_7_MASK 128

sfrb UBRR1H = 0xcd;
#define UBRR8 0
#define UBRR8_BIT 0
#define UBRR8_MASK 1
#define UBRR9 1
#define UBRR9_BIT 1
#define UBRR9_MASK 2
#define UBRR10 2
#define UBRR10_BIT 2
#define UBRR10_MASK 4
#define UBRR11 3
#define UBRR11_BIT 3
#define UBRR11_MASK 8

sfrb UBRR1L = 0xcc;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrw UBRR1W = 0xcc;

sfrb UCSR1C = 0xca;
#define UCPOL1 0
#define UCPOL1_BIT 0
#define UCPOL1_MASK 1
#define UCSZ10 1
#define UCSZ10_BIT 1
#define UCSZ10_MASK 2
#define UCSZ11 2
#define UCSZ11_BIT 2
#define UCSZ11_MASK 4
#define USBS1 3
#define USBS1_BIT 3
#define USBS1_MASK 8
#define UPM10 4
#define UPM10_BIT 4
#define UPM10_MASK 16
#define UPM11 5
#define UPM11_BIT 5
#define UPM11_MASK 32
#define UMSEL10 6
#define UMSEL10_BIT 6
#define UMSEL10_MASK 64
#define UMSEL11 7
#define UMSEL11_BIT 7
#define UMSEL11_MASK 128

sfrb UCSR1B = 0xc9;
#define TXB81 0
#define TXB81_BIT 0
#define TXB81_MASK 1
#define RXB81 1
#define RXB81_BIT 1
#define RXB81_MASK 2
#define UCSZ12 2
#define UCSZ12_BIT 2
#define UCSZ12_MASK 4
#define TXEN1 3
#define TXEN1_BIT 3
#define TXEN1_MASK 8
#define RXEN1 4
#define RXEN1_BIT 4
#define RXEN1_MASK 16
#define UDRIE1 5
#define UDRIE1_BIT 5
#define UDRIE1_MASK 32
#define TXCIE1 6
#define TXCIE1_BIT 6
#define TXCIE1_MASK 64
#define RXCIE1 7
#define RXCIE1_BIT 7
#define RXCIE1_MASK 128

sfrb UCSR1A = 0xc8;
#define MPCM1 0
#define MPCM1_BIT 0
#define MPCM1_MASK 1
#define U2X1 1
#define U2X1_BIT 1
#define U2X1_MASK 2
#define UPE1 2
#define UPE1_BIT 2
#define UPE1_MASK 4
#define DOR1 3
#define DOR1_BIT 3
#define DOR1_MASK 8
#define FE1 4
#define FE1_BIT 4
#define FE1_MASK 16
#define UDRE1 5
#define UDRE1_BIT 5
#define UDRE1_MASK 32
#define TXC1 6
#define TXC1_BIT 6
#define TXC1_MASK 64
#define RXC1 7
#define RXC1_BIT 7
#define RXC1_MASK 128

sfrb UDR0 = 0xc6;
#define UDR0_0 0
#define UDR0_0_BIT 0
#define UDR0_0_MASK 1
#define UDR0_1 1
#define UDR0_1_BIT 1
#define UDR0_1_MASK 2
#define UDR0_2 2
#define UDR0_2_BIT 2
#define UDR0_2_MASK 4
#define UDR0_3 3
#define UDR0_3_BIT 3
#define UDR0_3_MASK 8
#define UDR0_4 4
#define UDR0_4_BIT 4
#define UDR0_4_MASK 16
#define UDR0_5 5
#define UDR0_5_BIT 5
#define UDR0_5_MASK 32
#define UDR0_6 6
#define UDR0_6_BIT 6
#define UDR0_6_MASK 64
#define UDR0_7 7
#define UDR0_7_BIT 7
#define UDR0_7_MASK 128

sfrb UBRR0H = 0xc5;
#define UBRR8 0
#define UBRR8_BIT 0
#define UBRR8_MASK 1
#define UBRR9 1
#define UBRR9_BIT 1
#define UBRR9_MASK 2
#define UBRR10 2
#define UBRR10_BIT 2
#define UBRR10_MASK 4
#define UBRR11 3
#define UBRR11_BIT 3
#define UBRR11_MASK 8

sfrb UBRR0L = 0xc4;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrw UBRR0W = 0xc4;

sfrb UCSR0C = 0xc2;
#define UCPOL0 0
#define UCPOL0_BIT 0
#define UCPOL0_MASK 1
#define UCSZ00 1
#define UCSZ00_BIT 1
#define UCSZ00_MASK 2
#define UCSZ01 2
#define UCSZ01_BIT 2
#define UCSZ01_MASK 4
#define USBS0 3
#define USBS0_BIT 3
#define USBS0_MASK 8
#define UPM00 4
#define UPM00_BIT 4
#define UPM00_MASK 16
#define UPM01 5
#define UPM01_BIT 5
#define UPM01_MASK 32
#define UMSEL00 6
#define UMSEL00_BIT 6
#define UMSEL00_MASK 64
#define UMSEL01 7
#define UMSEL01_BIT 7
#define UMSEL01_MASK 128

sfrb UCSR0B = 0xc1;
#define TXB80 0
#define TXB80_BIT 0
#define TXB80_MASK 1
#define RXB80 1
#define RXB80_BIT 1
#define RXB80_MASK 2
#define UCSZ02 2
#define UCSZ02_BIT 2
#define UCSZ02_MASK 4
#define TXEN0 3
#define TXEN0_BIT 3
#define TXEN0_MASK 8
#define RXEN0 4
#define RXEN0_BIT 4
#define RXEN0_MASK 16
#define UDRIE0 5
#define UDRIE0_BIT 5
#define UDRIE0_MASK 32
#define TXCIE0 6
#define TXCIE0_BIT 6
#define TXCIE0_MASK 64
#define RXCIE0 7
#define RXCIE0_BIT 7
#define RXCIE0_MASK 128

sfrb UCSR0A = 0xc0;
#define MPCM0 0
#define MPCM0_BIT 0
#define MPCM0_MASK 1
#define U2X0 1
#define U2X0_BIT 1
#define U2X0_MASK 2
#define UPE0 2
#define UPE0_BIT 2
#define UPE0_MASK 4
#define DOR0 3
#define DOR0_BIT 3
#define DOR0_MASK 8
#define FE0 4
#define FE0_BIT 4
#define FE0_MASK 16
#define UDRE0 5
#define UDRE0_BIT 5
#define UDRE0_MASK 32
#define TXC0 6
#define TXC0_BIT 6
#define TXC0_MASK 64
#define RXC0 7
#define RXC0_BIT 7
#define RXC0_MASK 128

sfrb TWAMR = 0xbd;
#define TWAM0 1
#define TWAM0_BIT 1
#define TWAM0_MASK 2
#define TWAM1 2
#define TWAM1_BIT 2
#define TWAM1_MASK 4
#define TWAM2 3
#define TWAM2_BIT 3
#define TWAM2_MASK 8
#define TWAM3 4
#define TWAM3_BIT 4
#define TWAM3_MASK 16
#define TWAM4 5
#define TWAM4_BIT 5
#define TWAM4_MASK 32
#define TWAM5 6
#define TWAM5_BIT 6
#define TWAM5_MASK 64
#define TWAM6 7
#define TWAM6_BIT 7
#define TWAM6_MASK 128

sfrb TWCR = 0xbc;
#define TWIE 0
#define TWIE_BIT 0
#define TWIE_MASK 1
#define TWEN 2
#define TWEN_BIT 2
#define TWEN_MASK 4
#define TWWC 3
#define TWWC_BIT 3
#define TWWC_MASK 8
#define TWSTO 4
#define TWSTO_BIT 4
#define TWSTO_MASK 16
#define TWSTA 5
#define TWSTA_BIT 5
#define TWSTA_MASK 32
#define TWEA 6
#define TWEA_BIT 6
#define TWEA_MASK 64
#define TWINT 7
#define TWINT_BIT 7
#define TWINT_MASK 128

sfrb TWDR = 0xbb;
#define TWD0 0
#define TWD0_BIT 0
#define TWD0_MASK 1
#define TWD1 1
#define TWD1_BIT 1
#define TWD1_MASK 2
#define TWD2 2
#define TWD2_BIT 2
#define TWD2_MASK 4
#define TWD3 3
#define TWD3_BIT 3
#define TWD3_MASK 8
#define TWD4 4
#define TWD4_BIT 4
#define TWD4_MASK 16
#define TWD5 5
#define TWD5_BIT 5
#define TWD5_MASK 32
#define TWD6 6
#define TWD6_BIT 6
#define TWD6_MASK 64
#define TWD7 7
#define TWD7_BIT 7
#define TWD7_MASK 128

sfrb TWAR = 0xba;
#define TWGCE 0
#define TWGCE_BIT 0
#define TWGCE_MASK 1
#define TWA0 1
#define TWA0_BIT 1
#define TWA0_MASK 2
#define TWA1 2
#define TWA1_BIT 2
#define TWA1_MASK 4
#define TWA2 3
#define TWA2_BIT 3
#define TWA2_MASK 8
#define TWA3 4
#define TWA3_BIT 4
#define TWA3_MASK 16
#define TWA4 5
#define TWA4_BIT 5
#define TWA4_MASK 32
#define TWA5 6
#define TWA5_BIT 6
#define TWA5_MASK 64
#define TWA6 7
#define TWA6_BIT 7
#define TWA6_MASK 128

sfrb TWSR = 0xb9;
#define TWPS0 0
#define TWPS0_BIT 0
#define TWPS0_MASK 1
#define TWPS1 1
#define TWPS1_BIT 1
#define TWPS1_MASK 2
#define TWS3 3
#define TWS3_BIT 3
#define TWS3_MASK 8
#define TWS4 4
#define TWS4_BIT 4
#define TWS4_MASK 16
#define TWS5 5
#define TWS5_BIT 5
#define TWS5_MASK 32
#define TWS6 6
#define TWS6_BIT 6
#define TWS6_MASK 64
#define TWS7 7
#define TWS7_BIT 7
#define TWS7_MASK 128

sfrb TWBR = 0xb8;
#define TWBR0 0
#define TWBR0_BIT 0
#define TWBR0_MASK 1
#define TWBR1 1
#define TWBR1_BIT 1
#define TWBR1_MASK 2
#define TWBR2 2
#define TWBR2_BIT 2
#define TWBR2_MASK 4
#define TWBR3 3
#define TWBR3_BIT 3
#define TWBR3_MASK 8
#define TWBR4 4
#define TWBR4_BIT 4
#define TWBR4_MASK 16
#define TWBR5 5
#define TWBR5_BIT 5
#define TWBR5_MASK 32
#define TWBR6 6
#define TWBR6_BIT 6
#define TWBR6_MASK 64
#define TWBR7 7
#define TWBR7_BIT 7
#define TWBR7_MASK 128

sfrb ASSR = 0xb6;
#define TCR2BUB 0
#define TCR2BUB_BIT 0
#define TCR2BUB_MASK 1
#define TCR2AUB 1
#define TCR2AUB_BIT 1
#define TCR2AUB_MASK 2
#define OCR2BUB 2
#define OCR2BUB_BIT 2
#define OCR2BUB_MASK 4
#define OCR2AUB 3
#define OCR2AUB_BIT 3
#define OCR2AUB_MASK 8
#define TCN2UB 4
#define TCN2UB_BIT 4
#define TCN2UB_MASK 16
#define AS2 5
#define AS2_BIT 5
#define AS2_MASK 32
#define EXCLK 6
#define EXCLK_BIT 6
#define EXCLK_MASK 64

sfrb OCR2B = 0xb4;
#define OCR2_0 0
#define OCR2_0_BIT 0
#define OCR2_0_MASK 1
#define OCR2_1 1
#define OCR2_1_BIT 1
#define OCR2_1_MASK 2
#define OCR2_2 2
#define OCR2_2_BIT 2
#define OCR2_2_MASK 4
#define OCR2_3 3
#define OCR2_3_BIT 3
#define OCR2_3_MASK 8
#define OCR2_4 4
#define OCR2_4_BIT 4
#define OCR2_4_MASK 16
#define OCR2_5 5
#define OCR2_5_BIT 5
#define OCR2_5_MASK 32
#define OCR2_6 6
#define OCR2_6_BIT 6
#define OCR2_6_MASK 64
#define OCR2_7 7
#define OCR2_7_BIT 7
#define OCR2_7_MASK 128

sfrb OCR2A = 0xb3;
#define OCR2_0 0
#define OCR2_0_BIT 0
#define OCR2_0_MASK 1
#define OCR2_1 1
#define OCR2_1_BIT 1
#define OCR2_1_MASK 2
#define OCR2_2 2
#define OCR2_2_BIT 2
#define OCR2_2_MASK 4
#define OCR2_3 3
#define OCR2_3_BIT 3
#define OCR2_3_MASK 8
#define OCR2_4 4
#define OCR2_4_BIT 4
#define OCR2_4_MASK 16
#define OCR2_5 5
#define OCR2_5_BIT 5
#define OCR2_5_MASK 32
#define OCR2_6 6
#define OCR2_6_BIT 6
#define OCR2_6_MASK 64
#define OCR2_7 7
#define OCR2_7_BIT 7
#define OCR2_7_MASK 128

sfrb TCNT2 = 0xb2;
#define TCNT2_0 0
#define TCNT2_0_BIT 0
#define TCNT2_0_MASK 1
#define TCNT2_1 1
#define TCNT2_1_BIT 1
#define TCNT2_1_MASK 2
#define TCNT2_2 2
#define TCNT2_2_BIT 2
#define TCNT2_2_MASK 4
#define TCNT2_3 3
#define TCNT2_3_BIT 3
#define TCNT2_3_MASK 8
#define TCNT2_4 4
#define TCNT2_4_BIT 4
#define TCNT2_4_MASK 16
#define TCNT2_5 5
#define TCNT2_5_BIT 5
#define TCNT2_5_MASK 32
#define TCNT2_6 6
#define TCNT2_6_BIT 6
#define TCNT2_6_MASK 64
#define TCNT2_7 7
#define TCNT2_7_BIT 7
#define TCNT2_7_MASK 128

sfrb TCCR2B = 0xb1;
#define CS20 0
#define CS20_BIT 0
#define CS20_MASK 1
#define CS21 1
#define CS21_BIT 1
#define CS21_MASK 2
#define CS22 2
#define CS22_BIT 2
#define CS22_MASK 4
#define WGM22 3
#define WGM22_BIT 3
#define WGM22_MASK 8
#define FOC2B 6
#define FOC2B_BIT 6
#define FOC2B_MASK 64
#define FOC2A 7
#define FOC2A_BIT 7
#define FOC2A_MASK 128

sfrb TCCR2A = 0xb0;
#define WGM20 0
#define WGM20_BIT 0
#define WGM20_MASK 1
#define WGM21 1
#define WGM21_BIT 1
#define WGM21_MASK 2
#define COM2B0 4
#define COM2B0_BIT 4
#define COM2B0_MASK 16
#define COM2B1 5
#define COM2B1_BIT 5
#define COM2B1_MASK 32
#define COM2A0 6
#define COM2A0_BIT 6
#define COM2A0_MASK 64
#define COM2A1 7
#define COM2A1_BIT 7
#define COM2A1_MASK 128

sfrb OCR4CH = 0xad;
#define OCR4CH0 0
#define OCR4CH0_BIT 0
#define OCR4CH0_MASK 1
#define OCR4CH1 1
#define OCR4CH1_BIT 1
#define OCR4CH1_MASK 2
#define OCR4CH2 2
#define OCR4CH2_BIT 2
#define OCR4CH2_MASK 4
#define OCR4CH3 3
#define OCR4CH3_BIT 3
#define OCR4CH3_MASK 8
#define OCR4CH4 4
#define OCR4CH4_BIT 4
#define OCR4CH4_MASK 16
#define OCR4CH5 5
#define OCR4CH5_BIT 5
#define OCR4CH5_MASK 32
#define OCR4CH6 6
#define OCR4CH6_BIT 6
#define OCR4CH6_MASK 64
#define OCR4CH7 7
#define OCR4CH7_BIT 7
#define OCR4CH7_MASK 128

sfrb OCR4CL = 0xac;
#define OCR4CL0 0
#define OCR4CL0_BIT 0
#define OCR4CL0_MASK 1
#define OCR4CL1 1
#define OCR4CL1_BIT 1
#define OCR4CL1_MASK 2
#define OCR4CL2 2
#define OCR4CL2_BIT 2
#define OCR4CL2_MASK 4
#define OCR4CL3 3
#define OCR4CL3_BIT 3
#define OCR4CL3_MASK 8
#define OCR4CL4 4
#define OCR4CL4_BIT 4
#define OCR4CL4_MASK 16
#define OCR4CL5 5
#define OCR4CL5_BIT 5
#define OCR4CL5_MASK 32
#define OCR4CL6 6
#define OCR4CL6_BIT 6
#define OCR4CL6_MASK 64
#define OCR4CL7 7
#define OCR4CL7_BIT 7
#define OCR4CL7_MASK 128

sfrw OCR4CW = 0xac;

sfrb OCR4BH = 0xab;
#define OCR4BH0 0
#define OCR4BH0_BIT 0
#define OCR4BH0_MASK 1
#define OCR4BH1 1
#define OCR4BH1_BIT 1
#define OCR4BH1_MASK 2
#define OCR4BH2 2
#define OCR4BH2_BIT 2
#define OCR4BH2_MASK 4
#define OCR4BH3 3
#define OCR4BH3_BIT 3
#define OCR4BH3_MASK 8
#define OCR4BH4 4
#define OCR4BH4_BIT 4
#define OCR4BH4_MASK 16
#define OCR4BH5 5
#define OCR4BH5_BIT 5
#define OCR4BH5_MASK 32
#define OCR4BH6 6
#define OCR4BH6_BIT 6
#define OCR4BH6_MASK 64
#define OCR4BH7 7
#define OCR4BH7_BIT 7
#define OCR4BH7_MASK 128

sfrb OCR4BL = 0xaa;
#define OCR4BL0 0
#define OCR4BL0_BIT 0
#define OCR4BL0_MASK 1
#define OCR4BL1 1
#define OCR4BL1_BIT 1
#define OCR4BL1_MASK 2
#define OCR4BL2 2
#define OCR4BL2_BIT 2
#define OCR4BL2_MASK 4
#define OCR4BL3 3
#define OCR4BL3_BIT 3
#define OCR4BL3_MASK 8
#define OCR4BL4 4
#define OCR4BL4_BIT 4
#define OCR4BL4_MASK 16
#define OCR4BL5 5
#define OCR4BL5_BIT 5
#define OCR4BL5_MASK 32
#define OCR4BL6 6
#define OCR4BL6_BIT 6
#define OCR4BL6_MASK 64
#define OCR4BL7 7
#define OCR4BL7_BIT 7
#define OCR4BL7_MASK 128

sfrw OCR4BW = 0xaa;

sfrb OCR4AH = 0xa9;
#define OCR4AH0 0
#define OCR4AH0_BIT 0
#define OCR4AH0_MASK 1
#define OCR4AH1 1
#define OCR4AH1_BIT 1
#define OCR4AH1_MASK 2
#define OCR4AH2 2
#define OCR4AH2_BIT 2
#define OCR4AH2_MASK 4
#define OCR4AH3 3
#define OCR4AH3_BIT 3
#define OCR4AH3_MASK 8
#define OCR4AH4 4
#define OCR4AH4_BIT 4
#define OCR4AH4_MASK 16
#define OCR4AH5 5
#define OCR4AH5_BIT 5
#define OCR4AH5_MASK 32
#define OCR4AH6 6
#define OCR4AH6_BIT 6
#define OCR4AH6_MASK 64
#define OCR4AH7 7
#define OCR4AH7_BIT 7
#define OCR4AH7_MASK 128

sfrb OCR4AL = 0xa8;
#define OCR4AL0 0
#define OCR4AL0_BIT 0
#define OCR4AL0_MASK 1
#define OCR4AL1 1
#define OCR4AL1_BIT 1
#define OCR4AL1_MASK 2
#define OCR4AL2 2
#define OCR4AL2_BIT 2
#define OCR4AL2_MASK 4
#define OCR4AL3 3
#define OCR4AL3_BIT 3
#define OCR4AL3_MASK 8
#define OCR4AL4 4
#define OCR4AL4_BIT 4
#define OCR4AL4_MASK 16
#define OCR4AL5 5
#define OCR4AL5_BIT 5
#define OCR4AL5_MASK 32
#define OCR4AL6 6
#define OCR4AL6_BIT 6
#define OCR4AL6_MASK 64
#define OCR4AL7 7
#define OCR4AL7_BIT 7
#define OCR4AL7_MASK 128

sfrw OCR4AW = 0xa8;

sfrb ICR4H = 0xa7;
#define ICR4H0 0
#define ICR4H0_BIT 0
#define ICR4H0_MASK 1
#define ICR4H1 1
#define ICR4H1_BIT 1
#define ICR4H1_MASK 2
#define ICR4H2 2
#define ICR4H2_BIT 2
#define ICR4H2_MASK 4
#define ICR4H3 3
#define ICR4H3_BIT 3
#define ICR4H3_MASK 8
#define ICR4H4 4
#define ICR4H4_BIT 4
#define ICR4H4_MASK 16
#define ICR4H5 5
#define ICR4H5_BIT 5
#define ICR4H5_MASK 32
#define ICR4H6 6
#define ICR4H6_BIT 6
#define ICR4H6_MASK 64
#define ICR4H7 7
#define ICR4H7_BIT 7
#define ICR4H7_MASK 128

sfrb ICR4L = 0xa6;
#define ICR4L0 0
#define ICR4L0_BIT 0
#define ICR4L0_MASK 1
#define ICR4L1 1
#define ICR4L1_BIT 1
#define ICR4L1_MASK 2
#define ICR4L2 2
#define ICR4L2_BIT 2
#define ICR4L2_MASK 4
#define ICR4L3 3
#define ICR4L3_BIT 3
#define ICR4L3_MASK 8
#define ICR4L4 4
#define ICR4L4_BIT 4
#define ICR4L4_MASK 16
#define ICR4L5 5
#define ICR4L5_BIT 5
#define ICR4L5_MASK 32
#define ICR4L6 6
#define ICR4L6_BIT 6
#define ICR4L6_MASK 64
#define ICR4L7 7
#define ICR4L7_BIT 7
#define ICR4L7_MASK 128

sfrw ICR4W = 0xa6;

sfrb TCNT4H = 0xa5;
#define TCNT4H0 0
#define TCNT4H0_BIT 0
#define TCNT4H0_MASK 1
#define TCNT4H1 1
#define TCNT4H1_BIT 1
#define TCNT4H1_MASK 2
#define TCNT4H2 2
#define TCNT4H2_BIT 2
#define TCNT4H2_MASK 4
#define TCNT4H3 3
#define TCNT4H3_BIT 3
#define TCNT4H3_MASK 8
#define TCNT4H4 4
#define TCNT4H4_BIT 4
#define TCNT4H4_MASK 16
#define TCNT4H5 5
#define TCNT4H5_BIT 5
#define TCNT4H5_MASK 32
#define TCNT4H6 6
#define TCNT4H6_BIT 6
#define TCNT4H6_MASK 64
#define TCNT4H7 7
#define TCNT4H7_BIT 7
#define TCNT4H7_MASK 128

sfrb TCNT4L = 0xa4;
#define TCNT4L0 0
#define TCNT4L0_BIT 0
#define TCNT4L0_MASK 1
#define TCNT4L1 1
#define TCNT4L1_BIT 1
#define TCNT4L1_MASK 2
#define TCNT4L2 2
#define TCNT4L2_BIT 2
#define TCNT4L2_MASK 4
#define TCNT4L3 3
#define TCNT4L3_BIT 3
#define TCNT4L3_MASK 8
#define TCNT4L4 4
#define TCNT4L4_BIT 4
#define TCNT4L4_MASK 16
#define TCNT4L5 5
#define TCNT4L5_BIT 5
#define TCNT4L5_MASK 32
#define TCNT4L6 6
#define TCNT4L6_BIT 6
#define TCNT4L6_MASK 64
#define TCNT4L7 7
#define TCNT4L7_BIT 7
#define TCNT4L7_MASK 128

sfrw TCNT4W = 0xa4;

sfrb TCCR4C = 0xa2;
#define FOC4C 5
#define FOC4C_BIT 5
#define FOC4C_MASK 32
#define FOC4B 6
#define FOC4B_BIT 6
#define FOC4B_MASK 64
#define FOC4A 7
#define FOC4A_BIT 7
#define FOC4A_MASK 128

sfrb TCCR4B = 0xa1;
#define CS40 0
#define CS40_BIT 0
#define CS40_MASK 1
#define CS41 1
#define CS41_BIT 1
#define CS41_MASK 2
#define CS42 2
#define CS42_BIT 2
#define CS42_MASK 4
#define WGM42 3
#define WGM42_BIT 3
#define WGM42_MASK 8
#define WGM43 4
#define WGM43_BIT 4
#define WGM43_MASK 16
#define ICES4 6
#define ICES4_BIT 6
#define ICES4_MASK 64
#define ICNC4 7
#define ICNC4_BIT 7
#define ICNC4_MASK 128

sfrb TCCR4A = 0xa0;
#define WGM40 0
#define WGM40_BIT 0
#define WGM40_MASK 1
#define WGM41 1
#define WGM41_BIT 1
#define WGM41_MASK 2
#define COM4C0 2
#define COM4C0_BIT 2
#define COM4C0_MASK 4
#define COM4C1 3
#define COM4C1_BIT 3
#define COM4C1_MASK 8
#define COM4B0 4
#define COM4B0_BIT 4
#define COM4B0_MASK 16
#define COM4B1 5
#define COM4B1_BIT 5
#define COM4B1_MASK 32
#define COM4A0 6
#define COM4A0_BIT 6
#define COM4A0_MASK 64
#define COM4A1 7
#define COM4A1_BIT 7
#define COM4A1_MASK 128

sfrb OCR3CH = 0x9d;
#define OCR3CH0 0
#define OCR3CH0_BIT 0
#define OCR3CH0_MASK 1
#define OCR3CH1 1
#define OCR3CH1_BIT 1
#define OCR3CH1_MASK 2
#define OCR3CH2 2
#define OCR3CH2_BIT 2
#define OCR3CH2_MASK 4
#define OCR3CH3 3
#define OCR3CH3_BIT 3
#define OCR3CH3_MASK 8
#define OCR3CH4 4
#define OCR3CH4_BIT 4
#define OCR3CH4_MASK 16
#define OCR3CH5 5
#define OCR3CH5_BIT 5
#define OCR3CH5_MASK 32
#define OCR3CH6 6
#define OCR3CH6_BIT 6
#define OCR3CH6_MASK 64
#define OCR3CH7 7
#define OCR3CH7_BIT 7
#define OCR3CH7_MASK 128

sfrb OCR3CL = 0x9c;
#define OCR3CL0 0
#define OCR3CL0_BIT 0
#define OCR3CL0_MASK 1
#define OCR3CL1 1
#define OCR3CL1_BIT 1
#define OCR3CL1_MASK 2
#define OCR3CL2 2
#define OCR3CL2_BIT 2
#define OCR3CL2_MASK 4
#define OCR3CL3 3
#define OCR3CL3_BIT 3
#define OCR3CL3_MASK 8
#define OCR3CL4 4
#define OCR3CL4_BIT 4
#define OCR3CL4_MASK 16
#define OCR3CL5 5
#define OCR3CL5_BIT 5
#define OCR3CL5_MASK 32
#define OCR3CL6 6
#define OCR3CL6_BIT 6
#define OCR3CL6_MASK 64
#define OCR3CL7 7
#define OCR3CL7_BIT 7
#define OCR3CL7_MASK 128

sfrw OCR3CW = 0x9c;

sfrb OCR3BH = 0x9b;
#define OCR3BH0 0
#define OCR3BH0_BIT 0
#define OCR3BH0_MASK 1
#define OCR3BH1 1
#define OCR3BH1_BIT 1
#define OCR3BH1_MASK 2
#define OCR3BH2 2
#define OCR3BH2_BIT 2
#define OCR3BH2_MASK 4
#define OCR3BH3 3
#define OCR3BH3_BIT 3
#define OCR3BH3_MASK 8
#define OCR3BH4 4
#define OCR3BH4_BIT 4
#define OCR3BH4_MASK 16
#define OCR3BH5 5
#define OCR3BH5_BIT 5
#define OCR3BH5_MASK 32
#define OCR3BH6 6
#define OCR3BH6_BIT 6
#define OCR3BH6_MASK 64
#define OCR3BH7 7
#define OCR3BH7_BIT 7
#define OCR3BH7_MASK 128

sfrb OCR3BL = 0x9a;
#define OCR3BL0 0
#define OCR3BL0_BIT 0
#define OCR3BL0_MASK 1
#define OCR3BL1 1
#define OCR3BL1_BIT 1
#define OCR3BL1_MASK 2
#define OCR3BL2 2
#define OCR3BL2_BIT 2
#define OCR3BL2_MASK 4
#define OCR3BL3 3
#define OCR3BL3_BIT 3
#define OCR3BL3_MASK 8
#define OCR3BL4 4
#define OCR3BL4_BIT 4
#define OCR3BL4_MASK 16
#define OCR3BL5 5
#define OCR3BL5_BIT 5
#define OCR3BL5_MASK 32
#define OCR3BL6 6
#define OCR3BL6_BIT 6
#define OCR3BL6_MASK 64
#define OCR3BL7 7
#define OCR3BL7_BIT 7
#define OCR3BL7_MASK 128

sfrw OCR3BW = 0x9a;

sfrb OCR3AH = 0x99;
#define OCR3AH0 0
#define OCR3AH0_BIT 0
#define OCR3AH0_MASK 1
#define OCR3AH1 1
#define OCR3AH1_BIT 1
#define OCR3AH1_MASK 2
#define OCR3AH2 2
#define OCR3AH2_BIT 2
#define OCR3AH2_MASK 4
#define OCR3AH3 3
#define OCR3AH3_BIT 3
#define OCR3AH3_MASK 8
#define OCR3AH4 4
#define OCR3AH4_BIT 4
#define OCR3AH4_MASK 16
#define OCR3AH5 5
#define OCR3AH5_BIT 5
#define OCR3AH5_MASK 32
#define OCR3AH6 6
#define OCR3AH6_BIT 6
#define OCR3AH6_MASK 64
#define OCR3AH7 7
#define OCR3AH7_BIT 7
#define OCR3AH7_MASK 128

sfrb OCR3AL = 0x98;
#define OCR3AL0 0
#define OCR3AL0_BIT 0
#define OCR3AL0_MASK 1
#define OCR3AL1 1
#define OCR3AL1_BIT 1
#define OCR3AL1_MASK 2
#define OCR3AL2 2
#define OCR3AL2_BIT 2
#define OCR3AL2_MASK 4
#define OCR3AL3 3
#define OCR3AL3_BIT 3
#define OCR3AL3_MASK 8
#define OCR3AL4 4
#define OCR3AL4_BIT 4
#define OCR3AL4_MASK 16
#define OCR3AL5 5
#define OCR3AL5_BIT 5
#define OCR3AL5_MASK 32
#define OCR3AL6 6
#define OCR3AL6_BIT 6
#define OCR3AL6_MASK 64
#define OCR3AL7 7
#define OCR3AL7_BIT 7
#define OCR3AL7_MASK 128

sfrw OCR3AW = 0x98;

sfrb ICR3H = 0x97;
#define ICR3H0 0
#define ICR3H0_BIT 0
#define ICR3H0_MASK 1
#define ICR3H1 1
#define ICR3H1_BIT 1
#define ICR3H1_MASK 2
#define ICR3H2 2
#define ICR3H2_BIT 2
#define ICR3H2_MASK 4
#define ICR3H3 3
#define ICR3H3_BIT 3
#define ICR3H3_MASK 8
#define ICR3H4 4
#define ICR3H4_BIT 4
#define ICR3H4_MASK 16
#define ICR3H5 5
#define ICR3H5_BIT 5
#define ICR3H5_MASK 32
#define ICR3H6 6
#define ICR3H6_BIT 6
#define ICR3H6_MASK 64
#define ICR3H7 7
#define ICR3H7_BIT 7
#define ICR3H7_MASK 128

sfrb ICR3L = 0x96;
#define ICR3L0 0
#define ICR3L0_BIT 0
#define ICR3L0_MASK 1
#define ICR3L1 1
#define ICR3L1_BIT 1
#define ICR3L1_MASK 2
#define ICR3L2 2
#define ICR3L2_BIT 2
#define ICR3L2_MASK 4
#define ICR3L3 3
#define ICR3L3_BIT 3
#define ICR3L3_MASK 8
#define ICR3L4 4
#define ICR3L4_BIT 4
#define ICR3L4_MASK 16
#define ICR3L5 5
#define ICR3L5_BIT 5
#define ICR3L5_MASK 32
#define ICR3L6 6
#define ICR3L6_BIT 6
#define ICR3L6_MASK 64
#define ICR3L7 7
#define ICR3L7_BIT 7
#define ICR3L7_MASK 128

sfrw ICR3W = 0x96;

sfrb TCNT3H = 0x95;
#define TCNT3H0 0
#define TCNT3H0_BIT 0
#define TCNT3H0_MASK 1
#define TCNT3H1 1
#define TCNT3H1_BIT 1
#define TCNT3H1_MASK 2
#define TCNT3H2 2
#define TCNT3H2_BIT 2
#define TCNT3H2_MASK 4
#define TCNT3H3 3
#define TCNT3H3_BIT 3
#define TCNT3H3_MASK 8
#define TCNT3H4 4
#define TCNT3H4_BIT 4
#define TCNT3H4_MASK 16
#define TCNT3H5 5
#define TCNT3H5_BIT 5
#define TCNT3H5_MASK 32
#define TCNT3H6 6
#define TCNT3H6_BIT 6
#define TCNT3H6_MASK 64
#define TCNT3H7 7
#define TCNT3H7_BIT 7
#define TCNT3H7_MASK 128

sfrb TCNT3L = 0x94;
#define TCNT3L0 0
#define TCNT3L0_BIT 0
#define TCNT3L0_MASK 1
#define TCNT3L1 1
#define TCNT3L1_BIT 1
#define TCNT3L1_MASK 2
#define TCNT3L2 2
#define TCNT3L2_BIT 2
#define TCNT3L2_MASK 4
#define TCNT3L3 3
#define TCNT3L3_BIT 3
#define TCNT3L3_MASK 8
#define TCNT3L4 4
#define TCNT3L4_BIT 4
#define TCNT3L4_MASK 16
#define TCNT3L5 5
#define TCNT3L5_BIT 5
#define TCNT3L5_MASK 32
#define TCNT3L6 6
#define TCNT3L6_BIT 6
#define TCNT3L6_MASK 64
#define TCNT3L7 7
#define TCNT3L7_BIT 7
#define TCNT3L7_MASK 128

sfrw TCNT3W = 0x94;

sfrb TCCR3C = 0x92;
#define FOC3C 5
#define FOC3C_BIT 5
#define FOC3C_MASK 32
#define FOC3B 6
#define FOC3B_BIT 6
#define FOC3B_MASK 64
#define FOC3A 7
#define FOC3A_BIT 7
#define FOC3A_MASK 128

sfrb TCCR3B = 0x91;
#define CS30 0
#define CS30_BIT 0
#define CS30_MASK 1
#define CS31 1
#define CS31_BIT 1
#define CS31_MASK 2
#define CS32 2
#define CS32_BIT 2
#define CS32_MASK 4
#define WGM32 3
#define WGM32_BIT 3
#define WGM32_MASK 8
#define WGM33 4
#define WGM33_BIT 4
#define WGM33_MASK 16
#define ICES3 6
#define ICES3_BIT 6
#define ICES3_MASK 64
#define ICNC3 7
#define ICNC3_BIT 7
#define ICNC3_MASK 128

sfrb TCCR3A = 0x90;
#define WGM30 0
#define WGM30_BIT 0
#define WGM30_MASK 1
#define WGM31 1
#define WGM31_BIT 1
#define WGM31_MASK 2
#define COM3C0 2
#define COM3C0_BIT 2
#define COM3C0_MASK 4
#define COM3C1 3
#define COM3C1_BIT 3
#define COM3C1_MASK 8
#define COM3B0 4
#define COM3B0_BIT 4
#define COM3B0_MASK 16
#define COM3B1 5
#define COM3B1_BIT 5
#define COM3B1_MASK 32
#define COM3A0 6
#define COM3A0_BIT 6
#define COM3A0_MASK 64
#define COM3A1 7
#define COM3A1_BIT 7
#define COM3A1_MASK 128

sfrb OCR1CH = 0x8d;
#define OCR1CH0 0
#define OCR1CH0_BIT 0
#define OCR1CH0_MASK 1
#define OCR1CH1 1
#define OCR1CH1_BIT 1
#define OCR1CH1_MASK 2
#define OCR1CH2 2
#define OCR1CH2_BIT 2
#define OCR1CH2_MASK 4
#define OCR1CH3 3
#define OCR1CH3_BIT 3
#define OCR1CH3_MASK 8
#define OCR1CH4 4
#define OCR1CH4_BIT 4
#define OCR1CH4_MASK 16
#define OCR1CH5 5
#define OCR1CH5_BIT 5
#define OCR1CH5_MASK 32
#define OCR1CH6 6
#define OCR1CH6_BIT 6
#define OCR1CH6_MASK 64
#define OCR1CH7 7
#define OCR1CH7_BIT 7
#define OCR1CH7_MASK 128

sfrb OCR1CL = 0x8c;
#define OCR1CL0 0
#define OCR1CL0_BIT 0
#define OCR1CL0_MASK 1
#define OCR1CL1 1
#define OCR1CL1_BIT 1
#define OCR1CL1_MASK 2
#define OCR1CL2 2
#define OCR1CL2_BIT 2
#define OCR1CL2_MASK 4
#define OCR1CL3 3
#define OCR1CL3_BIT 3
#define OCR1CL3_MASK 8
#define OCR1CL4 4
#define OCR1CL4_BIT 4
#define OCR1CL4_MASK 16
#define OCR1CL5 5
#define OCR1CL5_BIT 5
#define OCR1CL5_MASK 32
#define OCR1CL6 6
#define OCR1CL6_BIT 6
#define OCR1CL6_MASK 64
#define OCR1CL7 7
#define OCR1CL7_BIT 7
#define OCR1CL7_MASK 128

sfrw OCR1CW = 0x8c;

sfrb OCR1BH = 0x8b;
#define OCR1BH0 0
#define OCR1BH0_BIT 0
#define OCR1BH0_MASK 1
#define OCR1BH1 1
#define OCR1BH1_BIT 1
#define OCR1BH1_MASK 2
#define OCR1BH2 2
#define OCR1BH2_BIT 2
#define OCR1BH2_MASK 4
#define OCR1BH3 3
#define OCR1BH3_BIT 3
#define OCR1BH3_MASK 8
#define OCR1BH4 4
#define OCR1BH4_BIT 4
#define OCR1BH4_MASK 16
#define OCR1BH5 5
#define OCR1BH5_BIT 5
#define OCR1BH5_MASK 32
#define OCR1BH6 6
#define OCR1BH6_BIT 6
#define OCR1BH6_MASK 64
#define OCR1BH7 7
#define OCR1BH7_BIT 7
#define OCR1BH7_MASK 128

sfrb OCR1BL = 0x8a;
#define OCR1BL0 0
#define OCR1BL0_BIT 0
#define OCR1BL0_MASK 1
#define OCR1BL1 1
#define OCR1BL1_BIT 1
#define OCR1BL1_MASK 2
#define OCR1BL2 2
#define OCR1BL2_BIT 2
#define OCR1BL2_MASK 4
#define OCR1BL3 3
#define OCR1BL3_BIT 3
#define OCR1BL3_MASK 8
#define OCR1BL4 4
#define OCR1BL4_BIT 4
#define OCR1BL4_MASK 16
#define OCR1BL5 5
#define OCR1BL5_BIT 5
#define OCR1BL5_MASK 32
#define OCR1BL6 6
#define OCR1BL6_BIT 6
#define OCR1BL6_MASK 64
#define OCR1BL7 7
#define OCR1BL7_BIT 7
#define OCR1BL7_MASK 128

sfrw OCR1BW = 0x8a;

sfrb OCR1AH = 0x89;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x88;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x88;

sfrb ICR1H = 0x87;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x86;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x86;

sfrb TCNT1H = 0x85;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x84;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x84;

sfrb TCCR1C = 0x82;
#define FOC1C 5
#define FOC1C_BIT 5
#define FOC1C_MASK 32
#define FOC1B 6
#define FOC1B_BIT 6
#define FOC1B_MASK 64
#define FOC1A 7
#define FOC1A_BIT 7
#define FOC1A_MASK 128

sfrb TCCR1B = 0x81;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define WGM12 3
#define WGM12_BIT 3
#define WGM12_MASK 8
#define WGM13 4
#define WGM13_BIT 4
#define WGM13_MASK 16
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCCR1A = 0x80;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define COM1C0 2
#define COM1C0_BIT 2
#define COM1C0_MASK 4
#define COM1C1 3
#define COM1C1_BIT 3
#define COM1C1_MASK 8
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb DIDR1 = 0x7f;
#define AIN0D 0
#define AIN0D_BIT 0
#define AIN0D_MASK 1
#define AIN1D 1
#define AIN1D_BIT 1
#define AIN1D_MASK 2

sfrb DIDR0 = 0x7e;
#define ADC0D 0
#define ADC0D_BIT 0
#define ADC0D_MASK 1
#define ADC1D 1
#define ADC1D_BIT 1
#define ADC1D_MASK 2
#define ADC2D 2
#define ADC2D_BIT 2
#define ADC2D_MASK 4
#define ADC3D 3
#define ADC3D_BIT 3
#define ADC3D_MASK 8
#define ADC4D 4
#define ADC4D_BIT 4
#define ADC4D_MASK 16
#define ADC5D 5
#define ADC5D_BIT 5
#define ADC5D_MASK 32
#define ADC6D 6
#define ADC6D_BIT 6
#define ADC6D_MASK 64
#define ADC7D 7
#define ADC7D_BIT 7
#define ADC7D_MASK 128

sfrb DIDR2 = 0x7d;
#define ADC8D 0
#define ADC8D_BIT 0
#define ADC8D_MASK 1
#define ADC9D 1
#define ADC9D_BIT 1
#define ADC9D_MASK 2
#define ADC10D 2
#define ADC10D_BIT 2
#define ADC10D_MASK 4
#define ADC11D 3
#define ADC11D_BIT 3
#define ADC11D_MASK 8
#define ADC12D 4
#define ADC12D_BIT 4
#define ADC12D_MASK 16
#define ADC13D 5
#define ADC13D_BIT 5
#define ADC13D_MASK 32
#define ADC14D 6
#define ADC14D_BIT 6
#define ADC14D_MASK 64
#define ADC15D 7
#define ADC15D_BIT 7
#define ADC15D_MASK 128

sfrb ADMUX = 0x7c;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define MUX2 2
#define MUX2_BIT 2
#define MUX2_MASK 4
#define MUX3 3
#define MUX3_BIT 3
#define MUX3_MASK 8
#define MUX4 4
#define MUX4_BIT 4
#define MUX4_MASK 16
#define ADLAR 5
#define ADLAR_BIT 5
#define ADLAR_MASK 32
#define REFS0 6
#define REFS0_BIT 6
#define REFS0_MASK 64
#define REFS1 7
#define REFS1_BIT 7
#define REFS1_MASK 128

sfrb ADCSRB = 0x7b;
#define ADTS0 0
#define ADTS0_BIT 0
#define ADTS0_MASK 1
#define ADTS1 1
#define ADTS1_BIT 1
#define ADTS1_MASK 2
#define ADTS2 2
#define ADTS2_BIT 2
#define ADTS2_MASK 4
#define MUX5 3
#define MUX5_BIT 3
#define MUX5_MASK 8
#define ACME 6
#define ACME_BIT 6
#define ACME_MASK 64

sfrb ADCSRA = 0x7a;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADATE 5
#define ADATE_BIT 5
#define ADATE_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x79;
#define ADCH0 0
#define ADCH0_BIT 0
#define ADCH0_MASK 1
#define ADCH1 1
#define ADCH1_BIT 1
#define ADCH1_MASK 2
#define ADCH2 2
#define ADCH2_BIT 2
#define ADCH2_MASK 4
#define ADCH3 3
#define ADCH3_BIT 3
#define ADCH3_MASK 8
#define ADCH4 4
#define ADCH4_BIT 4
#define ADCH4_MASK 16
#define ADCH5 5
#define ADCH5_BIT 5
#define ADCH5_MASK 32
#define ADCH6 6
#define ADCH6_BIT 6
#define ADCH6_MASK 64
#define ADCH7 7
#define ADCH7_BIT 7
#define ADCH7_MASK 128

sfrb ADCL = 0x78;
#define ADCL0 0
#define ADCL0_BIT 0
#define ADCL0_MASK 1
#define ADCL1 1
#define ADCL1_BIT 1
#define ADCL1_MASK 2
#define ADCL2 2
#define ADCL2_BIT 2
#define ADCL2_MASK 4
#define ADCL3 3
#define ADCL3_BIT 3
#define ADCL3_MASK 8
#define ADCL4 4
#define ADCL4_BIT 4
#define ADCL4_MASK 16
#define ADCL5 5
#define ADCL5_BIT 5
#define ADCL5_MASK 32
#define ADCL6 6
#define ADCL6_BIT 6
#define ADCL6_MASK 64
#define ADCL7 7
#define ADCL7_BIT 7
#define ADCL7_MASK 128

sfrw ADCW = 0x78;

sfrb XMCRB = 0x75;
#define XMM0 0
#define XMM0_BIT 0
#define XMM0_MASK 1
#define XMM1 1
#define XMM1_BIT 1
#define XMM1_MASK 2
#define XMM2 2
#define XMM2_BIT 2
#define XMM2_MASK 4
#define XMBK 7
#define XMBK_BIT 7
#define XMBK_MASK 128

sfrb XMCRA = 0x74;
#define SRW00 0
#define SRW00_BIT 0
#define SRW00_MASK 1
#define SRW01 1
#define SRW01_BIT 1
#define SRW01_MASK 2
#define SRW10 2
#define SRW10_BIT 2
#define SRW10_MASK 4
#define SRW11 3
#define SRW11_BIT 3
#define SRW11_MASK 8
#define SRL0 4
#define SRL0_BIT 4
#define SRL0_MASK 16
#define SRL1 5
#define SRL1_BIT 5
#define SRL1_MASK 32
#define SRL2 6
#define SRL2_BIT 6
#define SRL2_MASK 64
#define SRE 7
#define SRE_BIT 7
#define SRE_MASK 128

sfrb TIMSK5 = 0x73;
#define TOIE5 0
#define TOIE5_BIT 0
#define TOIE5_MASK 1
#define OCIE5A 1
#define OCIE5A_BIT 1
#define OCIE5A_MASK 2
#define OCIE5B 2
#define OCIE5B_BIT 2
#define OCIE5B_MASK 4
#define OCIE5C 3
#define OCIE5C_BIT 3
#define OCIE5C_MASK 8
#define ICIE5 5
#define ICIE5_BIT 5
#define ICIE5_MASK 32

sfrb TIMSK4 = 0x72;
#define TOIE4 0
#define TOIE4_BIT 0
#define TOIE4_MASK 1
#define OCIE4A 1
#define OCIE4A_BIT 1
#define OCIE4A_MASK 2
#define OCIE4B 2
#define OCIE4B_BIT 2
#define OCIE4B_MASK 4
#define OCIE4C 3
#define OCIE4C_BIT 3
#define OCIE4C_MASK 8
#define ICIE4 5
#define ICIE4_BIT 5
#define ICIE4_MASK 32

sfrb TIMSK3 = 0x71;
#define TOIE3 0
#define TOIE3_BIT 0
#define TOIE3_MASK 1
#define OCIE3A 1
#define OCIE3A_BIT 1
#define OCIE3A_MASK 2
#define OCIE3B 2
#define OCIE3B_BIT 2
#define OCIE3B_MASK 4
#define OCIE3C 3
#define OCIE3C_BIT 3
#define OCIE3C_MASK 8
#define ICIE3 5
#define ICIE3_BIT 5
#define ICIE3_MASK 32

sfrb TIMSK2 = 0x70;
#define TOIE2 0
#define TOIE2_BIT 0
#define TOIE2_MASK 1
#define OCIE2A 1
#define OCIE2A_BIT 1
#define OCIE2A_MASK 2
#define OCIE2B 2
#define OCIE2B_BIT 2
#define OCIE2B_MASK 4

sfrb TIMSK1 = 0x6f;
#define TOIE1 0
#define TOIE1_BIT 0
#define TOIE1_MASK 1
#define OCIE1A 1
#define OCIE1A_BIT 1
#define OCIE1A_MASK 2
#define OCIE1B 2
#define OCIE1B_BIT 2
#define OCIE1B_MASK 4
#define OCIE1C 3
#define OCIE1C_BIT 3
#define OCIE1C_MASK 8
#define ICIE1 5
#define ICIE1_BIT 5
#define ICIE1_MASK 32

sfrb TIMSK0 = 0x6e;
#define TOIE0 0
#define TOIE0_BIT 0
#define TOIE0_MASK 1
#define OCIE0A 1
#define OCIE0A_BIT 1
#define OCIE0A_MASK 2
#define OCIE0B 2
#define OCIE0B_BIT 2
#define OCIE0B_MASK 4

sfrb PCMSK2 = 0x6d;
#define PCINT16 0
#define PCINT16_BIT 0
#define PCINT16_MASK 1
#define PCINT17 1
#define PCINT17_BIT 1
#define PCINT17_MASK 2
#define PCINT18 2
#define PCINT18_BIT 2
#define PCINT18_MASK 4
#define PCINT19 3
#define PCINT19_BIT 3
#define PCINT19_MASK 8
#define PCINT20 4
#define PCINT20_BIT 4
#define PCINT20_MASK 16
#define PCINT21 5
#define PCINT21_BIT 5
#define PCINT21_MASK 32
#define PCINT22 6
#define PCINT22_BIT 6
#define PCINT22_MASK 64
#define PCINT23 7
#define PCINT23_BIT 7
#define PCINT23_MASK 128

sfrb PCMSK1 = 0x6c;
#define PCINT8 0
#define PCINT8_BIT 0
#define PCINT8_MASK 1
#define PCINT9 1
#define PCINT9_BIT 1
#define PCINT9_MASK 2
#define PCINT10 2
#define PCINT10_BIT 2
#define PCINT10_MASK 4
#define PCINT11 3
#define PCINT11_BIT 3
#define PCINT11_MASK 8
#define PCINT12 4
#define PCINT12_BIT 4
#define PCINT12_MASK 16
#define PCINT13 5
#define PCINT13_BIT 5
#define PCINT13_MASK 32
#define PCINT14 6
#define PCINT14_BIT 6
#define PCINT14_MASK 64
#define PCINT15 7
#define PCINT15_BIT 7
#define PCINT15_MASK 128

sfrb PCMSK0 = 0x6b;
#define PCINT0 0
#define PCINT0_BIT 0
#define PCINT0_MASK 1
#define PCINT1 1
#define PCINT1_BIT 1
#define PCINT1_MASK 2
#define PCINT2 2
#define PCINT2_BIT 2
#define PCINT2_MASK 4
#define PCINT3 3
#define PCINT3_BIT 3
#define PCINT3_MASK 8
#define PCINT4 4
#define PCINT4_BIT 4
#define PCINT4_MASK 16
#define PCINT5 5
#define PCINT5_BIT 5
#define PCINT5_MASK 32
#define PCINT6 6
#define PCINT6_BIT 6
#define PCINT6_MASK 64
#define PCINT7 7
#define PCINT7_BIT 7
#define PCINT7_MASK 128

sfrb EICRB = 0x6a;
#define ISC40 0
#define ISC40_BIT 0
#define ISC40_MASK 1
#define ISC41 1
#define ISC41_BIT 1
#define ISC41_MASK 2
#define ISC50 2
#define ISC50_BIT 2
#define ISC50_MASK 4
#define ISC51 3
#define ISC51_BIT 3
#define ISC51_MASK 8
#define ISC60 4
#define ISC60_BIT 4
#define ISC60_MASK 16
#define ISC61 5
#define ISC61_BIT 5
#define ISC61_MASK 32
#define ISC70 6
#define ISC70_BIT 6
#define ISC70_MASK 64
#define ISC71 7
#define ISC71_BIT 7
#define ISC71_MASK 128

sfrb EICRA = 0x69;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ISC10 2
#define ISC10_BIT 2
#define ISC10_MASK 4
#define ISC11 3
#define ISC11_BIT 3
#define ISC11_MASK 8
#define ISC20 4
#define ISC20_BIT 4
#define ISC20_MASK 16
#define ISC21 5
#define ISC21_BIT 5
#define ISC21_MASK 32
#define ISC30 6
#define ISC30_BIT 6
#define ISC30_MASK 64
#define ISC31 7
#define ISC31_BIT 7
#define ISC31_MASK 128

sfrb PCICR = 0x68;
#define PCIE0 0
#define PCIE0_BIT 0
#define PCIE0_MASK 1
#define PCIE1 1
#define PCIE1_BIT 1
#define PCIE1_MASK 2
#define PCIE2 2
#define PCIE2_BIT 2
#define PCIE2_MASK 4

sfrb OSCCAL = 0x66;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64
#define CAL7 7
#define CAL7_BIT 7
#define CAL7_MASK 128

sfrb PRR1 = 0x65;
#define PRUSART1 0
#define PRUSART1_BIT 0
#define PRUSART1_MASK 1
#define PRUSART2 1
#define PRUSART2_BIT 1
#define PRUSART2_MASK 2
#define PRUSART3 2
#define PRUSART3_BIT 2
#define PRUSART3_MASK 4
#define PRTIM3 3
#define PRTIM3_BIT 3
#define PRTIM3_MASK 8
#define PRTIM4 4
#define PRTIM4_BIT 4
#define PRTIM4_MASK 16
#define PRTIM5 5
#define PRTIM5_BIT 5
#define PRTIM5_MASK 32

sfrb PRR0 = 0x64;
#define PRADC 0
#define PRADC_BIT 0
#define PRADC_MASK 1
#define PRUSART0 1
#define PRUSART0_BIT 1
#define PRUSART0_MASK 2
#define PRSPI 2
#define PRSPI_BIT 2
#define PRSPI_MASK 4
#define PRTIM1 3
#define PRTIM1_BIT 3
#define PRTIM1_MASK 8
#define PRTIM0 5
#define PRTIM0_BIT 5
#define PRTIM0_MASK 32
#define PRTIM2 6
#define PRTIM2_BIT 6
#define PRTIM2_MASK 64
#define PRTWI 7
#define PRTWI_BIT 7
#define PRTWI_MASK 128

sfrb CLKPR = 0x61;
#define CLKPS0 0
#define CLKPS0_BIT 0
#define CLKPS0_MASK 1
#define CLKPS1 1
#define CLKPS1_BIT 1
#define CLKPS1_MASK 2
#define CLKPS2 2
#define CLKPS2_BIT 2
#define CLKPS2_MASK 4
#define CLKPS3 3
#define CLKPS3_BIT 3
#define CLKPS3_MASK 8
#define CLKPCE 7
#define CLKPCE_BIT 7
#define CLKPCE_MASK 128

sfrb WDTCSR = 0x60;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16
#define WDP3 5
#define WDP3_BIT 5
#define WDP3_MASK 32
#define WDIE 6
#define WDIE_BIT 6
#define WDIE_MASK 64
#define WDIF 7
#define WDIF_BIT 7
#define WDIF_MASK 128

sfrb SREG = 0x5f;

sfrb SPH = 0x5e;
#define SP8 0
#define SP8_BIT 0
#define SP8_MASK 1
#define SP9 1
#define SP9_BIT 1
#define SP9_MASK 2
#define SP10 2
#define SP10_BIT 2
#define SP10_MASK 4
#define SP11 3
#define SP11_BIT 3
#define SP11_MASK 8
#define SP12 4
#define SP12_BIT 4
#define SP12_MASK 16
#define SP13 5
#define SP13_BIT 5
#define SP13_MASK 32
#define SP14 6
#define SP14_BIT 6
#define SP14_MASK 64
#define SP15 7
#define SP15_BIT 7
#define SP15_MASK 128

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrw SPW = 0x5d;

sfrb EIND = 0x5c;

sfrb RAMPZ = 0x5b;
#define RAMPZ0 0
#define RAMPZ0_BIT 0
#define RAMPZ0_MASK 1
#define RAMPZ1 1
#define RAMPZ1_BIT 1
#define RAMPZ1_MASK 2

sfrb SPMCSR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define BLBSET 3
#define BLBSET_BIT 3
#define BLBSET_MASK 8
#define RWWSRE 4
#define RWWSRE_BIT 4
#define RWWSRE_MASK 16
#define SIGRD 5
#define SIGRD_BIT 5
#define SIGRD_MASK 32
#define RWWSB 6
#define RWWSB_BIT 6
#define RWWSB_MASK 64
#define SPMIE 7
#define SPMIE_BIT 7
#define SPMIE_MASK 128

sfrb MCUCR = 0x55;
#define IVCE 0
#define IVCE_BIT 0
#define IVCE_MASK 1
#define IVSEL 1
#define IVSEL_BIT 1
#define IVSEL_MASK 2
#define PUD 4
#define PUD_BIT 4
#define PUD_MASK 16
#define JTD 7
#define JTD_BIT 7
#define JTD_MASK 128

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8
#define JTRF 4
#define JTRF_BIT 4
#define JTRF_MASK 16

sfrb SMCR = 0x53;
#define SE 0
#define SE_BIT 0
#define SE_MASK 1
#define SM0 1
#define SM0_BIT 1
#define SM0_MASK 2
#define SM1 2
#define SM1_BIT 2
#define SM1_MASK 4
#define SM2 3
#define SM2_BIT 3
#define SM2_MASK 8

sfrb OCDR = 0x51;
#define OCDR0 0
#define OCDR0_BIT 0
#define OCDR0_MASK 1
#define OCDR1 1
#define OCDR1_BIT 1
#define OCDR1_MASK 2
#define OCDR2 2
#define OCDR2_BIT 2
#define OCDR2_MASK 4
#define OCDR3 3
#define OCDR3_BIT 3
#define OCDR3_MASK 8
#define OCDR4 4
#define OCDR4_BIT 4
#define OCDR4_MASK 16
#define OCDR5 5
#define OCDR5_BIT 5
#define OCDR5_MASK 32
#define OCDR6 6
#define OCDR6_BIT 6
#define OCDR6_MASK 64
#define OCDR7 7
#define OCDR7_BIT 7
#define OCDR7_MASK 128

sfrb ACSR = 0x50;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIC 2
#define ACIC_BIT 2
#define ACIC_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb SPDR = 0x4e;
#define SPDR0 0
#define SPDR0_BIT 0
#define SPDR0_MASK 1
#define SPDR1 1
#define SPDR1_BIT 1
#define SPDR1_MASK 2
#define SPDR2 2
#define SPDR2_BIT 2
#define SPDR2_MASK 4
#define SPDR3 3
#define SPDR3_BIT 3
#define SPDR3_MASK 8
#define SPDR4 4
#define SPDR4_BIT 4
#define SPDR4_MASK 16
#define SPDR5 5
#define SPDR5_BIT 5
#define SPDR5_MASK 32
#define SPDR6 6
#define SPDR6_BIT 6
#define SPDR6_MASK 64
#define SPDR7 7
#define SPDR7_BIT 7
#define SPDR7_MASK 128

sfrb SPSR = 0x4d;
#define SPI2X 0
#define SPI2X_BIT 0
#define SPI2X_MASK 1
#define WCOL 6
#define WCOL_BIT 6
#define WCOL_MASK 64
#define SPIF 7
#define SPIF_BIT 7
#define SPIF_MASK 128

sfrb SPCR = 0x4c;
#define SPR0 0
#define SPR0_BIT 0
#define SPR0_MASK 1
#define SPR1 1
#define SPR1_BIT 1
#define SPR1_MASK 2
#define CPHA 2
#define CPHA_BIT 2
#define CPHA_MASK 4
#define CPOL 3
#define CPOL_BIT 3
#define CPOL_MASK 8
#define MSTR 4
#define MSTR_BIT 4
#define MSTR_MASK 16
#define DORD 5
#define DORD_BIT 5
#define DORD_MASK 32
#define SPE 6
#define SPE_BIT 6
#define SPE_MASK 64
#define SPIE 7
#define SPIE_BIT 7
#define SPIE_MASK 128

sfrb GPIOR2 = 0x4b;
#define GPIOR20 0
#define GPIOR20_BIT 0
#define GPIOR20_MASK 1
#define GPIOR21 1
#define GPIOR21_BIT 1
#define GPIOR21_MASK 2
#define GPIOR22 2
#define GPIOR22_BIT 2
#define GPIOR22_MASK 4
#define GPIOR23 3
#define GPIOR23_BIT 3
#define GPIOR23_MASK 8
#define GPIOR24 4
#define GPIOR24_BIT 4
#define GPIOR24_MASK 16
#define GPIOR25 5
#define GPIOR25_BIT 5
#define GPIOR25_MASK 32
#define GPIOR26 6
#define GPIOR26_BIT 6
#define GPIOR26_MASK 64
#define GPIOR27 7
#define GPIOR27_BIT 7
#define GPIOR27_MASK 128

sfrb GPIOR1 = 0x4a;
#define GPIOR10 0
#define GPIOR10_BIT 0
#define GPIOR10_MASK 1
#define GPIOR11 1
#define GPIOR11_BIT 1
#define GPIOR11_MASK 2
#define GPIOR12 2
#define GPIOR12_BIT 2
#define GPIOR12_MASK 4
#define GPIOR13 3
#define GPIOR13_BIT 3
#define GPIOR13_MASK 8
#define GPIOR14 4
#define GPIOR14_BIT 4
#define GPIOR14_MASK 16
#define GPIOR15 5
#define GPIOR15_BIT 5
#define GPIOR15_MASK 32
#define GPIOR16 6
#define GPIOR16_BIT 6
#define GPIOR16_MASK 64
#define GPIOR17 7
#define GPIOR17_BIT 7
#define GPIOR17_MASK 128

sfrb OCR0B = 0x48;
#define OCR0B_0 0
#define OCR0B_0_BIT 0
#define OCR0B_0_MASK 1
#define OCR0B_1 1
#define OCR0B_1_BIT 1
#define OCR0B_1_MASK 2
#define OCR0B_2 2
#define OCR0B_2_BIT 2
#define OCR0B_2_MASK 4
#define OCR0B_3 3
#define OCR0B_3_BIT 3
#define OCR0B_3_MASK 8
#define OCR0B_4 4
#define OCR0B_4_BIT 4
#define OCR0B_4_MASK 16
#define OCR0B_5 5
#define OCR0B_5_BIT 5
#define OCR0B_5_MASK 32
#define OCR0B_6 6
#define OCR0B_6_BIT 6
#define OCR0B_6_MASK 64
#define OCR0B_7 7
#define OCR0B_7_BIT 7
#define OCR0B_7_MASK 128

sfrb OCR0A = 0x47;
#define OCROA_0 0
#define OCROA_0_BIT 0
#define OCROA_0_MASK 1
#define OCROA_1 1
#define OCROA_1_BIT 1
#define OCROA_1_MASK 2
#define OCROA_2 2
#define OCROA_2_BIT 2
#define OCROA_2_MASK 4
#define OCROA_3 3
#define OCROA_3_BIT 3
#define OCROA_3_MASK 8
#define OCROA_4 4
#define OCROA_4_BIT 4
#define OCROA_4_MASK 16
#define OCROA_5 5
#define OCROA_5_BIT 5
#define OCROA_5_MASK 32
#define OCROA_6 6
#define OCROA_6_BIT 6
#define OCROA_6_MASK 64
#define OCROA_7 7
#define OCROA_7_BIT 7
#define OCROA_7_MASK 128

sfrb TCNT0 = 0x46;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb TCCR0B = 0x45;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM02 3
#define WGM02_BIT 3
#define WGM02_MASK 8
#define FOC0B 6
#define FOC0B_BIT 6
#define FOC0B_MASK 64
#define FOC0A 7
#define FOC0A_BIT 7
#define FOC0A_MASK 128

sfrb TCCR0A = 0x44;
#define WGM00 0
#define WGM00_BIT 0
#define WGM00_MASK 1
#define WGM01 1
#define WGM01_BIT 1
#define WGM01_MASK 2
#define COM0B0 4
#define COM0B0_BIT 4
#define COM0B0_MASK 16
#define COM0B1 5
#define COM0B1_BIT 5
#define COM0B1_MASK 32
#define COM0A0 6
#define COM0A0_BIT 6
#define COM0A0_MASK 64
#define COM0A1 7
#define COM0A1_BIT 7
#define COM0A1_MASK 128

sfrb GTCCR = 0x43;
#define PSRSYNC 0
#define PSRSYNC_BIT 0
#define PSRSYNC_MASK 1
#define PSRASY 1
#define PSRASY_BIT 1
#define PSRASY_MASK 2
#define TSM 7
#define TSM_BIT 7
#define TSM_MASK 128

sfrb EEARH = 0x42;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1
#define EEAR9 1
#define EEAR9_BIT 1
#define EEAR9_MASK 2
#define EEAR10 2
#define EEAR10_BIT 2
#define EEAR10_MASK 4
#define EEAR11 3
#define EEAR11_BIT 3
#define EEAR11_MASK 8

sfrb EEARL = 0x41;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64
#define EEAR7 7
#define EEAR7_BIT 7
#define EEAR7_MASK 128

sfrw EEARW = 0x41;

sfrb EEDR = 0x40;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3f;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEPE 1
#define EEPE_BIT 1
#define EEPE_MASK 2
#define EEMPE 2
#define EEMPE_BIT 2
#define EEMPE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8
#define EEPM0 4
#define EEPM0_BIT 4
#define EEPM0_MASK 16
#define EEPM1 5
#define EEPM1_BIT 5
#define EEPM1_MASK 32

sfrb GPIOR0 = 0x3e;
#define GPIOR00 0
#define GPIOR00_BIT 0
#define GPIOR00_MASK 1
#define GPIOR01 1
#define GPIOR01_BIT 1
#define GPIOR01_MASK 2
#define GPIOR02 2
#define GPIOR02_BIT 2
#define GPIOR02_MASK 4
#define GPIOR03 3
#define GPIOR03_BIT 3
#define GPIOR03_MASK 8
#define GPIOR04 4
#define GPIOR04_BIT 4
#define GPIOR04_MASK 16
#define GPIOR05 5
#define GPIOR05_BIT 5
#define GPIOR05_MASK 32
#define GPIOR06 6
#define GPIOR06_BIT 6
#define GPIOR06_MASK 64
#define GPIOR07 7
#define GPIOR07_BIT 7
#define GPIOR07_MASK 128

sfrb EIMSK = 0x3d;
#define INT0 0
#define INT0_BIT 0
#define INT0_MASK 1
#define INT1 1
#define INT1_BIT 1
#define INT1_MASK 2
#define INT2 2
#define INT2_BIT 2
#define INT2_MASK 4
#define INT3 3
#define INT3_BIT 3
#define INT3_MASK 8
#define INT4 4
#define INT4_BIT 4
#define INT4_MASK 16
#define INT5 5
#define INT5_BIT 5
#define INT5_MASK 32
#define INT6 6
#define INT6_BIT 6
#define INT6_MASK 64
#define INT7 7
#define INT7_BIT 7
#define INT7_MASK 128

sfrb EIFR = 0x3c;
#define INTF0 0
#define INTF0_BIT 0
#define INTF0_MASK 1
#define INTF1 1
#define INTF1_BIT 1
#define INTF1_MASK 2
#define INTF2 2
#define INTF2_BIT 2
#define INTF2_MASK 4
#define INTF3 3
#define INTF3_BIT 3
#define INTF3_MASK 8
#define INTF4 4
#define INTF4_BIT 4
#define INTF4_MASK 16
#define INTF5 5
#define INTF5_BIT 5
#define INTF5_MASK 32
#define INTF6 6
#define INTF6_BIT 6
#define INTF6_MASK 64
#define INTF7 7
#define INTF7_BIT 7
#define INTF7_MASK 128

sfrb PCIFR = 0x3b;
#define PCIF0 0
#define PCIF0_BIT 0
#define PCIF0_MASK 1
#define PCIF1 1
#define PCIF1_BIT 1
#define PCIF1_MASK 2
#define PCIF2 2
#define PCIF2_BIT 2
#define PCIF2_MASK 4

sfrb TIFR5 = 0x3a;
#define TOV5 0
#define TOV5_BIT 0
#define TOV5_MASK 1
#define OCF5A 1
#define OCF5A_BIT 1
#define OCF5A_MASK 2
#define OCF5B 2
#define OCF5B_BIT 2
#define OCF5B_MASK 4
#define OCF5C 3
#define OCF5C_BIT 3
#define OCF5C_MASK 8
#define ICF5 5
#define ICF5_BIT 5
#define ICF5_MASK 32

sfrb TIFR4 = 0x39;
#define TOV4 0
#define TOV4_BIT 0
#define TOV4_MASK 1
#define OCF4A 1
#define OCF4A_BIT 1
#define OCF4A_MASK 2
#define OCF4B 2
#define OCF4B_BIT 2
#define OCF4B_MASK 4
#define OCF4C 3
#define OCF4C_BIT 3
#define OCF4C_MASK 8
#define ICF4 5
#define ICF4_BIT 5
#define ICF4_MASK 32

sfrb TIFR3 = 0x38;
#define TOV3 0
#define TOV3_BIT 0
#define TOV3_MASK 1
#define OCF3A 1
#define OCF3A_BIT 1
#define OCF3A_MASK 2
#define OCF3B 2
#define OCF3B_BIT 2
#define OCF3B_MASK 4
#define OCF3C 3
#define OCF3C_BIT 3
#define OCF3C_MASK 8
#define ICF3 5
#define ICF3_BIT 5
#define ICF3_MASK 32

sfrb TIFR2 = 0x37;
#define TOV2 0
#define TOV2_BIT 0
#define TOV2_MASK 1
#define OCF2A 1
#define OCF2A_BIT 1
#define OCF2A_MASK 2
#define OCF2B 2
#define OCF2B_BIT 2
#define OCF2B_MASK 4

sfrb TIFR1 = 0x36;
#define TOV1 0
#define TOV1_BIT 0
#define TOV1_MASK 1
#define OCF1A 1
#define OCF1A_BIT 1
#define OCF1A_MASK 2
#define OCF1B 2
#define OCF1B_BIT 2
#define OCF1B_MASK 4
#define OCF1C 3
#define OCF1C_BIT 3
#define OCF1C_MASK 8
#define ICF1 5
#define ICF1_BIT 5
#define ICF1_MASK 32

sfrb TIFR0 = 0x35;
#define TOV0 0
#define TOV0_BIT 0
#define TOV0_MASK 1
#define OCF0A 1
#define OCF0A_BIT 1
#define OCF0A_MASK 2
#define OCF0B 2
#define OCF0B_BIT 2
#define OCF0B_MASK 4

sfrb PORTG = 0x34;
#define PORTG0 0
#define PORTG0_BIT 0
#define PORTG0_MASK 1
#define PORTG1 1
#define PORTG1_BIT 1
#define PORTG1_MASK 2
#define PORTG2 2
#define PORTG2_BIT 2
#define PORTG2_MASK 4
#define PORTG3 3
#define PORTG3_BIT 3
#define PORTG3_MASK 8
#define PORTG4 4
#define PORTG4_BIT 4
#define PORTG4_MASK 16
#define PORTG5 5
#define PORTG5_BIT 5
#define PORTG5_MASK 32

sfrb DDRG = 0x33;
#define DDG0 0
#define DDG0_BIT 0
#define DDG0_MASK 1
#define DDG1 1
#define DDG1_BIT 1
#define DDG1_MASK 2
#define DDG2 2
#define DDG2_BIT 2
#define DDG2_MASK 4
#define DDG3 3
#define DDG3_BIT 3
#define DDG3_MASK 8
#define DDG4 4
#define DDG4_BIT 4
#define DDG4_MASK 16
#define DDG5 5
#define DDG5_BIT 5
#define DDG5_MASK 32

sfrb PING = 0x32;
#define PING0 0
#define PING0_BIT 0
#define PING0_MASK 1
#define PING1 1
#define PING1_BIT 1
#define PING1_MASK 2
#define PING2 2
#define PING2_BIT 2
#define PING2_MASK 4
#define PING3 3
#define PING3_BIT 3
#define PING3_MASK 8
#define PING4 4
#define PING4_BIT 4
#define PING4_MASK 16
#define PING5 5
#define PING5_BIT 5
#define PING5_MASK 32

sfrb PORTF = 0x31;
#define PORTF0 0
#define PORTF0_BIT 0
#define PORTF0_MASK 1
#define PORTF1 1
#define PORTF1_BIT 1
#define PORTF1_MASK 2
#define PORTF2 2
#define PORTF2_BIT 2
#define PORTF2_MASK 4
#define PORTF3 3
#define PORTF3_BIT 3
#define PORTF3_MASK 8
#define PORTF4 4
#define PORTF4_BIT 4
#define PORTF4_MASK 16
#define PORTF5 5
#define PORTF5_BIT 5
#define PORTF5_MASK 32
#define PORTF6 6
#define PORTF6_BIT 6
#define PORTF6_MASK 64
#define PORTF7 7
#define PORTF7_BIT 7
#define PORTF7_MASK 128

sfrb DDRF = 0x30;
#define DDF0 0
#define DDF0_BIT 0
#define DDF0_MASK 1
#define DDF1 1
#define DDF1_BIT 1
#define DDF1_MASK 2
#define DDF2 2
#define DDF2_BIT 2
#define DDF2_MASK 4
#define DDF3 3
#define DDF3_BIT 3
#define DDF3_MASK 8
#define DDF4 4
#define DDF4_BIT 4
#define DDF4_MASK 16
#define DDF5 5
#define DDF5_BIT 5
#define DDF5_MASK 32
#define DDF6 6
#define DDF6_BIT 6
#define DDF6_MASK 64
#define DDF7 7
#define DDF7_BIT 7
#define DDF7_MASK 128

sfrb PINF = 0x2f;
#define PINF0 0
#define PINF0_BIT 0
#define PINF0_MASK 1
#define PINF1 1
#define PINF1_BIT 1
#define PINF1_MASK 2
#define PINF2 2
#define PINF2_BIT 2
#define PINF2_MASK 4
#define PINF3 3
#define PINF3_BIT 3
#define PINF3_MASK 8
#define PINF4 4
#define PINF4_BIT 4
#define PINF4_MASK 16
#define PINF5 5
#define PINF5_BIT 5
#define PINF5_MASK 32
#define PINF6 6
#define PINF6_BIT 6
#define PINF6_MASK 64
#define PINF7 7
#define PINF7_BIT 7
#define PINF7_MASK 128

sfrb PORTE = 0x2e;
#define PORTE0 0
#define PORTE0_BIT 0
#define PORTE0_MASK 1
#define PORTE1 1
#define PORTE1_BIT 1
#define PORTE1_MASK 2
#define PORTE2 2
#define PORTE2_BIT 2
#define PORTE2_MASK 4
#define PORTE3 3
#define PORTE3_BIT 3
#define PORTE3_MASK 8
#define PORTE4 4
#define PORTE4_BIT 4
#define PORTE4_MASK 16
#define PORTE5 5
#define PORTE5_BIT 5
#define PORTE5_MASK 32
#define PORTE6 6
#define PORTE6_BIT 6
#define PORTE6_MASK 64
#define PORTE7 7
#define PORTE7_BIT 7
#define PORTE7_MASK 128

sfrb DDRE = 0x2d;
#define DDE0 0
#define DDE0_BIT 0
#define DDE0_MASK 1
#define DDE1 1
#define DDE1_BIT 1
#define DDE1_MASK 2
#define DDE2 2
#define DDE2_BIT 2
#define DDE2_MASK 4
#define DDE3 3
#define DDE3_BIT 3
#define DDE3_MASK 8
#define DDE4 4
#define DDE4_BIT 4
#define DDE4_MASK 16
#define DDE5 5
#define DDE5_BIT 5
#define DDE5_MASK 32
#define DDE6 6
#define DDE6_BIT 6
#define DDE6_MASK 64
#define DDE7 7
#define DDE7_BIT 7
#define DDE7_MASK 128

sfrb PINE = 0x2c;
#define PINE0 0
#define PINE0_BIT 0
#define PINE0_MASK 1
#define PINE1 1
#define PINE1_BIT 1
#define PINE1_MASK 2
#define PINE2 2
#define PINE2_BIT 2
#define PINE2_MASK 4
#define PINE3 3
#define PINE3_BIT 3
#define PINE3_MASK 8
#define PINE4 4
#define PINE4_BIT 4
#define PINE4_MASK 16
#define PINE5 5
#define PINE5_BIT 5
#define PINE5_MASK 32
#define PINE6 6
#define PINE6_BIT 6
#define PINE6_MASK 64
#define PINE7 7
#define PINE7_BIT 7
#define PINE7_MASK 128

sfrb PORTD = 0x2b;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x2a;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64
#define DDD7 7
#define DDD7_BIT 7
#define DDD7_MASK 128

sfrb PIND = 0x29;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb PORTC = 0x28;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1
#define PORTC1 1
#define PORTC1_BIT 1
#define PORTC1_MASK 2
#define PORTC2 2
#define PORTC2_BIT 2
#define PORTC2_MASK 4
#define PORTC3 3
#define PORTC3_BIT 3
#define PORTC3_MASK 8
#define PORTC4 4
#define PORTC4_BIT 4
#define PORTC4_MASK 16
#define PORTC5 5
#define PORTC5_BIT 5
#define PORTC5_MASK 32
#define PORTC6 6
#define PORTC6_BIT 6
#define PORTC6_MASK 64
#define PORTC7 7
#define PORTC7_BIT 7
#define PORTC7_MASK 128

sfrb DDRC = 0x27;
#define DDC0 0
#define DDC0_BIT 0
#define DDC0_MASK 1
#define DDC1 1
#define DDC1_BIT 1
#define DDC1_MASK 2
#define DDC2 2
#define DDC2_BIT 2
#define DDC2_MASK 4
#define DDC3 3
#define DDC3_BIT 3
#define DDC3_MASK 8
#define DDC4 4
#define DDC4_BIT 4
#define DDC4_MASK 16
#define DDC5 5
#define DDC5_BIT 5
#define DDC5_MASK 32
#define DDC6 6
#define DDC6_BIT 6
#define DDC6_MASK 64
#define DDC7 7
#define DDC7_BIT 7
#define DDC7_MASK 128

sfrb PINC = 0x26;
#define PINC0 0
#define PINC0_BIT 0
#define PINC0_MASK 1
#define PINC1 1
#define PINC1_BIT 1
#define PINC1_MASK 2
#define PINC2 2
#define PINC2_BIT 2
#define PINC2_MASK 4
#define PINC3 3
#define PINC3_BIT 3
#define PINC3_MASK 8
#define PINC4 4
#define PINC4_BIT 4
#define PINC4_MASK 16
#define PINC5 5
#define PINC5_BIT 5
#define PINC5_MASK 32
#define PINC6 6
#define PINC6_BIT 6
#define PINC6_MASK 64
#define PINC7 7
#define PINC7_BIT 7
#define PINC7_MASK 128

sfrb PORTB = 0x25;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x24;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x23;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb PORTA = 0x22;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8
#define PORTA4 4
#define PORTA4_BIT 4
#define PORTA4_MASK 16
#define PORTA5 5
#define PORTA5_BIT 5
#define PORTA5_MASK 32
#define PORTA6 6
#define PORTA6_BIT 6
#define PORTA6_MASK 64
#define PORTA7 7
#define PORTA7_BIT 7
#define PORTA7_MASK 128

sfrb DDRA = 0x21;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define DDA2 2
#define DDA2_BIT 2
#define DDA2_MASK 4
#define DDA3 3
#define DDA3_BIT 3
#define DDA3_MASK 8
#define DDA4 4
#define DDA4_BIT 4
#define DDA4_MASK 16
#define DDA5 5
#define DDA5_BIT 5
#define DDA5_MASK 32
#define DDA6 6
#define DDA6_BIT 6
#define DDA6_MASK 64
#define DDA7 7
#define DDA7_BIT 7
#define DDA7_MASK 128

sfrb PINA = 0x20;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8
#define PINA4 4
#define PINA4_BIT 4
#define PINA4_MASK 16
#define PINA5 5
#define PINA5_BIT 5
#define PINA5_MASK 32
#define PINA6 6
#define PINA6_BIT 6
#define PINA6_MASK 64
#define PINA7 7
#define PINA7_BIT 7
#define PINA7_MASK 128

#endif
