#ifndef __AT90USB162_h
#define __AT90USB162_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0004
#define INT1_vect 0x0008
#define INT2_vect 0x000c
#define INT3_vect 0x0010
#define INT4_vect 0x0014
#define INT5_vect 0x0018
#define INT6_vect 0x001c
#define INT7_vect 0x0020
#define PCINT0_vect 0x0024
#define PCINT1_vect 0x0028
#define USB_GEN_vect 0x002c
#define USB_COM_vect 0x0030
#define WDT_vect 0x0034
#define TIMER1_CAPT_vect 0x0038
#define TIMER1_COMPA_vect 0x003c
#define TIMER1_COMPB_vect 0x0040
#define TIMER1_COMPC_vect 0x0044
#define TIMER1_OVF_vect 0x0048
#define TIMER0_COMPA_vect 0x004c
#define TIMER0_COMPB_vect 0x0050
#define TIMER0_OVF_vect 0x0054
#define SPI_STC_vect 0x0058
#define USART1_RX_vect 0x005c
#define USART1_UDRE_vect 0x0060
#define USART1_TX_vect 0x0064
#define ANALOG_COMP_vect 0x0068
#define EE_READY_vect 0x006c
#define SPM_READY_vect 0x0070

// I/O addresses


sfrb CKSTA = 0xd2;
#define EXTON 0
#define EXTON_BIT 0
#define EXTON_MASK 1
#define RCON 1
#define RCON_BIT 1
#define RCON_MASK 2

sfrb CKSEL1 = 0xd1;
#define EXCKSEL0 0
#define EXCKSEL0_BIT 0
#define EXCKSEL0_MASK 1
#define EXCKSEL1 1
#define EXCKSEL1_BIT 1
#define EXCKSEL1_MASK 2
#define EXCKSEL2 2
#define EXCKSEL2_BIT 2
#define EXCKSEL2_MASK 4
#define EXCKSEL3 3
#define EXCKSEL3_BIT 3
#define EXCKSEL3_MASK 8
#define RCCKSEL0 4
#define RCCKSEL0_BIT 4
#define RCCKSEL0_MASK 16
#define RCCKSEL1 5
#define RCCKSEL1_BIT 5
#define RCCKSEL1_MASK 32
#define RCCKSEL2 6
#define RCCKSEL2_BIT 6
#define RCCKSEL2_MASK 64
#define RCCKSEL3 7
#define RCCKSEL3_BIT 7
#define RCCKSEL3_MASK 128

sfrb CKSEL0 = 0xd0;
#define CLKS 0
#define CLKS_BIT 0
#define CLKS_MASK 1
#define EXTE 2
#define EXTE_BIT 2
#define EXTE_MASK 4
#define RCE 3
#define RCE_BIT 3
#define RCE_MASK 8
#define EXSUT0 4
#define EXSUT0_BIT 4
#define EXSUT0_MASK 16
#define EXSUT1 5
#define EXSUT1_BIT 5
#define EXSUT1_MASK 32
#define RCSUT0 6
#define RCSUT0_BIT 6
#define RCSUT0_MASK 64
#define RCSUT1 7
#define RCSUT1_BIT 7
#define RCSUT1_MASK 128

sfrb PLLCSR = 0x49;
#define PLOCK 0
#define PLOCK_BIT 0
#define PLOCK_MASK 1
#define PLLE 1
#define PLLE_BIT 1
#define PLLE_MASK 2
#define PLLP0 2
#define PLLP0_BIT 2
#define PLLP0_MASK 4
#define PLLP1 3
#define PLLP1_BIT 3
#define PLLP1_MASK 8
#define PLLP2 4
#define PLLP2_BIT 4
#define PLLP2_MASK 16

sfrb TESTPADSTATUS = 0xfd;

sfrb TESTPADPULL = 0xfe;

sfrb TESTPADCTRL = 0xff;

sfrb PS2CON = 0xfa;
#define PS2EN 0
#define PS2EN_BIT 0
#define PS2EN_MASK 1

sfrb UPOE = 0xfb;
#define DMI 0
#define DMI_BIT 0
#define DMI_MASK 1
#define DPI 1
#define DPI_BIT 1
#define DPI_MASK 2
#define DATAI 2
#define DATAI_BIT 2
#define DATAI_MASK 4
#define SCKI 3
#define SCKI_BIT 3
#define SCKI_MASK 8
#define UPDRV0 4
#define UPDRV0_BIT 4
#define UPDRV0_MASK 16
#define UPDRV1 5
#define UPDRV1_BIT 5
#define UPDRV1_MASK 32
#define UPWE0 6
#define UPWE0_BIT 6
#define UPWE0_MASK 64
#define UPWE1 7
#define UPWE1_BIT 7
#define UPWE1_MASK 128

sfrb UEINT = 0xf4;
#define UEINT_0 0
#define UEINT_0_BIT 0
#define UEINT_0_MASK 1
#define UEINT_1 1
#define UEINT_1_BIT 1
#define UEINT_1_MASK 2
#define UEINT_2 2
#define UEINT_2_BIT 2
#define UEINT_2_MASK 4
#define UEINT_3 3
#define UEINT_3_BIT 3
#define UEINT_3_MASK 8
#define UEINT_4 4
#define UEINT_4_BIT 4
#define UEINT_4_MASK 16
#define UEINT_5 5
#define UEINT_5_BIT 5
#define UEINT_5_MASK 32
#define UEINT_6 6
#define UEINT_6_BIT 6
#define UEINT_6_MASK 64

sfrb UPINT = 0xf8;

sfrb UEBCHX = 0xf3;
#define UEBCHX_0 0
#define UEBCHX_0_BIT 0
#define UEBCHX_0_MASK 1
#define UEBCHX_1 1
#define UEBCHX_1_BIT 1
#define UEBCHX_1_MASK 2
#define UEBCHX_2 2
#define UEBCHX_2_BIT 2
#define UEBCHX_2_MASK 4

sfrb UPBCHX = 0xf7;

sfrb UEBCLX = 0xf2;
#define UEBCLX_0 0
#define UEBCLX_0_BIT 0
#define UEBCLX_0_MASK 1
#define UEBCLX_1 1
#define UEBCLX_1_BIT 1
#define UEBCLX_1_MASK 2
#define UEBCLX_2 2
#define UEBCLX_2_BIT 2
#define UEBCLX_2_MASK 4
#define UEBCLX_3 3
#define UEBCLX_3_BIT 3
#define UEBCLX_3_MASK 8
#define UEBCLX_4 4
#define UEBCLX_4_BIT 4
#define UEBCLX_4_MASK 16
#define UEBCLX_5 5
#define UEBCLX_5_BIT 5
#define UEBCLX_5_MASK 32
#define UEBCLX_6 6
#define UEBCLX_6_BIT 6
#define UEBCLX_6_MASK 64
#define UEBCLX_7 7
#define UEBCLX_7_BIT 7
#define UEBCLX_7_MASK 128

sfrb UPBCLX = 0xf6;

sfrb UEDATX = 0xf1;
#define UEDATX_0 0
#define UEDATX_0_BIT 0
#define UEDATX_0_MASK 1
#define UEDATX_1 1
#define UEDATX_1_BIT 1
#define UEDATX_1_MASK 2
#define UEDATX_2 2
#define UEDATX_2_BIT 2
#define UEDATX_2_MASK 4
#define UEDATX_3 3
#define UEDATX_3_BIT 3
#define UEDATX_3_MASK 8
#define UEDATX_4 4
#define UEDATX_4_BIT 4
#define UEDATX_4_MASK 16
#define UEDATX_5 5
#define UEDATX_5_BIT 5
#define UEDATX_5_MASK 32
#define UEDATX_6 6
#define UEDATX_6_BIT 6
#define UEDATX_6_MASK 64
#define UEDATX_7 7
#define UEDATX_7_BIT 7
#define UEDATX_7_MASK 128

sfrb UPDATX = 0xaf;

sfrb UEIENX = 0xf0;
#define TXINE 0
#define TXINE_BIT 0
#define TXINE_MASK 1
#define STALLEDE 1
#define STALLEDE_BIT 1
#define STALLEDE_MASK 2
#define RXOUTE 2
#define RXOUTE_BIT 2
#define RXOUTE_MASK 4
#define RXSTPE 3
#define RXSTPE_BIT 3
#define RXSTPE_MASK 8
#define NAKOUTE 4
#define NAKOUTE_BIT 4
#define NAKOUTE_MASK 16
#define NAKINE 6
#define NAKINE_BIT 6
#define NAKINE_MASK 64
#define FLERRE 7
#define FLERRE_BIT 7
#define FLERRE_MASK 128

sfrb UPIENX = 0xae;

sfrb UESTA1X = 0xef;
#define CURRBK0 0
#define CURRBK0_BIT 0
#define CURRBK0_MASK 1
#define CURRBK1 1
#define CURRBK1_BIT 1
#define CURRBK1_MASK 2
#define CTRLDIR 2
#define CTRLDIR_BIT 2
#define CTRLDIR_MASK 4

sfrb UPCFG2X = 0xad;

sfrb UESTA0X = 0xee;
#define NBUSYBK0 0
#define NBUSYBK0_BIT 0
#define NBUSYBK0_MASK 1
#define NBUSYBK1 1
#define NBUSYBK1_BIT 1
#define NBUSYBK1_MASK 2
#define DTSEQ0 2
#define DTSEQ0_BIT 2
#define DTSEQ0_MASK 4
#define DTSEQ1 3
#define DTSEQ1_BIT 3
#define DTSEQ1_MASK 8
#define ZLPSEEN 4
#define ZLPSEEN_BIT 4
#define ZLPSEEN_MASK 16
#define UNDERFI 5
#define UNDERFI_BIT 5
#define UNDERFI_MASK 32
#define OVERFI 6
#define OVERFI_BIT 6
#define OVERFI_MASK 64
#define CFGOK 7
#define CFGOK_BIT 7
#define CFGOK_MASK 128

sfrb UPSTAX = 0xac;

sfrb UECFG1X = 0xed;
#define ALLOC 1
#define ALLOC_BIT 1
#define ALLOC_MASK 2
#define EPBK0 2
#define EPBK0_BIT 2
#define EPBK0_MASK 4
#define EPBK1 3
#define EPBK1_BIT 3
#define EPBK1_MASK 8
#define EPSIZE0 4
#define EPSIZE0_BIT 4
#define EPSIZE0_MASK 16
#define EPSIZE1 5
#define EPSIZE1_BIT 5
#define EPSIZE1_MASK 32
#define EPSIZE2 6
#define EPSIZE2_BIT 6
#define EPSIZE2_MASK 64

sfrb UPCFG1X = 0xab;

sfrb UECFG0X = 0xec;
#define EPDIR 0
#define EPDIR_BIT 0
#define EPDIR_MASK 1
#define EPTYPE0 6
#define EPTYPE0_BIT 6
#define EPTYPE0_MASK 64
#define EPTYPE1 7
#define EPTYPE1_BIT 7
#define EPTYPE1_MASK 128

sfrb UPCFG0X = 0xaa;

sfrb UECONX = 0xeb;
#define EPEN 0
#define EPEN_BIT 0
#define EPEN_MASK 1
#define RSTDT 3
#define RSTDT_BIT 3
#define RSTDT_MASK 8
#define STALLRQC 4
#define STALLRQC_BIT 4
#define STALLRQC_MASK 16
#define STALLRQ 5
#define STALLRQ_BIT 5
#define STALLRQ_MASK 32

sfrb UPCONX = 0xa9;

sfrb UERST = 0xea;
#define EPRST0 0
#define EPRST0_BIT 0
#define EPRST0_MASK 1
#define EPRST1 1
#define EPRST1_BIT 1
#define EPRST1_MASK 2
#define EPRST2 2
#define EPRST2_BIT 2
#define EPRST2_MASK 4
#define EPRST3 3
#define EPRST3_BIT 3
#define EPRST3_MASK 8
#define EPRST4 4
#define EPRST4_BIT 4
#define EPRST4_MASK 16
#define EPRST5 5
#define EPRST5_BIT 5
#define EPRST5_MASK 32
#define EPRST6 6
#define EPRST6_BIT 6
#define EPRST6_MASK 64

sfrb UPRST = 0xa8;

sfrb UENUM = 0xe9;
#define UENUM_0 0
#define UENUM_0_BIT 0
#define UENUM_0_MASK 1
#define UENUM_1 1
#define UENUM_1_BIT 1
#define UENUM_1_MASK 2
#define UENUM_2 2
#define UENUM_2_BIT 2
#define UENUM_2_MASK 4

sfrb UPNUM = 0xa7;

sfrb UEINTX = 0xe8;
#define TXINI 0
#define TXINI_BIT 0
#define TXINI_MASK 1
#define STALLEDI 1
#define STALLEDI_BIT 1
#define STALLEDI_MASK 2
#define RXOUTI 2
#define RXOUTI_BIT 2
#define RXOUTI_MASK 4
#define RXSTPI 3
#define RXSTPI_BIT 3
#define RXSTPI_MASK 8
#define NAKOUTI 4
#define NAKOUTI_BIT 4
#define NAKOUTI_MASK 16
#define RWAL 5
#define RWAL_BIT 5
#define RWAL_MASK 32
#define NAKINI 6
#define NAKINI_BIT 6
#define NAKINI_MASK 64
#define FIFOCON 7
#define FIFOCON_BIT 7
#define FIFOCON_MASK 128

sfrb UPINTX = 0xa6;

sfrb UDTST = 0xe7;

sfrb UPINRQX = 0xa5;

sfrb UDMFN = 0xe6;
#define FNCERR 4
#define FNCERR_BIT 4
#define FNCERR_MASK 16

sfrb UHFLEN = 0xa4;

sfrb UDFNUMH = 0xe5;
#define UDFNUMH_0 0
#define UDFNUMH_0_BIT 0
#define UDFNUMH_0_MASK 1
#define UDFNUMH_1 1
#define UDFNUMH_1_BIT 1
#define UDFNUMH_1_MASK 2
#define UDFNUMH_2 2
#define UDFNUMH_2_BIT 2
#define UDFNUMH_2_MASK 4

sfrb UHFNUMH = 0xa3;

sfrb UDFNUML = 0xe4;
#define UDFNUML_0 0
#define UDFNUML_0_BIT 0
#define UDFNUML_0_MASK 1
#define UDFNUML_1 1
#define UDFNUML_1_BIT 1
#define UDFNUML_1_MASK 2
#define UDFNUML_2 2
#define UDFNUML_2_BIT 2
#define UDFNUML_2_MASK 4
#define UDFNUML_3 3
#define UDFNUML_3_BIT 3
#define UDFNUML_3_MASK 8
#define UDFNUML_4 4
#define UDFNUML_4_BIT 4
#define UDFNUML_4_MASK 16
#define UDFNUML_5 5
#define UDFNUML_5_BIT 5
#define UDFNUML_5_MASK 32
#define UDFNUML_6 6
#define UDFNUML_6_BIT 6
#define UDFNUML_6_MASK 64
#define UDFNUML_7 7
#define UDFNUML_7_BIT 7
#define UDFNUML_7_MASK 128

sfrb UHFNUML = 0xa2;

sfrb UDADDR = 0xe3;
#define UDADDR0 0
#define UDADDR0_BIT 0
#define UDADDR0_MASK 1
#define UDADDR1 1
#define UDADDR1_BIT 1
#define UDADDR1_MASK 2
#define UDADDR2 2
#define UDADDR2_BIT 2
#define UDADDR2_MASK 4
#define UDADDR3 3
#define UDADDR3_BIT 3
#define UDADDR3_MASK 8
#define UDADDR4 4
#define UDADDR4_BIT 4
#define UDADDR4_MASK 16
#define UDADDR5 5
#define UDADDR5_BIT 5
#define UDADDR5_MASK 32
#define UDADDR6 6
#define UDADDR6_BIT 6
#define UDADDR6_MASK 64
#define ADDEN 7
#define ADDEN_BIT 7
#define ADDEN_MASK 128

sfrb UHADDR = 0xa1;

sfrb UDIEN = 0xe2;
#define SUSPE 0
#define SUSPE_BIT 0
#define SUSPE_MASK 1
#define MSOFE 1
#define MSOFE_BIT 1
#define MSOFE_MASK 2
#define SOFE 2
#define SOFE_BIT 2
#define SOFE_MASK 4
#define EORSTE 3
#define EORSTE_BIT 3
#define EORSTE_MASK 8
#define WAKEUPE 4
#define WAKEUPE_BIT 4
#define WAKEUPE_MASK 16
#define EORSME 5
#define EORSME_BIT 5
#define EORSME_MASK 32
#define UPRSME 6
#define UPRSME_BIT 6
#define UPRSME_MASK 64

sfrb UHIEN = 0xa0;

sfrb UDINT = 0xe1;
#define SUSPI 0
#define SUSPI_BIT 0
#define SUSPI_MASK 1
#define MSOFI 1
#define MSOFI_BIT 1
#define MSOFI_MASK 2
#define SOFI 2
#define SOFI_BIT 2
#define SOFI_MASK 4
#define EORSTI 3
#define EORSTI_BIT 3
#define EORSTI_MASK 8
#define WAKEUPI 4
#define WAKEUPI_BIT 4
#define WAKEUPI_MASK 16
#define EORSMI 5
#define EORSMI_BIT 5
#define EORSMI_MASK 32
#define UPRSMI 6
#define UPRSMI_BIT 6
#define UPRSMI_MASK 64

sfrb UHINT = 0x9f;

sfrb UDCON = 0xe0;
#define DETACH 0
#define DETACH_BIT 0
#define DETACH_MASK 1
#define RMWKUP 1
#define RMWKUP_BIT 1
#define RMWKUP_MASK 2
#define RSTCPU 2
#define RSTCPU_BIT 2
#define RSTCPU_MASK 4

sfrb UHCON = 0x9e;

sfrb UDPADDH = 0xdc;

sfrb UDPADDL = 0xdb;

sfrw UDPADDW = 0xdb;

sfrb USBINT = 0xda;

sfrb USBCON = 0xd8;
#define FRZCLK 5
#define FRZCLK_BIT 5
#define FRZCLK_MASK 32
#define USBE 7
#define USBE_BIT 7
#define USBE_MASK 128

sfrb REGCR = 0x63;
#define REGDIS 0
#define REGDIS_BIT 0
#define REGDIS_MASK 1

sfrb UDR1 = 0xce;
#define UDR1_0 0
#define UDR1_0_BIT 0
#define UDR1_0_MASK 1
#define UDR1_1 1
#define UDR1_1_BIT 1
#define UDR1_1_MASK 2
#define UDR1_2 2
#define UDR1_2_BIT 2
#define UDR1_2_MASK 4
#define UDR1_3 3
#define UDR1_3_BIT 3
#define UDR1_3_MASK 8
#define UDR1_4 4
#define UDR1_4_BIT 4
#define UDR1_4_MASK 16
#define UDR1_5 5
#define UDR1_5_BIT 5
#define UDR1_5_MASK 32
#define UDR1_6 6
#define UDR1_6_BIT 6
#define UDR1_6_MASK 64
#define UDR1_7 7
#define UDR1_7_BIT 7
#define UDR1_7_MASK 128

sfrb UBRR1H = 0xcd;
#define UBRR8 0
#define UBRR8_BIT 0
#define UBRR8_MASK 1
#define UBRR9 1
#define UBRR9_BIT 1
#define UBRR9_MASK 2
#define UBRR10 2
#define UBRR10_BIT 2
#define UBRR10_MASK 4
#define UBRR11 3
#define UBRR11_BIT 3
#define UBRR11_MASK 8

sfrb UBRR1L = 0xcc;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrw UBRR1W = 0xcc;

sfrb UCSR1D = 0xcb;
#define RTSEN 0
#define RTSEN_BIT 0
#define RTSEN_MASK 1
#define CTSEN 1
#define CTSEN_BIT 1
#define CTSEN_MASK 2

sfrb UCSR1C = 0xca;
#define UCPOL1 0
#define UCPOL1_BIT 0
#define UCPOL1_MASK 1
#define UCSZ10 1
#define UCSZ10_BIT 1
#define UCSZ10_MASK 2
#define UCSZ11 2
#define UCSZ11_BIT 2
#define UCSZ11_MASK 4
#define USBS1 3
#define USBS1_BIT 3
#define USBS1_MASK 8
#define UPM10 4
#define UPM10_BIT 4
#define UPM10_MASK 16
#define UPM11 5
#define UPM11_BIT 5
#define UPM11_MASK 32
#define UMSEL10 6
#define UMSEL10_BIT 6
#define UMSEL10_MASK 64
#define UMSEL11 7
#define UMSEL11_BIT 7
#define UMSEL11_MASK 128

sfrb UCSR1B = 0xc9;
#define TXB81 0
#define TXB81_BIT 0
#define TXB81_MASK 1
#define RXB81 1
#define RXB81_BIT 1
#define RXB81_MASK 2
#define UCSZ12 2
#define UCSZ12_BIT 2
#define UCSZ12_MASK 4
#define TXEN1 3
#define TXEN1_BIT 3
#define TXEN1_MASK 8
#define RXEN1 4
#define RXEN1_BIT 4
#define RXEN1_MASK 16
#define UDRIE1 5
#define UDRIE1_BIT 5
#define UDRIE1_MASK 32
#define TXCIE1 6
#define TXCIE1_BIT 6
#define TXCIE1_MASK 64
#define RXCIE1 7
#define RXCIE1_BIT 7
#define RXCIE1_MASK 128

sfrb UCSR1A = 0xc8;
#define MPCM1 0
#define MPCM1_BIT 0
#define MPCM1_MASK 1
#define U2X1 1
#define U2X1_BIT 1
#define U2X1_MASK 2
#define UPE1 2
#define UPE1_BIT 2
#define UPE1_MASK 4
#define DOR1 3
#define DOR1_BIT 3
#define DOR1_MASK 8
#define FE1 4
#define FE1_BIT 4
#define FE1_MASK 16
#define UDRE1 5
#define UDRE1_BIT 5
#define UDRE1_MASK 32
#define TXC1 6
#define TXC1_BIT 6
#define TXC1_MASK 64
#define RXC1 7
#define RXC1_BIT 7
#define RXC1_MASK 128

sfrb ASSR = 0xb6;

sfrb OCR2B = 0xb4;

sfrb OCR2A = 0xb3;

sfrb TCNT2 = 0xb2;

sfrb TCCR2B = 0xb1;

sfrb TCCR2A = 0xb0;

sfrb OCR3CH = 0x9d;

sfrb OCR3CL = 0x9c;

sfrw OCR3CW = 0x9c;

sfrb OCR3BH = 0x9b;

sfrb OCR3BL = 0x9a;

sfrw OCR3BW = 0x9a;

sfrb OCR3AH = 0x99;

sfrb OCR3AL = 0x98;

sfrw OCR3AW = 0x98;

sfrb ICR3H = 0x97;

sfrb ICR3L = 0x96;

sfrw ICR3W = 0x96;

sfrb TCNT3H = 0x95;

sfrb TCNT3L = 0x94;

sfrw TCNT3W = 0x94;

sfrb TCCR3C = 0x92;

sfrb TCCR3B = 0x91;

sfrb TCCR3A = 0x90;

sfrb OCR1CH = 0x8d;
#define OCR1CH0 0
#define OCR1CH0_BIT 0
#define OCR1CH0_MASK 1
#define OCR1CH1 1
#define OCR1CH1_BIT 1
#define OCR1CH1_MASK 2
#define OCR1CH2 2
#define OCR1CH2_BIT 2
#define OCR1CH2_MASK 4
#define OCR1CH3 3
#define OCR1CH3_BIT 3
#define OCR1CH3_MASK 8
#define OCR1CH4 4
#define OCR1CH4_BIT 4
#define OCR1CH4_MASK 16
#define OCR1CH5 5
#define OCR1CH5_BIT 5
#define OCR1CH5_MASK 32
#define OCR1CH6 6
#define OCR1CH6_BIT 6
#define OCR1CH6_MASK 64
#define OCR1CH7 7
#define OCR1CH7_BIT 7
#define OCR1CH7_MASK 128

sfrb OCR1CL = 0x8c;
#define OCR1CL0 0
#define OCR1CL0_BIT 0
#define OCR1CL0_MASK 1
#define OCR1CL1 1
#define OCR1CL1_BIT 1
#define OCR1CL1_MASK 2
#define OCR1CL2 2
#define OCR1CL2_BIT 2
#define OCR1CL2_MASK 4
#define OCR1CL3 3
#define OCR1CL3_BIT 3
#define OCR1CL3_MASK 8
#define OCR1CL4 4
#define OCR1CL4_BIT 4
#define OCR1CL4_MASK 16
#define OCR1CL5 5
#define OCR1CL5_BIT 5
#define OCR1CL5_MASK 32
#define OCR1CL6 6
#define OCR1CL6_BIT 6
#define OCR1CL6_MASK 64
#define OCR1CL7 7
#define OCR1CL7_BIT 7
#define OCR1CL7_MASK 128

sfrw OCR1CW = 0x8c;

sfrb OCR1BH = 0x8b;
#define OCR1BH0 0
#define OCR1BH0_BIT 0
#define OCR1BH0_MASK 1
#define OCR1BH1 1
#define OCR1BH1_BIT 1
#define OCR1BH1_MASK 2
#define OCR1BH2 2
#define OCR1BH2_BIT 2
#define OCR1BH2_MASK 4
#define OCR1BH3 3
#define OCR1BH3_BIT 3
#define OCR1BH3_MASK 8
#define OCR1BH4 4
#define OCR1BH4_BIT 4
#define OCR1BH4_MASK 16
#define OCR1BH5 5
#define OCR1BH5_BIT 5
#define OCR1BH5_MASK 32
#define OCR1BH6 6
#define OCR1BH6_BIT 6
#define OCR1BH6_MASK 64
#define OCR1BH7 7
#define OCR1BH7_BIT 7
#define OCR1BH7_MASK 128

sfrb OCR1BL = 0x8a;
#define OCR1BL0 0
#define OCR1BL0_BIT 0
#define OCR1BL0_MASK 1
#define OCR1BL1 1
#define OCR1BL1_BIT 1
#define OCR1BL1_MASK 2
#define OCR1BL2 2
#define OCR1BL2_BIT 2
#define OCR1BL2_MASK 4
#define OCR1BL3 3
#define OCR1BL3_BIT 3
#define OCR1BL3_MASK 8
#define OCR1BL4 4
#define OCR1BL4_BIT 4
#define OCR1BL4_MASK 16
#define OCR1BL5 5
#define OCR1BL5_BIT 5
#define OCR1BL5_MASK 32
#define OCR1BL6 6
#define OCR1BL6_BIT 6
#define OCR1BL6_MASK 64
#define OCR1BL7 7
#define OCR1BL7_BIT 7
#define OCR1BL7_MASK 128

sfrw OCR1BW = 0x8a;

sfrb OCR1AH = 0x89;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x88;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x88;

sfrb ICR1H = 0x87;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x86;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x86;

sfrb TCNT1H = 0x85;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x84;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x84;

sfrb TCCR1C = 0x82;
#define FOC1C 5
#define FOC1C_BIT 5
#define FOC1C_MASK 32
#define FOC1B 6
#define FOC1B_BIT 6
#define FOC1B_MASK 64
#define FOC1A 7
#define FOC1A_BIT 7
#define FOC1A_MASK 128

sfrb TCCR1B = 0x81;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define WGM12 3
#define WGM12_BIT 3
#define WGM12_MASK 8
#define WGM13 4
#define WGM13_BIT 4
#define WGM13_MASK 16
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCCR1A = 0x80;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define COM1C0 2
#define COM1C0_BIT 2
#define COM1C0_MASK 4
#define COM1C1 3
#define COM1C1_BIT 3
#define COM1C1_MASK 8
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb DIDR1 = 0x7f;
#define AIN0D 0
#define AIN0D_BIT 0
#define AIN0D_MASK 1
#define AIN1D 1
#define AIN1D_BIT 1
#define AIN1D_MASK 2

sfrb DIDR0 = 0x7e;

sfrb DIDR2 = 0x7d;

sfrb ADMUX = 0x7c;

sfrb ADCSRB = 0x7b;
#define ACME 6
#define ACME_BIT 6
#define ACME_MASK 64

sfrb ADCSRA = 0x7a;

sfrb ADCH = 0x79;

sfrb ADCL = 0x78;

sfrw ADCW = 0x78;

sfrb XMCRB = 0x75;

sfrb XMCRA = 0x74;

sfrb TIMSK5 = 0x73;

sfrb TIMSK4 = 0x72;

sfrb TIMSK3 = 0x71;

sfrb TIMSK2 = 0x70;

sfrb TIMSK1 = 0x6f;
#define TOIE1 0
#define TOIE1_BIT 0
#define TOIE1_MASK 1
#define OCIE1A 1
#define OCIE1A_BIT 1
#define OCIE1A_MASK 2
#define OCIE1B 2
#define OCIE1B_BIT 2
#define OCIE1B_MASK 4
#define OCIE1C 3
#define OCIE1C_BIT 3
#define OCIE1C_MASK 8
#define ICIE1 5
#define ICIE1_BIT 5
#define ICIE1_MASK 32

sfrb TIMSK0 = 0x6e;
#define TOIE0 0
#define TOIE0_BIT 0
#define TOIE0_MASK 1
#define OCIE0A 1
#define OCIE0A_BIT 1
#define OCIE0A_MASK 2
#define OCIE0B 2
#define OCIE0B_BIT 2
#define OCIE0B_MASK 4

sfrb PCMSK2 = 0x6d;

sfrb PCMSK1 = 0x6c;
#define PCINT8 0
#define PCINT8_BIT 0
#define PCINT8_MASK 1
#define PCINT9 1
#define PCINT9_BIT 1
#define PCINT9_MASK 2
#define PCINT10 2
#define PCINT10_BIT 2
#define PCINT10_MASK 4
#define PCINT12 4
#define PCINT12_BIT 4
#define PCINT12_MASK 16

sfrb PCMSK0 = 0x6b;
#define PCINT0 0
#define PCINT0_BIT 0
#define PCINT0_MASK 1
#define PCINT1 1
#define PCINT1_BIT 1
#define PCINT1_MASK 2
#define PCINT2 2
#define PCINT2_BIT 2
#define PCINT2_MASK 4
#define PCINT3 3
#define PCINT3_BIT 3
#define PCINT3_MASK 8
#define PCINT4 4
#define PCINT4_BIT 4
#define PCINT4_MASK 16
#define PCINT5 5
#define PCINT5_BIT 5
#define PCINT5_MASK 32
#define PCINT6 6
#define PCINT6_BIT 6
#define PCINT6_MASK 64
#define PCINT7 7
#define PCINT7_BIT 7
#define PCINT7_MASK 128

sfrb EICRB = 0x6a;
#define ISC40 0
#define ISC40_BIT 0
#define ISC40_MASK 1
#define ISC41 1
#define ISC41_BIT 1
#define ISC41_MASK 2
#define ISC50 2
#define ISC50_BIT 2
#define ISC50_MASK 4
#define ISC51 3
#define ISC51_BIT 3
#define ISC51_MASK 8
#define ISC60 4
#define ISC60_BIT 4
#define ISC60_MASK 16
#define ISC61 5
#define ISC61_BIT 5
#define ISC61_MASK 32
#define ISC70 6
#define ISC70_BIT 6
#define ISC70_MASK 64
#define ISC71 7
#define ISC71_BIT 7
#define ISC71_MASK 128

sfrb EICRA = 0x69;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ISC10 2
#define ISC10_BIT 2
#define ISC10_MASK 4
#define ISC11 3
#define ISC11_BIT 3
#define ISC11_MASK 8
#define ISC20 4
#define ISC20_BIT 4
#define ISC20_MASK 16
#define ISC21 5
#define ISC21_BIT 5
#define ISC21_MASK 32
#define ISC30 6
#define ISC30_BIT 6
#define ISC30_MASK 64
#define ISC31 7
#define ISC31_BIT 7
#define ISC31_MASK 128

sfrb PCICR = 0x68;
#define PCIE0 0
#define PCIE0_BIT 0
#define PCIE0_MASK 1
#define PCIE1 1
#define PCIE1_BIT 1
#define PCIE1_MASK 2

sfrb OSCCAL = 0x66;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64
#define CAL7 7
#define CAL7_BIT 7
#define CAL7_MASK 128

sfrb PRR1 = 0x65;
#define PRUSART1 0
#define PRUSART1_BIT 0
#define PRUSART1_MASK 1
#define PRUSB 7
#define PRUSB_BIT 7
#define PRUSB_MASK 128

sfrb PRR0 = 0x64;
#define PRSPI 2
#define PRSPI_BIT 2
#define PRSPI_MASK 4
#define PRTIM1 3
#define PRTIM1_BIT 3
#define PRTIM1_MASK 8
#define PRTIM0 5
#define PRTIM0_BIT 5
#define PRTIM0_MASK 32

sfrb CLKPR = 0x61;
#define CLKPS0 0
#define CLKPS0_BIT 0
#define CLKPS0_MASK 1
#define CLKPS1 1
#define CLKPS1_BIT 1
#define CLKPS1_MASK 2
#define CLKPS2 2
#define CLKPS2_BIT 2
#define CLKPS2_MASK 4
#define CLKPS3 3
#define CLKPS3_BIT 3
#define CLKPS3_MASK 8
#define CLKPCE 7
#define CLKPCE_BIT 7
#define CLKPCE_MASK 128

sfrb WDTCSR = 0x60;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16
#define WDP3 5
#define WDP3_BIT 5
#define WDP3_MASK 32
#define WDIE 6
#define WDIE_BIT 6
#define WDIE_MASK 64
#define WDIF 7
#define WDIF_BIT 7
#define WDIF_MASK 128

sfrb WDTCKD = 0x62;
#define WCLKDO 0
#define WCLKDO_BIT 0
#define WCLKDO_MASK 1
#define WCLKD1 1
#define WCLKD1_BIT 1
#define WCLKD1_MASK 2
#define WDEWIE 2
#define WDEWIE_BIT 2
#define WDEWIE_MASK 4
#define WDEWIF 3
#define WDEWIF_BIT 3
#define WDEWIF_MASK 8

sfrb SREG = 0x5f;

sfrb SPH = 0x5e;
#define SP8 0
#define SP8_BIT 0
#define SP8_MASK 1
#define SP9 1
#define SP9_BIT 1
#define SP9_MASK 2
#define SP10 2
#define SP10_BIT 2
#define SP10_MASK 4
#define SP11 3
#define SP11_BIT 3
#define SP11_MASK 8
#define SP12 4
#define SP12_BIT 4
#define SP12_MASK 16
#define SP13 5
#define SP13_BIT 5
#define SP13_MASK 32
#define SP14 6
#define SP14_BIT 6
#define SP14_MASK 64
#define SP15 7
#define SP15_BIT 7
#define SP15_MASK 128

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrw SPW = 0x5d;

sfrb EIND = 0x5c;
#define EIND0 0
#define EIND0_BIT 0
#define EIND0_MASK 1

sfrb RAMPZ = 0x5b;

sfrb SPMCSR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define BLBSET 3
#define BLBSET_BIT 3
#define BLBSET_MASK 8
#define RWWSRE 4
#define RWWSRE_BIT 4
#define RWWSRE_MASK 16
#define SIGRD 5
#define SIGRD_BIT 5
#define SIGRD_MASK 32
#define RWWSB 6
#define RWWSB_BIT 6
#define RWWSB_MASK 64
#define SPMIE 7
#define SPMIE_BIT 7
#define SPMIE_MASK 128

sfrb MCUCR = 0x55;
#define IVCE 0
#define IVCE_BIT 0
#define IVCE_MASK 1
#define IVSEL 1
#define IVSEL_BIT 1
#define IVSEL_MASK 2
#define PUD 4
#define PUD_BIT 4
#define PUD_MASK 16
#define JTD 7
#define JTD_BIT 7
#define JTD_MASK 128

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8
#define JTRF 4
#define JTRF_BIT 4
#define JTRF_MASK 16

sfrb SMCR = 0x53;
#define SE 0
#define SE_BIT 0
#define SE_MASK 1
#define SM0 1
#define SM0_BIT 1
#define SM0_MASK 2
#define SM1 2
#define SM1_BIT 2
#define SM1_MASK 4
#define SM2 3
#define SM2_BIT 3
#define SM2_MASK 8

sfrb OCDR = 0x51;

sfrb ACSR = 0x50;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIC 2
#define ACIC_BIT 2
#define ACIC_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb SPDR = 0x4e;
#define SPDR0 0
#define SPDR0_BIT 0
#define SPDR0_MASK 1
#define SPDR1 1
#define SPDR1_BIT 1
#define SPDR1_MASK 2
#define SPDR2 2
#define SPDR2_BIT 2
#define SPDR2_MASK 4
#define SPDR3 3
#define SPDR3_BIT 3
#define SPDR3_MASK 8
#define SPDR4 4
#define SPDR4_BIT 4
#define SPDR4_MASK 16
#define SPDR5 5
#define SPDR5_BIT 5
#define SPDR5_MASK 32
#define SPDR6 6
#define SPDR6_BIT 6
#define SPDR6_MASK 64
#define SPDR7 7
#define SPDR7_BIT 7
#define SPDR7_MASK 128

sfrb SPSR = 0x4d;
#define SPI2X 0
#define SPI2X_BIT 0
#define SPI2X_MASK 1
#define WCOL 6
#define WCOL_BIT 6
#define WCOL_MASK 64
#define SPIF 7
#define SPIF_BIT 7
#define SPIF_MASK 128

sfrb SPCR = 0x4c;
#define SPR0 0
#define SPR0_BIT 0
#define SPR0_MASK 1
#define SPR1 1
#define SPR1_BIT 1
#define SPR1_MASK 2
#define CPHA 2
#define CPHA_BIT 2
#define CPHA_MASK 4
#define CPOL 3
#define CPOL_BIT 3
#define CPOL_MASK 8
#define MSTR 4
#define MSTR_BIT 4
#define MSTR_MASK 16
#define DORD 5
#define DORD_BIT 5
#define DORD_MASK 32
#define SPE 6
#define SPE_BIT 6
#define SPE_MASK 64
#define SPIE 7
#define SPIE_BIT 7
#define SPIE_MASK 128

sfrb GPIOR2 = 0x4b;
#define GPIOR20 0
#define GPIOR20_BIT 0
#define GPIOR20_MASK 1
#define GPIOR21 1
#define GPIOR21_BIT 1
#define GPIOR21_MASK 2
#define GPIOR22 2
#define GPIOR22_BIT 2
#define GPIOR22_MASK 4
#define GPIOR23 3
#define GPIOR23_BIT 3
#define GPIOR23_MASK 8
#define GPIOR24 4
#define GPIOR24_BIT 4
#define GPIOR24_MASK 16
#define GPIOR25 5
#define GPIOR25_BIT 5
#define GPIOR25_MASK 32
#define GPIOR26 6
#define GPIOR26_BIT 6
#define GPIOR26_MASK 64
#define GPIOR27 7
#define GPIOR27_BIT 7
#define GPIOR27_MASK 128

sfrb GPIOR1 = 0x4a;
#define GPIOR10 0
#define GPIOR10_BIT 0
#define GPIOR10_MASK 1
#define GPIOR11 1
#define GPIOR11_BIT 1
#define GPIOR11_MASK 2
#define GPIOR12 2
#define GPIOR12_BIT 2
#define GPIOR12_MASK 4
#define GPIOR13 3
#define GPIOR13_BIT 3
#define GPIOR13_MASK 8
#define GPIOR14 4
#define GPIOR14_BIT 4
#define GPIOR14_MASK 16
#define GPIOR15 5
#define GPIOR15_BIT 5
#define GPIOR15_MASK 32
#define GPIOR16 6
#define GPIOR16_BIT 6
#define GPIOR16_MASK 64
#define GPIOR17 7
#define GPIOR17_BIT 7
#define GPIOR17_MASK 128

sfrb OCR0B = 0x48;
#define OCR0B_0 0
#define OCR0B_0_BIT 0
#define OCR0B_0_MASK 1
#define OCR0B_1 1
#define OCR0B_1_BIT 1
#define OCR0B_1_MASK 2
#define OCR0B_2 2
#define OCR0B_2_BIT 2
#define OCR0B_2_MASK 4
#define OCR0B_3 3
#define OCR0B_3_BIT 3
#define OCR0B_3_MASK 8
#define OCR0B_4 4
#define OCR0B_4_BIT 4
#define OCR0B_4_MASK 16
#define OCR0B_5 5
#define OCR0B_5_BIT 5
#define OCR0B_5_MASK 32
#define OCR0B_6 6
#define OCR0B_6_BIT 6
#define OCR0B_6_MASK 64
#define OCR0B_7 7
#define OCR0B_7_BIT 7
#define OCR0B_7_MASK 128

sfrb OCR0A = 0x47;
#define OCROA_0 0
#define OCROA_0_BIT 0
#define OCROA_0_MASK 1
#define OCROA_1 1
#define OCROA_1_BIT 1
#define OCROA_1_MASK 2
#define OCROA_2 2
#define OCROA_2_BIT 2
#define OCROA_2_MASK 4
#define OCROA_3 3
#define OCROA_3_BIT 3
#define OCROA_3_MASK 8
#define OCROA_4 4
#define OCROA_4_BIT 4
#define OCROA_4_MASK 16
#define OCROA_5 5
#define OCROA_5_BIT 5
#define OCROA_5_MASK 32
#define OCROA_6 6
#define OCROA_6_BIT 6
#define OCROA_6_MASK 64
#define OCROA_7 7
#define OCROA_7_BIT 7
#define OCROA_7_MASK 128

sfrb TCNT0 = 0x46;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb TCCR0B = 0x45;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM02 3
#define WGM02_BIT 3
#define WGM02_MASK 8
#define FOC0B 6
#define FOC0B_BIT 6
#define FOC0B_MASK 64
#define FOC0A 7
#define FOC0A_BIT 7
#define FOC0A_MASK 128

sfrb TCCR0A = 0x44;
#define WGM00 0
#define WGM00_BIT 0
#define WGM00_MASK 1
#define WGM01 1
#define WGM01_BIT 1
#define WGM01_MASK 2
#define COM0B0 4
#define COM0B0_BIT 4
#define COM0B0_MASK 16
#define COM0B1 5
#define COM0B1_BIT 5
#define COM0B1_MASK 32
#define COM0A0 6
#define COM0A0_BIT 6
#define COM0A0_MASK 64
#define COM0A1 7
#define COM0A1_BIT 7
#define COM0A1_MASK 128

sfrb GTCCR = 0x43;
#define PSRSYNC 0
#define PSRSYNC_BIT 0
#define PSRSYNC_MASK 1
#define TSM 7
#define TSM_BIT 7
#define TSM_MASK 128

sfrb EEARH = 0x42;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1
#define EEAR9 1
#define EEAR9_BIT 1
#define EEAR9_MASK 2
#define EEAR10 2
#define EEAR10_BIT 2
#define EEAR10_MASK 4
#define EEAR11 3
#define EEAR11_BIT 3
#define EEAR11_MASK 8

sfrb EEARL = 0x41;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64
#define EEAR7 7
#define EEAR7_BIT 7
#define EEAR7_MASK 128

sfrw EEARW = 0x41;

sfrb EEDR = 0x40;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3f;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEPE 1
#define EEPE_BIT 1
#define EEPE_MASK 2
#define EEMPE 2
#define EEMPE_BIT 2
#define EEMPE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8
#define EEPM0 4
#define EEPM0_BIT 4
#define EEPM0_MASK 16
#define EEPM1 5
#define EEPM1_BIT 5
#define EEPM1_MASK 32

sfrb GPIOR0 = 0x3e;
#define GPIOR00 0
#define GPIOR00_BIT 0
#define GPIOR00_MASK 1
#define GPIOR01 1
#define GPIOR01_BIT 1
#define GPIOR01_MASK 2
#define GPIOR02 2
#define GPIOR02_BIT 2
#define GPIOR02_MASK 4
#define GPIOR03 3
#define GPIOR03_BIT 3
#define GPIOR03_MASK 8
#define GPIOR04 4
#define GPIOR04_BIT 4
#define GPIOR04_MASK 16
#define GPIOR05 5
#define GPIOR05_BIT 5
#define GPIOR05_MASK 32
#define GPIOR06 6
#define GPIOR06_BIT 6
#define GPIOR06_MASK 64
#define GPIOR07 7
#define GPIOR07_BIT 7
#define GPIOR07_MASK 128

sfrb EIMSK = 0x3d;
#define INT0 0
#define INT0_BIT 0
#define INT0_MASK 1
#define INT1 1
#define INT1_BIT 1
#define INT1_MASK 2
#define INT2 2
#define INT2_BIT 2
#define INT2_MASK 4
#define INT3 3
#define INT3_BIT 3
#define INT3_MASK 8
#define INT4 4
#define INT4_BIT 4
#define INT4_MASK 16
#define INT5 5
#define INT5_BIT 5
#define INT5_MASK 32
#define INT6 6
#define INT6_BIT 6
#define INT6_MASK 64
#define INT7 7
#define INT7_BIT 7
#define INT7_MASK 128

sfrb EIFR = 0x3c;
#define INTF0 0
#define INTF0_BIT 0
#define INTF0_MASK 1
#define INTF1 1
#define INTF1_BIT 1
#define INTF1_MASK 2
#define INTF2 2
#define INTF2_BIT 2
#define INTF2_MASK 4
#define INTF3 3
#define INTF3_BIT 3
#define INTF3_MASK 8
#define INTF4 4
#define INTF4_BIT 4
#define INTF4_MASK 16
#define INTF5 5
#define INTF5_BIT 5
#define INTF5_MASK 32
#define INTF6 6
#define INTF6_BIT 6
#define INTF6_MASK 64
#define INTF7 7
#define INTF7_BIT 7
#define INTF7_MASK 128

sfrb PCIFR = 0x3b;
#define PCIF0 0
#define PCIF0_BIT 0
#define PCIF0_MASK 1
#define PCIF1 1
#define PCIF1_BIT 1
#define PCIF1_MASK 2

sfrb TIFR5 = 0x3a;

sfrb TIFR4 = 0x39;

sfrb TIFR3 = 0x38;

sfrb TIFR2 = 0x37;

sfrb TIFR1 = 0x36;
#define TOV1 0
#define TOV1_BIT 0
#define TOV1_MASK 1
#define OCF1A 1
#define OCF1A_BIT 1
#define OCF1A_MASK 2
#define OCF1B 2
#define OCF1B_BIT 2
#define OCF1B_MASK 4
#define OCF1C 3
#define OCF1C_BIT 3
#define OCF1C_MASK 8
#define ICF1 5
#define ICF1_BIT 5
#define ICF1_MASK 32

sfrb TIFR0 = 0x35;
#define TOV0 0
#define TOV0_BIT 0
#define TOV0_MASK 1
#define OCF0A 1
#define OCF0A_BIT 1
#define OCF0A_MASK 2
#define OCF0B 2
#define OCF0B_BIT 2
#define OCF0B_MASK 4

sfrb PORTF = 0x31;

sfrb DDRF = 0x30;

sfrb PINF = 0x2f;

sfrb PORTE = 0x2e;

sfrb DDRE = 0x2d;

sfrb PINE = 0x2c;

sfrb PORTD = 0x2b;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x2a;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64
#define DDD7 7
#define DDD7_BIT 7
#define DDD7_MASK 128

sfrb PIND = 0x29;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb PORTC = 0x28;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1
#define PORTC1 1
#define PORTC1_BIT 1
#define PORTC1_MASK 2
#define PORTC2 2
#define PORTC2_BIT 2
#define PORTC2_MASK 4
#define PORTC3 3
#define PORTC3_BIT 3
#define PORTC3_MASK 8
#define PORTC4 4
#define PORTC4_BIT 4
#define PORTC4_MASK 16
#define PORTC5 5
#define PORTC5_BIT 5
#define PORTC5_MASK 32
#define PORTC6 6
#define PORTC6_BIT 6
#define PORTC6_MASK 64
#define PORTC7 7
#define PORTC7_BIT 7
#define PORTC7_MASK 128

sfrb DDRC = 0x27;
#define DDC0 0
#define DDC0_BIT 0
#define DDC0_MASK 1
#define DDC1 1
#define DDC1_BIT 1
#define DDC1_MASK 2
#define DDC2 2
#define DDC2_BIT 2
#define DDC2_MASK 4
#define DDC3 3
#define DDC3_BIT 3
#define DDC3_MASK 8
#define DDC4 4
#define DDC4_BIT 4
#define DDC4_MASK 16
#define DDC5 5
#define DDC5_BIT 5
#define DDC5_MASK 32
#define DDC6 6
#define DDC6_BIT 6
#define DDC6_MASK 64
#define DDC7 7
#define DDC7_BIT 7
#define DDC7_MASK 128

sfrb PINC = 0x26;
#define PINC0 0
#define PINC0_BIT 0
#define PINC0_MASK 1
#define PINC1 1
#define PINC1_BIT 1
#define PINC1_MASK 2
#define PINC2 2
#define PINC2_BIT 2
#define PINC2_MASK 4
#define PINC3 3
#define PINC3_BIT 3
#define PINC3_MASK 8
#define PINC4 4
#define PINC4_BIT 4
#define PINC4_MASK 16
#define PINC5 5
#define PINC5_BIT 5
#define PINC5_MASK 32
#define PINC6 6
#define PINC6_BIT 6
#define PINC6_MASK 64
#define PINC7 7
#define PINC7_BIT 7
#define PINC7_MASK 128

sfrb PORTB = 0x25;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x24;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x23;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

#endif
