#ifndef __AT90USB1287_h
#define __AT90USB1287_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0004
#define INT1_vect 0x0008
#define INT2_vect 0x000c
#define INT3_vect 0x0010
#define INT4_vect 0x0014
#define INT5_vect 0x0018
#define INT6_vect 0x001c
#define INT7_vect 0x0020
#define PCINT0_vect 0x0024
#define USB_GEN_vect 0x0028
#define USB_COM_vect 0x002c
#define WDT_vect 0x0030
#define TIMER2_COMPA_vect 0x0034
#define TIMER2_COMPB_vect 0x0038
#define TIMER2_OVF_vect 0x003c
#define TIMER1_CAPT_vect 0x0040
#define TIMER1_COMPA_vect 0x0044
#define TIMER1_COMPB_vect 0x0048
#define TIMER1_COMPC_vect 0x004c
#define TIMER1_OVF_vect 0x0050
#define TIMER0_COMPA_vect 0x0054
#define TIMER0_COMPB_vect 0x0058
#define TIMER0_OVF_vect 0x005c
#define SPI_STC_vect 0x0060
#define USART1_RX_vect 0x0064
#define USART1_UDRE_vect 0x0068
#define USART1_TX_vect 0x006c
#define ANALOG_COMP_vect 0x0070
#define ADC_vect 0x0074
#define EE_READY_vect 0x0078
#define TIMER3_CAPT_vect 0x007c
#define TIMER3_COMPA_vect 0x0080
#define TIMER3_COMPB_vect 0x0084
#define TIMER3_COMPC_vect 0x0088
#define TIMER3_OVF_vect 0x008c
#define TWI_vect 0x0090
#define SPM_READY_vect 0x0094

// I/O addresses


sfrb PLLCSR = 0x49;
#define PLOCK 0
#define PLOCK_BIT 0
#define PLOCK_MASK 1
#define PLLE 1
#define PLLE_BIT 1
#define PLLE_MASK 2
#define PLLP0 2
#define PLLP0_BIT 2
#define PLLP0_MASK 4
#define PLLP1 3
#define PLLP1_BIT 3
#define PLLP1_MASK 8
#define PLLP2 4
#define PLLP2_BIT 4
#define PLLP2_MASK 16

sfrb TESTPADSTATUS = 0xfd;

sfrb TESTPADPULL = 0xfe;

sfrb TESTPADCTRL = 0xff;

sfrb UPERRX = 0xf5;
#define DATATGL 0
#define DATATGL_BIT 0
#define DATATGL_MASK 1
#define DATAPID 1
#define DATAPID_BIT 1
#define DATAPID_MASK 2
#define PID 2
#define PID_BIT 2
#define PID_MASK 4
#define TIMEOUT 3
#define TIMEOUT_BIT 3
#define TIMEOUT_MASK 8
#define CRC16 4
#define CRC16_BIT 4
#define CRC16_MASK 16
#define COUNTER0 5
#define COUNTER0_BIT 5
#define COUNTER0_MASK 32
#define COUNTER1 6
#define COUNTER1_BIT 6
#define COUNTER1_MASK 64

sfrb UEINT = 0xf4;
#define UEINT_0 0
#define UEINT_0_BIT 0
#define UEINT_0_MASK 1
#define UEINT_1 1
#define UEINT_1_BIT 1
#define UEINT_1_MASK 2
#define UEINT_2 2
#define UEINT_2_BIT 2
#define UEINT_2_MASK 4
#define UEINT_3 3
#define UEINT_3_BIT 3
#define UEINT_3_MASK 8
#define UEINT_4 4
#define UEINT_4_BIT 4
#define UEINT_4_MASK 16
#define UEINT_5 5
#define UEINT_5_BIT 5
#define UEINT_5_MASK 32
#define UEINT_6 6
#define UEINT_6_BIT 6
#define UEINT_6_MASK 64

sfrb UPINT = 0xf8;
#define PINT0 0
#define PINT0_BIT 0
#define PINT0_MASK 1
#define PINT1 1
#define PINT1_BIT 1
#define PINT1_MASK 2
#define PINT2 2
#define PINT2_BIT 2
#define PINT2_MASK 4
#define PINT3 3
#define PINT3_BIT 3
#define PINT3_MASK 8
#define PINT4 4
#define PINT4_BIT 4
#define PINT4_MASK 16
#define PINT5 5
#define PINT5_BIT 5
#define PINT5_MASK 32
#define PINT6 6
#define PINT6_BIT 6
#define PINT6_MASK 64

sfrb UEBCHX = 0xf3;
#define UEBCHX_0 0
#define UEBCHX_0_BIT 0
#define UEBCHX_0_MASK 1
#define UEBCHX_1 1
#define UEBCHX_1_BIT 1
#define UEBCHX_1_MASK 2
#define UEBCHX_2 2
#define UEBCHX_2_BIT 2
#define UEBCHX_2_MASK 4

sfrb UPBCHX = 0xf7;
#define PBYCT8 0
#define PBYCT8_BIT 0
#define PBYCT8_MASK 1
#define PBYCT9 1
#define PBYCT9_BIT 1
#define PBYCT9_MASK 2
#define PBYCT10 2
#define PBYCT10_BIT 2
#define PBYCT10_MASK 4

sfrb UEBCLX = 0xf2;
#define UEBCLX_0 0
#define UEBCLX_0_BIT 0
#define UEBCLX_0_MASK 1
#define UEBCLX_1 1
#define UEBCLX_1_BIT 1
#define UEBCLX_1_MASK 2
#define UEBCLX_2 2
#define UEBCLX_2_BIT 2
#define UEBCLX_2_MASK 4
#define UEBCLX_3 3
#define UEBCLX_3_BIT 3
#define UEBCLX_3_MASK 8
#define UEBCLX_4 4
#define UEBCLX_4_BIT 4
#define UEBCLX_4_MASK 16
#define UEBCLX_5 5
#define UEBCLX_5_BIT 5
#define UEBCLX_5_MASK 32
#define UEBCLX_6 6
#define UEBCLX_6_BIT 6
#define UEBCLX_6_MASK 64
#define UEBCLX_7 7
#define UEBCLX_7_BIT 7
#define UEBCLX_7_MASK 128

sfrb UPBCLX = 0xf6;
#define PBYCT0 0
#define PBYCT0_BIT 0
#define PBYCT0_MASK 1
#define PBYCT1 1
#define PBYCT1_BIT 1
#define PBYCT1_MASK 2
#define PBYCT2 2
#define PBYCT2_BIT 2
#define PBYCT2_MASK 4
#define PBYCT3 3
#define PBYCT3_BIT 3
#define PBYCT3_MASK 8
#define PBYCT4 4
#define PBYCT4_BIT 4
#define PBYCT4_MASK 16
#define PBYCT5 5
#define PBYCT5_BIT 5
#define PBYCT5_MASK 32
#define PBYCT6 6
#define PBYCT6_BIT 6
#define PBYCT6_MASK 64
#define PBYCT7 7
#define PBYCT7_BIT 7
#define PBYCT7_MASK 128

sfrb UEDATX = 0xf1;
#define UEDATX_0 0
#define UEDATX_0_BIT 0
#define UEDATX_0_MASK 1
#define UEDATX_1 1
#define UEDATX_1_BIT 1
#define UEDATX_1_MASK 2
#define UEDATX_2 2
#define UEDATX_2_BIT 2
#define UEDATX_2_MASK 4
#define UEDATX_3 3
#define UEDATX_3_BIT 3
#define UEDATX_3_MASK 8
#define UEDATX_4 4
#define UEDATX_4_BIT 4
#define UEDATX_4_MASK 16
#define UEDATX_5 5
#define UEDATX_5_BIT 5
#define UEDATX_5_MASK 32
#define UEDATX_6 6
#define UEDATX_6_BIT 6
#define UEDATX_6_MASK 64
#define UEDATX_7 7
#define UEDATX_7_BIT 7
#define UEDATX_7_MASK 128

sfrb UPDATX = 0xaf;
#define PDAT0 0
#define PDAT0_BIT 0
#define PDAT0_MASK 1
#define PDAT1 1
#define PDAT1_BIT 1
#define PDAT1_MASK 2
#define PDAT2 2
#define PDAT2_BIT 2
#define PDAT2_MASK 4
#define PDAT3 3
#define PDAT3_BIT 3
#define PDAT3_MASK 8
#define PDAT4 4
#define PDAT4_BIT 4
#define PDAT4_MASK 16
#define PDAT5 5
#define PDAT5_BIT 5
#define PDAT5_MASK 32
#define PDAT6 6
#define PDAT6_BIT 6
#define PDAT6_MASK 64
#define PDAT7 7
#define PDAT7_BIT 7
#define PDAT7_MASK 128

sfrb UEIENX = 0xf0;
#define TXINE 0
#define TXINE_BIT 0
#define TXINE_MASK 1
#define STALLEDE 1
#define STALLEDE_BIT 1
#define STALLEDE_MASK 2
#define RXOUTE 2
#define RXOUTE_BIT 2
#define RXOUTE_MASK 4
#define RXSTPE 3
#define RXSTPE_BIT 3
#define RXSTPE_MASK 8
#define NAKOUTE 4
#define NAKOUTE_BIT 4
#define NAKOUTE_MASK 16
#define NAKINE 6
#define NAKINE_BIT 6
#define NAKINE_MASK 64
#define FLERRE 7
#define FLERRE_BIT 7
#define FLERRE_MASK 128

sfrb UPIENX = 0xae;
#define RXINE 0
#define RXINE_BIT 0
#define RXINE_MASK 1
#define RXSTALLE 1
#define RXSTALLE_BIT 1
#define RXSTALLE_MASK 2
#define TXOUTE 2
#define TXOUTE_BIT 2
#define TXOUTE_MASK 4
#define TXSTPE 3
#define TXSTPE_BIT 3
#define TXSTPE_MASK 8
#define PERRE 4
#define PERRE_BIT 4
#define PERRE_MASK 16
#define NAKEDE 6
#define NAKEDE_BIT 6
#define NAKEDE_MASK 64
#define FLERRE 7
#define FLERRE_BIT 7
#define FLERRE_MASK 128

sfrb UESTA1X = 0xef;
#define CURRBK0 0
#define CURRBK0_BIT 0
#define CURRBK0_MASK 1
#define CURRBK1 1
#define CURRBK1_BIT 1
#define CURRBK1_MASK 2
#define CTRLDIR 2
#define CTRLDIR_BIT 2
#define CTRLDIR_MASK 4

sfrb UPCFG2X = 0xad;
#define UPCFG2X_0 0
#define UPCFG2X_0_BIT 0
#define UPCFG2X_0_MASK 1
#define UPCFG2X_1 1
#define UPCFG2X_1_BIT 1
#define UPCFG2X_1_MASK 2
#define UPCFG2X_2 2
#define UPCFG2X_2_BIT 2
#define UPCFG2X_2_MASK 4
#define UPCFG2X_3 3
#define UPCFG2X_3_BIT 3
#define UPCFG2X_3_MASK 8
#define UPCFG2X_4 4
#define UPCFG2X_4_BIT 4
#define UPCFG2X_4_MASK 16
#define UPCFG2X_5 5
#define UPCFG2X_5_BIT 5
#define UPCFG2X_5_MASK 32
#define UPCFG2X_6 6
#define UPCFG2X_6_BIT 6
#define UPCFG2X_6_MASK 64
#define UPCFG2X_7 7
#define UPCFG2X_7_BIT 7
#define UPCFG2X_7_MASK 128

sfrb UESTA0X = 0xee;
#define NBUSYBK0 0
#define NBUSYBK0_BIT 0
#define NBUSYBK0_MASK 1
#define NBUSYBK1 1
#define NBUSYBK1_BIT 1
#define NBUSYBK1_MASK 2
#define DTSEQ0 2
#define DTSEQ0_BIT 2
#define DTSEQ0_MASK 4
#define DTSEQ1 3
#define DTSEQ1_BIT 3
#define DTSEQ1_MASK 8
#define ZLPSEEN 4
#define ZLPSEEN_BIT 4
#define ZLPSEEN_MASK 16
#define UNDERFI 5
#define UNDERFI_BIT 5
#define UNDERFI_MASK 32
#define OVERFI 6
#define OVERFI_BIT 6
#define OVERFI_MASK 64
#define CFGOK 7
#define CFGOK_BIT 7
#define CFGOK_MASK 128

sfrb UPSTAX = 0xac;
#define NBUSYK0 0
#define NBUSYK0_BIT 0
#define NBUSYK0_MASK 1
#define NBUSYK1 1
#define NBUSYK1_BIT 1
#define NBUSYK1_MASK 2
#define DTSEQ0 2
#define DTSEQ0_BIT 2
#define DTSEQ0_MASK 4
#define DTSEQ1 3
#define DTSEQ1_BIT 3
#define DTSEQ1_MASK 8
#define UNDERFI 5
#define UNDERFI_BIT 5
#define UNDERFI_MASK 32
#define OVERFI 6
#define OVERFI_BIT 6
#define OVERFI_MASK 64
#define CFGOK 7
#define CFGOK_BIT 7
#define CFGOK_MASK 128

sfrb UECFG1X = 0xed;
#define ALLOC 1
#define ALLOC_BIT 1
#define ALLOC_MASK 2
#define EPBK0 2
#define EPBK0_BIT 2
#define EPBK0_MASK 4
#define EPBK1 3
#define EPBK1_BIT 3
#define EPBK1_MASK 8
#define EPSIZE0 4
#define EPSIZE0_BIT 4
#define EPSIZE0_MASK 16
#define EPSIZE1 5
#define EPSIZE1_BIT 5
#define EPSIZE1_MASK 32
#define EPSIZE2 6
#define EPSIZE2_BIT 6
#define EPSIZE2_MASK 64

sfrb UPCFG1X = 0xab;
#define ALLOC 1
#define ALLOC_BIT 1
#define ALLOC_MASK 2
#define PBK0 2
#define PBK0_BIT 2
#define PBK0_MASK 4
#define PBK1 3
#define PBK1_BIT 3
#define PBK1_MASK 8
#define PSIZE0 4
#define PSIZE0_BIT 4
#define PSIZE0_MASK 16
#define PSIZE1 5
#define PSIZE1_BIT 5
#define PSIZE1_MASK 32
#define PSIZE2 6
#define PSIZE2_BIT 6
#define PSIZE2_MASK 64

sfrb UECFG0X = 0xec;
#define EPDIR 0
#define EPDIR_BIT 0
#define EPDIR_MASK 1
#define EPTYPE0 6
#define EPTYPE0_BIT 6
#define EPTYPE0_MASK 64
#define EPTYPE1 7
#define EPTYPE1_BIT 7
#define EPTYPE1_MASK 128

sfrb UPCFG0X = 0xaa;
#define PEPNUM0 0
#define PEPNUM0_BIT 0
#define PEPNUM0_MASK 1
#define PEPNUM1 1
#define PEPNUM1_BIT 1
#define PEPNUM1_MASK 2
#define PEPNUM2 2
#define PEPNUM2_BIT 2
#define PEPNUM2_MASK 4
#define PEPNUM3 3
#define PEPNUM3_BIT 3
#define PEPNUM3_MASK 8
#define PTOKEN0 4
#define PTOKEN0_BIT 4
#define PTOKEN0_MASK 16
#define PTOKEN1 5
#define PTOKEN1_BIT 5
#define PTOKEN1_MASK 32
#define PTYPE0 6
#define PTYPE0_BIT 6
#define PTYPE0_MASK 64
#define PTYPE1 7
#define PTYPE1_BIT 7
#define PTYPE1_MASK 128

sfrb UECONX = 0xeb;
#define EPEN 0
#define EPEN_BIT 0
#define EPEN_MASK 1
#define RSTDT 3
#define RSTDT_BIT 3
#define RSTDT_MASK 8
#define STALLRQC 4
#define STALLRQC_BIT 4
#define STALLRQC_MASK 16
#define STALLRQ 5
#define STALLRQ_BIT 5
#define STALLRQ_MASK 32

sfrb UPCONX = 0xa9;
#define PEN 0
#define PEN_BIT 0
#define PEN_MASK 1
#define RSTDT 3
#define RSTDT_BIT 3
#define RSTDT_MASK 8
#define INMODE 5
#define INMODE_BIT 5
#define INMODE_MASK 32
#define PFREEZE 6
#define PFREEZE_BIT 6
#define PFREEZE_MASK 64

sfrb UERST = 0xea;
#define EPRST0 0
#define EPRST0_BIT 0
#define EPRST0_MASK 1
#define EPRST1 1
#define EPRST1_BIT 1
#define EPRST1_MASK 2
#define EPRST2 2
#define EPRST2_BIT 2
#define EPRST2_MASK 4
#define EPRST3 3
#define EPRST3_BIT 3
#define EPRST3_MASK 8
#define EPRST4 4
#define EPRST4_BIT 4
#define EPRST4_MASK 16
#define EPRST5 5
#define EPRST5_BIT 5
#define EPRST5_MASK 32
#define EPRST6 6
#define EPRST6_BIT 6
#define EPRST6_MASK 64

sfrb UPRST = 0xa8;
#define PRST0 0
#define PRST0_BIT 0
#define PRST0_MASK 1
#define PRST1 1
#define PRST1_BIT 1
#define PRST1_MASK 2
#define PRST2 2
#define PRST2_BIT 2
#define PRST2_MASK 4
#define PRST3 3
#define PRST3_BIT 3
#define PRST3_MASK 8
#define PRST4 4
#define PRST4_BIT 4
#define PRST4_MASK 16
#define PRST5 5
#define PRST5_BIT 5
#define PRST5_MASK 32
#define PRST6 6
#define PRST6_BIT 6
#define PRST6_MASK 64

sfrb UENUM = 0xe9;
#define UENUM_0 0
#define UENUM_0_BIT 0
#define UENUM_0_MASK 1
#define UENUM_1 1
#define UENUM_1_BIT 1
#define UENUM_1_MASK 2
#define UENUM_2 2
#define UENUM_2_BIT 2
#define UENUM_2_MASK 4

sfrb UPNUM = 0xa7;
#define PNUM0 0
#define PNUM0_BIT 0
#define PNUM0_MASK 1
#define PNUM1 1
#define PNUM1_BIT 1
#define PNUM1_MASK 2
#define PNUM2 2
#define PNUM2_BIT 2
#define PNUM2_MASK 4

sfrb UEINTX = 0xe8;
#define TXINI 0
#define TXINI_BIT 0
#define TXINI_MASK 1
#define STALLEDI 1
#define STALLEDI_BIT 1
#define STALLEDI_MASK 2
#define RXOUTI 2
#define RXOUTI_BIT 2
#define RXOUTI_MASK 4
#define RXSTPI 3
#define RXSTPI_BIT 3
#define RXSTPI_MASK 8
#define NAKOUTI 4
#define NAKOUTI_BIT 4
#define NAKOUTI_MASK 16
#define RWAL 5
#define RWAL_BIT 5
#define RWAL_MASK 32
#define NAKINI 6
#define NAKINI_BIT 6
#define NAKINI_MASK 64
#define FIFOCON 7
#define FIFOCON_BIT 7
#define FIFOCON_MASK 128

sfrb UPINTX = 0xa6;
#define RXINI 0
#define RXINI_BIT 0
#define RXINI_MASK 1
#define RXSTALLI 1
#define RXSTALLI_BIT 1
#define RXSTALLI_MASK 2
#define TXOUTI 2
#define TXOUTI_BIT 2
#define TXOUTI_MASK 4
#define TXSTPI 3
#define TXSTPI_BIT 3
#define TXSTPI_MASK 8
#define PERRI 4
#define PERRI_BIT 4
#define PERRI_MASK 16
#define RWAL 5
#define RWAL_BIT 5
#define RWAL_MASK 32
#define NAKEDI 6
#define NAKEDI_BIT 6
#define NAKEDI_MASK 64
#define FIFOCON 7
#define FIFOCON_BIT 7
#define FIFOCON_MASK 128

sfrb UDTST = 0xe7;

sfrb UPINRQX = 0xa5;
#define INRQ0 0
#define INRQ0_BIT 0
#define INRQ0_MASK 1
#define INRQ1 1
#define INRQ1_BIT 1
#define INRQ1_MASK 2
#define INRQ2 2
#define INRQ2_BIT 2
#define INRQ2_MASK 4
#define INRQ3 3
#define INRQ3_BIT 3
#define INRQ3_MASK 8
#define INRQ4 4
#define INRQ4_BIT 4
#define INRQ4_MASK 16
#define INRQ5 5
#define INRQ5_BIT 5
#define INRQ5_MASK 32
#define INRQ6 6
#define INRQ6_BIT 6
#define INRQ6_MASK 64
#define INRQ7 7
#define INRQ7_BIT 7
#define INRQ7_MASK 128

sfrb UDMFN = 0xe6;
#define FNCERR 4
#define FNCERR_BIT 4
#define FNCERR_MASK 16

sfrb UHFLEN = 0xa4;
#define UHFLEN_0 0
#define UHFLEN_0_BIT 0
#define UHFLEN_0_MASK 1
#define UHFLEN_1 1
#define UHFLEN_1_BIT 1
#define UHFLEN_1_MASK 2
#define UHFLEN_2 2
#define UHFLEN_2_BIT 2
#define UHFLEN_2_MASK 4
#define UHFLEN_3 3
#define UHFLEN_3_BIT 3
#define UHFLEN_3_MASK 8
#define UHFLEN_4 4
#define UHFLEN_4_BIT 4
#define UHFLEN_4_MASK 16
#define UHFLEN_5 5
#define UHFLEN_5_BIT 5
#define UHFLEN_5_MASK 32
#define UHFLEN_6 6
#define UHFLEN_6_BIT 6
#define UHFLEN_6_MASK 64
#define UHFLEN_7 7
#define UHFLEN_7_BIT 7
#define UHFLEN_7_MASK 128

sfrb UDFNUMH = 0xe5;
#define UDFNUMH_0 0
#define UDFNUMH_0_BIT 0
#define UDFNUMH_0_MASK 1
#define UDFNUMH_1 1
#define UDFNUMH_1_BIT 1
#define UDFNUMH_1_MASK 2
#define UDFNUMH_2 2
#define UDFNUMH_2_BIT 2
#define UDFNUMH_2_MASK 4

sfrb UHFNUMH = 0xa3;
#define UHFNUMH_0 0
#define UHFNUMH_0_BIT 0
#define UHFNUMH_0_MASK 1
#define UHFNUMH_1 1
#define UHFNUMH_1_BIT 1
#define UHFNUMH_1_MASK 2
#define UHFNUMH_2 2
#define UHFNUMH_2_BIT 2
#define UHFNUMH_2_MASK 4

sfrb UDFNUML = 0xe4;
#define UDFNUML_0 0
#define UDFNUML_0_BIT 0
#define UDFNUML_0_MASK 1
#define UDFNUML_1 1
#define UDFNUML_1_BIT 1
#define UDFNUML_1_MASK 2
#define UDFNUML_2 2
#define UDFNUML_2_BIT 2
#define UDFNUML_2_MASK 4
#define UDFNUML_3 3
#define UDFNUML_3_BIT 3
#define UDFNUML_3_MASK 8
#define UDFNUML_4 4
#define UDFNUML_4_BIT 4
#define UDFNUML_4_MASK 16
#define UDFNUML_5 5
#define UDFNUML_5_BIT 5
#define UDFNUML_5_MASK 32
#define UDFNUML_6 6
#define UDFNUML_6_BIT 6
#define UDFNUML_6_MASK 64
#define UDFNUML_7 7
#define UDFNUML_7_BIT 7
#define UDFNUML_7_MASK 128

sfrb UHFNUML = 0xa2;
#define UHFNUML_0 0
#define UHFNUML_0_BIT 0
#define UHFNUML_0_MASK 1
#define UHFNUML_1 1
#define UHFNUML_1_BIT 1
#define UHFNUML_1_MASK 2
#define UHFNUML_2 2
#define UHFNUML_2_BIT 2
#define UHFNUML_2_MASK 4
#define UHFNUML_3 3
#define UHFNUML_3_BIT 3
#define UHFNUML_3_MASK 8
#define UHFNUML_4 4
#define UHFNUML_4_BIT 4
#define UHFNUML_4_MASK 16
#define UHFNUML_5 5
#define UHFNUML_5_BIT 5
#define UHFNUML_5_MASK 32
#define UHFNUML_6 6
#define UHFNUML_6_BIT 6
#define UHFNUML_6_MASK 64
#define UHFNUML_7 7
#define UHFNUML_7_BIT 7
#define UHFNUML_7_MASK 128

sfrb UDADDR = 0xe3;
#define UDADDR0 0
#define UDADDR0_BIT 0
#define UDADDR0_MASK 1
#define UDADDR1 1
#define UDADDR1_BIT 1
#define UDADDR1_MASK 2
#define UDADDR2 2
#define UDADDR2_BIT 2
#define UDADDR2_MASK 4
#define UDADDR3 3
#define UDADDR3_BIT 3
#define UDADDR3_MASK 8
#define UDADDR4 4
#define UDADDR4_BIT 4
#define UDADDR4_MASK 16
#define UDADDR5 5
#define UDADDR5_BIT 5
#define UDADDR5_MASK 32
#define UDADDR6 6
#define UDADDR6_BIT 6
#define UDADDR6_MASK 64
#define ADDEN 7
#define ADDEN_BIT 7
#define ADDEN_MASK 128

sfrb UHADDR = 0xa1;
#define UHADDR_0 0
#define UHADDR_0_BIT 0
#define UHADDR_0_MASK 1
#define UHADDR_1 1
#define UHADDR_1_BIT 1
#define UHADDR_1_MASK 2
#define UHADDR_2 2
#define UHADDR_2_BIT 2
#define UHADDR_2_MASK 4
#define UHADDR_3 3
#define UHADDR_3_BIT 3
#define UHADDR_3_MASK 8
#define UHADDR_4 4
#define UHADDR_4_BIT 4
#define UHADDR_4_MASK 16
#define UHADDR_5 5
#define UHADDR_5_BIT 5
#define UHADDR_5_MASK 32
#define UHADDR_6 6
#define UHADDR_6_BIT 6
#define UHADDR_6_MASK 64

sfrb UDIEN = 0xe2;
#define SUSPE 0
#define SUSPE_BIT 0
#define SUSPE_MASK 1
#define MSOFE 1
#define MSOFE_BIT 1
#define MSOFE_MASK 2
#define SOFE 2
#define SOFE_BIT 2
#define SOFE_MASK 4
#define EORSTE 3
#define EORSTE_BIT 3
#define EORSTE_MASK 8
#define WAKEUPE 4
#define WAKEUPE_BIT 4
#define WAKEUPE_MASK 16
#define EORSME 5
#define EORSME_BIT 5
#define EORSME_MASK 32
#define UPRSME 6
#define UPRSME_BIT 6
#define UPRSME_MASK 64

sfrb UHIEN = 0xa0;
#define DCONNE 0
#define DCONNE_BIT 0
#define DCONNE_MASK 1
#define DDISCE 1
#define DDISCE_BIT 1
#define DDISCE_MASK 2
#define RSTE 2
#define RSTE_BIT 2
#define RSTE_MASK 4
#define RSMEDE 3
#define RSMEDE_BIT 3
#define RSMEDE_MASK 8
#define RXRSME 4
#define RXRSME_BIT 4
#define RXRSME_MASK 16
#define HSOFE 5
#define HSOFE_BIT 5
#define HSOFE_MASK 32
#define HWUPE 6
#define HWUPE_BIT 6
#define HWUPE_MASK 64

sfrb UDINT = 0xe1;
#define SUSPI 0
#define SUSPI_BIT 0
#define SUSPI_MASK 1
#define MSOFI 1
#define MSOFI_BIT 1
#define MSOFI_MASK 2
#define SOFI 2
#define SOFI_BIT 2
#define SOFI_MASK 4
#define EORSTI 3
#define EORSTI_BIT 3
#define EORSTI_MASK 8
#define WAKEUPI 4
#define WAKEUPI_BIT 4
#define WAKEUPI_MASK 16
#define EORSMI 5
#define EORSMI_BIT 5
#define EORSMI_MASK 32
#define UPRSMI 6
#define UPRSMI_BIT 6
#define UPRSMI_MASK 64

sfrb UHINT = 0x9f;
#define DCONNI 0
#define DCONNI_BIT 0
#define DCONNI_MASK 1
#define DDISCI 1
#define DDISCI_BIT 1
#define DDISCI_MASK 2
#define RSTI 2
#define RSTI_BIT 2
#define RSTI_MASK 4
#define RSMEDI 3
#define RSMEDI_BIT 3
#define RSMEDI_MASK 8
#define RXRSMI 4
#define RXRSMI_BIT 4
#define RXRSMI_MASK 16
#define HSOFI 5
#define HSOFI_BIT 5
#define HSOFI_MASK 32
#define UHUPI 6
#define UHUPI_BIT 6
#define UHUPI_MASK 64

sfrb UDCON = 0xe0;
#define DETACH 0
#define DETACH_BIT 0
#define DETACH_MASK 1
#define RMWKUP 1
#define RMWKUP_BIT 1
#define RMWKUP_MASK 2
#define LSM 2
#define LSM_BIT 2
#define LSM_MASK 4

sfrb UHCON = 0x9e;
#define SOFEN 0
#define SOFEN_BIT 0
#define SOFEN_MASK 1
#define RESET 1
#define RESET_BIT 1
#define RESET_MASK 2
#define RESUME 2
#define RESUME_BIT 2
#define RESUME_MASK 4

sfrb OTGINT = 0xdf;
#define SRPI 0
#define SRPI_BIT 0
#define SRPI_MASK 1
#define VBERRI 1
#define VBERRI_BIT 1
#define VBERRI_MASK 2
#define BCERRI 2
#define BCERRI_BIT 2
#define BCERRI_MASK 4
#define ROLEEXI 3
#define ROLEEXI_BIT 3
#define ROLEEXI_MASK 8
#define HNPERRI 4
#define HNPERRI_BIT 4
#define HNPERRI_MASK 16
#define STOI 5
#define STOI_BIT 5
#define STOI_MASK 32

sfrb OTGIEN = 0xde;
#define SRPE 0
#define SRPE_BIT 0
#define SRPE_MASK 1
#define VBERRE 1
#define VBERRE_BIT 1
#define VBERRE_MASK 2
#define BCERRE 2
#define BCERRE_BIT 2
#define BCERRE_MASK 4
#define ROLEEXE 3
#define ROLEEXE_BIT 3
#define ROLEEXE_MASK 8
#define HNPERRE 4
#define HNPERRE_BIT 4
#define HNPERRE_MASK 16
#define STOE 5
#define STOE_BIT 5
#define STOE_MASK 32

sfrb OTGCON = 0xdd;
#define VBUSRQC 0
#define VBUSRQC_BIT 0
#define VBUSRQC_MASK 1
#define VBUSREQ 1
#define VBUSREQ_BIT 1
#define VBUSREQ_MASK 2
#define VBUSHWC 2
#define VBUSHWC_BIT 2
#define VBUSHWC_MASK 4
#define SRPSEL 3
#define SRPSEL_BIT 3
#define SRPSEL_MASK 8
#define SRPREQ 4
#define SRPREQ_BIT 4
#define SRPREQ_MASK 16
#define HNPREQ 5
#define HNPREQ_BIT 5
#define HNPREQ_MASK 32

sfrb OTGTCON = 0xf9;
#define VALUE_2_0 0
#define VALUE_2_0_BIT 0
#define VALUE_2_0_MASK 1
#define VALUE_2_1 1
#define VALUE_2_1_BIT 1
#define VALUE_2_1_MASK 2
#define VALUE_2 2
#define VALUE_2_BIT 2
#define VALUE_2_MASK 4
#define PAGE0 5
#define PAGE0_BIT 5
#define PAGE0_MASK 32
#define PAGE1 6
#define PAGE1_BIT 6
#define PAGE1_MASK 64
#define OTGTCON_7 7
#define OTGTCON_7_BIT 7
#define OTGTCON_7_MASK 128

sfrb UDPADDH = 0xdc;

sfrb UDPADDL = 0xdb;

sfrw UDPADDW = 0xdb;

sfrb USBINT = 0xda;
#define VBUSTI 0
#define VBUSTI_BIT 0
#define VBUSTI_MASK 1
#define IDTI 1
#define IDTI_BIT 1
#define IDTI_MASK 2

sfrb USBSTA = 0xd9;
#define VBUS 0
#define VBUS_BIT 0
#define VBUS_MASK 1
#define ID 1
#define ID_BIT 1
#define ID_MASK 2
#define SPEED 3
#define SPEED_BIT 3
#define SPEED_MASK 8

sfrb USBCON = 0xd8;
#define VBUSTE 0
#define VBUSTE_BIT 0
#define VBUSTE_MASK 1
#define IDTE 1
#define IDTE_BIT 1
#define IDTE_MASK 2
#define OTGPADE 4
#define OTGPADE_BIT 4
#define OTGPADE_MASK 16
#define FRZCLK 5
#define FRZCLK_BIT 5
#define FRZCLK_MASK 32
#define HOST 6
#define HOST_BIT 6
#define HOST_MASK 64
#define USBE 7
#define USBE_BIT 7
#define USBE_MASK 128

sfrb UHWCON = 0xd7;
#define UVREGE 0
#define UVREGE_BIT 0
#define UVREGE_MASK 1
#define UVCONE 4
#define UVCONE_BIT 4
#define UVCONE_MASK 16
#define UIDE 6
#define UIDE_BIT 6
#define UIDE_MASK 64
#define UIMOD 7
#define UIMOD_BIT 7
#define UIMOD_MASK 128

sfrb UDR1 = 0xce;
#define UDR1_0 0
#define UDR1_0_BIT 0
#define UDR1_0_MASK 1
#define UDR1_1 1
#define UDR1_1_BIT 1
#define UDR1_1_MASK 2
#define UDR1_2 2
#define UDR1_2_BIT 2
#define UDR1_2_MASK 4
#define UDR1_3 3
#define UDR1_3_BIT 3
#define UDR1_3_MASK 8
#define UDR1_4 4
#define UDR1_4_BIT 4
#define UDR1_4_MASK 16
#define UDR1_5 5
#define UDR1_5_BIT 5
#define UDR1_5_MASK 32
#define UDR1_6 6
#define UDR1_6_BIT 6
#define UDR1_6_MASK 64
#define UDR1_7 7
#define UDR1_7_BIT 7
#define UDR1_7_MASK 128

sfrb UBRR1H = 0xcd;
#define UBRR8 0
#define UBRR8_BIT 0
#define UBRR8_MASK 1
#define UBRR9 1
#define UBRR9_BIT 1
#define UBRR9_MASK 2
#define UBRR10 2
#define UBRR10_BIT 2
#define UBRR10_MASK 4
#define UBRR11 3
#define UBRR11_BIT 3
#define UBRR11_MASK 8

sfrb UBRR1L = 0xcc;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrw UBRR1W = 0xcc;

sfrb UCSR1C = 0xca;
#define UCPOL1 0
#define UCPOL1_BIT 0
#define UCPOL1_MASK 1
#define UCSZ10 1
#define UCSZ10_BIT 1
#define UCSZ10_MASK 2
#define UCSZ11 2
#define UCSZ11_BIT 2
#define UCSZ11_MASK 4
#define USBS1 3
#define USBS1_BIT 3
#define USBS1_MASK 8
#define UPM10 4
#define UPM10_BIT 4
#define UPM10_MASK 16
#define UPM11 5
#define UPM11_BIT 5
#define UPM11_MASK 32
#define UMSEL10 6
#define UMSEL10_BIT 6
#define UMSEL10_MASK 64
#define UMSEL11 7
#define UMSEL11_BIT 7
#define UMSEL11_MASK 128

sfrb UCSR1B = 0xc9;
#define TXB81 0
#define TXB81_BIT 0
#define TXB81_MASK 1
#define RXB81 1
#define RXB81_BIT 1
#define RXB81_MASK 2
#define UCSZ12 2
#define UCSZ12_BIT 2
#define UCSZ12_MASK 4
#define TXEN1 3
#define TXEN1_BIT 3
#define TXEN1_MASK 8
#define RXEN1 4
#define RXEN1_BIT 4
#define RXEN1_MASK 16
#define UDRIE1 5
#define UDRIE1_BIT 5
#define UDRIE1_MASK 32
#define TXCIE1 6
#define TXCIE1_BIT 6
#define TXCIE1_MASK 64
#define RXCIE1 7
#define RXCIE1_BIT 7
#define RXCIE1_MASK 128

sfrb UCSR1A = 0xc8;
#define MPCM1 0
#define MPCM1_BIT 0
#define MPCM1_MASK 1
#define U2X1 1
#define U2X1_BIT 1
#define U2X1_MASK 2
#define UPE1 2
#define UPE1_BIT 2
#define UPE1_MASK 4
#define DOR1 3
#define DOR1_BIT 3
#define DOR1_MASK 8
#define FE1 4
#define FE1_BIT 4
#define FE1_MASK 16
#define UDRE1 5
#define UDRE1_BIT 5
#define UDRE1_MASK 32
#define TXC1 6
#define TXC1_BIT 6
#define TXC1_MASK 64
#define RXC1 7
#define RXC1_BIT 7
#define RXC1_MASK 128

sfrb TWAMR = 0xbd;
#define TWAM0 1
#define TWAM0_BIT 1
#define TWAM0_MASK 2
#define TWAM1 2
#define TWAM1_BIT 2
#define TWAM1_MASK 4
#define TWAM2 3
#define TWAM2_BIT 3
#define TWAM2_MASK 8
#define TWAM3 4
#define TWAM3_BIT 4
#define TWAM3_MASK 16
#define TWAM4 5
#define TWAM4_BIT 5
#define TWAM4_MASK 32
#define TWAM5 6
#define TWAM5_BIT 6
#define TWAM5_MASK 64
#define TWAM6 7
#define TWAM6_BIT 7
#define TWAM6_MASK 128

sfrb TWCR = 0xbc;
#define TWIE 0
#define TWIE_BIT 0
#define TWIE_MASK 1
#define TWEN 2
#define TWEN_BIT 2
#define TWEN_MASK 4
#define TWWC 3
#define TWWC_BIT 3
#define TWWC_MASK 8
#define TWSTO 4
#define TWSTO_BIT 4
#define TWSTO_MASK 16
#define TWSTA 5
#define TWSTA_BIT 5
#define TWSTA_MASK 32
#define TWEA 6
#define TWEA_BIT 6
#define TWEA_MASK 64
#define TWINT 7
#define TWINT_BIT 7
#define TWINT_MASK 128

sfrb TWDR = 0xbb;
#define TWD0 0
#define TWD0_BIT 0
#define TWD0_MASK 1
#define TWD1 1
#define TWD1_BIT 1
#define TWD1_MASK 2
#define TWD2 2
#define TWD2_BIT 2
#define TWD2_MASK 4
#define TWD3 3
#define TWD3_BIT 3
#define TWD3_MASK 8
#define TWD4 4
#define TWD4_BIT 4
#define TWD4_MASK 16
#define TWD5 5
#define TWD5_BIT 5
#define TWD5_MASK 32
#define TWD6 6
#define TWD6_BIT 6
#define TWD6_MASK 64
#define TWD7 7
#define TWD7_BIT 7
#define TWD7_MASK 128

sfrb TWAR = 0xba;
#define TWGCE 0
#define TWGCE_BIT 0
#define TWGCE_MASK 1
#define TWA0 1
#define TWA0_BIT 1
#define TWA0_MASK 2
#define TWA1 2
#define TWA1_BIT 2
#define TWA1_MASK 4
#define TWA2 3
#define TWA2_BIT 3
#define TWA2_MASK 8
#define TWA3 4
#define TWA3_BIT 4
#define TWA3_MASK 16
#define TWA4 5
#define TWA4_BIT 5
#define TWA4_MASK 32
#define TWA5 6
#define TWA5_BIT 6
#define TWA5_MASK 64
#define TWA6 7
#define TWA6_BIT 7
#define TWA6_MASK 128

sfrb TWSR = 0xb9;
#define TWPS0 0
#define TWPS0_BIT 0
#define TWPS0_MASK 1
#define TWPS1 1
#define TWPS1_BIT 1
#define TWPS1_MASK 2
#define TWS3 3
#define TWS3_BIT 3
#define TWS3_MASK 8
#define TWS4 4
#define TWS4_BIT 4
#define TWS4_MASK 16
#define TWS5 5
#define TWS5_BIT 5
#define TWS5_MASK 32
#define TWS6 6
#define TWS6_BIT 6
#define TWS6_MASK 64
#define TWS7 7
#define TWS7_BIT 7
#define TWS7_MASK 128

sfrb TWBR = 0xb8;
#define TWBR0 0
#define TWBR0_BIT 0
#define TWBR0_MASK 1
#define TWBR1 1
#define TWBR1_BIT 1
#define TWBR1_MASK 2
#define TWBR2 2
#define TWBR2_BIT 2
#define TWBR2_MASK 4
#define TWBR3 3
#define TWBR3_BIT 3
#define TWBR3_MASK 8
#define TWBR4 4
#define TWBR4_BIT 4
#define TWBR4_MASK 16
#define TWBR5 5
#define TWBR5_BIT 5
#define TWBR5_MASK 32
#define TWBR6 6
#define TWBR6_BIT 6
#define TWBR6_MASK 64
#define TWBR7 7
#define TWBR7_BIT 7
#define TWBR7_MASK 128

sfrb ASSR = 0xb6;
#define TCR2BUB 0
#define TCR2BUB_BIT 0
#define TCR2BUB_MASK 1
#define TCR2AUB 1
#define TCR2AUB_BIT 1
#define TCR2AUB_MASK 2
#define OCR2BUB 2
#define OCR2BUB_BIT 2
#define OCR2BUB_MASK 4
#define OCR2AUB 3
#define OCR2AUB_BIT 3
#define OCR2AUB_MASK 8
#define TCN2UB 4
#define TCN2UB_BIT 4
#define TCN2UB_MASK 16
#define AS2 5
#define AS2_BIT 5
#define AS2_MASK 32
#define EXCLK 6
#define EXCLK_BIT 6
#define EXCLK_MASK 64

sfrb OCR2B = 0xb4;
#define OCR2_0 0
#define OCR2_0_BIT 0
#define OCR2_0_MASK 1
#define OCR2_1 1
#define OCR2_1_BIT 1
#define OCR2_1_MASK 2
#define OCR2_2 2
#define OCR2_2_BIT 2
#define OCR2_2_MASK 4
#define OCR2_3 3
#define OCR2_3_BIT 3
#define OCR2_3_MASK 8
#define OCR2_4 4
#define OCR2_4_BIT 4
#define OCR2_4_MASK 16
#define OCR2_5 5
#define OCR2_5_BIT 5
#define OCR2_5_MASK 32
#define OCR2_6 6
#define OCR2_6_BIT 6
#define OCR2_6_MASK 64
#define OCR2_7 7
#define OCR2_7_BIT 7
#define OCR2_7_MASK 128

sfrb OCR2A = 0xb3;
#define OCR2_0 0
#define OCR2_0_BIT 0
#define OCR2_0_MASK 1
#define OCR2_1 1
#define OCR2_1_BIT 1
#define OCR2_1_MASK 2
#define OCR2_2 2
#define OCR2_2_BIT 2
#define OCR2_2_MASK 4
#define OCR2_3 3
#define OCR2_3_BIT 3
#define OCR2_3_MASK 8
#define OCR2_4 4
#define OCR2_4_BIT 4
#define OCR2_4_MASK 16
#define OCR2_5 5
#define OCR2_5_BIT 5
#define OCR2_5_MASK 32
#define OCR2_6 6
#define OCR2_6_BIT 6
#define OCR2_6_MASK 64
#define OCR2_7 7
#define OCR2_7_BIT 7
#define OCR2_7_MASK 128

sfrb TCNT2 = 0xb2;
#define TCNT2_0 0
#define TCNT2_0_BIT 0
#define TCNT2_0_MASK 1
#define TCNT2_1 1
#define TCNT2_1_BIT 1
#define TCNT2_1_MASK 2
#define TCNT2_2 2
#define TCNT2_2_BIT 2
#define TCNT2_2_MASK 4
#define TCNT2_3 3
#define TCNT2_3_BIT 3
#define TCNT2_3_MASK 8
#define TCNT2_4 4
#define TCNT2_4_BIT 4
#define TCNT2_4_MASK 16
#define TCNT2_5 5
#define TCNT2_5_BIT 5
#define TCNT2_5_MASK 32
#define TCNT2_6 6
#define TCNT2_6_BIT 6
#define TCNT2_6_MASK 64
#define TCNT2_7 7
#define TCNT2_7_BIT 7
#define TCNT2_7_MASK 128

sfrb TCCR2B = 0xb1;
#define CS20 0
#define CS20_BIT 0
#define CS20_MASK 1
#define CS21 1
#define CS21_BIT 1
#define CS21_MASK 2
#define CS22 2
#define CS22_BIT 2
#define CS22_MASK 4
#define WGM22 3
#define WGM22_BIT 3
#define WGM22_MASK 8
#define FOC2B 6
#define FOC2B_BIT 6
#define FOC2B_MASK 64
#define FOC2A 7
#define FOC2A_BIT 7
#define FOC2A_MASK 128

sfrb TCCR2A = 0xb0;
#define WGM20 0
#define WGM20_BIT 0
#define WGM20_MASK 1
#define WGM21 1
#define WGM21_BIT 1
#define WGM21_MASK 2
#define COM2B0 4
#define COM2B0_BIT 4
#define COM2B0_MASK 16
#define COM2B1 5
#define COM2B1_BIT 5
#define COM2B1_MASK 32
#define COM2A0 6
#define COM2A0_BIT 6
#define COM2A0_MASK 64
#define COM2A1 7
#define COM2A1_BIT 7
#define COM2A1_MASK 128

sfrb OCR3CH = 0x9d;
#define OCR3CH0 0
#define OCR3CH0_BIT 0
#define OCR3CH0_MASK 1
#define OCR3CH1 1
#define OCR3CH1_BIT 1
#define OCR3CH1_MASK 2
#define OCR3CH2 2
#define OCR3CH2_BIT 2
#define OCR3CH2_MASK 4
#define OCR3CH3 3
#define OCR3CH3_BIT 3
#define OCR3CH3_MASK 8
#define OCR3CH4 4
#define OCR3CH4_BIT 4
#define OCR3CH4_MASK 16
#define OCR3CH5 5
#define OCR3CH5_BIT 5
#define OCR3CH5_MASK 32
#define OCR3CH6 6
#define OCR3CH6_BIT 6
#define OCR3CH6_MASK 64
#define OCR3CH7 7
#define OCR3CH7_BIT 7
#define OCR3CH7_MASK 128

sfrb OCR3CL = 0x9c;
#define OCR3CL0 0
#define OCR3CL0_BIT 0
#define OCR3CL0_MASK 1
#define OCR3CL1 1
#define OCR3CL1_BIT 1
#define OCR3CL1_MASK 2
#define OCR3CL2 2
#define OCR3CL2_BIT 2
#define OCR3CL2_MASK 4
#define OCR3CL3 3
#define OCR3CL3_BIT 3
#define OCR3CL3_MASK 8
#define OCR3CL4 4
#define OCR3CL4_BIT 4
#define OCR3CL4_MASK 16
#define OCR3CL5 5
#define OCR3CL5_BIT 5
#define OCR3CL5_MASK 32
#define OCR3CL6 6
#define OCR3CL6_BIT 6
#define OCR3CL6_MASK 64
#define OCR3CL7 7
#define OCR3CL7_BIT 7
#define OCR3CL7_MASK 128

sfrw OCR3CW = 0x9c;

sfrb OCR3BH = 0x9b;
#define OCR3BH0 0
#define OCR3BH0_BIT 0
#define OCR3BH0_MASK 1
#define OCR3BH1 1
#define OCR3BH1_BIT 1
#define OCR3BH1_MASK 2
#define OCR3BH2 2
#define OCR3BH2_BIT 2
#define OCR3BH2_MASK 4
#define OCR3BH3 3
#define OCR3BH3_BIT 3
#define OCR3BH3_MASK 8
#define OCR3BH4 4
#define OCR3BH4_BIT 4
#define OCR3BH4_MASK 16
#define OCR3BH5 5
#define OCR3BH5_BIT 5
#define OCR3BH5_MASK 32
#define OCR3BH6 6
#define OCR3BH6_BIT 6
#define OCR3BH6_MASK 64
#define OCR3BH7 7
#define OCR3BH7_BIT 7
#define OCR3BH7_MASK 128

sfrb OCR3BL = 0x9a;
#define OCR3BL0 0
#define OCR3BL0_BIT 0
#define OCR3BL0_MASK 1
#define OCR3BL1 1
#define OCR3BL1_BIT 1
#define OCR3BL1_MASK 2
#define OCR3BL2 2
#define OCR3BL2_BIT 2
#define OCR3BL2_MASK 4
#define OCR3BL3 3
#define OCR3BL3_BIT 3
#define OCR3BL3_MASK 8
#define OCR3BL4 4
#define OCR3BL4_BIT 4
#define OCR3BL4_MASK 16
#define OCR3BL5 5
#define OCR3BL5_BIT 5
#define OCR3BL5_MASK 32
#define OCR3BL6 6
#define OCR3BL6_BIT 6
#define OCR3BL6_MASK 64
#define OCR3BL7 7
#define OCR3BL7_BIT 7
#define OCR3BL7_MASK 128

sfrw OCR3BW = 0x9a;

sfrb OCR3AH = 0x99;
#define OCR3AH0 0
#define OCR3AH0_BIT 0
#define OCR3AH0_MASK 1
#define OCR3AH1 1
#define OCR3AH1_BIT 1
#define OCR3AH1_MASK 2
#define OCR3AH2 2
#define OCR3AH2_BIT 2
#define OCR3AH2_MASK 4
#define OCR3AH3 3
#define OCR3AH3_BIT 3
#define OCR3AH3_MASK 8
#define OCR3AH4 4
#define OCR3AH4_BIT 4
#define OCR3AH4_MASK 16
#define OCR3AH5 5
#define OCR3AH5_BIT 5
#define OCR3AH5_MASK 32
#define OCR3AH6 6
#define OCR3AH6_BIT 6
#define OCR3AH6_MASK 64
#define OCR3AH7 7
#define OCR3AH7_BIT 7
#define OCR3AH7_MASK 128

sfrb OCR3AL = 0x98;
#define OCR3AL0 0
#define OCR3AL0_BIT 0
#define OCR3AL0_MASK 1
#define OCR3AL1 1
#define OCR3AL1_BIT 1
#define OCR3AL1_MASK 2
#define OCR3AL2 2
#define OCR3AL2_BIT 2
#define OCR3AL2_MASK 4
#define OCR3AL3 3
#define OCR3AL3_BIT 3
#define OCR3AL3_MASK 8
#define OCR3AL4 4
#define OCR3AL4_BIT 4
#define OCR3AL4_MASK 16
#define OCR3AL5 5
#define OCR3AL5_BIT 5
#define OCR3AL5_MASK 32
#define OCR3AL6 6
#define OCR3AL6_BIT 6
#define OCR3AL6_MASK 64
#define OCR3AL7 7
#define OCR3AL7_BIT 7
#define OCR3AL7_MASK 128

sfrw OCR3AW = 0x98;

sfrb ICR3H = 0x97;
#define ICR3H0 0
#define ICR3H0_BIT 0
#define ICR3H0_MASK 1
#define ICR3H1 1
#define ICR3H1_BIT 1
#define ICR3H1_MASK 2
#define ICR3H2 2
#define ICR3H2_BIT 2
#define ICR3H2_MASK 4
#define ICR3H3 3
#define ICR3H3_BIT 3
#define ICR3H3_MASK 8
#define ICR3H4 4
#define ICR3H4_BIT 4
#define ICR3H4_MASK 16
#define ICR3H5 5
#define ICR3H5_BIT 5
#define ICR3H5_MASK 32
#define ICR3H6 6
#define ICR3H6_BIT 6
#define ICR3H6_MASK 64
#define ICR3H7 7
#define ICR3H7_BIT 7
#define ICR3H7_MASK 128

sfrb ICR3L = 0x96;
#define ICR3L0 0
#define ICR3L0_BIT 0
#define ICR3L0_MASK 1
#define ICR3L1 1
#define ICR3L1_BIT 1
#define ICR3L1_MASK 2
#define ICR3L2 2
#define ICR3L2_BIT 2
#define ICR3L2_MASK 4
#define ICR3L3 3
#define ICR3L3_BIT 3
#define ICR3L3_MASK 8
#define ICR3L4 4
#define ICR3L4_BIT 4
#define ICR3L4_MASK 16
#define ICR3L5 5
#define ICR3L5_BIT 5
#define ICR3L5_MASK 32
#define ICR3L6 6
#define ICR3L6_BIT 6
#define ICR3L6_MASK 64
#define ICR3L7 7
#define ICR3L7_BIT 7
#define ICR3L7_MASK 128

sfrw ICR3W = 0x96;

sfrb TCNT3H = 0x95;
#define TCNT3H0 0
#define TCNT3H0_BIT 0
#define TCNT3H0_MASK 1
#define TCNT3H1 1
#define TCNT3H1_BIT 1
#define TCNT3H1_MASK 2
#define TCNT3H2 2
#define TCNT3H2_BIT 2
#define TCNT3H2_MASK 4
#define TCNT3H3 3
#define TCNT3H3_BIT 3
#define TCNT3H3_MASK 8
#define TCNT3H4 4
#define TCNT3H4_BIT 4
#define TCNT3H4_MASK 16
#define TCNT3H5 5
#define TCNT3H5_BIT 5
#define TCNT3H5_MASK 32
#define TCNT3H6 6
#define TCNT3H6_BIT 6
#define TCNT3H6_MASK 64
#define TCNT3H7 7
#define TCNT3H7_BIT 7
#define TCNT3H7_MASK 128

sfrb TCNT3L = 0x94;
#define TCNT3L0 0
#define TCNT3L0_BIT 0
#define TCNT3L0_MASK 1
#define TCNT3L1 1
#define TCNT3L1_BIT 1
#define TCNT3L1_MASK 2
#define TCNT3L2 2
#define TCNT3L2_BIT 2
#define TCNT3L2_MASK 4
#define TCNT3L3 3
#define TCNT3L3_BIT 3
#define TCNT3L3_MASK 8
#define TCNT3L4 4
#define TCNT3L4_BIT 4
#define TCNT3L4_MASK 16
#define TCNT3L5 5
#define TCNT3L5_BIT 5
#define TCNT3L5_MASK 32
#define TCNT3L6 6
#define TCNT3L6_BIT 6
#define TCNT3L6_MASK 64
#define TCNT3L7 7
#define TCNT3L7_BIT 7
#define TCNT3L7_MASK 128

sfrw TCNT3W = 0x94;

sfrb TCCR3C = 0x92;
#define FOC3C 5
#define FOC3C_BIT 5
#define FOC3C_MASK 32
#define FOC3B 6
#define FOC3B_BIT 6
#define FOC3B_MASK 64
#define FOC3A 7
#define FOC3A_BIT 7
#define FOC3A_MASK 128

sfrb TCCR3B = 0x91;
#define CS30 0
#define CS30_BIT 0
#define CS30_MASK 1
#define CS31 1
#define CS31_BIT 1
#define CS31_MASK 2
#define CS32 2
#define CS32_BIT 2
#define CS32_MASK 4
#define WGM32 3
#define WGM32_BIT 3
#define WGM32_MASK 8
#define WGM33 4
#define WGM33_BIT 4
#define WGM33_MASK 16
#define ICES3 6
#define ICES3_BIT 6
#define ICES3_MASK 64
#define ICNC3 7
#define ICNC3_BIT 7
#define ICNC3_MASK 128

sfrb TCCR3A = 0x90;
#define WGM30 0
#define WGM30_BIT 0
#define WGM30_MASK 1
#define WGM31 1
#define WGM31_BIT 1
#define WGM31_MASK 2
#define COM3C0 2
#define COM3C0_BIT 2
#define COM3C0_MASK 4
#define COM3C1 3
#define COM3C1_BIT 3
#define COM3C1_MASK 8
#define COM3B0 4
#define COM3B0_BIT 4
#define COM3B0_MASK 16
#define COM3B1 5
#define COM3B1_BIT 5
#define COM3B1_MASK 32
#define COM3A0 6
#define COM3A0_BIT 6
#define COM3A0_MASK 64
#define COM3A1 7
#define COM3A1_BIT 7
#define COM3A1_MASK 128

sfrb OCR1CH = 0x8d;
#define OCR1CH0 0
#define OCR1CH0_BIT 0
#define OCR1CH0_MASK 1
#define OCR1CH1 1
#define OCR1CH1_BIT 1
#define OCR1CH1_MASK 2
#define OCR1CH2 2
#define OCR1CH2_BIT 2
#define OCR1CH2_MASK 4
#define OCR1CH3 3
#define OCR1CH3_BIT 3
#define OCR1CH3_MASK 8
#define OCR1CH4 4
#define OCR1CH4_BIT 4
#define OCR1CH4_MASK 16
#define OCR1CH5 5
#define OCR1CH5_BIT 5
#define OCR1CH5_MASK 32
#define OCR1CH6 6
#define OCR1CH6_BIT 6
#define OCR1CH6_MASK 64
#define OCR1CH7 7
#define OCR1CH7_BIT 7
#define OCR1CH7_MASK 128

sfrb OCR1CL = 0x8c;
#define OCR1CL0 0
#define OCR1CL0_BIT 0
#define OCR1CL0_MASK 1
#define OCR1CL1 1
#define OCR1CL1_BIT 1
#define OCR1CL1_MASK 2
#define OCR1CL2 2
#define OCR1CL2_BIT 2
#define OCR1CL2_MASK 4
#define OCR1CL3 3
#define OCR1CL3_BIT 3
#define OCR1CL3_MASK 8
#define OCR1CL4 4
#define OCR1CL4_BIT 4
#define OCR1CL4_MASK 16
#define OCR1CL5 5
#define OCR1CL5_BIT 5
#define OCR1CL5_MASK 32
#define OCR1CL6 6
#define OCR1CL6_BIT 6
#define OCR1CL6_MASK 64
#define OCR1CL7 7
#define OCR1CL7_BIT 7
#define OCR1CL7_MASK 128

sfrw OCR1CW = 0x8c;

sfrb OCR1BH = 0x8b;
#define OCR1BH0 0
#define OCR1BH0_BIT 0
#define OCR1BH0_MASK 1
#define OCR1BH1 1
#define OCR1BH1_BIT 1
#define OCR1BH1_MASK 2
#define OCR1BH2 2
#define OCR1BH2_BIT 2
#define OCR1BH2_MASK 4
#define OCR1BH3 3
#define OCR1BH3_BIT 3
#define OCR1BH3_MASK 8
#define OCR1BH4 4
#define OCR1BH4_BIT 4
#define OCR1BH4_MASK 16
#define OCR1BH5 5
#define OCR1BH5_BIT 5
#define OCR1BH5_MASK 32
#define OCR1BH6 6
#define OCR1BH6_BIT 6
#define OCR1BH6_MASK 64
#define OCR1BH7 7
#define OCR1BH7_BIT 7
#define OCR1BH7_MASK 128

sfrb OCR1BL = 0x8a;
#define OCR1BL0 0
#define OCR1BL0_BIT 0
#define OCR1BL0_MASK 1
#define OCR1BL1 1
#define OCR1BL1_BIT 1
#define OCR1BL1_MASK 2
#define OCR1BL2 2
#define OCR1BL2_BIT 2
#define OCR1BL2_MASK 4
#define OCR1BL3 3
#define OCR1BL3_BIT 3
#define OCR1BL3_MASK 8
#define OCR1BL4 4
#define OCR1BL4_BIT 4
#define OCR1BL4_MASK 16
#define OCR1BL5 5
#define OCR1BL5_BIT 5
#define OCR1BL5_MASK 32
#define OCR1BL6 6
#define OCR1BL6_BIT 6
#define OCR1BL6_MASK 64
#define OCR1BL7 7
#define OCR1BL7_BIT 7
#define OCR1BL7_MASK 128

sfrw OCR1BW = 0x8a;

sfrb OCR1AH = 0x89;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x88;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x88;

sfrb ICR1H = 0x87;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x86;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x86;

sfrb TCNT1H = 0x85;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x84;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x84;

sfrb TCCR1C = 0x82;
#define FOC1C 5
#define FOC1C_BIT 5
#define FOC1C_MASK 32
#define FOC1B 6
#define FOC1B_BIT 6
#define FOC1B_MASK 64
#define FOC1A 7
#define FOC1A_BIT 7
#define FOC1A_MASK 128

sfrb TCCR1B = 0x81;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define WGM12 3
#define WGM12_BIT 3
#define WGM12_MASK 8
#define WGM13 4
#define WGM13_BIT 4
#define WGM13_MASK 16
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCCR1A = 0x80;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define COM1C0 2
#define COM1C0_BIT 2
#define COM1C0_MASK 4
#define COM1C1 3
#define COM1C1_BIT 3
#define COM1C1_MASK 8
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb DIDR1 = 0x7f;
#define AIN0D 0
#define AIN0D_BIT 0
#define AIN0D_MASK 1
#define AIN1D 1
#define AIN1D_BIT 1
#define AIN1D_MASK 2

sfrb DIDR0 = 0x7e;
#define ADC0D 0
#define ADC0D_BIT 0
#define ADC0D_MASK 1
#define ADC1D 1
#define ADC1D_BIT 1
#define ADC1D_MASK 2
#define ADC2D 2
#define ADC2D_BIT 2
#define ADC2D_MASK 4
#define ADC3D 3
#define ADC3D_BIT 3
#define ADC3D_MASK 8
#define ADC4D 4
#define ADC4D_BIT 4
#define ADC4D_MASK 16
#define ADC5D 5
#define ADC5D_BIT 5
#define ADC5D_MASK 32
#define ADC6D 6
#define ADC6D_BIT 6
#define ADC6D_MASK 64
#define ADC7D 7
#define ADC7D_BIT 7
#define ADC7D_MASK 128

sfrb DIDR2 = 0x7d;

sfrb ADMUX = 0x7c;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define MUX2 2
#define MUX2_BIT 2
#define MUX2_MASK 4
#define MUX3 3
#define MUX3_BIT 3
#define MUX3_MASK 8
#define MUX4 4
#define MUX4_BIT 4
#define MUX4_MASK 16
#define ADLAR 5
#define ADLAR_BIT 5
#define ADLAR_MASK 32
#define REFS0 6
#define REFS0_BIT 6
#define REFS0_MASK 64
#define REFS1 7
#define REFS1_BIT 7
#define REFS1_MASK 128

sfrb ADCSRB = 0x7b;
#define ADTS0 0
#define ADTS0_BIT 0
#define ADTS0_MASK 1
#define ADTS1 1
#define ADTS1_BIT 1
#define ADTS1_MASK 2
#define ADTS2 2
#define ADTS2_BIT 2
#define ADTS2_MASK 4
#define ACME 6
#define ACME_BIT 6
#define ACME_MASK 64
#define ADHSM 7
#define ADHSM_BIT 7
#define ADHSM_MASK 128

sfrb ADCSRA = 0x7a;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADATE 5
#define ADATE_BIT 5
#define ADATE_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x79;
#define ADCH0 0
#define ADCH0_BIT 0
#define ADCH0_MASK 1
#define ADCH1 1
#define ADCH1_BIT 1
#define ADCH1_MASK 2
#define ADCH2 2
#define ADCH2_BIT 2
#define ADCH2_MASK 4
#define ADCH3 3
#define ADCH3_BIT 3
#define ADCH3_MASK 8
#define ADCH4 4
#define ADCH4_BIT 4
#define ADCH4_MASK 16
#define ADCH5 5
#define ADCH5_BIT 5
#define ADCH5_MASK 32
#define ADCH6 6
#define ADCH6_BIT 6
#define ADCH6_MASK 64
#define ADCH7 7
#define ADCH7_BIT 7
#define ADCH7_MASK 128

sfrb ADCL = 0x78;
#define ADCL0 0
#define ADCL0_BIT 0
#define ADCL0_MASK 1
#define ADCL1 1
#define ADCL1_BIT 1
#define ADCL1_MASK 2
#define ADCL2 2
#define ADCL2_BIT 2
#define ADCL2_MASK 4
#define ADCL3 3
#define ADCL3_BIT 3
#define ADCL3_MASK 8
#define ADCL4 4
#define ADCL4_BIT 4
#define ADCL4_MASK 16
#define ADCL5 5
#define ADCL5_BIT 5
#define ADCL5_MASK 32
#define ADCL6 6
#define ADCL6_BIT 6
#define ADCL6_MASK 64
#define ADCL7 7
#define ADCL7_BIT 7
#define ADCL7_MASK 128

sfrw ADCW = 0x78;

sfrb XMCRB = 0x75;
#define XMM0 0
#define XMM0_BIT 0
#define XMM0_MASK 1
#define XMM1 1
#define XMM1_BIT 1
#define XMM1_MASK 2
#define XMM2 2
#define XMM2_BIT 2
#define XMM2_MASK 4
#define XMBK 7
#define XMBK_BIT 7
#define XMBK_MASK 128

sfrb XMCRA = 0x74;
#define SRW00 0
#define SRW00_BIT 0
#define SRW00_MASK 1
#define SRW01 1
#define SRW01_BIT 1
#define SRW01_MASK 2
#define SRW10 2
#define SRW10_BIT 2
#define SRW10_MASK 4
#define SRW11 3
#define SRW11_BIT 3
#define SRW11_MASK 8
#define SRL0 4
#define SRL0_BIT 4
#define SRL0_MASK 16
#define SRL1 5
#define SRL1_BIT 5
#define SRL1_MASK 32
#define SRL2 6
#define SRL2_BIT 6
#define SRL2_MASK 64
#define SRE 7
#define SRE_BIT 7
#define SRE_MASK 128

sfrb TIMSK5 = 0x73;

sfrb TIMSK4 = 0x72;

sfrb TIMSK3 = 0x71;
#define TOIE3 0
#define TOIE3_BIT 0
#define TOIE3_MASK 1
#define OCIE3A 1
#define OCIE3A_BIT 1
#define OCIE3A_MASK 2
#define OCIE3B 2
#define OCIE3B_BIT 2
#define OCIE3B_MASK 4
#define OCIE3C 3
#define OCIE3C_BIT 3
#define OCIE3C_MASK 8
#define ICIE3 5
#define ICIE3_BIT 5
#define ICIE3_MASK 32

sfrb TIMSK2 = 0x70;
#define TOIE2 0
#define TOIE2_BIT 0
#define TOIE2_MASK 1
#define OCIE2A 1
#define OCIE2A_BIT 1
#define OCIE2A_MASK 2
#define OCIE2B 2
#define OCIE2B_BIT 2
#define OCIE2B_MASK 4

sfrb TIMSK1 = 0x6f;
#define TOIE1 0
#define TOIE1_BIT 0
#define TOIE1_MASK 1
#define OCIE1A 1
#define OCIE1A_BIT 1
#define OCIE1A_MASK 2
#define OCIE1B 2
#define OCIE1B_BIT 2
#define OCIE1B_MASK 4
#define OCIE1C 3
#define OCIE1C_BIT 3
#define OCIE1C_MASK 8
#define ICIE1 5
#define ICIE1_BIT 5
#define ICIE1_MASK 32

sfrb TIMSK0 = 0x6e;
#define TOIE0 0
#define TOIE0_BIT 0
#define TOIE0_MASK 1
#define OCIE0A 1
#define OCIE0A_BIT 1
#define OCIE0A_MASK 2
#define OCIE0B 2
#define OCIE0B_BIT 2
#define OCIE0B_MASK 4

sfrb PCMSK2 = 0x6d;

sfrb PCMSK1 = 0x6c;

sfrb PCMSK0 = 0x6b;
#define PCINT0 0
#define PCINT0_BIT 0
#define PCINT0_MASK 1
#define PCINT1 1
#define PCINT1_BIT 1
#define PCINT1_MASK 2
#define PCINT2 2
#define PCINT2_BIT 2
#define PCINT2_MASK 4
#define PCINT3 3
#define PCINT3_BIT 3
#define PCINT3_MASK 8
#define PCINT4 4
#define PCINT4_BIT 4
#define PCINT4_MASK 16
#define PCINT5 5
#define PCINT5_BIT 5
#define PCINT5_MASK 32
#define PCINT6 6
#define PCINT6_BIT 6
#define PCINT6_MASK 64
#define PCINT7 7
#define PCINT7_BIT 7
#define PCINT7_MASK 128

sfrb EICRB = 0x6a;
#define ISC40 0
#define ISC40_BIT 0
#define ISC40_MASK 1
#define ISC41 1
#define ISC41_BIT 1
#define ISC41_MASK 2
#define ISC50 2
#define ISC50_BIT 2
#define ISC50_MASK 4
#define ISC51 3
#define ISC51_BIT 3
#define ISC51_MASK 8
#define ISC60 4
#define ISC60_BIT 4
#define ISC60_MASK 16
#define ISC61 5
#define ISC61_BIT 5
#define ISC61_MASK 32
#define ISC70 6
#define ISC70_BIT 6
#define ISC70_MASK 64
#define ISC71 7
#define ISC71_BIT 7
#define ISC71_MASK 128

sfrb EICRA = 0x69;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ISC10 2
#define ISC10_BIT 2
#define ISC10_MASK 4
#define ISC11 3
#define ISC11_BIT 3
#define ISC11_MASK 8
#define ISC20 4
#define ISC20_BIT 4
#define ISC20_MASK 16
#define ISC21 5
#define ISC21_BIT 5
#define ISC21_MASK 32
#define ISC30 6
#define ISC30_BIT 6
#define ISC30_MASK 64
#define ISC31 7
#define ISC31_BIT 7
#define ISC31_MASK 128

sfrb PCICR = 0x68;
#define PCIE0 0
#define PCIE0_BIT 0
#define PCIE0_MASK 1
#define PCIE1 1
#define PCIE1_BIT 1
#define PCIE1_MASK 2
#define PCIE2 2
#define PCIE2_BIT 2
#define PCIE2_MASK 4

sfrb OSCCAL = 0x66;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64
#define CAL7 7
#define CAL7_BIT 7
#define CAL7_MASK 128

sfrb PRR1 = 0x65;
#define PRUSART1 0
#define PRUSART1_BIT 0
#define PRUSART1_MASK 1
#define PRUSART2 1
#define PRUSART2_BIT 1
#define PRUSART2_MASK 2
#define PRUSART3 2
#define PRUSART3_BIT 2
#define PRUSART3_MASK 4
#define PRTIM3 3
#define PRTIM3_BIT 3
#define PRTIM3_MASK 8
#define PRTIM4 4
#define PRTIM4_BIT 4
#define PRTIM4_MASK 16
#define PRTIM5 5
#define PRTIM5_BIT 5
#define PRTIM5_MASK 32

sfrb PRR0 = 0x64;
#define PRADC 0
#define PRADC_BIT 0
#define PRADC_MASK 1
#define PRUSART0 1
#define PRUSART0_BIT 1
#define PRUSART0_MASK 2
#define PRSPI 2
#define PRSPI_BIT 2
#define PRSPI_MASK 4
#define PRTIM1 3
#define PRTIM1_BIT 3
#define PRTIM1_MASK 8
#define PRTIM0 5
#define PRTIM0_BIT 5
#define PRTIM0_MASK 32
#define PRTIM2 6
#define PRTIM2_BIT 6
#define PRTIM2_MASK 64
#define PRTWI 7
#define PRTWI_BIT 7
#define PRTWI_MASK 128

sfrb CLKPR = 0x61;
#define CLKPS0 0
#define CLKPS0_BIT 0
#define CLKPS0_MASK 1
#define CLKPS1 1
#define CLKPS1_BIT 1
#define CLKPS1_MASK 2
#define CLKPS2 2
#define CLKPS2_BIT 2
#define CLKPS2_MASK 4
#define CLKPS3 3
#define CLKPS3_BIT 3
#define CLKPS3_MASK 8
#define CLKPCE 7
#define CLKPCE_BIT 7
#define CLKPCE_MASK 128

sfrb WDTCSR = 0x60;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16
#define WDP3 5
#define WDP3_BIT 5
#define WDP3_MASK 32
#define WDIE 6
#define WDIE_BIT 6
#define WDIE_MASK 64
#define WDIF 7
#define WDIF_BIT 7
#define WDIF_MASK 128

sfrb SREG = 0x5f;

sfrb SPH = 0x5e;
#define SP8 0
#define SP8_BIT 0
#define SP8_MASK 1
#define SP9 1
#define SP9_BIT 1
#define SP9_MASK 2
#define SP10 2
#define SP10_BIT 2
#define SP10_MASK 4
#define SP11 3
#define SP11_BIT 3
#define SP11_MASK 8
#define SP12 4
#define SP12_BIT 4
#define SP12_MASK 16
#define SP13 5
#define SP13_BIT 5
#define SP13_MASK 32
#define SP14 6
#define SP14_BIT 6
#define SP14_MASK 64
#define SP15 7
#define SP15_BIT 7
#define SP15_MASK 128

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrw SPW = 0x5d;

sfrb EIND = 0x5c;
#define EIND0 0
#define EIND0_BIT 0
#define EIND0_MASK 1

sfrb RAMPZ = 0x5b;
#define RAMPZ0 0
#define RAMPZ0_BIT 0
#define RAMPZ0_MASK 1

sfrb SPMCSR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define BLBSET 3
#define BLBSET_BIT 3
#define BLBSET_MASK 8
#define RWWSRE 4
#define RWWSRE_BIT 4
#define RWWSRE_MASK 16
#define SIGRD 5
#define SIGRD_BIT 5
#define SIGRD_MASK 32
#define RWWSB 6
#define RWWSB_BIT 6
#define RWWSB_MASK 64
#define SPMIE 7
#define SPMIE_BIT 7
#define SPMIE_MASK 128

sfrb MCUCR = 0x55;
#define IVCE 0
#define IVCE_BIT 0
#define IVCE_MASK 1
#define IVSEL 1
#define IVSEL_BIT 1
#define IVSEL_MASK 2
#define PUD 4
#define PUD_BIT 4
#define PUD_MASK 16
#define JTD 7
#define JTD_BIT 7
#define JTD_MASK 128

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8
#define JTRF 4
#define JTRF_BIT 4
#define JTRF_MASK 16

sfrb SMCR = 0x53;
#define SE 0
#define SE_BIT 0
#define SE_MASK 1
#define SM0 1
#define SM0_BIT 1
#define SM0_MASK 2
#define SM1 2
#define SM1_BIT 2
#define SM1_MASK 4
#define SM2 3
#define SM2_BIT 3
#define SM2_MASK 8

sfrb OCDR = 0x51;
#define OCDR0 0
#define OCDR0_BIT 0
#define OCDR0_MASK 1
#define OCDR1 1
#define OCDR1_BIT 1
#define OCDR1_MASK 2
#define OCDR2 2
#define OCDR2_BIT 2
#define OCDR2_MASK 4
#define OCDR3 3
#define OCDR3_BIT 3
#define OCDR3_MASK 8
#define OCDR4 4
#define OCDR4_BIT 4
#define OCDR4_MASK 16
#define OCDR5 5
#define OCDR5_BIT 5
#define OCDR5_MASK 32
#define OCDR6 6
#define OCDR6_BIT 6
#define OCDR6_MASK 64
#define OCDR7 7
#define OCDR7_BIT 7
#define OCDR7_MASK 128

sfrb ACSR = 0x50;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIC 2
#define ACIC_BIT 2
#define ACIC_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb SPDR = 0x4e;
#define SPDR0 0
#define SPDR0_BIT 0
#define SPDR0_MASK 1
#define SPDR1 1
#define SPDR1_BIT 1
#define SPDR1_MASK 2
#define SPDR2 2
#define SPDR2_BIT 2
#define SPDR2_MASK 4
#define SPDR3 3
#define SPDR3_BIT 3
#define SPDR3_MASK 8
#define SPDR4 4
#define SPDR4_BIT 4
#define SPDR4_MASK 16
#define SPDR5 5
#define SPDR5_BIT 5
#define SPDR5_MASK 32
#define SPDR6 6
#define SPDR6_BIT 6
#define SPDR6_MASK 64
#define SPDR7 7
#define SPDR7_BIT 7
#define SPDR7_MASK 128

sfrb SPSR = 0x4d;
#define SPI2X 0
#define SPI2X_BIT 0
#define SPI2X_MASK 1
#define WCOL 6
#define WCOL_BIT 6
#define WCOL_MASK 64
#define SPIF 7
#define SPIF_BIT 7
#define SPIF_MASK 128

sfrb SPCR = 0x4c;
#define SPR0 0
#define SPR0_BIT 0
#define SPR0_MASK 1
#define SPR1 1
#define SPR1_BIT 1
#define SPR1_MASK 2
#define CPHA 2
#define CPHA_BIT 2
#define CPHA_MASK 4
#define CPOL 3
#define CPOL_BIT 3
#define CPOL_MASK 8
#define MSTR 4
#define MSTR_BIT 4
#define MSTR_MASK 16
#define DORD 5
#define DORD_BIT 5
#define DORD_MASK 32
#define SPE 6
#define SPE_BIT 6
#define SPE_MASK 64
#define SPIE 7
#define SPIE_BIT 7
#define SPIE_MASK 128

sfrb GPIOR2 = 0x4b;
#define GPIOR20 0
#define GPIOR20_BIT 0
#define GPIOR20_MASK 1
#define GPIOR21 1
#define GPIOR21_BIT 1
#define GPIOR21_MASK 2
#define GPIOR22 2
#define GPIOR22_BIT 2
#define GPIOR22_MASK 4
#define GPIOR23 3
#define GPIOR23_BIT 3
#define GPIOR23_MASK 8
#define GPIOR24 4
#define GPIOR24_BIT 4
#define GPIOR24_MASK 16
#define GPIOR25 5
#define GPIOR25_BIT 5
#define GPIOR25_MASK 32
#define GPIOR26 6
#define GPIOR26_BIT 6
#define GPIOR26_MASK 64
#define GPIOR27 7
#define GPIOR27_BIT 7
#define GPIOR27_MASK 128

sfrb GPIOR1 = 0x4a;
#define GPIOR10 0
#define GPIOR10_BIT 0
#define GPIOR10_MASK 1
#define GPIOR11 1
#define GPIOR11_BIT 1
#define GPIOR11_MASK 2
#define GPIOR12 2
#define GPIOR12_BIT 2
#define GPIOR12_MASK 4
#define GPIOR13 3
#define GPIOR13_BIT 3
#define GPIOR13_MASK 8
#define GPIOR14 4
#define GPIOR14_BIT 4
#define GPIOR14_MASK 16
#define GPIOR15 5
#define GPIOR15_BIT 5
#define GPIOR15_MASK 32
#define GPIOR16 6
#define GPIOR16_BIT 6
#define GPIOR16_MASK 64
#define GPIOR17 7
#define GPIOR17_BIT 7
#define GPIOR17_MASK 128

sfrb OCR0B = 0x48;
#define OCR0B_0 0
#define OCR0B_0_BIT 0
#define OCR0B_0_MASK 1
#define OCR0B_1 1
#define OCR0B_1_BIT 1
#define OCR0B_1_MASK 2
#define OCR0B_2 2
#define OCR0B_2_BIT 2
#define OCR0B_2_MASK 4
#define OCR0B_3 3
#define OCR0B_3_BIT 3
#define OCR0B_3_MASK 8
#define OCR0B_4 4
#define OCR0B_4_BIT 4
#define OCR0B_4_MASK 16
#define OCR0B_5 5
#define OCR0B_5_BIT 5
#define OCR0B_5_MASK 32
#define OCR0B_6 6
#define OCR0B_6_BIT 6
#define OCR0B_6_MASK 64
#define OCR0B_7 7
#define OCR0B_7_BIT 7
#define OCR0B_7_MASK 128

sfrb OCR0A = 0x47;
#define OCROA_0 0
#define OCROA_0_BIT 0
#define OCROA_0_MASK 1
#define OCROA_1 1
#define OCROA_1_BIT 1
#define OCROA_1_MASK 2
#define OCROA_2 2
#define OCROA_2_BIT 2
#define OCROA_2_MASK 4
#define OCROA_3 3
#define OCROA_3_BIT 3
#define OCROA_3_MASK 8
#define OCROA_4 4
#define OCROA_4_BIT 4
#define OCROA_4_MASK 16
#define OCROA_5 5
#define OCROA_5_BIT 5
#define OCROA_5_MASK 32
#define OCROA_6 6
#define OCROA_6_BIT 6
#define OCROA_6_MASK 64
#define OCROA_7 7
#define OCROA_7_BIT 7
#define OCROA_7_MASK 128

sfrb TCNT0 = 0x46;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb TCCR0B = 0x45;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM02 3
#define WGM02_BIT 3
#define WGM02_MASK 8
#define FOC0B 6
#define FOC0B_BIT 6
#define FOC0B_MASK 64
#define FOC0A 7
#define FOC0A_BIT 7
#define FOC0A_MASK 128

sfrb TCCR0A = 0x44;
#define WGM00 0
#define WGM00_BIT 0
#define WGM00_MASK 1
#define WGM01 1
#define WGM01_BIT 1
#define WGM01_MASK 2
#define COM0B0 4
#define COM0B0_BIT 4
#define COM0B0_MASK 16
#define COM0B1 5
#define COM0B1_BIT 5
#define COM0B1_MASK 32
#define COM0A0 6
#define COM0A0_BIT 6
#define COM0A0_MASK 64
#define COM0A1 7
#define COM0A1_BIT 7
#define COM0A1_MASK 128

sfrb GTCCR = 0x43;
#define PSRSYNC 0
#define PSRSYNC_BIT 0
#define PSRSYNC_MASK 1
#define PSRASY 1
#define PSRASY_BIT 1
#define PSRASY_MASK 2
#define TSM 7
#define TSM_BIT 7
#define TSM_MASK 128

sfrb EEARH = 0x42;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1
#define EEAR9 1
#define EEAR9_BIT 1
#define EEAR9_MASK 2
#define EEAR10 2
#define EEAR10_BIT 2
#define EEAR10_MASK 4
#define EEAR11 3
#define EEAR11_BIT 3
#define EEAR11_MASK 8

sfrb EEARL = 0x41;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64
#define EEAR7 7
#define EEAR7_BIT 7
#define EEAR7_MASK 128

sfrw EEARW = 0x41;

sfrb EEDR = 0x40;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3f;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEPE 1
#define EEPE_BIT 1
#define EEPE_MASK 2
#define EEMPE 2
#define EEMPE_BIT 2
#define EEMPE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8
#define EEPM0 4
#define EEPM0_BIT 4
#define EEPM0_MASK 16
#define EEPM1 5
#define EEPM1_BIT 5
#define EEPM1_MASK 32

sfrb GPIOR0 = 0x3e;
#define GPIOR00 0
#define GPIOR00_BIT 0
#define GPIOR00_MASK 1
#define GPIOR01 1
#define GPIOR01_BIT 1
#define GPIOR01_MASK 2
#define GPIOR02 2
#define GPIOR02_BIT 2
#define GPIOR02_MASK 4
#define GPIOR03 3
#define GPIOR03_BIT 3
#define GPIOR03_MASK 8
#define GPIOR04 4
#define GPIOR04_BIT 4
#define GPIOR04_MASK 16
#define GPIOR05 5
#define GPIOR05_BIT 5
#define GPIOR05_MASK 32
#define GPIOR06 6
#define GPIOR06_BIT 6
#define GPIOR06_MASK 64
#define GPIOR07 7
#define GPIOR07_BIT 7
#define GPIOR07_MASK 128

sfrb EIMSK = 0x3d;
#define INT0 0
#define INT0_BIT 0
#define INT0_MASK 1
#define INT1 1
#define INT1_BIT 1
#define INT1_MASK 2
#define INT2 2
#define INT2_BIT 2
#define INT2_MASK 4
#define INT3 3
#define INT3_BIT 3
#define INT3_MASK 8
#define INT4 4
#define INT4_BIT 4
#define INT4_MASK 16
#define INT5 5
#define INT5_BIT 5
#define INT5_MASK 32
#define INT6 6
#define INT6_BIT 6
#define INT6_MASK 64
#define INT7 7
#define INT7_BIT 7
#define INT7_MASK 128

sfrb EIFR = 0x3c;
#define INTF0 0
#define INTF0_BIT 0
#define INTF0_MASK 1
#define INTF1 1
#define INTF1_BIT 1
#define INTF1_MASK 2
#define INTF2 2
#define INTF2_BIT 2
#define INTF2_MASK 4
#define INTF3 3
#define INTF3_BIT 3
#define INTF3_MASK 8
#define INTF4 4
#define INTF4_BIT 4
#define INTF4_MASK 16
#define INTF5 5
#define INTF5_BIT 5
#define INTF5_MASK 32
#define INTF6 6
#define INTF6_BIT 6
#define INTF6_MASK 64
#define INTF7 7
#define INTF7_BIT 7
#define INTF7_MASK 128

sfrb PCIFR = 0x3b;
#define PCIF0 0
#define PCIF0_BIT 0
#define PCIF0_MASK 1
#define PCIF1 1
#define PCIF1_BIT 1
#define PCIF1_MASK 2
#define PCIF2 2
#define PCIF2_BIT 2
#define PCIF2_MASK 4

sfrb TIFR5 = 0x3a;

sfrb TIFR4 = 0x39;

sfrb TIFR3 = 0x38;
#define TOV3 0
#define TOV3_BIT 0
#define TOV3_MASK 1
#define OCF3A 1
#define OCF3A_BIT 1
#define OCF3A_MASK 2
#define OCF3B 2
#define OCF3B_BIT 2
#define OCF3B_MASK 4
#define OCF3C 3
#define OCF3C_BIT 3
#define OCF3C_MASK 8
#define ICF3 5
#define ICF3_BIT 5
#define ICF3_MASK 32

sfrb TIFR2 = 0x37;
#define TOV2 0
#define TOV2_BIT 0
#define TOV2_MASK 1
#define OCF2A 1
#define OCF2A_BIT 1
#define OCF2A_MASK 2
#define OCF2B 2
#define OCF2B_BIT 2
#define OCF2B_MASK 4

sfrb TIFR1 = 0x36;
#define TOV1 0
#define TOV1_BIT 0
#define TOV1_MASK 1
#define OCF1A 1
#define OCF1A_BIT 1
#define OCF1A_MASK 2
#define OCF1B 2
#define OCF1B_BIT 2
#define OCF1B_MASK 4
#define OCF1C 3
#define OCF1C_BIT 3
#define OCF1C_MASK 8
#define ICF1 5
#define ICF1_BIT 5
#define ICF1_MASK 32

sfrb TIFR0 = 0x35;
#define TOV0 0
#define TOV0_BIT 0
#define TOV0_MASK 1
#define OCF0A 1
#define OCF0A_BIT 1
#define OCF0A_MASK 2
#define OCF0B 2
#define OCF0B_BIT 2
#define OCF0B_MASK 4

sfrb PORTF = 0x31;
#define PORTF0 0
#define PORTF0_BIT 0
#define PORTF0_MASK 1
#define PORTF1 1
#define PORTF1_BIT 1
#define PORTF1_MASK 2
#define PORTF2 2
#define PORTF2_BIT 2
#define PORTF2_MASK 4
#define PORTF3 3
#define PORTF3_BIT 3
#define PORTF3_MASK 8
#define PORTF4 4
#define PORTF4_BIT 4
#define PORTF4_MASK 16
#define PORTF5 5
#define PORTF5_BIT 5
#define PORTF5_MASK 32
#define PORTF6 6
#define PORTF6_BIT 6
#define PORTF6_MASK 64
#define PORTF7 7
#define PORTF7_BIT 7
#define PORTF7_MASK 128

sfrb DDRF = 0x30;
#define DDF0 0
#define DDF0_BIT 0
#define DDF0_MASK 1
#define DDF1 1
#define DDF1_BIT 1
#define DDF1_MASK 2
#define DDF2 2
#define DDF2_BIT 2
#define DDF2_MASK 4
#define DDF3 3
#define DDF3_BIT 3
#define DDF3_MASK 8
#define DDF4 4
#define DDF4_BIT 4
#define DDF4_MASK 16
#define DDF5 5
#define DDF5_BIT 5
#define DDF5_MASK 32
#define DDF6 6
#define DDF6_BIT 6
#define DDF6_MASK 64
#define DDF7 7
#define DDF7_BIT 7
#define DDF7_MASK 128

sfrb PINF = 0x2f;
#define PINF0 0
#define PINF0_BIT 0
#define PINF0_MASK 1
#define PINF1 1
#define PINF1_BIT 1
#define PINF1_MASK 2
#define PINF2 2
#define PINF2_BIT 2
#define PINF2_MASK 4
#define PINF3 3
#define PINF3_BIT 3
#define PINF3_MASK 8
#define PINF4 4
#define PINF4_BIT 4
#define PINF4_MASK 16
#define PINF5 5
#define PINF5_BIT 5
#define PINF5_MASK 32
#define PINF6 6
#define PINF6_BIT 6
#define PINF6_MASK 64
#define PINF7 7
#define PINF7_BIT 7
#define PINF7_MASK 128

sfrb PORTE = 0x2e;
#define PORTE0 0
#define PORTE0_BIT 0
#define PORTE0_MASK 1
#define PORTE1 1
#define PORTE1_BIT 1
#define PORTE1_MASK 2
#define PORTE2 2
#define PORTE2_BIT 2
#define PORTE2_MASK 4
#define PORTE3 3
#define PORTE3_BIT 3
#define PORTE3_MASK 8
#define PORTE4 4
#define PORTE4_BIT 4
#define PORTE4_MASK 16
#define PORTE5 5
#define PORTE5_BIT 5
#define PORTE5_MASK 32
#define PORTE6 6
#define PORTE6_BIT 6
#define PORTE6_MASK 64
#define PORTE7 7
#define PORTE7_BIT 7
#define PORTE7_MASK 128

sfrb DDRE = 0x2d;
#define DDE0 0
#define DDE0_BIT 0
#define DDE0_MASK 1
#define DDE1 1
#define DDE1_BIT 1
#define DDE1_MASK 2
#define DDE2 2
#define DDE2_BIT 2
#define DDE2_MASK 4
#define DDE3 3
#define DDE3_BIT 3
#define DDE3_MASK 8
#define DDE4 4
#define DDE4_BIT 4
#define DDE4_MASK 16
#define DDE5 5
#define DDE5_BIT 5
#define DDE5_MASK 32
#define DDE6 6
#define DDE6_BIT 6
#define DDE6_MASK 64
#define DDE7 7
#define DDE7_BIT 7
#define DDE7_MASK 128

sfrb PINE = 0x2c;
#define PINE0 0
#define PINE0_BIT 0
#define PINE0_MASK 1
#define PINE1 1
#define PINE1_BIT 1
#define PINE1_MASK 2
#define PINE2 2
#define PINE2_BIT 2
#define PINE2_MASK 4
#define PINE3 3
#define PINE3_BIT 3
#define PINE3_MASK 8
#define PINE4 4
#define PINE4_BIT 4
#define PINE4_MASK 16
#define PINE5 5
#define PINE5_BIT 5
#define PINE5_MASK 32
#define PINE6 6
#define PINE6_BIT 6
#define PINE6_MASK 64
#define PINE7 7
#define PINE7_BIT 7
#define PINE7_MASK 128

sfrb PORTD = 0x2b;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x2a;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64
#define DDD7 7
#define DDD7_BIT 7
#define DDD7_MASK 128

sfrb PIND = 0x29;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb PORTC = 0x28;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1
#define PORTC1 1
#define PORTC1_BIT 1
#define PORTC1_MASK 2
#define PORTC2 2
#define PORTC2_BIT 2
#define PORTC2_MASK 4
#define PORTC3 3
#define PORTC3_BIT 3
#define PORTC3_MASK 8
#define PORTC4 4
#define PORTC4_BIT 4
#define PORTC4_MASK 16
#define PORTC5 5
#define PORTC5_BIT 5
#define PORTC5_MASK 32
#define PORTC6 6
#define PORTC6_BIT 6
#define PORTC6_MASK 64
#define PORTC7 7
#define PORTC7_BIT 7
#define PORTC7_MASK 128

sfrb DDRC = 0x27;
#define DDC0 0
#define DDC0_BIT 0
#define DDC0_MASK 1
#define DDC1 1
#define DDC1_BIT 1
#define DDC1_MASK 2
#define DDC2 2
#define DDC2_BIT 2
#define DDC2_MASK 4
#define DDC3 3
#define DDC3_BIT 3
#define DDC3_MASK 8
#define DDC4 4
#define DDC4_BIT 4
#define DDC4_MASK 16
#define DDC5 5
#define DDC5_BIT 5
#define DDC5_MASK 32
#define DDC6 6
#define DDC6_BIT 6
#define DDC6_MASK 64
#define DDC7 7
#define DDC7_BIT 7
#define DDC7_MASK 128

sfrb PINC = 0x26;
#define PINC0 0
#define PINC0_BIT 0
#define PINC0_MASK 1
#define PINC1 1
#define PINC1_BIT 1
#define PINC1_MASK 2
#define PINC2 2
#define PINC2_BIT 2
#define PINC2_MASK 4
#define PINC3 3
#define PINC3_BIT 3
#define PINC3_MASK 8
#define PINC4 4
#define PINC4_BIT 4
#define PINC4_MASK 16
#define PINC5 5
#define PINC5_BIT 5
#define PINC5_MASK 32
#define PINC6 6
#define PINC6_BIT 6
#define PINC6_MASK 64
#define PINC7 7
#define PINC7_BIT 7
#define PINC7_MASK 128

sfrb PORTB = 0x25;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x24;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x23;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb PORTA = 0x22;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8
#define PORTA4 4
#define PORTA4_BIT 4
#define PORTA4_MASK 16
#define PORTA5 5
#define PORTA5_BIT 5
#define PORTA5_MASK 32
#define PORTA6 6
#define PORTA6_BIT 6
#define PORTA6_MASK 64
#define PORTA7 7
#define PORTA7_BIT 7
#define PORTA7_MASK 128

sfrb DDRA = 0x21;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define DDA2 2
#define DDA2_BIT 2
#define DDA2_MASK 4
#define DDA3 3
#define DDA3_BIT 3
#define DDA3_MASK 8
#define DDA4 4
#define DDA4_BIT 4
#define DDA4_MASK 16
#define DDA5 5
#define DDA5_BIT 5
#define DDA5_MASK 32
#define DDA6 6
#define DDA6_BIT 6
#define DDA6_MASK 64
#define DDA7 7
#define DDA7_BIT 7
#define DDA7_MASK 128

sfrb PINA = 0x20;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8
#define PINA4 4
#define PINA4_BIT 4
#define PINA4_MASK 16
#define PINA5 5
#define PINA5_BIT 5
#define PINA5_MASK 32
#define PINA6 6
#define PINA6_BIT 6
#define PINA6_MASK 64
#define PINA7 7
#define PINA7_BIT 7
#define PINA7_MASK 128

#endif
