#ifndef __AT90PWM3_h
#define __AT90PWM3_h

// Interrupt vectors

#define RESET_vect 0x0000
#define PSC2_CAPT_vect 0x0002
#define PSC2_EC_vect 0x0004
#define PSC1_CAPT_vect 0x0006
#define PSC1_EC_vect 0x0008
#define PSC0_CAPT_vect 0x000a
#define PSC0_EC_vect 0x000c
#define ANALOG_COMP_0_vect 0x000e
#define ANALOG_COMP_1_vect 0x0010
#define ANALOG_COMP_2_vect 0x0012
#define INT0_vect 0x0014
#define TIMER1_CAPT_vect 0x0016
#define TIMER1_COMPA_vect 0x0018
#define TIMER1_COMPB_vect 0x001a
#define RESERVED15_vect 0x001c
#define TIMER1_OVF_vect 0x001e
#define TIMER0_COMP_A_vect 0x0020
#define TIMER0_OVF_vect 0x0022
#define ADC_vect 0x0024
#define INT1_vect 0x0026
#define SPI_STC_vect 0x0028
#define USART_RX_vect 0x002a
#define USART_UDRE_vect 0x002c
#define USART_TX_vect 0x002e
#define INT2_vect 0x0030
#define WDT_vect 0x0032
#define EE_READY_vect 0x0034
#define TIMER0_COMPB_vect 0x0036
#define INT3_vect 0x0038
#define RESERVED30_vect 0x003a
#define RESERVED31_vect 0x003c
#define SPM_READY_vect 0x003e

// I/O addresses


sfrb PICR2H = 0xff;
#define PICR2_8 0
#define PICR2_8_BIT 0
#define PICR2_8_MASK 1
#define PICR2_9 1
#define PICR2_9_BIT 1
#define PICR2_9_MASK 2
#define PICR2_10 2
#define PICR2_10_BIT 2
#define PICR2_10_MASK 4
#define PICR2_11 3
#define PICR2_11_BIT 3
#define PICR2_11_MASK 8

sfrb PICR2L = 0xfe;
#define PICR2_0 0
#define PICR2_0_BIT 0
#define PICR2_0_MASK 1
#define PICR2_1 1
#define PICR2_1_BIT 1
#define PICR2_1_MASK 2
#define PICR2_2 2
#define PICR2_2_BIT 2
#define PICR2_2_MASK 4
#define PICR2_3 3
#define PICR2_3_BIT 3
#define PICR2_3_MASK 8
#define PICR2_4 4
#define PICR2_4_BIT 4
#define PICR2_4_MASK 16
#define PICR2_5 5
#define PICR2_5_BIT 5
#define PICR2_5_MASK 32
#define PICR2_6 6
#define PICR2_6_BIT 6
#define PICR2_6_MASK 64
#define PICR2_7 7
#define PICR2_7_BIT 7
#define PICR2_7_MASK 128

sfrw PICR2W = 0xfe;

sfrb PFRC2B = 0xfd;
#define PRFM2B0 0
#define PRFM2B0_BIT 0
#define PRFM2B0_MASK 1
#define PRFM2B1 1
#define PRFM2B1_BIT 1
#define PRFM2B1_MASK 2
#define PRFM2B2 2
#define PRFM2B2_BIT 2
#define PRFM2B2_MASK 4
#define PRFM2B3 3
#define PRFM2B3_BIT 3
#define PRFM2B3_MASK 8
#define PFLTE2B 4
#define PFLTE2B_BIT 4
#define PFLTE2B_MASK 16
#define PELEV2B 5
#define PELEV2B_BIT 5
#define PELEV2B_MASK 32
#define PISEL2B 6
#define PISEL2B_BIT 6
#define PISEL2B_MASK 64
#define PCAE2B 7
#define PCAE2B_BIT 7
#define PCAE2B_MASK 128

sfrb PFRC2A = 0xfc;
#define PRFM2A0 0
#define PRFM2A0_BIT 0
#define PRFM2A0_MASK 1
#define PRFM2A1 1
#define PRFM2A1_BIT 1
#define PRFM2A1_MASK 2
#define PRFM2A2 2
#define PRFM2A2_BIT 2
#define PRFM2A2_MASK 4
#define PRFM2A3 3
#define PRFM2A3_BIT 3
#define PRFM2A3_MASK 8
#define PFLTE2A 4
#define PFLTE2A_BIT 4
#define PFLTE2A_MASK 16
#define PELEV2A 5
#define PELEV2A_BIT 5
#define PELEV2A_MASK 32
#define PISEL2A 6
#define PISEL2A_BIT 6
#define PISEL2A_MASK 64
#define PCAE2A 7
#define PCAE2A_BIT 7
#define PCAE2A_MASK 128

sfrb PCTL2 = 0xfb;
#define PRUN2 0
#define PRUN2_BIT 0
#define PRUN2_MASK 1
#define PCCYC2 1
#define PCCYC2_BIT 1
#define PCCYC2_MASK 2
#define PARUN2 2
#define PARUN2_BIT 2
#define PARUN2_MASK 4
#define PAOC2A 3
#define PAOC2A_BIT 3
#define PAOC2A_MASK 8
#define PAOC2B 4
#define PAOC2B_BIT 4
#define PAOC2B_MASK 16
#define PBFM2 5
#define PBFM2_BIT 5
#define PBFM2_MASK 32
#define PPRE20 6
#define PPRE20_BIT 6
#define PPRE20_MASK 64
#define PPRE21 7
#define PPRE21_BIT 7
#define PPRE21_MASK 128

sfrb PCNF2 = 0xfa;
#define POME2 0
#define POME2_BIT 0
#define POME2_MASK 1
#define PCLKSEL2 1
#define PCLKSEL2_BIT 1
#define PCLKSEL2_MASK 2
#define POP2 2
#define POP2_BIT 2
#define POP2_MASK 4
#define PMODE20 3
#define PMODE20_BIT 3
#define PMODE20_MASK 8
#define PMODE21 4
#define PMODE21_BIT 4
#define PMODE21_MASK 16
#define PLOCK2 5
#define PLOCK2_BIT 5
#define PLOCK2_MASK 32
#define PALOCK2 6
#define PALOCK2_BIT 6
#define PALOCK2_MASK 64
#define PFIFTY2 7
#define PFIFTY2_BIT 7
#define PFIFTY2_MASK 128

sfrb OCR2RBH = 0xf9;
#define OCR2RB_8 0
#define OCR2RB_8_BIT 0
#define OCR2RB_8_MASK 1
#define OCR2RB_9 1
#define OCR2RB_9_BIT 1
#define OCR2RB_9_MASK 2
#define OCR2RB_10 2
#define OCR2RB_10_BIT 2
#define OCR2RB_10_MASK 4
#define OCR2RB_11 3
#define OCR2RB_11_BIT 3
#define OCR2RB_11_MASK 8
#define OCR2RB_12 4
#define OCR2RB_12_BIT 4
#define OCR2RB_12_MASK 16
#define OCR2RB_13 5
#define OCR2RB_13_BIT 5
#define OCR2RB_13_MASK 32
#define OCR2RB_14 6
#define OCR2RB_14_BIT 6
#define OCR2RB_14_MASK 64
#define OCR2RB_15 7
#define OCR2RB_15_BIT 7
#define OCR2RB_15_MASK 128

sfrb OCR2RBL = 0xf8;
#define OCR2RB_0 0
#define OCR2RB_0_BIT 0
#define OCR2RB_0_MASK 1
#define OCR2RB_1 1
#define OCR2RB_1_BIT 1
#define OCR2RB_1_MASK 2
#define OCR2RB_2 2
#define OCR2RB_2_BIT 2
#define OCR2RB_2_MASK 4
#define OCR2RB_3 3
#define OCR2RB_3_BIT 3
#define OCR2RB_3_MASK 8
#define OCR2RB_4 4
#define OCR2RB_4_BIT 4
#define OCR2RB_4_MASK 16
#define OCR2RB_5 5
#define OCR2RB_5_BIT 5
#define OCR2RB_5_MASK 32
#define OCR2RB_6 6
#define OCR2RB_6_BIT 6
#define OCR2RB_6_MASK 64
#define OCR2RB_7 7
#define OCR2RB_7_BIT 7
#define OCR2RB_7_MASK 128

sfrw OCR2RBW = 0xf8;

sfrb OCR2SBH = 0xf7;
#define OCR2SB_8 0
#define OCR2SB_8_BIT 0
#define OCR2SB_8_MASK 1
#define OCR2SB_9 1
#define OCR2SB_9_BIT 1
#define OCR2SB_9_MASK 2
#define OCR2SB_10 2
#define OCR2SB_10_BIT 2
#define OCR2SB_10_MASK 4
#define OCR2SB_11 3
#define OCR2SB_11_BIT 3
#define OCR2SB_11_MASK 8

sfrb OCR2SBL = 0xf6;
#define OCR2SB_0 0
#define OCR2SB_0_BIT 0
#define OCR2SB_0_MASK 1
#define OCR2SB_1 1
#define OCR2SB_1_BIT 1
#define OCR2SB_1_MASK 2
#define OCR2SB_2 2
#define OCR2SB_2_BIT 2
#define OCR2SB_2_MASK 4
#define OCR2SB_3 3
#define OCR2SB_3_BIT 3
#define OCR2SB_3_MASK 8
#define OCR2SB_4 4
#define OCR2SB_4_BIT 4
#define OCR2SB_4_MASK 16
#define OCR2SB_5 5
#define OCR2SB_5_BIT 5
#define OCR2SB_5_MASK 32
#define OCR2SB_6 6
#define OCR2SB_6_BIT 6
#define OCR2SB_6_MASK 64
#define OCR2SB_7 7
#define OCR2SB_7_BIT 7
#define OCR2SB_7_MASK 128

sfrw OCR2SBW = 0xf6;

sfrb OCR2RAH = 0xf5;
#define OCR2RA_8 0
#define OCR2RA_8_BIT 0
#define OCR2RA_8_MASK 1
#define OCR2RA_9 1
#define OCR2RA_9_BIT 1
#define OCR2RA_9_MASK 2
#define OCR2RA_10 2
#define OCR2RA_10_BIT 2
#define OCR2RA_10_MASK 4
#define OCR2RA_11 3
#define OCR2RA_11_BIT 3
#define OCR2RA_11_MASK 8

sfrb OCR2RAL = 0xf4;
#define OCR2RA_0 0
#define OCR2RA_0_BIT 0
#define OCR2RA_0_MASK 1
#define OCR2RA_1 1
#define OCR2RA_1_BIT 1
#define OCR2RA_1_MASK 2
#define OCR2RA_2 2
#define OCR2RA_2_BIT 2
#define OCR2RA_2_MASK 4
#define OCR2RA_3 3
#define OCR2RA_3_BIT 3
#define OCR2RA_3_MASK 8
#define OCR2RA_4 4
#define OCR2RA_4_BIT 4
#define OCR2RA_4_MASK 16
#define OCR2RA_5 5
#define OCR2RA_5_BIT 5
#define OCR2RA_5_MASK 32
#define OCR2RA_6 6
#define OCR2RA_6_BIT 6
#define OCR2RA_6_MASK 64
#define OCR2RA_7 7
#define OCR2RA_7_BIT 7
#define OCR2RA_7_MASK 128

sfrw OCR2RAW = 0xf4;

sfrb OCR2SAH = 0xf3;
#define OCR2SA_8 0
#define OCR2SA_8_BIT 0
#define OCR2SA_8_MASK 1
#define OCR2SA_9 1
#define OCR2SA_9_BIT 1
#define OCR2SA_9_MASK 2
#define OCR2SA_10 2
#define OCR2SA_10_BIT 2
#define OCR2SA_10_MASK 4
#define OCR2SA_11 3
#define OCR2SA_11_BIT 3
#define OCR2SA_11_MASK 8

sfrb OCR2SAL = 0xf2;
#define OCR2SA_0 0
#define OCR2SA_0_BIT 0
#define OCR2SA_0_MASK 1
#define OCR2SA_1 1
#define OCR2SA_1_BIT 1
#define OCR2SA_1_MASK 2
#define OCR2SA_2 2
#define OCR2SA_2_BIT 2
#define OCR2SA_2_MASK 4
#define OCR2SA_3 3
#define OCR2SA_3_BIT 3
#define OCR2SA_3_MASK 8
#define OCR2SA_4 4
#define OCR2SA_4_BIT 4
#define OCR2SA_4_MASK 16
#define OCR2SA_5 5
#define OCR2SA_5_BIT 5
#define OCR2SA_5_MASK 32
#define OCR2SA_6 6
#define OCR2SA_6_BIT 6
#define OCR2SA_6_MASK 64
#define OCR2SA_7 7
#define OCR2SA_7_BIT 7
#define OCR2SA_7_MASK 128

sfrw OCR2SAW = 0xf2;

sfrb POM2 = 0xf1;
#define POMV2A0 0
#define POMV2A0_BIT 0
#define POMV2A0_MASK 1
#define POMV2A1 1
#define POMV2A1_BIT 1
#define POMV2A1_MASK 2
#define POMV2A2 2
#define POMV2A2_BIT 2
#define POMV2A2_MASK 4
#define POMV2A3 3
#define POMV2A3_BIT 3
#define POMV2A3_MASK 8
#define POMV2B0 4
#define POMV2B0_BIT 4
#define POMV2B0_MASK 16
#define POMV2B1 5
#define POMV2B1_BIT 5
#define POMV2B1_MASK 32
#define POMV2B2 6
#define POMV2B2_BIT 6
#define POMV2B2_MASK 64
#define POMV2B3 7
#define POMV2B3_BIT 7
#define POMV2B3_MASK 128

sfrb PSOC2 = 0xf0;
#define POEN2A 0
#define POEN2A_BIT 0
#define POEN2A_MASK 1
#define POEN2C 1
#define POEN2C_BIT 1
#define POEN2C_MASK 2
#define POEN2B 2
#define POEN2B_BIT 2
#define POEN2B_MASK 4
#define POEN2D 3
#define POEN2D_BIT 3
#define POEN2D_MASK 8
#define PSYNC2_0 4
#define PSYNC2_0_BIT 4
#define PSYNC2_0_MASK 16
#define PSYNC2_1 5
#define PSYNC2_1_BIT 5
#define PSYNC2_1_MASK 32
#define POS22 6
#define POS22_BIT 6
#define POS22_MASK 64
#define POS23 7
#define POS23_BIT 7
#define POS23_MASK 128

sfrb PICR1H = 0xef;
#define PICR1_8 0
#define PICR1_8_BIT 0
#define PICR1_8_MASK 1
#define PICR1_9 1
#define PICR1_9_BIT 1
#define PICR1_9_MASK 2
#define PICR1_10 2
#define PICR1_10_BIT 2
#define PICR1_10_MASK 4
#define PICR1_11 3
#define PICR1_11_BIT 3
#define PICR1_11_MASK 8

sfrb PICR1L = 0xee;
#define PICR1_0 0
#define PICR1_0_BIT 0
#define PICR1_0_MASK 1
#define PICR1_1 1
#define PICR1_1_BIT 1
#define PICR1_1_MASK 2
#define PICR1_2 2
#define PICR1_2_BIT 2
#define PICR1_2_MASK 4
#define PICR1_3 3
#define PICR1_3_BIT 3
#define PICR1_3_MASK 8
#define PICR1_4 4
#define PICR1_4_BIT 4
#define PICR1_4_MASK 16
#define PICR1_5 5
#define PICR1_5_BIT 5
#define PICR1_5_MASK 32
#define PICR1_6 6
#define PICR1_6_BIT 6
#define PICR1_6_MASK 64
#define PICR1_7 7
#define PICR1_7_BIT 7
#define PICR1_7_MASK 128

sfrw PICR1W = 0xee;

sfrb PFRC1B = 0xed;
#define PRFM1B0 0
#define PRFM1B0_BIT 0
#define PRFM1B0_MASK 1
#define PRFM1B1 1
#define PRFM1B1_BIT 1
#define PRFM1B1_MASK 2
#define PRFM1B2 2
#define PRFM1B2_BIT 2
#define PRFM1B2_MASK 4
#define PRFM1B3 3
#define PRFM1B3_BIT 3
#define PRFM1B3_MASK 8
#define PFLTE1B 4
#define PFLTE1B_BIT 4
#define PFLTE1B_MASK 16
#define PELEV1B 5
#define PELEV1B_BIT 5
#define PELEV1B_MASK 32
#define PISEL1B 6
#define PISEL1B_BIT 6
#define PISEL1B_MASK 64
#define PCAE1B 7
#define PCAE1B_BIT 7
#define PCAE1B_MASK 128

sfrb PFRC1A = 0xec;
#define PRFM1A0 0
#define PRFM1A0_BIT 0
#define PRFM1A0_MASK 1
#define PRFM1A1 1
#define PRFM1A1_BIT 1
#define PRFM1A1_MASK 2
#define PRFM1A2 2
#define PRFM1A2_BIT 2
#define PRFM1A2_MASK 4
#define PRFM1A3 3
#define PRFM1A3_BIT 3
#define PRFM1A3_MASK 8
#define PFLTE1A 4
#define PFLTE1A_BIT 4
#define PFLTE1A_MASK 16
#define PELEV1A 5
#define PELEV1A_BIT 5
#define PELEV1A_MASK 32
#define PISEL1A 6
#define PISEL1A_BIT 6
#define PISEL1A_MASK 64
#define PCAE1A 7
#define PCAE1A_BIT 7
#define PCAE1A_MASK 128

sfrb PCTL1 = 0xeb;
#define PRUN1 0
#define PRUN1_BIT 0
#define PRUN1_MASK 1
#define PCCYC1 1
#define PCCYC1_BIT 1
#define PCCYC1_MASK 2
#define PARUN1 2
#define PARUN1_BIT 2
#define PARUN1_MASK 4
#define PAOC1A 3
#define PAOC1A_BIT 3
#define PAOC1A_MASK 8
#define PAOC1B 4
#define PAOC1B_BIT 4
#define PAOC1B_MASK 16
#define PBFM1 5
#define PBFM1_BIT 5
#define PBFM1_MASK 32
#define PPRE10 6
#define PPRE10_BIT 6
#define PPRE10_MASK 64
#define PPRE11 7
#define PPRE11_BIT 7
#define PPRE11_MASK 128

sfrb PCNF1 = 0xea;
#define PCLKSEL1 1
#define PCLKSEL1_BIT 1
#define PCLKSEL1_MASK 2
#define POP1 2
#define POP1_BIT 2
#define POP1_MASK 4
#define PMODE10 3
#define PMODE10_BIT 3
#define PMODE10_MASK 8
#define PMODE11 4
#define PMODE11_BIT 4
#define PMODE11_MASK 16
#define PLOCK1 5
#define PLOCK1_BIT 5
#define PLOCK1_MASK 32
#define PALOCK1 6
#define PALOCK1_BIT 6
#define PALOCK1_MASK 64
#define PFIFTY1 7
#define PFIFTY1_BIT 7
#define PFIFTY1_MASK 128

sfrb OCR1RBH = 0xe9;
#define OCR1RB_8 0
#define OCR1RB_8_BIT 0
#define OCR1RB_8_MASK 1
#define OCR1RB_9 1
#define OCR1RB_9_BIT 1
#define OCR1RB_9_MASK 2
#define OCR1RB_10 2
#define OCR1RB_10_BIT 2
#define OCR1RB_10_MASK 4
#define OCR1RB_11 3
#define OCR1RB_11_BIT 3
#define OCR1RB_11_MASK 8
#define OCR1RB_12 4
#define OCR1RB_12_BIT 4
#define OCR1RB_12_MASK 16
#define OCR1RB_13 5
#define OCR1RB_13_BIT 5
#define OCR1RB_13_MASK 32
#define OCR1RB_14 6
#define OCR1RB_14_BIT 6
#define OCR1RB_14_MASK 64
#define OCR1RB_15 7
#define OCR1RB_15_BIT 7
#define OCR1RB_15_MASK 128

sfrb OCR1RBL = 0xe8;
#define OCR1RB_0 0
#define OCR1RB_0_BIT 0
#define OCR1RB_0_MASK 1
#define OCR1RB_1 1
#define OCR1RB_1_BIT 1
#define OCR1RB_1_MASK 2
#define OCR1RB_2 2
#define OCR1RB_2_BIT 2
#define OCR1RB_2_MASK 4
#define OCR1RB_3 3
#define OCR1RB_3_BIT 3
#define OCR1RB_3_MASK 8
#define OCR1RB_4 4
#define OCR1RB_4_BIT 4
#define OCR1RB_4_MASK 16
#define OCR1RB_5 5
#define OCR1RB_5_BIT 5
#define OCR1RB_5_MASK 32
#define OCR1RB_6 6
#define OCR1RB_6_BIT 6
#define OCR1RB_6_MASK 64
#define OCR1RB_7 7
#define OCR1RB_7_BIT 7
#define OCR1RB_7_MASK 128

sfrw OCR1RBW = 0xe8;

sfrb OCR1SBH = 0xe7;
#define OCR1SB_8 0
#define OCR1SB_8_BIT 0
#define OCR1SB_8_MASK 1
#define OCR1SB_9 1
#define OCR1SB_9_BIT 1
#define OCR1SB_9_MASK 2
#define OCR1SB_10 2
#define OCR1SB_10_BIT 2
#define OCR1SB_10_MASK 4
#define OCR1SB_11 3
#define OCR1SB_11_BIT 3
#define OCR1SB_11_MASK 8

sfrb OCR1SBL = 0xe6;
#define OCR1SB_0 0
#define OCR1SB_0_BIT 0
#define OCR1SB_0_MASK 1
#define OCR1SB_1 1
#define OCR1SB_1_BIT 1
#define OCR1SB_1_MASK 2
#define OCR1SB_2 2
#define OCR1SB_2_BIT 2
#define OCR1SB_2_MASK 4
#define OCR1SB_3 3
#define OCR1SB_3_BIT 3
#define OCR1SB_3_MASK 8
#define OCR1SB_4 4
#define OCR1SB_4_BIT 4
#define OCR1SB_4_MASK 16
#define OCR1SB_5 5
#define OCR1SB_5_BIT 5
#define OCR1SB_5_MASK 32
#define OCR1SB_6 6
#define OCR1SB_6_BIT 6
#define OCR1SB_6_MASK 64
#define OCR1SB_7 7
#define OCR1SB_7_BIT 7
#define OCR1SB_7_MASK 128

sfrw OCR1SBW = 0xe6;

sfrb OCR1RAH = 0xe5;
#define OCR1RA_8 0
#define OCR1RA_8_BIT 0
#define OCR1RA_8_MASK 1
#define OCR1RA_9 1
#define OCR1RA_9_BIT 1
#define OCR1RA_9_MASK 2
#define OCR1RA_10 2
#define OCR1RA_10_BIT 2
#define OCR1RA_10_MASK 4
#define OCR1RA_11 3
#define OCR1RA_11_BIT 3
#define OCR1RA_11_MASK 8

sfrb OCR1RAL = 0xe4;
#define OCR1RA_0 0
#define OCR1RA_0_BIT 0
#define OCR1RA_0_MASK 1
#define OCR1RA_1 1
#define OCR1RA_1_BIT 1
#define OCR1RA_1_MASK 2
#define OCR1RA_2 2
#define OCR1RA_2_BIT 2
#define OCR1RA_2_MASK 4
#define OCR1RA_3 3
#define OCR1RA_3_BIT 3
#define OCR1RA_3_MASK 8
#define OCR1RA_4 4
#define OCR1RA_4_BIT 4
#define OCR1RA_4_MASK 16
#define OCR1RA_5 5
#define OCR1RA_5_BIT 5
#define OCR1RA_5_MASK 32
#define OCR1RA_6 6
#define OCR1RA_6_BIT 6
#define OCR1RA_6_MASK 64
#define OCR1RA_7 7
#define OCR1RA_7_BIT 7
#define OCR1RA_7_MASK 128

sfrw OCR1RAW = 0xe4;

sfrb OCR1SAH = 0xe3;
#define OCR1SA_8 0
#define OCR1SA_8_BIT 0
#define OCR1SA_8_MASK 1
#define OCR1SA_9 1
#define OCR1SA_9_BIT 1
#define OCR1SA_9_MASK 2
#define OCR1SA_10 2
#define OCR1SA_10_BIT 2
#define OCR1SA_10_MASK 4
#define OCR1SA_11 3
#define OCR1SA_11_BIT 3
#define OCR1SA_11_MASK 8

sfrb OCR1SAL = 0xe2;
#define OCR1SA_0 0
#define OCR1SA_0_BIT 0
#define OCR1SA_0_MASK 1
#define OCR1SA_1 1
#define OCR1SA_1_BIT 1
#define OCR1SA_1_MASK 2
#define OCR1SA_2 2
#define OCR1SA_2_BIT 2
#define OCR1SA_2_MASK 4
#define OCR1SA_3 3
#define OCR1SA_3_BIT 3
#define OCR1SA_3_MASK 8
#define OCR1SA_4 4
#define OCR1SA_4_BIT 4
#define OCR1SA_4_MASK 16
#define OCR1SA_5 5
#define OCR1SA_5_BIT 5
#define OCR1SA_5_MASK 32
#define OCR1SA_6 6
#define OCR1SA_6_BIT 6
#define OCR1SA_6_MASK 64
#define OCR1SA_7 7
#define OCR1SA_7_BIT 7
#define OCR1SA_7_MASK 128

sfrw OCR1SAW = 0xe2;

sfrb PSOC1 = 0xe0;
#define POEN1A 0
#define POEN1A_BIT 0
#define POEN1A_MASK 1
#define POEN1B 2
#define POEN1B_BIT 2
#define POEN1B_MASK 4
#define PSYNC1_0 4
#define PSYNC1_0_BIT 4
#define PSYNC1_0_MASK 16
#define PSYNC1_1 5
#define PSYNC1_1_BIT 5
#define PSYNC1_1_MASK 32

sfrb PICR0H = 0xdf;
#define PICR0_8 0
#define PICR0_8_BIT 0
#define PICR0_8_MASK 1
#define PICR0_9 1
#define PICR0_9_BIT 1
#define PICR0_9_MASK 2
#define PICR0_10 2
#define PICR0_10_BIT 2
#define PICR0_10_MASK 4
#define PICR0_11 3
#define PICR0_11_BIT 3
#define PICR0_11_MASK 8

sfrb PICR0L = 0xde;
#define PICR0_0 0
#define PICR0_0_BIT 0
#define PICR0_0_MASK 1
#define PICR0_1 1
#define PICR0_1_BIT 1
#define PICR0_1_MASK 2
#define PICR0_2 2
#define PICR0_2_BIT 2
#define PICR0_2_MASK 4
#define PICR0_3 3
#define PICR0_3_BIT 3
#define PICR0_3_MASK 8
#define PICR0_4 4
#define PICR0_4_BIT 4
#define PICR0_4_MASK 16
#define PICR0_5 5
#define PICR0_5_BIT 5
#define PICR0_5_MASK 32
#define PICR0_6 6
#define PICR0_6_BIT 6
#define PICR0_6_MASK 64
#define PICR0_7 7
#define PICR0_7_BIT 7
#define PICR0_7_MASK 128

sfrw PICR0W = 0xde;

sfrb PFRC0B = 0xdd;
#define PRFM0B0 0
#define PRFM0B0_BIT 0
#define PRFM0B0_MASK 1
#define PRFM0B1 1
#define PRFM0B1_BIT 1
#define PRFM0B1_MASK 2
#define PRFM0B2 2
#define PRFM0B2_BIT 2
#define PRFM0B2_MASK 4
#define PRFM0B3 3
#define PRFM0B3_BIT 3
#define PRFM0B3_MASK 8
#define PFLTE0B 4
#define PFLTE0B_BIT 4
#define PFLTE0B_MASK 16
#define PELEV0B 5
#define PELEV0B_BIT 5
#define PELEV0B_MASK 32
#define PISEL0B 6
#define PISEL0B_BIT 6
#define PISEL0B_MASK 64
#define PCAE0B 7
#define PCAE0B_BIT 7
#define PCAE0B_MASK 128

sfrb PFRC0A = 0xdc;
#define PRFM0A0 0
#define PRFM0A0_BIT 0
#define PRFM0A0_MASK 1
#define PRFM0A1 1
#define PRFM0A1_BIT 1
#define PRFM0A1_MASK 2
#define PRFM0A2 2
#define PRFM0A2_BIT 2
#define PRFM0A2_MASK 4
#define PRFM0A3 3
#define PRFM0A3_BIT 3
#define PRFM0A3_MASK 8
#define PFLTE0A 4
#define PFLTE0A_BIT 4
#define PFLTE0A_MASK 16
#define PELEV0A 5
#define PELEV0A_BIT 5
#define PELEV0A_MASK 32
#define PISEL0A 6
#define PISEL0A_BIT 6
#define PISEL0A_MASK 64
#define PCAE0A 7
#define PCAE0A_BIT 7
#define PCAE0A_MASK 128

sfrb PCTL0 = 0xdb;
#define PRUN0 0
#define PRUN0_BIT 0
#define PRUN0_MASK 1
#define PCCYC0 1
#define PCCYC0_BIT 1
#define PCCYC0_MASK 2
#define PARUN0 2
#define PARUN0_BIT 2
#define PARUN0_MASK 4
#define PAOC0A 3
#define PAOC0A_BIT 3
#define PAOC0A_MASK 8
#define PAOC0B 4
#define PAOC0B_BIT 4
#define PAOC0B_MASK 16
#define PBFM0 5
#define PBFM0_BIT 5
#define PBFM0_MASK 32
#define PPRE00 6
#define PPRE00_BIT 6
#define PPRE00_MASK 64
#define PPRE01 7
#define PPRE01_BIT 7
#define PPRE01_MASK 128

sfrb PCNF0 = 0xda;
#define PCLKSEL0 1
#define PCLKSEL0_BIT 1
#define PCLKSEL0_MASK 2
#define POP0 2
#define POP0_BIT 2
#define POP0_MASK 4
#define PMODE00 3
#define PMODE00_BIT 3
#define PMODE00_MASK 8
#define PMODE01 4
#define PMODE01_BIT 4
#define PMODE01_MASK 16
#define PLOCK0 5
#define PLOCK0_BIT 5
#define PLOCK0_MASK 32
#define PALOCK0 6
#define PALOCK0_BIT 6
#define PALOCK0_MASK 64
#define PFIFTY0 7
#define PFIFTY0_BIT 7
#define PFIFTY0_MASK 128

sfrb OCR0RBH = 0xd9;
#define OCR0RB_8 0
#define OCR0RB_8_BIT 0
#define OCR0RB_8_MASK 1
#define OCR0RB_9 1
#define OCR0RB_9_BIT 1
#define OCR0RB_9_MASK 2
#define OCR0RB_00 2
#define OCR0RB_00_BIT 2
#define OCR0RB_00_MASK 4
#define OCR0RB_01 3
#define OCR0RB_01_BIT 3
#define OCR0RB_01_MASK 8
#define OCR0RB_02 4
#define OCR0RB_02_BIT 4
#define OCR0RB_02_MASK 16
#define OCR0RB_03 5
#define OCR0RB_03_BIT 5
#define OCR0RB_03_MASK 32
#define OCR0RB_04 6
#define OCR0RB_04_BIT 6
#define OCR0RB_04_MASK 64
#define OCR0RB_05 7
#define OCR0RB_05_BIT 7
#define OCR0RB_05_MASK 128

sfrb OCR0RBL = 0xd8;
#define OCR0RB_0 0
#define OCR0RB_0_BIT 0
#define OCR0RB_0_MASK 1
#define OCR0RB_1 1
#define OCR0RB_1_BIT 1
#define OCR0RB_1_MASK 2
#define OCR0RB_2 2
#define OCR0RB_2_BIT 2
#define OCR0RB_2_MASK 4
#define OCR0RB_3 3
#define OCR0RB_3_BIT 3
#define OCR0RB_3_MASK 8
#define OCR0RB_4 4
#define OCR0RB_4_BIT 4
#define OCR0RB_4_MASK 16
#define OCR0RB_5 5
#define OCR0RB_5_BIT 5
#define OCR0RB_5_MASK 32
#define OCR0RB_6 6
#define OCR0RB_6_BIT 6
#define OCR0RB_6_MASK 64
#define OCR0RB_7 7
#define OCR0RB_7_BIT 7
#define OCR0RB_7_MASK 128

sfrw OCR0RBW = 0xd8;

sfrb OCR0SBH = 0xd7;
#define OCR0SB_8 0
#define OCR0SB_8_BIT 0
#define OCR0SB_8_MASK 1
#define OCR0SB_9 1
#define OCR0SB_9_BIT 1
#define OCR0SB_9_MASK 2
#define OCR0SB_00 2
#define OCR0SB_00_BIT 2
#define OCR0SB_00_MASK 4
#define OCR0SB_01 3
#define OCR0SB_01_BIT 3
#define OCR0SB_01_MASK 8

sfrb OCR0SBL = 0xd6;
#define OCR0SB_0 0
#define OCR0SB_0_BIT 0
#define OCR0SB_0_MASK 1
#define OCR0SB_1 1
#define OCR0SB_1_BIT 1
#define OCR0SB_1_MASK 2
#define OCR0SB_2 2
#define OCR0SB_2_BIT 2
#define OCR0SB_2_MASK 4
#define OCR0SB_3 3
#define OCR0SB_3_BIT 3
#define OCR0SB_3_MASK 8
#define OCR0SB_4 4
#define OCR0SB_4_BIT 4
#define OCR0SB_4_MASK 16
#define OCR0SB_5 5
#define OCR0SB_5_BIT 5
#define OCR0SB_5_MASK 32
#define OCR0SB_6 6
#define OCR0SB_6_BIT 6
#define OCR0SB_6_MASK 64
#define OCR0SB_7 7
#define OCR0SB_7_BIT 7
#define OCR0SB_7_MASK 128

sfrw OCR0SBW = 0xd6;

sfrb OCR0RAH = 0xd5;
#define OCR0RA_8 0
#define OCR0RA_8_BIT 0
#define OCR0RA_8_MASK 1
#define OCR0RA_9 1
#define OCR0RA_9_BIT 1
#define OCR0RA_9_MASK 2
#define OCR0RA_00 2
#define OCR0RA_00_BIT 2
#define OCR0RA_00_MASK 4
#define OCR0RA_01 3
#define OCR0RA_01_BIT 3
#define OCR0RA_01_MASK 8

sfrb OCR0RAL = 0xd4;
#define OCR0RA_0 0
#define OCR0RA_0_BIT 0
#define OCR0RA_0_MASK 1
#define OCR0RA_1 1
#define OCR0RA_1_BIT 1
#define OCR0RA_1_MASK 2
#define OCR0RA_2 2
#define OCR0RA_2_BIT 2
#define OCR0RA_2_MASK 4
#define OCR0RA_3 3
#define OCR0RA_3_BIT 3
#define OCR0RA_3_MASK 8
#define OCR0RA_4 4
#define OCR0RA_4_BIT 4
#define OCR0RA_4_MASK 16
#define OCR0RA_5 5
#define OCR0RA_5_BIT 5
#define OCR0RA_5_MASK 32
#define OCR0RA_6 6
#define OCR0RA_6_BIT 6
#define OCR0RA_6_MASK 64
#define OCR0RA_7 7
#define OCR0RA_7_BIT 7
#define OCR0RA_7_MASK 128

sfrw OCR0RAW = 0xd4;

sfrb OCR0SAH = 0xd3;
#define OCR0SA_8 0
#define OCR0SA_8_BIT 0
#define OCR0SA_8_MASK 1
#define OCR0SA_9 1
#define OCR0SA_9_BIT 1
#define OCR0SA_9_MASK 2
#define OCR0SA_00 2
#define OCR0SA_00_BIT 2
#define OCR0SA_00_MASK 4
#define OCR0SA_01 3
#define OCR0SA_01_BIT 3
#define OCR0SA_01_MASK 8

sfrb OCR0SAL = 0xd2;
#define OCR0SA_0 0
#define OCR0SA_0_BIT 0
#define OCR0SA_0_MASK 1
#define OCR0SA_1 1
#define OCR0SA_1_BIT 1
#define OCR0SA_1_MASK 2
#define OCR0SA_2 2
#define OCR0SA_2_BIT 2
#define OCR0SA_2_MASK 4
#define OCR0SA_3 3
#define OCR0SA_3_BIT 3
#define OCR0SA_3_MASK 8
#define OCR0SA_4 4
#define OCR0SA_4_BIT 4
#define OCR0SA_4_MASK 16
#define OCR0SA_5 5
#define OCR0SA_5_BIT 5
#define OCR0SA_5_MASK 32
#define OCR0SA_6 6
#define OCR0SA_6_BIT 6
#define OCR0SA_6_MASK 64
#define OCR0SA_7 7
#define OCR0SA_7_BIT 7
#define OCR0SA_7_MASK 128

sfrw OCR0SAW = 0xd2;

sfrb PSOC0 = 0xd0;
#define POEN0A 0
#define POEN0A_BIT 0
#define POEN0A_MASK 1
#define POEN0B 2
#define POEN0B_BIT 2
#define POEN0B_MASK 4
#define PSYNC00 4
#define PSYNC00_BIT 4
#define PSYNC00_MASK 16
#define PSYNC01 5
#define PSYNC01_BIT 5
#define PSYNC01_MASK 32

sfrb EUDR = 0xce;
#define EUDR0 0
#define EUDR0_BIT 0
#define EUDR0_MASK 1
#define EUDR1 1
#define EUDR1_BIT 1
#define EUDR1_MASK 2
#define EUDR2 2
#define EUDR2_BIT 2
#define EUDR2_MASK 4
#define EUDR3 3
#define EUDR3_BIT 3
#define EUDR3_MASK 8
#define EUDR4 4
#define EUDR4_BIT 4
#define EUDR4_MASK 16
#define EUDR5 5
#define EUDR5_BIT 5
#define EUDR5_MASK 32
#define EUDR6 6
#define EUDR6_BIT 6
#define EUDR6_MASK 64
#define EUDR7 7
#define EUDR7_BIT 7
#define EUDR7_MASK 128

sfrb MUBRRH = 0xcd;
#define MUBRR8 0
#define MUBRR8_BIT 0
#define MUBRR8_MASK 1
#define MUBRR9 1
#define MUBRR9_BIT 1
#define MUBRR9_MASK 2
#define MUBRR10 2
#define MUBRR10_BIT 2
#define MUBRR10_MASK 4
#define MUBRR11 3
#define MUBRR11_BIT 3
#define MUBRR11_MASK 8
#define MUBRR12 4
#define MUBRR12_BIT 4
#define MUBRR12_MASK 16
#define MUBRR13 5
#define MUBRR13_BIT 5
#define MUBRR13_MASK 32
#define MUBRR14 6
#define MUBRR14_BIT 6
#define MUBRR14_MASK 64
#define MUBRR15 7
#define MUBRR15_BIT 7
#define MUBRR15_MASK 128

sfrb MUBRRL = 0xcc;
#define MUBRR0 0
#define MUBRR0_BIT 0
#define MUBRR0_MASK 1
#define MUBRR1 1
#define MUBRR1_BIT 1
#define MUBRR1_MASK 2
#define MUBRR2 2
#define MUBRR2_BIT 2
#define MUBRR2_MASK 4
#define MUBRR3 3
#define MUBRR3_BIT 3
#define MUBRR3_MASK 8
#define MUBRR4 4
#define MUBRR4_BIT 4
#define MUBRR4_MASK 16
#define MUBRR5 5
#define MUBRR5_BIT 5
#define MUBRR5_MASK 32
#define MUBRR6 6
#define MUBRR6_BIT 6
#define MUBRR6_MASK 64
#define MUBRR7 7
#define MUBRR7_BIT 7
#define MUBRR7_MASK 128

sfrw MUBRRW = 0xcc;

sfrb EUCSRC = 0xca;
#define STP0 0
#define STP0_BIT 0
#define STP0_MASK 1
#define STP1 1
#define STP1_BIT 1
#define STP1_MASK 2
#define F1617 2
#define F1617_BIT 2
#define F1617_MASK 4
#define FEM 3
#define FEM_BIT 3
#define FEM_MASK 8

sfrb EUCSRB = 0xc9;
#define BODR 0
#define BODR_BIT 0
#define BODR_MASK 1
#define EMCH 1
#define EMCH_BIT 1
#define EMCH_MASK 2
#define EUSBS 3
#define EUSBS_BIT 3
#define EUSBS_MASK 8
#define EUSART 4
#define EUSART_BIT 4
#define EUSART_MASK 16

sfrb EUCSRA = 0xc8;
#define URxS0 0
#define URxS0_BIT 0
#define URxS0_MASK 1
#define URxS1 1
#define URxS1_BIT 1
#define URxS1_MASK 2
#define URxS2 2
#define URxS2_BIT 2
#define URxS2_MASK 4
#define URxS3 3
#define URxS3_BIT 3
#define URxS3_MASK 8
#define UTxS0 4
#define UTxS0_BIT 4
#define UTxS0_MASK 16
#define UTxS1 5
#define UTxS1_BIT 5
#define UTxS1_MASK 32
#define UTxS2 6
#define UTxS2_BIT 6
#define UTxS2_MASK 64
#define UTxS3 7
#define UTxS3_BIT 7
#define UTxS3_MASK 128

sfrb UDR = 0xc6;
#define UDR0 0
#define UDR0_BIT 0
#define UDR0_MASK 1
#define UDR1 1
#define UDR1_BIT 1
#define UDR1_MASK 2
#define UDR2 2
#define UDR2_BIT 2
#define UDR2_MASK 4
#define UDR3 3
#define UDR3_BIT 3
#define UDR3_MASK 8
#define UDR4 4
#define UDR4_BIT 4
#define UDR4_MASK 16
#define UDR5 5
#define UDR5_BIT 5
#define UDR5_MASK 32
#define UDR6 6
#define UDR6_BIT 6
#define UDR6_MASK 64
#define UDR7 7
#define UDR7_BIT 7
#define UDR7_MASK 128

sfrb UBRRH = 0xc5;
#define UBRR8 0
#define UBRR8_BIT 0
#define UBRR8_MASK 1
#define UBRR9 1
#define UBRR9_BIT 1
#define UBRR9_MASK 2
#define UBRR10 2
#define UBRR10_BIT 2
#define UBRR10_MASK 4
#define UBRR11 3
#define UBRR11_BIT 3
#define UBRR11_MASK 8

sfrb UBRRL = 0xc4;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrw UBRRW = 0xc4;

sfrb UCSRC = 0xc2;
#define UCPOL 0
#define UCPOL_BIT 0
#define UCPOL_MASK 1
#define UCSZ0 1
#define UCSZ0_BIT 1
#define UCSZ0_MASK 2
#define UCSZ1 2
#define UCSZ1_BIT 2
#define UCSZ1_MASK 4
#define USBS 3
#define USBS_BIT 3
#define USBS_MASK 8
#define UPM0 4
#define UPM0_BIT 4
#define UPM0_MASK 16
#define UPM1 5
#define UPM1_BIT 5
#define UPM1_MASK 32
#define UMSEL0 6
#define UMSEL0_BIT 6
#define UMSEL0_MASK 64

sfrb UCSRB = 0xc1;
#define TXB8 0
#define TXB8_BIT 0
#define TXB8_MASK 1
#define RXB8 1
#define RXB8_BIT 1
#define RXB8_MASK 2
#define UCSZ2 2
#define UCSZ2_BIT 2
#define UCSZ2_MASK 4
#define TXEN 3
#define TXEN_BIT 3
#define TXEN_MASK 8
#define RXEN 4
#define RXEN_BIT 4
#define RXEN_MASK 16
#define UDRIE 5
#define UDRIE_BIT 5
#define UDRIE_MASK 32
#define TXCIE 6
#define TXCIE_BIT 6
#define TXCIE_MASK 64
#define RXCIE 7
#define RXCIE_BIT 7
#define RXCIE_MASK 128

sfrb UCSRA = 0xc0;
#define MPCM 0
#define MPCM_BIT 0
#define MPCM_MASK 1
#define U2X 1
#define U2X_BIT 1
#define U2X_MASK 2
#define UPE 2
#define UPE_BIT 2
#define UPE_MASK 4
#define DOR 3
#define DOR_BIT 3
#define DOR_MASK 8
#define FE 4
#define FE_BIT 4
#define FE_MASK 16
#define UDRE 5
#define UDRE_BIT 5
#define UDRE_MASK 32
#define TXC 6
#define TXC_BIT 6
#define TXC_MASK 64
#define RXC 7
#define RXC_BIT 7
#define RXC_MASK 128

sfrb AC2CON = 0xaf;
#define AC2M0 0
#define AC2M0_BIT 0
#define AC2M0_MASK 1
#define AC2M1 1
#define AC2M1_BIT 1
#define AC2M1_MASK 2
#define AC2M2 2
#define AC2M2_BIT 2
#define AC2M2_MASK 4
#define AC2IS0 4
#define AC2IS0_BIT 4
#define AC2IS0_MASK 16
#define AC2IS1 5
#define AC2IS1_BIT 5
#define AC2IS1_MASK 32
#define AC2IE 6
#define AC2IE_BIT 6
#define AC2IE_MASK 64
#define AC2EN 7
#define AC2EN_BIT 7
#define AC2EN_MASK 128

sfrb AC1CON = 0xae;
#define AC1M0 0
#define AC1M0_BIT 0
#define AC1M0_MASK 1
#define AC1M1 1
#define AC1M1_BIT 1
#define AC1M1_MASK 2
#define AC1M2 2
#define AC1M2_BIT 2
#define AC1M2_MASK 4
#define AC1ICE 3
#define AC1ICE_BIT 3
#define AC1ICE_MASK 8
#define AC1IS0 4
#define AC1IS0_BIT 4
#define AC1IS0_MASK 16
#define AC1IS1 5
#define AC1IS1_BIT 5
#define AC1IS1_MASK 32
#define AC1IE 6
#define AC1IE_BIT 6
#define AC1IE_MASK 64
#define AC1EN 7
#define AC1EN_BIT 7
#define AC1EN_MASK 128

sfrb AC0CON = 0xad;
#define AC0M0 0
#define AC0M0_BIT 0
#define AC0M0_MASK 1
#define AC0M1 1
#define AC0M1_BIT 1
#define AC0M1_MASK 2
#define AC0M2 2
#define AC0M2_BIT 2
#define AC0M2_MASK 4
#define AC0IS0 4
#define AC0IS0_BIT 4
#define AC0IS0_MASK 16
#define AC0IS1 5
#define AC0IS1_BIT 5
#define AC0IS1_MASK 32
#define AC0IE 6
#define AC0IE_BIT 6
#define AC0IE_MASK 64
#define AC0EN 7
#define AC0EN_BIT 7
#define AC0EN_MASK 128

sfrb DACH = 0xac;
#define DACH0 0
#define DACH0_BIT 0
#define DACH0_MASK 1
#define DACH1 1
#define DACH1_BIT 1
#define DACH1_MASK 2
#define DACH2 2
#define DACH2_BIT 2
#define DACH2_MASK 4
#define DACH3 3
#define DACH3_BIT 3
#define DACH3_MASK 8
#define DACH4 4
#define DACH4_BIT 4
#define DACH4_MASK 16
#define DACH5 5
#define DACH5_BIT 5
#define DACH5_MASK 32
#define DACH6 6
#define DACH6_BIT 6
#define DACH6_MASK 64
#define DACH7 7
#define DACH7_BIT 7
#define DACH7_MASK 128

sfrb DACL = 0xab;
#define DACL0 0
#define DACL0_BIT 0
#define DACL0_MASK 1
#define DACL1 1
#define DACL1_BIT 1
#define DACL1_MASK 2
#define DACL2 2
#define DACL2_BIT 2
#define DACL2_MASK 4
#define DACL3 3
#define DACL3_BIT 3
#define DACL3_MASK 8
#define DACL4 4
#define DACL4_BIT 4
#define DACL4_MASK 16
#define DACL5 5
#define DACL5_BIT 5
#define DACL5_MASK 32
#define DACL6 6
#define DACL6_BIT 6
#define DACL6_MASK 64
#define DACL7 7
#define DACL7_BIT 7
#define DACL7_MASK 128

sfrw DACW = 0xab;

sfrb DACON = 0xaa;
#define DAEN 0
#define DAEN_BIT 0
#define DAEN_MASK 1
#define DAOE 1
#define DAOE_BIT 1
#define DAOE_MASK 2
#define DALA 2
#define DALA_BIT 2
#define DALA_MASK 4
#define DATS0 4
#define DATS0_BIT 4
#define DATS0_MASK 16
#define DATS1 5
#define DATS1_BIT 5
#define DATS1_MASK 32
#define DATS2 6
#define DATS2_BIT 6
#define DATS2_MASK 64
#define DAATE 7
#define DAATE_BIT 7
#define DAATE_MASK 128

sfrb PIM2 = 0xa5;
#define PEOPE2 0
#define PEOPE2_BIT 0
#define PEOPE2_MASK 1
#define PEVE2A 3
#define PEVE2A_BIT 3
#define PEVE2A_MASK 8
#define PEVE2B 4
#define PEVE2B_BIT 4
#define PEVE2B_MASK 16
#define PSEIE2 5
#define PSEIE2_BIT 5
#define PSEIE2_MASK 32

sfrb PIFR2 = 0xa4;
#define PEOP2 0
#define PEOP2_BIT 0
#define PEOP2_MASK 1
#define PRN20 1
#define PRN20_BIT 1
#define PRN20_MASK 2
#define PRN21 2
#define PRN21_BIT 2
#define PRN21_MASK 4
#define PEV2A 3
#define PEV2A_BIT 3
#define PEV2A_MASK 8
#define PEV2B 4
#define PEV2B_BIT 4
#define PEV2B_MASK 16
#define PSEI2 5
#define PSEI2_BIT 5
#define PSEI2_MASK 32

sfrb PIM1 = 0xa3;
#define PEOPE1 0
#define PEOPE1_BIT 0
#define PEOPE1_MASK 1
#define PEVE1A 3
#define PEVE1A_BIT 3
#define PEVE1A_MASK 8
#define PEVE1B 4
#define PEVE1B_BIT 4
#define PEVE1B_MASK 16
#define PSEIE1 5
#define PSEIE1_BIT 5
#define PSEIE1_MASK 32

sfrb PIFR1 = 0xa2;
#define PEOP1 0
#define PEOP1_BIT 0
#define PEOP1_MASK 1
#define PRN10 1
#define PRN10_BIT 1
#define PRN10_MASK 2
#define PRN11 2
#define PRN11_BIT 2
#define PRN11_MASK 4
#define PEV1A 3
#define PEV1A_BIT 3
#define PEV1A_MASK 8
#define PEV1B 4
#define PEV1B_BIT 4
#define PEV1B_MASK 16
#define PSEI1 5
#define PSEI1_BIT 5
#define PSEI1_MASK 32

sfrb PIM0 = 0xa1;
#define PEOPE0 0
#define PEOPE0_BIT 0
#define PEOPE0_MASK 1
#define PEVE0A 3
#define PEVE0A_BIT 3
#define PEVE0A_MASK 8
#define PEVE0B 4
#define PEVE0B_BIT 4
#define PEVE0B_MASK 16
#define PSEIE0 5
#define PSEIE0_BIT 5
#define PSEIE0_MASK 32

sfrb PIFR0 = 0xa0;
#define PEOP0 0
#define PEOP0_BIT 0
#define PEOP0_MASK 1
#define PRN00 1
#define PRN00_BIT 1
#define PRN00_MASK 2
#define PRN01 2
#define PRN01_BIT 2
#define PRN01_MASK 4
#define PEV0A 3
#define PEV0A_BIT 3
#define PEV0A_MASK 8
#define PEV0B 4
#define PEV0B_BIT 4
#define PEV0B_MASK 16
#define PSEI0 5
#define PSEI0_BIT 5
#define PSEI0_MASK 32

sfrb OCR1BH = 0x8b;
#define OCR1BH0 0
#define OCR1BH0_BIT 0
#define OCR1BH0_MASK 1
#define OCR1BH1 1
#define OCR1BH1_BIT 1
#define OCR1BH1_MASK 2
#define OCR1BH2 2
#define OCR1BH2_BIT 2
#define OCR1BH2_MASK 4
#define OCR1BH3 3
#define OCR1BH3_BIT 3
#define OCR1BH3_MASK 8
#define OCR1BH4 4
#define OCR1BH4_BIT 4
#define OCR1BH4_MASK 16
#define OCR1BH5 5
#define OCR1BH5_BIT 5
#define OCR1BH5_MASK 32
#define OCR1BH6 6
#define OCR1BH6_BIT 6
#define OCR1BH6_MASK 64
#define OCR1BH7 7
#define OCR1BH7_BIT 7
#define OCR1BH7_MASK 128

sfrb OCR1BL = 0x8a;
#define OCR1BL0 0
#define OCR1BL0_BIT 0
#define OCR1BL0_MASK 1
#define OCR1BL1 1
#define OCR1BL1_BIT 1
#define OCR1BL1_MASK 2
#define OCR1BL2 2
#define OCR1BL2_BIT 2
#define OCR1BL2_MASK 4
#define OCR1BL3 3
#define OCR1BL3_BIT 3
#define OCR1BL3_MASK 8
#define OCR1BL4 4
#define OCR1BL4_BIT 4
#define OCR1BL4_MASK 16
#define OCR1BL5 5
#define OCR1BL5_BIT 5
#define OCR1BL5_MASK 32
#define OCR1BL6 6
#define OCR1BL6_BIT 6
#define OCR1BL6_MASK 64
#define OCR1BL7 7
#define OCR1BL7_BIT 7
#define OCR1BL7_MASK 128

sfrw OCR1BW = 0x8a;

sfrb OCR1AH = 0x89;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x88;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x88;

sfrb ICR1H = 0x87;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x86;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x86;

sfrb TCNT1H = 0x85;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x84;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x84;

sfrb TCCR1C = 0x82;
#define FOC1B 6
#define FOC1B_BIT 6
#define FOC1B_MASK 64
#define FOC1A 7
#define FOC1A_BIT 7
#define FOC1A_MASK 128

sfrb TCCR1B = 0x81;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define WGM12 3
#define WGM12_BIT 3
#define WGM12_MASK 8
#define WGM13 4
#define WGM13_BIT 4
#define WGM13_MASK 16
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCCR1A = 0x80;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb DIDR1 = 0x7f;
#define ADC8D 0
#define ADC8D_BIT 0
#define ADC8D_MASK 1
#define ADC9D 1
#define ADC9D_BIT 1
#define ADC9D_MASK 2
#define ADC10D 2
#define ADC10D_BIT 2
#define ADC10D_MASK 4
#define AMP0ND 3
#define AMP0ND_BIT 3
#define AMP0ND_MASK 8
#define AMP0PD 4
#define AMP0PD_BIT 4
#define AMP0PD_MASK 16
#define ACMP0D 5
#define ACMP0D_BIT 5
#define ACMP0D_MASK 32

sfrb DIDR0 = 0x7e;
#define ADC0D 0
#define ADC0D_BIT 0
#define ADC0D_MASK 1
#define ADC1D 1
#define ADC1D_BIT 1
#define ADC1D_MASK 2
#define ADC2D 2
#define ADC2D_BIT 2
#define ADC2D_MASK 4
#define ADC3D 3
#define ADC3D_BIT 3
#define ADC3D_MASK 8
#define ADC4D 4
#define ADC4D_BIT 4
#define ADC4D_MASK 16
#define ADC5D 5
#define ADC5D_BIT 5
#define ADC5D_MASK 32
#define ADC6D 6
#define ADC6D_BIT 6
#define ADC6D_MASK 64
#define ADC7D 7
#define ADC7D_BIT 7
#define ADC7D_MASK 128

sfrb ADMUX = 0x7c;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define MUX2 2
#define MUX2_BIT 2
#define MUX2_MASK 4
#define MUX3 3
#define MUX3_BIT 3
#define MUX3_MASK 8
#define ADLAR 5
#define ADLAR_BIT 5
#define ADLAR_MASK 32
#define REFS0 6
#define REFS0_BIT 6
#define REFS0_MASK 64
#define REFS1 7
#define REFS1_BIT 7
#define REFS1_MASK 128

sfrb ADCSRB = 0x7b;
#define ADTS0 0
#define ADTS0_BIT 0
#define ADTS0_MASK 1
#define ADTS1 1
#define ADTS1_BIT 1
#define ADTS1_MASK 2
#define ADTS2 2
#define ADTS2_BIT 2
#define ADTS2_MASK 4
#define ADTS3 3
#define ADTS3_BIT 3
#define ADTS3_MASK 8
#define ADASCR 4
#define ADASCR_BIT 4
#define ADASCR_MASK 16
#define ADHSM 7
#define ADHSM_BIT 7
#define ADHSM_MASK 128

sfrb ADCSRA = 0x7a;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADATE 5
#define ADATE_BIT 5
#define ADATE_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x79;
#define ADCH0 0
#define ADCH0_BIT 0
#define ADCH0_MASK 1
#define ADCH1 1
#define ADCH1_BIT 1
#define ADCH1_MASK 2
#define ADCH2 2
#define ADCH2_BIT 2
#define ADCH2_MASK 4
#define ADCH3 3
#define ADCH3_BIT 3
#define ADCH3_MASK 8
#define ADCH4 4
#define ADCH4_BIT 4
#define ADCH4_MASK 16
#define ADCH5 5
#define ADCH5_BIT 5
#define ADCH5_MASK 32
#define ADCH6 6
#define ADCH6_BIT 6
#define ADCH6_MASK 64
#define ADCH7 7
#define ADCH7_BIT 7
#define ADCH7_MASK 128

sfrb ADCL = 0x78;
#define ADCL0 0
#define ADCL0_BIT 0
#define ADCL0_MASK 1
#define ADCL1 1
#define ADCL1_BIT 1
#define ADCL1_MASK 2
#define ADCL2 2
#define ADCL2_BIT 2
#define ADCL2_MASK 4
#define ADCL3 3
#define ADCL3_BIT 3
#define ADCL3_MASK 8
#define ADCL4 4
#define ADCL4_BIT 4
#define ADCL4_MASK 16
#define ADCL5 5
#define ADCL5_BIT 5
#define ADCL5_MASK 32
#define ADCL6 6
#define ADCL6_BIT 6
#define ADCL6_MASK 64
#define ADCL7 7
#define ADCL7_BIT 7
#define ADCL7_MASK 128

sfrw ADCW = 0x78;

sfrb AMP1CSR = 0x77;

sfrb AMP0CSR = 0x76;

sfrb TIMSK1 = 0x6f;
#define TOIE1 0
#define TOIE1_BIT 0
#define TOIE1_MASK 1
#define OCIE1A 1
#define OCIE1A_BIT 1
#define OCIE1A_MASK 2
#define OCIE1B 2
#define OCIE1B_BIT 2
#define OCIE1B_MASK 4
#define ICIE1 5
#define ICIE1_BIT 5
#define ICIE1_MASK 32

sfrb TIMSK0 = 0x6e;
#define TOIE0 0
#define TOIE0_BIT 0
#define TOIE0_MASK 1
#define OCIE0A 1
#define OCIE0A_BIT 1
#define OCIE0A_MASK 2
#define OCIE0B 2
#define OCIE0B_BIT 2
#define OCIE0B_MASK 4

sfrb EICRA = 0x69;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ISC10 2
#define ISC10_BIT 2
#define ISC10_MASK 4
#define ISC11 3
#define ISC11_BIT 3
#define ISC11_MASK 8
#define ISC20 4
#define ISC20_BIT 4
#define ISC20_MASK 16
#define ISC21 5
#define ISC21_BIT 5
#define ISC21_MASK 32
#define ISC30 6
#define ISC30_BIT 6
#define ISC30_MASK 64
#define ISC31 7
#define ISC31_BIT 7
#define ISC31_MASK 128

sfrb OSCCAL = 0x66;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64

sfrb PRR = 0x64;

sfrb CLKPR = 0x61;
#define CLKPS0 0
#define CLKPS0_BIT 0
#define CLKPS0_MASK 1
#define CLKPS1 1
#define CLKPS1_BIT 1
#define CLKPS1_MASK 2
#define CLKPS2 2
#define CLKPS2_BIT 2
#define CLKPS2_MASK 4
#define CLKPS3 3
#define CLKPS3_BIT 3
#define CLKPS3_MASK 8
#define CLKPCE 7
#define CLKPCE_BIT 7
#define CLKPCE_MASK 128

sfrb WDTCSR = 0x60;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16
#define WDP3 5
#define WDP3_BIT 5
#define WDP3_MASK 32
#define WDIE 6
#define WDIE_BIT 6
#define WDIE_MASK 64
#define WDIF 7
#define WDIF_BIT 7
#define WDIF_MASK 128

sfrb SREG = 0x5f;

sfrb SPH = 0x5e;
#define SP8 0
#define SP8_BIT 0
#define SP8_MASK 1
#define SP9 1
#define SP9_BIT 1
#define SP9_MASK 2
#define SP10 2
#define SP10_BIT 2
#define SP10_MASK 4
#define SP11 3
#define SP11_BIT 3
#define SP11_MASK 8
#define SP12 4
#define SP12_BIT 4
#define SP12_MASK 16
#define SP13 5
#define SP13_BIT 5
#define SP13_MASK 32
#define SP14 6
#define SP14_BIT 6
#define SP14_MASK 64
#define SP15 7
#define SP15_BIT 7
#define SP15_MASK 128

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrw SPW = 0x5d;

sfrb SPMCSR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define BLBSET 3
#define BLBSET_BIT 3
#define BLBSET_MASK 8
#define RWWSRE 4
#define RWWSRE_BIT 4
#define RWWSRE_MASK 16
#define RWWSB 6
#define RWWSB_BIT 6
#define RWWSB_MASK 64
#define SPMIE 7
#define SPMIE_BIT 7
#define SPMIE_MASK 128

sfrb MCUCR = 0x55;
#define IVCE 0
#define IVCE_BIT 0
#define IVCE_MASK 1
#define IVSEL 1
#define IVSEL_BIT 1
#define IVSEL_MASK 2
#define PUD 4
#define PUD_BIT 4
#define PUD_MASK 16
#define SPIPS 7
#define SPIPS_BIT 7
#define SPIPS_MASK 128

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8

sfrb SMCR = 0x53;
#define SE 0
#define SE_BIT 0
#define SE_MASK 1
#define SM0 1
#define SM0_BIT 1
#define SM0_MASK 2
#define SM1 2
#define SM1_BIT 2
#define SM1_MASK 4
#define SM2 3
#define SM2_BIT 3
#define SM2_MASK 8

sfrb ACSR = 0x50;

sfrb SPDR = 0x4e;
#define SPDR0 0
#define SPDR0_BIT 0
#define SPDR0_MASK 1
#define SPDR1 1
#define SPDR1_BIT 1
#define SPDR1_MASK 2
#define SPDR2 2
#define SPDR2_BIT 2
#define SPDR2_MASK 4
#define SPDR3 3
#define SPDR3_BIT 3
#define SPDR3_MASK 8
#define SPDR4 4
#define SPDR4_BIT 4
#define SPDR4_MASK 16
#define SPDR5 5
#define SPDR5_BIT 5
#define SPDR5_MASK 32
#define SPDR6 6
#define SPDR6_BIT 6
#define SPDR6_MASK 64
#define SPDR7 7
#define SPDR7_BIT 7
#define SPDR7_MASK 128

sfrb SPSR = 0x4d;
#define SPI2X 0
#define SPI2X_BIT 0
#define SPI2X_MASK 1
#define WCOL 6
#define WCOL_BIT 6
#define WCOL_MASK 64
#define SPIF 7
#define SPIF_BIT 7
#define SPIF_MASK 128

sfrb SPCR = 0x4c;
#define SPR0 0
#define SPR0_BIT 0
#define SPR0_MASK 1
#define SPR1 1
#define SPR1_BIT 1
#define SPR1_MASK 2
#define CPHA 2
#define CPHA_BIT 2
#define CPHA_MASK 4
#define CPOL 3
#define CPOL_BIT 3
#define CPOL_MASK 8
#define MSTR 4
#define MSTR_BIT 4
#define MSTR_MASK 16
#define DORD 5
#define DORD_BIT 5
#define DORD_MASK 32
#define SPE 6
#define SPE_BIT 6
#define SPE_MASK 64
#define SPIE 7
#define SPIE_BIT 7
#define SPIE_MASK 128

sfrb PLLCSR = 0x49;
#define PLOCK 0
#define PLOCK_BIT 0
#define PLOCK_MASK 1
#define PLLE 1
#define PLLE_BIT 1
#define PLLE_MASK 2
#define PLLF 2
#define PLLF_BIT 2
#define PLLF_MASK 4

sfrb OCR0B = 0x48;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb OCR0A = 0x47;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb TCNT0 = 0x46;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb TCCR0B = 0x45;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM02 3
#define WGM02_BIT 3
#define WGM02_MASK 8
#define FOC0B 6
#define FOC0B_BIT 6
#define FOC0B_MASK 64
#define FOC0A 7
#define FOC0A_BIT 7
#define FOC0A_MASK 128

sfrb TCCR0A = 0x44;
#define WGM00 0
#define WGM00_BIT 0
#define WGM00_MASK 1
#define WGM01 1
#define WGM01_BIT 1
#define WGM01_MASK 2
#define COM0B0 4
#define COM0B0_BIT 4
#define COM0B0_MASK 16
#define COM0B1 5
#define COM0B1_BIT 5
#define COM0B1_MASK 32
#define COM0A0 6
#define COM0A0_BIT 6
#define COM0A0_MASK 64
#define COM0A1 7
#define COM0A1_BIT 7
#define COM0A1_MASK 128

sfrb GTCCR = 0x43;
#define PSR10 0
#define PSR10_BIT 0
#define PSR10_MASK 1
#define ICPSEL1 6
#define ICPSEL1_BIT 6
#define ICPSEL1_MASK 64
#define TSM 7
#define TSM_BIT 7
#define TSM_MASK 128

sfrb EEARH = 0x42;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1
#define EEAR9 1
#define EEAR9_BIT 1
#define EEAR9_MASK 2
#define EEAR10 2
#define EEAR10_BIT 2
#define EEAR10_MASK 4
#define EEAR11 3
#define EEAR11_BIT 3
#define EEAR11_MASK 8

sfrb EEARL = 0x41;
#define EEARL0 0
#define EEARL0_BIT 0
#define EEARL0_MASK 1
#define EEARL1 1
#define EEARL1_BIT 1
#define EEARL1_MASK 2
#define EEARL2 2
#define EEARL2_BIT 2
#define EEARL2_MASK 4
#define EEARL3 3
#define EEARL3_BIT 3
#define EEARL3_MASK 8
#define EEARL4 4
#define EEARL4_BIT 4
#define EEARL4_MASK 16
#define EEARL5 5
#define EEARL5_BIT 5
#define EEARL5_MASK 32
#define EEARL6 6
#define EEARL6_BIT 6
#define EEARL6_MASK 64
#define EEARL7 7
#define EEARL7_BIT 7
#define EEARL7_MASK 128

sfrw EEARW = 0x41;

sfrb EEDR = 0x40;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3f;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEWE 1
#define EEWE_BIT 1
#define EEWE_MASK 2
#define EEMWE 2
#define EEMWE_BIT 2
#define EEMWE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8
#define EEPM0 4
#define EEPM0_BIT 4
#define EEPM0_MASK 16
#define EEPM1 5
#define EEPM1_BIT 5
#define EEPM1_MASK 32

sfrb GPIOR0 = 0x3e;
#define GPIOR00 0
#define GPIOR00_BIT 0
#define GPIOR00_MASK 1
#define GPIOR01 1
#define GPIOR01_BIT 1
#define GPIOR01_MASK 2
#define GPIOR02 2
#define GPIOR02_BIT 2
#define GPIOR02_MASK 4
#define GPIOR03 3
#define GPIOR03_BIT 3
#define GPIOR03_MASK 8
#define GPIOR04 4
#define GPIOR04_BIT 4
#define GPIOR04_MASK 16
#define GPIOR05 5
#define GPIOR05_BIT 5
#define GPIOR05_MASK 32
#define GPIOR06 6
#define GPIOR06_BIT 6
#define GPIOR06_MASK 64
#define GPIOR07 7
#define GPIOR07_BIT 7
#define GPIOR07_MASK 128

sfrb EIMSK = 0x3d;
#define INT0 0
#define INT0_BIT 0
#define INT0_MASK 1
#define INT1 1
#define INT1_BIT 1
#define INT1_MASK 2
#define INT2 2
#define INT2_BIT 2
#define INT2_MASK 4
#define INT3 3
#define INT3_BIT 3
#define INT3_MASK 8

sfrb EIFR = 0x3c;
#define INTF0 0
#define INTF0_BIT 0
#define INTF0_MASK 1
#define INTF1 1
#define INTF1_BIT 1
#define INTF1_MASK 2
#define INTF2 2
#define INTF2_BIT 2
#define INTF2_MASK 4
#define INTF3 3
#define INTF3_BIT 3
#define INTF3_MASK 8

sfrb GPIOR3 = 0x3b;
#define GPIOR30 0
#define GPIOR30_BIT 0
#define GPIOR30_MASK 1
#define GPIOR31 1
#define GPIOR31_BIT 1
#define GPIOR31_MASK 2
#define GPIOR32 2
#define GPIOR32_BIT 2
#define GPIOR32_MASK 4
#define GPIOR33 3
#define GPIOR33_BIT 3
#define GPIOR33_MASK 8
#define GPIOR34 4
#define GPIOR34_BIT 4
#define GPIOR34_MASK 16
#define GPIOR35 5
#define GPIOR35_BIT 5
#define GPIOR35_MASK 32
#define GPIOR36 6
#define GPIOR36_BIT 6
#define GPIOR36_MASK 64
#define GPIOR37 7
#define GPIOR37_BIT 7
#define GPIOR37_MASK 128

sfrb GPIOR2 = 0x3a;
#define GPIOR20 0
#define GPIOR20_BIT 0
#define GPIOR20_MASK 1
#define GPIOR21 1
#define GPIOR21_BIT 1
#define GPIOR21_MASK 2
#define GPIOR22 2
#define GPIOR22_BIT 2
#define GPIOR22_MASK 4
#define GPIOR23 3
#define GPIOR23_BIT 3
#define GPIOR23_MASK 8
#define GPIOR24 4
#define GPIOR24_BIT 4
#define GPIOR24_MASK 16
#define GPIOR25 5
#define GPIOR25_BIT 5
#define GPIOR25_MASK 32
#define GPIOR26 6
#define GPIOR26_BIT 6
#define GPIOR26_MASK 64
#define GPIOR27 7
#define GPIOR27_BIT 7
#define GPIOR27_MASK 128

sfrb GPIOR1 = 0x39;
#define GPIOR10 0
#define GPIOR10_BIT 0
#define GPIOR10_MASK 1
#define GPIOR11 1
#define GPIOR11_BIT 1
#define GPIOR11_MASK 2
#define GPIOR12 2
#define GPIOR12_BIT 2
#define GPIOR12_MASK 4
#define GPIOR13 3
#define GPIOR13_BIT 3
#define GPIOR13_MASK 8
#define GPIOR14 4
#define GPIOR14_BIT 4
#define GPIOR14_MASK 16
#define GPIOR15 5
#define GPIOR15_BIT 5
#define GPIOR15_MASK 32
#define GPIOR16 6
#define GPIOR16_BIT 6
#define GPIOR16_MASK 64
#define GPIOR17 7
#define GPIOR17_BIT 7
#define GPIOR17_MASK 128

sfrb TIFR1 = 0x36;
#define TOV1 0
#define TOV1_BIT 0
#define TOV1_MASK 1
#define OCF1A 1
#define OCF1A_BIT 1
#define OCF1A_MASK 2
#define OCF1B 2
#define OCF1B_BIT 2
#define OCF1B_MASK 4
#define ICF1 5
#define ICF1_BIT 5
#define ICF1_MASK 32

sfrb TIFR0 = 0x35;
#define TOV0 0
#define TOV0_BIT 0
#define TOV0_MASK 1
#define OCF0A 1
#define OCF0A_BIT 1
#define OCF0A_MASK 2
#define OCF0B 2
#define OCF0B_BIT 2
#define OCF0B_MASK 4

sfrb PORTE = 0x2e;
#define PORTE0 0
#define PORTE0_BIT 0
#define PORTE0_MASK 1
#define PORTE1 1
#define PORTE1_BIT 1
#define PORTE1_MASK 2
#define PORTE2 2
#define PORTE2_BIT 2
#define PORTE2_MASK 4

sfrb DDRE = 0x2d;
#define DDE0 0
#define DDE0_BIT 0
#define DDE0_MASK 1
#define DDE1 1
#define DDE1_BIT 1
#define DDE1_MASK 2
#define DDE2 2
#define DDE2_BIT 2
#define DDE2_MASK 4

sfrb PINE = 0x2c;
#define PINE0 0
#define PINE0_BIT 0
#define PINE0_MASK 1
#define PINE1 1
#define PINE1_BIT 1
#define PINE1_MASK 2
#define PINE2 2
#define PINE2_BIT 2
#define PINE2_MASK 4

sfrb PORTD = 0x2b;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x2a;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64
#define DDD7 7
#define DDD7_BIT 7
#define DDD7_MASK 128

sfrb PIND = 0x29;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb PORTC = 0x28;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1
#define PORTC1 1
#define PORTC1_BIT 1
#define PORTC1_MASK 2
#define PORTC2 2
#define PORTC2_BIT 2
#define PORTC2_MASK 4
#define PORTC3 3
#define PORTC3_BIT 3
#define PORTC3_MASK 8
#define PORTC4 4
#define PORTC4_BIT 4
#define PORTC4_MASK 16
#define PORTC5 5
#define PORTC5_BIT 5
#define PORTC5_MASK 32
#define PORTC6 6
#define PORTC6_BIT 6
#define PORTC6_MASK 64
#define PORTC7 7
#define PORTC7_BIT 7
#define PORTC7_MASK 128

sfrb DDRC = 0x27;
#define DDC0 0
#define DDC0_BIT 0
#define DDC0_MASK 1
#define DDC1 1
#define DDC1_BIT 1
#define DDC1_MASK 2
#define DDC2 2
#define DDC2_BIT 2
#define DDC2_MASK 4
#define DDC3 3
#define DDC3_BIT 3
#define DDC3_MASK 8
#define DDC4 4
#define DDC4_BIT 4
#define DDC4_MASK 16
#define DDC5 5
#define DDC5_BIT 5
#define DDC5_MASK 32
#define DDC6 6
#define DDC6_BIT 6
#define DDC6_MASK 64
#define DDC7 7
#define DDC7_BIT 7
#define DDC7_MASK 128

sfrb PINC = 0x26;
#define PINC0 0
#define PINC0_BIT 0
#define PINC0_MASK 1
#define PINC1 1
#define PINC1_BIT 1
#define PINC1_MASK 2
#define PINC2 2
#define PINC2_BIT 2
#define PINC2_MASK 4
#define PINC3 3
#define PINC3_BIT 3
#define PINC3_MASK 8
#define PINC4 4
#define PINC4_BIT 4
#define PINC4_MASK 16
#define PINC5 5
#define PINC5_BIT 5
#define PINC5_MASK 32
#define PINC6 6
#define PINC6_BIT 6
#define PINC6_MASK 64
#define PINC7 7
#define PINC7_BIT 7
#define PINC7_MASK 128

sfrb PORTB = 0x25;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x24;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x23;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

#endif
