// CrossWorks Tasking Library.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

/*
  saved stack has register and the call stack pointer      
      r31   // high address
      r30
      r27
      ...
      r0
      sreg
      spl
  sp->sph  // low address

  call stack has the saved PC as top element

  sph<<8|spl->
      saved pc
      top of call stack
      ..
      bottom of call stack

  ST      -Y, R31
  ST      -Y, R30
  ST      -Y, R27
  ST      -Y, R26
  ST      -Y, R25
  ST      -Y, R24
  ST      -Y, R23
  ST      -Y, R22
  ST      -Y, R21
  ST      -Y, R20
  ST      -Y, R19
  ST      -Y, R18
  ST      -Y, R17
  ST      -Y, R16
  ST      -Y, R15
  ST      -Y, R14
  ST      -Y, R13
  ST      -Y, R12
  ST      -Y, R11
  ST      -Y, R10
  ST      -Y, R9
  ST      -Y, R8
  ST      -Y, R7
  ST      -Y, R6
  ST      -Y, R5
  ST      -Y, R4
  ST      -Y, R3
  ST      -Y, R2
  ST      -Y, R1
  ST      -Y, R0
  IN      R31, 0x3f // sreg
  ST      -Y, R31
  IN      R31, 0x3d // spl
  ST      -Y, R31
  IN      R31, 0x3e // sph
  ST      -Y, R31
*/



	.text
	.code
	.align 0

        .public _ctl_private_init_registers  
	.public _ctl_private_switch_context        
        .public _ctl_private_switch_isr_context
        .public _ctl_private_isr_return
	.public _ctl_global_interrupts_set

// void 
// ctl_private_init_registers(Task *t,                     -- r26:27
//                            void (*entrypoint)(void *),  -- r24:25
//                            void *parameter,             -- r22:23        
//                            void (*exitpoint)(void),     -- r20:21
//                            unsigned *call_stack)        -- *Y:*Y+1   
_ctl_private_init_registers: 
        // push exitpoint and entrypoint onto the call_stack
        ld r30, y
        ldd r31, y+1; Z contains call_stack
#ifdef __8M
        st -z, r20
        st -z, r21; pushed exitpoint
        st -z, r0; extend to 3 byte
        st -z, r24
        st -z, r25; pushed entrypoint
        st -z, r0; extend to 3 byte
#else
        st -z, r20
        st -z, r21; pushed exitpoint
        st -z, r24
        st -z, r25; pushed entrypoint
#endif
        sbiw z, 1; reti pre-decrements
        std y+1, r31
        st y, r30; update call_stack        
        // load task->stack_pointer into Z
        ld r30, x+
        ld r31, x
        // *(--stack_pointer)=31
        // *(--stack_pointer)=30
        ldi r24, 31
        st -z, r24
        ldi r24, 30
        st -z, r24       
        // *(--stack_pointer) = parameter
        st -z, r22 // saved r27
        st -z, r23 // saved r26
        // for (i=25;i;i--) *(--stack_pointer)=i
        ldi r24, 25
L1:
        st -z, r24
        dec r24
        tst r24
        brne L1
        st -z, r24
        // *(--stack_pointer) = GIE
        ldi r24, 0x80
        st -z, r24
        // *(--stack_pointer) = spl
        ld r20, y
        st -z, r20
        // *(--stack_pointer) = sph
        ldd r21, y+1        
        st -z, r21
        // task->stack_pointer = stack_pointer
        st x, r31
        st -x, r30
        ret

// void ctl_private_switch_context(Task *save,    -- r26:27 (x)
//                                 Task *restore) -- r24:25
// sp is r28:29 (Y)
_ctl_private_switch_context:
        // save register state to the stack        
        st -y, r31
        st -y, r30
        st -y, r27
        st -y, r26
        st -y, r25
        st -y, r24
        st -y, r23
        st -y, r22
        st -y, r21
        st -y, r20
        st -y, r19
        st -y, r18
        st -y, r17
        st -y, r16
        st -y, r15
        st -y, r14
        st -y, r13
        st -y, r12
        st -y, r11
        st -y, r10
        st -y, r9
        st -y, r8
        st -y, r7
        st -y, r6
        st -y, r5
        st -y, r4
        st -y, r3
        st -y, r2
        st -y, r1
        st -y, r0
        // save the PC to the call stack
        rcall L10
L10:    
        // save sreg
        in r30, 0x3f 
        st -y, r30
        // save the call stack pointer
        in r30, 0x3d // spl
        st -y, r30
        in r30, 0x3e // sph
        st -y, r30
        // save->stack_pointer = sp;
        movw r30, r26
        st z, r28
        std z+1, r29
        // adjust the saved PC to be L11
        in r31, 0x3e // sph
        in r30, 0x3d // spl
#ifdef __8M
        ldd r23, z+3
        ldd r26, z+2
        ldd r27, z+1
        // r23:r26:r27 contains the saved PC      
        ldi r20, (L11-L10)/2
        ldi r21, 0
        ldi r22, 0
        add r23, r20
        adc r26, r21
        adc r27, r22
        std z+1, r27
        std z+2, r26
        std z+3, r23
#else
        ldd r26, z+2
        ldd r27, z+1
        // r26:r27 contains the saved PC      
        ldi r20, (L11-L10)/2
        ldi r21, 0
        add r26, r20
        adc r27, r21
        std z+1, r27
        std z+2, r26
#endif
        // sp = restore->stackPointer
        movw r26, r24
        ld r28, x+
        ld r29, x        
        rjmp ctl_private_restore_registers_from_SP
L11:
        ret

// void _ctl_private_switch_isr_context(void *savedRegisters, -- r26:27
//                                      Task *save,           -- r24:25
//                                      Task *restore);       -- r22:23
// sp is r28:29 (Y)
_ctl_private_switch_isr_context:
        // save->stack_pointer = savedRegisters
        movw r30, r24
        st z, r26
        std z+1, r27
        // sp = restore->stack_pointer
        movw r30, r22
        ld r28, z
        ldd r29, z+1
        rjmp     ctl_private_restore_registers_from_SP

// void ctl_private_isr_return(void *savedRegisters); -- r26:27
// sp is r28:29 (Y)
_ctl_private_isr_return:
        movw   r28, r26

ctl_private_restore_registers_from_SP:
        // restore the call stack pointer
        ld r30, y+
        out 0x3e, r30 // sph
        ld r30, y+
        out 0x3d, r30 // spl
        // restore sreg with GIE cleared
        ld r30, y+
        cbr r30, 0x80
        out 0x3f, r30
        // restore the other registers
        ld r0, y+
        ld r1, y+
        ld r2, y+
        ld r3, y+
        ld r4, y+
        ld r5, y+
        ld r6, y+
        ld r7, y+
        ld r8, y+
        ld r9, y+
        ld r10, y+
        ld r11, y+
        ld r12, y+
        ld r13, y+
        ld r14, y+
        ld r15, y+
        ld r16, y+
        ld r17, y+
        ld r18, y+
        ld r19, y+
        ld r20, y+
        ld r21, y+
        ld r22, y+
        ld r23, y+
        ld r24, y+
        ld r25, y+
        ld r26, y+
        ld r27, y+
        ld r30, y+
        ld r31, y+
        reti          

//int ctl_set_interrupts(int e) -- r26:r27
_ctl_global_interrupts_set:
        clr r27
        brid L35
        ldi r27, 1
L35
        tst r26
        breq L40
        sei
        rjmp L45
L40:
        cli
L45:
        mov r26, r27
        clr r27
        ret


