#include <avr.h>

  .dsect "CALLSTACK"
  .keep
  DS      call_stack_size

  .code

#define SPH 0x3e
#define SPL 0x3d
  
reset:
  ; Set up call stack
  ; SP points to the next empty location
  ldi     r16, high(SFE(CALLSTACK)-1)
  out     SPH, r16
  ldi     r16, low(SFE(CALLSTACK)-1)
  out     SPL, r16

  .vectors
  .keep
  org  RESET_vect
  rjmp   reset
