// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <avr.h>
#include <ctl_api.h>

static void (*timer_isr)(void);
static void (*button_pressed_isr)(void);

void ctl_board_init(void)
{
  DDRA = 0xff; // set port to output
  PORTA = 0xff; // turn the leds off
}

void ctl_start_timer(CTL_ISR_FN_t isr)
{
  timer_isr = isr;
  TIMSK = (1<<TOIE0_BIT); // Interrupt on timer0 overflow
  TCCR0 = (0<<WGM01_BIT)|(0<<WGM00_BIT)|(2<<CS00_BIT); // Normal operation (timer0 overflow is cleared on interrupt), divide prescaler by 8
}

unsigned long ctl_get_ticks_per_second(void)
{
  return 0x3e8;
}

void TIMER0_OVF_IRQ(void) __ctl_interrupt[TIMER0_OVF_vect]
{
  timer_isr();
}

void ctl_board_on_button_pressed(CTL_ISR_FN_t isr)
{
  button_pressed_isr = isr; 
   // Interrupt on external interrupt 0
  EICRA = 3;
  EIMSK = 1;
}

void INT0_IRQ(void) __ctl_interrupt[INT0_vect]
{   
  button_pressed_isr();
}

void ctl_board_set_leds(unsigned v)
{
  if (v)
    PORTA = 0xfe;
  else
    PORTA = 0xff;
}

