//***************************************************************************
//
//  File........: usart.c
//
//  Author(s)...: ATMEL Norway
//
//  Target(s)...: ATmega169
//
//  Compiler....: IAR EWAAVR 2.28a
//
//  Description.: AVR Butterfly USART routines
//
//  Revisions...: 1.0
//
//  YYYYMMDD - VER. - COMMENT                                       - SIGN.
//
//  20030116 - 1.0  - Created                                       - LHM
//
//***************************************************************************

//#include <inavr.h>

#include "iom169.h"
#include "main.h"
#include "usart.h"


/*****************************************************************************
*
*   Function name : USART_Init
*
*   Returns :       None
*
*   Parameters :    unsigned int baudrate
*
*   Purpose :       Initialize the USART
*
*****************************************************************************/
void USART_Init(unsigned int baudrate)
{
    // Set baud rate
    UBRRH = (unsigned char)(baudrate>>8);
    UBRRL = (unsigned char)baudrate;

    // Enable 2x speed
    UCSRA = (1<<U2X_BIT);

    // Enable receiver and transmitter
    UCSRB = (1<<RXEN_BIT)|(0<<TXEN_BIT)|(0<<RXCIE_BIT)|(0<<UDRIE_BIT);

    // Async. mode, 8N1
    UCSRC = (0<<UMSEL_BIT)|(0<<UPM0_BIT)|(0<<USBS_BIT)|(3<<UCSZ0_BIT)|(0<<UCPOL_BIT);
}


/*****************************************************************************
*
*   Function name : Usart_Tx
*
*   Returns :       None
*
*   Parameters :    char data: byte to send
*
*   Purpose :       Send one byte through the USART
*
*****************************************************************************/
void Usart_Tx(char data)
{
    while (!(UCSRA & (1<<UDRE_BIT)));
    UDR = data;
}


/*****************************************************************************
*
*   Function name : Usart_Rx
*
*   Returns :       char: byte received
*
*   Parameters :    None
*
*   Purpose :       Receives one byte from the USART
*
*****************************************************************************/
char Usart_Rx(void)
{
    while (!(UCSRA & (1<<RXC_BIT)));
    return UDR;
}
