#ifndef __ATtiny28_h
#define __ATtiny28_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0002
#define INT1_vect 0x0004
#define LOW-LEVEL_I/O_PINS_vect 0x0006
#define TIMER0_OVF_vect 0x0008
#define ANA_COMP_vect 0x000a

// I/O addresses


sfrb SREG = 0x5f;

sfrb PORTA = 0x3b;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8

sfrb PACR = 0x3a;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define PA2HC 2
#define PA2HC_BIT 2
#define PA2HC_MASK 4
#define DDA3 3
#define DDA3_BIT 3
#define DDA3_MASK 8

sfrb PINA = 0x39;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb PORTD = 0x32;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x31;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64
#define DDD7 7
#define DDD7_BIT 7
#define DDD7_MASK 128

sfrb PIND = 0x30;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb ACSR = 0x28;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb MCUCS = 0x27;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8
#define SM 4
#define SM_BIT 4
#define SM_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32
#define PLUPB 7
#define PLUPB_BIT 7
#define PLUPB_MASK 128

sfrb ICR = 0x26;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ICS10 2
#define ICS10_BIT 2
#define ICS10_MASK 4
#define ICS11 3
#define ICS11_BIT 3
#define ICS11_MASK 8
#define TOIE0 4
#define TOIE0_BIT 4
#define TOIE0_MASK 16
#define LLIE 5
#define LLIE_BIT 5
#define LLIE_MASK 32
#define INT0 6
#define INT0_BIT 6
#define INT0_MASK 64
#define INT1 7
#define INT1_BIT 7
#define INT1_MASK 128

sfrb IFR = 0x25;
#define TOV0 4
#define TOV0_BIT 4
#define TOV0_MASK 16
#define INTF0 6
#define INTF0_BIT 6
#define INTF0_MASK 64
#define INTF1 7
#define INTF1_BIT 7
#define INTF1_MASK 128

sfrb TCCR0 = 0x24;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define OOM00 3
#define OOM00_BIT 3
#define OOM00_MASK 8
#define OOM01 4
#define OOM01_BIT 4
#define OOM01_MASK 16
#define FOV0 7
#define FOV0_BIT 7
#define FOV0_MASK 128

sfrb TCNT0 = 0x23;
#define TCNT00 0
#define TCNT00_BIT 0
#define TCNT00_MASK 1
#define TCNT01 1
#define TCNT01_BIT 1
#define TCNT01_MASK 2
#define TCNT02 2
#define TCNT02_BIT 2
#define TCNT02_MASK 4
#define TCNT03 3
#define TCNT03_BIT 3
#define TCNT03_MASK 8
#define TCNT04 4
#define TCNT04_BIT 4
#define TCNT04_MASK 16
#define TCNT05 5
#define TCNT05_BIT 5
#define TCNT05_MASK 32
#define TCNT06 6
#define TCNT06_BIT 6
#define TCNT06_MASK 64
#define TCNT07 7
#define TCNT07_BIT 7
#define TCNT07_MASK 128

sfrb MODCR = 0x22;
#define MCONF0 0
#define MCONF0_BIT 0
#define MCONF0_MASK 1
#define MCONF1 1
#define MCONF1_BIT 1
#define MCONF1_MASK 2
#define MCONF2 2
#define MCONF2_BIT 2
#define MCONF2_MASK 4
#define ONTIM0 3
#define ONTIM0_BIT 3
#define ONTIM0_MASK 8
#define ONTIM1 4
#define ONTIM1_BIT 4
#define ONTIM1_MASK 16
#define ONTIM2 5
#define ONTIM2_BIT 5
#define ONTIM2_MASK 32
#define OTIM3 6
#define OTIM3_BIT 6
#define OTIM3_MASK 64
#define ONTIM4 7
#define ONTIM4_BIT 7
#define ONTIM4_MASK 128

sfrb WDTCR = 0x21;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDTOE 4
#define WDTOE_BIT 4
#define WDTOE_MASK 16
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64
#define CAL7 7
#define CAL7_BIT 7
#define CAL7_MASK 128

#endif
