#ifndef __ATmega128_h
#define __ATmega128_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0004
#define INT1_vect 0x0008
#define INT2_vect 0x000c
#define INT3_vect 0x0010
#define INT4_vect 0x0014
#define INT5_vect 0x0018
#define INT6_vect 0x001c
#define INT7_vect 0x0020
#define TIMER2_COMP_vect 0x0024
#define TIMER2_OVF_vect 0x0028
#define TIMER1_CAPT_vect 0x002c
#define TIMER1_COMPA_vect 0x0030
#define TIMER1_COMPB_vect 0x0034
#define TIMER1_OVF_vect 0x0038
#define TIMER0_COMP_vect 0x003c
#define TIMER0_OVF_vect 0x0040
#define SPI_STC_vect 0x0044
#define USART0_RX_vect 0x0048
#define USART0_UDRE_vect 0x004c
#define USART0_TX_vect 0x0050
#define ADC_vect 0x0054
#define EE_READY_vect 0x0058
#define ANALOG_COMP_vect 0x005c
#define TIMER1_COMPC_vect 0x0060
#define TIMER3_CAPT_vect 0x0064
#define TIMER3_COMPA_vect 0x0068
#define TIMER3_COMPB_vect 0x006c
#define TIMER3_COMPC_vect 0x0070
#define TIMER3_OVF_vect 0x0074
#define USART1_RX_vect 0x0078
#define USART1_UDRE_vect 0x007c
#define USART1_TX_vect 0x0080
#define TWI_vect 0x0084
#define SPM_READY_vect 0x0088

// I/O addresses


sfrb UCSR1C = 0x9d;
#define UCPOL1 0
#define UCPOL1_BIT 0
#define UCPOL1_MASK 1
#define UCSZ10 1
#define UCSZ10_BIT 1
#define UCSZ10_MASK 2
#define UCSZ11 2
#define UCSZ11_BIT 2
#define UCSZ11_MASK 4
#define USBS1 3
#define USBS1_BIT 3
#define USBS1_MASK 8
#define UPM10 4
#define UPM10_BIT 4
#define UPM10_MASK 16
#define UPM11 5
#define UPM11_BIT 5
#define UPM11_MASK 32
#define UMSEL1 6
#define UMSEL1_BIT 6
#define UMSEL1_MASK 64

sfrb UDR1 = 0x9c;
#define UDR10 0
#define UDR10_BIT 0
#define UDR10_MASK 1
#define UDR11 1
#define UDR11_BIT 1
#define UDR11_MASK 2
#define UDR12 2
#define UDR12_BIT 2
#define UDR12_MASK 4
#define UDR13 3
#define UDR13_BIT 3
#define UDR13_MASK 8
#define UDR14 4
#define UDR14_BIT 4
#define UDR14_MASK 16
#define UDR15 5
#define UDR15_BIT 5
#define UDR15_MASK 32
#define UDR16 6
#define UDR16_BIT 6
#define UDR16_MASK 64
#define UDR17 7
#define UDR17_BIT 7
#define UDR17_MASK 128

sfrb UCSR1A = 0x9b;
#define MPCM1 0
#define MPCM1_BIT 0
#define MPCM1_MASK 1
#define U2X1 1
#define U2X1_BIT 1
#define U2X1_MASK 2
#define UPE1 2
#define UPE1_BIT 2
#define UPE1_MASK 4
#define DOR1 3
#define DOR1_BIT 3
#define DOR1_MASK 8
#define FE1 4
#define FE1_BIT 4
#define FE1_MASK 16
#define UDRE1 5
#define UDRE1_BIT 5
#define UDRE1_MASK 32
#define TXC1 6
#define TXC1_BIT 6
#define TXC1_MASK 64
#define RXC1 7
#define RXC1_BIT 7
#define RXC1_MASK 128

sfrb UCSR1B = 0x9a;
#define TXB81 0
#define TXB81_BIT 0
#define TXB81_MASK 1
#define RXB81 1
#define RXB81_BIT 1
#define RXB81_MASK 2
#define UCSZ12 2
#define UCSZ12_BIT 2
#define UCSZ12_MASK 4
#define TXEN1 3
#define TXEN1_BIT 3
#define TXEN1_MASK 8
#define RXEN1 4
#define RXEN1_BIT 4
#define RXEN1_MASK 16
#define UDRIE1 5
#define UDRIE1_BIT 5
#define UDRIE1_MASK 32
#define TXCIE1 6
#define TXCIE1_BIT 6
#define TXCIE1_MASK 64
#define RXCIE1 7
#define RXCIE1_BIT 7
#define RXCIE1_MASK 128

sfrb UBRR1L = 0x99;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrb UBRR1H = 0x98;
#define UBRR8 0
#define UBRR8_BIT 0
#define UBRR8_MASK 1
#define UBRR9 1
#define UBRR9_BIT 1
#define UBRR9_MASK 2
#define UBRR10 2
#define UBRR10_BIT 2
#define UBRR10_MASK 4
#define UBRR11 3
#define UBRR11_BIT 3
#define UBRR11_MASK 8

sfrb UCSR0C = 0x95;
#define UCPOL0 0
#define UCPOL0_BIT 0
#define UCPOL0_MASK 1
#define UCSZ00 1
#define UCSZ00_BIT 1
#define UCSZ00_MASK 2
#define UCSZ01 2
#define UCSZ01_BIT 2
#define UCSZ01_MASK 4
#define USBS0 3
#define USBS0_BIT 3
#define USBS0_MASK 8
#define UPM00 4
#define UPM00_BIT 4
#define UPM00_MASK 16
#define UPM01 5
#define UPM01_BIT 5
#define UPM01_MASK 32
#define UMSEL0 6
#define UMSEL0_BIT 6
#define UMSEL0_MASK 64

sfrb UBRR0H = 0x90;
#define UBRR8 0
#define UBRR8_BIT 0
#define UBRR8_MASK 1
#define UBRR9 1
#define UBRR9_BIT 1
#define UBRR9_MASK 2
#define UBRR10 2
#define UBRR10_BIT 2
#define UBRR10_MASK 4
#define UBRR11 3
#define UBRR11_BIT 3
#define UBRR11_MASK 8

sfrb TCCR3C = 0x8c;
#define FOC3C 5
#define FOC3C_BIT 5
#define FOC3C_MASK 32
#define FOC3B 6
#define FOC3B_BIT 6
#define FOC3B_MASK 64
#define FOC3A 7
#define FOC3A_BIT 7
#define FOC3A_MASK 128

sfrb TCCR3A = 0x8b;
#define WGM30 0
#define WGM30_BIT 0
#define WGM30_MASK 1
#define WGM31 1
#define WGM31_BIT 1
#define WGM31_MASK 2
#define COM3C0 2
#define COM3C0_BIT 2
#define COM3C0_MASK 4
#define COM3C1 3
#define COM3C1_BIT 3
#define COM3C1_MASK 8
#define COM3B0 4
#define COM3B0_BIT 4
#define COM3B0_MASK 16
#define COM3B1 5
#define COM3B1_BIT 5
#define COM3B1_MASK 32
#define COM3A0 6
#define COM3A0_BIT 6
#define COM3A0_MASK 64
#define COM3A1 7
#define COM3A1_BIT 7
#define COM3A1_MASK 128

sfrb TCCR3B = 0x8a;
#define CS30 0
#define CS30_BIT 0
#define CS30_MASK 1
#define CS31 1
#define CS31_BIT 1
#define CS31_MASK 2
#define CS32 2
#define CS32_BIT 2
#define CS32_MASK 4
#define WGM32 3
#define WGM32_BIT 3
#define WGM32_MASK 8
#define WGM33 4
#define WGM33_BIT 4
#define WGM33_MASK 16
#define ICES3 6
#define ICES3_BIT 6
#define ICES3_MASK 64
#define ICNC3 7
#define ICNC3_BIT 7
#define ICNC3_MASK 128

sfrb TCNT3H = 0x89;
#define TCNT3H0 0
#define TCNT3H0_BIT 0
#define TCNT3H0_MASK 1
#define TCNT3H1 1
#define TCNT3H1_BIT 1
#define TCNT3H1_MASK 2
#define TCNT3H2 2
#define TCNT3H2_BIT 2
#define TCNT3H2_MASK 4
#define TCNT3H3 3
#define TCNT3H3_BIT 3
#define TCNT3H3_MASK 8
#define TCNT3H4 4
#define TCNT3H4_BIT 4
#define TCNT3H4_MASK 16
#define TCNT3H5 5
#define TCNT3H5_BIT 5
#define TCNT3H5_MASK 32
#define TCNT3H6 6
#define TCNT3H6_BIT 6
#define TCNT3H6_MASK 64
#define TCNT3H7 7
#define TCNT3H7_BIT 7
#define TCNT3H7_MASK 128

sfrb TCNT3L = 0x88;
#define TCN3L0 0
#define TCN3L0_BIT 0
#define TCN3L0_MASK 1
#define TCN3L1 1
#define TCN3L1_BIT 1
#define TCN3L1_MASK 2
#define TCN3L2 2
#define TCN3L2_BIT 2
#define TCN3L2_MASK 4
#define TCN3L3 3
#define TCN3L3_BIT 3
#define TCN3L3_MASK 8
#define TCN3L4 4
#define TCN3L4_BIT 4
#define TCN3L4_MASK 16
#define TCN3L5 5
#define TCN3L5_BIT 5
#define TCN3L5_MASK 32
#define TCN3L6 6
#define TCN3L6_BIT 6
#define TCN3L6_MASK 64
#define TCN3L7 7
#define TCN3L7_BIT 7
#define TCN3L7_MASK 128

sfrw TCNT3W = 0x88;

sfrb OCR3AH = 0x87;
#define OCR3AH0 0
#define OCR3AH0_BIT 0
#define OCR3AH0_MASK 1
#define OCR3AH1 1
#define OCR3AH1_BIT 1
#define OCR3AH1_MASK 2
#define OCR3AH2 2
#define OCR3AH2_BIT 2
#define OCR3AH2_MASK 4
#define OCR3AH3 3
#define OCR3AH3_BIT 3
#define OCR3AH3_MASK 8
#define OCR3AH4 4
#define OCR3AH4_BIT 4
#define OCR3AH4_MASK 16
#define OCR3AH5 5
#define OCR3AH5_BIT 5
#define OCR3AH5_MASK 32
#define OCR3AH6 6
#define OCR3AH6_BIT 6
#define OCR3AH6_MASK 64
#define OCR3AH7 7
#define OCR3AH7_BIT 7
#define OCR3AH7_MASK 128

sfrb OCR3AL = 0x86;
#define OCR3AL0 0
#define OCR3AL0_BIT 0
#define OCR3AL0_MASK 1
#define OCR3AL1 1
#define OCR3AL1_BIT 1
#define OCR3AL1_MASK 2
#define OCR3AL2 2
#define OCR3AL2_BIT 2
#define OCR3AL2_MASK 4
#define OCR3AL3 3
#define OCR3AL3_BIT 3
#define OCR3AL3_MASK 8
#define OCR3AL4 4
#define OCR3AL4_BIT 4
#define OCR3AL4_MASK 16
#define OCR3AL5 5
#define OCR3AL5_BIT 5
#define OCR3AL5_MASK 32
#define OCR3AL6 6
#define OCR3AL6_BIT 6
#define OCR3AL6_MASK 64
#define OCR3AL7 7
#define OCR3AL7_BIT 7
#define OCR3AL7_MASK 128

sfrw OCR3AW = 0x86;

sfrb OCR3BH = 0x85;
#define OCR3BH0 0
#define OCR3BH0_BIT 0
#define OCR3BH0_MASK 1
#define OCR3BH1 1
#define OCR3BH1_BIT 1
#define OCR3BH1_MASK 2
#define OCR3BH2 2
#define OCR3BH2_BIT 2
#define OCR3BH2_MASK 4
#define OCR3BH3 3
#define OCR3BH3_BIT 3
#define OCR3BH3_MASK 8
#define OCR3BH4 4
#define OCR3BH4_BIT 4
#define OCR3BH4_MASK 16
#define OCR3BH5 5
#define OCR3BH5_BIT 5
#define OCR3BH5_MASK 32
#define OCR3BH6 6
#define OCR3BH6_BIT 6
#define OCR3BH6_MASK 64
#define OCR3BH7 7
#define OCR3BH7_BIT 7
#define OCR3BH7_MASK 128

sfrb OCR3BL = 0x84;
#define OCR3BL0 0
#define OCR3BL0_BIT 0
#define OCR3BL0_MASK 1
#define OCR3BL1 1
#define OCR3BL1_BIT 1
#define OCR3BL1_MASK 2
#define OCR3BL2 2
#define OCR3BL2_BIT 2
#define OCR3BL2_MASK 4
#define OCR3BL3 3
#define OCR3BL3_BIT 3
#define OCR3BL3_MASK 8
#define OCR3BL4 4
#define OCR3BL4_BIT 4
#define OCR3BL4_MASK 16
#define OCR3BL5 5
#define OCR3BL5_BIT 5
#define OCR3BL5_MASK 32
#define OCR3BL6 6
#define OCR3BL6_BIT 6
#define OCR3BL6_MASK 64
#define OCR3BL7 7
#define OCR3BL7_BIT 7
#define OCR3BL7_MASK 128

sfrw OCR3BW = 0x84;

sfrb OCR3CH = 0x83;
#define OCR3CH0 0
#define OCR3CH0_BIT 0
#define OCR3CH0_MASK 1
#define OCR3CH1 1
#define OCR3CH1_BIT 1
#define OCR3CH1_MASK 2
#define OCR3CH2 2
#define OCR3CH2_BIT 2
#define OCR3CH2_MASK 4
#define OCR3CH3 3
#define OCR3CH3_BIT 3
#define OCR3CH3_MASK 8
#define OCR3CH4 4
#define OCR3CH4_BIT 4
#define OCR3CH4_MASK 16
#define OCR3CH5 5
#define OCR3CH5_BIT 5
#define OCR3CH5_MASK 32
#define OCR3CH6 6
#define OCR3CH6_BIT 6
#define OCR3CH6_MASK 64
#define OCR3CH7 7
#define OCR3CH7_BIT 7
#define OCR3CH7_MASK 128

sfrb OCR3CL = 0x82;
#define OCR3CL0 0
#define OCR3CL0_BIT 0
#define OCR3CL0_MASK 1
#define OCR3CL1 1
#define OCR3CL1_BIT 1
#define OCR3CL1_MASK 2
#define OCR3CL2 2
#define OCR3CL2_BIT 2
#define OCR3CL2_MASK 4
#define OCR3CL3 3
#define OCR3CL3_BIT 3
#define OCR3CL3_MASK 8
#define OCR3CL4 4
#define OCR3CL4_BIT 4
#define OCR3CL4_MASK 16
#define OCR3CL5 5
#define OCR3CL5_BIT 5
#define OCR3CL5_MASK 32
#define OCR3CL6 6
#define OCR3CL6_BIT 6
#define OCR3CL6_MASK 64
#define OCR3CL7 7
#define OCR3CL7_BIT 7
#define OCR3CL7_MASK 128

sfrw OCR3CW = 0x82;

sfrb ICR3H = 0x81;
#define ICR3H0 0
#define ICR3H0_BIT 0
#define ICR3H0_MASK 1
#define ICR3H1 1
#define ICR3H1_BIT 1
#define ICR3H1_MASK 2
#define ICR3H2 2
#define ICR3H2_BIT 2
#define ICR3H2_MASK 4
#define ICR3H3 3
#define ICR3H3_BIT 3
#define ICR3H3_MASK 8
#define ICR3H4 4
#define ICR3H4_BIT 4
#define ICR3H4_MASK 16
#define ICR3H5 5
#define ICR3H5_BIT 5
#define ICR3H5_MASK 32
#define ICR3H6 6
#define ICR3H6_BIT 6
#define ICR3H6_MASK 64
#define ICR3H7 7
#define ICR3H7_BIT 7
#define ICR3H7_MASK 128

sfrb ICR3L = 0x80;
#define ICR3L0 0
#define ICR3L0_BIT 0
#define ICR3L0_MASK 1
#define ICR3L1 1
#define ICR3L1_BIT 1
#define ICR3L1_MASK 2
#define ICR3L2 2
#define ICR3L2_BIT 2
#define ICR3L2_MASK 4
#define ICR3L3 3
#define ICR3L3_BIT 3
#define ICR3L3_MASK 8
#define ICR3L4 4
#define ICR3L4_BIT 4
#define ICR3L4_MASK 16
#define ICR3L5 5
#define ICR3L5_BIT 5
#define ICR3L5_MASK 32
#define ICR3L6 6
#define ICR3L6_BIT 6
#define ICR3L6_MASK 64
#define ICR3L7 7
#define ICR3L7_BIT 7
#define ICR3L7_MASK 128

sfrw ICR3W = 0x80;

sfrb ETIMSK = 0x7d;
#define OCIE1C 0
#define OCIE1C_BIT 0
#define OCIE1C_MASK 1
#define OCIE3C 1
#define OCIE3C_BIT 1
#define OCIE3C_MASK 2
#define TOIE3 2
#define TOIE3_BIT 2
#define TOIE3_MASK 4
#define OCIE3B 3
#define OCIE3B_BIT 3
#define OCIE3B_MASK 8
#define OCIE3A 4
#define OCIE3A_BIT 4
#define OCIE3A_MASK 16
#define TICIE3 5
#define TICIE3_BIT 5
#define TICIE3_MASK 32

sfrb ETIFR = 0x7c;
#define OCF1C 0
#define OCF1C_BIT 0
#define OCF1C_MASK 1
#define OCF3C 1
#define OCF3C_BIT 1
#define OCF3C_MASK 2
#define TOV3 2
#define TOV3_BIT 2
#define TOV3_MASK 4
#define OCF3B 3
#define OCF3B_BIT 3
#define OCF3B_MASK 8
#define OCF3A 4
#define OCF3A_BIT 4
#define OCF3A_MASK 16
#define ICF3 5
#define ICF3_BIT 5
#define ICF3_MASK 32

sfrb TCCR1C = 0x7a;
#define FOC1C 5
#define FOC1C_BIT 5
#define FOC1C_MASK 32
#define FOC1B 6
#define FOC1B_BIT 6
#define FOC1B_MASK 64
#define FOC1A 7
#define FOC1A_BIT 7
#define FOC1A_MASK 128

sfrb OCR1CH = 0x79;
#define OCR1CH0 0
#define OCR1CH0_BIT 0
#define OCR1CH0_MASK 1
#define OCR1CH1 1
#define OCR1CH1_BIT 1
#define OCR1CH1_MASK 2
#define OCR1CH2 2
#define OCR1CH2_BIT 2
#define OCR1CH2_MASK 4
#define OCR1CH3 3
#define OCR1CH3_BIT 3
#define OCR1CH3_MASK 8
#define OCR1CH4 4
#define OCR1CH4_BIT 4
#define OCR1CH4_MASK 16
#define OCR1CH5 5
#define OCR1CH5_BIT 5
#define OCR1CH5_MASK 32
#define OCR1CH6 6
#define OCR1CH6_BIT 6
#define OCR1CH6_MASK 64
#define OCR1CH7 7
#define OCR1CH7_BIT 7
#define OCR1CH7_MASK 128

sfrb OCR1CL = 0x78;
#define OCR1CL0 0
#define OCR1CL0_BIT 0
#define OCR1CL0_MASK 1
#define OCR1CL1 1
#define OCR1CL1_BIT 1
#define OCR1CL1_MASK 2
#define OCR1CL2 2
#define OCR1CL2_BIT 2
#define OCR1CL2_MASK 4
#define OCR1CL3 3
#define OCR1CL3_BIT 3
#define OCR1CL3_MASK 8
#define OCR1CL4 4
#define OCR1CL4_BIT 4
#define OCR1CL4_MASK 16
#define OCR1CL5 5
#define OCR1CL5_BIT 5
#define OCR1CL5_MASK 32
#define OCR1CL6 6
#define OCR1CL6_BIT 6
#define OCR1CL6_MASK 64
#define OCR1CL7 7
#define OCR1CL7_BIT 7
#define OCR1CL7_MASK 128

sfrw OCR1CW = 0x78;

sfrb TWCR = 0x74;
#define TWIE 0
#define TWIE_BIT 0
#define TWIE_MASK 1
#define TWEN 2
#define TWEN_BIT 2
#define TWEN_MASK 4
#define TWWC 3
#define TWWC_BIT 3
#define TWWC_MASK 8
#define TWSTO 4
#define TWSTO_BIT 4
#define TWSTO_MASK 16
#define TWSTA 5
#define TWSTA_BIT 5
#define TWSTA_MASK 32
#define TWEA 6
#define TWEA_BIT 6
#define TWEA_MASK 64
#define TWINT 7
#define TWINT_BIT 7
#define TWINT_MASK 128

sfrb TWDR = 0x73;
#define TWD0 0
#define TWD0_BIT 0
#define TWD0_MASK 1
#define TWD1 1
#define TWD1_BIT 1
#define TWD1_MASK 2
#define TWD2 2
#define TWD2_BIT 2
#define TWD2_MASK 4
#define TWD3 3
#define TWD3_BIT 3
#define TWD3_MASK 8
#define TWD4 4
#define TWD4_BIT 4
#define TWD4_MASK 16
#define TWD5 5
#define TWD5_BIT 5
#define TWD5_MASK 32
#define TWD6 6
#define TWD6_BIT 6
#define TWD6_MASK 64
#define TWD7 7
#define TWD7_BIT 7
#define TWD7_MASK 128

sfrb TWAR = 0x72;
#define TWGCE 0
#define TWGCE_BIT 0
#define TWGCE_MASK 1
#define TWA0 1
#define TWA0_BIT 1
#define TWA0_MASK 2
#define TWA1 2
#define TWA1_BIT 2
#define TWA1_MASK 4
#define TWA2 3
#define TWA2_BIT 3
#define TWA2_MASK 8
#define TWA3 4
#define TWA3_BIT 4
#define TWA3_MASK 16
#define TWA4 5
#define TWA4_BIT 5
#define TWA4_MASK 32
#define TWA5 6
#define TWA5_BIT 6
#define TWA5_MASK 64
#define TWA6 7
#define TWA6_BIT 7
#define TWA6_MASK 128

sfrb TWSR = 0x71;
#define TWPS0 0
#define TWPS0_BIT 0
#define TWPS0_MASK 1
#define TWPS1 1
#define TWPS1_BIT 1
#define TWPS1_MASK 2
#define TWS3 3
#define TWS3_BIT 3
#define TWS3_MASK 8
#define TWS4 4
#define TWS4_BIT 4
#define TWS4_MASK 16
#define TWS5 5
#define TWS5_BIT 5
#define TWS5_MASK 32
#define TWS6 6
#define TWS6_BIT 6
#define TWS6_MASK 64
#define TWS7 7
#define TWS7_BIT 7
#define TWS7_MASK 128

sfrb TWBR = 0x70;
#define TWBR0 0
#define TWBR0_BIT 0
#define TWBR0_MASK 1
#define TWBR1 1
#define TWBR1_BIT 1
#define TWBR1_MASK 2
#define TWBR2 2
#define TWBR2_BIT 2
#define TWBR2_MASK 4
#define TWBR3 3
#define TWBR3_BIT 3
#define TWBR3_MASK 8
#define TWBR4 4
#define TWBR4_BIT 4
#define TWBR4_MASK 16
#define TWBR5 5
#define TWBR5_BIT 5
#define TWBR5_MASK 32
#define TWBR6 6
#define TWBR6_BIT 6
#define TWBR6_MASK 64
#define TWBR7 7
#define TWBR7_BIT 7
#define TWBR7_MASK 128

sfrb OSCCAL = 0x6f;
#define CAL0 0
#define CAL0_BIT 0
#define CAL0_MASK 1
#define CAL1 1
#define CAL1_BIT 1
#define CAL1_MASK 2
#define CAL2 2
#define CAL2_BIT 2
#define CAL2_MASK 4
#define CAL3 3
#define CAL3_BIT 3
#define CAL3_MASK 8
#define CAL4 4
#define CAL4_BIT 4
#define CAL4_MASK 16
#define CAL5 5
#define CAL5_BIT 5
#define CAL5_MASK 32
#define CAL6 6
#define CAL6_BIT 6
#define CAL6_MASK 64
#define CAL7 7
#define CAL7_BIT 7
#define CAL7_MASK 128

sfrb XMCRA = 0x6d;
#define SRW11 1
#define SRW11_BIT 1
#define SRW11_MASK 2
#define SRW00 2
#define SRW00_BIT 2
#define SRW00_MASK 4
#define SRW01 3
#define SRW01_BIT 3
#define SRW01_MASK 8
#define SRL0 4
#define SRL0_BIT 4
#define SRL0_MASK 16
#define SRL1 5
#define SRL1_BIT 5
#define SRL1_MASK 32
#define SRL2 6
#define SRL2_BIT 6
#define SRL2_MASK 64

sfrb XMCRB = 0x6c;
#define XMM0 0
#define XMM0_BIT 0
#define XMM0_MASK 1
#define XMM1 1
#define XMM1_BIT 1
#define XMM1_MASK 2
#define XMM2 2
#define XMM2_BIT 2
#define XMM2_MASK 4
#define XMBK 7
#define XMBK_BIT 7
#define XMBK_MASK 128

sfrb EICRA = 0x6a;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ISC10 2
#define ISC10_BIT 2
#define ISC10_MASK 4
#define ISC11 3
#define ISC11_BIT 3
#define ISC11_MASK 8
#define ISC20 4
#define ISC20_BIT 4
#define ISC20_MASK 16
#define ISC21 5
#define ISC21_BIT 5
#define ISC21_MASK 32
#define ISC30 6
#define ISC30_BIT 6
#define ISC30_MASK 64
#define ISC31 7
#define ISC31_BIT 7
#define ISC31_MASK 128

sfrb SPMCSR = 0x68;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define BLBSET 3
#define BLBSET_BIT 3
#define BLBSET_MASK 8
#define RWWSRE 4
#define RWWSRE_BIT 4
#define RWWSRE_MASK 16
#define RWWSB 6
#define RWWSB_BIT 6
#define RWWSB_MASK 64
#define SPMIE 7
#define SPMIE_BIT 7
#define SPMIE_MASK 128

sfrb PORTG = 0x65;
#define PORTG0 0
#define PORTG0_BIT 0
#define PORTG0_MASK 1
#define PORTG1 1
#define PORTG1_BIT 1
#define PORTG1_MASK 2
#define PORTG2 2
#define PORTG2_BIT 2
#define PORTG2_MASK 4
#define PORTG3 3
#define PORTG3_BIT 3
#define PORTG3_MASK 8
#define PORTG4 4
#define PORTG4_BIT 4
#define PORTG4_MASK 16

sfrb DDRG = 0x64;
#define DDG0 0
#define DDG0_BIT 0
#define DDG0_MASK 1
#define DDG1 1
#define DDG1_BIT 1
#define DDG1_MASK 2
#define DDG2 2
#define DDG2_BIT 2
#define DDG2_MASK 4
#define DDG3 3
#define DDG3_BIT 3
#define DDG3_MASK 8
#define DDG4 4
#define DDG4_BIT 4
#define DDG4_MASK 16

sfrb PING = 0x63;
#define PING0 0
#define PING0_BIT 0
#define PING0_MASK 1
#define PING1 1
#define PING1_BIT 1
#define PING1_MASK 2
#define PING2 2
#define PING2_BIT 2
#define PING2_MASK 4
#define PING3 3
#define PING3_BIT 3
#define PING3_MASK 8
#define PING4 4
#define PING4_BIT 4
#define PING4_MASK 16

sfrb PORTF = 0x62;
#define PORTF0 0
#define PORTF0_BIT 0
#define PORTF0_MASK 1
#define PORTF1 1
#define PORTF1_BIT 1
#define PORTF1_MASK 2
#define PORTF2 2
#define PORTF2_BIT 2
#define PORTF2_MASK 4
#define PORTF3 3
#define PORTF3_BIT 3
#define PORTF3_MASK 8
#define PORTF4 4
#define PORTF4_BIT 4
#define PORTF4_MASK 16
#define PORTF5 5
#define PORTF5_BIT 5
#define PORTF5_MASK 32
#define PORTF6 6
#define PORTF6_BIT 6
#define PORTF6_MASK 64
#define PORTF7 7
#define PORTF7_BIT 7
#define PORTF7_MASK 128

sfrb DDRF = 0x61;
#define DDF0 0
#define DDF0_BIT 0
#define DDF0_MASK 1
#define DDF1 1
#define DDF1_BIT 1
#define DDF1_MASK 2
#define DDF2 2
#define DDF2_BIT 2
#define DDF2_MASK 4
#define DDF3 3
#define DDF3_BIT 3
#define DDF3_MASK 8
#define DDF4 4
#define DDF4_BIT 4
#define DDF4_MASK 16
#define DDF5 5
#define DDF5_BIT 5
#define DDF5_MASK 32
#define DDF6 6
#define DDF6_BIT 6
#define DDF6_MASK 64
#define DDF7 7
#define DDF7_BIT 7
#define DDF7_MASK 128

sfrb SREG = 0x5f;

sfrb SPH = 0x5e;
#define SP8 0
#define SP8_BIT 0
#define SP8_MASK 1
#define SP9 1
#define SP9_BIT 1
#define SP9_MASK 2
#define SP10 2
#define SP10_BIT 2
#define SP10_MASK 4
#define SP11 3
#define SP11_BIT 3
#define SP11_MASK 8
#define SP12 4
#define SP12_BIT 4
#define SP12_MASK 16
#define SP13 5
#define SP13_BIT 5
#define SP13_MASK 32
#define SP14 6
#define SP14_BIT 6
#define SP14_MASK 64
#define SP15 7
#define SP15_BIT 7
#define SP15_MASK 128

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrw SPW = 0x5d;

sfrb XDIV = 0x5c;
#define XDIV0 0
#define XDIV0_BIT 0
#define XDIV0_MASK 1
#define XDIV1 1
#define XDIV1_BIT 1
#define XDIV1_MASK 2
#define XDIV2 2
#define XDIV2_BIT 2
#define XDIV2_MASK 4
#define XDIV3 3
#define XDIV3_BIT 3
#define XDIV3_MASK 8
#define XDIV4 4
#define XDIV4_BIT 4
#define XDIV4_MASK 16
#define XDIV5 5
#define XDIV5_BIT 5
#define XDIV5_MASK 32
#define XDIV6 6
#define XDIV6_BIT 6
#define XDIV6_MASK 64
#define XDIVEN 7
#define XDIVEN_BIT 7
#define XDIVEN_MASK 128

sfrb RAMPZ = 0x5b;
#define RAMPZ0 0
#define RAMPZ0_BIT 0
#define RAMPZ0_MASK 1

sfrb EICRB = 0x5a;
#define ISC40 0
#define ISC40_BIT 0
#define ISC40_MASK 1
#define ISC41 1
#define ISC41_BIT 1
#define ISC41_MASK 2
#define ISC50 2
#define ISC50_BIT 2
#define ISC50_MASK 4
#define ISC51 3
#define ISC51_BIT 3
#define ISC51_MASK 8
#define ISC60 4
#define ISC60_BIT 4
#define ISC60_MASK 16
#define ISC61 5
#define ISC61_BIT 5
#define ISC61_MASK 32
#define ISC70 6
#define ISC70_BIT 6
#define ISC70_MASK 64
#define ISC71 7
#define ISC71_BIT 7
#define ISC71_MASK 128

sfrb EIMSK = 0x59;
#define INT0 0
#define INT0_BIT 0
#define INT0_MASK 1
#define INT1 1
#define INT1_BIT 1
#define INT1_MASK 2
#define INT2 2
#define INT2_BIT 2
#define INT2_MASK 4
#define INT3 3
#define INT3_BIT 3
#define INT3_MASK 8
#define INT4 4
#define INT4_BIT 4
#define INT4_MASK 16
#define INT5 5
#define INT5_BIT 5
#define INT5_MASK 32
#define INT6 6
#define INT6_BIT 6
#define INT6_MASK 64
#define INT7 7
#define INT7_BIT 7
#define INT7_MASK 128

sfrb EIFR = 0x58;
#define INTF0 0
#define INTF0_BIT 0
#define INTF0_MASK 1
#define INTF1 1
#define INTF1_BIT 1
#define INTF1_MASK 2
#define INTF2 2
#define INTF2_BIT 2
#define INTF2_MASK 4
#define INTF3 3
#define INTF3_BIT 3
#define INTF3_MASK 8
#define INTF4 4
#define INTF4_BIT 4
#define INTF4_MASK 16
#define INTF5 5
#define INTF5_BIT 5
#define INTF5_MASK 32
#define INTF6 6
#define INTF6_BIT 6
#define INTF6_MASK 64
#define INTF7 7
#define INTF7_BIT 7
#define INTF7_MASK 128

sfrb TIMSK = 0x57;
#define TOIE0 0
#define TOIE0_BIT 0
#define TOIE0_MASK 1
#define OCIE0 1
#define OCIE0_BIT 1
#define OCIE0_MASK 2
#define TOIE1 2
#define TOIE1_BIT 2
#define TOIE1_MASK 4
#define OCIE1B 3
#define OCIE1B_BIT 3
#define OCIE1B_MASK 8
#define OCIE1A 4
#define OCIE1A_BIT 4
#define OCIE1A_MASK 16
#define TICIE1 5
#define TICIE1_BIT 5
#define TICIE1_MASK 32
#define TOIE2 6
#define TOIE2_BIT 6
#define TOIE2_MASK 64
#define OCIE2 7
#define OCIE2_BIT 7
#define OCIE2_MASK 128

sfrb TIFR = 0x56;
#define TOV0 0
#define TOV0_BIT 0
#define TOV0_MASK 1
#define OCF0 1
#define OCF0_BIT 1
#define OCF0_MASK 2
#define TOV1 2
#define TOV1_BIT 2
#define TOV1_MASK 4
#define OCF1B 3
#define OCF1B_BIT 3
#define OCF1B_MASK 8
#define OCF1A 4
#define OCF1A_BIT 4
#define OCF1A_MASK 16
#define ICF1 5
#define ICF1_BIT 5
#define ICF1_MASK 32
#define TOV2 6
#define TOV2_BIT 6
#define TOV2_MASK 64
#define OCF2 7
#define OCF2_BIT 7
#define OCF2_MASK 128

sfrb MCUCR = 0x55;
#define IVCE 0
#define IVCE_BIT 0
#define IVCE_MASK 1
#define IVSEL 1
#define IVSEL_BIT 1
#define IVSEL_MASK 2
#define SM2 2
#define SM2_BIT 2
#define SM2_MASK 4
#define SM0 3
#define SM0_BIT 3
#define SM0_MASK 8
#define SM1 4
#define SM1_BIT 4
#define SM1_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32
#define SRW10 6
#define SRW10_BIT 6
#define SRW10_MASK 64
#define SRE 7
#define SRE_BIT 7
#define SRE_MASK 128

sfrb MCUCSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8
#define JTRF 4
#define JTRF_BIT 4
#define JTRF_MASK 16
#define JTD 7
#define JTD_BIT 7
#define JTD_MASK 128

sfrb TCCR0 = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM01 3
#define WGM01_BIT 3
#define WGM01_MASK 8
#define COM00 4
#define COM00_BIT 4
#define COM00_MASK 16
#define COM01 5
#define COM01_BIT 5
#define COM01_MASK 32
#define WGM00 6
#define WGM00_BIT 6
#define WGM00_MASK 64
#define FOC0 7
#define FOC0_BIT 7
#define FOC0_MASK 128

sfrb TCNT0 = 0x52;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb OCR0 = 0x51;
#define OCR0_0 0
#define OCR0_0_BIT 0
#define OCR0_0_MASK 1
#define OCR0_1 1
#define OCR0_1_BIT 1
#define OCR0_1_MASK 2
#define OCR0_2 2
#define OCR0_2_BIT 2
#define OCR0_2_MASK 4
#define OCR0_3 3
#define OCR0_3_BIT 3
#define OCR0_3_MASK 8
#define OCR0_4 4
#define OCR0_4_BIT 4
#define OCR0_4_MASK 16
#define OCR0_5 5
#define OCR0_5_BIT 5
#define OCR0_5_MASK 32
#define OCR0_6 6
#define OCR0_6_BIT 6
#define OCR0_6_MASK 64
#define OCR0_7 7
#define OCR0_7_BIT 7
#define OCR0_7_MASK 128

sfrb ASSR = 0x50;
#define TCR0UB 0
#define TCR0UB_BIT 0
#define TCR0UB_MASK 1
#define OCR0UB 1
#define OCR0UB_BIT 1
#define OCR0UB_MASK 2
#define TCN0UB 2
#define TCN0UB_BIT 2
#define TCN0UB_MASK 4
#define AS0 3
#define AS0_BIT 3
#define AS0_MASK 8

sfrb TCCR1A = 0x4f;
#define WGM10 0
#define WGM10_BIT 0
#define WGM10_MASK 1
#define WGM11 1
#define WGM11_BIT 1
#define WGM11_MASK 2
#define COM1C0 2
#define COM1C0_BIT 2
#define COM1C0_MASK 4
#define COM1C1 3
#define COM1C1_BIT 3
#define COM1C1_MASK 8
#define COM1B0 4
#define COM1B0_BIT 4
#define COM1B0_MASK 16
#define COM1B1 5
#define COM1B1_BIT 5
#define COM1B1_MASK 32
#define COM1A0 6
#define COM1A0_BIT 6
#define COM1A0_MASK 64
#define COM1A1 7
#define COM1A1_BIT 7
#define COM1A1_MASK 128

sfrb TCCR1B = 0x4e;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define WGM12 3
#define WGM12_BIT 3
#define WGM12_MASK 8
#define WGM13 4
#define WGM13_BIT 4
#define WGM13_MASK 16
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCNT1H = 0x4d;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x4c;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x4c;

sfrb OCR1AH = 0x4b;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x4a;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x4a;

sfrb OCR1BH = 0x49;
#define OCR1BH0 0
#define OCR1BH0_BIT 0
#define OCR1BH0_MASK 1
#define OCR1BH1 1
#define OCR1BH1_BIT 1
#define OCR1BH1_MASK 2
#define OCR1BH2 2
#define OCR1BH2_BIT 2
#define OCR1BH2_MASK 4
#define OCR1BH3 3
#define OCR1BH3_BIT 3
#define OCR1BH3_MASK 8
#define OCR1BH4 4
#define OCR1BH4_BIT 4
#define OCR1BH4_MASK 16
#define OCR1BH5 5
#define OCR1BH5_BIT 5
#define OCR1BH5_MASK 32
#define OCR1BH6 6
#define OCR1BH6_BIT 6
#define OCR1BH6_MASK 64
#define OCR1BH7 7
#define OCR1BH7_BIT 7
#define OCR1BH7_MASK 128

sfrb OCR1BL = 0x48;
#define OCR1BL0 0
#define OCR1BL0_BIT 0
#define OCR1BL0_MASK 1
#define OCR1BL1 1
#define OCR1BL1_BIT 1
#define OCR1BL1_MASK 2
#define OCR1BL2 2
#define OCR1BL2_BIT 2
#define OCR1BL2_MASK 4
#define OCR1BL3 3
#define OCR1BL3_BIT 3
#define OCR1BL3_MASK 8
#define OCR1BL4 4
#define OCR1BL4_BIT 4
#define OCR1BL4_MASK 16
#define OCR1BL5 5
#define OCR1BL5_BIT 5
#define OCR1BL5_MASK 32
#define OCR1BL6 6
#define OCR1BL6_BIT 6
#define OCR1BL6_MASK 64
#define OCR1BL7 7
#define OCR1BL7_BIT 7
#define OCR1BL7_MASK 128

sfrw OCR1BW = 0x48;

sfrb ICR1H = 0x47;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x46;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x46;

sfrb TCCR2 = 0x45;
#define CS20 0
#define CS20_BIT 0
#define CS20_MASK 1
#define CS21 1
#define CS21_BIT 1
#define CS21_MASK 2
#define CS22 2
#define CS22_BIT 2
#define CS22_MASK 4
#define WGM21 3
#define WGM21_BIT 3
#define WGM21_MASK 8
#define COM20 4
#define COM20_BIT 4
#define COM20_MASK 16
#define COM21 5
#define COM21_BIT 5
#define COM21_MASK 32
#define WGM20 6
#define WGM20_BIT 6
#define WGM20_MASK 64
#define FOC2 7
#define FOC2_BIT 7
#define FOC2_MASK 128

sfrb TCNT2 = 0x44;
#define TCNT2_0 0
#define TCNT2_0_BIT 0
#define TCNT2_0_MASK 1
#define TCNT2_1 1
#define TCNT2_1_BIT 1
#define TCNT2_1_MASK 2
#define TCNT2_2 2
#define TCNT2_2_BIT 2
#define TCNT2_2_MASK 4
#define TCNT2_3 3
#define TCNT2_3_BIT 3
#define TCNT2_3_MASK 8
#define TCNT2_4 4
#define TCNT2_4_BIT 4
#define TCNT2_4_MASK 16
#define TCNT2_5 5
#define TCNT2_5_BIT 5
#define TCNT2_5_MASK 32
#define TCNT2_6 6
#define TCNT2_6_BIT 6
#define TCNT2_6_MASK 64
#define TCNT2_7 7
#define TCNT2_7_BIT 7
#define TCNT2_7_MASK 128

sfrb OCR2 = 0x43;
#define OCR2_0 0
#define OCR2_0_BIT 0
#define OCR2_0_MASK 1
#define OCR2_1 1
#define OCR2_1_BIT 1
#define OCR2_1_MASK 2
#define OCR2_2 2
#define OCR2_2_BIT 2
#define OCR2_2_MASK 4
#define OCR2_3 3
#define OCR2_3_BIT 3
#define OCR2_3_MASK 8
#define OCR2_4 4
#define OCR2_4_BIT 4
#define OCR2_4_MASK 16
#define OCR2_5 5
#define OCR2_5_BIT 5
#define OCR2_5_MASK 32
#define OCR2_6 6
#define OCR2_6_BIT 6
#define OCR2_6_MASK 64
#define OCR2_7 7
#define OCR2_7_BIT 7
#define OCR2_7_MASK 128

sfrb OCDR = 0x42;
#define OCDR0 0
#define OCDR0_BIT 0
#define OCDR0_MASK 1
#define OCDR1 1
#define OCDR1_BIT 1
#define OCDR1_MASK 2
#define OCDR2 2
#define OCDR2_BIT 2
#define OCDR2_MASK 4
#define OCDR3 3
#define OCDR3_BIT 3
#define OCDR3_MASK 8
#define OCDR4 4
#define OCDR4_BIT 4
#define OCDR4_MASK 16
#define OCDR5 5
#define OCDR5_BIT 5
#define OCDR5_MASK 32
#define OCDR6 6
#define OCDR6_BIT 6
#define OCDR6_MASK 64
#define OCDR7 7
#define OCDR7_BIT 7
#define OCDR7_MASK 128

sfrb WDTCR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16

sfrb SFIOR = 0x40;
#define PSR321 0
#define PSR321_BIT 0
#define PSR321_MASK 1
#define PSR0 1
#define PSR0_BIT 1
#define PSR0_MASK 2
#define PUD 2
#define PUD_BIT 2
#define PUD_MASK 4
#define ACME 3
#define ACME_BIT 3
#define ACME_MASK 8
#define TSM 7
#define TSM_BIT 7
#define TSM_MASK 128

sfrb EEARH = 0x3f;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1
#define EEAR9 1
#define EEAR9_BIT 1
#define EEAR9_MASK 2
#define EEAR10 2
#define EEAR10_BIT 2
#define EEAR10_MASK 4
#define EEAR11 3
#define EEAR11_BIT 3
#define EEAR11_MASK 8

sfrb EEARL = 0x3e;
#define EEARL0 0
#define EEARL0_BIT 0
#define EEARL0_MASK 1
#define EEARL1 1
#define EEARL1_BIT 1
#define EEARL1_MASK 2
#define EEARL2 2
#define EEARL2_BIT 2
#define EEARL2_MASK 4
#define EEARL3 3
#define EEARL3_BIT 3
#define EEARL3_MASK 8
#define EEARL4 4
#define EEARL4_BIT 4
#define EEARL4_MASK 16
#define EEARL5 5
#define EEARL5_BIT 5
#define EEARL5_MASK 32
#define EEARL6 6
#define EEARL6_BIT 6
#define EEARL6_MASK 64
#define EEARL7 7
#define EEARL7_BIT 7
#define EEARL7_MASK 128

sfrw EEARW = 0x3e;

sfrb EEDR = 0x3d;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3c;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEWE 1
#define EEWE_BIT 1
#define EEWE_MASK 2
#define EEMWE 2
#define EEMWE_BIT 2
#define EEMWE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8

sfrb PORTA = 0x3b;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8
#define PORTA4 4
#define PORTA4_BIT 4
#define PORTA4_MASK 16
#define PORTA5 5
#define PORTA5_BIT 5
#define PORTA5_MASK 32
#define PORTA6 6
#define PORTA6_BIT 6
#define PORTA6_MASK 64
#define PORTA7 7
#define PORTA7_BIT 7
#define PORTA7_MASK 128

sfrb DDRA = 0x3a;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define DDA2 2
#define DDA2_BIT 2
#define DDA2_MASK 4
#define DDA3 3
#define DDA3_BIT 3
#define DDA3_MASK 8
#define DDA4 4
#define DDA4_BIT 4
#define DDA4_MASK 16
#define DDA5 5
#define DDA5_BIT 5
#define DDA5_MASK 32
#define DDA6 6
#define DDA6_BIT 6
#define DDA6_MASK 64
#define DDA7 7
#define DDA7_BIT 7
#define DDA7_MASK 128

sfrb PINA = 0x39;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8
#define PINA4 4
#define PINA4_BIT 4
#define PINA4_MASK 16
#define PINA5 5
#define PINA5_BIT 5
#define PINA5_MASK 32
#define PINA6 6
#define PINA6_BIT 6
#define PINA6_MASK 64
#define PINA7 7
#define PINA7_BIT 7
#define PINA7_MASK 128

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x37;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb PORTC = 0x35;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1
#define PORTC1 1
#define PORTC1_BIT 1
#define PORTC1_MASK 2
#define PORTC2 2
#define PORTC2_BIT 2
#define PORTC2_MASK 4
#define PORTC3 3
#define PORTC3_BIT 3
#define PORTC3_MASK 8
#define PORTC4 4
#define PORTC4_BIT 4
#define PORTC4_MASK 16
#define PORTC5 5
#define PORTC5_BIT 5
#define PORTC5_MASK 32
#define PORTC6 6
#define PORTC6_BIT 6
#define PORTC6_MASK 64
#define PORTC7 7
#define PORTC7_BIT 7
#define PORTC7_MASK 128

sfrb DDRC = 0x34;
#define DDC0 0
#define DDC0_BIT 0
#define DDC0_MASK 1
#define DDC1 1
#define DDC1_BIT 1
#define DDC1_MASK 2
#define DDC2 2
#define DDC2_BIT 2
#define DDC2_MASK 4
#define DDC3 3
#define DDC3_BIT 3
#define DDC3_MASK 8
#define DDC4 4
#define DDC4_BIT 4
#define DDC4_MASK 16
#define DDC5 5
#define DDC5_BIT 5
#define DDC5_MASK 32
#define DDC6 6
#define DDC6_BIT 6
#define DDC6_MASK 64
#define DDC7 7
#define DDC7_BIT 7
#define DDC7_MASK 128

sfrb PINC = 0x33;
#define PINC0 0
#define PINC0_BIT 0
#define PINC0_MASK 1
#define PINC1 1
#define PINC1_BIT 1
#define PINC1_MASK 2
#define PINC2 2
#define PINC2_BIT 2
#define PINC2_MASK 4
#define PINC3 3
#define PINC3_BIT 3
#define PINC3_MASK 8
#define PINC4 4
#define PINC4_BIT 4
#define PINC4_MASK 16
#define PINC5 5
#define PINC5_BIT 5
#define PINC5_MASK 32
#define PINC6 6
#define PINC6_BIT 6
#define PINC6_MASK 64
#define PINC7 7
#define PINC7_BIT 7
#define PINC7_MASK 128

sfrb PORTD = 0x32;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x31;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64
#define DDD7 7
#define DDD7_BIT 7
#define DDD7_MASK 128

sfrb PIND = 0x30;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb SPDR = 0x2f;
#define SPDR0 0
#define SPDR0_BIT 0
#define SPDR0_MASK 1
#define SPDR1 1
#define SPDR1_BIT 1
#define SPDR1_MASK 2
#define SPDR2 2
#define SPDR2_BIT 2
#define SPDR2_MASK 4
#define SPDR3 3
#define SPDR3_BIT 3
#define SPDR3_MASK 8
#define SPDR4 4
#define SPDR4_BIT 4
#define SPDR4_MASK 16
#define SPDR5 5
#define SPDR5_BIT 5
#define SPDR5_MASK 32
#define SPDR6 6
#define SPDR6_BIT 6
#define SPDR6_MASK 64
#define SPDR7 7
#define SPDR7_BIT 7
#define SPDR7_MASK 128

sfrb SPSR = 0x2e;
#define SPI2X 0
#define SPI2X_BIT 0
#define SPI2X_MASK 1
#define WCOL 6
#define WCOL_BIT 6
#define WCOL_MASK 64
#define SPIF 7
#define SPIF_BIT 7
#define SPIF_MASK 128

sfrb SPCR = 0x2d;
#define SPR0 0
#define SPR0_BIT 0
#define SPR0_MASK 1
#define SPR1 1
#define SPR1_BIT 1
#define SPR1_MASK 2
#define CPHA 2
#define CPHA_BIT 2
#define CPHA_MASK 4
#define CPOL 3
#define CPOL_BIT 3
#define CPOL_MASK 8
#define MSTR 4
#define MSTR_BIT 4
#define MSTR_MASK 16
#define DORD 5
#define DORD_BIT 5
#define DORD_MASK 32
#define SPE 6
#define SPE_BIT 6
#define SPE_MASK 64
#define SPIE 7
#define SPIE_BIT 7
#define SPIE_MASK 128

sfrb UDR0 = 0x2c;
#define UDR00 0
#define UDR00_BIT 0
#define UDR00_MASK 1
#define UDR01 1
#define UDR01_BIT 1
#define UDR01_MASK 2
#define UDR02 2
#define UDR02_BIT 2
#define UDR02_MASK 4
#define UDR03 3
#define UDR03_BIT 3
#define UDR03_MASK 8
#define UDR04 4
#define UDR04_BIT 4
#define UDR04_MASK 16
#define UDR05 5
#define UDR05_BIT 5
#define UDR05_MASK 32
#define UDR06 6
#define UDR06_BIT 6
#define UDR06_MASK 64
#define UDR07 7
#define UDR07_BIT 7
#define UDR07_MASK 128

sfrb UCSR0A = 0x2b;
#define MPCM0 0
#define MPCM0_BIT 0
#define MPCM0_MASK 1
#define U2X0 1
#define U2X0_BIT 1
#define U2X0_MASK 2
#define UPE0 2
#define UPE0_BIT 2
#define UPE0_MASK 4
#define DOR0 3
#define DOR0_BIT 3
#define DOR0_MASK 8
#define FE0 4
#define FE0_BIT 4
#define FE0_MASK 16
#define UDRE0 5
#define UDRE0_BIT 5
#define UDRE0_MASK 32
#define TXC0 6
#define TXC0_BIT 6
#define TXC0_MASK 64
#define RXC0 7
#define RXC0_BIT 7
#define RXC0_MASK 128

sfrb UCSR0B = 0x2a;
#define TXB80 0
#define TXB80_BIT 0
#define TXB80_MASK 1
#define RXB80 1
#define RXB80_BIT 1
#define RXB80_MASK 2
#define UCSZ02 2
#define UCSZ02_BIT 2
#define UCSZ02_MASK 4
#define TXEN0 3
#define TXEN0_BIT 3
#define TXEN0_MASK 8
#define RXEN0 4
#define RXEN0_BIT 4
#define RXEN0_MASK 16
#define UDRIE0 5
#define UDRIE0_BIT 5
#define UDRIE0_MASK 32
#define TXCIE0 6
#define TXCIE0_BIT 6
#define TXCIE0_MASK 64
#define RXCIE0 7
#define RXCIE0_BIT 7
#define RXCIE0_MASK 128

sfrb UBRR0L = 0x29;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrb ACSR = 0x28;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIC 2
#define ACIC_BIT 2
#define ACIC_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACBG 6
#define ACBG_BIT 6
#define ACBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb ADMUX = 0x27;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define MUX2 2
#define MUX2_BIT 2
#define MUX2_MASK 4
#define MUX3 3
#define MUX3_BIT 3
#define MUX3_MASK 8
#define MUX4 4
#define MUX4_BIT 4
#define MUX4_MASK 16
#define ADLAR 5
#define ADLAR_BIT 5
#define ADLAR_MASK 32
#define REFS0 6
#define REFS0_BIT 6
#define REFS0_MASK 64
#define REFS1 7
#define REFS1_BIT 7
#define REFS1_MASK 128

sfrb ADCSRA = 0x26;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADFR 5
#define ADFR_BIT 5
#define ADFR_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x25;
#define ADCH0 0
#define ADCH0_BIT 0
#define ADCH0_MASK 1
#define ADCH1 1
#define ADCH1_BIT 1
#define ADCH1_MASK 2
#define ADCH2 2
#define ADCH2_BIT 2
#define ADCH2_MASK 4
#define ADCH3 3
#define ADCH3_BIT 3
#define ADCH3_MASK 8
#define ADCH4 4
#define ADCH4_BIT 4
#define ADCH4_MASK 16
#define ADCH5 5
#define ADCH5_BIT 5
#define ADCH5_MASK 32
#define ADCH6 6
#define ADCH6_BIT 6
#define ADCH6_MASK 64
#define ADCH7 7
#define ADCH7_BIT 7
#define ADCH7_MASK 128

sfrb ADCL = 0x24;
#define ADCL0 0
#define ADCL0_BIT 0
#define ADCL0_MASK 1
#define ADCL1 1
#define ADCL1_BIT 1
#define ADCL1_MASK 2
#define ADCL2 2
#define ADCL2_BIT 2
#define ADCL2_MASK 4
#define ADCL3 3
#define ADCL3_BIT 3
#define ADCL3_MASK 8
#define ADCL4 4
#define ADCL4_BIT 4
#define ADCL4_MASK 16
#define ADCL5 5
#define ADCL5_BIT 5
#define ADCL5_MASK 32
#define ADCL6 6
#define ADCL6_BIT 6
#define ADCL6_MASK 64
#define ADCL7 7
#define ADCL7_BIT 7
#define ADCL7_MASK 128

sfrw ADCW = 0x24;

sfrb PORTE = 0x23;
#define PORTE0 0
#define PORTE0_BIT 0
#define PORTE0_MASK 1
#define PORTE1 1
#define PORTE1_BIT 1
#define PORTE1_MASK 2
#define PORTE2 2
#define PORTE2_BIT 2
#define PORTE2_MASK 4
#define PORTE3 3
#define PORTE3_BIT 3
#define PORTE3_MASK 8
#define PORTE4 4
#define PORTE4_BIT 4
#define PORTE4_MASK 16
#define PORTE5 5
#define PORTE5_BIT 5
#define PORTE5_MASK 32
#define PORTE6 6
#define PORTE6_BIT 6
#define PORTE6_MASK 64
#define PORTE7 7
#define PORTE7_BIT 7
#define PORTE7_MASK 128

sfrb DDRE = 0x22;
#define DDE0 0
#define DDE0_BIT 0
#define DDE0_MASK 1
#define DDE1 1
#define DDE1_BIT 1
#define DDE1_MASK 2
#define DDE2 2
#define DDE2_BIT 2
#define DDE2_MASK 4
#define DDE3 3
#define DDE3_BIT 3
#define DDE3_MASK 8
#define DDE4 4
#define DDE4_BIT 4
#define DDE4_MASK 16
#define DDE5 5
#define DDE5_BIT 5
#define DDE5_MASK 32
#define DDE6 6
#define DDE6_BIT 6
#define DDE6_MASK 64
#define DDE7 7
#define DDE7_BIT 7
#define DDE7_MASK 128

sfrb PINE = 0x21;
#define PINE0 0
#define PINE0_BIT 0
#define PINE0_MASK 1
#define PINE1 1
#define PINE1_BIT 1
#define PINE1_MASK 2
#define PINE2 2
#define PINE2_BIT 2
#define PINE2_MASK 4
#define PINE3 3
#define PINE3_BIT 3
#define PINE3_MASK 8
#define PINE4 4
#define PINE4_BIT 4
#define PINE4_MASK 16
#define PINE5 5
#define PINE5_BIT 5
#define PINE5_MASK 32
#define PINE6 6
#define PINE6_BIT 6
#define PINE6_MASK 64
#define PINE7 7
#define PINE7_BIT 7
#define PINE7_MASK 128

sfrb PINF = 0x20;
#define PINF0 0
#define PINF0_BIT 0
#define PINF0_MASK 1
#define PINF1 1
#define PINF1_BIT 1
#define PINF1_MASK 2
#define PINF2 2
#define PINF2_BIT 2
#define PINF2_MASK 4
#define PINF3 3
#define PINF3_BIT 3
#define PINF3_MASK 8
#define PINF4 4
#define PINF4_BIT 4
#define PINF4_MASK 16
#define PINF5 5
#define PINF5_BIT 5
#define PINF5_MASK 32
#define PINF6 6
#define PINF6_BIT 6
#define PINF6_MASK 64
#define PINF7 7
#define PINF7_BIT 7
#define PINF7_MASK 128

#endif
