#ifndef __AT90S1200_h
#define __AT90S1200_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0002
#define TIMER0_OVF_vect 0x0004
#define ANA_COMP_vect 0x0006

// I/O addresses


sfrb SREG = 0x5f;

sfrb GIMSK = 0x5b;
#define INT0 6
#define INT0_BIT 6
#define INT0_MASK 64

sfrb TIMSK = 0x59;
#define TOIE0 1
#define TOIE0_BIT 1
#define TOIE0_MASK 2

sfrb TIFR = 0x58;
#define TOV0 1
#define TOV0_BIT 1
#define TOV0_MASK 2

sfrb MCUCR = 0x55;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define SM 4
#define SM_BIT 4
#define SM_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32

sfrb TCCR0 = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4

sfrb TCNT0 = 0x52;
#define TCNT00 0
#define TCNT00_BIT 0
#define TCNT00_MASK 1
#define TCNT01 1
#define TCNT01_BIT 1
#define TCNT01_MASK 2
#define TCNT02 2
#define TCNT02_BIT 2
#define TCNT02_MASK 4
#define TCNT03 3
#define TCNT03_BIT 3
#define TCNT03_MASK 8
#define TCNT04 4
#define TCNT04_BIT 4
#define TCNT04_MASK 16
#define TCNT05 5
#define TCNT05_BIT 5
#define TCNT05_MASK 32
#define TCNT06 6
#define TCNT06_BIT 6
#define TCNT06_MASK 64
#define TCNT07 7
#define TCNT07_BIT 7
#define TCNT07_MASK 128

sfrb WDTCR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8

sfrb EEAR = 0x3e;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64

sfrb EEDR = 0x3d;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3c;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEWE 1
#define EEWE_BIT 1
#define EEWE_MASK 2

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x37;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb PORTD = 0x32;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64

sfrb DDRD = 0x31;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64

sfrb PIND = 0x30;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64

sfrb ACSR = 0x28;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

#endif
