#ifndef __AT76C_h
#define __AT76C_h

// Interrupt vectors

#define RESET_vect 0x0000
#define SUSP_RESM_vect 0x0004
#define USB_vect 0x0008
#define INT0_vect 0x000c
#define INT1_vect 0x0010
#define INT2_vect 0x0014
#define INT3_vect 0x0018
#define TIMER2_OVF_vect 0x001c
#define TIMER1_CAPT_vect 0x0020
#define TIMER1_COMPA_vect 0x0024
#define TIMER1_COMPB_vect 0x0028
#define TIMER1_OVF_vect 0x002c
#define TIMER0_OVF_vect 0x0030
#define SPI_STC_vect 0x0034
#define UART0_IRQ_vect 0x0038
#define UART1_IRQ_vect 0x003c

// I/O addresses


sfrb SREG = 0x5f;

sfrb SPH = 0x5e;
#define SP8 0
#define SP8_BIT 0
#define SP8_MASK 1
#define SP9 1
#define SP9_BIT 1
#define SP9_MASK 2
#define SP10 2
#define SP10_BIT 2
#define SP10_MASK 4
#define SP11 3
#define SP11_BIT 3
#define SP11_MASK 8
#define SP12 4
#define SP12_BIT 4
#define SP12_MASK 16
#define SP13 5
#define SP13_BIT 5
#define SP13_MASK 32
#define SP14 6
#define SP14_BIT 6
#define SP14_MASK 64
#define SP15 7
#define SP15_BIT 7
#define SP15_MASK 128

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrw SPW = 0x5d;

sfrb REMAP = 0xf404;

sfrb UART1_RHR = 0xf300;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART0_RHR = 0xf200;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART1_THR = 0xf300;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART0_THR = 0xf200;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART1_IER = 0xf301;
#define RDAI 0
#define RDAI_BIT 0
#define RDAI_MASK 1
#define IER_TRI 1
#define IER_TRI_BIT 1
#define IER_TRI_MASK 2
#define RSLI 2
#define RSLI_BIT 2
#define RSLI_MASK 4
#define MSI 3
#define MSI_BIT 3
#define MSI_MASK 8

sfrb UART0_IER = 0xf201;
#define RDAI 0
#define RDAI_BIT 0
#define RDAI_MASK 1
#define IER_TRI 1
#define IER_TRI_BIT 1
#define IER_TRI_MASK 2
#define RSLI 2
#define RSLI_BIT 2
#define RSLI_MASK 4
#define MSI 3
#define MSI_BIT 3
#define MSI_MASK 8

sfrb UART1_IIR = 0xf302;
#define NIP 0
#define NIP_BIT 0
#define NIP_MASK 1
#define ID0 1
#define ID0_BIT 1
#define ID0_MASK 2
#define ID1 2
#define ID1_BIT 2
#define ID1_MASK 4
#define ID2 3
#define ID2_BIT 3
#define ID2_MASK 8
#define FIFOEN0 6
#define FIFOEN0_BIT 6
#define FIFOEN0_MASK 64
#define FIFOEN1 7
#define FIFOEN1_BIT 7
#define FIFOEN1_MASK 128

sfrb UART0_IIR = 0xf202;
#define NIP 0
#define NIP_BIT 0
#define NIP_MASK 1
#define ID0 1
#define ID0_BIT 1
#define ID0_MASK 2
#define ID1 2
#define ID1_BIT 2
#define ID1_MASK 4
#define ID2 3
#define ID2_BIT 3
#define ID2_MASK 8
#define FIFOEN0 6
#define FIFOEN0_BIT 6
#define FIFOEN0_MASK 64
#define FIFOEN1 7
#define FIFOEN1_BIT 7
#define FIFOEN1_MASK 128

sfrb UART1_FCR = 0xf302;
#define FCR_FEN 0
#define FCR_FEN_BIT 0
#define FCR_FEN_MASK 1
#define FRS 1
#define FRS_BIT 1
#define FRS_MASK 2
#define TRS 2
#define TRS_BIT 2
#define TRS_MASK 4
#define RDMA 3
#define RDMA_BIT 3
#define RDMA_MASK 8
#define RCVR1L 6
#define RCVR1L_BIT 6
#define RCVR1L_MASK 64
#define RCVR1H 7
#define RCVR1H_BIT 7
#define RCVR1H_MASK 128

sfrb UART0_FCR = 0xf202;
#define FCR_FEN 0
#define FCR_FEN_BIT 0
#define FCR_FEN_MASK 1
#define FRS 1
#define FRS_BIT 1
#define FRS_MASK 2
#define TRS 2
#define TRS_BIT 2
#define TRS_MASK 4
#define RDMA 3
#define RDMA_BIT 3
#define RDMA_MASK 8
#define RCVR1L 6
#define RCVR1L_BIT 6
#define RCVR1L_MASK 64
#define RCVR1H 7
#define RCVR1H_BIT 7
#define RCVR1H_MASK 128

sfrb UART1_LCR = 0xf303;
#define WL0 0
#define WL0_BIT 0
#define WL0_MASK 1
#define WL1 1
#define WL1_BIT 1
#define WL1_MASK 2
#define SB 2
#define SB_BIT 2
#define SB_MASK 4
#define ENPAR 3
#define ENPAR_BIT 3
#define ENPAR_MASK 8
#define EVPAR 4
#define EVPAR_BIT 4
#define EVPAR_MASK 16
#define SPAR 5
#define SPAR_BIT 5
#define SPAR_MASK 32
#define SBRK 6
#define SBRK_BIT 6
#define SBRK_MASK 64
#define DLAB 7
#define DLAB_BIT 7
#define DLAB_MASK 128

sfrb UART0_LCR = 0xf203;
#define WL0 0
#define WL0_BIT 0
#define WL0_MASK 1
#define WL1 1
#define WL1_BIT 1
#define WL1_MASK 2
#define SB 2
#define SB_BIT 2
#define SB_MASK 4
#define ENPAR 3
#define ENPAR_BIT 3
#define ENPAR_MASK 8
#define EVPAR 4
#define EVPAR_BIT 4
#define EVPAR_MASK 16
#define SPAR 5
#define SPAR_BIT 5
#define SPAR_MASK 32
#define SBRK 6
#define SBRK_BIT 6
#define SBRK_MASK 64
#define DLAB 7
#define DLAB_BIT 7
#define DLAB_MASK 128

sfrb UART1_MCR = 0xf304;
#define LB 3
#define LB_BIT 3
#define LB_MASK 8
#define OUT2 4
#define OUT2_BIT 4
#define OUT2_MASK 16
#define OUT1 5
#define OUT1_BIT 5
#define OUT1_MASK 32
#define RTS 6
#define RTS_BIT 6
#define RTS_MASK 64
#define DTR 7
#define DTR_BIT 7
#define DTR_MASK 128

sfrb UART0_MCR = 0xf204;
#define LB 3
#define LB_BIT 3
#define LB_MASK 8
#define OUT2 4
#define OUT2_BIT 4
#define OUT2_MASK 16
#define OUT1 5
#define OUT1_BIT 5
#define OUT1_MASK 32
#define RTS 6
#define RTS_BIT 6
#define RTS_MASK 64
#define DTR 7
#define DTR_BIT 7
#define DTR_MASK 128

sfrb UART1_LSR = 0xf305;
#define RDA 0
#define RDA_BIT 0
#define RDA_MASK 1
#define OE 1
#define OE_BIT 1
#define OE_MASK 2
#define PE 2
#define PE_BIT 2
#define PE_MASK 4
#define FE 3
#define FE_BIT 3
#define FE_MASK 8
#define BI 4
#define BI_BIT 4
#define BI_MASK 16
#define THRR 5
#define THRR_BIT 5
#define THRR_MASK 32
#define TE 6
#define TE_BIT 6
#define TE_MASK 64
#define ERF 7
#define ERF_BIT 7
#define ERF_MASK 128

sfrb UART0_LSR = 0xf205;
#define RDA 0
#define RDA_BIT 0
#define RDA_MASK 1
#define OE 1
#define OE_BIT 1
#define OE_MASK 2
#define PE 2
#define PE_BIT 2
#define PE_MASK 4
#define FE 3
#define FE_BIT 3
#define FE_MASK 8
#define BI 4
#define BI_BIT 4
#define BI_MASK 16
#define THRR 5
#define THRR_BIT 5
#define THRR_MASK 32
#define TE 6
#define TE_BIT 6
#define TE_MASK 64
#define ERF 7
#define ERF_BIT 7
#define ERF_MASK 128

sfrb UART1_MSR = 0xf306;
#define DCTS 0
#define DCTS_BIT 0
#define DCTS_MASK 1
#define DDSR 1
#define DDSR_BIT 1
#define DDSR_MASK 2
#define TRI 2
#define TRI_BIT 2
#define TRI_MASK 4
#define DCD 3
#define DCD_BIT 3
#define DCD_MASK 8
#define CTS 4
#define CTS_BIT 4
#define CTS_MASK 16
#define DSR 5
#define DSR_BIT 5
#define DSR_MASK 32
#define RI 6
#define RI_BIT 6
#define RI_MASK 64
#define CD 7
#define CD_BIT 7
#define CD_MASK 128

sfrb UART0_MSR = 0xf206;
#define DCTS 0
#define DCTS_BIT 0
#define DCTS_MASK 1
#define DDSR 1
#define DDSR_BIT 1
#define DDSR_MASK 2
#define TRI 2
#define TRI_BIT 2
#define TRI_MASK 4
#define DCD 3
#define DCD_BIT 3
#define DCD_MASK 8
#define CTS 4
#define CTS_BIT 4
#define CTS_MASK 16
#define DSR 5
#define DSR_BIT 5
#define DSR_MASK 32
#define RI 6
#define RI_BIT 6
#define RI_MASK 64
#define CD 7
#define CD_BIT 7
#define CD_MASK 128

sfrb UART1_SCR = 0xf307;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART0_SCR = 0xf207;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART1_DLL = 0xf300;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART0_DLL = 0xf200;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART1_DLH = 0xf301;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART0_DLH = 0xf201;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART1_XR1 = 0xf308;
#define RXDIS 0
#define RXDIS_BIT 0
#define RXDIS_MASK 1
#define TXDIS 1
#define TXDIS_BIT 1
#define TXDIS_MASK 2
#define RXR 2
#define RXR_BIT 2
#define RXR_MASK 4
#define TXR 3
#define TXR_BIT 3
#define TXR_MASK 8
#define RTO 4
#define RTO_BIT 4
#define RTO_MASK 16
#define STOC 5
#define STOC_BIT 5
#define STOC_MASK 32
#define SA 6
#define SA_BIT 6
#define SA_MASK 64
#define OPL 7
#define OPL_BIT 7
#define OPL_MASK 128

sfrb UART0_XR1 = 0xf208;
#define RXDIS 0
#define RXDIS_BIT 0
#define RXDIS_MASK 1
#define TXDIS 1
#define TXDIS_BIT 1
#define TXDIS_MASK 2
#define RXR 2
#define RXR_BIT 2
#define RXR_MASK 4
#define TXR 3
#define TXR_BIT 3
#define TXR_MASK 8
#define RTO 4
#define RTO_BIT 4
#define RTO_MASK 16
#define STOC 5
#define STOC_BIT 5
#define STOC_MASK 32
#define SA 6
#define SA_BIT 6
#define SA_MASK 64
#define OPL 7
#define OPL_BIT 7
#define OPL_MASK 128

sfrb UART1_XR2 = 0xf309;
#define MDM 0
#define MDM_BIT 0
#define MDM_MASK 1
#define THRRC 5
#define THRRC_BIT 5
#define THRRC_MASK 32
#define TE 6
#define TE_BIT 6
#define TE_MASK 64
#define TXFD 7
#define TXFD_BIT 7
#define TXFD_MASK 128

sfrb UART0_XR2 = 0xf209;
#define MDM 0
#define MDM_BIT 0
#define MDM_MASK 1
#define THRRC 5
#define THRRC_BIT 5
#define THRRC_MASK 32
#define TE 6
#define TE_BIT 6
#define TE_MASK 64
#define TXFD 7
#define TXFD_BIT 7
#define TXFD_MASK 128

sfrb UART1_MDR = 0xf30a;
#define DTRD 0
#define DTRD_BIT 0
#define DTRD_MASK 1
#define RTSD 1
#define RTSD_BIT 1
#define RTSD_MASK 2
#define OUT1D 2
#define OUT1D_BIT 2
#define OUT1D_MASK 4
#define OUT2D 3
#define OUT2D_BIT 3
#define OUT2D_MASK 8
#define CTSD 4
#define CTSD_BIT 4
#define CTSD_MASK 16
#define DRSD 5
#define DRSD_BIT 5
#define DRSD_MASK 32
#define RID 6
#define RID_BIT 6
#define RID_MASK 64
#define CDD 7
#define CDD_BIT 7
#define CDD_MASK 128

sfrb UART0_MDR = 0xf20a;
#define DTRD 0
#define DTRD_BIT 0
#define DTRD_MASK 1
#define RTSD 1
#define RTSD_BIT 1
#define RTSD_MASK 2
#define OUT1D 2
#define OUT1D_BIT 2
#define OUT1D_MASK 4
#define OUT2D 3
#define OUT2D_BIT 3
#define OUT2D_MASK 8
#define CTSD 4
#define CTSD_BIT 4
#define CTSD_MASK 16
#define DRSD 5
#define DRSD_BIT 5
#define DRSD_MASK 32
#define RID 6
#define RID_BIT 6
#define RID_MASK 64
#define CDD 7
#define CDD_BIT 7
#define CDD_MASK 128

sfrb UART1_RTO = 0xf30b;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART0_RTO = 0xf20b;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART1_TTG = 0xf30c;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb UART0_TTG = 0xf20c;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb MEMMAP = 0xf800;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb DMA_EMICRA = 0xf801;
#define WM0 0
#define WM0_BIT 0
#define WM0_MASK 1
#define WM1 1
#define WM1_BIT 1
#define WM1_MASK 2
#define WW0 2
#define WW0_BIT 2
#define WW0_MASK 4
#define WW1 3
#define WW1_BIT 3
#define WW1_MASK 8
#define RM0 4
#define RM0_BIT 4
#define RM0_MASK 16
#define RM1 5
#define RM1_BIT 5
#define RM1_MASK 32
#define RW0 6
#define RW0_BIT 6
#define RW0_MASK 64
#define RW1 7
#define RW1_BIT 7
#define RW1_MASK 128

sfrb DMA_EMICRB = 0xf802;
#define EMD1 0
#define EMD1_BIT 0
#define EMD1_MASK 1
#define EMD0 1
#define EMD0_BIT 1
#define EMD0_MASK 2
#define AM0 4
#define AM0_BIT 4
#define AM0_MASK 16
#define AM1 5
#define AM1_BIT 5
#define AM1_MASK 32
#define AW0 6
#define AW0_BIT 6
#define AW0_MASK 64
#define AW1 7
#define AW1_BIT 7
#define AW1_MASK 128

sfrb SLP_MODE = 0xf000;
#define SLP 5
#define SLP_BIT 5
#define SLP_MASK 32

sfrb IRQ_EN = 0xf001;
#define RSM_INT_EN 0
#define RSM_INT_EN_BIT 0
#define RSM_INT_EN_MASK 1
#define SUSP_INT_EN 1
#define SUSP_INT_EN_BIT 1
#define SUSP_INT_EN_MASK 2

sfrb IRQ_STAT = 0xf002;
#define RSM 0
#define RSM_BIT 0
#define RSM_MASK 1
#define SUSP 1
#define SUSP_BIT 1
#define SUSP_MASK 2
#define INT 6
#define INT_BIT 6
#define INT_MASK 64

sfrb RES_STAT = 0xf003;
#define USB_RES 2
#define USB_RES_BIT 2
#define USB_RES_MASK 4

sfrb PAIR_EN = 0xf004;
#define UPA1 1
#define UPA1_BIT 1
#define UPA1_MASK 2
#define UPA2 2
#define UPA2_BIT 2
#define UPA2_MASK 4
#define UPA3 4
#define UPA3_BIT 4
#define UPA3_MASK 16

sfrb USB_DMA_ADL = 0xf005;
#define UDA0 0
#define UDA0_BIT 0
#define UDA0_MASK 1
#define UDA1 1
#define UDA1_BIT 1
#define UDA1_MASK 2
#define UDA2 2
#define UDA2_BIT 2
#define UDA2_MASK 4
#define UDA3 3
#define UDA3_BIT 3
#define UDA3_MASK 8
#define UDA4 4
#define UDA4_BIT 4
#define UDA4_MASK 16
#define UDA5 5
#define UDA5_BIT 5
#define UDA5_MASK 32
#define UDA6 6
#define UDA6_BIT 6
#define UDA6_MASK 64
#define UDA7 7
#define UDA7_BIT 7
#define UDA7_MASK 128

sfrb USB_DMA_ADH = 0xf006;
#define UDA8 0
#define UDA8_BIT 0
#define UDA8_MASK 1
#define UDA9 1
#define UDA9_BIT 1
#define UDA9_MASK 2
#define UDA10 2
#define UDA10_BIT 2
#define UDA10_MASK 4
#define UDA11 3
#define UDA11_BIT 3
#define UDA11_MASK 8
#define UDA12 4
#define UDA12_BIT 4
#define UDA12_MASK 16
#define UDA13 5
#define UDA13_BIT 5
#define UDA13_MASK 32
#define UDA14 6
#define UDA14_BIT 6
#define UDA14_MASK 64

sfrb USB_DMA_LEN = 0xf007;
#define PLEN0 0
#define PLEN0_BIT 0
#define PLEN0_MASK 1
#define PLEN1 1
#define PLEN1_BIT 1
#define PLEN1_MASK 2
#define PLEN2 2
#define PLEN2_BIT 2
#define PLEN2_MASK 4
#define PLEN3 3
#define PLEN3_BIT 3
#define PLEN3_MASK 8
#define PLEN4 4
#define PLEN4_BIT 4
#define PLEN4_MASK 16
#define PLEN5 5
#define PLEN5_BIT 5
#define PLEN5_MASK 32
#define PLEN6 6
#define PLEN6_BIT 6
#define PLEN6_MASK 64
#define PLEN7 7
#define PLEN7_BIT 7
#define PLEN7_MASK 128

sfrb USB_DMA_EAD = 0xf008;
#define EAD0 0
#define EAD0_BIT 0
#define EAD0_MASK 1
#define EAD1 1
#define EAD1_BIT 1
#define EAD1_MASK 2
#define EAD2 2
#define EAD2_BIT 2
#define EAD2_MASK 4
#define EAD3 3
#define EAD3_BIT 3
#define EAD3_MASK 8
#define EAD4 4
#define EAD4_BIT 4
#define EAD4_MASK 16
#define EAD5 5
#define EAD5_BIT 5
#define EAD5_MASK 32
#define EAD6 6
#define EAD6_BIT 6
#define EAD6_MASK 64
#define EAD7 7
#define EAD7_BIT 7
#define EAD7_MASK 128

sfrb USB_DMA_PLT = 0xf009;
#define TPL0 0
#define TPL0_BIT 0
#define TPL0_MASK 1
#define TPL1 1
#define TPL1_BIT 1
#define TPL1_MASK 2
#define TPL2 2
#define TPL2_BIT 2
#define TPL2_MASK 4
#define TPL3 3
#define TPL3_BIT 3
#define TPL3_MASK 8
#define TPL4 4
#define TPL4_BIT 4
#define TPL4_MASK 16
#define TPL5 5
#define TPL5_BIT 5
#define TPL5_MASK 32
#define TPL6 6
#define TPL6_BIT 6
#define TPL6_MASK 64
#define TPL7 7
#define TPL7_BIT 7
#define TPL7_MASK 128

sfrb USB_DMA_EN = 0xf00a;
#define USB_TDMA_EN 0
#define USB_TDMA_EN_BIT 0
#define USB_TDMA_EN_MASK 1
#define USB_RDMA_EN 1
#define USB_RDMA_EN_BIT 1
#define USB_RDMA_EN_MASK 2

sfrb F_BYTE_CNT7_H = 0xf0a8;
#define BYTECNT8 0
#define BYTECNT8_BIT 0
#define BYTECNT8_MASK 1
#define BYTECNT9 1
#define BYTECNT9_BIT 1
#define BYTECNT9_MASK 2
#define BYTECNT10 2
#define BYTECNT10_BIT 2
#define BYTECNT10_MASK 4

sfrb F_BYTE_CNT6_H = 0xf0a9;
#define BYTECNT8 0
#define BYTECNT8_BIT 0
#define BYTECNT8_MASK 1
#define BYTECNT9 1
#define BYTECNT9_BIT 1
#define BYTECNT9_MASK 2
#define BYTECNT10 2
#define BYTECNT10_BIT 2
#define BYTECNT10_MASK 4

sfrb F_BYTE_CNT5_H = 0xf0aa;
#define BYTECNT8 0
#define BYTECNT8_BIT 0
#define BYTECNT8_MASK 1
#define BYTECNT9 1
#define BYTECNT9_BIT 1
#define BYTECNT9_MASK 2
#define BYTECNT10 2
#define BYTECNT10_BIT 2
#define BYTECNT10_MASK 4

sfrb F_BYTE_CNT4_H = 0xf0ab;
#define BYTECNT8 0
#define BYTECNT8_BIT 0
#define BYTECNT8_MASK 1
#define BYTECNT9 1
#define BYTECNT9_BIT 1
#define BYTECNT9_MASK 2
#define BYTECNT10 2
#define BYTECNT10_BIT 2
#define BYTECNT10_MASK 4

sfrb F_BYTE_CNT3_H = 0xf0ac;
#define BYTECNT8 0
#define BYTECNT8_BIT 0
#define BYTECNT8_MASK 1
#define BYTECNT9 1
#define BYTECNT9_BIT 1
#define BYTECNT9_MASK 2
#define BYTECNT10 2
#define BYTECNT10_BIT 2
#define BYTECNT10_MASK 4

sfrb F_BYTE_CNT2_H = 0xf0ad;
#define BYTECNT8 0
#define BYTECNT8_BIT 0
#define BYTECNT8_MASK 1
#define BYTECNT9 1
#define BYTECNT9_BIT 1
#define BYTECNT9_MASK 2
#define BYTECNT10 2
#define BYTECNT10_BIT 2
#define BYTECNT10_MASK 4

sfrb F_BYTE_CNT1_H = 0xf0ae;
#define BYTECNT8 0
#define BYTECNT8_BIT 0
#define BYTECNT8_MASK 1
#define BYTECNT9 1
#define BYTECNT9_BIT 1
#define BYTECNT9_MASK 2
#define BYTECNT10 2
#define BYTECNT10_BIT 2
#define BYTECNT10_MASK 4

sfrb F_BYTE_CNT0_H = 0xf0af;
#define BYTECNT8 0
#define BYTECNT8_BIT 0
#define BYTECNT8_MASK 1
#define BYTECNT9 1
#define BYTECNT9_BIT 1
#define BYTECNT9_MASK 2
#define BYTECNT10 2
#define BYTECNT10_BIT 2
#define BYTECNT10_MASK 4

sfrb F_BYTE_CNT7_L = 0xf0b8;
#define BYTECNT0 0
#define BYTECNT0_BIT 0
#define BYTECNT0_MASK 1
#define BYTECNT1 1
#define BYTECNT1_BIT 1
#define BYTECNT1_MASK 2
#define BYTECNT2 2
#define BYTECNT2_BIT 2
#define BYTECNT2_MASK 4
#define BYTECNT3 3
#define BYTECNT3_BIT 3
#define BYTECNT3_MASK 8
#define BYTECNT4 4
#define BYTECNT4_BIT 4
#define BYTECNT4_MASK 16
#define BYTECNT5 5
#define BYTECNT5_BIT 5
#define BYTECNT5_MASK 32
#define BYTECNT6 6
#define BYTECNT6_BIT 6
#define BYTECNT6_MASK 64
#define BYTECNT7 7
#define BYTECNT7_BIT 7
#define BYTECNT7_MASK 128

sfrb F_BYTE_CNT6_L = 0xf0b9;
#define BYTECNT0 0
#define BYTECNT0_BIT 0
#define BYTECNT0_MASK 1
#define BYTECNT1 1
#define BYTECNT1_BIT 1
#define BYTECNT1_MASK 2
#define BYTECNT2 2
#define BYTECNT2_BIT 2
#define BYTECNT2_MASK 4
#define BYTECNT3 3
#define BYTECNT3_BIT 3
#define BYTECNT3_MASK 8
#define BYTECNT4 4
#define BYTECNT4_BIT 4
#define BYTECNT4_MASK 16
#define BYTECNT5 5
#define BYTECNT5_BIT 5
#define BYTECNT5_MASK 32
#define BYTECNT6 6
#define BYTECNT6_BIT 6
#define BYTECNT6_MASK 64
#define BYTECNT7 7
#define BYTECNT7_BIT 7
#define BYTECNT7_MASK 128

sfrb F_BYTE_CNT5_L = 0xf0ba;
#define BYTECNT0 0
#define BYTECNT0_BIT 0
#define BYTECNT0_MASK 1
#define BYTECNT1 1
#define BYTECNT1_BIT 1
#define BYTECNT1_MASK 2
#define BYTECNT2 2
#define BYTECNT2_BIT 2
#define BYTECNT2_MASK 4
#define BYTECNT3 3
#define BYTECNT3_BIT 3
#define BYTECNT3_MASK 8
#define BYTECNT4 4
#define BYTECNT4_BIT 4
#define BYTECNT4_MASK 16
#define BYTECNT5 5
#define BYTECNT5_BIT 5
#define BYTECNT5_MASK 32
#define BYTECNT6 6
#define BYTECNT6_BIT 6
#define BYTECNT6_MASK 64
#define BYTECNT7 7
#define BYTECNT7_BIT 7
#define BYTECNT7_MASK 128

sfrb F_BYTE_CNT4_L = 0xf0bb;
#define BYTECNT0 0
#define BYTECNT0_BIT 0
#define BYTECNT0_MASK 1
#define BYTECNT1 1
#define BYTECNT1_BIT 1
#define BYTECNT1_MASK 2
#define BYTECNT2 2
#define BYTECNT2_BIT 2
#define BYTECNT2_MASK 4
#define BYTECNT3 3
#define BYTECNT3_BIT 3
#define BYTECNT3_MASK 8
#define BYTECNT4 4
#define BYTECNT4_BIT 4
#define BYTECNT4_MASK 16
#define BYTECNT5 5
#define BYTECNT5_BIT 5
#define BYTECNT5_MASK 32
#define BYTECNT6 6
#define BYTECNT6_BIT 6
#define BYTECNT6_MASK 64
#define BYTECNT7 7
#define BYTECNT7_BIT 7
#define BYTECNT7_MASK 128

sfrb F_BYTE_CNT3_L = 0xf0bc;
#define BYTECNT0 0
#define BYTECNT0_BIT 0
#define BYTECNT0_MASK 1
#define BYTECNT1 1
#define BYTECNT1_BIT 1
#define BYTECNT1_MASK 2
#define BYTECNT2 2
#define BYTECNT2_BIT 2
#define BYTECNT2_MASK 4
#define BYTECNT3 3
#define BYTECNT3_BIT 3
#define BYTECNT3_MASK 8
#define BYTECNT4 4
#define BYTECNT4_BIT 4
#define BYTECNT4_MASK 16
#define BYTECNT5 5
#define BYTECNT5_BIT 5
#define BYTECNT5_MASK 32
#define BYTECNT6 6
#define BYTECNT6_BIT 6
#define BYTECNT6_MASK 64
#define BYTECNT7 7
#define BYTECNT7_BIT 7
#define BYTECNT7_MASK 128

sfrb F_BYTE_CNT2_L = 0xf0bd;
#define BYTECNT0 0
#define BYTECNT0_BIT 0
#define BYTECNT0_MASK 1
#define BYTECNT1 1
#define BYTECNT1_BIT 1
#define BYTECNT1_MASK 2
#define BYTECNT2 2
#define BYTECNT2_BIT 2
#define BYTECNT2_MASK 4
#define BYTECNT3 3
#define BYTECNT3_BIT 3
#define BYTECNT3_MASK 8
#define BYTECNT4 4
#define BYTECNT4_BIT 4
#define BYTECNT4_MASK 16
#define BYTECNT5 5
#define BYTECNT5_BIT 5
#define BYTECNT5_MASK 32
#define BYTECNT6 6
#define BYTECNT6_BIT 6
#define BYTECNT6_MASK 64
#define BYTECNT7 7
#define BYTECNT7_BIT 7
#define BYTECNT7_MASK 128

sfrb F_BYTE_CNT1_L = 0xf0be;
#define BYTECNT0 0
#define BYTECNT0_BIT 0
#define BYTECNT0_MASK 1
#define BYTECNT1 1
#define BYTECNT1_BIT 1
#define BYTECNT1_MASK 2
#define BYTECNT2 2
#define BYTECNT2_BIT 2
#define BYTECNT2_MASK 4
#define BYTECNT3 3
#define BYTECNT3_BIT 3
#define BYTECNT3_MASK 8
#define BYTECNT4 4
#define BYTECNT4_BIT 4
#define BYTECNT4_MASK 16
#define BYTECNT5 5
#define BYTECNT5_BIT 5
#define BYTECNT5_MASK 32
#define BYTECNT6 6
#define BYTECNT6_BIT 6
#define BYTECNT6_MASK 64
#define BYTECNT7 7
#define BYTECNT7_BIT 7
#define BYTECNT7_MASK 128

sfrb F_BYTE_CNT0_L = 0xf0bf;
#define BYTECNT0 0
#define BYTECNT0_BIT 0
#define BYTECNT0_MASK 1
#define BYTECNT1 1
#define BYTECNT1_BIT 1
#define BYTECNT1_MASK 2
#define BYTECNT2 2
#define BYTECNT2_BIT 2
#define BYTECNT2_MASK 4
#define BYTECNT3 3
#define BYTECNT3_BIT 3
#define BYTECNT3_MASK 8
#define BYTECNT4 4
#define BYTECNT4_BIT 4
#define BYTECNT4_MASK 16
#define BYTECNT5 5
#define BYTECNT5_BIT 5
#define BYTECNT5_MASK 32
#define BYTECNT6 6
#define BYTECNT6_BIT 6
#define BYTECNT6_MASK 64
#define BYTECNT7 7
#define BYTECNT7_BIT 7
#define BYTECNT7_MASK 128

sfrb FDR7 = 0xf0c8;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb FDR6 = 0xf0c9;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb FDR5 = 0xf0ca;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb FDR4 = 0xf0cb;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb FDR3 = 0xf0cc;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb FDR2 = 0xf0cd;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb FDR1 = 0xf0ce;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb FDR0 = 0xf0cf;
#define BIT0 0
#define BIT0_BIT 0
#define BIT0_MASK 1
#define BIT1 1
#define BIT1_BIT 1
#define BIT1_MASK 2
#define BIT2 2
#define BIT2_BIT 2
#define BIT2_MASK 4
#define BIT3 3
#define BIT3_BIT 3
#define BIT3_MASK 8
#define BIT4 4
#define BIT4_BIT 4
#define BIT4_MASK 16
#define BIT5 5
#define BIT5_BIT 5
#define BIT5_MASK 32
#define BIT6 6
#define BIT6_BIT 6
#define BIT6_MASK 64
#define BIT7 7
#define BIT7_BIT 7
#define BIT7_MASK 128

sfrb ECSR7 = 0xf0d8;
#define Tx_Complete 0
#define Tx_Complete_BIT 0
#define Tx_Complete_MASK 1
#define RX_OUT_packet 1
#define RX_OUT_packet_BIT 1
#define RX_OUT_packet_MASK 2
#define RX_SETUP 2
#define RX_SETUP_BIT 2
#define RX_SETUP_MASK 4
#define Stall_Snd 3
#define Stall_Snd_BIT 3
#define Stall_Snd_MASK 8
#define TX_Packet_Ready 4
#define TX_Packet_Ready_BIT 4
#define TX_Packet_Ready_MASK 16
#define Force_Stall 5
#define Force_Stall_BIT 5
#define Force_Stall_MASK 32
#define Data_End 6
#define Data_End_BIT 6
#define Data_End_MASK 64
#define Control_Direction 7
#define Control_Direction_BIT 7
#define Control_Direction_MASK 128

sfrb ECSR6 = 0xf0d9;
#define Tx_Complete 0
#define Tx_Complete_BIT 0
#define Tx_Complete_MASK 1
#define RX_OUT_packet 1
#define RX_OUT_packet_BIT 1
#define RX_OUT_packet_MASK 2
#define RX_SETUP 2
#define RX_SETUP_BIT 2
#define RX_SETUP_MASK 4
#define Stall_Snd 3
#define Stall_Snd_BIT 3
#define Stall_Snd_MASK 8
#define TX_Packet_Ready 4
#define TX_Packet_Ready_BIT 4
#define TX_Packet_Ready_MASK 16
#define Force_Stall 5
#define Force_Stall_BIT 5
#define Force_Stall_MASK 32
#define Data_End 6
#define Data_End_BIT 6
#define Data_End_MASK 64
#define Control_Direction 7
#define Control_Direction_BIT 7
#define Control_Direction_MASK 128

sfrb ECSR5 = 0xf0da;
#define Tx_Complete 0
#define Tx_Complete_BIT 0
#define Tx_Complete_MASK 1
#define RX_OUT_packet 1
#define RX_OUT_packet_BIT 1
#define RX_OUT_packet_MASK 2
#define RX_SETUP 2
#define RX_SETUP_BIT 2
#define RX_SETUP_MASK 4
#define Stall_Snd 3
#define Stall_Snd_BIT 3
#define Stall_Snd_MASK 8
#define TX_Packet_Ready 4
#define TX_Packet_Ready_BIT 4
#define TX_Packet_Ready_MASK 16
#define Force_Stall 5
#define Force_Stall_BIT 5
#define Force_Stall_MASK 32
#define Data_End 6
#define Data_End_BIT 6
#define Data_End_MASK 64
#define Control_Direction 7
#define Control_Direction_BIT 7
#define Control_Direction_MASK 128

sfrb ECSR4 = 0xf0db;
#define Tx_Complete 0
#define Tx_Complete_BIT 0
#define Tx_Complete_MASK 1
#define RX_OUT_packet 1
#define RX_OUT_packet_BIT 1
#define RX_OUT_packet_MASK 2
#define RX_SETUP 2
#define RX_SETUP_BIT 2
#define RX_SETUP_MASK 4
#define Stall_Snd 3
#define Stall_Snd_BIT 3
#define Stall_Snd_MASK 8
#define TX_Packet_Ready 4
#define TX_Packet_Ready_BIT 4
#define TX_Packet_Ready_MASK 16
#define Force_Stall 5
#define Force_Stall_BIT 5
#define Force_Stall_MASK 32
#define Data_End 6
#define Data_End_BIT 6
#define Data_End_MASK 64
#define Control_Direction 7
#define Control_Direction_BIT 7
#define Control_Direction_MASK 128

sfrb ECSR3 = 0xf0dc;
#define Tx_Complete 0
#define Tx_Complete_BIT 0
#define Tx_Complete_MASK 1
#define RX_OUT_packet 1
#define RX_OUT_packet_BIT 1
#define RX_OUT_packet_MASK 2
#define RX_SETUP 2
#define RX_SETUP_BIT 2
#define RX_SETUP_MASK 4
#define Stall_Snd 3
#define Stall_Snd_BIT 3
#define Stall_Snd_MASK 8
#define TX_Packet_Ready 4
#define TX_Packet_Ready_BIT 4
#define TX_Packet_Ready_MASK 16
#define Force_Stall 5
#define Force_Stall_BIT 5
#define Force_Stall_MASK 32
#define Data_End 6
#define Data_End_BIT 6
#define Data_End_MASK 64
#define Control_Direction 7
#define Control_Direction_BIT 7
#define Control_Direction_MASK 128

sfrb ECSR2 = 0xf0dd;
#define Tx_Complete 0
#define Tx_Complete_BIT 0
#define Tx_Complete_MASK 1
#define RX_OUT_packet 1
#define RX_OUT_packet_BIT 1
#define RX_OUT_packet_MASK 2
#define RX_SETUP 2
#define RX_SETUP_BIT 2
#define RX_SETUP_MASK 4
#define Stall_Snd 3
#define Stall_Snd_BIT 3
#define Stall_Snd_MASK 8
#define TX_Packet_Ready 4
#define TX_Packet_Ready_BIT 4
#define TX_Packet_Ready_MASK 16
#define Force_Stall 5
#define Force_Stall_BIT 5
#define Force_Stall_MASK 32
#define Data_End 6
#define Data_End_BIT 6
#define Data_End_MASK 64
#define Control_Direction 7
#define Control_Direction_BIT 7
#define Control_Direction_MASK 128

sfrb ECSR1 = 0xf0de;
#define Tx_Complete 0
#define Tx_Complete_BIT 0
#define Tx_Complete_MASK 1
#define RX_OUT_packet 1
#define RX_OUT_packet_BIT 1
#define RX_OUT_packet_MASK 2
#define RX_SETUP 2
#define RX_SETUP_BIT 2
#define RX_SETUP_MASK 4
#define Stall_Snd 3
#define Stall_Snd_BIT 3
#define Stall_Snd_MASK 8
#define TX_Packet_Ready 4
#define TX_Packet_Ready_BIT 4
#define TX_Packet_Ready_MASK 16
#define Force_Stall 5
#define Force_Stall_BIT 5
#define Force_Stall_MASK 32
#define Data_End 6
#define Data_End_BIT 6
#define Data_End_MASK 64
#define Control_Direction 7
#define Control_Direction_BIT 7
#define Control_Direction_MASK 128

sfrb ECSR0 = 0xf0df;
#define Tx_Complete 0
#define Tx_Complete_BIT 0
#define Tx_Complete_MASK 1
#define RX_OUT_packet 1
#define RX_OUT_packet_BIT 1
#define RX_OUT_packet_MASK 2
#define RX_SETUP 2
#define RX_SETUP_BIT 2
#define RX_SETUP_MASK 4
#define Stall_Snd 3
#define Stall_Snd_BIT 3
#define Stall_Snd_MASK 8
#define TX_Packet_Ready 4
#define TX_Packet_Ready_BIT 4
#define TX_Packet_Ready_MASK 16
#define Force_Stall 5
#define Force_Stall_BIT 5
#define Force_Stall_MASK 32
#define Data_End 6
#define Data_End_BIT 6
#define Data_End_MASK 64
#define Control_Direction 7
#define Control_Direction_BIT 7
#define Control_Direction_MASK 128

sfrb ECR7 = 0xf0e8;
#define EPTYPE0 0
#define EPTYPE0_BIT 0
#define EPTYPE0_MASK 1
#define EP_TYPE1 1
#define EP_TYPE1_BIT 1
#define EP_TYPE1_MASK 2
#define DTGLE 2
#define DTGLE_BIT 2
#define DTGLE_MASK 4
#define EPEDS 7
#define EPEDS_BIT 7
#define EPEDS_MASK 128

sfrb ECR6 = 0xf0e9;
#define EPTYPE0 0
#define EPTYPE0_BIT 0
#define EPTYPE0_MASK 1
#define EP_TYPE1 1
#define EP_TYPE1_BIT 1
#define EP_TYPE1_MASK 2
#define DTGLE 2
#define DTGLE_BIT 2
#define DTGLE_MASK 4
#define EPEDS 7
#define EPEDS_BIT 7
#define EPEDS_MASK 128

sfrb ECR5 = 0xf0ea;
#define EPTYPE0 0
#define EPTYPE0_BIT 0
#define EPTYPE0_MASK 1
#define EP_TYPE1 1
#define EP_TYPE1_BIT 1
#define EP_TYPE1_MASK 2
#define DTGLE 2
#define DTGLE_BIT 2
#define DTGLE_MASK 4
#define EPEDS 7
#define EPEDS_BIT 7
#define EPEDS_MASK 128

sfrb ECR4 = 0xf0eb;
#define EPTYPE0 0
#define EPTYPE0_BIT 0
#define EPTYPE0_MASK 1
#define EP_TYPE1 1
#define EP_TYPE1_BIT 1
#define EP_TYPE1_MASK 2
#define DTGLE 2
#define DTGLE_BIT 2
#define DTGLE_MASK 4
#define EPEDS 7
#define EPEDS_BIT 7
#define EPEDS_MASK 128

sfrb ECR3 = 0xf0ec;
#define EPTYPE0 0
#define EPTYPE0_BIT 0
#define EPTYPE0_MASK 1
#define EP_TYPE1 1
#define EP_TYPE1_BIT 1
#define EP_TYPE1_MASK 2
#define DTGLE 2
#define DTGLE_BIT 2
#define DTGLE_MASK 4
#define EPEDS 7
#define EPEDS_BIT 7
#define EPEDS_MASK 128

sfrb ECR2 = 0xf0ed;
#define EPTYPE0 0
#define EPTYPE0_BIT 0
#define EPTYPE0_MASK 1
#define EP_TYPE1 1
#define EP_TYPE1_BIT 1
#define EP_TYPE1_MASK 2
#define DTGLE 2
#define DTGLE_BIT 2
#define DTGLE_MASK 4
#define EPEDS 7
#define EPEDS_BIT 7
#define EPEDS_MASK 128

sfrb ECR1 = 0xf0ee;
#define EPTYPE0 0
#define EPTYPE0_BIT 0
#define EPTYPE0_MASK 1
#define EP_TYPE1 1
#define EP_TYPE1_BIT 1
#define EP_TYPE1_MASK 2
#define DTGLE 2
#define DTGLE_BIT 2
#define DTGLE_MASK 4
#define EPEDS 7
#define EPEDS_BIT 7
#define EPEDS_MASK 128

sfrb ECR0 = 0xf0ef;
#define EPTYPE0 0
#define EPTYPE0_BIT 0
#define EPTYPE0_MASK 1
#define EP_TYPE1 1
#define EP_TYPE1_BIT 1
#define EP_TYPE1_MASK 2
#define DTGLE 2
#define DTGLE_BIT 2
#define DTGLE_MASK 4
#define EPEDS 7
#define EPEDS_BIT 7
#define EPEDS_MASK 128

sfrb ENDPPGPG = 0xf0f1;
#define PG_PG0 0
#define PG_PG0_BIT 0
#define PG_PG0_MASK 1
#define PG_PG1 1
#define PG_PG1_BIT 1
#define PG_PG1_MASK 2
#define PG_PG2 2
#define PG_PG2_BIT 2
#define PG_PG2_MASK 4
#define PG_PG3 3
#define PG_PG3_BIT 3
#define PG_PG3_MASK 8
#define PG_PG4 4
#define PG_PG4_BIT 4
#define PG_PG4_MASK 16
#define PG_PG5 5
#define PG_PG5_BIT 5
#define PG_PG5_MASK 32
#define PG_PG6 6
#define PG_PG6_BIT 6
#define PG_PG6_MASK 64

sfrb FADDR = 0xf0f2;
#define FADD0 0
#define FADD0_BIT 0
#define FADD0_MASK 1
#define FADD1 1
#define FADD1_BIT 1
#define FADD1_MASK 2
#define FADD2 2
#define FADD2_BIT 2
#define FADD2_MASK 4
#define FADD3 3
#define FADD3_BIT 3
#define FADD3_MASK 8
#define FADD4 4
#define FADD4_BIT 4
#define FADD4_MASK 16
#define FADD5 5
#define FADD5_BIT 5
#define FADD5_MASK 32
#define FADD6 6
#define FADD6_BIT 6
#define FADD6_MASK 64
#define FEN 7
#define FEN_BIT 7
#define FEN_MASK 128

sfrb UIER = 0xf0f3;
#define EP0_IE 0
#define EP0_IE_BIT 0
#define EP0_IE_MASK 1
#define EP1_IE 1
#define EP1_IE_BIT 1
#define EP1_IE_MASK 2
#define EP2_IE 2
#define EP2_IE_BIT 2
#define EP2_IE_MASK 4
#define EP3_IE 3
#define EP3_IE_BIT 3
#define EP3_IE_MASK 8
#define EP4_IE 4
#define EP4_IE_BIT 4
#define EP4_IE_MASK 16
#define EP5_IE 5
#define EP5_IE_BIT 5
#define EP5_IE_MASK 32
#define EP6_IE 6
#define EP6_IE_BIT 6
#define EP6_IE_MASK 64
#define UIER_SOF_IE 7
#define UIER_SOF_IE_BIT 7
#define UIER_SOF_IE_MASK 128

sfrb UIAR = 0xf0f5;
#define EP0_INTA 0
#define EP0_INTA_BIT 0
#define EP0_INTA_MASK 1
#define EP1_INTA 1
#define EP1_INTA_BIT 1
#define EP1_INTA_MASK 2
#define EP2_INTA 2
#define EP2_INTA_BIT 2
#define EP2_INTA_MASK 4
#define EP3_INTA 3
#define EP3_INTA_BIT 3
#define EP3_INTA_MASK 8
#define EP4_INTA 4
#define EP4_INTA_BIT 4
#define EP4_INTA_MASK 16
#define EP5_INTA 5
#define EP5_INTA_BIT 5
#define EP5_INTA_MASK 32
#define EP6_INTA 6
#define EP6_INTA_BIT 6
#define EP6_INTA_MASK 64

sfrb UISR = 0xf0f7;
#define EP0_INT 0
#define EP0_INT_BIT 0
#define EP0_INT_MASK 1
#define EP1_INT 1
#define EP1_INT_BIT 1
#define EP1_INT_MASK 2
#define EP2_INT 2
#define EP2_INT_BIT 2
#define EP2_INT_MASK 4
#define EP3_INT 3
#define EP3_INT_BIT 3
#define EP3_INT_MASK 8
#define EP4_INT 4
#define EP4_INT_BIT 4
#define EP4_INT_MASK 16
#define EP5_INT 5
#define EP5_INT_BIT 5
#define EP5_INT_MASK 32
#define EP6_INT 6
#define EP6_INT_BIT 6
#define EP6_INT_MASK 64

sfrb SPRSIE = 0xf0f9;
#define SUSP_IE 0
#define SUSP_IE_BIT 0
#define SUSP_IE_MASK 1
#define RCVDRSM_IE 1
#define RCVDRSM_IE_BIT 1
#define RCVDRSM_IE_MASK 2
#define EXTRSM_IE 2
#define EXTRSM_IE_BIT 2
#define EXTRSM_IE_MASK 4
#define SOF_IE 3
#define SOF_IE_BIT 3
#define SOF_IE_MASK 8

sfrb SPRSR = 0xf0fa;
#define SPSR_SUSP 0
#define SPSR_SUSP_BIT 0
#define SPSR_SUSP_MASK 1
#define RCVD_RSM 1
#define RCVD_RSM_BIT 1
#define RCVD_RSM_MASK 2
#define EXT_RSM 2
#define EXT_RSM_BIT 2
#define EXT_RSM_MASK 4
#define SOF_INT 3
#define SOF_INT_BIT 3
#define SOF_INT_MASK 8

sfrb GLB_STATE = 0xf0fb;
#define FADD_enable 0
#define FADD_enable_BIT 0
#define FADD_enable_MASK 1
#define CONFG 1
#define CONFG_BIT 1
#define CONFG_MASK 2
#define RMWUPE 2
#define RMWUPE_BIT 2
#define RMWUPE_MASK 4
#define RSMINRP 3
#define RSMINRP_BIT 3
#define RSMINRP_MASK 8

sfrb FRM_NUM_L = 0xf0fc;
#define FCL0 0
#define FCL0_BIT 0
#define FCL0_MASK 1
#define FCL1 1
#define FCL1_BIT 1
#define FCL1_MASK 2
#define FCL2 2
#define FCL2_BIT 2
#define FCL2_MASK 4
#define FCL3 3
#define FCL3_BIT 3
#define FCL3_MASK 8
#define FCL4 4
#define FCL4_BIT 4
#define FCL4_MASK 16
#define FCL5 5
#define FCL5_BIT 5
#define FCL5_MASK 32
#define FCL6 6
#define FCL6_BIT 6
#define FCL6_MASK 64
#define FCL7 7
#define FCL7_BIT 7
#define FCL7_MASK 128

sfrb FRM_NUM_H = 0xf0fd;
#define FCH8 0
#define FCH8_BIT 0
#define FCH8_MASK 1
#define FCH9 1
#define FCH9_BIT 1
#define FCH9_MASK 2
#define FCH10 2
#define FCH10_BIT 2
#define FCH10_MASK 4

sfrb IDR = 0x5c;
#define LSB0 0
#define LSB0_BIT 0
#define LSB0_MASK 1
#define LSB1 1
#define LSB1_BIT 1
#define LSB1_MASK 2
#define LSB2 2
#define LSB2_BIT 2
#define LSB2_MASK 4
#define LSB3 3
#define LSB3_BIT 3
#define LSB3_MASK 8
#define LSB4 4
#define LSB4_BIT 4
#define LSB4_MASK 16
#define LSB5 5
#define LSB5_BIT 5
#define LSB5_MASK 32
#define LSB6 6
#define LSB6_BIT 6
#define LSB6_MASK 64
#define IDRD 7
#define IDRD_BIT 7
#define IDRD_MASK 128

sfrb TIMSK = 0x59;
#define TOIE0 1
#define TOIE0_BIT 1
#define TOIE0_MASK 2
#define TOIE2 2
#define TOIE2_BIT 2
#define TOIE2_MASK 4
#define TICIE1 3
#define TICIE1_BIT 3
#define TICIE1_MASK 8
#define OCIE1B 5
#define OCIE1B_BIT 5
#define OCIE1B_MASK 32
#define OCIE1A 6
#define OCIE1A_BIT 6
#define OCIE1A_MASK 64
#define TOIE1 7
#define TOIE1_BIT 7
#define TOIE1_MASK 128

sfrb TIFR = 0x58;
#define TOV0 1
#define TOV0_BIT 1
#define TOV0_MASK 2
#define TOV2 2
#define TOV2_BIT 2
#define TOV2_MASK 4
#define ICF1 3
#define ICF1_BIT 3
#define ICF1_MASK 8
#define OCFB 5
#define OCFB_BIT 5
#define OCFB_MASK 32
#define OCFA 6
#define OCFA_BIT 6
#define OCFA_MASK 64

sfrb EIMSK = 0x57;
#define INT0 0
#define INT0_BIT 0
#define INT0_MASK 1
#define INT1 1
#define INT1_BIT 1
#define INT1_MASK 2
#define INT2 2
#define INT2_BIT 2
#define INT2_MASK 4
#define INT3 3
#define INT3_BIT 3
#define INT3_MASK 8
#define POL0 4
#define POL0_BIT 4
#define POL0_MASK 16
#define POL1 5
#define POL1_BIT 5
#define POL1_MASK 32
#define POL2 6
#define POL2_BIT 6
#define POL2_MASK 64
#define POL3 7
#define POL3_BIT 7
#define POL3_MASK 128

sfrb MCUCR = 0x55;
#define SM 4
#define SM_BIT 4
#define SM_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2

sfrb TCCR0 = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4

sfrb TCNT0 = 0x52;
#define TCNT0_0 0
#define TCNT0_0_BIT 0
#define TCNT0_0_MASK 1
#define TCNT0_1 1
#define TCNT0_1_BIT 1
#define TCNT0_1_MASK 2
#define TCNT0_2 2
#define TCNT0_2_BIT 2
#define TCNT0_2_MASK 4
#define TCNT0_3 3
#define TCNT0_3_BIT 3
#define TCNT0_3_MASK 8
#define TCNT0_4 4
#define TCNT0_4_BIT 4
#define TCNT0_4_MASK 16
#define TCNT0_5 5
#define TCNT0_5_BIT 5
#define TCNT0_5_MASK 32
#define TCNT0_6 6
#define TCNT0_6_BIT 6
#define TCNT0_6_MASK 64
#define TCNT0_7 7
#define TCNT0_7_BIT 7
#define TCNT0_7_MASK 128

sfrb PRELD0 = 0x51;
#define PRELD0_0 0
#define PRELD0_0_BIT 0
#define PRELD0_0_MASK 1
#define PRELD0_1 1
#define PRELD0_1_BIT 1
#define PRELD0_1_MASK 2
#define PRELD0_2 2
#define PRELD0_2_BIT 2
#define PRELD0_2_MASK 4
#define PRELD0_3 3
#define PRELD0_3_BIT 3
#define PRELD0_3_MASK 8
#define PRELD0_4 4
#define PRELD0_4_BIT 4
#define PRELD0_4_MASK 16
#define PRELD0_5 5
#define PRELD0_5_BIT 5
#define PRELD0_5_MASK 32
#define PRELD0_6 6
#define PRELD0_6_BIT 6
#define PRELD0_6_MASK 64
#define PRELD0_7 7
#define PRELD0_7_BIT 7
#define PRELD0_7_MASK 128

sfrb TCCR1B = 0x4e;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define CTCA1 3
#define CTCA1_BIT 3
#define CTCA1_MASK 8
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCNT1H = 0x4d;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x4c;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x4c;

sfrb OCR1AH = 0x4b;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x4a;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x4a;

sfrb OCR1BH = 0x49;
#define OCR1BH0 0
#define OCR1BH0_BIT 0
#define OCR1BH0_MASK 1
#define OCR1BH1 1
#define OCR1BH1_BIT 1
#define OCR1BH1_MASK 2
#define OCR1BH2 2
#define OCR1BH2_BIT 2
#define OCR1BH2_MASK 4
#define OCR1BH3 3
#define OCR1BH3_BIT 3
#define OCR1BH3_MASK 8
#define OCR1BH4 4
#define OCR1BH4_BIT 4
#define OCR1BH4_MASK 16
#define OCR1BH5 5
#define OCR1BH5_BIT 5
#define OCR1BH5_MASK 32
#define OCR1BH6 6
#define OCR1BH6_BIT 6
#define OCR1BH6_MASK 64
#define OCR1BH7 7
#define OCR1BH7_BIT 7
#define OCR1BH7_MASK 128

sfrb OCR1BL = 0x48;
#define OCR1BL0 0
#define OCR1BL0_BIT 0
#define OCR1BL0_MASK 1
#define OCR1BL1 1
#define OCR1BL1_BIT 1
#define OCR1BL1_MASK 2
#define OCR1BL2 2
#define OCR1BL2_BIT 2
#define OCR1BL2_MASK 4
#define OCR1BL3 3
#define OCR1BL3_BIT 3
#define OCR1BL3_MASK 8
#define OCR1BL4 4
#define OCR1BL4_BIT 4
#define OCR1BL4_MASK 16
#define OCR1BL5 5
#define OCR1BL5_BIT 5
#define OCR1BL5_MASK 32
#define OCR1BL6 6
#define OCR1BL6_BIT 6
#define OCR1BL6_MASK 64
#define OCR1BL7 7
#define OCR1BL7_BIT 7
#define OCR1BL7_MASK 128

sfrw OCR1BW = 0x48;

sfrb ICR1H = 0x47;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x46;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x46;

sfrb TCCR2 = 0x45;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4

sfrb TCNT2 = 0x44;
#define TCNT2_0 0
#define TCNT2_0_BIT 0
#define TCNT2_0_MASK 1
#define TCNT2_1 1
#define TCNT2_1_BIT 1
#define TCNT2_1_MASK 2
#define TCNT2_2 2
#define TCNT2_2_BIT 2
#define TCNT2_2_MASK 4
#define TCNT2_3 3
#define TCNT2_3_BIT 3
#define TCNT2_3_MASK 8
#define TCNT2_4 4
#define TCNT2_4_BIT 4
#define TCNT2_4_MASK 16
#define TCNT2_5 5
#define TCNT2_5_BIT 5
#define TCNT2_5_MASK 32
#define TCNT2_6 6
#define TCNT2_6_BIT 6
#define TCNT2_6_MASK 64
#define TCNT2_7 7
#define TCNT2_7_BIT 7
#define TCNT2_7_MASK 128

sfrb PRELD2 = 0x43;
#define PRELD2_0 0
#define PRELD2_0_BIT 0
#define PRELD2_0_MASK 1
#define PRELD2_1 1
#define PRELD2_1_BIT 1
#define PRELD2_1_MASK 2
#define PRELD2_2 2
#define PRELD2_2_BIT 2
#define PRELD2_2_MASK 4
#define PRELD2_3 3
#define PRELD2_3_BIT 3
#define PRELD2_3_MASK 8
#define PRELD2_4 4
#define PRELD2_4_BIT 4
#define PRELD2_4_MASK 16
#define PRELD2_5 5
#define PRELD2_5_BIT 5
#define PRELD2_5_MASK 32
#define PRELD2_6 6
#define PRELD2_6_BIT 6
#define PRELD2_6_MASK 64
#define PRELD2_7 7
#define PRELD2_7_BIT 7
#define PRELD2_7_MASK 128

sfrb IRDACR = 0x42;
#define IRDAEN 0
#define IRDAEN_BIT 0
#define IRDAEN_MASK 1
#define USELUART 1
#define USELUART_BIT 1
#define USELUART_MASK 2
#define MODE 2
#define MODE_BIT 2
#define MODE_MASK 4
#define RXPOL 3
#define RXPOL_BIT 3
#define RXPOL_MASK 8
#define TXPOL 4
#define TXPOL_BIT 4
#define TXPOL_MASK 16

sfrb WDTCR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WTOE 4
#define WTOE_BIT 4
#define WTOE_MASK 16

sfrb PMOD = 0x3f;
#define PMOD0 0
#define PMOD0_BIT 0
#define PMOD0_MASK 1
#define PMOD1 1
#define PMOD1_BIT 1
#define PMOD1_MASK 2

sfrb EMICRB = 0x3d;
#define EMD1 0
#define EMD1_BIT 0
#define EMD1_MASK 1
#define EMD0 1
#define EMD0_BIT 1
#define EMD0_MASK 2
#define AM0 4
#define AM0_BIT 4
#define AM0_MASK 16
#define AM1 5
#define AM1_BIT 5
#define AM1_MASK 32
#define AW0 6
#define AW0_BIT 6
#define AW0_MASK 64
#define AW1 7
#define AW1_BIT 7
#define AW1_MASK 128

sfrb EMICRA = 0x3c;
#define WM0 0
#define WM0_BIT 0
#define WM0_MASK 1
#define WM1 1
#define WM1_BIT 1
#define WM1_MASK 2
#define WW0 2
#define WW0_BIT 2
#define WW0_MASK 4
#define WW1 3
#define WW1_BIT 3
#define WW1_MASK 8
#define RM0 4
#define RM0_BIT 4
#define RM0_MASK 16
#define RM1 5
#define RM1_BIT 5
#define RM1_MASK 32
#define RW0 6
#define RW0_BIT 6
#define RW0_MASK 64
#define RW1 7
#define RW1_BIT 7
#define RW1_MASK 128

sfrb PORTA = 0x3b;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8
#define PORTA4 4
#define PORTA4_BIT 4
#define PORTA4_MASK 16
#define PORTA5 5
#define PORTA5_BIT 5
#define PORTA5_MASK 32
#define PORTA6 6
#define PORTA6_BIT 6
#define PORTA6_MASK 64
#define PORTA7 7
#define PORTA7_BIT 7
#define PORTA7_MASK 128

sfrb DDRA = 0x3a;
#define DDRA0 0
#define DDRA0_BIT 0
#define DDRA0_MASK 1
#define DDRA1 1
#define DDRA1_BIT 1
#define DDRA1_MASK 2
#define DDRA2 2
#define DDRA2_BIT 2
#define DDRA2_MASK 4
#define DDRA3 3
#define DDRA3_BIT 3
#define DDRA3_MASK 8
#define DDRA4 4
#define DDRA4_BIT 4
#define DDRA4_MASK 16
#define DDRA5 5
#define DDRA5_BIT 5
#define DDRA5_MASK 32
#define DDRA6 6
#define DDRA6_BIT 6
#define DDRA6_MASK 64
#define DDRA7 7
#define DDRA7_BIT 7
#define DDRA7_MASK 128

sfrb PINA = 0x39;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8
#define PINA4 4
#define PINA4_BIT 4
#define PINA4_MASK 16
#define PINA5 5
#define PINA5_BIT 5
#define PINA5_MASK 32
#define PINA6 6
#define PINA6_BIT 6
#define PINA6_MASK 64
#define PINA7 7
#define PINA7_BIT 7
#define PINA7_MASK 128

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x37;
#define DDRB0 0
#define DDRB0_BIT 0
#define DDRB0_MASK 1
#define DDRB1 1
#define DDRB1_BIT 1
#define DDRB1_MASK 2
#define DDRB2 2
#define DDRB2_BIT 2
#define DDRB2_MASK 4
#define DDRB3 3
#define DDRB3_BIT 3
#define DDRB3_MASK 8
#define DDRB4 4
#define DDRB4_BIT 4
#define DDRB4_MASK 16
#define DDRB5 5
#define DDRB5_BIT 5
#define DDRB5_MASK 32
#define DDRB6 6
#define DDRB6_BIT 6
#define DDRB6_MASK 64
#define DDRB7 7
#define DDRB7_BIT 7
#define DDRB7_MASK 128

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb PORTC = 0x35;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1
#define PORTC1 1
#define PORTC1_BIT 1
#define PORTC1_MASK 2
#define PORTC2 2
#define PORTC2_BIT 2
#define PORTC2_MASK 4
#define PORTC3 3
#define PORTC3_BIT 3
#define PORTC3_MASK 8
#define PORTC4 4
#define PORTC4_BIT 4
#define PORTC4_MASK 16
#define PORTC5 5
#define PORTC5_BIT 5
#define PORTC5_MASK 32
#define PORTC6 6
#define PORTC6_BIT 6
#define PORTC6_MASK 64
#define PORTC7 7
#define PORTC7_BIT 7
#define PORTC7_MASK 128

sfrb DDRC = 0x34;
#define DDRC0 0
#define DDRC0_BIT 0
#define DDRC0_MASK 1
#define DDRC1 1
#define DDRC1_BIT 1
#define DDRC1_MASK 2
#define DDRC2 2
#define DDRC2_BIT 2
#define DDRC2_MASK 4
#define DDRC3 3
#define DDRC3_BIT 3
#define DDRC3_MASK 8
#define DDRC4 4
#define DDRC4_BIT 4
#define DDRC4_MASK 16
#define DDRC5 5
#define DDRC5_BIT 5
#define DDRC5_MASK 32
#define DDRC6 6
#define DDRC6_BIT 6
#define DDRC6_MASK 64
#define DDRC7 7
#define DDRC7_BIT 7
#define DDRC7_MASK 128

sfrb PINC = 0x33;
#define PINC0 0
#define PINC0_BIT 0
#define PINC0_MASK 1
#define PINC1 1
#define PINC1_BIT 1
#define PINC1_MASK 2
#define PINC2 2
#define PINC2_BIT 2
#define PINC2_MASK 4
#define PINC3 3
#define PINC3_BIT 3
#define PINC3_MASK 8
#define PINC4 4
#define PINC4_BIT 4
#define PINC4_MASK 16
#define PINC5 5
#define PINC5_BIT 5
#define PINC5_MASK 32
#define PINC6 6
#define PINC6_BIT 6
#define PINC6_MASK 64
#define PINC7 7
#define PINC7_BIT 7
#define PINC7_MASK 128

sfrb PORTD = 0x32;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x31;
#define DDRD0 0
#define DDRD0_BIT 0
#define DDRD0_MASK 1
#define DDRD1 1
#define DDRD1_BIT 1
#define DDRD1_MASK 2
#define DDRD2 2
#define DDRD2_BIT 2
#define DDRD2_MASK 4
#define DDRD3 3
#define DDRD3_BIT 3
#define DDRD3_MASK 8
#define DDRD4 4
#define DDRD4_BIT 4
#define DDRD4_MASK 16
#define DDRD5 5
#define DDRD5_BIT 5
#define DDRD5_MASK 32
#define DDRD6 6
#define DDRD6_BIT 6
#define DDRD6_MASK 64
#define DDRD7 7
#define DDRD7_BIT 7
#define DDRD7_MASK 128

sfrb PIND = 0x30;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb SPDR = 0x2f;
#define SPDR0 0
#define SPDR0_BIT 0
#define SPDR0_MASK 1
#define SPDR1 1
#define SPDR1_BIT 1
#define SPDR1_MASK 2
#define SPDR2 2
#define SPDR2_BIT 2
#define SPDR2_MASK 4
#define SPDR3 3
#define SPDR3_BIT 3
#define SPDR3_MASK 8
#define SPDR4 4
#define SPDR4_BIT 4
#define SPDR4_MASK 16
#define SPDR5 5
#define SPDR5_BIT 5
#define SPDR5_MASK 32
#define SPDR6 6
#define SPDR6_BIT 6
#define SPDR6_MASK 64
#define SPDR7 7
#define SPDR7_BIT 7
#define SPDR7_MASK 128

sfrb SPSR = 0x2e;
#define WCOL 6
#define WCOL_BIT 6
#define WCOL_MASK 64
#define SPIF 7
#define SPIF_BIT 7
#define SPIF_MASK 128

sfrb SPCR = 0x2d;
#define SPR0 0
#define SPR0_BIT 0
#define SPR0_MASK 1
#define SPR1 1
#define SPR1_BIT 1
#define SPR1_MASK 2
#define CPHA 2
#define CPHA_BIT 2
#define CPHA_MASK 4
#define CPOL 3
#define CPOL_BIT 3
#define CPOL_MASK 8
#define MSTR 4
#define MSTR_BIT 4
#define MSTR_MASK 16
#define DORD 5
#define DORD_BIT 5
#define DORD_MASK 32
#define SPE 6
#define SPE_BIT 6
#define SPE_MASK 64
#define SPIE 7
#define SPIE_BIT 7
#define SPIE_MASK 128

sfrb CLK_CNTR = 0x2c;
#define MCSP0 0
#define MCSP0_BIT 0
#define MCSP0_MASK 1
#define MCSP1 1
#define MCSP1_BIT 1
#define MCSP1_MASK 2
#define MUL16 2
#define MUL16_BIT 2
#define MUL16_MASK 4
#define PIVCO1 4
#define PIVCO1_BIT 4
#define PIVCO1_MASK 16
#define UDPLL 5
#define UDPLL_BIT 5
#define UDPLL_MASK 32
#define PLCK 6
#define PLCK_BIT 6
#define PLCK_MASK 64
#define NPICP 7
#define NPICP_BIT 7
#define NPICP_MASK 128

sfrb PERIPHEN = 0x2b;
#define EMIEN 0
#define EMIEN_BIT 0
#define EMIEN_MASK 1
#define USBEN 1
#define USBEN_BIT 1
#define USBEN_MASK 2
#define UATTACH 2
#define UATTACH_BIT 2
#define UATTACH_MASK 4
#define UART0EN 3
#define UART0EN_BIT 3
#define UART0EN_MASK 8
#define UART1EN 4
#define UART1EN_BIT 4
#define UART1EN_MASK 16
#define SPIEN 5
#define SPIEN_BIT 5
#define SPIEN_MASK 32

sfrb PORTE = 0x2a;
#define PORTE0 0
#define PORTE0_BIT 0
#define PORTE0_MASK 1
#define PORTE1 1
#define PORTE1_BIT 1
#define PORTE1_MASK 2
#define PORTE2 2
#define PORTE2_BIT 2
#define PORTE2_MASK 4
#define PORTE3 3
#define PORTE3_BIT 3
#define PORTE3_MASK 8
#define PORTE4 4
#define PORTE4_BIT 4
#define PORTE4_MASK 16
#define PORTE5 5
#define PORTE5_BIT 5
#define PORTE5_MASK 32
#define PORTE6 6
#define PORTE6_BIT 6
#define PORTE6_MASK 64
#define PORTE7 7
#define PORTE7_BIT 7
#define PORTE7_MASK 128

sfrb DDRE = 0x29;
#define DDRE0 0
#define DDRE0_BIT 0
#define DDRE0_MASK 1
#define DDRE1 1
#define DDRE1_BIT 1
#define DDRE1_MASK 2
#define DDRE2 2
#define DDRE2_BIT 2
#define DDRE2_MASK 4
#define DDRE3 3
#define DDRE3_BIT 3
#define DDRE3_MASK 8
#define DDRE4 4
#define DDRE4_BIT 4
#define DDRE4_MASK 16
#define DDRE5 5
#define DDRE5_BIT 5
#define DDRE5_MASK 32
#define DDRE6 6
#define DDRE6_BIT 6
#define DDRE6_MASK 64
#define DDRE7 7
#define DDRE7_BIT 7
#define DDRE7_MASK 128

sfrb PINE = 0x28;
#define PINE0 0
#define PINE0_BIT 0
#define PINE0_MASK 1
#define PINE1 1
#define PINE1_BIT 1
#define PINE1_MASK 2
#define PINE2 2
#define PINE2_BIT 2
#define PINE2_MASK 4
#define PINE3 3
#define PINE3_BIT 3
#define PINE3_MASK 8
#define PINE4 4
#define PINE4_BIT 4
#define PINE4_MASK 16
#define PINE5 5
#define PINE5_BIT 5
#define PINE5_MASK 32
#define PINE6 6
#define PINE6_BIT 6
#define PINE6_MASK 64
#define PINE7 7
#define PINE7_BIT 7
#define PINE7_MASK 128

#endif
