// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// CTL template file to implement the timer tick using the TIMER0 overflow.
//

#include <avr.h>
#include <ctl_api.h>

void start_timer()
{
  TIMSK = (1<<TOIE0); // Interrupt on timer0 overflow
  TCCR0 = (0<<WGM01)|(0<<WGM00)|(2<<CS00); // Normal operation (timer0 overflow is cleared on interrupt), divide prescaler by 8
}

void TIMER0_OVF_IRQ(void) __ctl_interrupt[TIMER0_OVF_vect]
{
  ctl_increment_tick_from_isr();
}

