// Implement enough of the TimerCounter0 to support interrupt on overflow
// The rest of IO space is implemented as RAM

peripherals = new Array(0x100);
var totalCycleCount;

function reset()
{
  totalCycleCount = 0;
  for (i=0; i<peripherals.length;i++)
    peripherals[i] = 0xcd;
  peripherals[0x52] = 0; // TCNT0
  peripherals[0x53] = 0; // TCCR0
  peripherals[0x57] = 0; // TIMSK
}

function pollForInterrupts(cycleCount)
{
  var TIMSK = peripherals[0x57];
  var TCCR0 = peripherals[0x53];
  var amount = 0;
  totalCycleCount += cycleCount
  switch (TCCR0 & 0x7)
    {
      case 0: // not enabled
        return 0;
      case 1:
        amount = 1;
        break;
      case 2:
        if ((totalCycleCount % 8) == 0)
          amount = 1;
        break;
      case 3:
        if ((totalCycleCount % 32) == 0)
          amount = 1;
        break;
      case 4:
        if ((totalCycleCount % 64) == 0)
          amount = 1;
        break;
      case 5:
        if ((totalCycleCount % 128) == 0)
          amount = 1;
        break;
      case 6:
        if ((totalCycleCount % 256) == 0)
          amount = 1;
        break;
      case 7:
        if ((totalCycleCount % 1024) == 0)
          amount = 1;
        break;
    }
  peripherals[0x52] += amount;
  if (peripherals[0x52] > 0xff)
    {
      peripherals[0x52] = 0;
      if (TIMSK & 1)
        return 17;
    }
  return 0;
}

function loadPeripheral(address)
{ 
  if (address >= 0x20 && address < 0x100)
    return peripherals[address];
  return 0xcd;
}

function storePeripheral(address, value)
{
  if (address >= 0x20 && address < 0x100)
    return peripherals[address]=value;   
}
