#ifndef __ATtiny22_h
#define __ATtiny22_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0002
#define TIMER0_OVF0_vect 0x0004

// I/O addresses


sfrb SREG = 0x5f;

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrb GIMSK = 0x5b;

sfrb GIFR = 0x5a;

sfrb TIMSK = 0x59;
#define TOIE0 1
#define TOIE0_BIT 1
#define TOIE0_MASK 2

sfrb TIFR = 0x58;
#define TOV0 1
#define TOV0_BIT 1
#define TOV0_MASK 2

sfrb MCUCR = 0x55;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define SM 4
#define SM_BIT 4
#define SM_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2

sfrb TCCR0 = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4

sfrb TCNT0 = 0x52;
#define TCNT00 0
#define TCNT00_BIT 0
#define TCNT00_MASK 1
#define TCNT01 1
#define TCNT01_BIT 1
#define TCNT01_MASK 2
#define TCNT02 2
#define TCNT02_BIT 2
#define TCNT02_MASK 4
#define TCNT03 3
#define TCNT03_BIT 3
#define TCNT03_MASK 8
#define TCNT04 4
#define TCNT04_BIT 4
#define TCNT04_MASK 16
#define TCNT05 5
#define TCNT05_BIT 5
#define TCNT05_MASK 32
#define TCNT06 6
#define TCNT06_BIT 6
#define TCNT06_MASK 64
#define TCNT07 7
#define TCNT07_BIT 7
#define TCNT07_MASK 128

sfrb WDTCR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDTOE 4
#define WDTOE_BIT 4
#define WDTOE_MASK 16

sfrb EEAR = 0x3e;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64
#define EEAR7 7
#define EEAR7_BIT 7
#define EEAR7_MASK 128

sfrb EEDR = 0x3d;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3c;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEWE 1
#define EEWE_BIT 1
#define EEWE_MASK 2
#define EEMWE 2
#define EEMWE_BIT 2
#define EEMWE_MASK 4

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16

sfrb DDRB = 0x37;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16

#endif
