#ifndef __ATmega406_h
#define __ATmega406_h

// Interrupt vectors

#define RESET_vect 0x0000
#define BPINT_vect 0x0004
#define INT0_vect 0x0008
#define INT1_vect 0x000c
#define INT2_vect 0x0010
#define INT3_vect 0x0014
#define PCINT0_vect 0x0018
#define PCINT1_vect 0x001c
#define WDT_vect 0x0020
#define WAKE_UP_vect 0x0024
#define TIM1_COMP_vect 0x0028
#define TIM1_OVF_vect 0x002c
#define TIM0_COMPA_vect 0x0030
#define TIM0_COMPB_vect 0x0034
#define TIM0_OVF_vect 0x0038
#define TWI_BUS_CD_vect 0x003c
#define TWI_vect 0x0040
#define VADC_vect 0x0044
#define CCADC_CONV_vect 0x0048
#define CCADC_REG_CUR_vect 0x004c
#define CCADC_ACC_vect 0x0050
#define EE_READY_vect 0x0054
#define SPM_READY_vect 0x0058

// I/O addresses


sfrb BPPLR = 0xf8;
#define BPPL 0
#define BPPL_BIT 0
#define BPPL_MASK 1
#define BPPLE 1
#define BPPLE_BIT 1
#define BPPLE_MASK 2

sfrb BPCR = 0xf7;
#define CCD 0
#define CCD_BIT 0
#define CCD_MASK 1
#define DCD 1
#define DCD_BIT 1
#define DCD_MASK 2
#define SCD 2
#define SCD_BIT 2
#define SCD_MASK 4
#define DUVD 3
#define DUVD_BIT 3
#define DUVD_MASK 8

sfrb CBPTR = 0xf6;
#define OCPT0 0
#define OCPT0_BIT 0
#define OCPT0_MASK 1
#define OCPT1 1
#define OCPT1_BIT 1
#define OCPT1_MASK 2
#define OCPT2 2
#define OCPT2_BIT 2
#define OCPT2_MASK 4
#define OCPT3 3
#define OCPT3_BIT 3
#define OCPT3_MASK 8
#define SCPT0 4
#define SCPT0_BIT 4
#define SCPT0_MASK 16
#define SCPT1 5
#define SCPT1_BIT 5
#define SCPT1_MASK 32
#define SCPT2 6
#define SCPT2_BIT 6
#define SCPT2_MASK 64
#define SCPT3 7
#define SCPT3_BIT 7
#define SCPT3_MASK 128

sfrb BPOCD = 0xf5;
#define CCDL0 0
#define CCDL0_BIT 0
#define CCDL0_MASK 1
#define CCDL1 1
#define CCDL1_BIT 1
#define CCDL1_MASK 2
#define CCDL2 2
#define CCDL2_BIT 2
#define CCDL2_MASK 4
#define CCDL3 3
#define CCDL3_BIT 3
#define CCDL3_MASK 8
#define DCDL0 4
#define DCDL0_BIT 4
#define DCDL0_MASK 16
#define DCDL1 5
#define DCDL1_BIT 5
#define DCDL1_MASK 32
#define DCDL2 6
#define DCDL2_BIT 6
#define DCDL2_MASK 64
#define DCDL3 7
#define DCDL3_BIT 7
#define DCDL3_MASK 128

sfrb BPSCD = 0xf4;
#define SCDL0 0
#define SCDL0_BIT 0
#define SCDL0_MASK 1
#define SCDL1 1
#define SCDL1_BIT 1
#define SCDL1_MASK 2
#define SCDL2 2
#define SCDL2_BIT 2
#define SCDL2_MASK 4
#define SCDL3 3
#define SCDL3_BIT 3
#define SCDL3_MASK 8

sfrb BPDUV = 0xf3;
#define DUDL0 0
#define DUDL0_BIT 0
#define DUDL0_MASK 1
#define DUDL1 1
#define DUDL1_BIT 1
#define DUDL1_MASK 2
#define DUDL2 2
#define DUDL2_BIT 2
#define DUDL2_MASK 4
#define DUDL3 3
#define DUDL3_BIT 3
#define DUDL3_MASK 8
#define DUVT0 4
#define DUVT0_BIT 4
#define DUVT0_MASK 16
#define DUVT1 5
#define DUVT1_BIT 5
#define DUVT1_MASK 32

sfrb BPIR = 0xf2;
#define SCIE 0
#define SCIE_BIT 0
#define SCIE_MASK 1
#define DOCIE 1
#define DOCIE_BIT 1
#define DOCIE_MASK 2
#define COCIE 2
#define COCIE_BIT 2
#define COCIE_MASK 4
#define DUVIE 3
#define DUVIE_BIT 3
#define DUVIE_MASK 8
#define SCIF 4
#define SCIF_BIT 4
#define SCIF_MASK 16
#define DOCIF 5
#define DOCIF_BIT 5
#define DOCIF_MASK 32
#define COCIF 6
#define COCIF_BIT 6
#define COCIF_MASK 64
#define DUVIF 7
#define DUVIF_BIT 7
#define DUVIF_MASK 128

sfrb CBCR = 0xf1;
#define CBE1 0
#define CBE1_BIT 0
#define CBE1_MASK 1
#define CBE2 1
#define CBE2_BIT 1
#define CBE2_MASK 2
#define CBE3 2
#define CBE3_BIT 2
#define CBE3_MASK 4
#define CBE4 3
#define CBE4_BIT 3
#define CBE4_MASK 8

sfrb FCSR = 0xf0;
#define PFD 0
#define PFD_BIT 0
#define PFD_MASK 1
#define CFE 1
#define CFE_BIT 1
#define CFE_MASK 2
#define DFE 2
#define DFE_BIT 2
#define DFE_MASK 4
#define CPS 3
#define CPS_BIT 3
#define CPS_MASK 8
#define PWMOPC 4
#define PWMOPC_BIT 4
#define PWMOPC_MASK 16
#define PWMOC 5
#define PWMOC_BIT 5
#define PWMOC_MASK 32

sfrb CADICH = 0xe9;
#define CADICH0 0
#define CADICH0_BIT 0
#define CADICH0_MASK 1
#define CADICH1 1
#define CADICH1_BIT 1
#define CADICH1_MASK 2
#define CADICH2 2
#define CADICH2_BIT 2
#define CADICH2_MASK 4
#define CADICH3 3
#define CADICH3_BIT 3
#define CADICH3_MASK 8
#define CADICH4 4
#define CADICH4_BIT 4
#define CADICH4_MASK 16
#define CADICH5 5
#define CADICH5_BIT 5
#define CADICH5_MASK 32
#define CADICH6 6
#define CADICH6_BIT 6
#define CADICH6_MASK 64
#define CADICH7 7
#define CADICH7_BIT 7
#define CADICH7_MASK 128

sfrb CADICL = 0xe8;
#define CADICL0 0
#define CADICL0_BIT 0
#define CADICL0_MASK 1
#define CADICL1 1
#define CADICL1_BIT 1
#define CADICL1_MASK 2
#define CADICL2 2
#define CADICL2_BIT 2
#define CADICL2_MASK 4
#define CADICL3 3
#define CADICL3_BIT 3
#define CADICL3_MASK 8
#define CADICL4 4
#define CADICL4_BIT 4
#define CADICL4_MASK 16
#define CADICL5 5
#define CADICL5_BIT 5
#define CADICL5_MASK 32
#define CADICL6 6
#define CADICL6_BIT 6
#define CADICL6_MASK 64
#define CADICL7 7
#define CADICL7_BIT 7
#define CADICL7_MASK 128

sfrw CADICW = 0xe8;

sfrb CADRDC = 0xe7;
#define CADRDC0 0
#define CADRDC0_BIT 0
#define CADRDC0_MASK 1
#define CADRDC1 1
#define CADRDC1_BIT 1
#define CADRDC1_MASK 2
#define CADRDC2 2
#define CADRDC2_BIT 2
#define CADRDC2_MASK 4
#define CADRDC3 3
#define CADRDC3_BIT 3
#define CADRDC3_MASK 8
#define CADRDC4 4
#define CADRDC4_BIT 4
#define CADRDC4_MASK 16
#define CADRDC5 5
#define CADRDC5_BIT 5
#define CADRDC5_MASK 32
#define CADRDC6 6
#define CADRDC6_BIT 6
#define CADRDC6_MASK 64
#define CADRDC7 7
#define CADRDC7_BIT 7
#define CADRDC7_MASK 128

sfrb CADRCC = 0xe6;
#define CADRCC0 0
#define CADRCC0_BIT 0
#define CADRCC0_MASK 1
#define CADRCC1 1
#define CADRCC1_BIT 1
#define CADRCC1_MASK 2
#define CADRCC2 2
#define CADRCC2_BIT 2
#define CADRCC2_MASK 4
#define CADRCC3 3
#define CADRCC3_BIT 3
#define CADRCC3_MASK 8
#define CADRCC4 4
#define CADRCC4_BIT 4
#define CADRCC4_MASK 16
#define CADRCC5 5
#define CADRCC5_BIT 5
#define CADRCC5_MASK 32
#define CADRCC6 6
#define CADRCC6_BIT 6
#define CADRCC6_MASK 64
#define CADRCC7 7
#define CADRCC7_BIT 7
#define CADRCC7_MASK 128

sfrb CADCSRB = 0xe5;
#define CADICIF 0
#define CADICIF_BIT 0
#define CADICIF_MASK 1
#define CADRCIF 1
#define CADRCIF_BIT 1
#define CADRCIF_MASK 2
#define CADACIF 2
#define CADACIF_BIT 2
#define CADACIF_MASK 4
#define CADICIE 4
#define CADICIE_BIT 4
#define CADICIE_MASK 16
#define CADRCIE 5
#define CADRCIE_BIT 5
#define CADRCIE_MASK 32
#define CADACIE 6
#define CADACIE_BIT 6
#define CADACIE_MASK 64

sfrb CADCSRA = 0xe4;
#define CADSE 0
#define CADSE_BIT 0
#define CADSE_MASK 1
#define CADSI0 1
#define CADSI0_BIT 1
#define CADSI0_MASK 2
#define CADSI1 2
#define CADSI1_BIT 2
#define CADSI1_MASK 4
#define CADAS0 3
#define CADAS0_BIT 3
#define CADAS0_MASK 8
#define CADAS1 4
#define CADAS1_BIT 4
#define CADAS1_MASK 16
#define CADUB 5
#define CADUB_BIT 5
#define CADUB_MASK 32
#define CADEN 7
#define CADEN_BIT 7
#define CADEN_MASK 128

sfrb CADAC3 = 0xe3;
#define CADAC24 0
#define CADAC24_BIT 0
#define CADAC24_MASK 1
#define CADAC25 1
#define CADAC25_BIT 1
#define CADAC25_MASK 2
#define CADAC26 2
#define CADAC26_BIT 2
#define CADAC26_MASK 4
#define CADAC27 3
#define CADAC27_BIT 3
#define CADAC27_MASK 8
#define CADAC28 4
#define CADAC28_BIT 4
#define CADAC28_MASK 16
#define CADAC29 5
#define CADAC29_BIT 5
#define CADAC29_MASK 32
#define CADAC30 6
#define CADAC30_BIT 6
#define CADAC30_MASK 64
#define CADAC31 7
#define CADAC31_BIT 7
#define CADAC31_MASK 128

sfrb CADAC2 = 0xe2;
#define CADAC16 0
#define CADAC16_BIT 0
#define CADAC16_MASK 1
#define CADAC17 1
#define CADAC17_BIT 1
#define CADAC17_MASK 2
#define CADAC18 2
#define CADAC18_BIT 2
#define CADAC18_MASK 4
#define CADAC19 3
#define CADAC19_BIT 3
#define CADAC19_MASK 8
#define CADAC20 4
#define CADAC20_BIT 4
#define CADAC20_MASK 16
#define CADAC21 5
#define CADAC21_BIT 5
#define CADAC21_MASK 32
#define CADAC22 6
#define CADAC22_BIT 6
#define CADAC22_MASK 64
#define CADAC23 7
#define CADAC23_BIT 7
#define CADAC23_MASK 128

sfrb CADAC1 = 0xe1;
#define CADAC08 0
#define CADAC08_BIT 0
#define CADAC08_MASK 1
#define CADAC09 1
#define CADAC09_BIT 1
#define CADAC09_MASK 2
#define CADAC10 2
#define CADAC10_BIT 2
#define CADAC10_MASK 4
#define CADAC11 3
#define CADAC11_BIT 3
#define CADAC11_MASK 8
#define CADAC12 4
#define CADAC12_BIT 4
#define CADAC12_MASK 16
#define CADAC13 5
#define CADAC13_BIT 5
#define CADAC13_MASK 32
#define CADAC14 6
#define CADAC14_BIT 6
#define CADAC14_MASK 64
#define CADAC15 7
#define CADAC15_BIT 7
#define CADAC15_MASK 128

sfrb CADAC0 = 0xe0;
#define CADAC00 0
#define CADAC00_BIT 0
#define CADAC00_MASK 1
#define CADAC01 1
#define CADAC01_BIT 1
#define CADAC01_MASK 2
#define CADAC02 2
#define CADAC02_BIT 2
#define CADAC02_MASK 4
#define CADAC03 3
#define CADAC03_BIT 3
#define CADAC03_MASK 8
#define CADAC04 4
#define CADAC04_BIT 4
#define CADAC04_MASK 16
#define CADAC05 5
#define CADAC05_BIT 5
#define CADAC05_MASK 32
#define CADAC06 6
#define CADAC06_BIT 6
#define CADAC06_MASK 64
#define CADAC07 7
#define CADAC07_BIT 7
#define CADAC07_MASK 128

sfrb BGCRR = 0xd1;
#define BGCR0 0
#define BGCR0_BIT 0
#define BGCR0_MASK 1
#define BGCR1 1
#define BGCR1_BIT 1
#define BGCR1_MASK 2
#define BGCR2 2
#define BGCR2_BIT 2
#define BGCR2_MASK 4
#define BGCR3 3
#define BGCR3_BIT 3
#define BGCR3_MASK 8
#define BGCR4 4
#define BGCR4_BIT 4
#define BGCR4_MASK 16
#define BGCR5 5
#define BGCR5_BIT 5
#define BGCR5_MASK 32
#define BGCR6 6
#define BGCR6_BIT 6
#define BGCR6_MASK 64
#define BGCR7 7
#define BGCR7_BIT 7
#define BGCR7_MASK 128

sfrb BGCCR = 0xd0;
#define BGCC0 0
#define BGCC0_BIT 0
#define BGCC0_MASK 1
#define BGCC1 1
#define BGCC1_BIT 1
#define BGCC1_MASK 2
#define BGCC2 2
#define BGCC2_BIT 2
#define BGCC2_MASK 4
#define BGCC3 3
#define BGCC3_BIT 3
#define BGCC3_MASK 8
#define BGCC4 4
#define BGCC4_BIT 4
#define BGCC4_MASK 16
#define BGCC5 5
#define BGCC5_BIT 5
#define BGCC5_MASK 32
#define BGEN 7
#define BGEN_BIT 7
#define BGEN_MASK 128

sfrb CCSR = 0xc0;
#define ACS 0
#define ACS_BIT 0
#define ACS_MASK 1
#define XOE 1
#define XOE_BIT 1
#define XOE_MASK 2

sfrb TWBCSR = 0xbe;
#define TWBCIP 0
#define TWBCIP_BIT 0
#define TWBCIP_MASK 1
#define TWBDT0 1
#define TWBDT0_BIT 1
#define TWBDT0_MASK 2
#define TWBDT1 2
#define TWBDT1_BIT 2
#define TWBDT1_MASK 4
#define TWBCIE 6
#define TWBCIE_BIT 6
#define TWBCIE_MASK 64
#define TWBCIF 7
#define TWBCIF_BIT 7
#define TWBCIF_MASK 128

sfrb TWAMR = 0xbd;
#define TWAM0 1
#define TWAM0_BIT 1
#define TWAM0_MASK 2
#define TWAM1 2
#define TWAM1_BIT 2
#define TWAM1_MASK 4
#define TWAM2 3
#define TWAM2_BIT 3
#define TWAM2_MASK 8
#define TWAM3 4
#define TWAM3_BIT 4
#define TWAM3_MASK 16
#define TWAM4 5
#define TWAM4_BIT 5
#define TWAM4_MASK 32
#define TWAM5 6
#define TWAM5_BIT 6
#define TWAM5_MASK 64
#define TWAM6 7
#define TWAM6_BIT 7
#define TWAM6_MASK 128

sfrb TWCR = 0xbc;
#define TWIE 0
#define TWIE_BIT 0
#define TWIE_MASK 1
#define TWEN 2
#define TWEN_BIT 2
#define TWEN_MASK 4
#define TWWC 3
#define TWWC_BIT 3
#define TWWC_MASK 8
#define TWSTO 4
#define TWSTO_BIT 4
#define TWSTO_MASK 16
#define TWSTA 5
#define TWSTA_BIT 5
#define TWSTA_MASK 32
#define TWEA 6
#define TWEA_BIT 6
#define TWEA_MASK 64
#define TWINT 7
#define TWINT_BIT 7
#define TWINT_MASK 128

sfrb TWDR = 0xbb;
#define TWD0 0
#define TWD0_BIT 0
#define TWD0_MASK 1
#define TWD1 1
#define TWD1_BIT 1
#define TWD1_MASK 2
#define TWD2 2
#define TWD2_BIT 2
#define TWD2_MASK 4
#define TWD3 3
#define TWD3_BIT 3
#define TWD3_MASK 8
#define TWD4 4
#define TWD4_BIT 4
#define TWD4_MASK 16
#define TWD5 5
#define TWD5_BIT 5
#define TWD5_MASK 32
#define TWD6 6
#define TWD6_BIT 6
#define TWD6_MASK 64
#define TWD7 7
#define TWD7_BIT 7
#define TWD7_MASK 128

sfrb TWAR = 0xba;
#define TWGCE 0
#define TWGCE_BIT 0
#define TWGCE_MASK 1
#define TWA0 1
#define TWA0_BIT 1
#define TWA0_MASK 2
#define TWA1 2
#define TWA1_BIT 2
#define TWA1_MASK 4
#define TWA2 3
#define TWA2_BIT 3
#define TWA2_MASK 8
#define TWA3 4
#define TWA3_BIT 4
#define TWA3_MASK 16
#define TWA4 5
#define TWA4_BIT 5
#define TWA4_MASK 32
#define TWA5 6
#define TWA5_BIT 6
#define TWA5_MASK 64
#define TWA6 7
#define TWA6_BIT 7
#define TWA6_MASK 128

sfrb TWSR = 0xb9;
#define TWPS0 0
#define TWPS0_BIT 0
#define TWPS0_MASK 1
#define TWPS1 1
#define TWPS1_BIT 1
#define TWPS1_MASK 2
#define TWS3 3
#define TWS3_BIT 3
#define TWS3_MASK 8
#define TWS4 4
#define TWS4_BIT 4
#define TWS4_MASK 16
#define TWS5 5
#define TWS5_BIT 5
#define TWS5_MASK 32
#define TWS6 6
#define TWS6_BIT 6
#define TWS6_MASK 64
#define TWS7 7
#define TWS7_BIT 7
#define TWS7_MASK 128

sfrb TWBR = 0xb8;
#define TWBR0 0
#define TWBR0_BIT 0
#define TWBR0_MASK 1
#define TWBR1 1
#define TWBR1_BIT 1
#define TWBR1_MASK 2
#define TWBR2 2
#define TWBR2_BIT 2
#define TWBR2_MASK 4
#define TWBR3 3
#define TWBR3_BIT 3
#define TWBR3_MASK 8
#define TWBR4 4
#define TWBR4_BIT 4
#define TWBR4_MASK 16
#define TWBR5 5
#define TWBR5_BIT 5
#define TWBR5_MASK 32
#define TWBR6 6
#define TWBR6_BIT 6
#define TWBR6_MASK 64
#define TWBR7 7
#define TWBR7_BIT 7
#define TWBR7_MASK 128

sfrb OCR1AH = 0x89;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1AL = 0x88;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1AW = 0x88;

sfrb TCNT1H = 0x85;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x84;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x84;

sfrb TCCR1B = 0x81;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define CTC1 3
#define CTC1_BIT 3
#define CTC1_MASK 8

sfrb DIDR0 = 0x7e;
#define VADC0D 0
#define VADC0D_BIT 0
#define VADC0D_MASK 1
#define VADC1D 1
#define VADC1D_BIT 1
#define VADC1D_MASK 2
#define VADC2D 2
#define VADC2D_BIT 2
#define VADC2D_MASK 4
#define VADC3D 3
#define VADC3D_BIT 3
#define VADC3D_MASK 8

sfrb VADMUX = 0x7c;
#define VADMUX0 0
#define VADMUX0_BIT 0
#define VADMUX0_MASK 1
#define VADMUX1 1
#define VADMUX1_BIT 1
#define VADMUX1_MASK 2
#define VADMUX2 2
#define VADMUX2_BIT 2
#define VADMUX2_MASK 4
#define VADMUX3 3
#define VADMUX3_BIT 3
#define VADMUX3_MASK 8

sfrb VADCSR = 0x7a;
#define VADCCIE 0
#define VADCCIE_BIT 0
#define VADCCIE_MASK 1
#define VADCCIF 1
#define VADCCIF_BIT 1
#define VADCCIF_MASK 2
#define VADSC 2
#define VADSC_BIT 2
#define VADSC_MASK 4
#define VADEN 3
#define VADEN_BIT 3
#define VADEN_MASK 8

sfrb VADCH = 0x79;
#define VADCH0 0
#define VADCH0_BIT 0
#define VADCH0_MASK 1
#define VADCH1 1
#define VADCH1_BIT 1
#define VADCH1_MASK 2
#define VADCH2 2
#define VADCH2_BIT 2
#define VADCH2_MASK 4
#define VADCH3 3
#define VADCH3_BIT 3
#define VADCH3_MASK 8

sfrb VADCL = 0x78;
#define VADCL0 0
#define VADCL0_BIT 0
#define VADCL0_MASK 1
#define VADCL1 1
#define VADCL1_BIT 1
#define VADCL1_MASK 2
#define VADCL2 2
#define VADCL2_BIT 2
#define VADCL2_MASK 4
#define VADCL3 3
#define VADCL3_BIT 3
#define VADCL3_MASK 8
#define VADCL4 4
#define VADCL4_BIT 4
#define VADCL4_MASK 16
#define VADCL5 5
#define VADCL5_BIT 5
#define VADCL5_MASK 32
#define VADCL6 6
#define VADCL6_BIT 6
#define VADCL6_MASK 64
#define VADCL7 7
#define VADCL7_BIT 7
#define VADCL7_MASK 128

sfrw VADCW = 0x78;

sfrb TIMSK1 = 0x6f;
#define TOIE1 0
#define TOIE1_BIT 0
#define TOIE1_MASK 1
#define OCIE1A 1
#define OCIE1A_BIT 1
#define OCIE1A_MASK 2

sfrb TIMSK0 = 0x6e;
#define TOIE0 0
#define TOIE0_BIT 0
#define TOIE0_MASK 1
#define OCIE0A 1
#define OCIE0A_BIT 1
#define OCIE0A_MASK 2
#define OCIE0B 2
#define OCIE0B_BIT 2
#define OCIE0B_MASK 4

sfrb PCMSK1 = 0x6c;
#define PCINT8 0
#define PCINT8_BIT 0
#define PCINT8_MASK 1
#define PCINT9 1
#define PCINT9_BIT 1
#define PCINT9_MASK 2
#define PCINT10 2
#define PCINT10_BIT 2
#define PCINT10_MASK 4
#define PCINT11 3
#define PCINT11_BIT 3
#define PCINT11_MASK 8
#define PCINT12 4
#define PCINT12_BIT 4
#define PCINT12_MASK 16
#define PCINT13 5
#define PCINT13_BIT 5
#define PCINT13_MASK 32
#define PCINT14 6
#define PCINT14_BIT 6
#define PCINT14_MASK 64
#define PCINT15 7
#define PCINT15_BIT 7
#define PCINT15_MASK 128

sfrb PCMSK0 = 0x6b;
#define PCINT0 0
#define PCINT0_BIT 0
#define PCINT0_MASK 1
#define PCINT1 1
#define PCINT1_BIT 1
#define PCINT1_MASK 2
#define PCINT2 2
#define PCINT2_BIT 2
#define PCINT2_MASK 4
#define PCINT3 3
#define PCINT3_BIT 3
#define PCINT3_MASK 8
#define PCINT4 4
#define PCINT4_BIT 4
#define PCINT4_MASK 16
#define PCINT5 5
#define PCINT5_BIT 5
#define PCINT5_MASK 32
#define PCINT6 6
#define PCINT6_BIT 6
#define PCINT6_MASK 64
#define PCINT7 7
#define PCINT7_BIT 7
#define PCINT7_MASK 128

sfrb EICRA = 0x69;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ISC10 2
#define ISC10_BIT 2
#define ISC10_MASK 4
#define ISC11 3
#define ISC11_BIT 3
#define ISC11_MASK 8
#define ISC20 4
#define ISC20_BIT 4
#define ISC20_MASK 16
#define ISC21 5
#define ISC21_BIT 5
#define ISC21_MASK 32
#define ISC30 6
#define ISC30_BIT 6
#define ISC30_MASK 64
#define ISC31 7
#define ISC31_BIT 7
#define ISC31_MASK 128

sfrb PCICR = 0x68;
#define PCIE0 0
#define PCIE0_BIT 0
#define PCIE0_MASK 1
#define PCIE1 1
#define PCIE1_BIT 1
#define PCIE1_MASK 2

sfrb FOSCCAL = 0x66;
#define FCAL0 0
#define FCAL0_BIT 0
#define FCAL0_MASK 1
#define FCAL1 1
#define FCAL1_BIT 1
#define FCAL1_MASK 2
#define FCAL2 2
#define FCAL2_BIT 2
#define FCAL2_MASK 4
#define FCAL3 3
#define FCAL3_BIT 3
#define FCAL3_MASK 8
#define FCAL4 4
#define FCAL4_BIT 4
#define FCAL4_MASK 16
#define FCAL5 5
#define FCAL5_BIT 5
#define FCAL5_MASK 32
#define FCAL6 6
#define FCAL6_BIT 6
#define FCAL6_MASK 64
#define FCAL7 7
#define FCAL7_BIT 7
#define FCAL7_MASK 128

sfrb PRR0 = 0x64;
#define PRVADC 0
#define PRVADC_BIT 0
#define PRVADC_MASK 1
#define PRTIM0 1
#define PRTIM0_BIT 1
#define PRTIM0_MASK 2
#define PRTIM1 2
#define PRTIM1_BIT 2
#define PRTIM1_MASK 4
#define PRTWI 3
#define PRTWI_BIT 3
#define PRTWI_MASK 8

sfrb WUTCSR = 0x62;
#define WUTP0 0
#define WUTP0_BIT 0
#define WUTP0_MASK 1
#define WUTP1 1
#define WUTP1_BIT 1
#define WUTP1_MASK 2
#define WUTP2 2
#define WUTP2_BIT 2
#define WUTP2_MASK 4
#define WUTE 3
#define WUTE_BIT 3
#define WUTE_MASK 8
#define WUTR 4
#define WUTR_BIT 4
#define WUTR_MASK 16
#define WUTCF 5
#define WUTCF_BIT 5
#define WUTCF_MASK 32
#define WUTIE 6
#define WUTIE_BIT 6
#define WUTIE_MASK 64
#define WUTIF 7
#define WUTIF_BIT 7
#define WUTIF_MASK 128

sfrb WDTCSR = 0x60;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDCE 4
#define WDCE_BIT 4
#define WDCE_MASK 16
#define WDP3 5
#define WDP3_BIT 5
#define WDP3_MASK 32
#define WDIE 6
#define WDIE_BIT 6
#define WDIE_MASK 64
#define WDIF 7
#define WDIF_BIT 7
#define WDIF_MASK 128

sfrb SREG = 0x5f;

sfrb SPH = 0x5e;
#define SP8 0
#define SP8_BIT 0
#define SP8_MASK 1
#define SP9 1
#define SP9_BIT 1
#define SP9_MASK 2
#define SP10 2
#define SP10_BIT 2
#define SP10_MASK 4
#define SP11 3
#define SP11_BIT 3
#define SP11_MASK 8
#define SP12 4
#define SP12_BIT 4
#define SP12_MASK 16
#define SP13 5
#define SP13_BIT 5
#define SP13_MASK 32
#define SP14 6
#define SP14_BIT 6
#define SP14_MASK 64
#define SP15 7
#define SP15_BIT 7
#define SP15_MASK 128

sfrb SPL = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrw SPW = 0x5d;

sfrb SPMCSR = 0x57;
#define SPMEN 0
#define SPMEN_BIT 0
#define SPMEN_MASK 1
#define PGERS 1
#define PGERS_BIT 1
#define PGERS_MASK 2
#define PGWRT 2
#define PGWRT_BIT 2
#define PGWRT_MASK 4
#define BLBSET 3
#define BLBSET_BIT 3
#define BLBSET_MASK 8
#define RWWSRE 4
#define RWWSRE_BIT 4
#define RWWSRE_MASK 16
#define SIGRD 5
#define SIGRD_BIT 5
#define SIGRD_MASK 32
#define RWWSB 6
#define RWWSB_BIT 6
#define RWWSB_MASK 64
#define SPMIE 7
#define SPMIE_BIT 7
#define SPMIE_MASK 128

sfrb MCUCR = 0x55;
#define IVCE 0
#define IVCE_BIT 0
#define IVCE_MASK 1
#define IVSEL 1
#define IVSEL_BIT 1
#define IVSEL_MASK 2
#define PUD 4
#define PUD_BIT 4
#define PUD_MASK 16
#define JTD 7
#define JTD_BIT 7
#define JTD_MASK 128

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BODRF 2
#define BODRF_BIT 2
#define BODRF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8
#define JTRF 4
#define JTRF_BIT 4
#define JTRF_MASK 16

sfrb SMCR = 0x53;
#define SE 0
#define SE_BIT 0
#define SE_MASK 1
#define SM0 1
#define SM0_BIT 1
#define SM0_MASK 2
#define SM1 2
#define SM1_BIT 2
#define SM1_MASK 4
#define SM2 3
#define SM2_BIT 3
#define SM2_MASK 8

sfrb OCDR = 0x51;

sfrb GPIOR2 = 0x4b;
#define GPIOR20 0
#define GPIOR20_BIT 0
#define GPIOR20_MASK 1
#define GPIOR21 1
#define GPIOR21_BIT 1
#define GPIOR21_MASK 2
#define GPIOR22 2
#define GPIOR22_BIT 2
#define GPIOR22_MASK 4
#define GPIOR23 3
#define GPIOR23_BIT 3
#define GPIOR23_MASK 8
#define GPIOR24 4
#define GPIOR24_BIT 4
#define GPIOR24_MASK 16
#define GPIOR25 5
#define GPIOR25_BIT 5
#define GPIOR25_MASK 32
#define GPIOR26 6
#define GPIOR26_BIT 6
#define GPIOR26_MASK 64
#define GPIOR27 7
#define GPIOR27_BIT 7
#define GPIOR27_MASK 128

sfrb GPIOR1 = 0x4a;
#define GPIOR10 0
#define GPIOR10_BIT 0
#define GPIOR10_MASK 1
#define GPIOR11 1
#define GPIOR11_BIT 1
#define GPIOR11_MASK 2
#define GPIOR12 2
#define GPIOR12_BIT 2
#define GPIOR12_MASK 4
#define GPIOR13 3
#define GPIOR13_BIT 3
#define GPIOR13_MASK 8
#define GPIOR14 4
#define GPIOR14_BIT 4
#define GPIOR14_MASK 16
#define GPIOR15 5
#define GPIOR15_BIT 5
#define GPIOR15_MASK 32
#define GPIOR16 6
#define GPIOR16_BIT 6
#define GPIOR16_MASK 64
#define GPIOR17 7
#define GPIOR17_BIT 7
#define GPIOR17_MASK 128

sfrb OCR0B = 0x48;
#define OCR0B0 0
#define OCR0B0_BIT 0
#define OCR0B0_MASK 1
#define OCR0B1 1
#define OCR0B1_BIT 1
#define OCR0B1_MASK 2
#define OCR0B2 2
#define OCR0B2_BIT 2
#define OCR0B2_MASK 4
#define OCR0B3 3
#define OCR0B3_BIT 3
#define OCR0B3_MASK 8
#define OCR0B4 4
#define OCR0B4_BIT 4
#define OCR0B4_MASK 16
#define OCR0B5 5
#define OCR0B5_BIT 5
#define OCR0B5_MASK 32
#define OCR0B6 6
#define OCR0B6_BIT 6
#define OCR0B6_MASK 64
#define OCR0B7 7
#define OCR0B7_BIT 7
#define OCR0B7_MASK 128

sfrb OCR0A = 0x47;
#define OCR0A0 0
#define OCR0A0_BIT 0
#define OCR0A0_MASK 1
#define OCR0A1 1
#define OCR0A1_BIT 1
#define OCR0A1_MASK 2
#define OCR0A2 2
#define OCR0A2_BIT 2
#define OCR0A2_MASK 4
#define OCR0A3 3
#define OCR0A3_BIT 3
#define OCR0A3_MASK 8
#define OCR0A4 4
#define OCR0A4_BIT 4
#define OCR0A4_MASK 16
#define OCR0A5 5
#define OCR0A5_BIT 5
#define OCR0A5_MASK 32
#define OCR0A6 6
#define OCR0A6_BIT 6
#define OCR0A6_MASK 64
#define OCR0A7 7
#define OCR0A7_BIT 7
#define OCR0A7_MASK 128

sfrb TCNT0 = 0x46;
#define TCNT00 0
#define TCNT00_BIT 0
#define TCNT00_MASK 1
#define TCNT01 1
#define TCNT01_BIT 1
#define TCNT01_MASK 2
#define TCNT02 2
#define TCNT02_BIT 2
#define TCNT02_MASK 4
#define TCNT03 3
#define TCNT03_BIT 3
#define TCNT03_MASK 8
#define TCNT04 4
#define TCNT04_BIT 4
#define TCNT04_MASK 16
#define TCNT05 5
#define TCNT05_BIT 5
#define TCNT05_MASK 32
#define TCNT06 6
#define TCNT06_BIT 6
#define TCNT06_MASK 64
#define TCNT07 7
#define TCNT07_BIT 7
#define TCNT07_MASK 128

sfrb TCCR0B = 0x45;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4
#define WGM02 3
#define WGM02_BIT 3
#define WGM02_MASK 8
#define FOC0B 6
#define FOC0B_BIT 6
#define FOC0B_MASK 64
#define FOC0A 7
#define FOC0A_BIT 7
#define FOC0A_MASK 128

sfrb TCCR0A = 0x44;
#define WGM00 0
#define WGM00_BIT 0
#define WGM00_MASK 1
#define WGM01 1
#define WGM01_BIT 1
#define WGM01_MASK 2
#define COM0B0 4
#define COM0B0_BIT 4
#define COM0B0_MASK 16
#define COM0B1 5
#define COM0B1_BIT 5
#define COM0B1_MASK 32
#define COM0A0 6
#define COM0A0_BIT 6
#define COM0A0_MASK 64
#define COM0A1 7
#define COM0A1_BIT 7
#define COM0A1_MASK 128

sfrb GTCCR = 0x43;
#define PSRSYNC 0
#define PSRSYNC_BIT 0
#define PSRSYNC_MASK 1
#define PSRASY 1
#define PSRASY_BIT 1
#define PSRASY_MASK 2
#define TSM 7
#define TSM_BIT 7
#define TSM_MASK 128

sfrb EEARH = 0x42;
#define EEAR8 0
#define EEAR8_BIT 0
#define EEAR8_MASK 1

sfrb EEARL = 0x41;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64
#define EEAR7 7
#define EEAR7_BIT 7
#define EEAR7_MASK 128

sfrw EEARW = 0x41;

sfrb EEDR = 0x40;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3f;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEWE 1
#define EEWE_BIT 1
#define EEWE_MASK 2
#define EEMWE 2
#define EEMWE_BIT 2
#define EEMWE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8
#define EEPM0 4
#define EEPM0_BIT 4
#define EEPM0_MASK 16
#define EEPM1 5
#define EEPM1_BIT 5
#define EEPM1_MASK 32

sfrb GPIOR0 = 0x3e;
#define GPIOR00 0
#define GPIOR00_BIT 0
#define GPIOR00_MASK 1
#define GPIOR01 1
#define GPIOR01_BIT 1
#define GPIOR01_MASK 2
#define GPIOR02 2
#define GPIOR02_BIT 2
#define GPIOR02_MASK 4
#define GPIOR03 3
#define GPIOR03_BIT 3
#define GPIOR03_MASK 8
#define GPIOR04 4
#define GPIOR04_BIT 4
#define GPIOR04_MASK 16
#define GPIOR05 5
#define GPIOR05_BIT 5
#define GPIOR05_MASK 32
#define GPIOR06 6
#define GPIOR06_BIT 6
#define GPIOR06_MASK 64
#define GPIOR07 7
#define GPIOR07_BIT 7
#define GPIOR07_MASK 128

sfrb EIMSK = 0x3d;
#define INT0 0
#define INT0_BIT 0
#define INT0_MASK 1
#define INT1 1
#define INT1_BIT 1
#define INT1_MASK 2
#define INT2 2
#define INT2_BIT 2
#define INT2_MASK 4
#define INT3 3
#define INT3_BIT 3
#define INT3_MASK 8

sfrb EIFR = 0x3c;
#define INTF0 0
#define INTF0_BIT 0
#define INTF0_MASK 1
#define INTF1 1
#define INTF1_BIT 1
#define INTF1_MASK 2
#define INTF2 2
#define INTF2_BIT 2
#define INTF2_MASK 4
#define INTF3 3
#define INTF3_BIT 3
#define INTF3_MASK 8

sfrb PCIFR = 0x3b;
#define PCIF0 0
#define PCIF0_BIT 0
#define PCIF0_MASK 1
#define PCIF1 1
#define PCIF1_BIT 1
#define PCIF1_MASK 2

sfrb TIFR1 = 0x36;
#define TOV1 0
#define TOV1_BIT 0
#define TOV1_MASK 1
#define OCF1A 1
#define OCF1A_BIT 1
#define OCF1A_MASK 2

sfrb TIFR0 = 0x35;
#define TOV0 0
#define TOV0_BIT 0
#define TOV0_MASK 1
#define OCF0A 1
#define OCF0A_BIT 1
#define OCF0A_MASK 2
#define OCF0B 2
#define OCF0B_BIT 2
#define OCF0B_MASK 4

sfrb PORTD = 0x2b;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2

sfrb DDRD = 0x2a;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2

sfrb PIND = 0x29;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2

sfrb PORTC = 0x28;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1

sfrb PORTB = 0x25;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32
#define PORTB6 6
#define PORTB6_BIT 6
#define PORTB6_MASK 64
#define PORTB7 7
#define PORTB7_BIT 7
#define PORTB7_MASK 128

sfrb DDRB = 0x24;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32
#define DDB6 6
#define DDB6_BIT 6
#define DDB6_MASK 64
#define DDB7 7
#define DDB7_BIT 7
#define DDB7_MASK 128

sfrb PINB = 0x23;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32
#define PINB6 6
#define PINB6_BIT 6
#define PINB6_MASK 64
#define PINB7 7
#define PINB7_BIT 7
#define PINB7_MASK 128

sfrb PORTA = 0x22;
#define PORTA0 0
#define PORTA0_BIT 0
#define PORTA0_MASK 1
#define PORTA1 1
#define PORTA1_BIT 1
#define PORTA1_MASK 2
#define PORTA2 2
#define PORTA2_BIT 2
#define PORTA2_MASK 4
#define PORTA3 3
#define PORTA3_BIT 3
#define PORTA3_MASK 8
#define PORTA4 4
#define PORTA4_BIT 4
#define PORTA4_MASK 16
#define PORTA5 5
#define PORTA5_BIT 5
#define PORTA5_MASK 32
#define PORTA6 6
#define PORTA6_BIT 6
#define PORTA6_MASK 64
#define PORTA7 7
#define PORTA7_BIT 7
#define PORTA7_MASK 128

sfrb DDRA = 0x21;
#define DDA0 0
#define DDA0_BIT 0
#define DDA0_MASK 1
#define DDA1 1
#define DDA1_BIT 1
#define DDA1_MASK 2
#define DDA2 2
#define DDA2_BIT 2
#define DDA2_MASK 4
#define DDA3 3
#define DDA3_BIT 3
#define DDA3_MASK 8
#define DDA4 4
#define DDA4_BIT 4
#define DDA4_MASK 16
#define DDA5 5
#define DDA5_BIT 5
#define DDA5_MASK 32
#define DDA6 6
#define DDA6_BIT 6
#define DDA6_MASK 64
#define DDA7 7
#define DDA7_BIT 7
#define DDA7_MASK 128

sfrb PINA = 0x20;
#define PINA0 0
#define PINA0_BIT 0
#define PINA0_MASK 1
#define PINA1 1
#define PINA1_BIT 1
#define PINA1_MASK 2
#define PINA2 2
#define PINA2_BIT 2
#define PINA2_MASK 4
#define PINA3 3
#define PINA3_BIT 3
#define PINA3_MASK 8
#define PINA4 4
#define PINA4_BIT 4
#define PINA4_MASK 16
#define PINA5 5
#define PINA5_BIT 5
#define PINA5_MASK 32
#define PINA6 6
#define PINA6_BIT 6
#define PINA6_MASK 64
#define PINA7 7
#define PINA7_BIT 7
#define PINA7_MASK 128

#endif
