#ifndef __AT90S4433_h
#define __AT90S4433_h

// Interrupt vectors

#define RESET_vect 0x0000
#define INT0_vect 0x0002
#define INT1_vect 0x0004
#define TIMER1_CAPT_vect 0x0006
#define TIMER1_COMP_vect 0x0008
#define TIMER1_OVF_vect 0x000a
#define TIMER0_OVF_vect 0x000c
#define SPISTC_vect 0x000e
#define UARTRX_vect 0x0010
#define UARTUDRE_vect 0x0012
#define UART_TX_vect 0x0014
#define ADC_vect 0x0016
#define EE_RDY_vect 0x0018
#define ANA_COMP_vect 0x001a

// I/O addresses


sfrb SREG = 0x5f;

sfrb SP = 0x5d;
#define SP0 0
#define SP0_BIT 0
#define SP0_MASK 1
#define SP1 1
#define SP1_BIT 1
#define SP1_MASK 2
#define SP2 2
#define SP2_BIT 2
#define SP2_MASK 4
#define SP3 3
#define SP3_BIT 3
#define SP3_MASK 8
#define SP4 4
#define SP4_BIT 4
#define SP4_MASK 16
#define SP5 5
#define SP5_BIT 5
#define SP5_MASK 32
#define SP6 6
#define SP6_BIT 6
#define SP6_MASK 64
#define SP7 7
#define SP7_BIT 7
#define SP7_MASK 128

sfrb GIMSK = 0x5b;
#define INT0 6
#define INT0_BIT 6
#define INT0_MASK 64
#define INT1 7
#define INT1_BIT 7
#define INT1_MASK 128

sfrb GIFR = 0x5a;
#define INTF0 6
#define INTF0_BIT 6
#define INTF0_MASK 64
#define INTF1 7
#define INTF1_BIT 7
#define INTF1_MASK 128

sfrb TIMSK = 0x59;
#define TOIE0 1
#define TOIE0_BIT 1
#define TOIE0_MASK 2
#define TICIE1 3
#define TICIE1_BIT 3
#define TICIE1_MASK 8
#define OCIE1 6
#define OCIE1_BIT 6
#define OCIE1_MASK 64
#define TOIE1 7
#define TOIE1_BIT 7
#define TOIE1_MASK 128

sfrb TIFR = 0x58;
#define TOV0 1
#define TOV0_BIT 1
#define TOV0_MASK 2
#define ICF1 3
#define ICF1_BIT 3
#define ICF1_MASK 8
#define OCF1 6
#define OCF1_BIT 6
#define OCF1_MASK 64
#define TOV1 7
#define TOV1_BIT 7
#define TOV1_MASK 128

sfrb MCUCR = 0x55;
#define ISC00 0
#define ISC00_BIT 0
#define ISC00_MASK 1
#define ISC01 1
#define ISC01_BIT 1
#define ISC01_MASK 2
#define ISC10 2
#define ISC10_BIT 2
#define ISC10_MASK 4
#define ISC11 3
#define ISC11_BIT 3
#define ISC11_MASK 8
#define SM 4
#define SM_BIT 4
#define SM_MASK 16
#define SE 5
#define SE_BIT 5
#define SE_MASK 32

sfrb MCUSR = 0x54;
#define PORF 0
#define PORF_BIT 0
#define PORF_MASK 1
#define EXTRF 1
#define EXTRF_BIT 1
#define EXTRF_MASK 2
#define BORF 2
#define BORF_BIT 2
#define BORF_MASK 4
#define WDRF 3
#define WDRF_BIT 3
#define WDRF_MASK 8

sfrb TCCR0 = 0x53;
#define CS00 0
#define CS00_BIT 0
#define CS00_MASK 1
#define CS01 1
#define CS01_BIT 1
#define CS01_MASK 2
#define CS02 2
#define CS02_BIT 2
#define CS02_MASK 4

sfrb TCNT0 = 0x52;
#define TCNT00 0
#define TCNT00_BIT 0
#define TCNT00_MASK 1
#define TCNT01 1
#define TCNT01_BIT 1
#define TCNT01_MASK 2
#define TCNT02 2
#define TCNT02_BIT 2
#define TCNT02_MASK 4
#define TCNT03 3
#define TCNT03_BIT 3
#define TCNT03_MASK 8
#define TCNT04 4
#define TCNT04_BIT 4
#define TCNT04_MASK 16
#define TCNT05 5
#define TCNT05_BIT 5
#define TCNT05_MASK 32
#define TCNT06 6
#define TCNT06_BIT 6
#define TCNT06_MASK 64
#define TCNT07 7
#define TCNT07_BIT 7
#define TCNT07_MASK 128

sfrb TCCR1A = 0x4f;
#define PWM10 0
#define PWM10_BIT 0
#define PWM10_MASK 1
#define PWM11 1
#define PWM11_BIT 1
#define PWM11_MASK 2
#define COM10 6
#define COM10_BIT 6
#define COM10_MASK 64
#define COM11 7
#define COM11_BIT 7
#define COM11_MASK 128

sfrb TCCR1B = 0x4e;
#define CS10 0
#define CS10_BIT 0
#define CS10_MASK 1
#define CS11 1
#define CS11_BIT 1
#define CS11_MASK 2
#define CS12 2
#define CS12_BIT 2
#define CS12_MASK 4
#define CTC1 3
#define CTC1_BIT 3
#define CTC1_MASK 8
#define ICES1 6
#define ICES1_BIT 6
#define ICES1_MASK 64
#define ICNC1 7
#define ICNC1_BIT 7
#define ICNC1_MASK 128

sfrb TCNT1H = 0x4d;
#define TCNT1H0 0
#define TCNT1H0_BIT 0
#define TCNT1H0_MASK 1
#define TCNT1H1 1
#define TCNT1H1_BIT 1
#define TCNT1H1_MASK 2
#define TCNT1H2 2
#define TCNT1H2_BIT 2
#define TCNT1H2_MASK 4
#define TCNT1H3 3
#define TCNT1H3_BIT 3
#define TCNT1H3_MASK 8
#define TCNT1H4 4
#define TCNT1H4_BIT 4
#define TCNT1H4_MASK 16
#define TCNT1H5 5
#define TCNT1H5_BIT 5
#define TCNT1H5_MASK 32
#define TCNT1H6 6
#define TCNT1H6_BIT 6
#define TCNT1H6_MASK 64
#define TCNT1H7 7
#define TCNT1H7_BIT 7
#define TCNT1H7_MASK 128

sfrb TCNT1L = 0x4c;
#define TCNT1L0 0
#define TCNT1L0_BIT 0
#define TCNT1L0_MASK 1
#define TCNT1L1 1
#define TCNT1L1_BIT 1
#define TCNT1L1_MASK 2
#define TCNT1L2 2
#define TCNT1L2_BIT 2
#define TCNT1L2_MASK 4
#define TCNT1L3 3
#define TCNT1L3_BIT 3
#define TCNT1L3_MASK 8
#define TCNT1L4 4
#define TCNT1L4_BIT 4
#define TCNT1L4_MASK 16
#define TCNT1L5 5
#define TCNT1L5_BIT 5
#define TCNT1L5_MASK 32
#define TCNT1L6 6
#define TCNT1L6_BIT 6
#define TCNT1L6_MASK 64
#define TCNT1L7 7
#define TCNT1L7_BIT 7
#define TCNT1L7_MASK 128

sfrw TCNT1W = 0x4c;

sfrb OCR1H = 0x4b;
#define OCR1AH0 0
#define OCR1AH0_BIT 0
#define OCR1AH0_MASK 1
#define OCR1AH1 1
#define OCR1AH1_BIT 1
#define OCR1AH1_MASK 2
#define OCR1AH2 2
#define OCR1AH2_BIT 2
#define OCR1AH2_MASK 4
#define OCR1AH3 3
#define OCR1AH3_BIT 3
#define OCR1AH3_MASK 8
#define OCR1AH4 4
#define OCR1AH4_BIT 4
#define OCR1AH4_MASK 16
#define OCR1AH5 5
#define OCR1AH5_BIT 5
#define OCR1AH5_MASK 32
#define OCR1AH6 6
#define OCR1AH6_BIT 6
#define OCR1AH6_MASK 64
#define OCR1AH7 7
#define OCR1AH7_BIT 7
#define OCR1AH7_MASK 128

sfrb OCR1L = 0x4a;
#define OCR1AL0 0
#define OCR1AL0_BIT 0
#define OCR1AL0_MASK 1
#define OCR1AL1 1
#define OCR1AL1_BIT 1
#define OCR1AL1_MASK 2
#define OCR1AL2 2
#define OCR1AL2_BIT 2
#define OCR1AL2_MASK 4
#define OCR1AL3 3
#define OCR1AL3_BIT 3
#define OCR1AL3_MASK 8
#define OCR1AL4 4
#define OCR1AL4_BIT 4
#define OCR1AL4_MASK 16
#define OCR1AL5 5
#define OCR1AL5_BIT 5
#define OCR1AL5_MASK 32
#define OCR1AL6 6
#define OCR1AL6_BIT 6
#define OCR1AL6_MASK 64
#define OCR1AL7 7
#define OCR1AL7_BIT 7
#define OCR1AL7_MASK 128

sfrw OCR1W = 0x4a;

sfrb ICR1H = 0x47;
#define ICR1H0 0
#define ICR1H0_BIT 0
#define ICR1H0_MASK 1
#define ICR1H1 1
#define ICR1H1_BIT 1
#define ICR1H1_MASK 2
#define ICR1H2 2
#define ICR1H2_BIT 2
#define ICR1H2_MASK 4
#define ICR1H3 3
#define ICR1H3_BIT 3
#define ICR1H3_MASK 8
#define ICR1H4 4
#define ICR1H4_BIT 4
#define ICR1H4_MASK 16
#define ICR1H5 5
#define ICR1H5_BIT 5
#define ICR1H5_MASK 32
#define ICR1H6 6
#define ICR1H6_BIT 6
#define ICR1H6_MASK 64
#define ICR1H7 7
#define ICR1H7_BIT 7
#define ICR1H7_MASK 128

sfrb ICR1L = 0x46;
#define ICR1L0 0
#define ICR1L0_BIT 0
#define ICR1L0_MASK 1
#define ICR1L1 1
#define ICR1L1_BIT 1
#define ICR1L1_MASK 2
#define ICR1L2 2
#define ICR1L2_BIT 2
#define ICR1L2_MASK 4
#define ICR1L3 3
#define ICR1L3_BIT 3
#define ICR1L3_MASK 8
#define ICR1L4 4
#define ICR1L4_BIT 4
#define ICR1L4_MASK 16
#define ICR1L5 5
#define ICR1L5_BIT 5
#define ICR1L5_MASK 32
#define ICR1L6 6
#define ICR1L6_BIT 6
#define ICR1L6_MASK 64
#define ICR1L7 7
#define ICR1L7_BIT 7
#define ICR1L7_MASK 128

sfrw ICR1W = 0x46;

sfrb WDTCR = 0x41;
#define WDP0 0
#define WDP0_BIT 0
#define WDP0_MASK 1
#define WDP1 1
#define WDP1_BIT 1
#define WDP1_MASK 2
#define WDP2 2
#define WDP2_BIT 2
#define WDP2_MASK 4
#define WDE 3
#define WDE_BIT 3
#define WDE_MASK 8
#define WDTOE 4
#define WDTOE_BIT 4
#define WDTOE_MASK 16

sfrb EEAR = 0x3e;
#define EEAR0 0
#define EEAR0_BIT 0
#define EEAR0_MASK 1
#define EEAR1 1
#define EEAR1_BIT 1
#define EEAR1_MASK 2
#define EEAR2 2
#define EEAR2_BIT 2
#define EEAR2_MASK 4
#define EEAR3 3
#define EEAR3_BIT 3
#define EEAR3_MASK 8
#define EEAR4 4
#define EEAR4_BIT 4
#define EEAR4_MASK 16
#define EEAR5 5
#define EEAR5_BIT 5
#define EEAR5_MASK 32
#define EEAR6 6
#define EEAR6_BIT 6
#define EEAR6_MASK 64
#define EEAR7 7
#define EEAR7_BIT 7
#define EEAR7_MASK 128

sfrb EEDR = 0x3d;
#define EEDR0 0
#define EEDR0_BIT 0
#define EEDR0_MASK 1
#define EEDR1 1
#define EEDR1_BIT 1
#define EEDR1_MASK 2
#define EEDR2 2
#define EEDR2_BIT 2
#define EEDR2_MASK 4
#define EEDR3 3
#define EEDR3_BIT 3
#define EEDR3_MASK 8
#define EEDR4 4
#define EEDR4_BIT 4
#define EEDR4_MASK 16
#define EEDR5 5
#define EEDR5_BIT 5
#define EEDR5_MASK 32
#define EEDR6 6
#define EEDR6_BIT 6
#define EEDR6_MASK 64
#define EEDR7 7
#define EEDR7_BIT 7
#define EEDR7_MASK 128

sfrb EECR = 0x3c;
#define EERE 0
#define EERE_BIT 0
#define EERE_MASK 1
#define EEWE 1
#define EEWE_BIT 1
#define EEWE_MASK 2
#define EEMWE 2
#define EEMWE_BIT 2
#define EEMWE_MASK 4
#define EERIE 3
#define EERIE_BIT 3
#define EERIE_MASK 8

sfrb PORTB = 0x38;
#define PORTB0 0
#define PORTB0_BIT 0
#define PORTB0_MASK 1
#define PORTB1 1
#define PORTB1_BIT 1
#define PORTB1_MASK 2
#define PORTB2 2
#define PORTB2_BIT 2
#define PORTB2_MASK 4
#define PORTB3 3
#define PORTB3_BIT 3
#define PORTB3_MASK 8
#define PORTB4 4
#define PORTB4_BIT 4
#define PORTB4_MASK 16
#define PORTB5 5
#define PORTB5_BIT 5
#define PORTB5_MASK 32

sfrb DDRB = 0x37;
#define DDB0 0
#define DDB0_BIT 0
#define DDB0_MASK 1
#define DDB1 1
#define DDB1_BIT 1
#define DDB1_MASK 2
#define DDB2 2
#define DDB2_BIT 2
#define DDB2_MASK 4
#define DDB3 3
#define DDB3_BIT 3
#define DDB3_MASK 8
#define DDB4 4
#define DDB4_BIT 4
#define DDB4_MASK 16
#define DDB5 5
#define DDB5_BIT 5
#define DDB5_MASK 32

sfrb PINB = 0x36;
#define PINB0 0
#define PINB0_BIT 0
#define PINB0_MASK 1
#define PINB1 1
#define PINB1_BIT 1
#define PINB1_MASK 2
#define PINB2 2
#define PINB2_BIT 2
#define PINB2_MASK 4
#define PINB3 3
#define PINB3_BIT 3
#define PINB3_MASK 8
#define PINB4 4
#define PINB4_BIT 4
#define PINB4_MASK 16
#define PINB5 5
#define PINB5_BIT 5
#define PINB5_MASK 32

sfrb PORTC = 0x35;
#define PORTC0 0
#define PORTC0_BIT 0
#define PORTC0_MASK 1
#define PORTC1 1
#define PORTC1_BIT 1
#define PORTC1_MASK 2
#define PORTC2 2
#define PORTC2_BIT 2
#define PORTC2_MASK 4
#define PORTC3 3
#define PORTC3_BIT 3
#define PORTC3_MASK 8
#define PORTC4 4
#define PORTC4_BIT 4
#define PORTC4_MASK 16
#define PORTC5 5
#define PORTC5_BIT 5
#define PORTC5_MASK 32

sfrb DDRC = 0x34;
#define DDC0 0
#define DDC0_BIT 0
#define DDC0_MASK 1
#define DDC1 1
#define DDC1_BIT 1
#define DDC1_MASK 2
#define DDC2 2
#define DDC2_BIT 2
#define DDC2_MASK 4
#define DDC3 3
#define DDC3_BIT 3
#define DDC3_MASK 8
#define DDC4 4
#define DDC4_BIT 4
#define DDC4_MASK 16
#define DDC5 5
#define DDC5_BIT 5
#define DDC5_MASK 32

sfrb PINC = 0x33;
#define PINC0 0
#define PINC0_BIT 0
#define PINC0_MASK 1
#define PINC1 1
#define PINC1_BIT 1
#define PINC1_MASK 2
#define PINC2 2
#define PINC2_BIT 2
#define PINC2_MASK 4
#define PINC3 3
#define PINC3_BIT 3
#define PINC3_MASK 8
#define PINC4 4
#define PINC4_BIT 4
#define PINC4_MASK 16
#define PINC5 5
#define PINC5_BIT 5
#define PINC5_MASK 32

sfrb PORTD = 0x32;
#define PORTD0 0
#define PORTD0_BIT 0
#define PORTD0_MASK 1
#define PORTD1 1
#define PORTD1_BIT 1
#define PORTD1_MASK 2
#define PORTD2 2
#define PORTD2_BIT 2
#define PORTD2_MASK 4
#define PORTD3 3
#define PORTD3_BIT 3
#define PORTD3_MASK 8
#define PORTD4 4
#define PORTD4_BIT 4
#define PORTD4_MASK 16
#define PORTD5 5
#define PORTD5_BIT 5
#define PORTD5_MASK 32
#define PORTD6 6
#define PORTD6_BIT 6
#define PORTD6_MASK 64
#define PORTD7 7
#define PORTD7_BIT 7
#define PORTD7_MASK 128

sfrb DDRD = 0x31;
#define DDD0 0
#define DDD0_BIT 0
#define DDD0_MASK 1
#define DDD1 1
#define DDD1_BIT 1
#define DDD1_MASK 2
#define DDD2 2
#define DDD2_BIT 2
#define DDD2_MASK 4
#define DDD3 3
#define DDD3_BIT 3
#define DDD3_MASK 8
#define DDD4 4
#define DDD4_BIT 4
#define DDD4_MASK 16
#define DDD5 5
#define DDD5_BIT 5
#define DDD5_MASK 32
#define DDD6 6
#define DDD6_BIT 6
#define DDD6_MASK 64
#define DDD7 7
#define DDD7_BIT 7
#define DDD7_MASK 128

sfrb PIND = 0x30;
#define PIND0 0
#define PIND0_BIT 0
#define PIND0_MASK 1
#define PIND1 1
#define PIND1_BIT 1
#define PIND1_MASK 2
#define PIND2 2
#define PIND2_BIT 2
#define PIND2_MASK 4
#define PIND3 3
#define PIND3_BIT 3
#define PIND3_MASK 8
#define PIND4 4
#define PIND4_BIT 4
#define PIND4_MASK 16
#define PIND5 5
#define PIND5_BIT 5
#define PIND5_MASK 32
#define PIND6 6
#define PIND6_BIT 6
#define PIND6_MASK 64
#define PIND7 7
#define PIND7_BIT 7
#define PIND7_MASK 128

sfrb SPDR = 0x2f;
#define SPDR0 0
#define SPDR0_BIT 0
#define SPDR0_MASK 1
#define SPDR1 1
#define SPDR1_BIT 1
#define SPDR1_MASK 2
#define SPDR2 2
#define SPDR2_BIT 2
#define SPDR2_MASK 4
#define SPDR3 3
#define SPDR3_BIT 3
#define SPDR3_MASK 8
#define SPDR4 4
#define SPDR4_BIT 4
#define SPDR4_MASK 16
#define SPDR5 5
#define SPDR5_BIT 5
#define SPDR5_MASK 32
#define SPDR6 6
#define SPDR6_BIT 6
#define SPDR6_MASK 64
#define SPDR7 7
#define SPDR7_BIT 7
#define SPDR7_MASK 128

sfrb SPSR = 0x2e;
#define WCOL 6
#define WCOL_BIT 6
#define WCOL_MASK 64
#define SPIF 7
#define SPIF_BIT 7
#define SPIF_MASK 128

sfrb SPCR = 0x2d;
#define SPR0 0
#define SPR0_BIT 0
#define SPR0_MASK 1
#define SPR1 1
#define SPR1_BIT 1
#define SPR1_MASK 2
#define CPHA 2
#define CPHA_BIT 2
#define CPHA_MASK 4
#define CPOL 3
#define CPOL_BIT 3
#define CPOL_MASK 8
#define MSTR 4
#define MSTR_BIT 4
#define MSTR_MASK 16
#define DORD 5
#define DORD_BIT 5
#define DORD_MASK 32
#define SPE 6
#define SPE_BIT 6
#define SPE_MASK 64
#define SPIE 7
#define SPIE_BIT 7
#define SPIE_MASK 128

sfrb UDR = 0x2c;
#define UDR0 0
#define UDR0_BIT 0
#define UDR0_MASK 1
#define UDR1 1
#define UDR1_BIT 1
#define UDR1_MASK 2
#define UDR2 2
#define UDR2_BIT 2
#define UDR2_MASK 4
#define UDR3 3
#define UDR3_BIT 3
#define UDR3_MASK 8
#define UDR4 4
#define UDR4_BIT 4
#define UDR4_MASK 16
#define UDR5 5
#define UDR5_BIT 5
#define UDR5_MASK 32
#define UDR6 6
#define UDR6_BIT 6
#define UDR6_MASK 64
#define UDR7 7
#define UDR7_BIT 7
#define UDR7_MASK 128

sfrb UCSRA = 0x2b;
#define MPCM 0
#define MPCM_BIT 0
#define MPCM_MASK 1
#define OR 3
#define OR_BIT 3
#define OR_MASK 8
#define FE 4
#define FE_BIT 4
#define FE_MASK 16
#define UDRE 5
#define UDRE_BIT 5
#define UDRE_MASK 32
#define TXC 6
#define TXC_BIT 6
#define TXC_MASK 64
#define RXC 7
#define RXC_BIT 7
#define RXC_MASK 128

sfrb UCSRB = 0x2a;
#define TXB8 0
#define TXB8_BIT 0
#define TXB8_MASK 1
#define RXB8 1
#define RXB8_BIT 1
#define RXB8_MASK 2
#define CHR9 2
#define CHR9_BIT 2
#define CHR9_MASK 4
#define TXEN 3
#define TXEN_BIT 3
#define TXEN_MASK 8
#define RXEN 4
#define RXEN_BIT 4
#define RXEN_MASK 16
#define UDRIE 5
#define UDRIE_BIT 5
#define UDRIE_MASK 32
#define TXCIE 6
#define TXCIE_BIT 6
#define TXCIE_MASK 64
#define RXCIE 7
#define RXCIE_BIT 7
#define RXCIE_MASK 128

sfrb UBRR = 0x29;
#define UBRR0 0
#define UBRR0_BIT 0
#define UBRR0_MASK 1
#define UBRR1 1
#define UBRR1_BIT 1
#define UBRR1_MASK 2
#define UBRR2 2
#define UBRR2_BIT 2
#define UBRR2_MASK 4
#define UBRR3 3
#define UBRR3_BIT 3
#define UBRR3_MASK 8
#define UBRR4 4
#define UBRR4_BIT 4
#define UBRR4_MASK 16
#define UBRR5 5
#define UBRR5_BIT 5
#define UBRR5_MASK 32
#define UBRR6 6
#define UBRR6_BIT 6
#define UBRR6_MASK 64
#define UBRR7 7
#define UBRR7_BIT 7
#define UBRR7_MASK 128

sfrb ACSR = 0x28;
#define ACIS0 0
#define ACIS0_BIT 0
#define ACIS0_MASK 1
#define ACIS1 1
#define ACIS1_BIT 1
#define ACIS1_MASK 2
#define ACIC 2
#define ACIC_BIT 2
#define ACIC_MASK 4
#define ACIE 3
#define ACIE_BIT 3
#define ACIE_MASK 8
#define ACI 4
#define ACI_BIT 4
#define ACI_MASK 16
#define ACO 5
#define ACO_BIT 5
#define ACO_MASK 32
#define AINBG 6
#define AINBG_BIT 6
#define AINBG_MASK 64
#define ACD 7
#define ACD_BIT 7
#define ACD_MASK 128

sfrb ADMUX = 0x27;
#define MUX0 0
#define MUX0_BIT 0
#define MUX0_MASK 1
#define MUX1 1
#define MUX1_BIT 1
#define MUX1_MASK 2
#define MUX2 2
#define MUX2_BIT 2
#define MUX2_MASK 4
#define ADCBG 6
#define ADCBG_BIT 6
#define ADCBG_MASK 64

sfrb ADCSR = 0x26;
#define ADPS0 0
#define ADPS0_BIT 0
#define ADPS0_MASK 1
#define ADPS1 1
#define ADPS1_BIT 1
#define ADPS1_MASK 2
#define ADPS2 2
#define ADPS2_BIT 2
#define ADPS2_MASK 4
#define ADIE 3
#define ADIE_BIT 3
#define ADIE_MASK 8
#define ADIF 4
#define ADIF_BIT 4
#define ADIF_MASK 16
#define ADFR 5
#define ADFR_BIT 5
#define ADFR_MASK 32
#define ADSC 6
#define ADSC_BIT 6
#define ADSC_MASK 64
#define ADEN 7
#define ADEN_BIT 7
#define ADEN_MASK 128

sfrb ADCH = 0x25;
#define ADC8 0
#define ADC8_BIT 0
#define ADC8_MASK 1
#define ADC9 1
#define ADC9_BIT 1
#define ADC9_MASK 2

sfrb ADCL = 0x24;
#define ADC0 0
#define ADC0_BIT 0
#define ADC0_MASK 1
#define ADC1 1
#define ADC1_BIT 1
#define ADC1_MASK 2
#define ADC2 2
#define ADC2_BIT 2
#define ADC2_MASK 4
#define ADC3 3
#define ADC3_BIT 3
#define ADC3_MASK 8
#define ADC4 4
#define ADC4_BIT 4
#define ADC4_MASK 16
#define ADC5 5
#define ADC5_BIT 5
#define ADC5_MASK 32
#define ADC6 6
#define ADC6_BIT 6
#define ADC6_MASK 64
#define ADC7 7
#define ADC7_BIT 7
#define ADC7_MASK 128

sfrw ADCW = 0x24;

sfrb UBRRHI = 0x23;
#define UBRRHI0 0
#define UBRRHI0_BIT 0
#define UBRRHI0_MASK 1
#define UBRRHI1 1
#define UBRRHI1_BIT 1
#define UBRRHI1_MASK 2
#define UBRRHI2 2
#define UBRRHI2_BIT 2
#define UBRRHI2_MASK 4
#define UBRRHI3 3
#define UBRRHI3_BIT 3
#define UBRRHI3_MASK 8

#endif
