function getState(state)
{
  if (state == 0x00)
    return "runnable";
  if (state == 0x1)
    return "timer wait";
  var stateStr;
  if ((state & 0x30) == 0x30)
    stateStr = "message queue receive";  
  else if ((state & 0x20) == 0x20)
    stateStr = "message queue post";  
  else if ((state & 0x10) == 0x10)
    stateStr = "semaphore";
  else if ((state & 0x04)==0x04)     
    stateStr = "event any";     
  else if ((state & 0x02)==0x02)
    stateStr = "event all";
  else
    return "invalid";
  if ((state & 0x01) == 0x01)      
    stateStr += "& timer wait";
  else
    stateStr += " wait";
  return stateStr;
}

function getregs(sp)
{
  var a = new Array();
  a[36] = (Debug.evaluate("*(unsigned char*)0x"+sp.toString(16)) & 0xff)<<8; // sph
  sp += 1;
  a[36] += Debug.evaluate("*(unsigned char*)0x"+sp.toString(16)) & 0xff; // spl
  sp += 1;
  a[37] = Debug.evaluate("*(unsigned char *)0x"+sp.toString(16)); // sreg
  sp += 1;
  for (i=0;i<28;i++) // r0-r27
    {
      a[i] = Debug.evaluate("*(unsigned char *)0x"+sp.toString(16)); 
      sp += 1;
    }
  a[30] = Debug.evaluate("*(unsigned char *)0x"+sp.toString(16)); // r30
  sp += 1;
  a[31] = Debug.evaluate("*(unsigned char *)0x"+sp.toString(16)); // r31
  sp += 1;
  a[28] = sp & 0xff;
  a[29] = (sp >> 8) & 0xff;
  a[32] = a[26] + (a[27]<<8); // X
  a[33] = sp; // Y
  a[34] = a[30] + (a[31]<<8); // Z
  if (1) // two byte PC
    {
      a[35] = (Debug.evaluate("*(unsigned char *)0x"+(a[36]+1).toString(16)) & 0xff)<<8; // PC High
      a[35] += Debug.evaluate("*(unsigned char *)0x"+(a[36]+2).toString(16)) & 0xff; // PC Low
      a[35] = a[35]<<1; // byte address
      a[36] += 2; // SP is now at the point of call
    }
  else // three byte PC
    {
      a[35] = (Debug.evaluate("*(unsigned char *)0x"+(a[36]+1).toString(16)) & 0xff)<<16; // PC High
      a[35] += (Debug.evaluate("*(unsigned char *)0x"+(a[36]+2).toString(16)) & 0xff)<<8; // PC Middle
      a[35] += Debug.evaluate("*(unsigned char *)0x"+(a[36]+3).toString(16)) & 0xff; // PC Low
      a[35] = a[35]<<1; // byte address
      a[36] += 3; // SP is now at the point of call
    }
  return a;
}

function update() 
{
  Threads.clear();
  x=Debug.evaluate("ctl_task_executing");
  if (x)
    {
      Threads.newqueue("Executing");
      x = Debug.evaluate("*(CTL_TASK_t*)"+x);
      Threads.add(x.name, x.priority, "executing", null);
    }
  x=Debug.evaluate("ctl_task_list");
  if (x)
    Threads.newqueue("Waiting");
  count=0;
  while (x && count<10)
    {
      count++;
      x = Debug.evaluate("*(CTL_TASK_t*)"+x);
      state = getState(x.state);
      Threads.add(x.name, x.priority, state, getregs(x.stack_pointer));
      x=x.next;
    }
}