// CrossWorks Tasking Library.
//
// Copyright (c) 2004 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#include <../libc/__libc.h>
#include "ctl_api.h"

CTL_EVENT_SET_t ctl_libc_mutex = CTL_LIBC_MUTEX_HEAP | CTL_LIBC_MUTEX_PRINTF | CTL_LIBC_MUTEX_SCANF | CTL_LIBC_MUTEX_DEBUG_IO;

int 
*__errno(void)
{
  return &(ctl_task_executing->errno);
}

void 
__heap_lock(void)
{
  ctl_events_wait(CTL_EVENT_WAIT_ANY_EVENTS_WITH_AUTO_CLEAR, &ctl_libc_mutex, CTL_LIBC_MUTEX_HEAP, 0, 0);
}

void 
__heap_unlock(void)
{
  ctl_events_set_clear(&ctl_libc_mutex, CTL_LIBC_MUTEX_HEAP, 0);
}

void 
__printf_lock(void)
{
  ctl_events_wait(CTL_EVENT_WAIT_ANY_EVENTS_WITH_AUTO_CLEAR, &ctl_libc_mutex, CTL_LIBC_MUTEX_PRINTF, 0, 0);
}

void 
__printf_unlock(void)
{
  ctl_events_set_clear(&ctl_libc_mutex, CTL_LIBC_MUTEX_PRINTF, 0);
}

void 
__scanf_lock(void)
{
  ctl_events_wait(CTL_EVENT_WAIT_ANY_EVENTS_WITH_AUTO_CLEAR, &ctl_libc_mutex, CTL_LIBC_MUTEX_SCANF, 0, 0);
}

void 
__scanf_unlock(void)
{
  ctl_events_set_clear(&ctl_libc_mutex, CTL_LIBC_MUTEX_SCANF, 0);
}

void 
__debug_io_lock(void)
{
  ctl_events_wait(CTL_EVENT_WAIT_ANY_EVENTS_WITH_AUTO_CLEAR, &ctl_libc_mutex, CTL_LIBC_MUTEX_DEBUG_IO, 0, 0);
}

void 
__debug_io_unlock(void)
{
  ctl_events_set_clear(&ctl_libc_mutex, CTL_LIBC_MUTEX_DEBUG_IO, 0);
}
