/*****************************************************************************
 * This file provides a workaround for the "relocation truncated to fit:     *
 * R_ARM_THM_PC22 _call_via..." ld linker error that is caused when you      *
 * have THUMB functions in sections further away from the .text section than *
 * +/- 4MBytes that make calls to external functions.                        *
 *                                                                           *
 * To use:  Include this header file in modules that generate the error      *
 *          message and include DEFINE_CALL_VIA(register_name, section_name) *
 *          in the code for each register that generates the error.          *
 *                                                                           *
 * Example: DEFINE_CALL_VIA(r3, .text)                                       *
 *                                                                           *
 *****************************************************************************
 * Copyright (c) 2005 Rowley Associates Limited.                             *
 *                                                                           *
 * This file may be distributed under the terms of the License Agreement     *
 * provided with this software.                                              *
 *                                                                           *
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE   *
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. *
 *****************************************************************************/

#ifndef call_via_fix_h
#define call_via_fix_h

#define DEFINE_CALL_VIA(register_name, section_name) \
static void _call_via_##register_name(void) __attribute__((naked)) __attribute__((section(#section_name))); \
static void _call_via_##register_name(void) \
{ \
  asm("bx " #register_name); \
  asm("nop"); \
}

#endif

