// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////////////
//
//                  Generic LED Example
//
// Description
// -----------
// This example flashes LED's 
// 
////////////////////////////////////////////////////////////////////////////////

#include <ctl_api.h>

void 
delay(volatile unsigned int d);

static void 
cycle(int n)
{
  int m = 0;
  for (; n; m++, n--)
    {
      ctl_board_set_leds(1);
      delay(m);
      ctl_board_set_leds(0);
      delay(n);
    }

  for (; m; m--, n++)
    {
      ctl_board_set_leds(1);
      delay(m);      
      ctl_board_set_leds(0);
      delay(n);
    }
}

int
main(void)
{
  ctl_board_init();
  
  while (1)
    {
      cycle(500);
      cycle(800);
      delay(300000);
    }      
          
  return 0;    
}


