// Copyright (c) 2005 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
////////////////////////////////////////////////////////////////////////////////
//
//                          Generic Interrupt Example
//
// Description
// -----------
// This example demonstrates a simple interrupt handler. 
//
////////////////////////////////////////////////////////////////////////////////

#include <ctl_api.h>

static volatile int count;

void
buttonPressed(void)
{  
  if (++count & 1)
    ctl_board_set_leds(1);
  else
    ctl_board_set_leds(0);  
}

int
main(int argc, const char *argv[])
{
  unsigned int v = 0;

  ctl_board_init();
  ctl_board_on_button_pressed(buttonPressed);
  ctl_global_interrupts_enable();

  while(1)
    v++;
  
  return 0;
}



