// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002, 2003 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __math_h
#define __math_h

#define FP_ZERO      0x00
#define FP_SUBNORMAL 0x01
#define FP_NORMAL    0x02
#define FP_INFINITE  0x03
#define FP_NAN       0x04

#ifndef __ASSEMBLY_INCLUDE

#ifdef __cplusplus
extern "C" {
#endif

#if defined(__CROSSWORKS_AVR) || defined(__CROSSWORKS_MSP430) || defined(__CROSSWORKS_MAXQ)

#define HUGE_VAL __maxof(double)
#define HUGE_VALF __maxof(float)
#define INFINITY __infinityof(float)

#else

extern const float __float32_infinity;

#ifndef __SHORT_DOUBLES
extern const double __float64_infinity;
#endif

#define INFINITY __float32_infinity

#ifdef __SHORT_DOUBLES
#define HUGE_VAL __float32_infinity
#else
#define HUGE_VAL __float64_infinity
#endif
#define HUGE_VALF __float32_infinity

#endif

// Type-generic macros
#define isinf(x) (sizeof(x) == sizeof(float) ? __float32_isinf(x) : __float64_isinf(x))
#define isnan(x) (sizeof(x) == sizeof(float) ? __float32_isnan(x) : __float64_isnan(x))
#define isfinite(x) (sizeof(x) == sizeof(float) ? __float32_isfinite(x) : __float64_isfinite(x))
#define isnormal(x) (sizeof(x) == sizeof(float) ? __float32_isnormal(x) : __float64_isnormal(x))
#define signbit(x) (sizeof(x) == sizeof(float) ? __float32_signbit(x) : __float64_signbitf(x))
#define fpclassify(x) (sizeof(x) == sizeof(float) ? __float32_classify(x) : __float64_classify(x))

typedef float float_t;
typedef double double_t;

float acosf(float);
double acos(double);

float asinf(float);
double asin(double);

float atanf(float);
double atan(double);

float atan2f(float, float);
double atan2(double, double);

float cosf(float);
double cos(double);

float sinf(float);
double sin(double);

float tanf(float);
double tan(double);

float coshf(float);
double cosh(double);

float sinhf(float);
double sinh(double);

float tanhf(float);
double tanh(double);

float expf(float);
double exp(double);

float frexpf(float, int *);
double frexp(double, int *);

float ldexpf(float, int);
double ldexp(double, int);

float scalbnf(float, int);
double scalbn(double, int);

float logf(float);
double log(double);

float log10f(float);
double log10(double);

float fmodf(float, float);
double fmod(double, double);

float modff(float, float *);
double modf(double, double *);

float powf(float, float);
double pow(double, double);

float sqrtf(float);
double sqrt(double);

float ceilf(float);
double ceil(double);

float fabsf(float);
double fabs(double);

float fminf(float, float);
double fmin(double, double);

float fmaxf(float, float);
double fmax(double, double);

float floorf(float);
double floor(double);

float hypotf(float, float);
double hypot(double, double);

float acoshf(float);
double acosh(double);

float asinhf(float);
double asinh(double);

float atanhf(float);
double atanh(double);

/* \brief Private functions. */
int __float32_isinf(float);
int __float64_isinf(double);
int __float32_isnan(float);
int __float64_isnan(double);
int __float32_isfinite(float);
int __float64_isfinite(double);
int __float32_isnormal(float);
int __float64_isnormal(double);
int __float32_signbit(float);
int __float64_signbit(double);
int __float32_classify(float);
int __float64_classify(double);

#ifdef __cplusplus
}
#endif

#endif

#endif
