// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __float_h
#define __float_h

// Fast floating-point math library rounds to nearest
#define FLT_ROUNDS 1

// Float arithmetic implemented in float precision
#define FLT_EVAL_METHOD 0

#define FLT_RADIX                 2
#define DECIMAL_DIG              17
#define FLT_MANT_DIG             24
#define FLT_EPSILON 1.19209290E-07F // decimal constant
#define FLT_DIG                   6
#define FLT_MIN_EXP            -125
#define FLT_MIN     1.17549435E-38F
#define FLT_MIN_10_EXP          -37
#define FLT_MAX_EXP            +128
#define FLT_MAX     3.40282347E+38F
#define FLT_MAX_10_EXP          +38

#ifdef __SHORT_DOUBLES

// double is 32-bit IEC 60559
#define DBL_MANT_DIG             24
#define DBL_EPSILON 1.19209290E-07F
#define DBL_DIG                   6
#define DBL_MIN_EXP            -125
#define DBL_MIN     1.17549435E-38F
#define DBL_MIN_10_EXP          -37
#define DBL_MAX_EXP            +128
#define DBL_MAX     3.40282347E+38F
#define DBL_MAX_10_EXP          +38

#else

// double is 64-bit IEC 60559
#define DBL_MANT_DIG                    53
#define DBL_EPSILON 2.2204460492503131E-16
#define DBL_DIG                         15
#define DBL_MIN_EXP                  -1021
#define DBL_MIN    2.2250738585072014E-308
#define DBL_MIN_10_EXP                -307
#define DBL_MAX_EXP                  +1024
#define DBL_MAX    1.7976931348623157E+308
#define DBL_MAX_10_EXP                +308

#endif

#endif
