// Rowley C Compiler, runtime support.
//
// Copyright (c) 2001, 2002, 2007 Rowley Associates Limited.
//
// This file may be distributed under the terms of the License Agreement
// provided with this software.
//
// THIS FILE IS PROVIDED AS IS WITH NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

#ifndef __cross_studio_io_H
#define __cross_studio_io_H

#include "__crossworks.h"

#ifdef __cplusplus
extern "C" {
#endif

#define DEBUG_FILE void 
#define DEBUG_SEEK_CUR 1
#define DEBUG_SEEK_END 2
#define DEBUG_SEEK_SET 0

#define DEBUG_STDIN ((DEBUG_FILE *)0)
#define DEBUG_STDOUT ((DEBUG_FILE *)1)
#define DEBUG_STDERR ((DEBUG_FILE *)2)
                         
DEBUG_FILE *debug_fopen(const char *, const char *); 
int debug_fflush(DEBUG_FILE *);
void debug_fclose(DEBUG_FILE *);

int debug_fprintf(DEBUG_FILE *, const char *, ...);
int debug_printf(const char *, ...);  

int debug_fscanf(DEBUG_FILE *, const char *, ...);
int debug_scanf(const char *, ...);  

int debug_getchar(void);
char *debug_gets(char *s);    
int debug_geti(int *);
int debug_getu(unsigned *);
int debug_getl(long *);
int debug_getul(unsigned long *);
int debug_getf(float *);
int debug_getd(double *);
int debug_getll(long long *);
int debug_getull(unsigned long long *);
   
int debug_fgetc(DEBUG_FILE *);

char *debug_fgets(char *, int, DEBUG_FILE *);
int debug_fputc(int, DEBUG_FILE *);                        
int debug_fputs(const char *, DEBUG_FILE *);
int debug_putchar(int);
int debug_puts(const char *);

int debug_fread(void *, int, int, DEBUG_FILE *);
int debug_fwrite(void *, int, int, DEBUG_FILE *);

int debug_fseek(DEBUG_FILE *, long, int);
long debug_ftell(DEBUG_FILE *);
void debug_rewind(DEBUG_FILE *);
int debug_filesize(DEBUG_FILE *);

void debug_clearerr(DEBUG_FILE *);
int debug_feof(DEBUG_FILE *);
int debug_ferror(DEBUG_FILE *);

int debug_kbhit(void);
int debug_getch(void);

int debug_ioctl(int, int);

void debug_runtime_error(const char *);

void debug_break(void);
void debug_exit(int);
unsigned long debug_time(unsigned long *);

#if defined(__CROSSWORKS_AVR) || defined(__CROSSWORKS_MAXQ)
int debug_fprintf_c(DEBUG_FILE *, __code const char *, ...);
int debug_printf_c(__code const char *, ...);  

int debug_fscanf_c(DEBUG_FILE *, __code const char *, ...);
int debug_scanf_c(__code const char *, ...);  
#endif

int debug_vfprintf(DEBUG_FILE *, const char *, __va_list);
int debug_vprintf(const char *, __va_list);
int debug_vfscanf(DEBUG_FILE *, const char *, __va_list);
int debug_vscanf(const char *, __va_list);
int debug_ungetc(int, DEBUG_FILE *);
int debug_fgetpos(DEBUG_FILE *, long *);
int debug_fsetpos(DEBUG_FILE *, const long *);
DEBUG_FILE *debug_freopen(const char *, const char *, DEBUG_FILE *);
void debug_perror(const char *);
int debug_remove(const char *);
int debug_rename(const char *, const char *);
DEBUG_FILE *debug_tmpfile(void);
char *debug_tmpnam(char *);
char *debug_getenv(char *);
int debug_system(char *);
int debug_getargs(unsigned, unsigned char *);

#ifdef __cplusplus
}
#endif

#endif

